#include "tftp.h"
#include "tftpglob.h"

#include <string.h>
#include <memory.h>

unsigned char SendPacket[600] ;

char *FilesList[] = {
	"CONFIG.INI",
	"MTROUTER.BIN",
	"BOOT.CFG",
	"USER.DTB",
	"SCRIPT.HDR",
	"PORT1.FIL",
	"PORT2.FIL",
	"PORT3.FIL",
#if PROXY_SERVER
	"PORTSTAT.ONL",
#endif
	"HUPANDREDIAL",
	""
} ;


/*---------------------------------------------------------------------------
Function	: SendDataPacket
Synopsis	: sends a packet.
Input 	: Destination IP address
           Destination port
			  socket to send data on
			  Pointer to the information to be sent
			  No. of bytes to be sent
Output	: SUCCESS on success else FAILURE
---------------------------------------------------------------------------*/
enum BOOLEAN SendDataPacket(u_long DestinationIPAddress, int DestinationPort,
                   int Socket, unsigned char *Info, u_long Length)
{
	struct sockaddr_in Destination ;
	int ReturnValue ;

	memset(&Destination, 0, sizeof(struct sockaddr_in)) ;
	Destination.sin_family = AF_INET ;
	Destination.sin_port = DestinationPort ;
	Destination.sin_addr.S_un.S_addr = DestinationIPAddress ;

	ReturnValue = Dsendto(Socket, (char far *)Info, (int)Length, 0,
	       (struct sockaddr far *)&Destination, (int)sizeof(struct sockaddr_in)) ;

	if (ReturnValue)
		return SUCCESS ;
	return FAILURE ;
}


/*---------------------------------------------------------------------------
Function	: ReceiveData
Synopsis	: reads a packet.
Input 	: Destination IP address
           Destination port
			  socket to send data on
			  Pointer to the information to be sent
			  No. of bytes to be sent
Output	: SUCCESS on success else FAILURE
---------------------------------------------------------------------------*/
enum BOOLEAN ReceiveData(u_long *SourceIPAddress, int *SourcePort, int Socket,
                unsigned char *Packet, int *PacketLength)
{
	int AddLen = sizeof(struct sockaddr), ReturnCode ;
	struct sockaddr_in ClientAddress ;

	ReturnCode = Drecvfrom(Socket, Packet, 1000, 0,
	                      (struct sockaddr far *)&ClientAddress, &AddLen) ;
	if (ReturnCode != -1)
	{
		*PacketLength = ReturnCode ;
		*SourceIPAddress = (ClientAddress.sin_addr.S_un.S_addr) ;
		*SourcePort = (ClientAddress.sin_port) ;
		return SUCCESS ;
	}
	*PacketLength = 0 ;
	return FAILURE ;
}


/*---------------------------------------------------------------------------
Function	: SendAckPacket
Synopsis	: sends an ack packet.
Input 	: Destination IP address
           Destination port
			  socket to send data on
			  sequence number of the packet that is to be ack.ed
Output	: SUCCESS on success else FAILURE
---------------------------------------------------------------------------*/
enum BOOLEAN SendAckPacket(u_long DestinationIPAddress, int DestinationPort,
                    int Socket, u_long SequenceNumber)
{
	struct sockaddr_in Destination ;
	int ReturnValue ;

	memset(&Destination, 0, sizeof(struct sockaddr_in)) ;
	Destination.sin_family = AF_INET ;
	Destination.sin_port = DestinationPort ;
	Destination.sin_addr.S_un.S_addr = DestinationIPAddress ;

	((TFTPPacketType *)SendPacket)->OpCode = Dhtons(OPCODE_ACK) ;
	((TFTPPacketType *)SendPacket)->MessageType.Ack.AckedBlockNumber = Dhtons((u_short)SequenceNumber) ;

	ReturnValue = Dsendto(Socket, SendPacket, 2+2, 0,
	       (struct sockaddr far *)&Destination, sizeof(struct sockaddr_in)) ;

	if (ReturnValue)
		return SUCCESS ;
	return FAILURE ;
}



/*---------------------------------------------------------------------------
Function	: SendErrorPacket
Synopsis	: sends an error packet. The destination and the info. to be sent is
        	  present in ErrorBlock
Input 	: ErrorBlock
Output	: SUCCESS on success else FAILURE
---------------------------------------------------------------------------*/
enum BOOLEAN SendErrorPacket(u_long DestinationIPAddress, int DestinationPort,
                    int Socket, unsigned char *ErrorMessage, u_short ErrorCode)
{
	struct sockaddr_in Destination ;
	int ReturnValue ;

	memset(&Destination, 0, sizeof(struct sockaddr_in)) ;
	Destination.sin_family = AF_INET ;
	Destination.sin_port = DestinationPort ;
	Destination.sin_addr.S_un.S_addr = DestinationIPAddress ;

	((TFTPPacketType *)SendPacket)->OpCode = Dhtons(OPCODE_ERR) ;
	((TFTPPacketType *)SendPacket)->MessageType.Error.ErrorNumber = Dhtons(ErrorCode) ;
	strcpy(((TFTPPacketType *)SendPacket)->MessageType.Error.ErrorMessage, ErrorMessage) ;

	ReturnValue = Dsendto(Socket, SendPacket, 2+2+1+strlen(ErrorMessage), 0,
	       (struct sockaddr far *)&Destination, sizeof(struct sockaddr_in)) ;

	if (ReturnValue)
		return SUCCESS ;
	return FAILURE ;
}


enum BOOLEAN MakeFileOpenRequest (enum OPCODE OpCode, u_long DestinationIPAddress, 
			int DestinationPort, int Socket, char *FileName, char *Mode)
{
	char FileOpenPacket[100] ;
	TFTPPacketType *TFTPPacket = (TFTPPacketType *)FileOpenPacket ;

	TFTPPacket->OpCode = Dhtons (OpCode) ;
	strcpy(TFTPPacket->MessageType.FileOpenReq.FileName, FileName) ;
	((char *)TFTPPacket) += strlen(FileName) + 1 ;
	strcpy(TFTPPacket->MessageType.FileOpenReq.FileName, Mode) ;

	if (SendDataPacket(DestinationIPAddress, Dhtons(DestinationPort), Socket, FileOpenPacket,
	                   strlen(FileName)+strlen(Mode)+2+2) == FAILURE)
		return (FAILURE) ;
	return (SUCCESS) ;
}

#if 0
int MyStrnCmpi (char *Source, char *Destination, int Count)
{
	int i ;
	char SrcChar, DestChar ;

	for (i = 0 ; i < Count ; i++)
	{
		SrcChar = Source[i] ;
		DestChar = Destination[i] ;
		
		if ((SrcChar <= 'z') && (SrcChar >= 'a'))
			SrcChar += ('A' - 'a') ;
		if ((DestChar <= 'z') && (DestChar >= 'a'))
			DestChar += ('A' - 'a') ;

		if (DestChar != SrcChar)
			return (DestChar - SrcChar) ;

		if (DestChar == 0)
			return 0 ;
	}
	return 0 ;
}
#endif

void FixFileType (char *FileName)
{
#if 0
	if (MyStrnCmpi (FileName, "MTROUTER.BIN", 12) == 0)
		FileType = FILE_TYPE_CODE ; /* Code */
	else
      if (MyStrnCmpi (FileName, "CONFIG.INI", 10) == 0)
		   FileType = FILE_TYPE_CONFIG ; /* Config */
      else
			if (MyStrnCmpi (FileName, "BOOT.CFG", 8) == 0)
				FileType = FILE_TYPE_BOOT_CONFIG ;
			else
				if (MyStrnCmpi (FileName, "USER.DTB", 8) == 0)
					FileType = FILE_TYPE_USER_DATABASE ;
				else
     	    		FileType = FILE_TYPE_UNKNOWN ;
#endif

	int index = 0 ;

	FileType = FILE_TYPE_UNKNOWN ;	
	strupr (FileName);
	while (*FilesList[index])
	{		
		if (strstr (FileName, FilesList[index]))
		{
			FileType = index ;
			break ;
		}
		index ++ ;
	}
	return ;
}
