// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	WANDLG.CPP
// Description       :	Defines Classes :
//									CWANDlg		: Function of WAN Dialog
//									CWanPortDlg	: Function of WAN Port Tabs
//									CWanTab		: Function of WAN Port TabDialog
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :  2/11/95 Vidy added LSL speed updation for SNMP
// Modifications     :  2/11/95 Vidy fixed LSL speed updation 
// -------------------------------------------------------------------------
// Vidy 05/12/96		: if only one wan don't show WAN 1

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include <stdio.h>
#include "stdafx.h"
#include "procon.h"
#include "isdnta.h"
#include "wandlg.h"
#include "tabdlg.h"
#include "maindlg.h"
#include "modem.h"
#include "script.h"
#include "hardware.h"
#include "maskdot.h"
#include <ctype.h>
					

// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------


LPCSTR DefaultConfigHeader = "Default Configs";
LPCSTR DefaultIniString = "Config1";
char TempSection[40];

LPCSTR IsdnMsgHeader = "ProxyServer Setup - Isdn Configuration" ;

//Sudha 9 Dec 1997
char WanPortNum[12];
int m_cfgtype = 0;
LPCSTR MapHeader = "Port Mappings";
int bAGEnable = 0 ; /* sudha 13 nov 1998 */
         
LPCSTR WANMsgHeader = "MultiRouter Setup - WAN" ;
LPCSTR WANSectionHeader = "WAN Serial Device Driver" ;
LPCSTR ScriptSectionHeader = "Script Section" ;

static BOOL RouterStatus = FALSE ;
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


// Sudha 13 Feb 1998 
LPCSTR GetPriStr(LPCSTR strLHS)
{
   char strRHS[50];
   GetPrivateProfileString ( WANSectionHeader, strLHS,
         StrNull,strRHS,sizeof(strRHS),IniInWinForm );
   return strRHS;
}

// Sudha 13 Feb 1998 
void ReadISDNInfoFromRouconIniToIsdntaIni(int PortIndex)
{
   char strLHS[50],strRHS[50],ConfigName[50];
   int UsType = 0;
   int index = 0;

   sprintf ( strLHS,"ISDN WAN Port%d",PortIndex );
   strcpy ( strRHS,GetPriStr(strLHS));

   if ( strcmp ( strRHS,StrDisabled ) == 0)
   	return;

   sprintf ( strLHS,"ISDN WAN Port%d ConfigName",PortIndex);
   strcpy(ConfigName,GetPriStr(strLHS));
   if ( strcmp ( ConfigName,StrNull ) == 0 )
      return;

   sprintf ( strLHS,"ISDN Port%d Initialization String1",PortIndex);
   strcpy(strRHS,GetPriStr(strLHS));
   if ( strcmp ( strRHS,StrNull ) == 0 )
         return;

   switch ( strRHS[6] )
   {
      case '0' :
      case '1' :
      case '5' :
         UsType = 1;
         break;
      case '2' :
      case '3' :
      case '4' :
      case '6' :
         UsType = 0;
         break;
   }
   if ( UsType == 1 )
   {
      strLHS[32]++;
      strcpy(strRHS,GetPriStr(strLHS));
      if (strcmp ( strRHS,StrNull))
         WritePrivateProfileString ( ConfigName,"DataSPID",&strRHS[6],ini_INIFilename );
      strLHS[32]++;
      strcpy(strRHS,GetPriStr(strLHS));
      if (strcmp ( strRHS,StrNull))
         WritePrivateProfileString ( ConfigName,"VoiceSPID",&strRHS[7],ini_INIFilename );
      strLHS[32]++;
      strcpy(strRHS,GetPriStr(strLHS));
      if (strcmp ( strRHS,StrNull))
         WritePrivateProfileString ( ConfigName,"DataDirectoryNumber",&strRHS[6],ini_INIFilename );
      strLHS[32]++;
      strcpy(strRHS,GetPriStr(strLHS));
      if (strcmp ( strRHS,StrNull))
         WritePrivateProfileString ( ConfigName,"VoiceDirectoryNumber",&strRHS[7],ini_INIFilename );
   }
	else 
	{
	   strLHS[32]+=3;
   	strcpy(strRHS,GetPriStr(strLHS));
	   if (strcmp ( strRHS,StrNull))
   	   WritePrivateProfileString ( ConfigName,"DataMSN", &strRHS[6], ini_INIFilename );
	   strLHS[32]++;
   	strcpy(strRHS,GetPriStr(strLHS));
	   if (strcmp ( strRHS,StrNull))
   	   WritePrivateProfileString ( ConfigName,"VoiceMSN",&strRHS[7],ini_INIFilename );
	}
	return;
}

//Sudha 10 Feb 1998 
BOOL IsSPIDorISDN ( const char *command )
{
   if ((!strcmp(command,"!C6=")) || (!strcmp(command,"*!C6=")))
      return TRUE;
   if ((!strcmp(command,"!N1=")) || (!strcmp(command,"*!N1=")))
      return TRUE;
   else
      return FALSE; 
}

/////////////////////////////////////////////////////////////////////////////
// CWANDlg dialog


CWANDlg::CWANDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWANDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWANDlg)
	m_WANEnable = TRUE;
	m_Printf = FALSE;
	m_PrintfRx = FALSE;
	m_PrintfTx = FALSE;
	m_PrintfInitialize = FALSE;
	m_bNonCriticalScriptPrintf = FALSE;
	m_bAlarmScriptPrintf = FALSE;
	m_szPPINISection = "";
	m_modem_type = "";
	//}}AFX_DATA_INIT

	m_bMdmConfigChanged = FALSE;
	m_nSelectedModem = CB_ERR ;
	m_nSelectedIsdn = CB_ERR ;
	IsdnEnabled = FALSE;
	Create(IDD,NULL);
}

void CWANDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWANDlg)
	DDX_Control(pDX, IDC_STATIC_ISDN_CONFIG_TYPES, m_ctrl_static_isdn_config_types);
	DDX_Control(pDX, IDC_STATIC_ISDN_CONTROL, m_IsdnCtrlWnd);
	DDX_Control(pDX, IDC_ISDN_EDIT, m_EditConfig);
	DDX_Control(pDX, IDC_ISDN_DELETE, m_DeleteConfig);
	DDX_Control(pDX, IDC_ISDN_ADD, m_AddConfig);
	DDX_Control(pDX, IDC_EXISTING_CFGS, m_INISectionControl);
	DDX_Control(pDX, IDC_CHECK_NON_CRITICAL, m_ChkBoxScriptNonCritical);
	DDX_Control(pDX, IDC_CHECK_SCRIPT_ALARM, m_ChkBoxScriptAlarm);
	DDX_Control(pDX, IDC_STATIC_SCRIPT_PRINTF_GRP, m_ScriptCtrlGrp);
	DDX_Control(pDX, IDC_BTN_ADD_MODEM, m_BtnAdd);
	DDX_Control(pDX, IDC_STATIC_MODEM_CONTROL, m_MdmCtrlWnd);
	DDX_Control(pDX, IDC_BTN_EDIT_MODEM, m_BtnEdit);
	DDX_Control(pDX, IDC_BTN_DELETE_MODEM, m_BtnDelete);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPES, m_combBoxModemTypes);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_RX, m_PrintfRx);
	DDX_Check(pDX, IDC_PRINTF_TX, m_PrintfTx);
	DDX_Check(pDX, IDC_INITIALIZE, m_PrintfInitialize);
	DDX_Check(pDX, IDC_CHECK_NON_CRITICAL, m_bNonCriticalScriptPrintf);
	DDX_Check(pDX, IDC_CHECK_SCRIPT_ALARM, m_bAlarmScriptPrintf);
	DDX_CBString(pDX, IDC_EXISTING_CFGS, m_szPPINISection);
	DDV_MaxChars(pDX, m_szPPINISection, 40);
	DDX_CBString(pDX, IDC_COMBO_MODEM_TYPES, m_modem_type);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWANDlg, CDialog)
	//{{AFX_MSG_MAP(CWANDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEM_TYPES, OnSelchangeComboModemTypes)
	ON_BN_CLICKED(IDC_BTN_ADD_MODEM, OnBtnAddModem)
	ON_BN_CLICKED(IDC_BTN_EDIT_MODEM, OnBtnEditModem)
	ON_BN_CLICKED(IDC_BTN_DELETE_MODEM, OnBtnDeleteModem)
	ON_BN_CLICKED(IDC_ISDN_EDIT, OnIsdnEdit)
	ON_BN_CLICKED(IDC_ISDN_DELETE, OnIsdnDelete)
	ON_BN_CLICKED(IDC_ISDN_ADD, OnIsdnAdd)
	ON_CBN_SELCHANGE(IDC_EXISTING_CFGS, OnCfgs)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWANDlg message handlers

BOOL CWANDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn1.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn1.SubclassDlgItem (IDC_BTN_ADD_MODEM, this));
	AddBmpBtn1.SizeToContent();

	if (!DeleteBmpBtn1.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn1.SubclassDlgItem (IDC_BTN_DELETE_MODEM, this));
	DeleteBmpBtn1.SizeToContent();

	if (!EditBmpBtn1.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditBmpBtn1.SubclassDlgItem (IDC_BTN_EDIT_MODEM, this));
	EditBmpBtn1.SizeToContent();

	if (!AddBmpBtn2.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn2.SubclassDlgItem (IDC_ISDN_ADD, this));
	AddBmpBtn2.SizeToContent();

	if (!DeleteBmpBtn2.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn2.SubclassDlgItem (IDC_ISDN_DELETE, this));
	DeleteBmpBtn2.SizeToContent();

	if (!EditBmpBtn2.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditBmpBtn2.SubclassDlgItem (IDC_ISDN_EDIT, this));
	EditBmpBtn2.SizeToContent();


	char szBuf[30] ;
	// Get the values of all WAN parameters from INI file.
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Printf", (LPCSTR) StrDisabled, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_Printf = TRUE ;
	else 
		m_Printf = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Initialization Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfInitialize = TRUE ;
	else
		m_PrintfInitialize = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Rx Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfRx = TRUE ;
	else 
		m_PrintfRx = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Tx Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm);
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfTx = TRUE ;
	else
		m_PrintfTx = FALSE ;

	GetPrivateProfileString ((LPCSTR) ScriptSectionHeader, 
			(LPCSTR) "Script Alarm Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_bAlarmScriptPrintf = TRUE ;
	else
		m_bAlarmScriptPrintf = FALSE ;

	GetPrivateProfileString ((LPCSTR) ScriptSectionHeader, 
			(LPCSTR) "Script Non Critical Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_bNonCriticalScriptPrintf = TRUE ;
	else
		m_bNonCriticalScriptPrintf = FALSE ;

/* chetan 9/7/97 */
	if (model == MODEL_MTSR3_200)
	{
		m_INISectionControl.ShowWindow (SW_HIDE);
		m_AddConfig.ShowWindow (SW_HIDE);
		m_DeleteConfig.ShowWindow (SW_HIDE);
		m_EditConfig.ShowWindow (SW_HIDE);
		m_ctrl_static_isdn_config_types.ShowWindow (SW_HIDE);
		m_IsdnCtrlWnd.ShowWindow (SW_HIDE);

	}
	if (!GetModemTypes())
	{
		CDialog::OnCancel() ;
		return FALSE ;
	}
	if (model != MODEL_MTSR3_200)
	{
		if (m_nSelectedModem != CB_ERR)
			m_combBoxModemTypes.SetCurSel (m_nSelectedModem) ;
		GetIsdnTypes ();
		if (m_nSelectedIsdn != CB_ERR )
		m_INISectionControl.SetCurSel ( m_nSelectedIsdn );
		if ( m_INISectionControl.GetCurSel () == CB_ERR )
 				m_INISectionControl.SetCurSel(m_INISectionControl.FindStringExact(-1,"USA_5ESS"));
      m_INISectionControl.GetLBText(m_INISectionControl.GetCurSel (),m_szPPINISection );
		sprintf ( TempSection ,"%s",m_szPPINISection );
	}
	
	CenterWindow() ;

   // Update the Dialog Box fields.
	UpdateData (FALSE) ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

void CWANDlg::OnHelp()
{
	if ((model == MODEL_MTSR1_202ST)	|| (model == MODEL_MTSR1_202NT))
		AfxGetApp()->WinHelp(0x20000 + IDD_WAN_ISDN_CONFIG,HELP_CONTEXT);
	else if (model == MODEL_MTSR2_201)
		AfxGetApp()->WinHelp(0x20000 + IDD_WAN_DSU_CONFIG,HELP_CONTEXT);
	else
		AfxGetApp()->WinHelp(0x20000 + IDD_WAN_CONFIG,HELP_CONTEXT);
	
}


void CWANDlg::OnOK()
{
	// Update the parameters from the Dialog Box.
	if (!UpdateData (TRUE))
      return ;

	LPCSTR temp ;
	// Write the WAN parameters to the INI file.

	if (m_Printf)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) "WAN Printf", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
		
	if (m_PrintfInitialize)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Initialization Printf", (LPCSTR) temp,
				(LPCSTR) IniInWinForm) ;

	if (m_PrintfRx)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Rx Printf", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
			
 	if (m_PrintfTx)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Tx Printf", temp, (LPCSTR) IniInWinForm) ;

	if (m_bAlarmScriptPrintf)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) ScriptSectionHeader, 
				(LPCSTR) "Script Alarm Printf", 
						(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_bNonCriticalScriptPrintf)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) ScriptSectionHeader, 
				(LPCSTR) "Script Non Critical Printf", 
						(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_bMdmConfigChanged)
		WriteToCnfFile() ;
	CWanTab *pParent = (CWanTab *) GetParent();
	for (int i = 0 ; i < pParent->tabcount ; i ++)
		pParent->WriteModemInfoToIni ();

	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

/*----------------------------------------------------------------------------
	Module 	: WriteToCnfFile
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any error while writing
	Synopsis	: Writes the Modem Info into the MODEMS.CNF file
				  along with the Header
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWANDlg::WriteToCnfFile()
{
	char szFilePath[200] ;
	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	// Rewrite Modems.Cnf file with new Modems Info
	fModemsPtr = fopen (szFilePath, "wb") ;
	if (fModemsPtr == NULL)
	{
		MessageBox ("Could not create MODEMS.CNF file",
			"File Creation Error", MB_OK | MB_ICONSTOP) ;

		// Before returning free all the buffers allocated
		// with new
		ReleaseBuffers() ;
		return FALSE ;
	}

	int nItems = m_combBoxModemTypes.GetCount() ;

	MODEMS_HDR ModemsHdr ;

	ModemsHdr.ChkSum = (WORD) 0 ; // Just like that
	ModemsHdr.Version = '1' ;  // For the time being
	ModemsHdr.NumEntries = (WORD) nItems ; // No. of modems
	fwrite (&ModemsHdr, sizeof (ModemsHdr), 1, fModemsPtr) ;

	MODEM_SETUP *pModemSetup ;

	// Write each Modem Info. one by one
	for (int i = 0 ; i < nItems ; i ++)
	{
		pModemSetup = (MODEM_SETUP *)
			m_combBoxModemTypes.GetItemDataPtr (i) ;
		fwrite ((MODEM_SETUP *) pModemSetup, 
				sizeof (MODEM_SETUP), 1, fModemsPtr) ;
	}

	// This is to ensure that "Direct Connection"
	// still goes with the modems.cnf file
	MODEM_SETUP DirConnect ;
	memset (&DirConnect, 0x00, sizeof (MODEM_SETUP)) ;
	strcpy (DirConnect.ModemType, "Direct Connection") ;
	fwrite (&DirConnect, sizeof (MODEM_SETUP), 1, fModemsPtr) ;

	fclose (fModemsPtr) ;
		
	// Open Modems.Cnf file in Read-Write-Binary Mode
	fModemsPtr = fopen (szFilePath, "r+b") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(), "Error writing MODEMS.CNF!!!",
				"Warning", MB_OK) ;

		// Before returning free all the buffers allocated
		// with new
		ReleaseBuffers() ;
		return FALSE ;
	}
		
	if (!WriteCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Error writing MODEMS.CNF!!!",
				"Warning", MB_OK) ;
	}
	fclose (fModemsPtr) ;

	// Before returning free all the buffers allocated
	// with new
	ReleaseBuffers() ;
	return TRUE ;
}

/*----------------------------------------------------------------------------
	Module 	: ReleaseBuffers
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Releases all Buffers allocated for storing
				  the Modems Information	
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::ReleaseBuffers()
{
	int nItems = m_combBoxModemTypes.GetCount() ;
	MODEM_SETUP *pModemSetup ;

	for (int i = 0 ; i < nItems ; i ++)
	{
		pModemSetup = (MODEM_SETUP *) 
				m_combBoxModemTypes.GetItemDataPtr (i) ;
		delete pModemSetup ;
	}
	return ;
}

/*----------------------------------------------------------------------------
	Module 	: PutModemsInParentsList
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Puts the Modems List into each of the Tab's Combo Boxes
				  And depending on the previous selection	restores them
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::PutModemsInParentsList()
{
	CWanTab *pParent = (CWanTab *) GetParent() ;
	int nCount = m_combBoxModemTypes.GetCount() ;

	char szBuf[40] ;
	int nIndex ;

	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		// Get the previous selection
		nIndex = pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
		if (nIndex != CB_ERR)
		{
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nIndex, szBuf) ;
			pParent->m_pdlgWAN[i]->m_szOldModemSel = szBuf ;
		}
		else
			pParent->m_pdlgWAN[i]->m_szOldModemSel = "" ;
			
		// Refresh the Modems List in the Combo Box
		pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent() ;

		// Add Modems to List
		for (int j = 0 ; j < nCount ; j ++)
		{
			m_combBoxModemTypes.GetLBText (j, (LPSTR) szBuf) ;
			if (strcmp (szBuf, "Direct Connection") != 0)
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (szBuf) ;
		}

		// If there was a previous selection restore it
		if (!pParent->m_pdlgWAN[i]->m_szOldModemSel.IsEmpty())
		{
			nIndex =	
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1, 
								pParent->m_pdlgWAN[i]->m_szOldModemSel) ;								
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nIndex) ;
		}	
	}
	
}

void CWANDlg::PutIsdnConfigInParentsList (int index)
{
	CWanTab *pParent = (CWanTab *) GetParent() ;
 	int nCount = m_INISectionControl.GetCount() ;

	char szBuf[40] ;
	int nIndex ;
	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		// Get the previous selection
		if ( i == index )
		{
			nIndex = pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
			if (nIndex != CB_ERR)
			{
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nIndex, szBuf) ;
				pParent->m_pdlgWAN[i]->m_szOldIsdnSel = szBuf ;
			}
			else
				pParent->m_pdlgWAN[i]->m_szOldIsdnSel = "" ;
			
			// Refresh the Isdn Configs List in the Combo Box
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent() ;
			
			// Add Isdn Configs to List
			for (int j = 0 ; j < nCount ; j ++)
			{
				m_INISectionControl.GetLBText (j, (LPSTR) szBuf) ;
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (szBuf) ;
			}

			// If there was a previous selection restore it
			if (!pParent->m_pdlgWAN[i]->m_szOldIsdnSel.IsEmpty())
			{
				nIndex =	
					pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1, 
									pParent->m_pdlgWAN[i]->m_szOldIsdnSel) ;								
				if ( nIndex == CB_ERR)
					nIndex = 0;
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nIndex) ;

			}
		}	
	}		
}


/*----------------------------------------------------------------------------
	Module 	: OnBtnAddModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: On Clicking Add Modems Button processing takes place here
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnAddModem()
{
	// TODO: Add your control notification handler code here

	CModemTypes cModem;
	cModem.m_bActionAdd = TRUE ;

	int nRetVal = cModem.DoModal() ;
	if (nRetVal == IDOK)
	{
		m_bMdmConfigChanged = TRUE ;
				
	}
	EnableButtons() ;
}

/*----------------------------------------------------------------------------
	Module 	: OnBtnDelModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Confirm and Delete selected Modem Info 
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnDeleteModem()
{
	// TODO: Add your control notification handler code here

	int nSelected  = m_combBoxModemTypes.GetCurSel() ;

	// If none selected return
	if (nSelected == CB_ERR)
		return ;

	int nRetVal = ::MessageBox (GetSafeHwnd(),
			"Do you want to delete this modem ?",
				"Modem Information", MB_YESNO | MB_ICONQUESTION) ;
	if (nRetVal == IDNO)
		return ;

	MODEM_SETUP *pModemSetup = (MODEM_SETUP *) 
							m_combBoxModemTypes.GetItemDataPtr (nSelected) ;
	delete pModemSetup ;

	m_combBoxModemTypes.DeleteString (nSelected) ;
	CWanTab *pParent = (CWanTab *)GetParent();
	for (int index = 0; index < pParent->tabcount; index++)
		pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.DeleteString (nSelected) ;

	m_bMdmConfigChanged = TRUE ;
	EnableButtons() ;
	PutModemsInParentsList() ;
	UpdateData (FALSE) ;

	return ;
}

/*----------------------------------------------------------------------------
	Module 	: OnBtnEditModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Let user Edit Modem Info 
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnEditModem()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);

	int nSelected  = m_combBoxModemTypes.GetCurSel() ;
	// If none selected return
	if (nSelected == CB_ERR)
		return ;

	CModemTypes cModem;
	cModem.m_bActionAdd = FALSE ;
	int nRetVal = cModem.DoModal() ;
	if (nRetVal == IDOK)
	{
		m_bMdmConfigChanged = TRUE ;
//		int nCurSel = m_combBoxModemTypes.GetCurSel();
	}	
	EnableButtons() ;

	return ;
}

/*----------------------------------------------------------------------------
	Module 	: EnableButtons
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: If No modems in List disable Edit and Delete Buttons
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::EnableButtons() 
{
	BOOL fEnable = FALSE ;

	int nCount = m_combBoxModemTypes.GetCount() ;
	if (nCount)
		fEnable = TRUE ;

	m_BtnEdit.EnableWindow (fEnable) ;
	m_BtnDelete.EnableWindow (fEnable) ;
	
	return ;
}

/*----------------------------------------------------------------------------
	Module 	: GetModemTypes
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any read error
	Synopsis	: List all Modems from the Cnf file
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWANDlg::GetModemTypes()
{
	char szFilePath[200] ; // For MODEMS.CNF File

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	// Refresh the Combo Box
	m_combBoxModemTypes.ResetContent() ;

	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
					"File Open Error", MB_OK) ;
		EnableButtons() ;
		return TRUE ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Invalid MODEMS.CNF file",
																"Warning", MB_OK) ;
		EnableButtons() ;
		return TRUE ;
	} 

	// Jump directly to Modems Info bypassing the header
	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

	int nIndex ;

	while (TRUE)
	{
		MODEM_SETUP *MdmSetupPtr = (MODEM_SETUP *) new (MODEM_SETUP) ;
		if (MdmSetupPtr == NULL)
		{
			::MessageBox (GetSafeHwnd(), "Insufficient Memory",
				"Modem Setup", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
		if (fread (MdmSetupPtr, sizeof (MODEM_SETUP), 1, fModemsPtr) < 1)
		{
			delete MdmSetupPtr ;
			break ;
		}
		if (strcmp (MdmSetupPtr->ModemType, "Direct Connection") != 0)
		{
			nIndex = m_combBoxModemTypes.AddString (MdmSetupPtr->ModemType) ;
			m_combBoxModemTypes.SetItemDataPtr (nIndex, 
										(MODEM_SETUP *) MdmSetupPtr) ;  
		}
	}
	EnableButtons() ;
	m_combBoxModemTypes.SetCurSel(0);
	fclose (fModemsPtr) ;
	return TRUE ;
}

void CWANDlg::OnSelchangeComboModemTypes()
{
	// TODO: Add your control notification handler code here
	int nIndex = m_combBoxModemTypes.GetCurSel() ;

	CString DirectConnectStr ;
	m_combBoxModemTypes.GetLBText (nIndex, DirectConnectStr) ;
	if (DirectConnectStr == MODEM_TYPE_DIRECT_CONNECT)
	{
		m_BtnEdit.EnableWindow (FALSE) ;
		return ;
	}
	m_BtnEdit.EnableWindow (TRUE) ;
	return ;
}


void CWANDlg::GetIsdnTypes ()
{
	char strLHS[40],strRHS[40],buffer[512];
	char *token;
	char *seps = "\0";
	int length = 0;
	int total;
	CString szDefaultConfig;

	m_INISectionControl.ResetContent();
	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
		if ( m_INISectionControl.FindStringExact ( -1, strRHS ) == CB_ERR )
		{
			// Insert the string in the list box
/* Sudha 9 June 1998 */
         if (( model == MODEL_MTSR1_202ST) ||
            (( model == MODEL_MTSR1_202NT ) && (strstr ( strRHS,"USA") != NULL)) ||
            ( model == MODEL_MTSR2_201 ))              
   			m_INISectionControl.AddString( strRHS );
		}
		strLHS[6]++;
   } 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	if ( total != 0 )
	{
		token = strtok ( buffer, seps );
		while ( token != NULL)
		{
			if ( m_INISectionControl.FindStringExact ( -1, token ) == CB_ERR )
			{
				// Insert the string in the list box
				m_INISectionControl.AddString( token );
			}	
			length = length + strlen ( token ) + 1;	// +1 for the NULL character
	      token = strtok( &buffer[length], seps );
		}
	}
	
	if ( m_nSelectedIsdn == CB_ERR )
		m_nSelectedIsdn = 0;
	m_INISectionControl.SetCurSel ( m_nSelectedIsdn );
   m_INISectionControl.GetLBText ( m_INISectionControl.GetCurSel(),m_szPPINISection );

}

void CWANDlg::OnIsdnEdit()
{
	// TODO: Add your control notification handler code here
	
	m_cfgtype = kEdit;
	CIsdnTa Isdn (this);
	Isdn.DoModal();
}

void CWANDlg::OnIsdnDelete()
{
	// TODO: Add your control notification handler code here

	int			nCurSel, nMBResponse;
	CString		szConfig, szMsg, config ,deleted_config;
	char strRHS[40] ,strLHS[40];
	
	CIsdnTa Isdn;

	m_cfgtype = kDelete;

	if ( m_INISectionControl.GetCurSel() == CB_ERR)
	{
		::MessageBox(GetSafeHwnd(),"Select a Configuration file to delete",IsdnMsgHeader,MB_OK);
		m_INISectionControl.SetFocus();
		return;
	}
	else
	{
		nCurSel = m_INISectionControl.GetCurSel ();
   	m_INISectionControl.GetLBText ( nCurSel, m_szPPINISection );
		deleted_config = m_szPPINISection;

	   if ( nCurSel != CB_ERR )
	   { 
			m_INISectionControl.GetLBText ( nCurSel, szConfig );
			if ( Isdn.IsThisADefaultCfg ( szConfig ) )
			{	
				szMsg.LoadString(IDS_DELETE_DEFAULT_CONFIG);
				nMBResponse = AfxMessageBox ( szMsg );
				return;
			}
			sprintf(strLHS,"Port0");
			while ( GetPrivateProfileString ( MapHeader,strLHS,
				StrNull,strRHS,sizeof(strRHS),ini_INIFilename ))
		  	{
				if ( szConfig.CompareNoCase ( strRHS ) == 0 )
				{
 					::MessageBox ( GetSafeHwnd(),"This is the existing configuration.\
Before deleting this make sure to change the configuration.",IsdnMsgHeader,MB_OK);
					return;
				}
			 	strLHS[4]++;
			}
		   szMsg.LoadString(IDS_DELETE_CONFIG);
		   nMBResponse = AfxMessageBox ( szMsg, MB_YESNO, 0 );
			if ( nMBResponse == IDYES )
			{
				::WritePrivateProfileString ( szConfig, NULL, NULL, ini_INIFilename );
				::WritePrivateProfileString  (	"User Config", szConfig, NULL, ini_INIFilename );
				m_INISectionControl.DeleteString ( nCurSel );
			
				if ( nCurSel != m_INISectionControl.GetCount () )
					m_INISectionControl.SetCurSel ( (nCurSel) );
				else
					m_INISectionControl.SetCurSel ( nCurSel-1 );
			}
		}
		////Prabha, 4/2/98, To echo the deletion in the port tabs also
		CWanTab *pParent = (CWanTab *)GetParent();
		for (int port = 0; port < pParent->tabcount; port++)
		{
			pParent->m_pdlgWAN[port]->m_ComBoxModemTypes.GetLBText ( nCurSel, deleted_config );
			pParent->m_pdlgWAN[port]->m_ComBoxModemTypes.DeleteString (nCurSel);
		}
	}		
	return;
}

void CWANDlg::OnIsdnAdd()
{
	// TODO: Add your control notification handler code here

	m_cfgtype = kAdd;
	
	CIsdnTa Isdn (this);
	if (Isdn.DoModal() == IDOK)
	{
		////Prabha, 6/3/98, Put the newly added config in the list
		if (m_INISectionControl.FindStringExact (-1, Isdn.m_szPPSectionName ) == CB_ERR)
			m_INISectionControl.AddString ( Isdn.m_szPPSectionName );
		CWanTab *pParent = (CWanTab *) GetParent();
		for (int index = 0; index < pParent->tabcount; index++)
		{
			if ( pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.FindStringExact ( -1, Isdn.m_szPPSectionName ) == CB_ERR )
				pParent->m_pdlgWAN[index]->m_ComBoxModemTypes.AddString ( Isdn.m_szPPSectionName );
		}
	}
	return;
}

void CWANDlg::OnCfgs()
{
	// TODO: Add your control notification handler code here
	
	if ( m_INISectionControl.GetCurSel() != CB_ERR )
	{
 		//m_INISectionControl.GetWindowText ( m_szPPINISection );
                m_INISectionControl.GetLBText ( 
                        m_INISectionControl.GetCurSel(),m_szPPINISection );

		sprintf ( TempSection,"%s",m_szPPINISection );
	}
	
}

LRESULT CWANDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWANDlg::PostNcDestroy(void)
{
	delete this;
}

void CWANDlg::OnCancel()
{
	// TODO: Add extra cleanup here

	if (m_bMdmConfigChanged)
	{
		int nRetVal = MessageBox ("Do you want to save changes?",
					"Modems - Information", MB_YESNO | MB_ICONQUESTION) ;
		if (nRetVal == IDYES)
		{
			PutModemsInParentsList() ;
			WriteToCnfFile() ;

			CWanTab *pParent = (CWanTab *) GetParent() ;
			pParent->WriteModemInfoToIni() ;
		}
	}
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

/////////////////////////////////////////////////////////////////////////////
// CWanPortDlg dialog


CWanPortDlg::CWanPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWanPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWanPortDlg)
	m_WANPort = FALSE;
	m_cboxAsyncBaud = "";
	m_cboxSyncIntClk = "";
	m_bDirConnect = FALSE;
	m_bRestartScriptOnCommFailure = FALSE;
	m_bScriptEnable = FALSE;
	m_active_connections = 0;
	m_host = "";
	m_szSectionName = "";
	m_active_hosts = "";
	m_idle_time = 0;
	m_general_name = "";
	m_specific_name = "";
	m_port_inactivity_timeout = 0;
	m_isdn_str = "";
	m_bAGEnable = FALSE;
	m_bProxyEnable = FALSE;
	m_bRasEnable = FALSE;
	//}}AFX_DATA_INIT

	m_szOldModemSel = "";
	
	Create(IDD,NULL);
}

void CWanPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanPortDlg)
	DDX_Control(pDX, IDC_CHECK_RAS_ENABLE, m_ctrl_ras_enable);
	DDX_Control(pDX, IDC_CHECK_PROXY_ENABLE, m_ctrl_proxy_enable);
	DDX_Control(pDX, IDC_CHECK_AG_ENABLE, m_ctrl_ag_enable);
	DDX_Control(pDX, IDC_DIAL_ANSWER, m_ctrl_dial_answer);
	DDX_Control(pDX, IDC_EDIT_ISDN_EXTRA_STRING, m_ctrl_isdn_str);
	DDX_Control(pDX, IDC_STATIC_EXTRA_ISDN_STRING, m_stat_isdn_str);
	DDX_Control(pDX, IDC_STATIC_SPECIFIC_NAME, m_ctrl_static_specific_name);
	DDX_Control(pDX, IDC_STATIC_PORT_INACTIVITY_TIMEOUT, m_ctrl_static_port_inactivity_timeout);
	DDX_Control(pDX, IDC_STATIC_GENERAL_NAME, m_ctrl_static_general_name);
	DDX_Control(pDX, IDC_STATIC_ASYNCHRONOUS_GATEWAY, m_ctrl_asynchronous_gateway);
	DDX_Control(pDX, IDC_EDIT_SPECIFIC_NAME, m_ctrl_specific_name);
	DDX_Control(pDX, IDC_EDIT_PORT_INACTIVITY_TIMEOUT, m_ctrl_port_inactivity_timeout);
	DDX_Control(pDX, IDC_EDIT_GENERAL_NAME, m_ctrl_general_name);
	DDX_Control(pDX, IDC_STATIC_LINK_USAGE_CONTROL, m_ctrl_link_usage_ctrl);
	DDX_Control(pDX, IDC_STATIC_HOST, m_static_list_host);
	DDX_Control(pDX, IDC_STATIC_ACTIVE_IP_HOST_MACHINES, m_ctrl_static_ip_hosts);
	DDX_Control(pDX, IDC_EDIT_IP_HOST_MACHINES, m_ctrl_active_ip_hosts);
	DDX_Control(pDX, IDC_STATIC_ACTIVE_CONNECTIONS, m_ctrl_static_active_connections);
	DDX_Control(pDX, IDC_EDIT_CONNECTIONS, m_ctrl_active_connections);
	DDX_Control(pDX, IDC_CHECK_LINK_CTRL_ENABLE, m_link_ctrl_enabled);
	DDX_Control(pDX, IDC_EDIT_IDLE_TIME, m_ctrl_idle_time);
	DDX_Control(pDX, IDC_STATIC_MINUTES, m_ctrl_minutes);
	DDX_Control(pDX, IDC_STATIC_IDLE_TIME, m_ctrl_static_idle_time);
	DDX_Control(pDX, IDC_BUTTON_DELETE, m_ctrl_delete);
	DDX_Control(pDX, IDC_BUTTON_ADD, m_ctrl_add);
	DDX_Control(pDX, IDC_STATIC_BRING_UP, m_static_bring_up);
	DDX_Control(pDX, IDC_EDIT_HOST, m_ctrl_host);
	DDX_Control(pDX, IDC_LIST_HOST, m_list_host);
	DDX_Control(pDX, IDC_RADIO_ISDN, m_RBtnIsdn);
	DDX_Control(pDX, IDC_RADIO_MODEM, m_RBtnModem);
	DDX_Control(pDX, IDC_BTN_SCRIPT, m_BtnScript);
	DDX_Control(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_RestartScriptWnd);
	DDX_Control(pDX, IDC_CHECK_ENABLE_SCRIPT, m_ScriptEnableWnd);
	DDX_Control(pDX, IDC_CHECK_DIR_CONNECT, m_chkBtnDirConnect);
	DDX_Control(pDX, IDC_CHECK_IDLE_FLAGS, m_chkboxIdleFlags);
	DDX_Control(pDX, IDC_STATIC_MODEM_TYPES, m_StatModemTypes);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPES, m_ComBoxModemTypes);
	DDX_Control(pDX, IDC_CLK_SPEED_HDR, m_ClkSpeedHdr);
	DDX_Control(pDX, IDC_BAUD_HEADER, m_BaudHeader);
	DDX_Control(pDX, IDC_DIALLING, m_RBtnDialling);
	DDX_Control(pDX, IDC_ANSWERING, m_RBtnAnswering);
	DDX_Control(pDX, IDC_EXT_CLOCK, m_RBtnExtClk);
	DDX_Control(pDX, IDC_SYNC_INT_CLK, m_cboxSyncIntClkWnd);
	DDX_Control(pDX, IDC_INT_CLOCK, m_RBtnIntClk);
	DDX_Control(pDX, IDC_RADIO_SYNC, m_RBtnSync);
	DDX_Control(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaudWnd);
	DDX_Control(pDX, IDC_RADIO_ASYNC, m_RBtnAsync);
	DDX_Check(pDX, IDC_WAN_PORT, m_WANPort);
	DDX_CBString(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaud);
	DDV_MaxChars(pDX, m_cboxAsyncBaud, 15);
	DDX_CBString(pDX, IDC_SYNC_INT_CLK, m_cboxSyncIntClk);
	DDV_MaxChars(pDX, m_cboxSyncIntClk, 15);
	DDX_Check(pDX, IDC_CHECK_DIR_CONNECT, m_bDirConnect);
	DDX_Check(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_bRestartScriptOnCommFailure);
	DDX_Check(pDX, IDC_CHECK_ENABLE_SCRIPT, m_bScriptEnable);
	DDX_Text(pDX, IDC_EDIT_CONNECTIONS, m_active_connections);
	DDV_MinMaxInt(pDX, m_active_connections, 0, 9999);
	DDX_Text(pDX, IDC_EDIT_HOST, m_host);
	DDX_CBString(pDX, IDC_COMBO_MODEM_TYPES, m_szSectionName);
	DDX_Text(pDX, IDC_EDIT_IP_HOST_MACHINES, m_active_hosts);
	DDX_Text(pDX, IDC_EDIT_IDLE_TIME, m_idle_time);
	DDX_Text(pDX, IDC_EDIT_GENERAL_NAME, m_general_name);
	DDX_Text(pDX, IDC_EDIT_SPECIFIC_NAME, m_specific_name);
	DDX_Text(pDX, IDC_EDIT_PORT_INACTIVITY_TIMEOUT, m_port_inactivity_timeout);
	DDX_Text(pDX, IDC_EDIT_ISDN_EXTRA_STRING, m_isdn_str);
	DDV_MaxChars(pDX, m_isdn_str, 40);
	DDX_Check(pDX, IDC_CHECK_AG_ENABLE, m_bAGEnable);
	DDX_Check(pDX, IDC_CHECK_PROXY_ENABLE, m_bProxyEnable);
	DDX_Check(pDX, IDC_CHECK_RAS_ENABLE, m_bRasEnable);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanPortDlg, CDialog)
	//{{AFX_MSG_MAP(CWanPortDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_REGISTERED_MESSAGE(msgSwitchTo, OnSwitchToIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_RADIO_ASYNC, OnRadioAsync)
	ON_BN_CLICKED(IDC_RADIO_SYNC, OnRadioSync)
	ON_BN_CLICKED(IDC_INT_CLOCK, OnIntClock)
	ON_BN_CLICKED(IDC_EXT_CLOCK, OnExtClock)
	ON_BN_CLICKED(IDC_ANSWERING, OnAnswering)
	ON_BN_CLICKED(IDC_DIALLING, OnDialling)
	ON_BN_CLICKED(IDC_CHECK_DIR_CONNECT, OnCheckDirConnect)
	ON_BN_CLICKED(IDC_BTN_SCRIPT, OnBtnScript)
	ON_BN_CLICKED(IDC_RADIO_ISDN, OnRadioIsdn)
	ON_BN_CLICKED(IDC_RADIO_MODEM, OnRadioModem)
	ON_BN_CLICKED(IDC_CHECK_LINK_CTRL_ENABLE, OnCheckLinkCtrlEnable)
	ON_BN_CLICKED(IDC_BUTTON_ADD, OnButtonAdd)
	ON_BN_CLICKED(IDC_BUTTON_DELETE, OnButtonDelete)
	ON_BN_CLICKED(IDC_DIAL_ANSWER, OnDialAnswer)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEM_TYPES, OnSelchangeComboModemTypes)
	ON_BN_CLICKED(IDC_CHECK_PROXY_ENABLE, OnCheckProxyEnable)
	ON_BN_CLICKED(IDC_CHECK_RAS_ENABLE, OnCheckRasEnable)
	ON_BN_CLICKED(IDC_CHECK_AG_ENABLE, OnCheckAgEnable)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanPortDlg message handlers

void CWanPortDlg::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CWanPortDlg::OnOK()
{
   // TODO: Add extra validation here
   if (!UpdateData (TRUE))
		return ;

// Brindha on 28/4/99.
   if (!ValidCheckBtns())
   	  return ;			

   if (!ValidEditFields())  
      return ;

	CDialog::OnOK() ;
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

LRESULT CWanPortDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWanPortDlg::PostNcDestroy(void)
{
	delete this;
}

void CWanPortDlg::OnHelp()
{
		AfxGetApp()->WinHelp(0x20000 + IDD_WAN_PORT_CONFIG,HELP_CONTEXT);
	
}

void CWanPortDlg::OnControl()
{
	UpdateData (TRUE) ;

	// Added by cfp on 25-3-96
	int id = GetMyID();
	BOOL linkctrl ;
	BOOL fAsync = m_RBtnAsync.GetCheck() ;	
	BOOL fIntClk = m_RBtnIntClk.GetCheck() ;

	//Sudha 9 Dec 1997
	BOOL fIsdn = m_RBtnIsdn.GetCheck();
	BOOL fModem = m_RBtnModem.GetCheck();

	if ( !fIsdn && !fModem )
		OnRadioModem () ;

	// Added by cfp on 27-3-96
	BOOL fAnswering = m_RBtnAnswering.GetCheck() ;
	BOOL fdialanswer = m_ctrl_dial_answer.GetCheck(); /* sudha 14 nov 1998 */

	m_StatModemTypes.EnableWindow (fAsync && !m_bDirConnect) ;
	m_ComBoxModemTypes.EnableWindow (fAsync && !m_bDirConnect) ;

// Brindha on 27/4/99. 
	m_ctrl_dial_answer.EnableWindow (!m_bDirConnect) ;
	
/* Sudha 05 Nov 1998....*/
	m_ctrl_isdn_str.EnableWindow (fAsync && !m_bDirConnect && fIsdn ) ;
	m_stat_isdn_str.EnableWindow (fAsync && !m_bDirConnect && fIsdn ) ;
/* ....Sudha 05 Nov 1998 */
	m_RBtnModem.EnableWindow (fAsync && !m_bDirConnect) ;
	m_RBtnIsdn.EnableWindow (fAsync && !m_bDirConnect) ;

	m_cboxAsyncBaudWnd.EnableWindow (fAsync) ;
	m_RBtnIntClk.EnableWindow (!fAsync) ;
	m_cboxSyncIntClkWnd.EnableWindow (!fAsync && fIntClk) ;
	m_RBtnExtClk.EnableWindow (!fAsync) ;
	m_BaudHeader.EnableWindow (fAsync) ;
	m_ClkSpeedHdr.EnableWindow (!fAsync && fIntClk) ;
	m_chkboxIdleFlags.EnableWindow (!fAsync) ;

	/* 9/7/97 chetan */
	m_BtnScript.EnableWindow (fAsync && RouterStatus && !m_bDirConnect && m_bProxyEnable) ;
	m_RestartScriptWnd.EnableWindow (fAsync && !m_bDirConnect && m_bProxyEnable) ;
	m_ScriptEnableWnd.EnableWindow (fAsync && !m_bDirConnect && m_bProxyEnable) ;
	/* 9/7/97 chetan */

	/* sudha 14 nov 1998 */
  	if ( fAnswering )
		m_link_ctrl_enabled.SetCheck (0) ;
	
	
// Brindha on 27/4/99.
	m_ctrl_proxy_enable.EnableWindow (!fAnswering) ;
	m_ctrl_ag_enable.EnableWindow (fAsync && !fAnswering) ;
	m_ctrl_ras_enable.EnableWindow (fAnswering || fdialanswer) ;

	m_link_ctrl_enabled.EnableWindow (!fAnswering && !m_bDirConnect && m_bProxyEnable) ;
	m_ctrl_idle_time.EnableWindow (!fAnswering && !m_bDirConnect && m_bProxyEnable) ;
	m_ctrl_minutes.EnableWindow (!fAnswering && !m_bDirConnect && m_bProxyEnable) ;
	m_ctrl_static_idle_time.EnableWindow (!fAnswering && !m_bDirConnect && m_bProxyEnable) ;

	m_ctrl_link_usage_ctrl.EnableWindow (!fAnswering && !m_bDirConnect && m_bProxyEnable) ;

	if ( (!fAnswering) && (id != 0) && (!m_bDirConnect) && m_bProxyEnable)
		linkctrl = TRUE ;
	else												 
		linkctrl = FALSE ;

	m_static_bring_up.EnableWindow (linkctrl) ;
	m_ctrl_static_active_connections.EnableWindow (linkctrl) ;
	m_ctrl_active_connections.EnableWindow (linkctrl) ;
	m_ctrl_static_ip_hosts.EnableWindow (linkctrl) ;
	m_ctrl_active_ip_hosts.EnableWindow (linkctrl) ;
	m_static_list_host.EnableWindow (linkctrl) ;
	m_list_host.EnableWindow (linkctrl) ;
	m_ctrl_host.EnableWindow (linkctrl) ;
	m_ctrl_add.EnableWindow (linkctrl) ;
	m_ctrl_delete.EnableWindow (linkctrl) ;

	if (model == MODEL_MTSR2_201)
	{
		m_cboxSyncIntClkWnd.EnableWindow(FALSE) ;
		m_ClkSpeedHdr.EnableWindow(FALSE) ;
	}

// Brindha on 28/4/99.
	if (fAsync && !fAnswering && m_bAGEnable)
		BringBackAG() ;
	else
		CutoutAG() ;
}


BOOL CWanPortDlg::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap") ;	    

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this)) ;
	OKBmpBtn.SizeToContent() ;

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap") ;

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this)) ;
	CancelBmpBtn.SizeToContent() ;

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap") ;

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this)) ;
	HelpBmpBtn.SizeToContent() ;

	if (!AddBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap") ;

	VERIFY (AddBmpBtn.SubclassDlgItem (IDC_BUTTON_ADD, this));
	AddBmpBtn.SizeToContent();

	if (!DeleteBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap") ;

	VERIFY (DeleteBmpBtn.SubclassDlgItem (IDC_BUTTON_DELETE, this));
	DeleteBmpBtn.SizeToContent() ;

	if (!ScriptBmpBtn.LoadBitmaps ("SCRIPT1", "SCRIPT2", "SCRIPT3", "SCRIPT4"))
		AfxMessageBox ("Failed to load SCRIPT bitmap") ;

	VERIFY (ScriptBmpBtn.SubclassDlgItem (IDC_BTN_SCRIPT, this)) ;
	ScriptBmpBtn.SizeToContent() ;

	// TODO: Add extra initialization here
	
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

int	CWanPortDlg::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

// Added by cfp
void CWanPortDlg::OnRadioAsync()
{
	// TODO: Add your control notification handler code here
	m_RBtnAsync.SetCheck (1) ;
	m_RBtnSync.SetCheck (0) ;		
	OnControl() ;

/* sudha 12 nov 1998 */
// modified by brindha on 27/4/99. 
	BOOL fAnswering = m_RBtnAnswering.GetCheck() ;
	BOOL fAgEnabled = m_ctrl_ag_enable.GetCheck() ;
    if (!fAnswering && fAgEnabled) 
		BringBackAG() ;
}

void CWanPortDlg::BringBackAG()
{
	CWanTab *pParent = (CWanTab *) GetParent() ;
	
	for (int nPort = 0 ; nPort < pParent->tabcount ; nPort ++)
	{
		if (pParent->m_pdlgWAN[nPort] == this)
			break ;
	}

	if (pParent->m_bAG)
		pParent->GrayAGControls (FALSE, nPort) ;

	if (bAGEnable == 0)
		pParent->GrayAGControls (TRUE, nPort) ;
}


// Added by cfp
void CWanPortDlg::OnRadioSync()
{
	// TODO: Add your control notification handler code here
	m_RBtnAsync.SetCheck (0) ;
	m_RBtnSync.SetCheck (1) ;		
	OnControl() ;
    CutoutAG();
}

void CWanPortDlg::CutoutAG()
{
	CWanTab *pParent = (CWanTab *) GetParent() ;
	for (int nPort = 0 ; nPort < pParent->tabcount ; nPort ++)
	{
		if (pParent->m_pdlgWAN[nPort] == this)
			break ;
	}

	if (pParent->m_bAG)
		pParent->GrayAGControls (TRUE, nPort) ;
}


// Added by cfp
void CWanPortDlg::OnIntClock()
{
	// TODO: Add your control notification handler code here
	if (m_RBtnSync.GetCheck())
	{
		m_RBtnAsync.SetCheck (0) ;
        m_RBtnIntClk.SetCheck (1) ;      
		m_RBtnExtClk.SetCheck (0) ;		
		OnControl() ;
	    return ;
	}
	m_RBtnIntClk.SetCheck (0) ;      
	OnControl() ;
	return ;
}

// Added by cfp
void CWanPortDlg::OnExtClock()
{
	// TODO: Add your control notification handler code here
	if (m_RBtnSync.GetCheck())
	{
		m_RBtnAsync.SetCheck (0) ;
	    m_RBtnIntClk.SetCheck (0) ;      
		m_RBtnExtClk.SetCheck (1) ;		
		OnControl() ;
		return ;
	}
	m_RBtnExtClk.SetCheck (0) ;		
	OnControl() ;
	return ;
}



// Added by cfp
void CWanPortDlg::OnAnswering()
{
	// TODO: Add your control notification handler code here
	m_RBtnAnswering.SetCheck (1) ;
	m_RBtnDialling.SetCheck (0) ;
	m_ctrl_dial_answer.SetCheck (0) ;

	// Brindha on 27/4/99.
	m_ctrl_proxy_enable.SetCheck (0);
   	m_ctrl_ag_enable.SetCheck (0);
   	m_ctrl_ras_enable.SetCheck (1);

	OnControl() ;
    
	return ;
}

// Added by cfp
void CWanPortDlg::OnDialling()
{
	// TODO: Add your control notification handler code here
	m_ctrl_dial_answer.SetCheck (0) ;
	m_RBtnAnswering.SetCheck (0) ;
	m_RBtnDialling.SetCheck (1) ;

	// Brindha on 27/4/99.
	m_ctrl_proxy_enable.SetCheck (1) ;
	if (m_bDirConnect)
   		m_ctrl_ag_enable.SetCheck (0) ;
	else
		m_ctrl_ag_enable.SetCheck (1);	

   	m_ctrl_ras_enable.SetCheck (0);

	OnControl() ; 

	// If both PPP and SLIP are enabled, disable SLIP
	CMainDlg *maindlg = ((CMainDlg *)(GetParent()->GetParent()));
	int PortNo = GetMyID();
	if (PortNo == -1) return;
	if (maindlg->IsPPPEnabled(PortNo) && maindlg->IsSLIPEnabled(PortNo))
		maindlg->EnableSLIP (PortNo, FALSE);
	return ;
}

BOOL CWanPortDlg::ValidEditFields()
{
	CWanTab *pParent = (CWanTab *) GetParent() ;
	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}

	char szLHSPPP[80] ;
	char szRHSPPP[80] ;
	char temp_msg[15] ;
	char temp_name[20] ;
	BOOL bAsync ;
	BOOL bAnswering ;
	bAsync = m_RBtnAsync.GetCheck() ? TRUE : FALSE ;
	bAnswering = m_RBtnAnswering.GetCheck() ? TRUE : FALSE ;

	sprintf (temp_msg, "WAN%d - Info", i+1) ;
	if (i < pParent->tabcount)
	{
		sprintf (szLHSPPP, "%s%d%s", "PPP Port", i, 
												" Remote Port Client Only") ;
		GetPrivateProfileString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) szLHSPPP, (LPCSTR) StrNull, (LPSTR) szRHSPPP,
					sizeof (szRHSPPP), 	(LPCSTR) IniInWinForm) ;
		if (szRHSPPP[0])
		{
			if (!strcmpi (szRHSPPP, StrEnabled))
			{
				if (!bAsync)
				{
					::MessageBox (pParent->GetSafeHwnd(),
						"If remote end is 'Client only type'\n \
port should be Asynchronous", temp_msg, MB_OK | MB_ICONINFORMATION) ;
					pParent->m_pdlgWAN[i]->m_RBtnAsync.SetFocus() ;
					return FALSE ;
				}
#if __Sudha__
                if (!bAnswering)
				{
					::MessageBox (pParent->GetSafeHwnd(),
						"If remote end is 'Client only type'\n \
port should be Answering", temp_msg, MB_OK | MB_ICONINFORMATION) ;
					pParent->m_pdlgWAN[i]->m_RBtnAnswering.SetFocus() ;
					return FALSE ;
				}
#endif
			}
		}
	}
    if (pParent->m_pdlgWAN[i]->m_bAGEnable )
	{
		if (pParent->m_pdlgWAN[i]->m_general_name.IsEmpty())
		{
			::MessageBox (GetSafeHwnd(), "Enter the general name since AG is enabled.", 
			temp_msg, MB_OK | MB_ICONINFORMATION) ; 
			pParent->m_pdlgWAN[i]->m_ctrl_general_name.SetFocus() ;
			return FALSE ;
		}

		if (pParent->m_pdlgWAN[i]->m_specific_name.IsEmpty())
		{
			::MessageBox (GetSafeHwnd(), "Enter the specific name since AG is enabled.", 
			temp_msg, MB_OK | MB_ICONINFORMATION) ; 
			pParent->m_pdlgWAN[i]->m_ctrl_specific_name.SetFocus() ;
			return FALSE ;
		}

		sprintf(temp_name,"%s",pParent->m_pdlgWAN[i]->m_general_name) ;

		int index = 0 ;

		if  ( (!isalpha(temp_name[index])) || (!isupper(temp_name[index])))
		{	
			::MessageBox (GetSafeHwnd(), "Enter an uppercase alphabet as the first letter \
for general name.", temp_msg, MB_OK | MB_ICONINFORMATION) ;
			pParent->m_pdlgWAN[i]->m_ctrl_general_name.SetFocus() ;
			return FALSE ;
		}
		index++ ;
		while ( temp_name[index] != '\0' )
		{
			if ( !(__iscsym(temp_name[index])) || (isalpha(temp_name[index]) && !(isupper(temp_name[index]))) )
			{
				::MessageBox (GetSafeHwnd(), "Enter only uppercase alphabets,digits & underscore (A-Z,0-9,_) \
for general name.", temp_msg, MB_OK | MB_ICONINFORMATION) ;
				pParent->m_pdlgWAN[i]->m_ctrl_general_name.SetFocus() ;
				return FALSE ;
			}
			index++ ;
		}

		sprintf(temp_name,"%s",pParent->m_pdlgWAN[i]->m_specific_name) ;

		index = 0 ;

		if  ( (!isalpha(temp_name[index])) || (!isupper(temp_name[index])))
		{	
			::MessageBox (GetSafeHwnd(), "Enter an uppercase alphabet as the first letter \
for specific name.", temp_msg, MB_OK | MB_ICONINFORMATION) ;
			pParent->m_pdlgWAN[i]->m_ctrl_specific_name.SetFocus() ;
			return FALSE ;
		}
		index++ ;
		while ( temp_name[index] != '\0' )
		{
			if ( !(__iscsym(temp_name[index])) || (isalpha(temp_name[index]) && !(isupper(temp_name[index]))) )
			{
				::MessageBox (GetSafeHwnd(), "Enter only uppercase alphabets,digits & underscore (A-Z,0-9,_) \
for specific name.", temp_msg, MB_OK | MB_ICONINFORMATION) ;
				pParent->m_pdlgWAN[i]->m_ctrl_specific_name.SetFocus() ;
				return FALSE ;
			}
			index++ ;
		}

        if (pParent->m_pdlgWAN[i]->m_port_inactivity_timeout < 1 || pParent->m_pdlgWAN[i]->m_port_inactivity_timeout > 50)
        {
            ::MessageBox (GetSafeHwnd(), "Enter an integer value between 1 and 50",
			temp_msg, MB_OK | MB_ICONINFORMATION);
		    pParent->m_pdlgWAN[i]->m_ctrl_port_inactivity_timeout.SetFocus();
		    return FALSE;
	    }
	}

	if ((m_idle_time < 1) || (m_idle_time > 500))
	{
		::MessageBox (pParent->GetSafeHwnd(), "Enter an integer value between 1 and 500",
		temp_msg, MB_OK | MB_ICONINFORMATION);
		pParent->m_pdlgWAN[i]->m_ctrl_idle_time.SetFocus();
		return FALSE;
	}
	i = 0;
	if (!m_active_hosts.IsEmpty())
	{
		strcpy (szLHSPPP, m_active_hosts);
		while (szLHSPPP[i])
		{
			if ((szLHSPPP[i] < '0') || (szLHSPPP[i] > '9'))
			{
				::MessageBox (pParent->GetSafeHwnd(), "Enter an integer value",
				temp_msg, MB_OK | MB_ICONINFORMATION);
				pParent->m_pdlgWAN[i]->m_ctrl_active_ip_hosts.SetFocus();
				return FALSE;
			}
			i++;
		}
	}
	return TRUE ;
}

// Brindha on 28/4/99.
BOOL CWanPortDlg::ValidCheckBtns()
{
	CWanTab *pParent = (CWanTab *) GetParent() ;
	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}

	BOOL fAnswering = pParent->m_pdlgWAN[i]->m_RBtnAnswering.GetCheck() ;
	BOOL fDialAnswer = pParent->m_pdlgWAN[i]->m_ctrl_dial_answer.GetCheck() ;
	BOOL fDirConnect = pParent->m_pdlgWAN[i]->m_chkBtnDirConnect.GetCheck() ;
	char temp_msg[20] ;
	sprintf (temp_msg, "WAN%d - Info", i+1) ; 

	if (fDirConnect && !fAnswering && !fDialAnswer)
	{
		if (pParent->m_pdlgWAN[i]->m_bProxyEnable && pParent->m_pdlgWAN[i]->m_bAGEnable)
		{
			::MessageBox (GetSafeHwnd(), "For Direct Connect either Proxy or Ag can be enabled and not both.",
			temp_msg, MB_OK | MB_ICONINFORMATION) ;
			pParent->m_pdlgWAN[i]->m_ctrl_proxy_enable.SetFocus() ;
			return FALSE ;
		}
	}
	if (!m_bProxyEnable && !m_bAGEnable && !m_bRasEnable)
	{
		::MessageBox (GetSafeHwnd(), " For Dial Out, Proxy or AG can be enabled.\n \
For Dial In, RAS can be enabled.\n \
For Dial Out/In, Proxy or AG or RAS can be enabled.",
		temp_msg, MB_OK | MB_ICONINFORMATION) ;
		pParent->m_pdlgWAN[i]->m_ctrl_proxy_enable.SetFocus() ;
		return FALSE ;		
	}
	if ((m_bProxyEnable && m_bAGEnable) || (m_bProxyEnable && m_bRasEnable) 
	   	 || (m_bProxyEnable && m_bAGEnable && m_bRasEnable))  
	{
		if (!m_link_ctrl_enabled.GetCheck())
		{
			::MessageBox (GetSafeHwnd(), " If AG or RAS is enabled along with Proxy\n \
then Link Control should be enabled.", 
	 		temp_msg, MB_OK | MB_ICONINFORMATION) ;
	 	
	     	pParent->m_pdlgWAN[i]->m_link_ctrl_enabled.SetFocus() ;
	     	return FALSE ;	
		}
	}
	if ((fDialAnswer && !m_bRasEnable) || (fDialAnswer && !m_bProxyEnable && !m_bAGEnable))
	{
		::MessageBox (GetSafeHwnd(), "For Dial Out / In,\n \
     Proxy & Ras\n \
     AG & Ras\n \
     Proxy, AG & Ras\n \
     are the allowed combinations.", 
		temp_msg, MB_OK | MB_ICONINFORMATION) ;
		pParent->m_pdlgWAN[i]->m_ctrl_ras_enable.SetFocus() ;
		return FALSE ;		
	}
	return TRUE ;
}

void CWanPortDlg::OnCheckDirConnect()
{
	// TODO: Add your control notification handler code here

// brindha on 28/4/99.
// By default enabling DialOut & Proxy.

	m_RBtnDialling.SetCheck(1) ;
	m_RBtnAnswering.SetCheck(0) ;
	m_ctrl_dial_answer.SetCheck(0) ;
	m_ctrl_proxy_enable.SetCheck(1) ;
    m_ctrl_ag_enable.SetCheck(0) ;
	m_ctrl_ras_enable.SetCheck(0) ;

	OnControl() ;
}


void CWanPortDlg::OnBtnScript()
{
	// TODO: Add your control notification handler code here

	CWanTab *pParent = (CWanTab *) GetParent() ;

	for (UINT i = 0 ; i < pParent->m_nPort ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}
	CScriptDlg CScript ;
	CScript.m_nPortNum = (int)i ;
	CScript.DoModal() ;
}


LRESULT CWanPortDlg::OnSwitchToIden (WPARAM wParam, LPARAM lParam)
{
	UpdateData (TRUE) ;

    CWanTab *pParent = (CWanTab *) GetParent() ;
	for (int nPort = 0 ; nPort < pParent->tabcount ; nPort ++)
	{
		if (pParent->m_pdlgWAN[nPort] == this)
		{
			break ;
		}
	}
#if 0
	if (pParent->m_pdlgWAN[nPort]->m_RBtnAsync.GetCheck() && pParent->m_bAG && (!pParent->m_pdlgWAN[nPort]->m_RBtnDialling.GetCheck()))
		pParent->GrayAGControls (FALSE, nPort) ;
	else
		pParent->GrayAGControls (TRUE, nPort) ;

	if (bAGEnable == 0)
		pParent->GrayAGControls (TRUE, nPort) ;
#endif	
	return 0L ;
}

int CWanPortDlg::GetMyID (void)
{
	CWanTab *parent = (CWanTab *)GetParent();
	int tabcount = parent->tabcount;
	
	for (int index = 0 ; index < tabcount ; index ++)
	{
			if (parent->m_pdlgWAN[index] == this)
			{
				return (index);
			}
	}
	return -1;
}

void CWanPortDlg::OnRadioIsdn()
{
	// TODO: Add your control notification handler code here
	int Id;

	Id = GetMyID();
	m_RBtnModem.SetCheck(0);
	m_RBtnIsdn.SetCheck(1);
/* Sudha 04 Nov 1998.... */
	m_ctrl_isdn_str.ShowWindow(SW_SHOW);
	m_ctrl_isdn_str.EnableWindow(TRUE);
	m_stat_isdn_str.ShowWindow(SW_SHOW);
	m_StatModemTypes.ShowWindow(SW_HIDE);
	m_ComBoxModemTypes.ShowWindow(SW_HIDE);
	m_ComBoxModemTypes.EnableWindow(FALSE);
/* ....Sudha 04 Nov 1998 */
	OnControl();
	
	GetIsdnTypes(Id);	
	
	
}

void CWanPortDlg::OnRadioModem()
{
	// TODO: Add your control notification handler code here
	int Id;

	Id = GetMyID();
	m_RBtnIsdn.SetCheck (0) ;
	m_RBtnModem.SetCheck (1) ;
/* Sudha 04 Nov 1998.... */
	m_ctrl_isdn_str.ShowWindow(SW_HIDE);
	m_ctrl_isdn_str.EnableWindow(FALSE);
	m_stat_isdn_str.ShowWindow(SW_HIDE);
	m_StatModemTypes.ShowWindow(SW_SHOW);
	m_ComBoxModemTypes.ShowWindow(SW_SHOW);
	m_ComBoxModemTypes.EnableWindow(TRUE);
/* ....Sudha 04 Nov 1998 */

// Brindha on 28/4/99.
// By default enabling DialOut/In, Proxy, AG & RAS.

	m_RBtnDialling.SetCheck(0) ;
	m_RBtnAnswering.SetCheck(0) ;
	m_ctrl_dial_answer.SetCheck(1) ;
	m_ctrl_proxy_enable.SetCheck(1) ;
	m_ctrl_ag_enable.SetCheck(1) ;
	m_ctrl_ras_enable.SetCheck(1) ;

	OnControl();
	
	GetTypesofmodems(Id);
	
}

void CWanPortDlg::GetIsdnTypes (int j)
{
	char strLHS[40],strRHS[40],buffer[512];
	char token[40];
	char seps = '\0';
	int length = 0;
	int total;
	CString szDefaultConfig;
	int k;
	
	CWanTab *parent = (CWanTab *)GetParent();

	for (k = 0; k < parent->tabcount; k++ )
	{
		if ( j == k )
			break;
	}
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.ResetContent();

	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
	 	if ( parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, strRHS ) == CB_ERR )
	 	{
	 		// Insert the string in the list box
/* Sudha 9 June 1998 */
         if (( model == MODEL_MTSR1_202ST) ||
            (( model == MODEL_MTSR1_202NT ) && (strstr ( strRHS,"USA") != NULL)) ||
            (( model == MODEL_MTSR2_201 ) && (j == 1)))
   	 		parent->m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( strRHS );
	 	}
	 	strLHS[6]++;
   }
 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	while ( total > 0 )
	{
		strcpy ( token,&buffer[length]);
      if ( parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, token ) == CB_ERR )
	        {
	       	   // Insert the string in the list box
		   parent->m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( token );
		}	

 	        length = length + strlen ( token ) + 1;	// +1 for the NULL character
		total = total - ( strlen ( token ) + 1 ) ;
	      //token = strtok( &buffer[length], seps );
	      //token = strchr( &buffer[length], seps );
	      //strcpy(token,&buffer[length]);
		//}
	}
/* Sudha 04 Nov 1998.... */	
	sprintf ( strLHS,"ISDN Port%d Extra Initialization String8",j);
	GetPrivateProfileString ( WANSectionHeader, strLHS,
		StrNull,strRHS,sizeof(strRHS),IniInWinForm );
	parent->m_pdlgWAN[k]->m_isdn_str = strRHS ;
/* ....Sudha 04 Nov 1998 */	
	
	sprintf ( strLHS,"ISDN WAN Port%d ConfigName",j);
	GetPrivateProfileString ( WANSectionHeader, strLHS,
		StrNull,strRHS,sizeof(strRHS),IniInWinForm );
	if ( strcmp ( strRHS,StrNull ) == 0 )
		strcpy ( strRHS,"USA_5ESS");
	int nsel;
	nsel = parent->m_pdlgWAN[k]->m_ComBoxModemTypes	.FindStringExact(-1,strRHS );
	/*	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.SetCurSel (
                parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact(
                -1,strRHS)); */
	if (nsel == CB_ERR )
	   nsel = 0;
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.SetCurSel ( nsel );
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.GetLBText (nsel,parent->m_pdlgWAN[k]->m_szSectionName );
	//parent->m_pdlgWAN[k]->m_ComBoxModemTypes.GetWindowText (parent->m_pdlgWAN[k]->m_szPPINISection );
/* sudha 14 nov 1998 */
	if (model == MODEL_MTSR2_201 && j == 1)		
	{		
		parent->m_advdlgWAN->m_nSelectedIsdn = m_ComBoxModemTypes.GetCurSel();
		parent->m_advdlgWAN->m_INISectionControl.SetCurSel (parent->m_advdlgWAN->m_nSelectedIsdn);
	}			


}

void CWanPortDlg::GetTypesofmodems(int k)
{
	char szFilePath[200] ; // For MODEMS.CNF File
	char strLHS[40],strRHS[40];
	char szBlankBackSlash[100] ;

	CWanTab *parent = (CWanTab *) GetParent();

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;
	
	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetParent()->GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
				"Warning - File not found", MB_OK) ;
		return ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetParent()->GetSafeHwnd(),
			"Invalid MODEMS.CNF file", "Warning", MB_OK) ;
		return ;
	} 

	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;
	MODEM_SETUP ModemSetup ;
	int i ;

	for ( i = 0 ; i < parent->tabcount ; i++)
	{
		if ( i == k )
			break;
	}
	
	parent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent();

	while (TRUE)
	{
		if (fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) < 1)
			break ;
		if (strcmp (ModemSetup.ModemType, "Direct Connection") == 0)
			continue ;
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (ModemSetup.ModemType) ;
	}

	fclose (fModemsPtr) ;
	sprintf(strLHS, "WAN Port%d Modem Type",i) ;
   GetPrivateProfileString (WANSectionHeader,  
	   strLHS,StrNull,strRHS, sizeof (strRHS),  
  	     (LPCSTR) IniInWinForm) ;  
   int nToSel ;
	if (strRHS[0])
  	{
		ConvertBackSlashesToBlanks (szBlankBackSlash, strRHS) ;
		nToSel = 
			parent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1,
			szBlankBackSlash) ;
		if (nToSel == CB_ERR)
			nToSel = 0 ;
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nToSel) ;
	}
	else
	{
      nToSel = 0;
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel(nToSel);
	}

/* sudha 14 nov 1998 */
	if (model != MODEL_MTSR2_201 && k == 0)		
	{
		parent->m_advdlgWAN->m_nSelectedModem = m_ComBoxModemTypes.GetCurSel();
		parent->m_advdlgWAN->m_combBoxModemTypes.SetCurSel(parent->m_advdlgWAN->m_nSelectedModem);
	}
	else if (model == MODEL_MTSR2_201 && k == 1)
	{
		parent->m_advdlgWAN->m_nSelectedModem = m_ComBoxModemTypes.GetCurSel();
		parent->m_advdlgWAN->m_combBoxModemTypes.SetCurSel(parent->m_advdlgWAN->m_nSelectedModem);
	}

	return ;
}

void CWanPortDlg::OnCheckLinkCtrlEnable()
{
	// TODO: Add your control notification handler code here
	
	BOOL check; 
	char szBuf[80] ;

	CWanTab *pParent = (CWanTab *) GetParent() ;
	for (UINT i = 0 ; i < pParent->m_nPort ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}

	m_ctrl_link_usage_ctrl.EnableWindow (TRUE);

	if (!m_link_ctrl_enabled.GetCheck())
		check = FALSE;
	else
		check = TRUE;
	m_ctrl_static_idle_time.EnableWindow (check);
	m_ctrl_idle_time.EnableWindow (check);
	m_ctrl_minutes.EnableWindow (check);
	m_static_bring_up.EnableWindow (check);
	m_ctrl_static_active_connections.EnableWindow (check);
	m_ctrl_active_connections.EnableWindow (check);
	m_ctrl_static_ip_hosts.EnableWindow (check);
	m_ctrl_active_ip_hosts.EnableWindow (check);
	m_static_list_host.EnableWindow (check);
	m_list_host.EnableWindow (check);
	m_ctrl_host.EnableWindow (check);
	m_ctrl_add.EnableWindow (check);
	m_ctrl_delete.EnableWindow (check);

// brindha checking for MLPP enabled.
    GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
		StrNull, szBuf, sizeof(szBuf), IniInWinForm);

	if (i == 0 || szBuf[0])
	{
		m_static_bring_up.EnableWindow (FALSE);
		m_ctrl_static_active_connections.EnableWindow (FALSE);
		m_ctrl_active_connections.EnableWindow (FALSE);
		m_ctrl_static_ip_hosts.EnableWindow (FALSE);
		m_ctrl_active_ip_hosts.EnableWindow (FALSE);
		m_static_list_host.EnableWindow (FALSE);
		m_list_host.EnableWindow (FALSE);
		m_ctrl_host.EnableWindow (FALSE);
		m_ctrl_add.EnableWindow (FALSE);
		m_ctrl_delete.EnableWindow (FALSE);
	}	
}

void CWanPortDlg::OnButtonAdd()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE);
	if (m_host.IsEmpty())
	{
		::MessageBox (GetSafeHwnd(), "Enter the host address", (LPSTR) WANSectionHeader, MB_OK);
		m_ctrl_host.SetFocus();
		return;
	}

	if (!m_host.IsValid())
	{
		::MessageBox (GetSafeHwnd(), "Invalid Host Address", (LPSTR) WANSectionHeader, MB_OK);
		m_ctrl_host.SetFocus();
		return;
	}

	CString buf;
	unsigned long addr1, addr2;
	get_ip_address (m_host, &addr1);
	for (int index = 0; index < m_list_host.GetCount(); index++)
	{
		m_list_host.GetText (index, buf);
		get_ip_address (buf, &addr2);
		if (addr1 == addr2)
		{
			::MessageBox (GetSafeHwnd(), "Addresses should be unique",
				"WAN - Info", MB_OK | MB_ICONINFORMATION);
			m_ctrl_host.SetFocus();
			return;
		}
	}

	m_list_host.AddString (m_host);
	m_host.Empty();
	UpdateData (FALSE);
}

void CWanPortDlg::OnButtonDelete()
{
	// TODO: Add your control notification handler code here
	if (m_list_host.GetCurSel() == CB_ERR)
		return;
	else
		m_list_host.DeleteString (m_list_host.GetCurSel());
	UpdateData (FALSE);
}

/////////////////////////////////////////////////////////////////////////////
// CWanTab dialog


CWanTab::CWanTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(CWanTab::IDD, pParent)
{

//{{AFX_DATA_INIT(CWanTab)
		// NOTE: the ClassWizard will add member initialization here
		m_nPort = 3 ;
	//}}AFX_DATA_INIT

	// Get the UINT parameter
	m_nPort = GetPrivateProfileInt(WANSectionHeader,
				(LPCSTR) "WAN Number of Ports",0,
								(LPCSTR) IniInWinForm);
	if (m_nPort < 1 || m_nPort > 3)
		m_nPort = 3 ;

	tabcount = m_nPort ;
	
	// Limit the tabcount
	if (tabcount > n_PORTMAX_WAN)
		tabcount = n_PORTMAX_WAN ;
	if (tabcount < 1)
		tabcount = 1 ;

	for (int i = 0 ; i < tabcount ; i++)
		m_pdlgWAN [i] = new CWanPortDlg (this);
	m_advdlgWAN = new CWANDlg (this);
}

void CWanTab::DoDataExchange(CDataExchange* pDX)
{
	CTabDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanTab, CTabDialog)
	//{{AFX_MSG_MAP(CWanTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanTab message handlers
void CWanTab::GetConfig()
{
	char szBuf[80] ;
	BOOL fAsync, fIntClk, fAnswering, fdialanswer, fDirConnect;
   // Get all the parameters for Ports
   // Get the BOOL parameters.      
   char field[80], StrLHS[40] ;
   int dial_in_out_type ;
   int function_type ;

   GetTabsRectDim() ;
	
/* sudha 13 nov 1998 */
	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
		(LPCSTR) "AG", (LPCSTR) StrNull, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		bAGEnable = 1 ;
	else
		if (strcmp (szBuf, StrDisabled) == 0)
			bAGEnable = 0 ;
/* sudha 13 nov 1998 */

   for (int i = 0 ; i < tabcount ; i ++)
   {
		char Buf[12] ;
		_itoa (i, Buf, 10) ;
		
		strcpy (field, "WAN Port") ;
		strcat (field, Buf) ;
		strcpy (Buf, field) ;
		GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) IniInWinForm) ;
   	if (!strcmp (szBuf, StrEnabled))
   		m_pdlgWAN[i]->m_WANPort = TRUE ;
	  	else
	   	m_pdlgWAN[i]->m_WANPort = FALSE ;

      strcpy (field, Buf) ;
      strcat (field, " Async") ;
      GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;

      // Modified here by cfp on 25-3-96
      if (!strcmp (szBuf, StrEnabled))
	   {
			m_pdlgWAN[i]->m_RBtnAsync.SetCheck (1) ;
         m_pdlgWAN[i]->m_RBtnSync.SetCheck (0) ;
			fAsync = TRUE ;
	   }
	   else
	   {
			m_pdlgWAN[i]->m_RBtnAsync.SetCheck (0) ;
         m_pdlgWAN[i]->m_RBtnSync.SetCheck (1) ;
			fAsync = FALSE ;
	   } 
	 
      strcpy (field, Buf) ;
	   strcat (field, " Internal Clock") ;
	   GetPrivateProfileString(WANSectionHeader,
				(LPCSTR) field, StrDisabled,(LPSTR) szBuf, sizeof(szBuf),
		   			(LPCSTR) IniInWinForm) ;
	   if (!strcmpi (szBuf, StrEnabled))
	   {
			m_pdlgWAN[i]->m_RBtnExtClk.SetCheck (0) ;
	  		m_pdlgWAN[i]->m_RBtnIntClk.SetCheck (1) ;
			fIntClk = TRUE ;
      }
	   else
	   {
			m_pdlgWAN[i]->m_RBtnExtClk.SetCheck (1) ;
	  		m_pdlgWAN[i]->m_RBtnIntClk.SetCheck (0) ;
			fIntClk = FALSE ;
      }

		strcpy (field, Buf) ;
		strcat (field, " Send Idle Flags") ;
		GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) IniInWinForm) ;
		if (!strcmp (szBuf, StrEnabled))
			m_pdlgWAN[i]->m_chkboxIdleFlags.SetCheck (1) ;
		else
			m_pdlgWAN[i]->m_chkboxIdleFlags.SetCheck (0) ;

		strcpy (field, Buf) ;
		strcat (field, " Script") ;
		GetPrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) field, (LPCSTR) StrDisabled, (LPSTR) szBuf,
					sizeof (szBuf), (LPCSTR) IniInWinForm) ;
		if (strcmp (szBuf, StrEnabled) == 0)
			m_pdlgWAN[i]->m_bScriptEnable = TRUE ;
		else
			m_pdlgWAN[i]->m_bScriptEnable = FALSE ;
        
		strcpy (field, Buf) ;
		strcat (field, " Restart Script On Comm Failure") ;
		GetPrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) field, (LPCSTR) StrDisabled, (LPSTR) szBuf,
					sizeof (szBuf), (LPCSTR) IniInWinForm) ;
		if (strcmp (szBuf, StrEnabled) == 0)
			m_pdlgWAN[i]->m_bRestartScriptOnCommFailure = TRUE ;
		else
			m_pdlgWAN[i]->m_bRestartScriptOnCommFailure = FALSE ;

      strcpy (field, Buf) ;
      strcat (field, " Direct Connect") ;
      GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	   if (!strcmp (szBuf, StrEnabled)) 
			m_pdlgWAN[i]->m_bDirConnect = TRUE ;
	   else  
			m_pdlgWAN[i]->m_bDirConnect = FALSE ;

		fDirConnect = m_pdlgWAN[i]->m_bDirConnect;
// brindha on 29/4/99.
		if (fDirConnect)
			m_pdlgWAN[i]->m_ctrl_dial_answer.EnableWindow (FALSE) ;	
		
/* sudha 13 nov 1998 */
	   strcpy (field, Buf) ;
  	   strcat (field, " DialInOut Type") ;

// brindha modified on 29/4/99.   	
	   GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
					StrNull, szBuf, sizeof(szBuf), IniInWinForm);

	   dial_in_out_type = GetPrivateProfileInt (WANSectionHeader,
			(LPCSTR) field, 0, (LPCSTR) IniInWinForm) ;

	   if (szBuf[0])
	   		DialOutProxyOnly (i) ;		
	   else
	   		CheckDialInOutType (i, dial_in_out_type) ;

	   strcpy (field, Buf) ;
	   strcat (field, " Function Type") ;
	   function_type = GetPrivateProfileInt (WANSectionHeader,
			(LPCSTR) field, 1, (LPCSTR) IniInWinForm) ;
 
	   if (!szBuf[0])
	   		CheckFunctionType (i, function_type) ;
	   
/* sudha made changes here for all ports to be dial in or dial out ports.*/
#if 0
		if (i == 0)
		{
			m_pdlgWAN[i]->m_RBtnAnswering.SetCheck (0) ;
			m_pdlgWAN[i]->m_RBtnDialling.SetCheck (1) ;
			m_pdlgWAN[i]->m_RBtnAnswering.EnableWindow (FALSE);
			m_pdlgWAN[i]->m_RBtnDialling.EnableWindow (FALSE);
			fAnswering = FALSE ;
		}
#endif		
      // Get the CString parameters.
	   strcpy (field, Buf) ;
      strcat (field, " Speed") ;
	   GetPrivateProfileString (WANSectionHeader,
	   	(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),
		     (LPCSTR) IniInWinForm) ;

	   m_pdlgWAN[i]->m_cboxAsyncBaud = szBuf ;
	   m_pdlgWAN[i]->m_OldSpeedStr = szBuf ;

/* Sudha 04 Nov 1998.... */
		wsprintf (field, "ISDN Port%d Extra Initialization String8", i);
      GetPrivateProfileString (WANSectionHeader,  
	 		(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),  
		     (LPCSTR) IniInWinForm) ;  
		m_pdlgWAN[i]->m_isdn_str = szBuf;
/* Sudha 04 Nov 1998.... */

		int nToSelect ;
		if (model != MODEL_MTSR3_200)
		{
			wsprintf (field, "ISDN WAN Port%d", i);
      	GetPrivateProfileString (WANSectionHeader,  
	 	   	(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),  
		      	  (LPCSTR) IniInWinForm) ;  
	      if (!strcmp (szBuf, StrEnabled)) 
		   {
				m_pdlgWAN[i]->m_RBtnIsdn.SetCheck (1) ;
				m_pdlgWAN[i]->m_RBtnModem.SetCheck (0) ;
/* sudha 04 Nov 1998.... */
				m_pdlgWAN[i]->m_stat_isdn_str.ShowWindow (SW_SHOW);
				m_pdlgWAN[i]->m_ctrl_isdn_str.ShowWindow (SW_SHOW);
/* ....sudha 04 Nov 1998 */

/* Sudha 8 June 1998 */	  
            ReadISDNInfoFromRouconIniToIsdntaIni(i);
				m_pdlgWAN[i]->GetIsdnTypes (i);
		   }
	   	else 
		   {
				m_pdlgWAN[i]->m_RBtnIsdn.SetCheck (0) ;
				m_pdlgWAN[i]->m_RBtnModem.SetCheck (1) ;
/* sudha 04 Nov 1998.... */
			m_pdlgWAN[i]->m_stat_isdn_str.ShowWindow (SW_HIDE);
			m_pdlgWAN[i]->m_ctrl_isdn_str.ShowWindow (SW_HIDE);
/* ....sudha 04 Nov 1998 */
				m_pdlgWAN[i]->GetTypesofmodems(i) ;
			  	char szBlankBackSlash[100] ;
			   strcpy (field, Buf) ;
			  	strcat (field, " Modem Type") ;
	   		GetPrivateProfileString (WANSectionHeader,  
 	   			(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),  
		     		  (LPCSTR) IniInWinForm) ;  
			   if (szBuf[0])
			   {
					ConvertBackSlashesToBlanks (szBlankBackSlash, szBuf) ;
					nToSelect = 
						m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1,
																			szBlankBackSlash) ;
					if (nToSelect == CB_ERR)
						nToSelect = 0 ;
					m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nToSelect) ;
				}
			}
		}
		else
		{
			m_pdlgWAN[i]->m_RBtnIsdn.ShowWindow (SW_HIDE);
			m_pdlgWAN[i]->m_RBtnModem.ShowWindow (SW_HIDE);
/* sudha 04 Nov 1998.... */
			m_pdlgWAN[i]->m_stat_isdn_str.ShowWindow (SW_HIDE);
			m_pdlgWAN[i]->m_ctrl_isdn_str.ShowWindow (SW_HIDE);
/* ....sudha 04 Nov 1998 */
			m_pdlgWAN[i]->GetTypesofmodems(i) ;
		  	char szBlankBackSlash[100] ;
		   strcpy (field, Buf) ;
		  	strcat (field, " Modem Type") ;
	   	GetPrivateProfileString (WANSectionHeader,  
 	   		(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),  
	     		  (LPCSTR) IniInWinForm) ;  
		   if (szBuf[0])
		   {
				ConvertBackSlashesToBlanks (szBlankBackSlash, szBuf) ;
				nToSelect = 
					m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1,
																			szBlankBackSlash) ;
				if (nToSelect == CB_ERR)
					nToSelect = 0 ;
				m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nToSelect) ;
			}
	   } 

		m_pdlgWAN[i]->m_cboxAsyncBaudWnd.EnableWindow (fAsync) ;
		m_pdlgWAN[i]->m_cboxSyncIntClkWnd.EnableWindow (!fAsync && fIntClk) ;
		m_pdlgWAN[i]->m_RBtnIntClk.EnableWindow (!fAsync ) ;
		m_pdlgWAN[i]->m_RBtnExtClk.EnableWindow (!fAsync) ; 
		m_pdlgWAN[i]->m_BaudHeader.EnableWindow (fAsync) ;
		m_pdlgWAN[i]->m_ClkSpeedHdr.EnableWindow (!fAsync && fIntClk) ;
		/* chetan 9/7/97 */
		m_pdlgWAN[i]->m_ScriptEnableWnd.EnableWindow (fAsync && !fDirConnect && m_pdlgWAN[i]->m_bProxyEnable) ;
		m_pdlgWAN[i]->m_RestartScriptWnd.EnableWindow (fAsync && !fDirConnect && m_pdlgWAN[i]->m_bProxyEnable) ;
		m_pdlgWAN[i]->m_BtnScript.EnableWindow (RouterStatus && fAsync && !fDirConnect && m_pdlgWAN[i]->m_bProxyEnable) ;
		/* chetan 9/7/97 */

//		m_pdlgWAN[i]->m_RBtnModem.SetCheck(1);		
		m_pdlgWAN[i]->m_StatModemTypes.EnableWindow (fAsync && 
													!m_pdlgWAN[i]->m_bDirConnect) ;
		m_pdlgWAN[i]->m_ComBoxModemTypes.EnableWindow (fAsync && 
													!m_pdlgWAN[i]->m_bDirConnect) ;
		m_pdlgWAN[i]->m_chkboxIdleFlags.EnableWindow (!fAsync) ;

		// Added by cfp on 26-3-96
		strcpy (field, Buf) ;
		strcat (field, " Synchronous Speed") ;
		GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) StrNull, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
		m_pdlgWAN[i]->m_cboxSyncIntClk = szBuf ;

		if (model == MODEL_MTSR2_201)
		{
			m_pdlgWAN[i]->m_cboxSyncIntClkWnd.EnableWindow(FALSE);
			m_pdlgWAN[i]->m_ClkSpeedHdr.EnableWindow(FALSE);
		}

		////Prabha, 19/2/98
		BOOL linkcontrol;
		char prefix_alphabet = 65;
		char *ch;
		int tempnum, index, entrynum = 0, prefix_num = 0;
		wsprintf (field, "PPP Port%d Connection Dial On Demand", i);
		GetPrivateProfileString ((LPCSTR) PPPSectionHeader, 
			(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
				(LPCSTR) IniInWinForm);
		if ((!strcmp (szBuf, StrEnabled)) && !m_pdlgWAN[i]->m_bDirConnect)
		{
			linkcontrol = TRUE;
			m_pdlgWAN[i]->m_ctrl_link_usage_ctrl.EnableWindow (TRUE);
			m_pdlgWAN[i]->m_link_ctrl_enabled.SetCheck (1);
			m_pdlgWAN[i]->m_link_ctrl_enabled.EnableWindow (TRUE);
			m_pdlgWAN[i]->m_ctrl_idle_time.EnableWindow (TRUE);
			m_pdlgWAN[i]->m_ctrl_minutes.EnableWindow (TRUE);
			m_pdlgWAN[i]->m_ctrl_static_idle_time.EnableWindow (TRUE);
		}
		else
		{
			linkcontrol = FALSE;
			m_pdlgWAN[i]->m_link_ctrl_enabled.SetCheck (0);

// modified by brindha on 29/4/99.
			if (m_pdlgWAN[i]->m_bDirConnect || ((m_pdlgWAN[i]->m_bAGEnable || m_pdlgWAN[i]->m_bRasEnable)
				&& !m_pdlgWAN[i]->m_bProxyEnable))
			{
				m_pdlgWAN[i]->m_ctrl_link_usage_ctrl.EnableWindow (FALSE);
				m_pdlgWAN[i]->m_link_ctrl_enabled.EnableWindow (FALSE);
			}
			else
			{
				m_pdlgWAN[i]->m_ctrl_link_usage_ctrl.EnableWindow (TRUE);
				m_pdlgWAN[i]->m_link_ctrl_enabled.EnableWindow (TRUE);
			}
			m_pdlgWAN[i]->m_ctrl_idle_time.EnableWindow (FALSE);
			m_pdlgWAN[i]->m_ctrl_minutes.EnableWindow (FALSE);
			m_pdlgWAN[i]->m_ctrl_static_idle_time.EnableWindow (FALSE);
		}

		wsprintf (field, "PPP Port%d Connection Idle Timer", i);
		tempnum = GetPrivateProfileInt ((LPCSTR) PPPSectionHeader, 
			(LPCSTR) field, 0, (LPCSTR) IniInWinForm);
		m_pdlgWAN[i]->m_idle_time = tempnum / 60;
		if (i !=	0)
		{
			wsprintf (field, "Proxy Server Number of Connections to Trigger Port%d", i+1); 
			m_pdlgWAN[i]->m_active_connections = GetPrivateProfileInt ((LPCSTR) ProxySectionHeader, 
				(LPCSTR) field, 0, (LPCSTR) IniInWinForm);
			wsprintf (field, "Proxy Server Number of Hosts to Trigger Port%d", i+1); 
			GetPrivateProfileString ((LPCSTR) ProxySectionHeader,	(LPCSTR) field, 
					StrNull, szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm);
			m_pdlgWAN[i]->m_active_hosts = szBuf;

			wsprintf (field, "Proxy Server Port%d Number of Privileged Users", i+1); 
			tempnum = GetPrivateProfileInt ((LPCSTR) ProxySectionHeader,
				(LPCSTR) field, 0, (LPCSTR) IniInWinForm);
			for (index = 0; index < tempnum; index++)
			{
				wsprintf (field, "$%c%dProxy Server Port%d Privileged User List", prefix_alphabet, prefix_num, i+1);
				GetPrivateProfileString ((LPCSTR) ProxySectionHeader, (LPCSTR) field,
					"10000", szBuf, sizeof (szBuf), IniInWinForm);
				while (strcmp (szBuf, "10000"))
				{
					while ((ch = strchr (szBuf, (int)',')) != NULL)
					{
						*ch = '\0';
						m_pdlgWAN[i]->m_list_host.AddString (szBuf);
						strcpy (szBuf, ++ch);
					}
					m_pdlgWAN[i]->m_list_host.AddString (szBuf);
					prefix_alphabet++;
					if (prefix_alphabet > 90)
					{
						prefix_num++;
						prefix_alphabet = 65;
					}
					wsprintf (field, "$%c%dProxy Server Port%d Privileged User List", prefix_alphabet, prefix_num, i+1);
					GetPrivateProfileString ((LPCSTR) ProxySectionHeader, (LPCSTR) field,
						"10000", szBuf, sizeof (szBuf), IniInWinForm);
				}
			}
		}
		////If MLPPP is enabled, grey out the link control entries
		if (i)
		{
			GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
					StrNull, szBuf, sizeof(szBuf), IniInWinForm);
#if 0 /* Sudha 27 July 1998 */

			if (szBuf[0])
			{
				m_pdlgWAN[i]->m_ctrl_link_usage_ctrl.EnableWindow (FALSE);
				m_pdlgWAN[i]->m_link_ctrl_enabled.SetCheck (0);
				m_pdlgWAN[i]->m_link_ctrl_enabled.EnableWindow (FALSE);
				m_pdlgWAN[i]->m_ctrl_idle_time.EnableWindow (FALSE);
				m_pdlgWAN[i]->m_ctrl_minutes.EnableWindow (FALSE);
				m_pdlgWAN[i]->m_ctrl_static_idle_time.EnableWindow (FALSE);
			}
#endif  /* Sudha 27 July 1998 */
		}
		if ((i == 0) || (szBuf[0]) || (m_pdlgWAN[i]->m_bDirConnect) || (!m_pdlgWAN[i]->m_bProxyEnable))
			linkcontrol = FALSE;
		else
			linkcontrol = TRUE;
		m_pdlgWAN[i]->m_static_bring_up.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_ctrl_static_active_connections.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_ctrl_active_connections.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_ctrl_static_ip_hosts.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_ctrl_active_ip_hosts.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_static_list_host.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_list_host.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_ctrl_host.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_ctrl_add.EnableWindow (linkcontrol);
		m_pdlgWAN[i]->m_ctrl_delete.EnableWindow (linkcontrol);
//		m_pdlgWAN[i]->m_ctrl_link_usage_ctrl.EnableWindow (linkcontrol);


		if (model == MODEL_MTSR2_201)
		{
			if (i == 0)
			{
				m_pdlgWAN[i]->m_RBtnModem.ShowWindow (SW_HIDE);
				m_pdlgWAN[i]->m_RBtnIsdn.ShowWindow (SW_HIDE);
/* sudha 04 Nov 1998.... */
				m_pdlgWAN[i]->m_stat_isdn_str.ShowWindow (SW_HIDE);
				m_pdlgWAN[i]->m_ctrl_isdn_str.ShowWindow (SW_HIDE);
/* ....sudha 04 Nov 1998 */
				m_pdlgWAN[i]->m_StatModemTypes.ShowWindow (SW_HIDE);
				m_pdlgWAN[i]->m_ComBoxModemTypes.ShowWindow (SW_HIDE);
	         m_pdlgWAN[i]->m_RBtnSync.EnableWindow (0) ;
	         m_pdlgWAN[i]->m_RBtnAsync.EnableWindow (0) ;
			}
		}
		if (model == MODEL_MTSR3_200)
	      m_pdlgWAN[i]->m_RBtnSync.EnableWindow (0) ;

		m_pdlgWAN[i]->m_ctrl_active_ip_hosts.LimitText (5);
 		m_pdlgWAN[i]->m_ctrl_isdn_str.LimitText (40) ;


        // brindha on 29/4/99. 

	    ProcessAGStrings (i) ;

        if (m_pdlgWAN[i]->m_bAGEnable)
			GrayAGControls (FALSE, i) ;
		else
			GrayAGControls (TRUE, i) ;
				
        // Update the Dialog fields  
		m_pdlgWAN[i]->UpdateData (FALSE) ;

	}	
	
}

BOOL CWanTab::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	
	char Buf[4][16] ;
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	switch (tabcount)
	{
	case 1:
		strcpy (Buf[0], " &WAN ") ;
		strcpy (Buf[1], " &Advanced ") ;
		break;
	case 2:
		strcpy (Buf[0], "WAN  &1(DSU)") ;
		strcpy (Buf[1], "WAN  &2") ;
		strcpy (Buf[2], " &Advanced ") ;
		break;
	case 3:
		strcpy (Buf[0], "WAN  &1") ;
		strcpy (Buf[1], "WAN  &2") ;
		strcpy (Buf[2], "WAN  &3") ;
		strcpy (Buf[3], " &Advanced ") ;
		break;
	default:
		break;		
	}

	// Add the Tabs
	for (int i = 0 ; i < tabcount ; i ++)
		addTabView (m_pdlgWAN[i], Buf[i], TRUE, (i == 0), 80) ;
	addTabView (m_advdlgWAN, Buf[tabcount], TRUE, FALSE, 80);
	
   // Get all the parameters of all the ports from INI file
   CenterWindow() ;

	CMainDlg *pMainDialog = (CMainDlg *) GetParent() ;
	RouterStatus = pMainDialog->RouterUp && pMainDialog->TargetFound ;

	GetConfig() ; 
   AfxGetApp()->DoWaitCursor(0) ;
	
   CTabDialog::OnInitDialog() ;
                                               
	return FALSE ;
}


int CWanTab::AcceptConfig()
{
	LPCSTR temp ;
	LPCSTR proxy_control ;
	LPCSTR remote_control ;
	char m_szTempBuf[21] ;
	temp = (char *) m_szTempBuf ;


	char TempLSL[] = "LSL ", TempWAN[] = "WAN " ;
	char TempPort[] = "Port", TempPortNumber[10], TempSpeed[] = " Speed" ;
	char TempBuff[40] ;
	char strLHS[40],strRHS[40];
	char prefix_alphabet = 65;
	int prefix_num = 0;
	// brindha on 29/4/99.
	proxy_control = (char *) m_szTempBuf ;
	remote_control = (char *) m_szTempBuf ;
	char dial_type[2] ;
	char fn_type[2] ;

	char sztemp[15] ; // added by cfp on 26-3-96

	BOOL FLAG ;
	
   //Write all parameters for Ports
   //Write BOOL parameters
	char field[80] ;


	WriteModemInfoToIni() ;
	for (int i = 0 ; i < tabcount ; i ++)
	{
		char Buf[12] ;
		_itoa (i, Buf, 10) ;
		
		strcpy (field,"WAN Port") ;
		strcat (field,Buf) ;
		strcpy (Buf,field) ;     

   	m_pdlgWAN[i]->UpdateData (TRUE) ;
	
	   if (m_pdlgWAN[i]->m_WANPort)
	  		temp = StrEnabled ;
	   else
			temp = StrDisabled ;
	
	   WritePrivateProfileString (WANSectionHeader,
		   	(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;


	// Chida - 21 Apr 1997		
		char szLHS[100];
	// Chida - 21 Apr 1997		

		// If WAN is disabled then disable PPP, SLIP and Frame Relay
		CMainDlg *pParent = (CMainDlg *)GetParent();
		if (!m_pdlgWAN[i]->m_WANPort)
		{
			pParent->EnablePPP (i, FALSE);
			pParent->EnableSLIP (i, FALSE);
      }
		else
		{
			if (!pParent->IsPPPEnabled(i) && !pParent->IsSLIPEnabled(i))
				pParent->EnablePPP (i, TRUE);
		}
			
   	strcpy (field, Buf) ;
      strcat (field, " Async") ;
	   if (m_pdlgWAN[i]->m_RBtnAsync.GetCheck())
			temp = StrEnabled ;
		else
			temp = StrDisabled ;                              
		FLAG = m_pdlgWAN[i]->m_RBtnAsync.GetCheck() ? TRUE : FALSE ;
	
		WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

// Modifications by Brindha on 29/4/99.

		if (m_pdlgWAN[i]->m_RBtnAnswering.GetCheck())	
		{
			strcpy (dial_type, "1") ;
			strcpy (fn_type, "4") ; // RAS will only be enabled.
			proxy_control = StrDisabled ;
			remote_control = StrEnabled ;
		}

		else if (m_pdlgWAN[i]->m_ctrl_dial_answer.GetCheck())	
		{
/* sudha 13 nov 1998 */
// brindha modified on 29/4/99.

			strcpy (dial_type, "2") ;
			if (m_pdlgWAN[i]->m_ctrl_proxy_enable.GetCheck())
				proxy_control = StrEnabled ;
			else
				proxy_control = StrDisabled ;

			if (m_pdlgWAN[i]->m_ctrl_ras_enable.GetCheck())
				remote_control = StrEnabled ;
			else
				remote_control = StrDisabled ;

			if (m_pdlgWAN[i]->m_ctrl_proxy_enable.GetCheck() && m_pdlgWAN[i]->m_ctrl_ras_enable.GetCheck())
 				strcpy (fn_type, "5") ;

			if (m_pdlgWAN[i]->m_ctrl_ag_enable.GetCheck() && m_pdlgWAN[i]->m_ctrl_ras_enable.GetCheck()) 
				strcpy (fn_type, "6") ;

			if (m_pdlgWAN[i]->m_ctrl_proxy_enable.GetCheck() && m_pdlgWAN[i]->m_ctrl_ras_enable.GetCheck()
				&& m_pdlgWAN[i]->m_ctrl_ag_enable.GetCheck())
				strcpy (fn_type, "7") ;
				
		}
		else 
		{
			strcpy (dial_type, "0") ;
			remote_control = StrDisabled ;
			if (m_pdlgWAN[i]->m_ctrl_proxy_enable.GetCheck())
				proxy_control = StrEnabled ;
			else
				proxy_control = StrDisabled ;
			if (m_pdlgWAN[i]->m_ctrl_proxy_enable.GetCheck() && !m_pdlgWAN[i]->m_ctrl_ag_enable.GetCheck())
				strcpy (fn_type, "1") ;
			if (!m_pdlgWAN[i]->m_ctrl_proxy_enable.GetCheck() && m_pdlgWAN[i]->m_ctrl_ag_enable.GetCheck())
				strcpy (fn_type, "2") ;
			if (m_pdlgWAN[i]->m_ctrl_proxy_enable.GetCheck() && m_pdlgWAN[i]->m_ctrl_ag_enable.GetCheck())
				strcpy (fn_type, "3") ;
		}


		strcpy (field, Buf) ;
		strcat (field, " DialInOut Type") ;
	   	WritePrivateProfileString (WANSectionHeader,
			(LPCSTR) field, (LPCSTR) dial_type, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Function Type") ;
	   	WritePrivateProfileString (WANSectionHeader,
			(LPCSTR) field, (LPCSTR) fn_type, (LPCSTR) IniInWinForm) ;

		wsprintf (field, "Proxy Server Port%d", i+1);
		WritePrivateProfileString (ProxySectionHeader,
			(LPCSTR) field, (LPCSTR) proxy_control, (LPCSTR) IniInWinForm) ;

		wsprintf (field, "PPP Port%d Remote Port Client Only", i);
		WritePrivateProfileString (PPPSectionHeader,
			(LPCSTR) field, (LPCSTR) remote_control, (LPCSTR) IniInWinForm) ;

		if (m_pdlgWAN[i]->m_ctrl_ag_enable.GetCheck())
	   		WriteAGStrings (i) ;


		strcpy (field, Buf) ;
   	strcat (field, " Direct Connect") ;
  		wsprintf (szLHS, "PPP Port%d Remote Option%%LCP%%CallBack", i);
   		
		if (m_pdlgWAN[i]->m_chkBtnDirConnect.GetCheck())
		{
			temp = StrEnabled ;
			WritePrivateProfileString (PPPSectionHeader, szLHS, NULL, IniInWinForm);
		}	
		else
		{
			temp = StrDisabled ;
			WritePrivateProfileString (PPPSectionHeader, szLHS, "13,Auto,Negotiation Not Required,Negotiable,H1,00", IniInWinForm);
		}
	
		WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
	
		// Added by cfp on 26-3-96
		strcpy (field, Buf) ;
		strcat (field, " Internal Clock") ;
		if (m_pdlgWAN[i]->m_RBtnIntClk.GetCheck()) 
			temp = StrEnabled ;
		else
			temp = StrDisabled ;
		WritePrivateProfileString (WANSectionHeader, (LPCSTR) field,
				(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Send Idle Flags") ;
		if (m_pdlgWAN[i]->m_chkboxIdleFlags.GetCheck()) 
			temp = StrEnabled ;
		else
			temp = StrDisabled ;
		WritePrivateProfileString (WANSectionHeader, (LPCSTR) field,
				(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Synchronous Speed") ;
		// Just give some valid values to the Sync speed entries
		// even if they are not selected
		if (m_pdlgWAN[i]->m_RBtnIntClk.GetCheck())
			lstrcpy ((LPSTR) sztemp, m_pdlgWAN[i]->m_cboxSyncIntClk) ;
		else
			m_pdlgWAN[i]->m_cboxSyncIntClkWnd.GetLBText (0, (LPSTR) sztemp) ;
		WritePrivateProfileString (WANSectionHeader, (LPCSTR) field,
				(LPCSTR) sztemp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Script") ;
		if (m_pdlgWAN[i]->m_bScriptEnable)
			temp = StrEnabled ;
		else
			temp = StrDisabled ;
		WritePrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Restart Script On Comm Failure") ; 
		if (m_pdlgWAN[i]->m_bRestartScriptOnCommFailure)
			temp = StrEnabled ;
		else
			temp = StrDisabled ;
		WritePrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
  		strcat (field, " Speed") ;
		// Modified by cfp on 25-3-96
		// To See that no Null Speed is in Combo box
		// and later written to ini file
		char BaudBuf[15] ;
		if (m_pdlgWAN[i]->m_cboxAsyncBaud.IsEmpty())
			m_pdlgWAN[i]->m_cboxAsyncBaudWnd.GetLBText (0, (LPSTR) BaudBuf) ;
		else
			strcpy (BaudBuf, m_pdlgWAN[i]->m_cboxAsyncBaud) ;
#if 0 /* Sachin took this off */
		if ( i < 2 || (!m_pdlgWAN[0]->m_Backup && !m_pdlgWAN[1]->m_Backup))
#endif
			WritePrivateProfileString(WANSectionHeader, (LPCSTR) field,
				(LPCSTR) BaudBuf, (LPCSTR) IniInWinForm) ;

	   // Write CString Parameters
		if (FLAG)
		{
			// 2/11/95 Vidy
			// Update the LSL speed also for SNMP to report it properly
			strcpy(field, Buf);
			field[0] = 'L';
			field[1] = 'S';
			field[2] = 'L'; //change WAN to LSL
			field[8] += 1;		//LSL port number of WAN starts at 1 :  29-12-95
		   strcat (field," Speed") ;
			// Modified by cfp on 25-3-96
			WritePrivateProfileString(LSLSectionHeader, (LPCSTR) field,
				  (LPCSTR) m_pdlgWAN[i]->m_cboxAsyncBaud, (LPCSTR) IniInWinForm) ;
   	}
		else
		{
			_itoa(i, TempPortNumber, 10);
			TempPortNumber[0]++ ;
			strcpy (TempBuff, TempLSL) ;
			strcat (TempBuff, TempPort) ;
			strcat (TempBuff, TempPortNumber) ;
			strcat (TempBuff, TempSpeed) ;

			// Modified by cfp on 26-3-96
			if (m_pdlgWAN[i]->m_RBtnIntClk.GetCheck())
				lstrcpy((LPSTR) sztemp, m_pdlgWAN[i]->m_cboxSyncIntClk) ;
			else   // Instead of 0 get some valid value
		   	m_pdlgWAN[i]->m_cboxSyncIntClkWnd.GetLBText(0, (LPSTR) sztemp) ;
			WritePrivateProfileString(LSLSectionHeader,
				(LPCSTR) TempBuff, (LPCSTR) sztemp, (LPCSTR) IniInWinForm);

		}
//^^^^Sudha 9 Dec 1997
		
		sprintf ( TempBuff,"%s%d",TempPort,i);
		sprintf ( strLHS,"ISDN WAN %s",TempBuff);
		
		if ( m_pdlgWAN[i]->m_RBtnIsdn.GetCheck())
		{
/* Sudha 04 Nov 1998..... */
			wsprintf (field, "ISDN Port%d Extra Initialization String8", i);
			sprintf ( strRHS,"%s",m_pdlgWAN[i]->m_isdn_str );
			WritePrivateProfileString ( WANSectionHeader,field,strRHS,IniInWinForm );
/* ....Sudha 04 Nov 1998 */

			WritePrivateProfileString ( WANSectionHeader,strLHS,StrEnabled,IniInWinForm );
			sprintf ( strRHS,"%s",m_pdlgWAN[i]->m_szSectionName );
/* Sudha 8 June 1998 */
         WritePrivateProfileString ( MapHeader,TempBuff,strRHS,ini_INIFilename );
			WriteInfoInIni ( TempBuff,strRHS );
		}
		else
		{
			WritePrivateProfileString ( WANSectionHeader,strLHS,StrDisabled,IniInWinForm );
			WritePrivateProfileString ( MapHeader,TempBuff,StrNull,ini_INIFilename );
/* Sudha 13 Feb 1998 */
         strcpy ( strRHS,"USA_5ESS");
         WriteInfoInIni ( TempBuff,strRHS );
		}
//^^^^Sudha 9 Dec 1997

		////Prabha 20/2/98
		int count = 0;
		prefix_alphabet = 65;
		prefix_num = 0;
		char tempbuf[25];

		wsprintf (field, "PPP Port%d Connection Dial on Demand", i);
		if (!m_pdlgWAN[i]->m_link_ctrl_enabled.GetCheck() || 
			((m_pdlgWAN[i]->m_ctrl_ag_enable.GetCheck() || m_pdlgWAN[i]->m_ctrl_ras_enable.GetCheck())
			 && !m_pdlgWAN[i]->m_ctrl_proxy_enable.GetCheck()))
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) field, StrDisabled, (LPCSTR) IniInWinForm);
		else
			WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) field, StrEnabled, (LPCSTR) IniInWinForm);

		wsprintf (field, "IP Port%d RIP Send Responses", i);
		if (m_pdlgWAN[i]->m_link_ctrl_enabled.GetCheck())
			WritePrivateProfileString ((LPCSTR) IPSectionHeader,
				(LPCSTR) field, StrDisabled, (LPCSTR) IniInWinForm);
		else
			WritePrivateProfileString ((LPCSTR) IPSectionHeader,
				(LPCSTR) field, StrEnabled, (LPCSTR) IniInWinForm);

		wsprintf (field, "PPP Port%d Connection Idle Timer", i);
		wsprintf (strRHS, "%d", m_pdlgWAN[i]->m_idle_time * 60);
		WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
			(LPCSTR) field, strRHS, (LPCSTR) IniInWinForm);

		if (i != 0)
		{
			wsprintf (field, "Proxy Server Number of Connections to Trigger Port%d", i+1); 
			WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
				(LPCSTR) field, NULL, (LPCSTR) IniInWinForm);
			wsprintf (field, "Proxy Server Number of Hosts to Trigger Port%d", i+1); 
			WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
				(LPCSTR) field, NULL, (LPCSTR) IniInWinForm);
			wsprintf (field, "Proxy Server Port%d Number of Privileged Users", i+1); 
			WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
				(LPCSTR) field, NULL, (LPCSTR) IniInWinForm);

			wsprintf (field, "$%c%dProxy Server Port%d Privileged User List", prefix_alphabet, prefix_num, i+1);
			GetPrivateProfileString ((LPCSTR) ProxySectionHeader,
					(LPCSTR) field, "10000", strRHS, sizeof (strRHS), IniInWinForm);
			while (strcmp(strRHS, "10000"))
			{
				WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
					(LPCSTR) field, NULL, (LPCSTR) IniInWinForm);
				prefix_alphabet++;
				if (prefix_alphabet > 90)
				{
					prefix_alphabet = 65;
					prefix_num++;
				}
				wsprintf (field, "$%c%dProxy Server Port%d Privileged User List", prefix_alphabet, prefix_num, i+1);
				GetPrivateProfileString ((LPCSTR) ProxySectionHeader,
					(LPCSTR) field, "10000", strRHS, sizeof (strRHS), IniInWinForm);
			}				
			prefix_alphabet = 65;
			prefix_num = 0;
			if (m_pdlgWAN[i]->m_link_ctrl_enabled.GetCheck())
			{
				wsprintf (field, "Proxy Server Number of Connections to Trigger Port%d", i+1); 
				wsprintf (strRHS, "%d", m_pdlgWAN[i]->m_active_connections);
				WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
					(LPCSTR) field, strRHS, (LPCSTR) IniInWinForm);

				wsprintf (field, "Proxy Server Number of Hosts to Trigger Port%d", i+1); 
				strcpy (strRHS, m_pdlgWAN[i]->m_active_hosts);
				WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
					(LPCSTR) field, strRHS, (LPCSTR) IniInWinForm);
				
				wsprintf (field, "Proxy Server Port%d Number of Privileged Users", i+1); 
				wsprintf (strRHS, "%d", m_pdlgWAN[i]->m_list_host.GetCount());
				WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
					(LPCSTR) field, strRHS, (LPCSTR) IniInWinForm);
				
				for (int index = 0; index < m_pdlgWAN[i]->m_list_host.GetCount(); index++)
				{
					count++;
					wsprintf (field, "$%c%dProxy Server Port%d Privileged User List", prefix_alphabet, prefix_num, i+1);
					m_pdlgWAN[i]->m_list_host.GetText (index, tempbuf);				
					if (count == 1)
						strcpy (strRHS, tempbuf);
					else
						strcat (strRHS, tempbuf);
					if ((count != 3) && (index != m_pdlgWAN[i]->m_list_host.GetCount()-1)) 
							strcat (strRHS, ",");
				 	WritePrivateProfileString ((LPCSTR) ProxySectionHeader,
							(LPCSTR) field, strRHS, (LPCSTR) IniInWinForm);
					if (count == 3)
					{
						count = 0;
						prefix_alphabet++;
						if (prefix_alphabet > 90)
						{
							prefix_num++;
							prefix_alphabet = 65;
						}
					}
				}
			}
		}
   }

	return TRUE;
}					

void CWanTab::OnOK()
{
//	char ErMsg[100] ;

//	UpdateData (TRUE) ;
   for (int i = 0 ; i < tabcount ; i ++)
   {
		if (!m_pdlgWAN[i]->ValidEditFields())
		{
	   		switchTab(i);
   	   		enableView(i,TRUE);
         	return;
      	}
		if (!m_pdlgWAN[i]->ValidCheckBtns())
		{
			switchTab(i) ;
			enableView(i, TRUE) ;
			return ;
		}

   }
	if (!AcceptConfig()) 
		return ;
	CTabDialog::OnOK() ;
	return ;
}

void CWanTab::OnCancel()
{
	CTabDialog::OnCancel();
}

/*----------------------------------------------------------------------------
	Module 	: WriteModemInfoToIni
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Writes the Modems Info into the Roucon.Ini
				  file for each of the WAN Links under the WAN Section
	Globals
	Affected : None
----------------------------------------------------------------------------*/

void CWanTab::WriteModemInfoToIni()
{
	char szFilePath[200] ;
	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;
	fModemsPtr = fopen (szFilePath, "rb") ;

	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(),
			"Could not locate MODEMS.CNF file",
					"File Open Error", MB_OK | MB_ICONSTOP) ;
		return ;
	}

	WORD nModems ;
	MODEMS_HDR ModemsHdr ;
	fread (&ModemsHdr, sizeof (ModemsHdr), 1, fModemsPtr) ;
	nModems = ModemsHdr.NumEntries ;

	// To prevent user from Modifying the Modems.Cnf File
	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Invalid MODEMS.CNF file",
																"Warning", MB_OK) ;
		return ;
	}

	char szModemNameInCombo[80] ;
	MODEM_SETUP ModemSetup ;
	WORD j = 0 ;

	for (int i = 0 ; i < tabcount ; i ++)
	{
		// Get the Select Index of the Modem from the Combo Box
		int nCurSel = m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
		
		// If none selected write nulls to Ini file
		if (nCurSel == CB_ERR)
		{
			memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;
		}
		else
		{
			m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nCurSel, 
													(LPSTR) szModemNameInCombo) ;
			
			// Offset from the Modems Header to First Modem Info
			fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

			for (j = 0 ; j < nModems ; j ++)
			{
				fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) ;
				if (!strcmpi (szModemNameInCombo, ModemSetup.ModemType))
					break ;
			}
		}

		if (j == nModems)
			memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;

		WriteModemStringsToIni (i, &ModemSetup) ;
	}

	fclose (fModemsPtr) ;
	return ;
}




/*----------------------------------------------------------------------------
	Module 	: GetModemTypes
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any read error
	Synopsis	: List all Modems from the Cnf file
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWanTab::GetModemTypes()
{
	char szFilePath[200] ; // For MODEMS.CNF File

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetParent()->GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
				"Warning - File not found", MB_OK) ;
		return FALSE ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetParent()->GetSafeHwnd(),
			"Invalid MODEMS.CNF file", "Warning", MB_OK) ;
		return FALSE ;
	} 

	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;
	MODEM_SETUP ModemSetup ;
	int i ;

	for (i = 0 ; i < tabcount ; i ++)
		m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent();
	while (TRUE)
	{
		if (fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) < 1)
			break ;
		if (strcmp (ModemSetup.ModemType, "Direct Connection") == 0)
			continue ;
		for (i = 0 ; i < tabcount ; i ++)
			m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (ModemSetup.ModemType) ;
	}

	fclose (fModemsPtr) ;
	return TRUE ;
}

#if 0
void CWanTab::GetIsdnTypes ()
{
	char strLHS[40],strRHS[40],buffer[512];
	char token[40];
	// char *seps = "\0";
	char seps = '\0';
	int length = 0;
	int total;
	CString szDefaultConfig;
	int k;
	
	for (k = 0; k < tabcount; k++ )
	{
		m_pdlgWAN[k]->m_ComBoxModemTypes.ResetContent();

		strcpy(strLHS,DefaultIniString);
		while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
			 StrNull, (LPSTR) strRHS,sizeof (strRHS),
				(LPCSTR) ini_INIFilename))
	  	{
		 	if ( m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, strRHS ) == CB_ERR )
		 	{
		 		// Insert the string in the list box
/* Sudha 9 June 1998 */
         if (( model == MODEL_MTSR1_202ST) ||
            (( model == MODEL_MTSR1_202NT ) && (strstr ( strRHS,"USA") != NULL)) ||
            ( model == MODEL_MTSR2_201 ))
   	 			m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( strRHS );
		 	}
		 	strLHS[6]++;
	   }
 
		total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
			buffer, sizeof(buffer), ini_INIFilename );

		while ( total > 0 )
		{
			strcpy ( token,&buffer[length]);
	      if ( m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, token ) == CB_ERR )
         {
	       	   // Insert the string in the list box
		   	m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( token );
			}	

 	      length = length + strlen ( token ) + 1;	// +1 for the NULL character
			total = total - ( strlen ( token ) + 1 ) ;
		}
	
		sprintf ( strLHS,"ISDN WAN Port%d ConfigName",k);
		GetPrivateProfileString ( WANSectionHeader, strLHS,
			StrNull,strRHS,sizeof(strRHS),IniInWinForm );
		if ( strcmp ( strRHS,StrNull ) == 0 )
			strcpy ( strRHS,"USA_5ESS");
		int nsel;
		nsel = m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact(-1,strRHS );
		if (nsel == CB_ERR )
	   nsel = 0;
		m_pdlgWAN[k]->m_ComBoxModemTypes.SetCurSel ( nsel );
		m_pdlgWAN[k]->m_ComBoxModemTypes.GetLBText (nsel,m_pdlgWAN[k]->m_szSectionName );
	}
}
#endif
//Sudha 9 Dec 1997

// brindha on 29/4/99.
void CWanTab::CheckDialInOutType (int nPort, int dial_type)
{
	switch(dial_type)
	{
		case 0 :
			m_pdlgWAN[nPort]->m_RBtnDialling.SetCheck (1) ;
			m_pdlgWAN[nPort]->m_RBtnAnswering.SetCheck (0) ;
			m_pdlgWAN[nPort]->m_ctrl_dial_answer.SetCheck (0) ;
			m_pdlgWAN[nPort]->m_ctrl_ras_enable.EnableWindow (FALSE) ;
			break ;
		case 1 :
			m_pdlgWAN[nPort]->m_RBtnDialling.SetCheck (0) ;
			m_pdlgWAN[nPort]->m_RBtnAnswering.SetCheck (1) ;
			m_pdlgWAN[nPort]->m_ctrl_dial_answer.SetCheck (0) ;
			m_pdlgWAN[nPort]->m_ctrl_proxy_enable.EnableWindow (FALSE) ;
			m_pdlgWAN[nPort]->m_ctrl_ag_enable.EnableWindow (FALSE) ;
			break ;
		case 2 :
			m_pdlgWAN[nPort]->m_RBtnDialling.SetCheck (0) ;
			m_pdlgWAN[nPort]->m_RBtnAnswering.SetCheck (0) ;
			m_pdlgWAN[nPort]->m_ctrl_dial_answer.SetCheck (1) ;
			break ;
	}
//	m_pdlgWAN[nPort]->UpdateData (FALSE);
}

void CWanTab::CheckFunctionType (int nPort, int fn_type)
{
	if ((fn_type & 0x01) == 0x01)
		m_pdlgWAN[nPort]->m_bProxyEnable = TRUE ;
	else
		m_pdlgWAN[nPort]->m_bProxyEnable = FALSE ;

	if ((fn_type & 0x02) == 0x02)
		m_pdlgWAN[nPort]->m_bAGEnable = TRUE ;
	else
		m_pdlgWAN[nPort]->m_bAGEnable = FALSE ;

	if ((fn_type & 0x04) == 0x04)
		m_pdlgWAN[nPort]->m_bRasEnable = TRUE ;
	else
		m_pdlgWAN[nPort]->m_bRasEnable = FALSE ;

//	m_pdlgWAN[nPort]->UpdateData (FALSE);
}

void CWanTab::DialOutProxyOnly (int nPort)
{
	m_pdlgWAN[nPort]->m_RBtnDialling.SetCheck (1) ;
	m_pdlgWAN[nPort]->m_RBtnAnswering.SetCheck (0) ;
	m_pdlgWAN[nPort]->m_RBtnAnswering.EnableWindow (FALSE) ;
	m_pdlgWAN[nPort]->m_ctrl_dial_answer.SetCheck (0) ;
	m_pdlgWAN[nPort]->m_ctrl_dial_answer.EnableWindow (FALSE) ;
	m_pdlgWAN[nPort]->m_bProxyEnable = TRUE ;
	m_pdlgWAN[nPort]->m_bAGEnable = FALSE ;
	m_pdlgWAN[nPort]->m_bRasEnable = FALSE ;
	m_pdlgWAN[nPort]->m_ctrl_ag_enable.EnableWindow (FALSE) ;
	m_pdlgWAN[nPort]->m_ctrl_ras_enable.EnableWindow (FALSE) ;
}


// Brindha  added  the  following functions on 23-10-98 for AG
void CWanTab::ProcessAGStrings (int nPort)
{
	char szLHS[100] ;
	char szRHS[100] ;
    int tempnum ;

	sprintf (szLHS, "%s%d%s", "AG Port", nPort, " General Name") ;
	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
	    (LPCSTR) szLHS, (LPCSTR) "MODEM", (LPSTR) szRHS,
	    sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	m_pdlgWAN[nPort]->m_ctrl_general_name.LimitText (8) ;
	m_pdlgWAN[nPort]->m_general_name = szRHS ;

	sprintf (szLHS, "%s%d%s", "AG Port", nPort, " Specific Name") ;
  	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
	    (LPCSTR) szLHS, (LPCSTR) "LINE1", (LPSTR) szRHS,
		    sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	m_pdlgWAN[nPort]->m_ctrl_specific_name.LimitText (14) ;
	m_pdlgWAN[nPort]->m_specific_name = szRHS ;

	sprintf (szLHS, "%s%d%s", "AG Port", nPort, " Idle Time") ;
    tempnum = GetPrivateProfileInt ((LPCSTR) AGSectionHeader,
	  (LPCSTR) szLHS, 0, (LPCSTR) IniInWinForm) ;
    m_pdlgWAN[nPort]->m_port_inactivity_timeout = tempnum ;

}


void CWanTab::WriteAGStrings (int nPort)
{
	char szLHS[100] ;
    char m_szTempBuf[21] ;

	sprintf (szLHS, "%s%d%s", "AG Port", nPort, " General Name") ;
	WritePrivateProfileString ((LPCSTR) AGSectionHeader,
	    (LPCSTR) szLHS, (LPCSTR) m_pdlgWAN[nPort]->m_general_name,
		    (LPCSTR) IniInWinForm) ;

	sprintf (szLHS, "%s%d%s", "AG Port", nPort, " Specific Name") ;
	WritePrivateProfileString ((LPCSTR) AGSectionHeader,
	    (LPCSTR) szLHS, (LPCSTR) m_pdlgWAN[nPort]->m_specific_name,
		    (LPCSTR) IniInWinForm) ;

	sprintf (szLHS, "%s%d%s", "AG Port", nPort, " Idle Time") ;
    wsprintf (m_szTempBuf, "%d", m_pdlgWAN[nPort]->m_port_inactivity_timeout) ; 
	WritePrivateProfileString ((LPCSTR) AGSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) m_szTempBuf,
			(LPCSTR) IniInWinForm) ;
}

void CWanTab::GrayAGControls (BOOL bGray, int nPort)
{
	m_pdlgWAN[nPort]->m_ctrl_port_inactivity_timeout.EnableWindow (!bGray) ;
	m_pdlgWAN[nPort]->m_ctrl_static_port_inactivity_timeout.EnableWindow (!bGray) ;
	m_pdlgWAN[nPort]->m_ctrl_specific_name.EnableWindow (!bGray) ;
	m_pdlgWAN[nPort]->m_ctrl_static_specific_name.EnableWindow (!bGray) ;
	m_pdlgWAN[nPort]->m_ctrl_general_name.EnableWindow (!bGray) ;
	m_pdlgWAN[nPort]->m_ctrl_static_general_name.EnableWindow (!bGray) ;
	m_pdlgWAN[nPort]->m_ctrl_asynchronous_gateway.EnableWindow (!bGray) ;

//	m_pdlgWAN[nPort]->UpdateData (FALSE) ;
}

void CWanTab::ShowAGControls (int nShow, int nPort)
{
	//Since we decide to greyout the controls & not to resize the dialog 

	 return;

	m_pdlgWAN[nPort]->m_ctrl_port_inactivity_timeout.ShowWindow (nShow) ;
	m_pdlgWAN[nPort]->m_ctrl_static_port_inactivity_timeout.ShowWindow (nShow) ;
	m_pdlgWAN[nPort]->m_ctrl_specific_name.ShowWindow (nShow) ;
	m_pdlgWAN[nPort]->m_ctrl_static_specific_name.ShowWindow (nShow) ;
	m_pdlgWAN[nPort]->m_ctrl_general_name.ShowWindow (nShow) ;
	m_pdlgWAN[nPort]->m_ctrl_static_general_name.ShowWindow (nShow) ;
	m_pdlgWAN[nPort]->m_ctrl_asynchronous_gateway.ShowWindow (nShow) ;
}


RECT TabsMaxRect ;
RECT TabsMinRect ;

/*  Not  used  at  present to resize the dialog */
void CWanTab::CutAGBox (int nPort)
{
	RECT FullRect ;
	//Since we decide to greyout the controls & to resize the dialog 
	//return;

	memcpy ((LPRECT) &FullRect, (LPRECT) &TabsMinRect, sizeof (FullRect)) ;
	MoveWindow (&FullRect, TRUE) ;
}

void CWanTab::ReputAGBox (int nPort)
{
	RECT FullRect ;
	//Since we decide to greyout the controls & to resize the dialog 
        //return;

	memcpy ((LPRECT) &FullRect, (LPRECT) &TabsMaxRect, sizeof (FullRect)) ;
	MoveWindow (&FullRect, TRUE) ;
}

void CWanTab::GetTabsRectDim()
{
	RECT TempRect ;

	GetWindowRect (&TabsMaxRect) ;
	GetWindowRect (&TabsMinRect) ;
	m_pdlgWAN[0]->m_ctrl_asynchronous_gateway.GetWindowRect (&TempRect) ;

	TabsMinRect.bottom = TempRect.top + 24 ;
}

void CWanTab::WriteInfoInIni(char Buff[40],char RHS[40] )
{
	char strLHS[40],strRHS[40] ;
	CIsdnTa Isdn;
	BOOL US = FALSE;
	
	//Configuration Name
	sprintf ( strLHS,"ISDN WAN %s ConfigName",Buff );
	WritePrivateProfileString(WANSectionHeader,strLHS,RHS,IniInWinForm);
	
	strcpy ( InitstrRHS,"AT");
	sprintf(InitstrLHS,"ISDN %s Initialization String1",Buff);

	//IDD_NETWORK_SWITCH_TYPE member
	WriteToRouconIni(RHS,"NetworkSwitchType","NI - 1",cfg_NetworkSwitchTypes,"!C0=");

	GetPrivateProfileString ( RHS,"NetworkSwitchType","NET3",strRHS,
		sizeof ( strRHS ),ini_INIFilename );
	US = Isdn.SwitchType ( strRHS );

	//IDD_NETWORK_CFG_I member
	WriteToRouconIni(RHS,"DataTEI","Auto TEI",cfg_TEI,"!D3=");
	WriteToRouconIni(RHS,"VoiceTEI","Auto TEI",cfg_TEI,"*!D3=");

	//IDD_NETWORK_CFG_II_US member
	WriteToRouconIni(RHS,"DataSPID","",cfg_null,"!C6=");
	WriteToRouconIni(RHS,"VoiceSPID","",cfg_null,"*!C6=");

	if ( US == TRUE )
	{
		WriteToRouconIni(RHS,"DataDirectoryNumber","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceDirectoryNumber","",cfg_null,"*!N1=");

	}
	
	//IDD_NETWORK_CFG_II_EUROPE
	else
	{	
		WriteToRouconIni(RHS,"DataMSN","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceMSN","",cfg_null,"*!N1=");

	}
	//IDD_CALL_CTRL_CFG
	
	WriteToRouconIni(RHS,"AutoAnswer","Yes",cfg_NoYes,"S0=");
	WriteToRouconIni(RHS,"PersistentDTRDialing","No",cfg_NoYes,"$D");
	WriteToRouconIni(RHS,"DialingMethod","Enbloc",cfg_DialingMethods,"%A97=");
	WriteToRouconIni(RHS,"RingsToAnswer","1",cfg_null,"S0=");
	WriteToRouconIni(RHS,"CallLineId","No",cfg_NoYes,"S50=");

	//IDD_DATA_PROTOCOL
	WriteToRouconIni(RHS,"DataProtocol","V.120",cfg_DataProtocols,"!Z=");
	WriteToRouconIni(RHS,"DataCompression","None",cfg_DataCompression,"&K");
	WriteToRouconIni(RHS,"AutoDetection","No",cfg_NoYes,"S52=");

	if ( strlen ( InitstrRHS ) > 2 )
	{
		WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
		InitstrLHS[32]++;
	}

/* Sudha 29 June 1998 */
   WritePrivateProfileString ( WANSectionHeader,InitstrLHS,"AT&W",IniInWinForm );
		InitstrLHS[32]++;

#if 0
	char max[2];
	int maxnum;

	sprintf ( max,"%c",InitstrLHS[32]);
	sscanf ( max,"%d",&maxnum);
 
	for ( int i = maxnum; i < 20;i++)
	{
		sprintf ( strLHS,"ISDN %s Initialization String%d",Buff,i);
		WritePrivateProfileString ( WANSectionHeader,strLHS,NULL,IniInWinForm );
	}
#endif	
/* Sudha 29 June 1998 */

	return;
}

void  CWanTab::WriteToRouconIni(LPCSTR Section,LPCSTR strLHS,LPCSTR Default,ini_tpValuePair Table,const char* command)
{
   char strRHS[40],tempstr[40];
	CString String;
	int value,len = 0;

	GetPrivateProfileString(Section,strLHS,Default,
		strRHS,sizeof(strRHS),ini_INIFilename);
	if (Table != cfg_null)
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			for(int i=0; Table[i].StringID;i++)
			{
				String.LoadString(Table[i].StringID );
				if (!strcmpi(String,strRHS))
				{	
					value = Table[i].nNum;
					break;
				}
			}
			sprintf(strRHS,"%s%d",command,value);
		}
	}
	else
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			sprintf(tempstr,"%s%s",command,strRHS);
			strcpy(strRHS,tempstr);
		}
	}

// Sudha 10 Feb 1998 
   if ( IsSPIDorISDN (command))
   {
   	if (!strcmp ( command,"!C6="))
      {      
      	WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
      }
	   strcat ( InitstrRHS , strRHS );
      WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
      strcpy ( InitstrRHS ,"AT");
	   InitstrLHS[32]++;
   }
   else
   {
		len = strlen ( strRHS ) + strlen ( InitstrRHS ) ;
		if ( len <= ( MAX_INIT_STRING_LENGTH - 2 ))
		strcat ( InitstrRHS , strRHS );
	
		if ( len >= ( MAX_INIT_STRING_LENGTH - 2 ))
		{
			WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
			if ( len > ( MAX_INIT_STRING_LENGTH - 2 ) )
				strcat ( InitstrRHS , strRHS );
		}
	}
	return ;
}


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnDlg dialog


CWanIsdnDlg::CWanIsdnDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWanIsdnDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWanIsdnDlg)
	m_WANEnable = TRUE;
	m_Printf = FALSE;
	m_PrintfRx = FALSE;
	m_PrintfTx = FALSE;
	m_PrintfInitialize = FALSE;
	m_bNonCriticalScriptPrintf = FALSE;
	m_bAlarmScriptPrintf = FALSE;
	m_szPPINISection = "";
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_nSelectedIsdn = CB_ERR ;
	IsdnEnabled = FALSE;
	Create(IDD,NULL);
}

void CWanIsdnDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanIsdnDlg)
	DDX_Control(pDX, IDC_STATIC_ISDN_CONTROL, m_IsdnCtrlWnd);
	DDX_Control(pDX, IDC_ISDN_EDIT, m_EditConfig);
	DDX_Control(pDX, IDC_ISDN_DELETE, m_DeleteConfig);
	DDX_Control(pDX, IDC_ISDN_ADD, m_AddConfig);
	DDX_Control(pDX, IDC_EXISTING_CFGS, m_INISectionControl);
	DDX_Control(pDX, IDC_CHECK_NON_CRITICAL, m_ChkBoxScriptNonCritical);
	DDX_Control(pDX, IDC_CHECK_SCRIPT_ALARM, m_ChkBoxScriptAlarm);
	DDX_Control(pDX, IDC_STATIC_SCRIPT_PRINTF_GRP, m_ScriptCtrlGrp);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_RX, m_PrintfRx);
	DDX_Check(pDX, IDC_PRINTF_TX, m_PrintfTx);
	DDX_Check(pDX, IDC_INITIALIZE, m_PrintfInitialize);
	DDX_Check(pDX, IDC_CHECK_NON_CRITICAL, m_bNonCriticalScriptPrintf);
	DDX_Check(pDX, IDC_CHECK_SCRIPT_ALARM, m_bAlarmScriptPrintf);
	DDX_CBString(pDX, IDC_EXISTING_CFGS, m_szPPINISection);
	DDV_MaxChars(pDX, m_szPPINISection, 40);
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanIsdnDlg, CDialog)
	//{{AFX_MSG_MAP(CWanIsdnDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_ISDN_EDIT, OnIsdnEdit)
	ON_BN_CLICKED(IDC_ISDN_DELETE, OnIsdnDelete)
	ON_BN_CLICKED(IDC_ISDN_ADD, OnIsdnAdd)
	ON_CBN_SELCHANGE(IDC_EXISTING_CFGS, OnCfgs)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnDlg message handlers

BOOL CWanIsdnDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!AddBmpBtn.LoadBitmaps ("ADD1", "ADD2", "ADD3", "ADD4"))
		AfxMessageBox ("Failed to load ADD bitmap");

	VERIFY (AddBmpBtn.SubclassDlgItem (IDC_ISDN_ADD, this));
	AddBmpBtn.SizeToContent();

	if (!DeleteBmpBtn.LoadBitmaps ("DELETE1", "DELETE2", "DELETE3", "DELETE4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (DeleteBmpBtn.SubclassDlgItem (IDC_ISDN_DELETE, this));
	DeleteBmpBtn.SizeToContent();

	if (!EditBmpBtn.LoadBitmaps ("EDIT1", "EDIT2", "EDIT3", "EDIT4"))
		AfxMessageBox ("Failed to load DELETE bitmap");

	VERIFY (EditBmpBtn.SubclassDlgItem (IDC_ISDN_EDIT, this));
	EditBmpBtn.SizeToContent();

	char szBuf[30] ;
	// Get the values of all WAN parameters from INI file.
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Printf", (LPCSTR) StrDisabled, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_Printf = TRUE ;
	else 
		m_Printf = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Initialization Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfInitialize = TRUE ;
	else
		m_PrintfInitialize = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Rx Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfRx = TRUE ;
	else 
		m_PrintfRx = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Tx Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm);
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfTx = TRUE ;
	else
		m_PrintfTx = FALSE ;

	GetPrivateProfileString ((LPCSTR) ScriptSectionHeader, 
			(LPCSTR) "Script Alarm Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_bAlarmScriptPrintf = TRUE ;
	else
		m_bAlarmScriptPrintf = FALSE ;

	GetPrivateProfileString ((LPCSTR) ScriptSectionHeader, 
			(LPCSTR) "Script Non Critical Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_bNonCriticalScriptPrintf = TRUE ;
	else
		m_bNonCriticalScriptPrintf = FALSE ;

	GetIsdnTypes ();
	if (m_nSelectedIsdn != CB_ERR )
		m_INISectionControl.SetCurSel ( m_nSelectedIsdn );

	if ( m_INISectionControl.GetCurSel () == CB_ERR )
		m_INISectionControl.SetCurSel(m_INISectionControl.FindStringExact(-1,"USA_5ESS"));
   m_INISectionControl.GetLBText(m_INISectionControl.GetCurSel (),m_szPPINISection );
	sprintf ( TempSection ,"%s",m_szPPINISection );
	CenterWindow() ;

   // Update the Dialog Box fields.
	UpdateData (FALSE) ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}

void CWanIsdnDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_WAN_ISDN_CONFIG,HELP_CONTEXT);
}

void CWanIsdnDlg::GetIsdnTypes ()
{
	char strLHS[40],strRHS[40],buffer[512];
	char *token;
	char *seps = "\0";
	int length = 0;
	int total;
	CString szDefaultConfig;
	
	m_INISectionControl.ResetContent();
	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
		if ( m_INISectionControl.FindStringExact ( -1, strRHS ) == CB_ERR )
		{
			// Insert the string in the list box
/* Sudha 9 June 1998 */
         if (( model == MODEL_MTSR1_202ST) ||
            (( model == MODEL_MTSR1_202NT ) && (strstr ( strRHS,"USA") != NULL)))
   			m_INISectionControl.AddString( strRHS );
		}
		strLHS[6]++;
   } 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	if ( total != 0 )
	{
		token = strtok ( buffer, seps );
		while ( token != NULL)
		{
			if ( m_INISectionControl.FindStringExact ( -1, token ) == CB_ERR )
			{
				// Insert the string in the list box
				m_INISectionControl.AddString( token );
			}	
			length = length + strlen ( token ) + 1;	// +1 for the NULL character
	      token = strtok( &buffer[length], seps );
		}
	}
/* Sudha 28 July 1998 */
	if ( m_nSelectedIsdn == CB_ERR )
		m_nSelectedIsdn = 0;
	m_INISectionControl.SetCurSel ( m_nSelectedIsdn );
   m_INISectionControl.GetLBText ( m_INISectionControl.GetCurSel(),m_szPPINISection );
	
}

void CWanIsdnDlg::OnIsdnEdit()
{
	// TODO: Add your control notification handler code here
	
	m_cfgtype = kEdit;
	CIsdnTa Isdn (this);
	Isdn.DoModal();

}

void CWanIsdnDlg::OnIsdnDelete()
{
	// TODO: Add your control notification handler code here

	int			nCurSel, nMBResponse;
	CString		szConfig, szMsg, config ,deleted_config;
	char strRHS[40] ,strLHS[40];
	
	CIsdnTa Isdn;

	m_cfgtype = kDelete;

	if ( m_INISectionControl.GetCurSel() == CB_ERR)
	{
		::MessageBox(GetSafeHwnd(),"Select a Configuration file to delete",IsdnMsgHeader,MB_OK);
		m_INISectionControl.SetFocus();
		return;
	}
	else
	{
		nCurSel = m_INISectionControl.GetCurSel ();
   	m_INISectionControl.GetLBText ( nCurSel, m_szPPINISection );
		deleted_config = m_szPPINISection;

	   if ( nCurSel != CB_ERR )
	   { 
			m_INISectionControl.GetLBText ( nCurSel, szConfig );
			if ( Isdn.IsThisADefaultCfg ( szConfig ) )
			{	
				szMsg.LoadString(IDS_DELETE_DEFAULT_CONFIG);
				nMBResponse = AfxMessageBox ( szMsg );
				return;
			}
			sprintf(strLHS,"Port0");
			while ( GetPrivateProfileString ( MapHeader,strLHS,
				StrNull,strRHS,sizeof(strRHS),ini_INIFilename ))
		  	{
				if ( szConfig.CompareNoCase ( strRHS ) == 0 )
				{
 					::MessageBox ( GetSafeHwnd(),"This is the existing configuration.\
Before deleting this make sure to change the configuration.",IsdnMsgHeader,MB_OK);
					return;
				}
			 	strLHS[4]++;
			}
		   szMsg.LoadString(IDS_DELETE_CONFIG);
		   nMBResponse = AfxMessageBox ( szMsg, MB_YESNO, 0 );
			if ( nMBResponse == IDYES )
			{
				::WritePrivateProfileString ( szConfig, NULL, NULL, ini_INIFilename );
				::WritePrivateProfileString  (	"User Config", szConfig, NULL, ini_INIFilename );
				m_INISectionControl.DeleteString ( nCurSel );
			
				if ( nCurSel != m_INISectionControl.GetCount () )
					m_INISectionControl.SetCurSel ( (nCurSel) );
				else
					m_INISectionControl.SetCurSel ( nCurSel-1 );
			}
		}
		////Prabha, 4/2/98, To echo the deletion in the port tabs also
		CWanIsdnTab *pParent = (CWanIsdnTab *)GetParent();
		pParent->m_pisdnWAN->m_ComBoxModemTypes.GetLBText ( nCurSel, deleted_config );
			pParent->m_pisdnWAN->m_ComBoxModemTypes.DeleteString (nCurSel);
	}		
	return;
}

void CWanIsdnDlg::OnIsdnAdd()
{
	// TODO: Add your control notification handler code here

	m_cfgtype = kAdd;
	
	CIsdnTa Isdn (this);
	if (Isdn.DoModal() == IDOK)
	{
		////Prabha, 6/3/98, Put the newly added config in the list
		if (m_INISectionControl.FindStringExact (-1, Isdn.m_szPPSectionName ) == CB_ERR)
			m_INISectionControl.AddString ( Isdn.m_szPPSectionName );
  		CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;
		if ( pParent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact ( -1, Isdn.m_szPPSectionName ) == CB_ERR )
				pParent->m_pisdnWAN->m_ComBoxModemTypes.AddString ( Isdn.m_szPPSectionName );
	}
}

void CWanIsdnDlg::OnCfgs()
{
	// TODO: Add your control notification handler code here
	
	if ( m_INISectionControl.GetCurSel() != CB_ERR )
	{
 		//m_INISectionControl.GetWindowText ( m_szPPINISection );
                m_INISectionControl.GetLBText ( 
                        m_INISectionControl.GetCurSel(),m_szPPINISection );

		sprintf ( TempSection,"%s",m_szPPINISection );
	}
	
}

void CWanIsdnDlg::PutIsdnConfigInParentsList (int index)
{
	CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;
 	int nCount = m_INISectionControl.GetCount() ;

	char szBuf[40] ;
	int nIndex ;
	int i = index;

	nIndex = pParent->m_pisdnWAN->m_ComBoxModemTypes.GetCurSel() ;
	if (nIndex != CB_ERR)
	{
		pParent->m_pisdnWAN->m_ComBoxModemTypes.GetLBText (nIndex, szBuf) ;
		pParent->m_pisdnWAN->m_szOldIsdnSel = szBuf ;
	}
	else
		pParent->m_pisdnWAN->m_szOldIsdnSel = "" ;
			
	// Refresh the Isdn Configs List in the Combo Box
	pParent->m_pisdnWAN->m_ComBoxModemTypes.ResetContent() ;
		
	// Add Isdn Configs to List
	for (int j = 0 ; j < nCount ; j ++)
	{
		m_INISectionControl.GetLBText (j, (LPSTR) szBuf) ;
		pParent->m_pisdnWAN->m_ComBoxModemTypes.AddString (szBuf) ;
	}

	// If there was a previous selection restore it
	if (!pParent->m_pisdnWAN->m_szOldIsdnSel.IsEmpty())
	{
		nIndex =	
			pParent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact (-1, 
							pParent->m_pisdnWAN->m_szOldIsdnSel) ;								
		if ( nIndex == CB_ERR)
			nIndex = 0;
		pParent->m_pisdnWAN->m_ComBoxModemTypes.SetCurSel (nIndex) ;
	}
}

LRESULT CWanIsdnDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWanIsdnDlg::PostNcDestroy(void)
{
	delete this;
}

void CWanIsdnDlg::OnOK()
{
	// Update the parameters from the Dialog Box.
	if (!UpdateData (TRUE))
      return ;

	LPCSTR temp ;
	// Write the WAN parameters to the INI file.

	if (m_Printf)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) "WAN Printf", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
		
	if (m_PrintfInitialize)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Initialization Printf", (LPCSTR) temp,
				(LPCSTR) IniInWinForm) ;

	if (m_PrintfRx)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Rx Printf", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
			
	if (m_PrintfTx)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Tx Printf", temp, (LPCSTR) IniInWinForm) ;

	if (m_bAlarmScriptPrintf)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) ScriptSectionHeader, 
				(LPCSTR) "Script Alarm Printf", 
						(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_bNonCriticalScriptPrintf)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) ScriptSectionHeader, 
				(LPCSTR) "Script Non Critical Printf", 
						(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;
	PutIsdnConfigInParentsList(0) ;

	CDialog::OnOK();
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

void CWanIsdnDlg::OnCancel()
{
	// TODO: Add extra cleanup here

	CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnPort dialog


CWanIsdnPort::CWanIsdnPort(CWnd* pParent /*=NULL*/)
	: CDialog(CWanIsdnPort::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWanIsdnPort)
	m_WANPort = FALSE;
	m_cboxAsyncBaud = "";
	m_bRestartScriptOnCommFailure = FALSE;
	m_bScriptEnable = FALSE;
	m_szSectionName = "";
	m_Idle_time = 0;
	m_general_name = "";
	m_specific_name = "";
	m_port_inactivity_timeout = 0;
	m_isdn_str = "";
	//}}AFX_DATA_INIT
	Create(IDD,NULL);
}

void CWanIsdnPort::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanIsdnPort)
	DDX_Control(pDX, IDC_STATIC_EXTRA_ISDN_STRING, m_stat_isdn_str);
	DDX_Control(pDX, IDC_EDIT_ISDN_EXTRA_STRING, m_ctrl_isdn_str);
	DDX_Control(pDX, IDC_EDIT_SPECIFIC_NAME, m_ctrl_specific_name);
	DDX_Control(pDX, IDC_EDIT_PORT_INACTIVITY_TIMEOUT, m_ctrl_port_inactivity_timeout);
	DDX_Control(pDX, IDC_EDIT_GENERAL_NAME, m_ctrl_general_name);
	DDX_Control(pDX, IDC_CHECK_DOD_ENABLE, m_LnkCtrlWnd);
	DDX_Control(pDX, IDC_BTN_SCRIPT, m_BtnScript);
	DDX_Control(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_RestartScriptWnd);
	DDX_Control(pDX, IDC_CHECK_ENABLE_SCRIPT, m_ScriptEnableWnd);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPES, m_ComBoxModemTypes);
	DDX_Control(pDX, IDC_BAUD_HEADER, m_BaudHeader);
	DDX_Control(pDX, IDC_DIALLING, m_RBtnDialling);
	DDX_Control(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaudWnd);
	DDX_Control(pDX, IDC_RADIO_ASYNC, m_RBtnAsync);
	DDX_Check(pDX, IDC_WAN_PORT, m_WANPort);
	DDX_CBString(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaud);
	DDV_MaxChars(pDX, m_cboxAsyncBaud, 15);
	DDX_Check(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_bRestartScriptOnCommFailure);
	DDX_Check(pDX, IDC_CHECK_ENABLE_SCRIPT, m_bScriptEnable);
	DDX_CBString(pDX, IDC_COMBO_MODEM_TYPES, m_szSectionName);
	DDX_Text(pDX, IDC_EDIT_IDLE_TIME, m_Idle_time);
	DDV_MinMaxUInt(pDX, m_Idle_time, 1, 500);
	DDX_Text(pDX, IDC_EDIT_GENERAL_NAME, m_general_name);
	DDX_Text(pDX, IDC_EDIT_SPECIFIC_NAME, m_specific_name);
	DDX_Text(pDX, IDC_EDIT_PORT_INACTIVITY_TIMEOUT, m_port_inactivity_timeout);
	DDX_Text(pDX, IDC_EDIT_ISDN_EXTRA_STRING, m_isdn_str);
	DDV_MaxChars(pDX, m_isdn_str, 40);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanIsdnPort, CDialog)
	//{{AFX_MSG_MAP(CWanIsdnPort)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_REGISTERED_MESSAGE(msgSwitchTo, OnSwitchToIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_BTN_SCRIPT, OnBtnScript)
	ON_BN_CLICKED(IDC_CHECK_DOD_ENABLE, OnCheckDodEnable)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEM_TYPES, OnSelchangeComboModemTypes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnPort message handlers

BOOL CWanIsdnPort::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3", "OK4"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3", "CANCEL4"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3", "SHELP4"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

	if (!ScriptBmpBtn.LoadBitmaps ("SCRIPT1", "SCRIPT2", "SCRIPT3", "SCRIPT4"))
		AfxMessageBox ("Failed to load SCRIPT bitmap");

	VERIFY (ScriptBmpBtn.SubclassDlgItem (IDC_BTN_SCRIPT, this));
	ScriptBmpBtn.SizeToContent();

	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWanIsdnPort::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CWanIsdnPort::OnOK()
{
	// TODO: Add extra validation here
	if (!UpdateData (TRUE))
		return ;

	CDialog::OnOK() ;
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

LRESULT CWanIsdnPort::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWanIsdnPort::PostNcDestroy(void)
{
	delete this;
}

void CWanIsdnPort::OnHelp()
{
		AfxGetApp()->WinHelp(0x20000 + IDD_WAN_ISDN_PORT_CONFIG,HELP_CONTEXT);
	
}

void CWanIsdnPort::OnBtnScript()
{
	// TODO: Add your control notification handler code here

	CWanIsdnTab *pParent = (CWanIsdnTab *) GetParent() ;

	CScriptDlg script ;
	script.m_nPortNum = (int)0 ;
	script.DoModal() ;
}

LRESULT CWanIsdnPort::OnSwitchToIden (WPARAM wParam, LPARAM lParam)
{
	UpdateData (TRUE) ;
	return 0L ;
}

void CWanIsdnPort::GetIsdnTypes (int j)
{
	char strLHS[40],strRHS[40],buffer[512];
	char token[40];
	// char *seps = "\0";
	char seps = '\0';
	int length = 0;
	int total;
	CString szDefaultConfig;
	int k = j;
	
	CWanIsdnTab *parent = (CWanIsdnTab *)GetParent();

	parent->m_pisdnWAN->m_ComBoxModemTypes.ResetContent();

	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
	 	if ( parent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact ( -1, strRHS ) == CB_ERR )
	 	{
	 		// Insert the string in the list box
/* Sudha 9 June 1998 */
         if (( model == MODEL_MTSR1_202ST) ||
            (( model == MODEL_MTSR1_202NT ) && (strstr ( strRHS,"USA") != NULL)))
   	 		parent->m_pisdnWAN->m_ComBoxModemTypes.AddString( strRHS );
	 	}
	 	strLHS[6]++;
   }
 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	while ( total > 0 )
	{
		strcpy ( token,&buffer[length]);
      if ( parent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact ( -1, token ) == CB_ERR )
      {
     	   // Insert the string in the list box
		   parent->m_pisdnWAN->m_ComBoxModemTypes.AddString( token );
		}	

      length = length + strlen ( token ) + 1;	// +1 for the NULL character
		total = total - ( strlen ( token ) + 1 ) ;
	}

/* Sudha 04 Nov 1998.... */	
	sprintf ( strLHS,"ISDN Port%d Extra Initialization String8",j);
	GetPrivateProfileString ( WANSectionHeader, strLHS,
		StrNull,strRHS,sizeof(strRHS),IniInWinForm );
	parent->m_pisdnWAN->m_isdn_str = strRHS ;
/* ....Sudha 04 Nov 1998 */	
	
	sprintf ( strLHS,"ISDN WAN Port%d ConfigName",j);
	GetPrivateProfileString ( WANSectionHeader, strLHS,
		StrNull,strRHS,sizeof(strRHS),IniInWinForm );
	if ( strcmp ( strRHS,StrNull ) == 0 )
		strcpy ( strRHS,"USA_5ESS");
	int nsel;
	nsel = parent->m_pisdnWAN->m_ComBoxModemTypes.FindStringExact(-1,strRHS );
	if (nsel == CB_ERR )
	   nsel = 0;
	parent->m_pisdnWAN->m_ComBoxModemTypes.SetCurSel ( nsel );
	parent->m_pisdnWAN->m_ComBoxModemTypes.GetLBText (nsel,parent->m_pisdnWAN->m_szSectionName );

/* sudha 14 nov 1998 */
	if (j == 0)		
	{		
		parent->m_advisdnWAN->m_nSelectedIsdn = m_ComBoxModemTypes.GetCurSel();
		parent->m_advisdnWAN->m_INISectionControl.SetCurSel (parent->m_advisdnWAN->m_nSelectedIsdn);
	}			


}

// Brindha for  AG  - but,  there  is  no  m_RBtnAnswering  in CWanIsdnPort. 
// What to  do ? - Doubtful !  To  be  Clarified with Sir !
BOOL CWanIsdnPort::ValidEditFields()
{
    
    CWanIsdnTab *parent = (CWanIsdnTab *)GetParent();
    if (!parent->m_pisdnWAN->m_RBtnDialling.GetCheck()) 
	{
        if (parent->m_pisdnWAN->m_port_inactivity_timeout < 1 || parent->m_pisdnWAN->m_port_inactivity_timeout > 50)
        {
            ::MessageBox (parent->GetSafeHwnd(), "Enter an integer value between 1 and 50",
			"WAN - Info", MB_OK | MB_ICONINFORMATION);
		    parent->m_pisdnWAN->m_ctrl_port_inactivity_timeout.SetFocus();
		    return FALSE;
	    }
    }
	return TRUE ;
}

/////////////////////////////////////////////////////////////////////////////
// CWanIsdnTab dialog


CWanIsdnTab::CWanIsdnTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(CWanIsdnTab::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWanIsdnTab)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
	m_pisdnWAN = new CWanIsdnPort (this);
	m_advisdnWAN = new CWanIsdnDlg (this);
}

void CWanIsdnTab::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWanIsdnTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWanIsdnTab, CTabDialog)
	//{{AFX_MSG_MAP(CWanIsdnTab)
		// NOTE: the ClassWizard will add message map macros here
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWanIsdnTab message handlers

BOOL CWanIsdnTab::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	
	char Buf[4][16] ;
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	strcpy (Buf[0], " &WAN ") ;
	strcpy (Buf[1], " &Advanced ") ;

	// Add the Tabs
	addTabView (m_pisdnWAN, Buf[0], TRUE, TRUE, 80) ;
	addTabView (m_advisdnWAN, Buf[1], TRUE, FALSE, 80);
	
   // Get all the parameters of all the ports from INI file
   CenterWindow() ;

	CMainDlg *pMainDialog = (CMainDlg *) GetParent() ;
	RouterStatus = pMainDialog->RouterUp && pMainDialog->TargetFound ;

	GetConfig() ; 
   AfxGetApp()->DoWaitCursor(0) ;
	
   CTabDialog::OnInitDialog() ;
                                            
	return FALSE ;
}


void CWanIsdnTab::GetConfig()
{
    char szBuf[80] ;

   // Get all the parameters for Ports
   // Get the BOOL parameters.      
  	char field[80] ;

  	int i = 0;
	char Buf[12] ;
	_itoa (i, Buf, 10) ;
		
	strcpy (field, "WAN Port") ;
	strcat (field, Buf) ;
	strcpy (Buf, field) ;
	GetPrivateProfileString (WANSectionHeader,
			(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
  	if (!strcmp (szBuf, StrEnabled))
  		m_pisdnWAN->m_WANPort = TRUE ;
  	else
   	m_pisdnWAN->m_WANPort = FALSE ;

	m_pisdnWAN->m_RBtnAsync.SetCheck (1) ;
	m_pisdnWAN->m_RBtnAsync.EnableWindow(FALSE);
	 
	strcpy (field, Buf) ;
	strcat (field, " Script") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) StrDisabled, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_pisdnWAN->m_bScriptEnable = TRUE ;
	else
		m_pisdnWAN->m_bScriptEnable = FALSE ;
        
	strcpy (field, Buf) ;
	strcat (field, " Restart Script On Comm Failure") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) StrDisabled, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_pisdnWAN->m_bRestartScriptOnCommFailure = TRUE ;
	else
		m_pisdnWAN->m_bRestartScriptOnCommFailure = FALSE ;

	m_pisdnWAN->m_RBtnDialling.SetCheck (1) ;
/* sudha made changes here to make the port to dial in as well as dial out */
#if 0
	m_pisdnWAN->m_RBtnDialling.EnableWindow(FALSE);
#endif

   // Get the CString parameters.
   strcpy (field, Buf) ;
   strcat (field, " Speed") ;
   GetPrivateProfileString (WANSectionHeader,
   	(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),
	     (LPCSTR) IniInWinForm) ;

   m_pisdnWAN->m_cboxAsyncBaud = szBuf ;
   m_pisdnWAN->m_OldSpeedStr = szBuf ;

/* Sudha 04 Nov 1998.... */
		strcpy (field, "ISDN Port0 Extra Initialization String8");
      GetPrivateProfileString (WANSectionHeader,  
	 		(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),  
		     (LPCSTR) IniInWinForm) ;  
		m_pisdnWAN->m_isdn_str = szBuf;
/* Sudha 04 Nov 1998.... */

	m_pisdnWAN->GetIsdnTypes(0);	
/* Sudha 8 June 1998 */	  
   ReadISDNInfoFromRouconIniToIsdntaIni(0);


//Vidy 30/4/98	  vvvv
	//DOD related control handling
	wsprintf (field, "PPP Port0 Connection Dial On Demand");
	GetPrivateProfileString ((LPCSTR) PPPSectionHeader, 
			(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
				(LPCSTR) IniInWinForm);
	if (!strcmp (szBuf, StrEnabled))
		m_pisdnWAN->m_LnkCtrlWnd.SetCheck(1);		
	else
		m_pisdnWAN->m_LnkCtrlWnd.SetCheck(0);		

//	m_pisdnWAN->OnCheckDodEnable();	//display controls greyed or not

	//get the idle time and update display
	int tempnum;
	wsprintf (field, "PPP Port%d Connection Idle Timer", i);
	tempnum = GetPrivateProfileInt ((LPCSTR) PPPSectionHeader, 
		(LPCSTR) field, 0, (LPCSTR) IniInWinForm);
	m_pisdnWAN->m_Idle_time = tempnum / 60;
//Vidy 30/4/98 ^^^^

// Added  by  Brindha  for  AG  on  24/10/98
    sprintf (field, "%s%d%s", "AG Port", i, " General Name") ;
	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
	    (LPCSTR) field, (LPCSTR) "MODEM", (LPSTR) szBuf,
		    sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	m_pisdnWAN->m_ctrl_general_name.LimitText (8) ;
	m_pisdnWAN->m_general_name = szBuf ;

	sprintf (field, "%s%d%s", "AG Port", i, " Specific Name") ;
	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
	    (LPCSTR) field, (LPCSTR) "LINE1", (LPSTR) szBuf,
		    sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	m_pisdnWAN->m_ctrl_specific_name.LimitText (14) ;
	m_pisdnWAN->m_specific_name = szBuf ;

	sprintf (field, "%s%d%s", "AG Port", i, " Idle Time") ;
    tempnum = GetPrivateProfileInt ((LPCSTR) AGSectionHeader,
		          (LPCSTR) field, 0, (LPCSTR) IniInWinForm) ;
	m_pisdnWAN->m_port_inactivity_timeout = tempnum ; 

// Added  by  Brindha  for  AG  on  24/10/98

	// Update the Dialog fields  
	m_pisdnWAN->UpdateData (FALSE) ;
}

void CWanIsdnTab::OnOK()
{
	if (!AcceptConfig()) 
		return ;
	CTabDialog::OnOK() ;
	return ;
}

void CWanIsdnTab::OnCancel()
{
	CTabDialog::OnCancel();
}

int CWanIsdnTab::AcceptConfig()
{
	LPCSTR temp ;
	char m_szTempBuf[21],strRHS[40] ;
	temp = (char *) m_szTempBuf ;

	char TempLSL[] = "LSL ", TempWAN[] = "WAN " ;
	char TempPort[] = "Port", TempSpeed[] = " Speed" ;

	BOOL FLAG ;
	
   //Write all parameters for Ports
   //Write BOOL parameters
	char field[80] ;

	int i = 0;
	char Buf[12] ;
	_itoa (i, Buf, 10) ;
		
	strcpy (field,"WAN Port") ;
	strcat (field,Buf) ;
	strcpy (Buf,field) ;     

  	m_pisdnWAN->UpdateData (TRUE) ;
	
   if (m_pisdnWAN->m_WANPort)
  		temp = StrEnabled ;
   else
   	temp = StrDisabled ;
	
   WritePrivateProfileString (WANSectionHeader,
	   	(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	// If WAN is disabled then disable PPP, SLIP and Frame Relay
	if (!m_pisdnWAN->m_WANPort)
	{
		CMainDlg *pParent = (CMainDlg *)GetParent();
		pParent->EnablePPP (i, FALSE);
		pParent->EnableSLIP (i, FALSE);
   }
			
  	strcpy (field, Buf) ;
   strcat (field, " Async") ;
   if (m_pisdnWAN->m_RBtnAsync.GetCheck())
		temp = StrEnabled ;
	else
		temp = StrDisabled ;                              

	FLAG = m_pisdnWAN->m_RBtnAsync.GetCheck() ? TRUE : FALSE ;
	
	WritePrivateProfileString (WANSectionHeader,
			(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	strcpy (field, Buf) ;
	strcat (field, " Script") ;
	if (m_pisdnWAN->m_bScriptEnable)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	strcpy (field, Buf) ;
	strcat (field, " Restart Script On Comm Failure") ; 
	if (m_pisdnWAN->m_bRestartScriptOnCommFailure)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	strcpy (field, Buf) ;
	strcat (field, " Speed") ;
	// Modified by cfp on 25-3-96
	// To See that no Null Speed is in Combo box
	// and later written to ini file
	char BaudBuf[15] ;
	if (m_pisdnWAN->m_cboxAsyncBaud.IsEmpty())
		m_pisdnWAN->m_cboxAsyncBaudWnd.GetLBText (0, (LPSTR) BaudBuf) ;
	else
		strcpy (BaudBuf, m_pisdnWAN->m_cboxAsyncBaud) ;
	WritePrivateProfileString(WANSectionHeader, (LPCSTR) field,
		(LPCSTR) BaudBuf, (LPCSTR) IniInWinForm) ;

/* Sudha 04 Nov 1998..... */
			sprintf (field, "ISDN Port0 Extra Initialization String8");
			sprintf ( strRHS,"%s",m_pisdnWAN->m_isdn_str );
			WritePrivateProfileString ( WANSectionHeader,field,strRHS,IniInWinForm );
/* ....Sudha 04 Nov 1998 */

	sprintf ( field,"ISDN WAN Port%d",i);
	WritePrivateProfileString ( WANSectionHeader,(LPCSTR) field,
		StrEnabled,IniInWinForm );
	strcpy (strRHS, m_pisdnWAN->m_szSectionName);
	sprintf ( Buf,"Port%d",i);
/* Sudha 8 June 1998 */
   WritePrivateProfileString ( MapHeader,(LPCSTR)Buf,strRHS,ini_INIFilename );
	WriteInfoInIni ( Buf, strRHS );

   // Write CString Parameters
	if (FLAG)
	{
		// 2/11/95 Vidy
		// Update the LSL speed also for SNMP to report it properly
		strcpy(field, "LSL Port1");
	   strcat (field," Speed") ;
		// Modified by cfp on 25-3-96
		WritePrivateProfileString(LSLSectionHeader, (LPCSTR) field,
			  (LPCSTR) m_pisdnWAN->m_cboxAsyncBaud, (LPCSTR) IniInWinForm) ;
  	}


//Vidy 30/4/98 vvvvvvv
	//Save the DOD parameteres
	if (m_pisdnWAN->m_LnkCtrlWnd.GetCheck())
		temp = StrEnabled ;
	else
		temp = StrDisabled ;

	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
		(LPCSTR) "PPP Port0 Connection Dial on Demand",
		(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_pisdnWAN->m_Idle_time < 0 || m_pisdnWAN->m_Idle_time > 500)
		m_pisdnWAN->m_Idle_time = 10;	// if limits exceed, set to default

	wsprintf (m_szTempBuf, "%d", m_pisdnWAN->m_Idle_time * 60);
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
		(LPCSTR) "PPP Port0 Connection Idle Timer",
		(LPCSTR) m_szTempBuf, (LPCSTR) IniInWinForm);

//Vidy 30/4/98	^^^^^^^

// Added  by  Brindha  for  AG  on  24/10/98
    strcpy (field, "AG");
	GetPrivateProfileString ((LPCSTR) AGSectionHeader,
	    (LPCSTR) field, StrDisabled, strRHS, sizeof (strRHS),
		    (LPCSTR) IniInWinForm) ;
	if (!strcmp (strRHS, StrEnabled))
	{
		sprintf (field, "%s%d%s", "AG Port", i, " General Name") ;
		WritePrivateProfileString ((LPCSTR) AGSectionHeader,
			(LPCSTR) field, (LPCSTR) m_pisdnWAN->m_general_name,
				(LPCSTR) IniInWinForm) ;
		sprintf (field, "%s%d%s", "AG Port", i, " Specific Name") ;
		WritePrivateProfileString ((LPCSTR) AGSectionHeader,
			(LPCSTR) field, (LPCSTR) m_pisdnWAN->m_specific_name,
				(LPCSTR) IniInWinForm) ;

		sprintf (field, "%s%d%s", "AG Port", i, " Idle Time") ;
        wsprintf (m_szTempBuf, "%d", m_pisdnWAN->m_port_inactivity_timeout);
		WritePrivateProfileString ((LPCSTR) AGSectionHeader,
			(LPCSTR) field, (LPCSTR) m_szTempBuf,
				 (LPCSTR) IniInWinForm) ;
	}

	return TRUE ;
}					

void CWanIsdnTab::WriteInfoInIni(char *Buff,char *RHS )
{
	char strLHS[40],strRHS[40] ;
	CIsdnTa Isdn;
	BOOL US = FALSE;
	
	//Configuration Name
	sprintf ( strLHS,"ISDN WAN %s ConfigName",Buff );
	WritePrivateProfileString(WANSectionHeader,strLHS,RHS,IniInWinForm);
	
	strcpy ( InitstrRHS,"AT");
	sprintf(InitstrLHS,"ISDN %s Initialization String1",Buff);

	//IDD_NETWORK_SWITCH_TYPE member
	WriteToRouconIni(RHS,"NetworkSwitchType","NI - 1",cfg_NetworkSwitchTypes,"!C0=");

	GetPrivateProfileString ( RHS,"NetworkSwitchType","NET3",strRHS,
		sizeof ( strRHS ),ini_INIFilename );
	US = Isdn.SwitchType ( strRHS );

	//IDD_NETWORK_CFG_I member
	WriteToRouconIni(RHS,"DataTEI","Auto TEI",cfg_TEI,"!D3=");
	WriteToRouconIni(RHS,"VoiceTEI","Auto TEI",cfg_TEI,"*!D3=");

	//IDD_NETWORK_CFG_II_US member
	WriteToRouconIni(RHS,"DataSPID","",cfg_null,"!C6=");
	WriteToRouconIni(RHS,"VoiceSPID","",cfg_null,"*!C6=");

	if ( US == TRUE )
	{
		WriteToRouconIni(RHS,"DataDirectoryNumber","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceDirectoryNumber","",cfg_null,"*!N1=");

	}
	
	//IDD_NETWORK_CFG_II_EUROPE
	else
	{	
		WriteToRouconIni(RHS,"DataMSN","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceMSN","",cfg_null,"*!N1=");

	}
	//IDD_CALL_CTRL_CFG
	
	WriteToRouconIni(RHS,"AutoAnswer","Yes",cfg_NoYes,"S0=");
	WriteToRouconIni(RHS,"PersistentDTRDialing","No",cfg_NoYes,"$D");
	WriteToRouconIni(RHS,"DialingMethod","Enbloc",cfg_DialingMethods,"%A97=");
	WriteToRouconIni(RHS,"RingsToAnswer","1",cfg_null,"S0=");
	WriteToRouconIni(RHS,"CallLineId","No",cfg_NoYes,"S50=");

	//IDD_DATA_PROTOCOL
	WriteToRouconIni(RHS,"DataProtocol","V.120",cfg_DataProtocols,"!Z=");
	WriteToRouconIni(RHS,"DataCompression","None",cfg_DataCompression,"&K");
	WriteToRouconIni(RHS,"AutoDetection","No",cfg_NoYes,"S52=");

	if ( strlen ( InitstrRHS ) > 2 )
	{
		WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
		InitstrLHS[32]++;
	}

/* Sudha 29 June 1998 */
   WritePrivateProfileString ( WANSectionHeader,InitstrLHS,"AT&W",IniInWinForm );
		InitstrLHS[32]++;

#if 0
	char max[2];
	int maxnum;

	sprintf ( max,"%c",InitstrLHS[32]);
	sscanf ( max,"%d",&maxnum);
 
	for ( int i = maxnum; i < 20;i++)
	{
		sprintf ( strLHS,"ISDN %s Initialization String%d",Buff,i);
		WritePrivateProfileString ( WANSectionHeader,strLHS,NULL,IniInWinForm );
	}
#endif
/* Sudha 29 June 1998 */	
	return;
}

void  CWanIsdnTab::WriteToRouconIni(LPCSTR Section,LPCSTR strLHS,LPCSTR Default,ini_tpValuePair Table,const char* command)
{
   char strRHS[40],tempstr[40];
	CString String;
	int value,len = 0;

	GetPrivateProfileString(Section,strLHS,Default,
		strRHS,sizeof(strRHS),ini_INIFilename);
	if (Table != cfg_null)
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			for(int i=0; Table[i].StringID;i++)
			{
				String.LoadString(Table[i].StringID );
				if (!strcmpi(String,strRHS))
				{	
					value = Table[i].nNum;
					break;
				}
			}
			sprintf(strRHS,"%s%d",command,value);
		}
	}
	else
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			sprintf(tempstr,"%s%s",command,strRHS);
			strcpy(strRHS,tempstr);
		}
	}

// Sudha 10 Feb 1998 
   if ( IsSPIDorISDN (command))
   {
   	if (!strcmp ( command,"!C6="))
      {      
      	WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
      }
	   strcat ( InitstrRHS , strRHS );
      WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
      strcpy ( InitstrRHS ,"AT");
	   InitstrLHS[32]++;
   }
   else
   {
		len = strlen ( strRHS ) + strlen ( InitstrRHS ) ;
		if ( len <= ( MAX_INIT_STRING_LENGTH - 2 ))
		strcat ( InitstrRHS , strRHS );
	
		if ( len >= ( MAX_INIT_STRING_LENGTH - 2 ))
		{
			WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
			strcpy ( InitstrRHS ,"AT");
			InitstrLHS[32]++;
			if ( len > ( MAX_INIT_STRING_LENGTH - 2 ) )
				strcat ( InitstrRHS , strRHS );
		}
	}
	return ;
}


void CWanIsdnPort::OnCheckDodEnable()
{
	// TODO: Add your control notification handler code here
	if (m_LnkCtrlWnd.GetCheck())
	{
	}
	else
	{
	}
}

void CWanPortDlg::OnDialAnswer()
{
	// TODO: Add your control notification handler code here

	m_RBtnAnswering.SetCheck (0) ;
	m_RBtnDialling.SetCheck (0) ;
	m_ctrl_dial_answer.SetCheck (1) ;

// Brindha on 27/4/99.
	m_ctrl_proxy_enable.SetCheck (1) ;
	m_ctrl_ag_enable.SetCheck (1) ;
	m_ctrl_ras_enable.SetCheck (1) ;

	OnControl() ;
	return ;
	
}
/* Sudha 30 July 1998 */

void CWanIsdnPort::OnSelchangeComboModemTypes()
{
	// TODO: Add your control notification handler code here
	CWanIsdnTab *parent = (CWanIsdnTab *) GetParent();

	int index = m_ComBoxModemTypes.GetCurSel();
	if ( index != CB_ERR )
	{
		parent->m_advisdnWAN->m_nSelectedIsdn = index;
		parent->m_advisdnWAN->m_INISectionControl.SetCurSel(index);
	}
}
/* Sudha 30 July 1998 */

void CWanPortDlg::OnSelchangeComboModemTypes()
{
	// TODO: Add your control notification handler code here
	CWanTab *parent = (CWanTab *) GetParent();

	int index = m_ComBoxModemTypes.GetCurSel();
	if ( index != CB_ERR )
	{
		parent->m_advdlgWAN->m_nSelectedModem = index;
		parent->m_advdlgWAN->m_nSelectedIsdn = index;
		if ((model == MODEL_MTSR3_200) || (model == MODEL_MTSR2_201))
			parent->m_advdlgWAN->m_combBoxModemTypes.SetCurSel(index);
		if ((model == MODEL_MTSR1_202ST) || (model == MODEL_MTSR1_202NT) ||
			(model == MODEL_MTSR2_201))
			parent->m_advdlgWAN->m_INISectionControl.SetCurSel(index);
	}
}

void CWanPortDlg::OnCheckProxyEnable()
{
	// TODO: Add your control notification handler code here
	OnControl() ;

	
}

void CWanPortDlg::OnCheckRasEnable()
{
	// TODO: Add your control notification handler code here
	OnControl() ;
}

void CWanPortDlg::OnCheckAgEnable()
{
	// TODO: Add your control notification handler code here
	OnControl() ;
}
