#include <stdio.h>
#include <stdlib.h>
#include <conio.h>
#include <string.h>
#include <dos.h>
#include "uitypes.h"
#include "uart.h"
#include "crc.c"
#include "uierr.h"

int com1=0x3f8;					   
int to_rcv_buff_reg;   /*=com1;  */
int to_trn_hld_reg;    /*=com1;  */
int to_int_enbl_reg;   /* =com1+1; */
int to_int_id;         /*  =com1+2; */
int to_data_fmt_reg;   /*  =com1+3; */
int to_mdm_ctrl_reg;   /* =com1+4;  */
int to_line_status_reg; /*  =com1+5;  */
int to_mdm_status_reg;  /* =com1+6;  */
int dt_count=0;
int crc_i=0;
byte crc_buff[256];
byte SHOW_CLK_TICKS=(byte)0;

extern int time_ticks, time_on, TOTAL_TIME_TICKS;
extern int DOWN_LOAD;
extern void display_string(byte *, int, byte, byte *);
extern void h2str(dword, byte *, byte);
extern byte *GetMem(word);
extern int CODE_CRC;
extern byte snd_buff[];
extern int snd_i;


void (_interrupt far *oldvect)();
void delay();

void clr_buff()
  {
	  int i=0;
     while (i < 255)
        crc_buff[i++]=0;
  } 
/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : init_uart()																 */
/* PURPOSE       : To initialise the UART with appropriate values 				 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void init_uart()
  {
	 /*------com1 holds the base address of UART port------*/
	 to_rcv_buff_reg=com1;
	 to_trn_hld_reg=com1;
	 to_int_enbl_reg=com1+1;
	 to_int_id=com1+2;
	 to_data_fmt_reg=com1+3;
	 to_mdm_ctrl_reg=com1+4;
	 to_line_status_reg=com1+5;
	 to_mdm_status_reg=com1+6;
	 /*------Set the MSB of the data format registe----------*/
    _outp(to_data_fmt_reg, 0x80);  
	 delay();
	 /*------------set the baud rate to 19200-------------*/
  	 _outp(to_rcv_buff_reg, 6);
	 delay();
	 _outp(to_int_enbl_reg, 0);
	 delay();
	 /*-------initialise the data format register(8N1)---------*/ 
	 _outp(to_data_fmt_reg, 3);
	 delay();
	 _outp(to_int_enbl_reg, 0);  /*------disable the interrupts-----*/
	 delay();
	 _outp(to_mdm_ctrl_reg, 3);   
	 delay();
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : reset_uart()																 */
/* PURPOSE       : To reset the UART 														 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void reset_uart()
  {
    _outp(0x21, 0x21);
	 _outp(to_int_enbl_reg, 0);
	 _outp(to_mdm_ctrl_reg, 3);
	 delay();
	 _inp(to_rcv_buff_reg);  /*-----clear the recieve buffer------*/
	 _inp(to_int_id);
	 _inp(to_mdm_status_reg);
	 delay();
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : delay																		 */
/* PURPOSE       : To pause for sometime													 */
/* PARAMETER     : NONE																			 */ 
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void delay()
  {
	  int i=0;
	  while (i++ < 1000);
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : snd_char(ch)																 */
/* PURPOSE       : To send a character on the serial  line							 */
/* PARAMETER     : ch																			 */
/*                    -char																	 */
/*                    -holds the character to be sent on the serial line		 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void snd_char(byte ch)
  {
    int i;
	 i=_inp(to_line_status_reg);
	 while (!(i & (1 << 5)))    /*---while transmitter buffer is not empty----*/
	   i=_inp(to_line_status_reg);
	 _outp(to_trn_hld_reg, (int)ch);
	 snd_buff[snd_i]=ch;
	 snd_i++; 
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_char0()																 */
/* PURPOSE       : To receive a character from the UART								 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : character receved on the serial line								 */
/*-----------------------------------------------------------------------------*/
char rcv_char0()
  {
    int i;
	 i=_inp(to_line_status_reg);
	 while (!(i & 1))  /*---while the receive buffer is empty----*/
		  i=_inp(to_line_status_reg);
	 i=_inp(to_rcv_buff_reg);
    crc_buff[crc_i]=i;
	 crc_i++;
 /* 	 printf("%02x\n", i); */
	 return((char)i);
  }
/*-----------------------------------------------------------------------------*/


void clear_uart_buff()
  {
	 int i;
	 i=_inp(to_line_status_reg);
	 while (i & 1)
		{
		 _inp(to_rcv_buff_reg);
		 i=_inp(to_line_status_reg);
		}
  }


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_char1()																 */
/* PURPOSE       : To receive a character from the serial line						 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : returns character recevied from the serial line or 0.		 */
/*-----------------------------------------------------------------------------*/
char rcv_char1()
  {
    int i;
	 byte *str;
	 str=(byte *)GetMem(sizeof(byte)*5);  
	 i=_inp(to_line_status_reg);
	 time_ticks=0;
	 /*------while receive buffer is empty and not timed out--------*/
	 while (!(i & 1) && time_ticks <= TOTAL_TIME_TICKS )
	   {
	     i=_inp(to_line_status_reg);
		  if (SHOW_CLK_TICKS==(byte)1)
		    {			  
			   h2str((dword)time_ticks, str, 0x0a);
				display_string(str, 0x0f2c, 0x0f, (void *)0); 
			 }   															 
		}
	 time_on=0;
/*	 if (_kbhit())
	   {
		  get_key();
		  time_ticks=TOTAL_TIME_TICKS+1;
		}  */
	 if (time_ticks > TOTAL_TIME_TICKS)
		return((char)0);
	 else
	   return((byte)(crc_buff[crc_i++]=(byte)_inp(to_rcv_buff_reg)));  
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_char()																	 */
/* PURPOSE       : To receive a character													 */
/* PARAMETER     : NONE																			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
char rcv_char()
  {
    char (*rcv_fns[2])()={rcv_char0, rcv_char1};
	 return((*rcv_fns[time_on])());
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : quote_and_snd(ch)														 */
/* PURPOSE       : To send a character on serial line with quoting if necessary*/
/* PARAMETER     : ch																			 */
/*                   -holds the character to be sent									 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void quote_and_snd(byte ch)
  {
    switch((byte) ch)
		{ 
		  case (byte)0x7e : /*-----ch='~'-----*/
		                    snd_char((byte)0x7d);
								  snd_char((byte)0x5e);
								  break;
		  case (byte)0x7d : snd_char((byte)0x7d);
								  snd_char((byte)0x5d);
								  break;
		  case (byte)0x13 : snd_char((byte)0x7d);
		                    snd_char((byte)0x33);
								  break;
		  case (byte)0x11 : snd_char((byte)0x7d);
		                    snd_char((byte)0x31);
								  break;
		  case (byte)0x93 : snd_char((byte)0x7d);
		                    snd_char((byte)0x93^0x20);
								  break;
		  case (byte)0x91 : snd_char((byte)0x7d);
		                    snd_char((byte)0x91^0x20);
								  break;
		  default          :snd_char((byte)ch);
								  break;
		 }
 }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : snd_packet(pkt_data, pkt_size)										 */
/* PURPOSE       : To send a packet on serial line with necessary quoting along*/
/*                  with crc check value													 */
/* PARAMETERS    : pkt_data																	 */
/*                    -pointer to an array of bytes									 */
/*                    -points to the data to be sent on serial line				 */
/*                 pkt_size																	 */
/*                    -integer																 */
/*                    -holds the length of the data to be sent on serial line	 */
/* RETURN VALUE   : NONE																		 */
/*-----------------------------------------------------------------------------*/
void snd_packet(byte *pkt_data, int pkt_size)
  {
     int i=0;
	  int crc=0xffff;
	  snd_i=0;
	  snd_char((byte)0x7e);   /*-----send the quote character------*/
	  i=0;
	  while (!DOWN_LOAD && i < 4)
	    {
			 /*------pkt is not down load packet------*/
			 quote_and_snd(BridgeId[i]);
			 crc=updcrc(BridgeId[i], crc);
			 i++;
		 }
	  i=0;
	  while (i < pkt_size)
	    {
			quote_and_snd(pkt_data[i]);
			crc=updcrc(pkt_data[i], crc);
		  i++;
		 }
	  crc=updcrc(0, updcrc(0, crc));
	  quote_and_snd((byte)((crc >> 8) & 0xff)); /*---send Ist byte of crc----*/
	  quote_and_snd((byte)(crc & 0xff));        /*---send IInd byte of crc---*/  
	  snd_char((byte)0x7e);							  /*---send quote character----*/
  }
/*-----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : chk_overrun()
/* PURPOSE       : To check whether a overrun of data has occured in UART
/* PARAMETER     : NONE
/* RETURN VALUE  : returns 1 or 0
/*-----------------------------------------------------------------------------*/
int chk_overrun()
  {
	  return(_inp(to_line_status_reg) & 2);
  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_packet(pkt_data, pkt_size)										 */
/* PURPOSE       : To receive a packet of length pkt_size.							 */
/* PARAMETERS    : pkt_data																	 */
/*                    -pointer to an array of bytes									 */
/*                    -acts like a buffer for the data to be received			 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
int rcv_packet(byte *pkt_data, int pkt_size)
  {
     int i=0;
	  int crc=0xffff;
	  byte ch;
	  clr_buff();
	  crc_i=0;
	  /*---while the recevied character is not 7e or not timed out do------*/
 	  while ((rcv_char()!=(byte)0x7e) && time_ticks < 55)
	    {
		   time_on=1;
	    }
	  if (time_ticks < 55)
	    {
			 /*-----7e received------*/
	       if (chk_overrun())
			    {
	            display_string((byte *)"over run", 0x1010, 0x1f, (void *)0);
				 }
	       while (i < 4)  /*----recevie BridgeId-----*/
	         {
		          if (chk_overrun())
					   {
			          display_string((byte *)"over run", 0x1010, 0x1f, (void *)0);
						}
		          ch=rcv_char();
					 if (ch==(byte)0x7d)	 
					   {
						   ch=rcv_char();
						   ch=(byte)((int)ch ^ 0x20);  /*---unquote ch----*/
						 }
			       crc=updcrc(ch, crc);
			       i++;
		      }
	       i=0;
	       while (i < pkt_size) /*----receive the data packet-----*/
	         { 
		         if (chk_overrun())
					  {
			          display_string((byte *)"over run", 0x1010, 0x1f, (void *)0);
					  }
			      ch=rcv_char(); 
					if (ch==(byte)0x7e)
					   break; 
			      if (ch==(byte)RES_TYPE  && i==0)
			        {
						 /*---result type packet-----*/
			          pkt_size=sizeof(ResultType);
			        }
               /*--------crc=updcrc(ch, crc);---------*/
			      if (ch==(byte)0x7d)
			        {
				        if (chk_overrun())
					       printf("over run");
				        ch=rcv_char();
					     pkt_data[i]=(byte)((int)ch ^ 0x20);  /*---unquote ch----*/
					     /*----crc=updcrc(pkt_data[i], crc);----*/
				      }
			      else
			         pkt_data[i]=ch;
					crc=updcrc(pkt_data[i], crc);
			      i++;
		       }
				 ch=(byte)0;
				 if (i==pkt_size)
	             ch=rcv_char();  
	          while (ch != (byte)0x7e)  /*--while received character is not 7e--*/
	            {
						 if (ch==(byte)0x7d)
							{
							  ch=rcv_char();
							  ch=(byte)((int)ch ^ 0x20);  /*---unquote ch----*/
							}
		             crc=updcrc(ch, crc);
		             ch=rcv_char();
		          }  
		       if (crc)
					 {
		            error_win((byte *)"Crc Error", 15, 10, 21); 
					 }
				 return(crc);
          }
			return(0);
	  }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : rcv_dnld_packet(pkt_data, pkt_size)								 */
/* PURPOSE       : To receive a packet of type down load(i.e., without bridgeId*/
/* PARAMETERS    : pkt_data																	 */
/*                   -pointer to an array of bytes										 */
/*                   -acts like a buffer for the received data						 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
int rcv_dnld_packet(byte *pkt_data, int pkt_size)
  {
     int i=0;
	  int crc=0xffff;
	  byte ch;
	  crc_i=0;
	  time_on=1;
     clr_buff();
	  /*--While the received character is not 7e and not time out----*/
 	  while ((rcv_char()!=(byte)0x7e) && time_ticks < TOTAL_TIME_TICKS)
	    {
	      time_on=1;
	    }
	  if (time_ticks < TOTAL_TIME_TICKS)
	    {
			 /*----7e received-----*/
			 crc_i=1;
	       if (chk_overrun())
			    {
	            display_string((byte *)"over run", 0x1010, 0x1f, (void *)0);
				 }
	       i=0;
	       while (i < pkt_size)	 /*----receive the data packet------*/
	         { 
		         if (chk_overrun())
					  {
			          display_string((byte *)"over run", 0x1010, 0x1f, (void *)0);
					  }
				   time_ticks=0;
			      ch=rcv_char(); 
					if (ch==(byte)0x7e)
					   break;  
			      if (ch==(byte)RES_TYPE  && i==0)
			        {
			          pkt_size=sizeof(ResultType);
			        }
			      /*  crc=updcrc(ch, crc); */
			      if (ch==(byte)0x7d)
			        {
				        if (chk_overrun())
					       printf("over run");
						  time_ticks=0;
				        ch=rcv_char();
						  /*----7d received, unquote the received character----*/
					     pkt_data[i]=(byte)((int)ch ^ 0x20);
					     crc=updcrc(pkt_data[i], crc);
				      }
			      else
					  {
					    crc=updcrc(ch, crc);
			          pkt_data[i]=ch;
					  }
			      i++;
		       }
				 if (i==pkt_size)
					{
	               ch=rcv_char();
	  //					display_string((byte *)"ok", 0x1015, 0x1f, (void *)0);
					}
	          while (ch != (byte)0x7e)  /*--while the received character is not 7e--*/
	            {
						 if (ch==(byte)0x7d)
							{
							  ch=rcv_char();
							  ch=(byte)((int)ch ^ 0x20);  /*---unquote ch----*/
							}
		             crc=updcrc(ch, crc);
		             ch=rcv_char();
		          }  
		       if (crc)
					{
					  /*	display_string((byte *)"      ", 0x0e10, 0x1f, (void *)0);
					      display_string((byte *)"crc", 0x0e10, 0x1f, (void *)0);
					   
					      display_string((byte *)crc_buff, 0x1010, 0x1f, (void *)0);
		             
					      error_win((byte *)"Crc Error1", 15, 10, 21);
						   getch();  
					  */
					}   
/*				 display_string((byte *)"                      ", 0x1010, 0x1f, (void *)0);
				 crc_buff[crc_i]=0;
				 display_string((byte *)crc_buff, 0x1010, 0x1f, (void *)0);  */
				 if (crc)
					{
						//display_string((byte *)"      ", 0x0e10, 0x1f, (void *)0);
				   }
				 return(crc);
          }
		  return(0);
     }
/*-----------------------------------------------------------------------------*/


/*-----------------------------------------------------------------------------*/
/* FUNCTION NAME : updatacrc(ch)																 */
/* PURPOSE       : To calculate the crc check for the down load data				 */
/* PARAMETER     : ch																			 */
/*                  -byte																		 */
/*                  -holds the character being down loaded							 */
/* RETURN VALUE  : NONE																			 */
/*-----------------------------------------------------------------------------*/
void updatecrc(byte ch)
  {
	 CODE_CRC=updcrc(ch, CODE_CRC);
  }
/*-----------------------------------------------------------------------------*/


void file_buff(byte far *fl_buff, FILE *fl)
  {
     int i=0;
	  int ch;
	  ch=fgetc(fl);
	  while (ch!=EOF)
	    {
		   fl_buff[i]=(byte)ch;
			CODE_CRC=updcrc(ch, CODE_CRC);
			i++;
			ch=fgetc(fl);
		 }
	  CODE_CRC=updcrc(0, updcrc(0, CODE_CRC));
	  fl_buff[i]=0;
  }

