// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	ROUCON.CPP
// Description       :	Defines the class behaviors for the application.
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :  Vidy 20/10/95
//								Vidy 7/11/95	added LSL and PPP dependency of WAN
// -------------------------------------------------------------------------


// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include "stdafx.h"
#include "procon.h"
#include "ctl3d.h"
#include "maindlg.h"
#include "mainfrm.h"
#include "roudoc.h"
#include "rouvw.h"
#include "poweron.h"
#include "wandefs.h"
#include "powercod.h"
#include "tftpread.h"
#include "tftpwrit.h"		// name was longer than 8.3 format. win95 wont work
#include "boot.h"
#include "usersdlg.h"
#include "compress.h"
#include "userscom.h"
#include "userdata.h"
#include "bootvers.h"
#include "tftpdnld.h"
#include	"ipprx.h"
#include "hardware.h"
#include "isddnld.h"

// -------------------------------------------------------------------------
// Global Variable Declarations
// -------------------------------------------------------------------------
// #define PollingTimerID 420	//Vidy removed the redefinition
#define PollingInterval 55	//55mSec timer for polling

#define CodeTimerID	840
#define CodeInterval 65000   // 65 Sec. timer for downloading code.

// #define Max_exitcount 0xff00 //Comeout if packet is not expected.

#define MaxINIString 150   // Maximum length of string in the CNF File.
#define TimerCount 4000    //Used for setting 4 Sec. timer.

#define  MTR_SETUP   "ProxyServer Setup"

BYTE model;
char LoadPath[FILE_NAME_SIZE] ;				// directory pathname of executable file
char OwnIniFile[FILE_NAME_SIZE] ;			// configuration ini file "SETUP.INI"
char IniInWinForm[FILE_NAME_SIZE] ;			// Router ini file in windows form
char NewIniInWinForm[FILE_NAME_SIZE];                   // New Router ini file in windows form
char ini_INIFilename[128] ;		//Isdnta ini file in windows form
char IniInRtrWareForm[FILE_NAME_SIZE] ;	// Router ini file in RouterWare form
char IniInRtrWareFormDef[FILE_NAME_SIZE] ;	// Router ini file in RouterWare form
char UDBCompressedDBaseFile[FILE_NAME_SIZE] ;    // Compressed User DBase File
char UDBUnCompressedDBaseFile[FILE_NAME_SIZE] ; //  Uncompressed User DBase File
char LogFileName[FILE_NAME_SIZE];
char EtherNetAddr[13] ;			// ethernet address - printable string
BOOL LookForTargetOnly ;
BOOL DownloadSetupOnly ;
BOOL DefaultSetup = FALSE; /* Sudha 3 June 1998 */
CString MessageString ;
CString WindowText ;

LPCSTR StrEnabled = "enabled" ;
LPCSTR StrDisabled = "disabled" ;
LPCSTR StrNull = "" ;

extern LPCSTR MainMsgHeader ;

BOOL DontReadConfiguration = FALSE ;
int CommandLineArgument = 0 ;

BOOL IsPortIP = FALSE ;		// is true if we are going to use TFTP
char TFTPPutLocalFileName[FILE_NAME_SIZE] ;
char TFTPPutRemoteFileName[TFTP_NAME_SIZE] ;
char TFTPGetLocalFileName[FILE_NAME_SIZE] ;
char TFTPGetRemoteFileName[TFTP_NAME_SIZE] ;

UINT NumberOfPorts = 2 ; // Just in case no assignment takes place

/* 9/7/97 chetan */
BOOL IsLanTalker = FALSE ;
BOOL IsRF200 = FALSE ;
/* 9/7/97 chetan */


#ifdef NEW_BOOT_2
DWORD CodeLoadAddress ;
DWORD CodeStartAddress ;
DWORD FlCodeStartAddress ;

char *DialogTitleFormat = "%s - %s";

TFTPCodeBurnStruct TFTPCodeAddressDetails ;
#endif /* NEW_BOOT_2 */

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif


// If these sizes are changed same changes
// should be carried out in \roucon\tftp\tftpcomp.c
// and in mtrouter.bin
#define MAX_READ_SIZE (8 * 1024) 
#define MAX_UNCOMP_SIZE (10 * 1024)

/////////////////////////////////////////////////////////////////////////////
// CRouconApp

BEGIN_MESSAGE_MAP(CRouconApp, CWinApp)
	//{{AFX_MSG_MAP(CRouconApp)
	ON_COMMAND(ID_APP_ABOUT, OnAppAbout)
		// NOTE - the ClassWizard will add and remove mapping macros here.
		//    DO NOT EDIT what you see in these blocks of generated code!
	//}}AFX_MSG_MAP
	// Standard file based document commands
	ON_COMMAND(ID_FILE_NEW, CWinApp::OnFileNew)
	ON_COMMAND(ID_FILE_OPEN, CWinApp::OnFileOpen)
	// Standard print setup command
	ON_COMMAND(ID_FILE_PRINT_SETUP, CWinApp::OnFilePrintSetup)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRouconApp construction

CRouconApp::CRouconApp()
{
	// TODO: add construction code here,
	// Place all significant initialization in InitInstance
}

int	CRouconApp::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	HWND	WindowWithFocus;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	WindowWithFocus = GetFocus();

	Ret_val = AfxGetMainWnd()->MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);

	SetFocus(WindowWithFocus);

	return Ret_val;

}


// vidy added this 19th Aug 95
void	RouconCrossCheckPPP(void)		
{
	int	port, number_of_enabled_wan_ports;
	char	PPPAsyncStr[80];
	char	WANAsyncStr[80];
	char	szBuf[30];
	char	WANPortStr[80], LSLPortStr[80], PPPPortStr[80];
	
	strcpy(PPPAsyncStr, "PPP Port0 Asynchronous Link");
	strcpy(WANAsyncStr, "WAN Port0 ASYNC");

	for (port = 0; port < 3; port++) {
		// make string for the proper port number
		PPPAsyncStr[8] = '0' + port;
		WANAsyncStr[8] = '0' + port;
		// read the port WAN async type
		GetPrivateProfileString(WANSectionHeader,
			(LPCSTR) WANAsyncStr, StrNull,(LPSTR) szBuf ,sizeof(szBuf),
			(LPCSTR) IniInWinForm);
		if (szBuf[0]) {
			WritePrivateProfileString(PPPSectionHeader, 
				(LPCSTR) PPPAsyncStr, (LPCSTR) szBuf, (LPCSTR) IniInWinForm);
		}
	}

	/* we need to update the LSL section and PPP section setup
	based on the WAN port setup, for number of ports and their
	enabled/disabled state, this is for SNMP to report correctly
	7.11.95*/

	strcpy(WANPortStr, "WAN Port0");
	strcpy(LSLPortStr, "LSL Port1");	//LSL port 0 is Ethernet
	strcpy(PPPPortStr, "PPP Port0");
	number_of_enabled_wan_ports = 0;

	for (port = 0; port < 3; port++) {
		// make string for the proper port number
		WANPortStr[8] = '0' + port;
		LSLPortStr[8] = '1' + port;	//LSL port 0 is Ethernet
		PPPPortStr[8] = '0' + port;
		// read the port WAN async type
		GetPrivateProfileString(WANSectionHeader,
			(LPCSTR) WANPortStr, StrNull,(LPSTR) szBuf ,sizeof(szBuf),
			(LPCSTR) IniInWinForm);
		if (szBuf[0]) {
			WritePrivateProfileString(LSLSectionHeader, 
				(LPCSTR) LSLPortStr, (LPCSTR) szBuf, (LPCSTR) IniInWinForm);
			WritePrivateProfileString(PPPSectionHeader, 
				(LPCSTR) PPPPortStr, (LPCSTR) szBuf, (LPCSTR) IniInWinForm);
		}
		if ( !strcmp(szBuf, StrEnabled))
			number_of_enabled_wan_ports++;
	}
}

// -------------------------------------------------------------------------
// Function 			:	CRouconApp::RAWriteRouterINI()
// Arguments			:  None.
// Synopsis 			:  Converts Windows INI to MTRouter CNF, only if the Windows 
//                  		INI is changed after Reading.
// Returns  			:  TRUE if it is changed, else FALSE.
// Globals Affected  :  None.
// -------------------------------------------------------------------------
BOOL CRouconApp::RAWriteRouterINI()
{
   char Buf[80];
   char* pInFileName;
   if (CommandLineArgument == 6)	        								   
      pInFileName = NewIniInWinForm ;
   else
      pInFileName = IniInWinForm ; 
   CStdioFile input;
   if(!input.Open( pInFileName, CFile::modeRead | CFile::typeText ))
   {
		sprintf(Buf, "Couldn't open file %s", pInFileName);
		DoMessageBox (Buf, MB_OK, 0) ;
		return FALSE ;
   }

	char* pOutFileName = IniInRtrWareFormDef;
	CStdioFile output( pOutFileName, CFile::modeCreate | CFile::modeWrite 
						| CFile::typeBinary );  //VIDY changed from TXT to BIN

	char* pRtrCnf = IniInRtrWareForm;
	CStdioFile output_rtrcnf( pRtrCnf, CFile::modeCreate | CFile::modeWrite 
						| CFile::typeBinary );

	char sBuf[MaxINIString];
	char *ch, *ptr;
	char pBuf[MaxINIString];

	while((input.ReadString(sBuf , MaxINIString)) != NULL)
	{
		// PINTO 28/1/97
		// There must not be any "0d"s in the sBuf by now
		while (ptr = strchr (sBuf, '\r'))
		{
			strcpy (ptr, ptr + 1) ;
		}
		// To remove blank lines
		if (sBuf[0] == '\n')
			continue ;
		// PINTO 28/1/97

		if((ch = strchr(sBuf,(int) '[')) != NULL) //Check for section header
		{
			*ch = '\0';
			strcpy(pBuf,sBuf);
			strcat(pBuf,"[[ ");
			strcpy(sBuf,++ch);
			if((ch = strchr(sBuf,(int) ']')) != NULL)
			{
				*ch = '\0' ;
				strcat(pBuf,sBuf);
				strcat(pBuf," = Section Start ]]");     //Change the section header
    				strcat(pBuf,++ch);
				strcpy(sBuf, pBuf);
			}
			else
			{
				strcat(pBuf,sBuf);
				strcpy(sBuf,pBuf);      
			}

	}                      
		else
		{
			// Changes by Vidy for PPP local and remote options 22nd Sept
			if ( !wildstrcmp("PPP Port? Option%*",sBuf) ||
							!wildstrcmp("PPP Port? Remote Option%*",sBuf)) {
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// to the RHS 
				// <words>%<words>%<words>=<words> ==> 
				// <words>=<words>,<words>,<words>
				char *ChrPtr;

				ChrPtr = strchr(sBuf,(int) '%');
				*ChrPtr++ = '=';
				ChrPtr = strchr(ChrPtr,(int) '%');
				*ChrPtr++ = ',';
				ChrPtr = strchr(ChrPtr,(int) '=');
				*ChrPtr = ',';
			}
			if ( !wildstrcmp("PPP Port? RAS Option%*",sBuf) ||
							!wildstrcmp("PPP Port? RAS Remote Option%*",sBuf)) {
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// to the RHS 
				// <words>%<words>%<words>=<words> ==> 
				// <words>=<words>,<words>,<words>
				char *ChrPtr;

				ChrPtr = strchr(sBuf,(int) '%');
				*ChrPtr++ = '=';
				ChrPtr = strchr(ChrPtr,(int) '%');
				*ChrPtr++ = ',';
				ChrPtr = strchr(ChrPtr,(int) '=');
				*ChrPtr = ',';
			}

			if((ch = strstr(sBuf,"Port")) != NULL)
			{
				ch += 4;		//Look after "Port"
				int c = *ch;
				if((c >= 0x30) && (c <= 0x39))	//Check for digit.
				{
					*ch = '\0' ;                  
					strcpy(pBuf, sBuf);
					int c2 = *(++ch);
					BOOL flag = FALSE;
					if((c2 >= 0x30) && (c2 <= 0x39))	//Check for digit.
					{
						ch++;
						flag = TRUE ;
					}       
					strcpy(sBuf,ch);        
					if((ch = strchr(sBuf, (int) '=')) != NULL)
					{
						*ch = '\0' ;
						strcat(pBuf, sBuf);
						strcat(pBuf, "=");
						char temp[4];
						temp[0] = flag ? c  : '0';
						temp[1] = flag ? c2 :  c;
						temp[2] = ',';
						temp[3] = '\0' ;
						strcat(pBuf, temp);
						strcat(pBuf, ++ch);
						strcpy(sBuf, pBuf);
					}       
				}
			}       
		// Put " = " inplace of "="
			if((ch = strchr(sBuf,(int) '=')) != NULL)
			{
				*ch = '\0';
				strcpy(pBuf, sBuf);
				strcat(pBuf, " = ");
				strcat(pBuf, ++ch);
				strcpy(sBuf, pBuf);
			}
		}
		output.WriteString(sBuf);               
		output_rtrcnf.WriteString(sBuf);               
	}
	output.Write("\0\0", 2);
	output_rtrcnf.Write("\0\0", 2);
	return (TRUE);
}       //End of WriteRouterINI

// -------------------------------------------------------------------------
// Function        :       CRouconApp::WriteWinINI()
// Arguments       :       None.
// Synopsis        :       Converts Router CNF to Windows INI.
// Returns         :       None.
// -------------------------------------------------------------------------

BOOL CRouconApp::RAWriteWinINI()
{
	char Buf[80];

	char *pInFileName = IniInRtrWareFormDef ;
	CStdioFile input ;
	if (!input.Open (pInFileName, CFile::modeRead | CFile::typeText ))
	{
		sprintf(Buf, "Couldn't open file %s", pInFileName);
		DoMessageBox (Buf, MB_OK, 0) ;
		return FALSE ;
	}

	char *pOutFileName;
        if (CommandLineArgument == 6)	        								   
           pOutFileName = NewIniInWinForm ;
        else
           pOutFileName = IniInWinForm ;
//	CStdioFile output (pOutFileName, CFile::modeCreate | CFile::modeWrite 
//											| CFile::typeText ) ;
	CStdioFile output;
	if ( !output.Open(pOutFileName, CFile::modeCreate | CFile::modeWrite 
											| CFile::typeText ))
	{
		sprintf(Buf, "Couldn't open file %s", pOutFileName);
		DoMessageBox (Buf, MB_OK, 0) ;
		return FALSE ;
	}

	char sBuf[MaxINIString] ;
	char *ch ;
	char *pBuf = new char[MaxINIString] ;
		
	while ((input.ReadString (sBuf, MaxINIString)) != NULL)
	{
		if ((ch = strchr (sBuf, (int) '[')) != NULL)    //Check for section header
		{
			*(++ ch) = '\0' ;
			strcpy (pBuf, sBuf) ;
			ch += 2 ;
			strcpy (sBuf, ch) ;
			if ((ch = strchr (sBuf, (int) '=')) != NULL)
			{
				*(-- ch) = '\0' ;
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, ++ ch) ;
				ch = strstr (sBuf, "]]") ;
				if (ch != NULL)
				{
					strcat (pBuf, ++ ch) ;
					strcpy (sBuf, pBuf) ;
				}
			}
			else
			{
				strcat (pBuf, sBuf) ;
				strcpy (sBuf, pBuf) ;
			}
		}
		else
		{
			if ((ch = strstr (sBuf, "Virtual Port to DLCI")) != NULL)
			{
				ch += 20;       //Look after "Virtual Port to DLCI"
				char *ch2 ;
				if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
				{
					*ch = '\0';
					strcpy(pBuf, sBuf);
					strcat(pBuf, " ");
					ch2++;
					char storing[2];
					storing[0] = *(ch2 +4);
					storing[1] = '\0';
					*(ch2 + 4) = '\0';
					strcat(pBuf, ch2);
					ch2 --;
					*ch2 = '\0';
					strcat(pBuf, " ");
					ch ++;
					strcat(pBuf, ch);
					strcat(pBuf, storing);
					strcpy(sBuf, pBuf);
				}
			}

			if ((ch = strstr (sBuf, "Port")) != NULL)
			{   
				char *ch2 ;
				if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
				{
					ch += 4 ;                               //Look after "Port"
					*ch = '\0' ;
					strcpy (pBuf, sBuf) ;
					strcpy (sBuf, ++ ch) ;
					ch2 = strchr (sBuf, (int) ',') ;
					if (ch2 != NULL)
					{       
						*ch2 = '\0' ;
						if ((*(ch2-2)) == '0')
							strcat (pBuf, (ch2-1)) ;
						else
							strcat (pBuf, (ch2-2)) ;
						*(ch2-2) = '\0' ;
						strcat (pBuf, " ") ;         
						strcat (pBuf, sBuf) ;
						strcat (pBuf, ++ ch2) ;
						strcpy (sBuf, pBuf) ;
					}       
				}                   
			}
			else
			{
				if ((ch = strstr (sBuf, "Channel")) != NULL)    
				{   
					char *ch2 ;
					if ((ch2 = strchr (sBuf, (int) ',')) != NULL)
					{
						ch += 7 ;                               //Look after "Channel"
						*ch = '\0' ;
						strcpy (pBuf, sBuf) ;
						strcpy (sBuf, ++ ch) ;
						ch2 = strchr (sBuf, (int) ',') ;
						if (ch2 != NULL)
						{       
							*ch2 = '\0' ;
							if ((*(ch2-2)) == '0')
								strcat (pBuf, (ch2-1)) ;
							else
								strcat (pBuf, (ch2-2)) ;
							*(ch2-2) = '\0' ;
							strcat (pBuf, " ") ;         
							strcat (pBuf, sBuf) ;
							strcat (pBuf, ++ ch2) ;
							strcpy (sBuf, pBuf) ;
						}       
					}                   
				}
				else
				{
					if ((ch = strstr (sBuf, "Frame Relay DLCI")) != NULL)
					{
						char *ch1;
						if ((ch1 = strstr (sBuf, "Number")) != NULL)
						{
							ch1 += 6;        // add 6 for the number
							*ch1 = '\0';
							strcpy(pBuf, sBuf);
							ch1 += 3;
							char store_temp[3];
							store_temp[0] = *ch1;
							store_temp[1] = *(ch1 + 1);
							store_temp[2] = '\0';
							strcat(pBuf, store_temp);
							strcat(pBuf, " = ");
							ch1 += 3; // two for numbers and one for comma
							strcat(pBuf, ch1);
							strcpy(sBuf, pBuf);
						}
						else
						{
							ch += 16;               // add 16 for "Frame Relay DLCI"
							*ch = '\0';
							ch++;
							strcpy(pBuf, sBuf);
							if ((ch1 = strchr (ch, (int) '=')) != NULL)
							{
								ch1 ++;
								*(ch1 + 5) = '\0';
								strcat(pBuf, ch1);
								strcat(pBuf, " ");
								*ch1 = '\0';
								strcat(pBuf, ch);
								strcat(pBuf, " ");
								ch1 += 6;
								strcat(pBuf, ch1);
								strcpy(sBuf, pBuf);
							}
						}
					}
				}
			}
			// Put "=" in place of " = "
			if ((ch = strchr (sBuf, (int) '=')) != NULL)
			{
				*(ch - 1) = '\0';
				strcpy (pBuf, sBuf) ;
				strcat (pBuf, "=") ;
				ch += 2 ;
				strcat (pBuf, ch) ;
				strcpy (sBuf, pBuf) ;
			}
			// Changes by Vidy for PPP local and remote options 22nd Sept
			if ( !wildstrcmp ("PPP Port? Option=*", sBuf) ||
							!wildstrcmp ("PPP Port? Remote Option=*", sBuf))
			{
				// we need to get the protocol token (like LCP, IPCP etc.)
				// and parameter token (like Magic Number, Network Number etc.)
				// also to the LHS for making unique LHS strings for
				// Windows ini APIs to work

				// <words>=<words>,<words>,<words> ==>
				// <words>%<words>%<words>=<words> 
				char *ChrPtr ;

				ChrPtr = strchr (sBuf, (int) '=') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr = '=' ;
			}
			if ( !wildstrcmp ("PPP Port? RAS Option=*", sBuf) ||
							!wildstrcmp ("PPP Port? RAS Remote Option=*", sBuf))
			{
				// <words>=<words>,<words>,<words> ==>
				// <words>%<words>%<words>=<words> 
				char *ChrPtr ;

				ChrPtr = strchr (sBuf, (int) '=') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr++ = '%' ;
				ChrPtr = strchr (ChrPtr, (int) ',') ;
				*ChrPtr = '=' ;
			}
		}
		output.WriteString (sBuf) ;
	}
	output.Close() ;
//	output.Open (pOutFileName, CFile::modeRead | CFile::typeText) ; 
	output.Open (pOutFileName, CFile::modeRead | CFile::typeText) ; 
	output.Flush() ;
	output.Close() ;

	WritePrivateProfileString(NULL, NULL, NULL, (LPCSTR) IniInWinForm);

	delete [] pBuf ;  
	return TRUE ;
}       // End of WriteWinINI


 
// -------------------------------------------------------------------------
// Function        :       CRouconApp::UpGradeProxy()
// Arguments       :       None.
// Synopsis        :       Incorporates changes in Roucon.ini into MTRouter.ini       
// Returns         :       None.
// -------------------------------------------------------------------------
BOOL CRouconApp::UpGradeProxy()
{
	char Buf[80];

	char *pInFileName = IniInWinForm ;
	CStdioFile input ;
	if (!input.Open (pInFileName, CFile::modeRead | CFile::typeText ))
	{
		sprintf(Buf, "Couldn't open file %s", pInFileName);
		DoMessageBox (Buf, MB_OK, 0) ;
		return FALSE ;
	}

	char *pOutFileName;
        pOutFileName = NewIniInWinForm ;
	CStdioFile output;                                                                             
        if ( !output.Open(pOutFileName, CFile::modeReadWrite | Cfile::typetext))
	{
		sprintf(Buf, "Couldn't open file %s", pOutFileName);
		DoMessageBox (Buf, MB_OK, 0) ;
		return FALSE ;
	}

	char sBuf[MaxINIString] ;
	char *ch1,*ch2;
	char *pBuf = new char[MaxINIString] ;
		
	while ((input.ReadString (sBuf, MaxINIString)) != NULL)
	{
                BOOL flag = FALSE;
                if ((ch1=strchr (sbuf, (int) '=')) == NULL)
                        continue;
                while ((output.Readstring (pbuf,MaxINIString)) != NULL)
                {
                        if ((ch2=strchr (pbuf, (int) '=')) == NULL)
                                continue;
                        *ch1 = '\0';
                        *ch2 = '\0';
                        if (strcmpi (sbuf, pbuf) == 0)
                        {
                                flag = TRUE;
                                strcat (pbuf, "=");
                                strcpy (sbuf, ++ch1);
                                strcat (pbuf, sbuf);
                                output.writestring (pbuf);
                                break;
                        }
                }
                if(flag == FALSE)
                {
                        sprintf(Buf, "Couldn't find required parameter in file %s", pOutFileName);
	        	DoMessageBox (Buf, MB_OK, 0) ;
		        return FALSE ;
	        }
        }
        output.Close() ;
        input.close();
	return TRUE ;
}      // End of UpGradeProxy

                
           
/////////////////////////////////////////////////////////////////////////////
// The one and only CRouconApp object

CRouconApp NEAR theApp;

/////////////////////////////////////////////////////////////////////////////
// CRouconApp initialization

void CRouconApp::GetBootVersionAndSetVars (CWnd *pWnd, char *VerStr)
{
	if (GetBootVersion (pWnd, VerStr) == TRUE)
	{
   strcpy (IniInRtrWareFormDef, LoadPath) ;
		switch (model)
		{
		case MODEL_MTSR3_200:
					WindowText = "MTPSR3_200" ;
				   strcat (IniInRtrWareFormDef, DEF_CNF_File) ;  // Mtrouter.Cnf
					break;
		case MODEL_MTSR2_201:
					WindowText = "MTPSR2_201" ;
				   strcat (IniInRtrWareFormDef, DEF_DSU_File) ;  // Def File for DSU
					break;
		case MODEL_MTSR1_202ST:
					WindowText = "MTPSR1_202ST" ;
				   strcat (IniInRtrWareFormDef, DEF_ISDN_File) ;  // ISDN Def file
					break;
		case MODEL_MTSR1_202NT:
					WindowText = "MTPSR1_202NT" ;
				   strcat (IniInRtrWareFormDef, DEF_ISDN_File) ;  // ISDN Def file
					break;
		default:
					WindowText = "ProxyServer 2.01" ;
				   strcat (IniInRtrWareFormDef, DEF_CNF_File) ;  // Mtrouter.Cnf
					break;
		}
	}
}

BOOL CRouconApp::InitInstance()
{
	CMainDlg mdlg;

	// Standard initialization
	// If you are not using these features and wish to reduce the size
	//  of your final executable, you should remove from the following
	//  the specific initialization routines you do not need.

	int length ;
   char *ptr ;
	char szBuf[30] ;
	char ApplicationName[50] ;
	BootConfigType ConfigHeader ;
	unsigned char *BytePointer ;
	char *NetAddrPointer ;
	int i, UpperNibble, LowerNibble ;

   length = GetModuleFileName (m_hInstance, LoadPath, FILE_NAME_SIZE) ;
   ptr = &LoadPath[length] ;
   while (*ptr != '\\')
      ptr -- ;
   *(ptr + 1) = NULL ;

   /* create all the ini File names */
   strcpy (OwnIniFile, LoadPath) ;
   strcat (OwnIniFile, LocalINI) ; // Setup.Ini

   strcpy (IniInWinForm, LoadPath) ;
   strcat (IniInWinForm, TempINI) ;  // Roucon.Ini

   strcpy (NewIniInWinForm, LoadPath) ;
   strcat (NewIniInWinForm, NewINI) ;  // MTRouter.Ini

   strcpy (IniInRtrWareForm, LoadPath) ;
   strcat (IniInRtrWareForm, CNF_File) ;  // Router.Cnf
	// IniInRtrWareForm contains the configuration file

   strcpy (IniInRtrWareFormDef, LoadPath) ;
   strcat (IniInRtrWareFormDef, DEF_CNF_File) ;
	// IniInRtrWareFormDef contains the default configuration file

	strcpy (ini_INIFilename, LoadPath);
	strcat (ini_INIFilename, IsdnTempINI);

	strcpy (UDBCompressedDBaseFile, LoadPath) ;  // Compressed User DBase
	strcat (UDBCompressedDBaseFile, UDB_COMPR_DBASE_FILE) ; 

	strcpy (UDBUnCompressedDBaseFile, LoadPath) ;  // UnCompressed User DBase
	strcat (UDBUnCompressedDBaseFile, UDB_UNCOMPR_DBASE_FILE) ; 

	strcpy (LogFileName, LoadPath) ;  // Log File
	strcat (LogFileName, LOG_FILE) ; 

   Ctl3dRegister (m_hInstance) ;
	Ctl3dAutoSubclass (m_hInstance) ;

	SetDialogBkColor() ;        // Set dialog background color to gray
	LoadStdProfileSettings() ;  // Load standard INI file
									    // options (including MRU)

	// Register the application's document templates.  Document templates
	//  serve as the connection between documents, frame windows and views.

	// create main window
	CMainFrame *p_MainFrame;
	if (m_lpCmdLine[0] != 0)
	{
		p_MainFrame = new CMainFrame ;
		if (!p_MainFrame->LoadFrame (IDR_MAINFRAME))
			return FALSE ;
	}
	else
		p_MainFrame = (CMainFrame *)&mdlg;

	m_pMainWnd = p_MainFrame ;

	((CWnd *) p_MainFrame)->CenterWindow() ;

	CommandLineArgument = 0 ;

	DownloadSetupOnly = FALSE ;
	LookForTargetOnly = FALSE ;
	DontReadConfiguration = FALSE ;

	// Check if the port is TFTP
	GetPrivateProfileString((LPCSTR) "Port Setup",
		(LPCSTR) "Communication type",
					(LPCSTR) "Serial", (LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) OwnIniFile) ;

	if (!strcmpi (szBuf, "IP"))
		IsPortIP = TRUE ;
/*
	GetPrivateProfileString ((LPCSTR) "Port Setup",
		(LPCSTR) "Application Name", (LPCSTR) "Router Setup",
			(LPSTR) ApplicationName , sizeof (ApplicationName),
						(LPCSTR) OwnIniFile) ;
	WindowText = ApplicationName ;*/
   WindowText = "ProxyServer 2.01" ;
	/* 9/7/97 */
	IsLanTalker = !strcmpi (ApplicationName, "LANTalker") ;
	IsRF200 = !strcmpi (ApplicationName, "RouteFinder200") ;
	/* 9/7/97 */
	MainMsgHeader = ApplicationName ;

	////Prabha, 6/2/98, to get the boot header for the model number
	char BootVerString[20] ;
	memset (BootVerString, 0, sizeof (BootVerString)) ;
//   strcat (IniInRtrWareFormDef, DEF_CNF_File) ;  // Mtrouter.Cnf
	/* Look if the router is up */


	GetBootVersionAndSetVars(p_MainFrame, BootVerString);

	CodeLoadAddress = COD_LOAD_ADDR ;
	CodeStartAddress = COD_START_ADDR ;
	FlCodeStartAddress = FL_CODE_START ;
	TFTPCodeAddressDetails.TFTP_FlCodeStartAddress = FL_CODE_START ;
	TFTPCodeAddressDetails.TFTP_CodeLoadAddress = COD_LOAD_ADDR ;
	TFTPCodeAddressDetails.TFTP_CodeStartAddress = COD_START_ADDR ;

	if (m_lpCmdLine[0] == '2')
	{
		CommandLineArgument = 2;
		if (!IsPortIP) // For COM Port
		{
			CPowerCode cPowerCode ((CWnd *) p_MainFrame) ;
			if (IDCANCEL == cPowerCode.DoModal())
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}
		else // using TFTP
		{
			if (RouMsgBox (MSG_MAIN_ASK_DOWN,
						MainMsgHeader, MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
			{
				CFileDialog cFileDialog (TRUE, (LPCSTR) "*.BIN",
							NULL, OFN_HIDEREADONLY /*| OFN_CREATEPROMPT*/,
			   	         (LPCSTR) "Firmware Files (*.bin) | *.bin ||", NULL) ;
				cFileDialog.CenterWindow () ;
				if (IDOK != cFileDialog.DoModal())
				{
					PostQuitMessage (0) ;
					return TRUE ;
				}

				CString CodeFileName = cFileDialog.GetPathName() ;
				char *Ptr = CodeFileName.GetBuffer(0) ;

				struct
				{
					BYTE Version[8] ;
					BYTE DateStamp[24] ;
					BYTE MagicNumber[5] ;
				} FileHeader ;

				CStdioFile Input ;

				if (!Input.Open (CodeFileName,
						CFile::modeRead | CFile::typeBinary))
				{
					RouMsgBox (MSG_GEN_FILE_OPEN_ERR, MainMsgHeader, 
													MB_OK | MB_ICONINFORMATION) ;

					PostQuitMessage (0) ;
					return (TRUE) ;
				}

				Input.Read (&FileHeader, 37) ;
				Input.Close() ;

				char szMagic[10] ;
				sprintf (szMagic, "%X", (WORD) MAGIC_NUM) ;
				if (strcmp ((LPCSTR) &FileHeader.MagicNumber, szMagic)) 
				{
					RouMsgBox (MSG_PWN_INV_CODE, MainMsgHeader,
														MB_OK | MB_ICONSTOP) ;
					PostQuitMessage (0) ;
					return TRUE ;
				}

				strcpy (TFTPPutLocalFileName, Ptr) ;
				strcpy (TFTPPutRemoteFileName, "MTROUTER.BIN") ;

//				TFTPWaitMessage TFTPCompressionProgress ((CWnd *) p_MainFrame) ;
//				TFTPCompressionProgress.ShowWindow (SW_SHOW) ;
//				TFTPCompressionProgress.ShowWindow (SW_SHOW) ;

				SetCapture(NULL);
				tftpwrit TFTPFirmwareUpdate ;
				if (IDOK != TFTPFirmwareUpdate.DoModal())
				{
					PostQuitMessage (0) ;
					return TRUE ;
				}
			}
			else
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}
		PostQuitMessage (0) ;		// exit out after firmwareupdate
		return TRUE ;
	}

	/* Download default setup */
	/* 3 --> while installing roucon */
	/* 1 --> while downloading default setup */
	if ((m_lpCmdLine[0] == '3') || (m_lpCmdLine[0] == '1'))
	{
		CommandLineArgument = 3 ;
		DefaultSetup = TRUE; /* Sudha 3 June 1998 */

		/* Using TFTP for Download Default setup */
		if (IsPortIP)
		{
			strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
			strcpy (TFTPGetLocalFileName, LoadPath) ;
			strcat (TFTPGetLocalFileName, "BOOT.CFG") ;

			tftpread TFTPReadDialog ;
			if (TFTPReadDialog.DoModal() != IDOK)
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}

			FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;
			if (FilePointer != NULL)
			{
				fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;

				for (i = 0,
						  BytePointer = &ConfigHeader.EthernetAddr[0],
							  NetAddrPointer = &EtherNetAddr[0] ; i < 6 ;
									  i++, BytePointer++)
				{
					UpperNibble = (*BytePointer >> 4) & 0x0F ;
					LowerNibble = (*BytePointer) & 0x0F ;

					if ((UpperNibble >= 0) && (UpperNibble <= 9))
						*NetAddrPointer++ = '0' + UpperNibble ;
					else
						*NetAddrPointer++ = 'A' + UpperNibble - 10 ;

					if ((LowerNibble >= 0) && (LowerNibble <= 9))
						*NetAddrPointer++ = '0' + LowerNibble ;
					else
						*NetAddrPointer++ = 'A' + LowerNibble - 10 ;
				}
				*NetAddrPointer = NULL ;
			}
			else
			{
				::MessageBox (((CWnd *) p_MainFrame)->GetSafeHwnd(), "Could not initialize configuration read. Quitting ...", "",
											MB_OK | MB_ICONINFORMATION) ;
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}

		// read ether net address and check if router network corresponds
		// to that of the one in roucon.ini. if same, just download
		// else invoke the dialog boxes
		LookForTargetOnly = TRUE ;   // Just read ethernet address
											  // Do not download setup now	
		if (!IsPortIP)
		{
			CPowerOn cPowerOn ((CWnd *) p_MainFrame) ;
			if (IDCANCEL == cPowerOn.DoModal() )
			{
				PostQuitMessage (0) ;
				return TRUE ;
			}
		}

		GetBootVersionAndSetVars(p_MainFrame, BootVerString);

		// Ask the user to connect the router and power on
		// If already connected just power off and power on
		if (!RAWriteWinINI())
		{	// Convert MTROUTER.CNF to ROUCON.INI
			::MessageBox (((CWnd *) p_MainFrame)->GetSafeHwnd(), "Error in writing configuration. Quitting ...", "",
											MB_OK | MB_ICONINFORMATION) ;
			PostQuitMessage (0) ;
			return TRUE ;
		}


		ipprx tagIPPrx ((CWnd *) p_MainFrame) ;
		tagIPPrx.DoModal() ;

		if ((model == MODEL_MTSR1_202ST) || (model == MODEL_MTSR1_202NT))
		{
			CIsddnld isdn ((CWnd *) p_MainFrame) ;
			isdn.DoModal();
		}
		else
		{
			CWandefs cWANDefs ((CWnd *) p_MainFrame) ;
			cWANDefs.DoModal() ;
		}

		char temp_get[15];
		BOOL WanAsync = TRUE ;
		GetPrivateProfileString (WANSectionHeader, "WAN Port0 ASYNC",
				StrDisabled, temp_get, sizeof (temp_get), IniInWinForm) ;
		if (strcmp (temp_get, StrEnabled) != 0)
			WanAsync = FALSE ;

		RAWriteRouterINI() ;	// Convert modified ROUCON.INI to MTROUTER.CNF

		// Now we are actually going to download the setup
		LookForTargetOnly = FALSE ;
		if (!IsPortIP)
		{
			CPowerOn c1PowerOn ((CWnd *) p_MainFrame) ;
			c1PowerOn.DoModal() ;
		}
		else
		{
			if (RouMsgBox (MSG_MAIN_ASK_DOWN, MainMsgHeader,
									MB_OKCANCEL | MB_ICONQUESTION) == IDOK)
			{
				strcpy (TFTPPutLocalFileName, IniInRtrWareFormDef) ;
				strcpy (TFTPPutRemoteFileName, "CONFIG.INI") ;

				tftpwrit TFTPPutDefaultSetup ;
				TFTPPutDefaultSetup.DoModal() ;
			}
		}
		//Copy the mtrouter.cnf to router.cnf to avoid reading of cnf
		//when tyring to configure next time

		PostQuitMessage (0) ;
		return TRUE ;
	}

	if (m_lpCmdLine[0] == '4')
	{
		DontReadConfiguration = TRUE;
		CommandLineArgument = 4;
	}

	if (m_lpCmdLine[0] == '5')
	{
		DontReadConfiguration = TRUE;
		CommandLineArgument = 5;
	}

/*        if (m_lpCmdLine[0] == '6')
        {
                CommandLineArgument = 6;

                CMainDlg mdlg(p_MainFrame);

                mdlg.DoModal();     //Reading router.cnf from FLASH PROM to HARD DISK

                RAWriteWinINI();    //Converting new mtrouter.cnf to new mtrouter.ini

                UpGradeProxy();          //new mtrouter.ini = router.ini + new modules(e.g.,OSPF)                

                RAWriteRouterINI(); //Converting new mtrouter.ini to mtrouter.cnf

                //Download new configuration mtrouter.cnf into box
		CPowerOn cPowOn ((CWnd *) p_MainFrame) ;
		if (IDCANCEL == cPowOn.DoModal() )
		{
			PostQuitMessage (0) ;
			return TRUE ;
		}

                remove (NewIniInWinForm);

                //Download firmware
                CPowerCode cPowCode ((CWnd *) p_MainFrame) ;
		if (IDCANCEL == cPowCode.DoModal())
		{
			PostQuitMessage (0) ;
			return TRUE ;
		}

         }     */



	// This is for USER DATABASE
       	if (m_lpCmdLine[0] == '7')
	{
		CommandLineArgument = 7 ;
		if (IsPortIP)    // If via Ethernet port
		{
			// This is done to find the number of ports
			// From the Configuration
			strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
			strcpy (TFTPGetLocalFileName, LoadPath) ;
			strcat (TFTPGetLocalFileName, "BOOT.CFG") ;	
			
			tftpread TFTPReadDialog ;	
			if (TFTPReadDialog.DoModal() != IDOK)
			{	
				PostQuitMessage (0) ;	
				return TRUE ;	
			}	

			// Open the BOOT.CFG in the Executable's path dir	
			FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;	
			if (FilePointer != NULL)
			{
				fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;	
				NumberOfPorts = (UINT) ConfigHeader.NumberOfPorts ;
				fclose (FilePointer) ;

				// Delete BOOT.CFG file
				remove (TFTPGetLocalFileName) ;
			}
			else
			{
				// Remote Possibility
				::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 					(LPCSTR) "Could not read/create header file",
					(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;
				return TRUE ;
			}

			// Get the User data Base from the Box
			// which is compressed and without the
			// Header
			strcpy (TFTPGetRemoteFileName, UDB_COMPR_DBASE_FILE) ;
			strcpy (TFTPGetLocalFileName, UDBCompressedDBaseFile) ;

			tftpread TFTPReadUserDBDialog ;
			if (TFTPReadUserDBDialog.DoModal() != IDOK)
			{
				PostQuitMessage (0) ;
				return (TRUE) ;
			}

			char UDBHeaderFilePath[200] ;
			FILE *UDBHeaderFile ;
			char UDBVer[20] ;

			memset (UDBVer, 0, sizeof (UDBVer)) ;
			strcpy (UDBHeaderFilePath, LoadPath) ;
			strcat (UDBHeaderFilePath, UDB_HDR_FILE) ;
			UDBHeaderFile = fopen (UDBHeaderFilePath, "rb") ;
			if (UDBHeaderFile == NULL)
			{
				// Remote Possibility
				::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 					(LPCSTR) "Couldn't read UDB Version",
					(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;
				return TRUE ;
			}
			else
			{
				fread (UDBVer, sizeof (UDBVer), 1, UDBHeaderFile) ;
			}

			// Uncompress the user data base file
			// in USER.DTB
			// without the Header into USER.TMR file
			FILE *FileCompressedDBase = fopen (TFTPGetLocalFileName, "rb") ;
			if (FileCompressedDBase == NULL)		
			{		
				// Remote Possibility
				::MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
 					(LPCSTR) "Unable to read Compressed DataBase",		
					(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;		
				return TRUE ;		
			}		
			
			FILE *FileUnCompressedDBase =
					fopen (UDBUnCompressedDBaseFile, "wb") ;		
			if (FileUnCompressedDBase == NULL)
			{		
				fclose (FileCompressedDBase) ;		
 			
				// To delete the file		
				remove (TFTPGetLocalFileName) ;
	 		
				MessageBox ((HWND) (((CWnd *) p_MainFrame)->GetSafeHwnd()),		
					(LPCSTR) "Unable to read DataBase",		
						(LPCSTR) "DBase Open", MB_OK | MB_ICONHAND) ;		
				PostQuitMessage (0) ;		
				return TRUE ;		
			}		
                

#if 0
			if (!strcmpi (UDBVer, VERSION2))
			{
				// just remane compressed file as uncompressed
				// as there is no compression for VERSION2
				// Delete the following file so that "rename" does not fail
				fclose (FileUnCompressedDBase) ;
				fclose (FileCompressedDBase) ;		
				remove (UDBUnCompressedDBaseFile) ;
				rename (UDBCompressedDBaseFile, UDBUnCompressedDBaseFile) ;
			}
			else
			{
#endif
				LZWExpandFromFile (FileCompressedDBase, FileUnCompressedDBase) ;		
				fclose (FileUnCompressedDBase) ;
				fclose (FileCompressedDBase) ;		
//			}

			
			// Pop up the Users List Dialog
			CUsersDlg cUsers ((CWnd *) p_MainFrame) ;
			if (cUsers.DoModal() == IDCANCEL)
			{		
			   PostQuitMessage (0) ;
				return TRUE ;
			}

			strcpy (TFTPPutLocalFileName, UDBUnCompressedDBaseFile) ;
			strcpy (TFTPPutRemoteFileName, UDB_COMPR_DBASE_FILE) ;

			// Use TFTP write
			tftpwrit TFTPWriteUserDataBase ;
			TFTPWriteUserDataBase.DoModal() ; 

			// Delete the uncompressed data base 
			// first destroying the contents
			FileUnCompressedDBase =
							fopen (UDBUnCompressedDBaseFile, "wb") ;		
			fclose (FileUnCompressedDBase) ;
			remove (UDBUnCompressedDBaseFile) ;

		   PostQuitMessage (0) ;
			return TRUE ;
   	}
		else // via COM Port
		{
			CUsersComDlg cUsersComDlg ((CWnd *) p_MainFrame) ;
			cUsersComDlg.DoModal() ;
		   PostQuitMessage (0) ;
			return TRUE ;
		}
	}

//	CMainDlg mdlg ((CWnd *) p_MainFrame) ;  // Vidy 10/01/97 Win95 mouse bug
#if 0
	CMainDlg mdlg (NULL) ;
#endif
	mdlg.DoModal() ;

	((CWnd *) p_MainFrame)->SendMessage (WM_CLOSE) ;
	return TRUE ;
}

int CRouconApp::ExitInstance()
{
	Ctl3dUnregister(m_hInstance);
	return(CWinApp::ExitInstance());
}
/////////////////////////////////////////////////////////////////////////////
// CAboutDlg dialog used for App About

class CAboutDlg : public CDialog
{
public:
	CAboutDlg();

// Dialog Data
	//{{AFX_DATA(CAboutDlg)
	enum { IDD = IDD_ABOUTBOX };
	//}}AFX_DATA

// Implementation
protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//{{AFX_MSG(CAboutDlg)
		// No message handlers
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

CAboutDlg::CAboutDlg() : CDialog(CAboutDlg::IDD)
{
	//{{AFX_DATA_INIT(CAboutDlg)
	//}}AFX_DATA_INIT
}

void CAboutDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CAboutDlg)
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CAboutDlg, CDialog)
	//{{AFX_MSG_MAP(CAboutDlg)
		// No message handlers
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

// App command to run the dialog
void CRouconApp::OnAppAbout()
{
	CAboutDlg aboutDlg;
	aboutDlg.DoModal();
}

int CRouconApp::wildstrcmp(LPSTR str1, LPSTR str2)
{
	while (*str1 && *str2)
	{
		if (*str1 == '?' || *str2 == '?')
		{	// is any of them a ? char
			str1 ++ ; 
			str2 ++ ;						// if yes skip compare at this char
			continue ;
		}
		if (*str1 == '*' || *str2 == '*') 	// is any of them a * char
			return 0 ;								// if yes return match

		if (*str1 < *str2)
			return -1 ;
		else
			if (*str1 > *str2)
				return 1 ;

		str1 ++ ;
		str2 ++ ;
	}
	return ((int)*str1 - (int)*str2) ;
}

/////////////////////////////////////////////////////////////////////////////
// CRouconApp commands

void LZWExpandFromFile (FILE *sfp, FILE *dfp)
{
	int read_block_len ;
	unsigned short nread, decomp_size ;

	BYTE *read_buf = new BYTE[MAX_READ_SIZE] ;
	if (read_buf == NULL)
		return ;

	BYTE *comp_buf = new BYTE[MAX_UNCOMP_SIZE] ;
	if (comp_buf == NULL)
	{
		delete [] read_buf ;
		return ;
	} 

	do
	{
		if (fread (&read_block_len, 1, sizeof (read_block_len), sfp) !=
													sizeof (read_block_len))
			break;

		read_block_len = change_endian ((WORD) read_block_len);

		if (read_block_len < 0)
		{
			nread = decomp_size = fread (comp_buf, sizeof (char), 
												-read_block_len, sfp);
		}
		else
		{
			nread = fread (read_buf, sizeof(char), read_block_len, sfp);
			decomp_size = LZ15VExpandBuf ((unsigned char far *) read_buf,
						nread, (unsigned char far *) comp_buf, MAX_UNCOMP_SIZE) ;
		}

		fwrite (comp_buf, sizeof (char), decomp_size, dfp);
	}
	while (1) ;

	delete [] read_buf ;
	delete [] comp_buf ; 

	return ;
}


static unsigned short change_endian (unsigned short num)
{
	unsigned short num2 ;
	unsigned char *str1, *str2 ;

	str1 = (unsigned char *) &num ;
	str2 = (unsigned char *) &num2 ;
	str2[0] = str1[1] ;
	str2[1] = str1[0] ;
	return num2 ;
}

/*----------------------------------------------------------------------------
	Module : PutLeadingZeroes
	Author : Chetan
	Input  : IPX Address Buffer
	Output : none
----------------------------------------------------------------------------*/
void PutLeadingZeroes (LPSTR lpszIPXNetAddr)
{
	char szAddr[8 + 1] ;

	int nAddrLen = strlen (lpszIPXNetAddr) ;

	// If length is 8 no need of adding leading zeroes
	// or may be "AutoLearn"
	if (nAddrLen >= 8)
		return ;

	// Add the leading zeroes
	for (int i = 0 ; i < (8 - nAddrLen) ; i ++)
		szAddr[i] = '0' ;
	szAddr[i] = 0x00 ;

	// Concatenate the address
	strcat (szAddr, lpszIPXNetAddr) ;
	strcpy (lpszIPXNetAddr, szAddr) ;
	return ;
}


/* Added by cfp 7/12/96 */
void ModifyEndOfRouconIniString (LPCSTR lpcszSection, LPCSTR lpcszLHS, int nCommas, LPCSTR lpcszModifier)
{
	char szRHS[100] ;
	LPSTR pComma ;
	CString csBalance;

	GetPrivateProfileString (lpcszSection, lpcszLHS, (LPCSTR) StrNull,
			(LPSTR) szRHS, sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	if (!szRHS[0])
		return ;

	pComma = &szRHS[0] ;
	while (nCommas)
	{
		pComma = strchr (pComma, (int) ',') ;
		if (pComma == NULL)
			return ;
		pComma ++ ;
		if (nCommas == 1)
		{
			*pComma = 0 ;
			csBalance = pComma+1;	//Store balance

			strcat (szRHS, lpcszModifier) ;
			if (pComma = strchr(csBalance, (int) ','))
				strcat(szRHS, pComma);

			WritePrivateProfileString (lpcszSection,
					lpcszLHS, (LPCSTR) szRHS, (LPCSTR) IniInWinForm) ;
		}
		nCommas -- ;
	}
	return ;
}

#ifdef NEW_BOOT_2
BOOL CRouconApp::GetBootVersion (CWnd *pWnd, char *VerStr)
{
	BootConfigType ConfigHeader ;

	if (IsPortIP)
	{
		strcpy (TFTPGetRemoteFileName, "BOOT.CFG") ;
		strcpy (TFTPGetLocalFileName, LoadPath) ;
		strcat (TFTPGetLocalFileName, "BOOT.CFG") ;

		tftpread TFTPReadDialog ;
		if (TFTPReadDialog.DoModal() != IDOK)
		{
			return FALSE ;
		}

		FILE *FilePointer = fopen (TFTPGetLocalFileName, "rb") ;
		if (FilePointer != NULL)
		{
			fread (&ConfigHeader, sizeof (BootConfigType), 1, FilePointer) ;
			strcpy (VerStr, (LPCSTR) ConfigHeader.Version) ;
			model = ConfigHeader.ModelNumber;
			fclose (FilePointer) ;
			remove (TFTPGetLocalFileName) ;
			return TRUE ;
		}
		return FALSE ;
	}
	else
	{
		CBootVersion BootDlg (pWnd) ;
		BootDlg.VersionString = VerStr ;
		if (BootDlg.DoModal() == IDCANCEL)
 			return FALSE ;
		else 
			return TRUE ; 
//		BootDlg.DoModal() ;
//		return TRUE ;
	}
}
#endif /* NEW_BOOT_2 */

BOOL IsValidHexadecimalString(LPCSTR pstr)
{
	for (	; *pstr; pstr++)
	{
		if (*pstr >= '0' && *pstr <='9')
			continue;
		if (*pstr >= 'a' && *pstr <='f')
			continue;
		if (*pstr >= 'A' && *pstr <='F')
			continue;
		return FALSE;
	}
	return TRUE;
}

DWORD SwapDWord (DWORD IntelMotorola)
{
	DWORD TempDWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempDWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 3) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 2) ;
	*(TempPtrDest + 2) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 3) = *(TempPtrSrc + 0) ;

	return TempDWord ;
}

WORD SwapWord (WORD IntelMotorola)
{
	WORD TempWord ;

	BYTE *TempPtrSrc = (BYTE *) &IntelMotorola ;
	BYTE *TempPtrDest = (BYTE *) &TempWord ;

	*(TempPtrDest + 0) = *(TempPtrSrc + 1) ;
	*(TempPtrDest + 1) = *(TempPtrSrc + 0) ;

	return TempWord ;
}

void PunctuateLong(LPSTR OutStr, DWORD number)
{
	char tBuf[40];
	int	src_idx, dst_idx, length, copy_len;

	length = sprintf(tBuf, "%lu", number);

	for(src_idx = 0, dst_idx = 0, copy_len = length;
					tBuf[src_idx]; copy_len--, src_idx++, dst_idx++)
	{
		if (src_idx && !((copy_len) % 3))
		{
			OutStr[dst_idx++] = ',';
		}
		OutStr[dst_idx] = tBuf[src_idx];
	}
	OutStr[dst_idx] = 0;

}

void DwordToDayHrMinSecs(LPSTR OutStr, DWORD time)
{
	long days, hours, mins, secs;

	days = time / ((long)60 * 60 * 24);   // number of days

	time %= ((long)60 * 60 * 24);			// remaining hours

	hours = time / (60 * 60);			// number of hours

	time %= (60 * 60);					// remaining minutes

	mins = time / 60;					// number of minutes

	secs = time % 60;					// remaing seconds

	sprintf(OutStr, " %03ld : %02ld : %02ld : %02ld", days, hours, mins, secs);

}
 


