// -------------------------------------------------------------------------
// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	CWandefs.CPP
// Start Date        :	
// Author            :	Vidy
// Date Last Modified:       
// Modifications     :  2/11/95 Vidy added LSL speed updation for SNMP
// Vidy 05/12/96		: if only one wan don't show WAN 1
// -------------------------------------------------------------------------
// CWandefs.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "wandefs.h"
#include "modem.h"
#include "cryptfns.h"
#include "hardware.h"

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWandefs dialog


CWandefs::CWandefs(CWnd* pParent /*=NULL*/)
	: CDialog(CWandefs::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWandefs)
	m_WAN1Enable = FALSE;
	m_WAN2Enable = FALSE;
	m_WAN3Enable = FALSE;
	m_Speed1Str = "";
	m_Speed2Str = "";
	m_Speed3Str = "";
	m_StrDialNumber1 = "";
	m_StrDialNumber2 = "";
	m_StrDialNumber3 = "";
	m_1UName = "";
	m_2UName = "";
	m_3UName = "";
	m_1PWord = "";
	m_2PWord = "";
	m_3PWord = "";
	m_MLPPP = FALSE;
	//}}AFX_DATA_INIT

	m_bDialogInited = FALSE ; //A lock for password editing
}

void CWandefs::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWandefs)
	DDX_Control(pDX, IDC_EDIT_PWORD3, m_3PWordWnd);
	DDX_Control(pDX, IDC_EDIT_PWORD2, m_2PWordWnd);
	DDX_Control(pDX, IDC_EDIT_PWORD1, m_1PWordWnd);
	DDX_Control(pDX, IDC_STATIC_PRT3_GRP, m_WAN3GrpWnd);
	DDX_Control(pDX, IDC_STATIC_PRT2_GRP, m_WAN2GrpWnd);
	DDX_Control(pDX, IDC_STATIC_PWROD2, m_2PWordHdr);
	DDX_Control(pDX, IDC_STATIC_PWROD3, m_3PWordHdr);
	DDX_Control(pDX, IDC_STATIC_PWROD1, m_1PWordHdr);
	DDX_Control(pDX, IDC_EDIT_UNAME3, m_3UNameWnd);
	DDX_Control(pDX, IDC_EDIT_UNAME2, m_2UNameWnd);
	DDX_Control(pDX, IDC_EDIT_UNAME1, m_1UNameWnd);
	DDX_Control(pDX, IDC_STATIC_UNAME1, m_1UNameHdr);
	DDX_Control(pDX, IDC_STATIC_UNAME3, m_3UNameHdr);
	DDX_Control(pDX, IDC_STATIC_UNAME2, m_2UNameHdr);
	DDX_Control(pDX, IDC_STATIC_PRT1_GRP, m_WAN1GrpWnd);
	DDX_Control(pDX, IDC_EDIT_DIAL_NUMBER_3, m_EditDialNumber3Wnd);
	DDX_Control(pDX, IDC_STATIC_DIAL_NUM_HDR3, m_StatDialNumberHdr3Wnd);
	DDX_Control(pDX, IDC_EDIT_DIAL_NUMBER_2, m_EditDialNumber2Wnd);
	DDX_Control(pDX, IDC_STATIC_DIAL_NUM_HDR2, m_StatDialNumberHdr2Wnd);
	DDX_Control(pDX, IDC_EDIT_DIAL_NUMBER_1, m_EditDialNumber1Wnd);
	DDX_Control(pDX, IDC_STATIC_DIAL_NUM_HDR1, m_StatDialNumberHdr1Wnd);
	DDX_Control(pDX, IDC_STATIC_MODEM_TYPE_3, m_StatModemType3);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPE_3, m_ComboBoxModemType3);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPE_2, m_ComboBoxModemType2);
	DDX_Control(pDX, IDC_STATIC_MODEM_TYPE_2, m_StatModemType2);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPE_1, m_ComboBoxModemType1);
	DDX_Control(pDX, IDC_STATIC_MODEM_TYPE_1, m_StatModemType1);
	DDX_Control(pDX, IDC_WAN_SPEED3, m_Speed3ListWnd);
	DDX_Control(pDX, IDC_WAN_SPEED2, m_Speed2ListWnd);
	DDX_Control(pDX, IDC_WAN_SPEED1, m_Speed1ListWnd);
	DDX_Control(pDX, IDC_WAN_PORT3, m_WAN3EnableWnd);
	DDX_Control(pDX, IDC_WAN_PORT2, m_WAN2EnableWnd);
	DDX_Control(pDX, IDC_WAN_PORT1, m_WAN1EnableWnd);
	DDX_Control(pDX, IDC_SPEED_TEXT3, m_Speed3Wnd);
	DDX_Control(pDX, IDC_SPEED_TEXT2, m_Speed2Wnd);
	DDX_Control(pDX, IDC_SPEED_TEXT1, m_Speed1Wnd);
	DDX_Check(pDX, IDC_WAN_PORT1, m_WAN1Enable);
	DDX_Check(pDX, IDC_WAN_PORT2, m_WAN2Enable);
	DDX_Check(pDX, IDC_WAN_PORT3, m_WAN3Enable);
	DDX_CBString(pDX, IDC_WAN_SPEED1, m_Speed1Str);
	DDX_CBString(pDX, IDC_WAN_SPEED2, m_Speed2Str);
	DDX_CBString(pDX, IDC_WAN_SPEED3, m_Speed3Str);
	DDX_Text(pDX, IDC_EDIT_DIAL_NUMBER_1, m_StrDialNumber1);
	DDV_MaxChars(pDX, m_StrDialNumber1, 40);
	DDX_Text(pDX, IDC_EDIT_DIAL_NUMBER_2, m_StrDialNumber2);
	DDV_MaxChars(pDX, m_StrDialNumber2, 40);
	DDX_Text(pDX, IDC_EDIT_DIAL_NUMBER_3, m_StrDialNumber3);
	DDV_MaxChars(pDX, m_StrDialNumber3, 40);
	DDX_Text(pDX, IDC_EDIT_UNAME1, m_1UName);
	DDX_Text(pDX, IDC_EDIT_UNAME2, m_2UName);
	DDX_Text(pDX, IDC_EDIT_UNAME3, m_3UName);
	DDX_Text(pDX, IDC_EDIT_PWORD1, m_1PWord);
	DDX_Text(pDX, IDC_EDIT_PWORD2, m_2PWord);
	DDX_Text(pDX, IDC_EDIT_PWORD3, m_3PWord);
	DDX_Check(pDX, IDC_CHECK1, m_MLPPP);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWandefs, CDialog)
	//{{AFX_MSG_MAP(CWandefs)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_WAN_PORT1, OnWanPort1)
	ON_BN_CLICKED(IDC_WAN_PORT2, OnWanPort2)
	ON_BN_CLICKED(IDC_WAN_PORT3, OnWanPort3)
	ON_EN_UPDATE(IDC_EDIT_PWORD1, OnUpdateEditPword1)
	ON_EN_UPDATE(IDC_EDIT_PWORD2, OnUpdateEditPword2)
	ON_EN_UPDATE(IDC_EDIT_PWORD3, OnUpdateEditPword3)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWandefs message handlers

void CWandefs::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp(0x20000 + IDD_WANDEFS,HELP_CONTEXT);
}

void CWandefs::OnWanPort1()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE) ;		// update class with current dialog data
	BOOL	Enable = m_WAN1EnableWnd.GetCheck() ? TRUE : FALSE;
	
	m_ComboBoxModemType1.EnableWindow (Enable && !IsRF200) ;
	m_StatModemType1.EnableWindow (Enable && !IsRF200) ;

	char szBuf[100] ;
	if (!IsRF200)
	{
		int nCurSel = m_ComboBoxModemType1.GetCurSel() ;
		if (nCurSel != CB_ERR)
		{
			m_ComboBoxModemType1.GetLBText (nCurSel, (LPSTR) szBuf) ;
		}
	}

	m_StatDialNumberHdr1Wnd.EnableWindow (Enable);
	m_EditDialNumber1Wnd.EnableWindow (Enable);

	m_Speed1ListWnd.EnableWindow (Enable);
	m_Speed1Wnd.EnableWindow (Enable);

	m_1UNameHdr.EnableWindow(Enable);
	m_1UNameWnd.EnableWindow(Enable);
	m_1PWordHdr.EnableWindow(Enable);
	m_1PWordWnd.EnableWindow(Enable);

	UpdateData (FALSE) ;
}

void CWandefs::OnWanPort2()
{
	// TODO: Add your control notification handler code here
	UpdateData (TRUE) ;		// update class with current dialog data
	BOOL Enable = m_WAN2EnableWnd.GetCheck() ? TRUE : FALSE ;

	m_ComboBoxModemType2.EnableWindow (Enable && !IsRF200) ;
	m_StatModemType2.EnableWindow (Enable && !IsRF200) ;

	char szBuf[100] ;
	if (!IsRF200)
	{
		int nCurSel = m_ComboBoxModemType2.GetCurSel() ;
		if (nCurSel != CB_ERR)
		{
			m_ComboBoxModemType2.GetLBText (nCurSel, (LPSTR) szBuf) ;
		}
	}

	m_StatDialNumberHdr2Wnd.EnableWindow (Enable);
	m_EditDialNumber2Wnd.EnableWindow (Enable);

	m_Speed2ListWnd.EnableWindow(Enable);
	m_Speed2Wnd.EnableWindow(Enable);

	m_2UNameHdr.EnableWindow(Enable);
	m_2UNameWnd.EnableWindow(Enable);
	m_2PWordHdr.EnableWindow(Enable);
	m_2PWordWnd.EnableWindow(Enable);

	UpdateData (FALSE) ;
}


void CWandefs::OnWanPort3()
{
	// TODO: Add your control notification handler code here
	UpdateData(TRUE);		//update class with current dialog data
	BOOL	Enable = m_WAN3EnableWnd.GetCheck() ? TRUE : FALSE;

	m_ComboBoxModemType3.EnableWindow (Enable && !IsRF200) ;
	m_StatModemType3.EnableWindow (Enable && !IsRF200) ;

	char szBuf[100] ;
	if (!IsRF200)
	{
		int nCurSel = m_ComboBoxModemType3.GetCurSel() ;
		if (nCurSel != CB_ERR)
		{
			m_ComboBoxModemType3.GetLBText (nCurSel, (LPSTR) szBuf) ;
		}
	}

	m_StatDialNumberHdr3Wnd.EnableWindow (Enable);
	m_EditDialNumber3Wnd.EnableWindow (Enable);

	m_Speed3ListWnd.EnableWindow (Enable);
	m_Speed3Wnd.EnableWindow(Enable);

	m_3UNameHdr.EnableWindow(Enable);
	m_3UNameWnd.EnableWindow(Enable);
	m_3PWordHdr.EnableWindow(Enable);
	m_3PWordWnd.EnableWindow(Enable);

	UpdateData (FALSE) ;
}

void CWandefs::OnOK()
{
	LPCSTR temp;

	// TODO: Add extra validation here
	UpdateData(TRUE);		// update class with the current dialog settings
	
	char szEncryptPassWd[42];
	char PWord[42];

	if (m_WAN1Enable)
		temp = StrEnabled;
	else
		temp = StrDisabled;
	WritePrivateProfileString(WANSectionHeader,
                        (LPCSTR) "WAN Port0", temp, (LPCSTR) FileName);

	WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) "WAN Port0 Dial Number",
                                                (LPCSTR) m_StrDialNumber1, (LPCSTR) FileName) ;

	WritePrivateProfileString(WANSectionHeader,
						(LPCSTR) "WAN Port0 Speed",
                                                (LPCSTR)m_Speed1Str, (LPCSTR) FileName);

	WritePrivateProfileString(LSLSectionHeader,
						(LPCSTR) "LSL Port1 Speed",
                                                (LPCSTR)m_Speed1Str, (LPCSTR) FileName);

	WritePrivateProfileString(PPPSectionHeader,
						(LPCSTR) "PPP Port0 User Name",
                                                (LPCSTR)m_1UName, (LPCSTR) FileName);

	if (m_1PWordWnd.GetModify()) {
		strcpy(PWord, (LPCSTR)m_1PWord);
		Encrypt (PWord, szEncryptPassWd) ;
		WritePrivateProfileString(PPPSectionHeader,
						(LPCSTR) "PPP Port0 User Password",
                                                (LPCSTR)szEncryptPassWd, (LPCSTR) FileName);
	}

	if (m_nPorts > 1)
	{	// write strings for WAN 2

		if (m_WAN2Enable)
			temp = StrEnabled;
		else
			temp = StrDisabled;
		WritePrivateProfileString(WANSectionHeader,
                        (LPCSTR) "WAN Port1", temp, (LPCSTR) FileName);
	
		WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) "WAN Port1 Dial Number",
                                                (LPCSTR) m_StrDialNumber2, (LPCSTR) FileName) ;

		WritePrivateProfileString(WANSectionHeader,
				(LPCSTR) "WAN Port1 Speed",
                                (LPCSTR)m_Speed2Str, (LPCSTR) FileName);

		WritePrivateProfileString(LSLSectionHeader,
				(LPCSTR) "LSL Port2 Speed",
                                (LPCSTR)m_Speed2Str, (LPCSTR) FileName);

		WritePrivateProfileString(PPPSectionHeader,
						(LPCSTR) "PPP Port1 User Name",
                                                (LPCSTR)m_2UName, (LPCSTR) FileName);

		if (m_2PWordWnd.GetModify()) {
			strcpy(PWord, (LPCSTR)m_2PWord);
			Encrypt (PWord, szEncryptPassWd) ;
			WritePrivateProfileString(PPPSectionHeader,
						(LPCSTR) "PPP Port1 User Password",
                                                (LPCSTR)szEncryptPassWd, (LPCSTR) FileName);
		}
	}

	if (m_nPorts > 2)
	{
		if (m_WAN3Enable)
			temp = StrEnabled;
		else
			temp = StrDisabled;
		WritePrivateProfileString(WANSectionHeader,
                                (LPCSTR) "WAN Port2", temp, (LPCSTR) FileName);

		WritePrivateProfileString (WANSectionHeader,
					(LPCSTR) "WAN Port2 Dial Number",
                                                        (LPCSTR) m_StrDialNumber3, (LPCSTR) FileName) ;

		WritePrivateProfileString(WANSectionHeader,
				(LPCSTR) "WAN Port2 Speed",
                                (LPCSTR)m_Speed3Str, (LPCSTR) FileName);

		WritePrivateProfileString(LSLSectionHeader,
				(LPCSTR) "LSL Port3 Speed",
                                (LPCSTR)m_Speed3Str, (LPCSTR) FileName);

		WritePrivateProfileString(PPPSectionHeader,
						(LPCSTR) "PPP Port2 User Name",
                                                (LPCSTR)m_3UName, (LPCSTR) FileName);

		if (m_3PWordWnd.GetModify()) {
			strcpy(PWord, (LPCSTR)m_3PWord);
			Encrypt (PWord, szEncryptPassWd) ;
			WritePrivateProfileString(PPPSectionHeader,
						(LPCSTR) "PPP Port2 User Password",
                                                (LPCSTR)szEncryptPassWd, (LPCSTR) FileName);
		}
	}

	if (!IsRF200)
		WriteModemsInfoToIni() ;

	//If MLPPP is enabled, we need to write the end point descriminator
	//string to the PPP Section
//PPP Port0 Option%LCP%EPD=19,Auto,Negotiation Not Required,Not Negotiable,H7,03000000000000
//PPP Port0 Remote Option%LCP%EPD=19,Auto,Negotiation Not Required,Negotiable,H7,03000000000000
	char MLPPPLocalLHS[] = "PPP Port0 Option%LCP%EPD";
	char MLPPPRemoteLHS[] = "PPP Port0 Remote Option%LCP%EPD";
	char MLPPPLocalMRRULHS[] = "PPP Port0 Option%LCP%MRRU";
	char MLPPPRemoteMRRULHS[] = "PPP Port0 Remote Option%LCP%MRRU";
	int	index;

	if (m_MLPPP)
	{
		for( index = 0; index < m_nPorts; index++)
		{
			WritePrivateProfileString(PPPSectionHeader, MLPPPLocalLHS,
				"19,Auto,Negotiation Not Required,Not Negotiable,H7,03000000000000",
                                FileName);
			WritePrivateProfileString(PPPSectionHeader, MLPPPRemoteLHS,
				"19,Auto,Negotiation Not Required,Negotiable,H7,03000000000000",
                                FileName);
			WritePrivateProfileString(PPPSectionHeader, MLPPPLocalMRRULHS,
				"17,Auto,Negotiation Not Required,Negotiable,D2,1600",
                                FileName);
			WritePrivateProfileString(PPPSectionHeader, MLPPPRemoteMRRULHS,
				"17,Auto,Negotiation Not Required,Negotiable,D2,1600",
                                FileName);

			MLPPPLocalLHS[8]++;
			MLPPPRemoteLHS[8]++;
			MLPPPLocalMRRULHS[8]++;
			MLPPPRemoteMRRULHS[8]++;
		}

		//Vidy 11/05/98, we need to disable remote access on all ports
		char szLHS[80];
		for (index = 0; index < m_nPorts; index++)
		{
			wsprintf(szLHS, "PPP Port%d Remote Port Client Only", index);
		 	WritePrivateProfileString(PPPSectionHeader, (LPCSTR) szLHS,
                                                        (LPCSTR) StrDisabled, (LPCSTR) FileName);
		}
	}
	else
	{
		for( index = 0; index < m_nPorts; index++)
		{
			WritePrivateProfileString(PPPSectionHeader, MLPPPLocalLHS,
                                NULL, FileName);
			WritePrivateProfileString(PPPSectionHeader, MLPPPRemoteLHS,
                                NULL, FileName);
			WritePrivateProfileString(PPPSectionHeader, MLPPPLocalMRRULHS,
                                NULL, FileName);
			WritePrivateProfileString(PPPSectionHeader, MLPPPRemoteMRRULHS,
                                NULL, FileName);
			MLPPPLocalLHS[8]++;
			MLPPPRemoteLHS[8]++;
			MLPPPLocalMRRULHS[8]++;
			MLPPPRemoteMRRULHS[8]++;
		}
	}

	CDialog::OnOK();
}

void CWandefs::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}


BOOL CWandefs::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	char szBuf[80] ;

	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer (0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	if (!OKBmpBtn.LoadBitmaps ("OK1", "OK2", "OK3"))
		AfxMessageBox ("Failed to load OK bitmap");

	VERIFY (OKBmpBtn.SubclassDlgItem (IDOK, this));
	OKBmpBtn.SizeToContent();

	if (!CancelBmpBtn.LoadBitmaps ("CANCEL1", "CANCEL2", "CANCEL3"))
		AfxMessageBox ("Failed to load CANCEL bitmap");

	VERIFY (CancelBmpBtn.SubclassDlgItem (IDCANCEL, this));
	CancelBmpBtn.SizeToContent();

	if (!HelpBmpBtn.LoadBitmaps ("SHELP1", "SHELP2", "SHELP3"))
		AfxMessageBox ("Failed to load HELP bitmap");

	VERIFY (HelpBmpBtn.SubclassDlgItem (IDC_HELP, this));
	HelpBmpBtn.SizeToContent();

/* Sachin, 03rd October */

	m_1PWordWnd.LimitText (PPP_PASSWORD_SIZE - 1) ;
	m_2PWordWnd.LimitText (PPP_PASSWORD_SIZE - 1) ;
	m_3PWordWnd.LimitText (PPP_PASSWORD_SIZE - 1) ;

	m_1UNameWnd.LimitText (PPP_USER_NAME_SIZE - 1) ;
	m_2UNameWnd.LimitText (PPP_USER_NAME_SIZE - 1) ;
	m_3UNameWnd.LimitText (PPP_USER_NAME_SIZE - 1) ;


        // Checking for UPGRADE PROXY - Brindha on 28/7/98
        if (CommandLineArgument == 6)
                strcpy(FileName, NewIniInWinForm);
        else
                strcpy(FileName, IniInWinForm);


/* Sachin, 03rd October */

	m_nPorts = GetPrivateProfileInt ((LPCSTR) WANSectionHeader,
                                                (LPCSTR) "WAN Number of Ports", 3, (LPCSTR) FileName) ;
	if (m_nPorts < 1 || m_nPorts > 3)
                m_nPorts = 3 ;


	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) "WAN Port0", StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) FileName) ;
	m_WAN1Enable = !strcmp (szBuf, StrEnabled) ? TRUE : FALSE ;

	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) "WAN Port1", StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) FileName) ;
	m_WAN2Enable = !strcmp (szBuf, StrEnabled) ? TRUE : FALSE ;

	GetPrivateProfileString (WANSectionHeader,
			(LPCSTR) "WAN Port2", StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) FileName) ;
	m_WAN3Enable = !strcmp (szBuf, StrEnabled) ? TRUE : FALSE ;

	GetPrivateProfileString (WANSectionHeader,
						(LPCSTR) "WAN Port0 Dial Number",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
							  	(LPCSTR) FileName);
	m_StrDialNumber1 = szBuf ;

	GetPrivateProfileString (WANSectionHeader,
					(LPCSTR) "WAN Port1 Dial Number",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	m_StrDialNumber2 = szBuf ;

	GetPrivateProfileString (WANSectionHeader,
					(LPCSTR) "WAN Port2 Dial Number",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	m_StrDialNumber3 = szBuf ;

	GetPrivateProfileString (PPPSectionHeader,
					(LPCSTR) "PPP Port0 User Name",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	m_1UName = szBuf ;

	GetPrivateProfileString (PPPSectionHeader,
					(LPCSTR) "PPP Port0 User Password",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	char P1[80], P2[80], P3[80];
	Decrypt(szBuf, P1);
	m_1PWord = P1 ;

	GetPrivateProfileString (PPPSectionHeader,
					(LPCSTR) "PPP Port1 User Name",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	m_2UName = szBuf ;

	GetPrivateProfileString (PPPSectionHeader,
					(LPCSTR) "PPP Port1 User Password",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	//This is infact wrong!!. Since we display *** for chars in password
	//window, we just need to show the same number of chars
	Decrypt(szBuf, P2);
	m_2PWord = P2 ;

	GetPrivateProfileString (PPPSectionHeader,
					(LPCSTR) "PPP Port2 User Name",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	m_3UName = szBuf ;

	GetPrivateProfileString (PPPSectionHeader,
					(LPCSTR) "PPP Port2 User Password",
							StrNull, (LPSTR) szBuf, sizeof (szBuf),
								(LPCSTR) FileName);
	//This is infact wrong!!. Since we display *** for chars in password
	//window, we just need to show the same number of chars
	Decrypt(szBuf, P3);
	m_3PWord = P3 ;

	int nSelected ;
	if (!IsRF200)
	{
		GetModemTypes() ;
		char szDest[40];

		GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) "WAN Port0 Modem Type", StrNull,
			(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) FileName) ;
		ConvertBackSlashesToBlanks(szDest, szBuf);
		if (szBuf[0])
		{ 
			nSelected = m_ComboBoxModemType1.FindStringExact (-1, (LPCSTR) szDest) ;
			if (nSelected != CB_ERR)
				m_ComboBoxModemType1.SetCurSel (nSelected) ;
		} 

		if (m_nPorts > 1)
		{
			GetPrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) "WAN Port1 Modem Type", StrNull, 
				(LPSTR) szBuf, sizeof (szBuf),	(LPCSTR) FileName) ;
			ConvertBackSlashesToBlanks(szDest, szBuf);
			if (szBuf[0])
			{ 
				nSelected = m_ComboBoxModemType2.FindStringExact (-1,
																		(LPCSTR) szDest) ;
				if (nSelected != CB_ERR)
					m_ComboBoxModemType2.SetCurSel (nSelected) ;
			}
		
			if (m_nPorts > 2)
			{
				GetPrivateProfileString ((LPCSTR) WANSectionHeader,
					(LPCSTR) "WAN Port1 Modem Type", StrNull,
					(LPSTR) szBuf, sizeof (szBuf),	(LPCSTR) FileName) ;
				ConvertBackSlashesToBlanks(szDest, szBuf);
				if (szBuf[0])
				{
					nSelected = m_ComboBoxModemType3.FindStringExact (-1,
																		(LPCSTR) szDest) ;
					if (nSelected != CB_ERR)
						m_ComboBoxModemType3.SetCurSel (nSelected) ;
				}
			}
		}
	}

	m_Speed1Str = m_Speed2Str = m_Speed3Str =	DEFAULT_SPEED ;

	if (m_nPorts != 3)
	{		// we need to show some port(s) less
		RECT DlgRect ;
		RECT FirstInvisibleGroupRect ;
		int FirstInvisibleGroup ;

		GetWindowRect (&DlgRect) ;
		if (m_nPorts == 2) {
			FirstInvisibleGroup = IDC_STATIC_PRT3_GRP ;
		}
		else
		{
			if (m_nPorts == 1)
			{
				FirstInvisibleGroup = IDC_STATIC_PRT2_GRP ;
				// Vidy 05/12/96 : if only one wan don't show WAN 1
				m_WAN1GrpWnd.SetWindowText ("&WAN") ;
				(GetDlgItem (IDC_STATIC_PRT3_GRP))->ShowWindow (SW_HIDE) ; 
				(GetDlgItem (IDC_STATIC_PRT3_GRP))->EnableWindow (FALSE) ;
			}
		}

		if (m_nPorts < 3)		//disable WAN3 controls
		{
			m_WAN3EnableWnd.EnableWindow(FALSE);
			m_ComboBoxModemType3.EnableWindow (FALSE);
			m_StatModemType3.EnableWindow (FALSE);

			m_ComboBoxModemType3.EnableWindow(FALSE) ;
			m_StatDialNumberHdr3Wnd.EnableWindow (FALSE);
			m_EditDialNumber3Wnd.EnableWindow (FALSE);

			m_Speed3ListWnd.EnableWindow (FALSE);
			m_Speed3Wnd.EnableWindow(FALSE);

			m_3UNameHdr.EnableWindow(FALSE);
			m_3UNameWnd.EnableWindow(FALSE);
			m_3PWordHdr.EnableWindow(FALSE);
			m_3PWordWnd.EnableWindow(FALSE);
		}

		if (m_nPorts < 2)		//hide WAN2 controls
		{
			m_WAN2EnableWnd.EnableWindow(FALSE);
			m_ComboBoxModemType2.EnableWindow (FALSE);
			m_StatModemType2.EnableWindow (FALSE);

			m_ComboBoxModemType2.EnableWindow(FALSE) ;
			m_StatDialNumberHdr2Wnd.EnableWindow (FALSE);
			m_EditDialNumber2Wnd.EnableWindow (FALSE);

			m_Speed2ListWnd.EnableWindow (FALSE);
			m_Speed2Wnd.EnableWindow(FALSE);

			m_2UNameHdr.EnableWindow(FALSE);
			m_2UNameWnd.EnableWindow(FALSE);
			m_2PWordHdr.EnableWindow(FALSE);
			m_2PWordWnd.EnableWindow(FALSE);
		}

		(GetDlgItem (FirstInvisibleGroup))->GetWindowRect (&FirstInvisibleGroupRect) ;
		// we need some border also
		(GetDlgItem (FirstInvisibleGroup))->ShowWindow (SW_HIDE) ; 
		(GetDlgItem (FirstInvisibleGroup))->EnableWindow (FALSE) ;

		DlgRect.bottom = FirstInvisibleGroupRect.top + 8 ;
		MoveWindow (&DlgRect, TRUE) ;
	}
	if (model == MODEL_MTSR2_201)
	{
		//we need to hide some controls since link one is a sync DSU
		m_Speed1Wnd.ShowWindow (SW_HIDE) ;
		m_Speed1ListWnd.ShowWindow (SW_HIDE) ;
		m_StatModemType1.ShowWindow (SW_HIDE) ;
		m_ComboBoxModemType1.ShowWindow (SW_HIDE) ;
		m_EditDialNumber1Wnd.ShowWindow (SW_HIDE) ;
		m_StatDialNumberHdr1Wnd.ShowWindow (SW_HIDE) ;

		m_Speed1Wnd.EnableWindow (FALSE) ;
		m_Speed1ListWnd.EnableWindow (FALSE) ;
		m_StatModemType1.EnableWindow (FALSE) ;
		m_ComboBoxModemType1.EnableWindow (FALSE) ;

		m_EditDialNumber1Wnd.EnableWindow(FALSE);
		m_StatDialNumberHdr1Wnd.EnableWindow(FALSE);
		m_WAN1GrpWnd.SetWindowText ("WAN &1 (DSU)") ;

	}

#if 0
	// Vidy 04/12/96. We need to disable some controls for RF200
	if (IsRF200)
	{
		// yes it is RouteFinder200 setup
		m_Speed1Wnd.ShowWindow (SW_HIDE) ;
		m_Speed1ListWnd.ShowWindow (SW_HIDE) ;
		m_StatModemType1.ShowWindow (SW_HIDE) ;
		m_ComboBoxModemType1.ShowWindow (SW_HIDE) ;

		m_Speed1Wnd.EnableWindow (FALSE) ;
		m_Speed1ListWnd.EnableWindow (FALSE) ;
		m_StatModemType1.EnableWindow (FALSE) ;
		m_ComboBoxModemType1.EnableWindow (FALSE) ;

	}
#endif

	if ( GetPrivateProfileString(PPPSectionHeader, "PPP Port0 Option%LCP%EPD",
				StrNull, szBuf, sizeof(szBuf), FileName))
		m_MLPPP = TRUE;
	else
		m_MLPPP = FALSE;


	CenterWindow() ;
	UpdateData (FALSE) ; 	// update the dialog with class stuff

	m_bDialogInited = TRUE ; //A lock for password editing
	return TRUE ;  // return TRUE  unless you set the focus to a control
}


void CWandefs::GetModemTypes()
{
	char szFilePath[200] ; // For MODEMS.CNF File

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	fModemsPtr = fopen (szFilePath, "rb") ;

	m_ComboBoxModemType1.ResetContent() ;
	m_ComboBoxModemType2.ResetContent() ;
	m_ComboBoxModemType3.ResetContent() ;

	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
				"Warning - File not found", MB_OK) ;
		return ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(),
			"Invalid MODEMS.CNF file", "Warning", MB_OK) ;
		return ;
	} 

	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;
	MODEM_SETUP ModemSetup ;

	while (TRUE)
	{
		if (fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) < 1)
			break ;
		if (strcmp (ModemSetup.ModemType, "Direct Connection") != 0)
		{
			m_ComboBoxModemType1.AddString (ModemSetup.ModemType) ;
			if (m_nPorts > 1)
			{
				m_ComboBoxModemType2.AddString (ModemSetup.ModemType) ;
				if (m_nPorts > 2)
					m_ComboBoxModemType3.AddString (ModemSetup.ModemType) ;
			}
		}
	}

	fclose (fModemsPtr) ;
	return ;
}

void CWandefs::WriteModemsInfoToIni()
{
	char szFilePath[200] ; // For MODEMS.CNF File

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	fModemsPtr = fopen (szFilePath, "rb") ;

	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
				"Warning - File not found", MB_OK) ;
		return ;
	}

	WORD nModems ;
	MODEMS_HDR ModemsHdr ;
	fread (&ModemsHdr, sizeof (ModemsHdr), 1, fModemsPtr) ;
	nModems = ModemsHdr.NumEntries ;
	
	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(),
			"Invalid MODEMS.CNF file", "Warning", MB_OK) ;
		return ;
	} 

	int nSelected ;
	MODEM_SETUP ModemSetup ;
	char szModemNameInCombo[80] ;
	WORD j = 0 ;

	nSelected = m_ComboBoxModemType1.GetCurSel() ;
	if (nSelected == CB_ERR)
	{
		memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;
	}
	else
	{
		// Offset from the Modems Header to First Modem Info
		fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

		m_ComboBoxModemType1.GetLBText (nSelected, (LPSTR) szModemNameInCombo) ;
		for ( ; j < nModems ; j ++)
		{
			fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) ;
			if (!strcmpi (szModemNameInCombo, ModemSetup.ModemType))
				break ;
		}
	}
	if (j == nModems)
		memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;
	WriteToIni (0, &ModemSetup) ;

	if (m_nPorts > 1)
	{
		j = 0 ;
		nSelected = m_ComboBoxModemType2.GetCurSel() ;	
		if (nSelected == CB_ERR)
		{
			memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;
		}
		else
		{
			// Offset from the Modems Header to First Modem Info
			fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

			m_ComboBoxModemType2.GetLBText (nSelected, 
										(LPSTR) szModemNameInCombo) ;
			for ( ; j < nModems ; j ++)
			{
				fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) ;
				if (!strcmpi (szModemNameInCombo, ModemSetup.ModemType))
					break ;
			}
		}
		if (j == nModems)
			memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;

		WriteToIni (1, &ModemSetup) ;

		if (m_nPorts > 2)
		{
			j = 0 ;
			nSelected = m_ComboBoxModemType3.GetCurSel() ;
			if (nSelected == CB_ERR)
			{
				memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;
			}
			else
			{
				// Offset from the Modems Header to First Modem Info
				fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

				m_ComboBoxModemType3.GetLBText (nSelected, 
											(LPSTR) szModemNameInCombo) ;
				for ( ; j < nModems ; j ++)
				{
					fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) ;
					if (!strcmpi (szModemNameInCombo, ModemSetup.ModemType))
						break ;
				}
			}
			if (j == nModems)
				memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;
			WriteToIni (2, &ModemSetup) ;
		}
	}

	fclose (fModemsPtr) ;
	return ;
}

void CWandefs::WriteToIni (int nPortNumber, MODEM_SETUP *pModemSetup)
{
	WriteModemStringsToIni (nPortNumber, pModemSetup) ;
	return ;
}

#if 0
void APPLICAT::OnUpdateEditPword()
{
	// TODO: Add your control notification handler code here

	int nPassLen = m_PWord.GetLength() ;
	if (m_bDialogInited)
	{
		if ((m_EditPasWordWnd.LineLength (-1) > nPassLen || m_EditPasWordWnd.LineLength (-1) < nPassLen) && nPassLen)
		{
			m_PWordStr = "" ;
			UpdateData (FALSE) ;
		}
	}
}
#endif


void CWandefs::OnUpdateEditPword1()
{
	// TODO: Add your control notification handler code here
	
	int nPassLen = m_1PWord.GetLength() ;
	if (m_bDialogInited)
	{
		if ((m_1PWordWnd.LineLength (-1) > nPassLen || m_1PWordWnd.LineLength (-1) < nPassLen) && nPassLen)
		{
			UpdateData (TRUE) ;
			m_1PWord = StrNull ;
			UpdateData (FALSE) ;
		}
	}
}

void CWandefs::OnUpdateEditPword2()
{
	// TODO: Add your control notification handler code here
	
	int nPassLen = m_2PWord.GetLength() ;
	if (m_bDialogInited)
	{
		if ((m_2PWordWnd.LineLength (-1) > nPassLen || m_2PWordWnd.LineLength (-1) < nPassLen) && nPassLen)
		{
			UpdateData (TRUE) ;
			m_2PWord = StrNull ;
			UpdateData (FALSE) ;
		}
	}
}

void CWandefs::OnUpdateEditPword3()
{
	// TODO: Add your control notification handler code here
	
	int nPassLen = m_3PWord.GetLength() ;
	if (m_bDialogInited)
	{
		if ((m_3PWordWnd.LineLength (-1) > nPassLen || m_3PWordWnd.LineLength (-1) < nPassLen) && nPassLen)
		{
			UpdateData (TRUE) ;
			m_3PWord = StrNull ;
			UpdateData (FALSE) ;
		}
	}
}
