// Project Name		:	MultiRouter Setup for Windows 
// File Name         :	WANDLG.CPP
// Description       :	Defines Classes :
//									CWANDlg		: Function of WAN Dialog
//									CWANPortDlg	: Function of WAN Port Tabs
//									CWANTab		: Function of WAN Port TabDialog
// Start Date        :	8th May 1995
// Author            :	Pravin
// Date Last Modified:       
// Modifications     :  2/11/95 Vidy added LSL speed updation for SNMP
// Modifications     :  2/11/95 Vidy fixed LSL speed updation 
// -------------------------------------------------------------------------
// Vidy 05/12/96		: if only one wan don't show WAN 1

// -------------------------------------------------------------------------
// Include Files
// -------------------------------------------------------------------------

#include <stdio.h>
#include "stdafx.h"
#include "procon.h"
#include "wandlg.h"
#include "tabdlg.h"
#include "maindlg.h"
#include "modem.h"
#include "script.h"

//Sudha 9 Dec 1997
#include <ctype.h>
#include "isdnta.h"

// In case this is changed, make sure it is changed in modem.h (in the target also)
#define MAX_INIT_STRING_LENGTH 41

LPCSTR DefaultConfigHeader = "Default Configs";
LPCSTR DefaultIniString = "Config1";
char TempSection[40];

LPCSTR IsdnMsgHeader = "ProxyServer Setup - Isdn Configuration" ;

//Sudha 9 Dec 1997
char WanPortNum[12];
int m_cfgtype = 0;


LPCSTR MapHeader = "Port Mappings";

// -------------------------------------------------------------------------
// Macros
// -------------------------------------------------------------------------
         
LPCSTR WANMsgHeader = "MultiRouter Setup - WAN" ;
LPCSTR WANSectionHeader = "WAN Serial Device Driver" ;
LPCSTR ScriptSectionHeader = "Script Section" ;

static BOOL RouterStatus = FALSE ;
#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWANDlg dialog


CWANDlg::CWANDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWANDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWANDlg)
	m_WANEnable = TRUE;
	m_Printf = FALSE;
	m_PrintfRx = FALSE;
	m_PrintfTx = FALSE;
	m_PrintfInitialize = FALSE;
	m_bNonCriticalScriptPrintf = FALSE;
	m_bAlarmScriptPrintf = FALSE;
	m_szPPINISection = "";
	//}}AFX_DATA_INIT

	m_bMdmConfigChanged = FALSE;
	m_nSelectedModem = CB_ERR ;
	m_nSelectedIsdn = CB_ERR ;
	IsdnEnabled = FALSE;
}

void CWANDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWANDlg)
	DDX_Control(pDX, IDC_STATIC_ISDN_CONTROL, m_IsdnCtrlWnd);
	DDX_Control(pDX, IDC_ISDN_EDIT, m_EditConfig);
	DDX_Control(pDX, IDC_ISDN_DELETE, m_DeleteConfig);
	DDX_Control(pDX, IDC_ISDN_ADD, m_AddConfig);
	DDX_Control(pDX, IDC_EXISTING_CFGS, m_INISectionControl);
	DDX_Control(pDX, IDC_CHECK_NON_CRITICAL, m_ChkBoxScriptNonCritical);
	DDX_Control(pDX, IDC_CHECK_SCRIPT_ALARM, m_ChkBoxScriptAlarm);
	DDX_Control(pDX, IDC_STATIC_SCRIPT_PRINTF_GRP, m_ScriptCtrlGrp);
	DDX_Control(pDX, IDC_BTN_ADD_MODEM, m_BtnAdd);
	DDX_Control(pDX, IDC_STATIC_MODEM_CONTROL, m_MdmCtrlWnd);
	DDX_Control(pDX, IDC_BTN_EDIT_MODEM, m_BtnEdit);
	DDX_Control(pDX, IDC_BTN_DELETE_MODEM, m_BtnDelete);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPES, m_combBoxModemTypes);
	DDX_Check(pDX, IDC_PRINTF, m_Printf);
	DDX_Check(pDX, IDC_PRINTF_RX, m_PrintfRx);
	DDX_Check(pDX, IDC_PRINTF_TX, m_PrintfTx);
	DDX_Check(pDX, IDC_INITIALIZE, m_PrintfInitialize);
	DDX_Check(pDX, IDC_CHECK_NON_CRITICAL, m_bNonCriticalScriptPrintf);
	DDX_Check(pDX, IDC_CHECK_SCRIPT_ALARM, m_bAlarmScriptPrintf);
	DDX_CBString(pDX, IDC_EXISTING_CFGS, m_szPPINISection);
	DDV_MaxChars(pDX, m_szPPINISection, 40);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWANDlg, CDialog)
	//{{AFX_MSG_MAP(CWANDlg)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEM_TYPES, OnSelchangeComboModemTypes)
	ON_BN_CLICKED(IDC_BTN_ADD_MODEM, OnBtnAddModem)
	ON_BN_CLICKED(IDC_BTN_EDIT_MODEM, OnBtnEditModem)
	ON_BN_CLICKED(IDC_BTN_DELETE_MODEM, OnBtnDeleteModem)
	ON_BN_CLICKED(IDC_ISDN_EDIT, OnIsdnEdit)
	ON_BN_CLICKED(IDC_ISDN_DELETE, OnIsdnDelete)
	ON_BN_CLICKED(IDC_ISDN_ADD, OnIsdnAdd)
	ON_CBN_SELCHANGE(IDC_EXISTING_CFGS, OnCfgs)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWANDlg message handlers

BOOL CWANDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;
	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	char szBuf[30] ;
	// Get the values of all WAN parameters from INI file.
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Printf", (LPCSTR) StrDisabled, (LPSTR) szBuf,
				sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_Printf = TRUE ;
	else 
		m_Printf = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Initialization Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfInitialize = TRUE ;
	else
		m_PrintfInitialize = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Rx Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfRx = TRUE ;
	else 
		m_PrintfRx = FALSE ;
	
	GetPrivateProfileString ((LPCSTR) WANSectionHeader, 
			(LPCSTR) "WAN Tx Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm);
	if (!strcmp (szBuf, StrEnabled))
		m_PrintfTx = TRUE ;
	else
		m_PrintfTx = FALSE ;

	GetPrivateProfileString ((LPCSTR) ScriptSectionHeader, 
			(LPCSTR) "Script Alarm Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_bAlarmScriptPrintf = TRUE ;
	else
		m_bAlarmScriptPrintf = FALSE ;

	GetPrivateProfileString ((LPCSTR) ScriptSectionHeader, 
			(LPCSTR) "Script Non Critical Printf", (LPCSTR) StrDisabled,
				(LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	if (strcmp (szBuf, StrEnabled) == 0)
		m_bNonCriticalScriptPrintf = TRUE ;
	else
		m_bNonCriticalScriptPrintf = FALSE ;

/* chetan 9/7/97 */
	if (IsLanTalker)
	{
		m_ChkBoxScriptNonCritical.ShowWindow (SW_HIDE) ;
		m_ChkBoxScriptAlarm.ShowWindow (SW_HIDE) ;
		m_ScriptCtrlGrp.ShowWindow (SW_HIDE) ;

		m_ChkBoxScriptNonCritical.EnableWindow (FALSE) ;
		m_ChkBoxScriptAlarm.EnableWindow (FALSE) ;
		m_ScriptCtrlGrp.EnableWindow (FALSE) ;
	}

	if (!IsRF200 && !IsLanTalker && !IsISDNProxy )
	{
		if (!GetModemTypes())
		{
			CDialog::OnCancel() ;
			return FALSE ;
		}

		if (m_nSelectedModem != CB_ERR)
			m_combBoxModemTypes.SetCurSel (m_nSelectedModem) ;
		GetIsdnTypes ();
		if (m_nSelectedIsdn != CB_ERR )
			m_INISectionControl.SetCurSel ( m_nSelectedIsdn );

		if ( m_INISectionControl.GetCurSel () == CB_ERR )
  			m_INISectionControl.SetCurSel(m_INISectionControl.FindStringExact(-1,"EuroIsdn"));
  		//m_INISectionControl.GetWindowText ( m_szPPINISection );
                m_INISectionControl.GetLBText(m_INISectionControl.GetCurSel (),m_szPPINISection );
		sprintf ( TempSection ,"%s",m_szPPINISection );
	}
	
	RECT FullRect ;
	RECT ClipRect ;

	if ( IsISDNProxy )
	{

		GetWindowRect (&FullRect) ;
		m_MdmCtrlWnd.GetWindowRect (&ClipRect) ;
//		FullRect.bottom = ClipRect.top + 6 ;
		FullRect.bottom = ClipRect.top ;
		MoveWindow (&FullRect, TRUE) ;
		m_BtnAdd.EnableWindow (FALSE) ;
		m_BtnEdit.EnableWindow (FALSE) ;
		m_BtnDelete.EnableWindow (FALSE) ;
		m_combBoxModemTypes.EnableWindow (FALSE) ;
		m_MdmCtrlWnd.EnableWindow (FALSE) ;
	}

	if ( IsLanTalker || IsRF200 )
	{
		GetWindowRect (&FullRect) ;
		m_IsdnCtrlWnd.GetWindowRect (&ClipRect) ;
	//	FullRect.bottom = ClipRect.top + 6 ;
	  	FullRect.bottom = ClipRect.top ;
	  	MoveWindow (&FullRect, TRUE) ;
	  	m_AddConfig.EnableWindow ( FALSE );
	  	m_EditConfig.EnableWindow ( FALSE );
	  	m_DeleteConfig.EnableWindow ( FALSE );
	  	m_INISectionControl.EnableWindow ( FALSE );
	  	m_IsdnCtrlWnd.EnableWindow ( FALSE );
	  	m_BtnAdd.EnableWindow (FALSE) ;
	  	m_BtnEdit.EnableWindow (FALSE) ;
	  	m_BtnDelete.EnableWindow (FALSE) ;
	  	m_combBoxModemTypes.EnableWindow (FALSE) ;
	  	m_MdmCtrlWnd.EnableWindow (FALSE) ;
  	}
	else
	{
		GetIsdnTypes ();
		if (m_nSelectedIsdn != CB_ERR )
			m_INISectionControl.SetCurSel ( m_nSelectedIsdn );
		if ( m_INISectionControl.GetCurSel () == CB_ERR )
			m_INISectionControl.SetCurSel(m_INISectionControl.FindStringExact(-1,"EuroIsdn"));
  		//m_INISectionControl.GetWindowText ( m_szPPINISection );
                m_INISectionControl.GetLBText ( m_INISectionControl.GetCurSel(),m_szPPINISection );
		sprintf ( TempSection ,"%s",m_szPPINISection );
	}	
	CenterWindow() ;

   // Update the Dialog Box fields.
	UpdateData (FALSE) ;
	return TRUE ;  // return TRUE  unless you set the focus to a control
}


void CWANDlg::OnHelp()
{
	AfxGetApp()->WinHelp(0x20000 + IDD_WAN_CONFIG,HELP_CONTEXT);
	
}


void CWANDlg::OnOK()
{
	// Update the parameters from the Dialog Box.
	if (!UpdateData (TRUE))
      return ;

	LPCSTR temp ;
	// Write the WAN parameters to the INI file.

	if (m_Printf)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) "WAN Printf", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
		
	if (m_PrintfInitialize)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Initialization Printf", (LPCSTR) temp,
				(LPCSTR) IniInWinForm) ;

	if (m_PrintfRx)
		temp = StrEnabled ;
	else 
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Rx Printf", (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
			
	if (m_PrintfTx)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) "WAN Tx Printf", temp, (LPCSTR) IniInWinForm) ;

	if (m_bAlarmScriptPrintf)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) ScriptSectionHeader, 
				(LPCSTR) "Script Alarm Printf", 
						(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	if (m_bNonCriticalScriptPrintf)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) ScriptSectionHeader, 
				(LPCSTR) "Script Non Critical Printf", 
						(LPCSTR) temp, (LPCSTR) IniInWinForm) ;
	if (!IsRF200 && !IsLanTalker && !IsISDNProxy)
	{	
		PutModemsInParentsList() ;

		if (m_bMdmConfigChanged)
			WriteToCnfFile() ;
	}
	else if ( IsISDNProxy )
	{
		CWANTab *pParent = (CWANTab *) GetParent() ;

		for (int i = 0 ; i < pParent->tabcount ; i ++)
			PutIsdnConfigInParentsList(i) ;
	}

	CDialog::OnOK();
}

/*----------------------------------------------------------------------------
	Module 	: WriteToCnfFile
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any error while writing
	Synopsis	: Writes the Modem Info into the MODEMS.CNF file
				  along with the Header
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWANDlg::WriteToCnfFile()
{
	char szFilePath[200] ;
	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	// Rewrite Modems.Cnf file with new Modems Info
	fModemsPtr = fopen (szFilePath, "wb") ;
	if (fModemsPtr == NULL)
	{
		MessageBox ("Could not create MODEMS.CNF file",
			"File Creation Error", MB_OK | MB_ICONSTOP) ;

		// Before returning free all the buffers allocated
		// with new
		ReleaseBuffers() ;
		return FALSE ;
	}

	int nItems = m_combBoxModemTypes.GetCount() ;

	MODEMS_HDR ModemsHdr ;

	ModemsHdr.ChkSum = (WORD) 0 ; // Just like that
	ModemsHdr.Version = '1' ;  // For the time being
	ModemsHdr.NumEntries = (WORD) nItems ; // No. of modems
	fwrite (&ModemsHdr, sizeof (ModemsHdr), 1, fModemsPtr) ;

	MODEM_SETUP *pModemSetup ;

	// Write each Modem Info. one by one
	for (int i = 0 ; i < nItems ; i ++)
	{
		pModemSetup = (MODEM_SETUP *)
			m_combBoxModemTypes.GetItemDataPtr (i) ;
		fwrite ((MODEM_SETUP *) pModemSetup, 
				sizeof (MODEM_SETUP), 1, fModemsPtr) ;
	}

	// This is to ensure that "Direct Connection"
	// still goes with the modems.cnf file
	MODEM_SETUP DirConnect ;
	memset (&DirConnect, 0x00, sizeof (MODEM_SETUP)) ;
	strcpy (DirConnect.ModemType, "Direct Connection") ;
	fwrite (&DirConnect, sizeof (MODEM_SETUP), 1, fModemsPtr) ;

	fclose (fModemsPtr) ;
		
	// Open Modems.Cnf file in Read-Write-Binary Mode
	fModemsPtr = fopen (szFilePath, "r+b") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(), "Error writing MODEMS.CNF!!!",
				"Warning", MB_OK) ;

		// Before returning free all the buffers allocated
		// with new
		ReleaseBuffers() ;
		return FALSE ;
	}
		
	if (!WriteCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Error writing MODEMS.CNF!!!",
				"Warning", MB_OK) ;
	}
	fclose (fModemsPtr) ;

	// Before returning free all the buffers allocated
	// with new
	ReleaseBuffers() ;
	return TRUE ;
}

/*----------------------------------------------------------------------------
	Module 	: ReleaseBuffers
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Releases all Buffers allocated for storing
				  the Modems Information	
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::ReleaseBuffers()
{
	int nItems = m_combBoxModemTypes.GetCount() ;
	MODEM_SETUP *pModemSetup ;

	for (int i = 0 ; i < nItems ; i ++)
	{
		pModemSetup = (MODEM_SETUP *) 
				m_combBoxModemTypes.GetItemDataPtr (i) ;
		delete pModemSetup ;
	}
	return ;
}

/*----------------------------------------------------------------------------
	Module 	: PutModemsInParentsList
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Puts the Modems List into each of the Tab's Combo Boxes
				  And depending on the previous selection	restores them
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::PutModemsInParentsList()
{
	CWANTab *pParent = (CWANTab *) GetParent() ;
	int nCount = m_combBoxModemTypes.GetCount() ;

	char szBuf[40] ;
	int nIndex ;
	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		// Get the previous selection
		if ( pParent->m_pdlgWAN[i]->m_RBtnIsdn.GetCheck() == 0)
		{
			nIndex = pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
			if (nIndex != CB_ERR)
			{
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nIndex, szBuf) ;
				pParent->m_pdlgWAN[i]->m_szOldModemSel = szBuf ;
			}
			else
				pParent->m_pdlgWAN[i]->m_szOldModemSel = "" ;
			
			// Refresh the Modems List in the Combo Box
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent() ;

			// Add Modems to List
			for (int j = 0 ; j < nCount ; j ++)
			{
				m_combBoxModemTypes.GetLBText (j, (LPSTR) szBuf) ;
				if (strcmp (szBuf, "Direct Connection") != 0)
					pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (szBuf) ;
			}

			// If there was a previous selection restore it
			if (!pParent->m_pdlgWAN[i]->m_szOldModemSel.IsEmpty())
			{
				nIndex =	
					pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1, 
									pParent->m_pdlgWAN[i]->m_szOldModemSel) ;								
				if ( nIndex == CB_ERR)
					nIndex = 0;
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nIndex) ;
			}	
		}
		else
			PutIsdnConfigInParentsList(i);
	}		
}

void CWANDlg::PutIsdnConfigInParentsList (int index)
{
	CWANTab *pParent = (CWANTab *) GetParent() ;
 	int nCount = m_INISectionControl.GetCount() ;

	char szBuf[40] ;
	int nIndex ;
	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		// Get the previous selection
		if ( i == index )
		{
			nIndex = pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
			if (nIndex != CB_ERR)
			{
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nIndex, szBuf) ;
				pParent->m_pdlgWAN[i]->m_szOldIsdnSel = szBuf ;
			}
			else
				pParent->m_pdlgWAN[i]->m_szOldIsdnSel = "" ;
			
			// Refresh the Isdn Configs List in the Combo Box
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent() ;
			
			// Add Isdn Configs to List
			for (int j = 0 ; j < nCount ; j ++)
			{
				m_INISectionControl.GetLBText (j, (LPSTR) szBuf) ;
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (szBuf) ;
			}

			// If there was a previous selection restore it
			if (!pParent->m_pdlgWAN[i]->m_szOldIsdnSel.IsEmpty())
			{
				nIndex =	
					pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1, 
									pParent->m_pdlgWAN[i]->m_szOldIsdnSel) ;								
				if ( nIndex == CB_ERR)
					nIndex = 0;
				pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nIndex) ;

			}
		}	
	}		
}

/////////////////////////////////////////////////////////////////////////////
// CWANPortDlg dialog


CWANPortDlg::CWANPortDlg(CWnd* pParent /*=NULL*/)
	: CDialog(CWANPortDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWANPortDlg)
	m_WANPort = FALSE;
	m_cboxAsyncBaud = "";
	m_cboxSyncIntClk = "";
	m_StrDialNumber = "";
	m_bDirConnect = FALSE;
	m_bRestartScriptOnCommFailure = FALSE;
	m_bScriptEnable = FALSE;
	m_Line = "";
	m_szSectionName = "";
	//}}AFX_DATA_INIT

	m_szOldModemSel = "";
	m_szOldIsdnSel = "";
	
	Create(IDD,NULL);
}

void CWANPortDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWANPortDlg)
	DDX_Control(pDX, IDC_MODEM_CONFIG, m_RBtnModem);
	DDX_Control(pDX, IDC_ISDN_CONFIG, m_RBtnIsdn);
	DDX_Control(pDX, IDC_BTN_SCRIPT, m_BtnScript);
	DDX_Control(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_RestartScriptWnd);
	DDX_Control(pDX, IDC_CHECK_ENABLE_SCRIPT, m_ScriptEnableWnd);
	DDX_Control(pDX, IDC_CHECK_DIR_CONNECT, m_chkBtnDirConnect);
	DDX_Control(pDX, IDC_CHECK_IDLE_FLAGS, m_chkboxIdleFlags);
	DDX_Control(pDX, IDC_EDIT_DIAL_NUMBER, m_EditDialNumberWnd);
	DDX_Control(pDX, IDC_STATIC_DIAL_NUMBER, m_StatDialNumber);
	DDX_Control(pDX, IDC_STATIC_MODEM_TYPES, m_StatModemTypes);
	DDX_Control(pDX, IDC_COMBO_MODEM_TYPES, m_ComBoxModemTypes);
	DDX_Control(pDX, IDC_CLK_SPEED_HDR, m_ClkSpeedHdr);
	DDX_Control(pDX, IDC_BAUD_HEADER, m_BaudHeader);
	DDX_Control(pDX, IDC_DIALLING, m_RBtnDialling);
	DDX_Control(pDX, IDC_ANSWERING, m_RBtnAnswering);
	DDX_Control(pDX, IDC_EXT_CLOCK, m_RBtnExtClk);
	DDX_Control(pDX, IDC_SYNC_INT_CLK, m_cboxSyncIntClkWnd);
	DDX_Control(pDX, IDC_INT_CLOCK, m_RBtnIntClk);
	DDX_Control(pDX, IDC_RADIO_SYNC, m_RBtnSync);
	DDX_Control(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaudWnd);
	DDX_Control(pDX, IDC_RADIO_ASYNC, m_RBtnAsync);
	DDX_Check(pDX, IDC_WAN_PORT, m_WANPort);
	DDX_CBString(pDX, IDC_ASYNC_BAUD, m_cboxAsyncBaud);
	DDV_MaxChars(pDX, m_cboxAsyncBaud, 15);
	DDX_CBString(pDX, IDC_SYNC_INT_CLK, m_cboxSyncIntClk);
	DDV_MaxChars(pDX, m_cboxSyncIntClk, 15);
	DDX_Text(pDX, IDC_EDIT_DIAL_NUMBER, m_StrDialNumber);
	DDX_Check(pDX, IDC_CHECK_DIR_CONNECT, m_bDirConnect);
	DDX_Check(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_bRestartScriptOnCommFailure);
	DDX_Check(pDX, IDC_CHECK_ENABLE_SCRIPT, m_bScriptEnable);
	DDX_Text(pDX, IDC_STATIC_MODEM_TYPES, m_Line);
	DDX_CBString(pDX, IDC_COMBO_MODEM_TYPES, m_szSectionName);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWANPortDlg, CDialog)
	//{{AFX_MSG_MAP(CWANPortDlg)
	ON_REGISTERED_MESSAGE(msgSwitchFrom, OnSwitchFromIden)
	ON_REGISTERED_MESSAGE(msgSwitchTo, OnSwitchToIden)
	ON_BN_CLICKED(IDC_HELP, OnHelp)
	ON_BN_CLICKED(IDC_RADIO_ASYNC, OnRadioAsync)
	ON_BN_CLICKED(IDC_RADIO_SYNC, OnRadioSync)
	ON_BN_CLICKED(IDC_INT_CLOCK, OnIntClock)
	ON_BN_CLICKED(IDC_EXT_CLOCK, OnExtClock)
	ON_BN_CLICKED(IDC_ANSWERING, OnAnswering)
	ON_BN_CLICKED(IDC_DIALLING, OnDialling)
	ON_BN_CLICKED(IDC_ADVANCED, OnAdvanced)
	ON_BN_CLICKED(IDC_CHECK_DIR_CONNECT, OnCheckDirConnect)
	ON_BN_CLICKED(IDC_BTN_SCRIPT, OnBtnScript)
	ON_BN_CLICKED(IDC_ISDN_CONFIG, OnIsdn)
	ON_BN_CLICKED(IDC_MODEM_CONFIG, OnModem)
	ON_CBN_SELCHANGE(IDC_COMBO_MODEM_TYPES, OnSelchangeComboModemTypes)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWANPortDlg message handlers

void CWANPortDlg::OnCancel()
{
	GetParent()->PostMessage(WM_COMMAND, IDCANCEL);
}

void CWANPortDlg::OnOK()
{
	// TODO: Add extra validation here
	if (!UpdateData (TRUE))
		return ;

   if (!ValidEditFields())  
      return;

	CDialog::OnOK() ;
	GetParent()->PostMessage(WM_COMMAND, IDOK) ;
}

LRESULT CWANPortDlg::OnSwitchFromIden(WPARAM wParam, LPARAM lParam)
{
	UpdateData(TRUE);  
	return (0L);
}

void CWANPortDlg::PostNcDestroy(void)
{
	delete this;
}

void CWANPortDlg::OnHelp()
{
		AfxGetApp()->WinHelp(0x20000 + IDD_WAN_PORT_CONFIG,HELP_CONTEXT);
	
}


/////////////////////////////////////////////////////////////////////////////
// CWANTab dialog


CWANTab::CWANTab(CWnd* pParent /*=NULL*/)
	: CTabDialog(CWANTab::IDD, pParent)
{

//{{AFX_DATA_INIT(CWANTab)
		// NOTE: the ClassWizard will add member initialization here
		m_nPort = 3 ;
	//}}AFX_DATA_INIT

	// Get the UINT parameter
	m_nPort = GetPrivateProfileInt(WANSectionHeader,
				(LPCSTR) "WAN Number of Ports",0,
								(LPCSTR) IniInWinForm);
	if (m_nPort < 1 || m_nPort > 3)
		m_nPort = 3 ;

	tabcount = m_nPort ;
	
	// Limit the tabcount
	if (tabcount > n_PORTMAX_WAN)
		tabcount = n_PORTMAX_WAN ;
	if (tabcount < 1)
		tabcount = 1 ;

	for (int i = 0 ; i < tabcount ; i++)
		m_pdlgWAN [i] = new CWANPortDlg (this);
}

void CWANTab::DoDataExchange(CDataExchange* pDX)
{
	CTabDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWANTab)
		// NOTE: the ClassWizard will add DDX and DDV calls here
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWANTab, CTabDialog)
	//{{AFX_MSG_MAP(CWANTab)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWANTab message handlers
void CWANTab::GetConfig()
{
	char szBuf[80] ;
	BOOL fAsync, fIntClk, fAnswering, fDirConnect,fIsdn,fModem ;
   // Get all the parameters for Ports
   // Get the BOOL parameters.      
  	char field[80] ;
	char strLHS[40],strRHS[40];
	
	if ( !IsISDNProxy )  	
		GetModemTypes() ;

   for (int i = 0 ; i < tabcount ; i ++)
   {
		char Buf[12] ;
		_itoa (i, Buf, 10) ;
		
		strcpy (field, "WAN Port") ;
		strcat (field, Buf) ;
		strcpy (Buf, field) ;
		GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) IniInWinForm) ;
   	if (!strcmp (szBuf, StrEnabled))
   		m_pdlgWAN[i]->m_WANPort = TRUE ;
	  	else
	   	m_pdlgWAN[i]->m_WANPort = FALSE ;

      strcpy (field, Buf) ;
      strcat (field, " Async") ;
      GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;

      // Modified here by cfp on 25-3-96
      if (!strcmp (szBuf, StrEnabled))
	   {
			m_pdlgWAN[i]->m_RBtnAsync.SetCheck (1) ;
         m_pdlgWAN[i]->m_RBtnSync.SetCheck (0) ;
			fAsync = TRUE ;
	   }
	   else
	   {
			m_pdlgWAN[i]->m_RBtnAsync.SetCheck (0) ;
         m_pdlgWAN[i]->m_RBtnSync.SetCheck (1) ;
			fAsync = FALSE ;
	   } 
	 
      strcpy (field, Buf) ;
	   strcat (field, " Internal Clock") ;
	   GetPrivateProfileString(WANSectionHeader,
				(LPCSTR) field, StrDisabled,(LPSTR) szBuf, sizeof(szBuf),
		   			(LPCSTR) IniInWinForm) ;
	   if (!strcmpi (szBuf, StrEnabled))
	   {
			m_pdlgWAN[i]->m_RBtnExtClk.SetCheck (0) ;
	  		m_pdlgWAN[i]->m_RBtnIntClk.SetCheck (1) ;
			fIntClk = TRUE ;
      }
	   else
	   {
			m_pdlgWAN[i]->m_RBtnExtClk.SetCheck (1) ;
	  		m_pdlgWAN[i]->m_RBtnIntClk.SetCheck (0) ;
			fIntClk = FALSE ;
      }

		strcpy (field, Buf) ;
		strcat (field, " Send Idle Flags") ;
		GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
						(LPCSTR) IniInWinForm) ;
		if (!strcmp (szBuf, StrEnabled))
			m_pdlgWAN[i]->m_chkboxIdleFlags.SetCheck (1) ;
		else
			m_pdlgWAN[i]->m_chkboxIdleFlags.SetCheck (0) ;

		strcpy (field, Buf) ;
		strcat (field, " Script") ;
		GetPrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) field, (LPCSTR) StrDisabled, (LPSTR) szBuf,
					sizeof (szBuf), (LPCSTR) IniInWinForm) ;
		if (strcmp (szBuf, StrEnabled) == 0)
			m_pdlgWAN[i]->m_bScriptEnable = TRUE ;
		else
			m_pdlgWAN[i]->m_bScriptEnable = FALSE ;
        
		strcpy (field, Buf) ;
		strcat (field, " Restart Script On Comm Failure") ;
		GetPrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) field, (LPCSTR) StrDisabled, (LPSTR) szBuf,
					sizeof (szBuf), (LPCSTR) IniInWinForm) ;
		if (strcmp (szBuf, StrEnabled) == 0)
			m_pdlgWAN[i]->m_bRestartScriptOnCommFailure = TRUE ;
		else
			m_pdlgWAN[i]->m_bRestartScriptOnCommFailure = FALSE ;

      strcpy (field, Buf) ;
      strcat (field, " Direct Connect") ;
      GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
	   if (!strcmp (szBuf, StrEnabled)) 
			m_pdlgWAN[i]->m_bDirConnect = TRUE ;
	   else  
			m_pdlgWAN[i]->m_bDirConnect = FALSE ;

		fDirConnect = m_pdlgWAN[i]->m_bDirConnect;

//Sudha 9 Dec 1997	 	
		sprintf(strLHS,"ISDN WAN Port%d",i);
		GetPrivateProfileString(WANSectionHeader,strLHS,StrNull,strRHS,
			sizeof(strRHS),IniInWinForm );

		if ( !IsISDNProxy )
		{
			m_pdlgWAN[i]->m_Line.LoadString ( IDS_MODEM_ISDN_TYPES );
			if ( fAsync == TRUE && m_pdlgWAN[i]->m_bDirConnect == FALSE)
			{				
				if (!strcmpi ( strRHS,StrEnabled ))
				{
					fIsdn = TRUE;
					m_pdlgWAN[i]->m_RBtnIsdn.SetCheck (1);
					m_pdlgWAN[i]->m_RBtnModem.SetCheck (0);

				}
				else
				{
					fIsdn = FALSE;
					m_pdlgWAN[i]->m_RBtnIsdn.SetCheck (0);
					m_pdlgWAN[i]->m_RBtnModem.SetCheck (1);
				}
			}
			else
			{
				fIsdn = FALSE;
				m_pdlgWAN[i]->m_RBtnIsdn.SetCheck (0);
				m_pdlgWAN[i]->m_RBtnModem.SetCheck (1);
			}
		}	
		else
		{
			m_pdlgWAN[i]->m_Line.LoadString ( IDS_ISDN_TYPES );
			fIsdn = TRUE;
			m_pdlgWAN[i]->m_RBtnIsdn.SetCheck (1);
			m_pdlgWAN[i]->m_RBtnModem.SetCheck (0);
		}

		fModem = !fIsdn;

	   strcpy (field, Buf) ;
      strcat (field, " Auto Answer") ;
	   GetPrivateProfileString (WANSectionHeader,
				(LPCSTR) field, StrDisabled, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
      if (!strcmp (szBuf, StrEnabled)) 
	   {
			m_pdlgWAN[i]->m_RBtnAnswering.SetCheck (1) ;
			m_pdlgWAN[i]->m_RBtnDialling.SetCheck (0) ;
			fAnswering = TRUE ;
	   }
	   else 
	   {
			m_pdlgWAN[i]->m_RBtnAnswering.SetCheck (0) ;
			m_pdlgWAN[i]->m_RBtnDialling.SetCheck (1) ;
			fAnswering = FALSE ;
	   } 
		
      // Get the CString parameters.
	   strcpy (field, Buf) ;
      strcat (field, " Speed") ;
	   GetPrivateProfileString (WANSectionHeader,
	   	(LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),
		     (LPCSTR) IniInWinForm) ;

	   m_pdlgWAN[i]->m_cboxAsyncBaud = szBuf ;
	   m_pdlgWAN[i]->m_OldSpeedStr = szBuf ;

	   strcpy (field, Buf) ;
	   strcat (field, " Dial Number") ;
      GetPrivateProfileString (WANSectionHeader,  
	 	   (LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),  
		       (LPCSTR) IniInWinForm) ;  
	   m_pdlgWAN[i]->m_StrDialNumber = szBuf ;
	   m_pdlgWAN[i]->m_EditDialNumberWnd.LimitText (LEN_DIAL_NUMBER - 1) ;

	   char szBlankBackSlash[100] ;
	   if ( fModem || !fIsdn)
		{
	   	strcpy (field, Buf) ;
		   strcat (field, " Modem Type") ;
   	   GetPrivateProfileString (WANSectionHeader,  
	 		   (LPCSTR) field, StrNull, (LPSTR) szBuf, sizeof (szBuf),  
		   	     (LPCSTR) IniInWinForm) ;  
		   int nToSelect ;
		   m_pdlgWAN[i]->GetModemTypes(i);
			if (szBuf[0])
	   	{
				ConvertBackSlashesToBlanks (szBlankBackSlash, szBuf) ;
				nToSelect = 
					m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1,
																				szBlankBackSlash) ;
				if (nToSelect == CB_ERR)
					nToSelect = 0 ;
				m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nToSelect) ;
			}
		}
		else
			m_pdlgWAN[i]->GetIsdnTypes(i);

		m_pdlgWAN[i]->m_cboxAsyncBaudWnd.EnableWindow (fAsync) ;
		m_pdlgWAN[i]->m_cboxSyncIntClkWnd.EnableWindow (!fAsync && fIntClk) ;
		m_pdlgWAN[i]->m_RBtnIntClk.EnableWindow (!fAsync ) ;
		m_pdlgWAN[i]->m_RBtnExtClk.EnableWindow (!fAsync) ; 
		m_pdlgWAN[i]->m_BaudHeader.EnableWindow (fAsync) ;
		m_pdlgWAN[i]->m_ClkSpeedHdr.EnableWindow (!fAsync && fIntClk) ;
		/* chetan 9/7/97 */
		m_pdlgWAN[i]->m_ScriptEnableWnd.EnableWindow (fAsync && !fDirConnect);
		m_pdlgWAN[i]->m_RestartScriptWnd.EnableWindow (fAsync && !fDirConnect);
		m_pdlgWAN[i]->m_BtnScript.EnableWindow (RouterStatus && fAsync && !fDirConnect) ;
		/* chetan 9/7/97 */


		m_pdlgWAN[i]->m_StatModemTypes.EnableWindow (fAsync && 
													!m_pdlgWAN[i]->m_bDirConnect) ;
		m_pdlgWAN[i]->m_ComBoxModemTypes.EnableWindow (fAsync && 
													!m_pdlgWAN[i]->m_bDirConnect) ;
		m_pdlgWAN[i]->m_StatDialNumber.EnableWindow (fAsync && !fAnswering &&
													!m_pdlgWAN[i]->m_bDirConnect) ;
		m_pdlgWAN[i]->m_EditDialNumberWnd.EnableWindow (fAsync && !fAnswering && 
													!m_pdlgWAN[i]->m_bDirConnect) ;
		m_pdlgWAN[i]->m_EditDialNumberWnd.EnableWindow (fAsync && !m_pdlgWAN[i]->m_bDirConnect) ;
													
		m_pdlgWAN[i]->m_chkboxIdleFlags.EnableWindow (!fAsync) ;
		m_pdlgWAN[i]->m_RBtnModem.EnableWindow (fAsync && !IsISDNProxy &&
													!m_pdlgWAN[i]->m_bDirConnect) ;
		m_pdlgWAN[i]->m_RBtnIsdn.EnableWindow (fAsync && 
													!m_pdlgWAN[i]->m_bDirConnect) ;


		// Added by cfp on 26-3-96
		strcpy (field, Buf) ;
		strcat (field, " Synchronous Speed") ;
		GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) field, (LPCSTR) StrNull, (LPSTR) szBuf, sizeof (szBuf),
					(LPCSTR) IniInWinForm) ;
		m_pdlgWAN[i]->m_cboxSyncIntClk = szBuf ;

  		// Update the Dialog fields  
		m_pdlgWAN[i]->UpdateData (FALSE) ;
	}	
	
}

BOOL CWANTab::OnInitDialog()
{
	CDialog::OnInitDialog() ;
	
	char Buf[4][16] ;
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;


	if (tabcount == 1)
	{
		strcpy (Buf[0], " WAN ") ;
	}
	else
	{
		strcpy (Buf[0], "WAN  &1") ;
		strcpy (Buf[1], "WAN  &2") ;
		strcpy (Buf[2], "WAN  &3") ;
		
	}

	// Add the Tabs
	for (int i = 0 ; i < tabcount ; i ++)
		addTabView (m_pdlgWAN[i], Buf[i], TRUE, (i == 0), 80) ;
	
   // Get all the parameters of all the ports from INI file
   CenterWindow() ;

	CMainDlg *pMainDialog = (CMainDlg *) GetParent() ;
	RouterStatus = pMainDialog->RouterUp && pMainDialog->TargetFound ;

	GetConfig() ; 
   AfxGetApp()->DoWaitCursor(0) ;
	
   CTabDialog::OnInitDialog() ;
                                               
	return FALSE ;
}


int CWANTab::AcceptConfig()
{
	LPCSTR temp ;
	char m_szTempBuf[21] ;
	temp = (char *) m_szTempBuf ;

	char TempLSL[] = "LSL ", TempWAN[] = "WAN " ;
	char TempPort[] = "Port", TempPortNumber[10], TempSpeed[] = " Speed" ;
	char TempBuff[40] ;
	char strLHS[40],strRHS[40];

	char sztemp[15] ; // added by cfp on 26-3-96

	BOOL FLAG ;
	
   //Write all parameters for Ports
   //Write BOOL parameters
	char field[80] ;

	if ( !IsISDNProxy)
		WriteModemInfoToIni() ;

	for (int i = 0 ; i < tabcount ; i ++)
	{
		char Buf[12] ;
		_itoa (i, Buf, 10) ;
		
		strcpy (field,"WAN Port") ;
		strcat (field,Buf) ;
		strcpy (Buf,field) ;     

   	m_pdlgWAN[i]->UpdateData (TRUE) ;
	
	   if (m_pdlgWAN[i]->m_WANPort)
	  		temp = StrEnabled ;
	   else
	   	temp = StrDisabled ;
	
	   WritePrivateProfileString (WANSectionHeader,
		   	(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;


	// Chida - 21 Apr 1997		
		char szLHS[100];
	// Chida - 21 Apr 1997		

		// If WAN is disabled then disable PPP, SLIP and Frame Relay
		if (!m_pdlgWAN[i]->m_WANPort)
		{
			CMainDlg *pParent = (CMainDlg *)GetParent();
			pParent->EnablePPP (i, FALSE);
			pParent->EnableSLIP (i, FALSE);
      }
			
   	strcpy (field, Buf) ;
      strcat (field, " Async") ;
   	// modified by cfp on 25-3-96
		//   if(m_pdlgWAN[i]->m_WANAsync)
	   if (m_pdlgWAN[i]->m_RBtnAsync.GetCheck())
			temp = StrEnabled ;
		else
			temp = StrDisabled ;                              
		//	FLAG = m_pdlgWAN[i]->m_WANAsync;
		FLAG = m_pdlgWAN[i]->m_RBtnAsync.GetCheck() ? TRUE : FALSE ;
	
		WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		//	if(FLAG) {
		strcpy (field, Buf) ;
		strcat (field, " Auto Answer") ;
		//  if(m_pdlgWAN[i]->m_AutoAnswer.GetCheck())

	   // Modified by cfp on 26-3-96 
		//      if (m_pdlgWAN[i]->m_Ans)
		if (m_pdlgWAN[i]->m_RBtnAnswering.GetCheck())	
			temp = StrEnabled ;
		else 
			temp = StrDisabled ;
	   WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
  
		strcpy (field, Buf) ;
   	strcat (field, " Direct Connect") ;
  		wsprintf (szLHS, "PPP Port%d Remote Option%%LCP%%CallBack", i);
   		
		if (m_pdlgWAN[i]->m_chkBtnDirConnect.GetCheck())
		{
			temp = StrEnabled ;
			WritePrivateProfileString (PPPSectionHeader, szLHS, NULL, IniInWinForm);
		}	
		else
		{
			temp = StrDisabled ;
			WritePrivateProfileString (PPPSectionHeader, szLHS, "13,Auto,Negotiation Not Required,Negotiable,H1,00", IniInWinForm);
		}
	
		WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;
	
		//	}		
		// Added by cfp on 26-3-96
		strcpy (field, Buf) ;
		strcat (field, " Internal Clock") ;
		if (m_pdlgWAN[i]->m_RBtnIntClk.GetCheck()) 
			temp = StrEnabled ;
		else
			temp = StrDisabled ;
		WritePrivateProfileString (WANSectionHeader, (LPCSTR) field,
				(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Send Idle Flags") ;
		if (m_pdlgWAN[i]->m_chkboxIdleFlags.GetCheck()) 
			temp = StrEnabled ;
		else
			temp = StrDisabled ;
		WritePrivateProfileString (WANSectionHeader, (LPCSTR) field,
				(LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Synchronous Speed") ;
		// Just give some valid values to the Sync speed entries
		// even if they are not selected
		if (m_pdlgWAN[i]->m_RBtnIntClk.GetCheck())
			lstrcpy ((LPSTR) sztemp, m_pdlgWAN[i]->m_cboxSyncIntClk) ;
		else
			m_pdlgWAN[i]->m_cboxSyncIntClkWnd.GetLBText (0, (LPSTR) sztemp) ;
		WritePrivateProfileString (WANSectionHeader, (LPCSTR) field,
				(LPCSTR) sztemp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Script") ;
		if (m_pdlgWAN[i]->m_bScriptEnable)
			temp = StrEnabled ;
		else
			temp = StrDisabled ;
		WritePrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Restart Script On Comm Failure") ; 
		if (m_pdlgWAN[i]->m_bRestartScriptOnCommFailure)
			temp = StrEnabled ;
		else
			temp = StrDisabled ;
		WritePrivateProfileString ((LPCSTR) WANSectionHeader,
				(LPCSTR) field, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

		strcpy (field, Buf) ;
		strcat (field, " Dial Number") ;
//		if (m_pdlgWAN[i]->m_StrDialNumber.IsEmpty())
//			m_pdlgWAN[i]->m_StrDialNumber = "1234" ;
		WritePrivateProfileString (WANSectionHeader,
				(LPCSTR) field, m_pdlgWAN[i]->m_StrDialNumber, 
					     (LPCSTR) IniInWinForm) ;  

		strcpy (field, Buf) ;
  		strcat (field, " Speed") ;
		// Modified by cfp on 25-3-96
		// To See that no Null Speed is in Combo box
		// and later written to ini file
		char BaudBuf[15] ;
		if (m_pdlgWAN[i]->m_cboxAsyncBaud.IsEmpty())
			m_pdlgWAN[i]->m_cboxAsyncBaudWnd.GetLBText (0, (LPSTR) BaudBuf) ;
		else
			strcpy (BaudBuf, m_pdlgWAN[i]->m_cboxAsyncBaud) ;
#if 0 /* Sachin took this off */
		if ( i < 2 || (!m_pdlgWAN[0]->m_Backup && !m_pdlgWAN[1]->m_Backup))
#endif
			WritePrivateProfileString(WANSectionHeader, (LPCSTR) field,
				(LPCSTR) BaudBuf, (LPCSTR) IniInWinForm) ;

	   // Write CString Parameters
		if (FLAG)
		{
			// 2/11/95 Vidy
			// Update the LSL speed also for SNMP to report it properly
			strcpy(field, Buf);
			field[0] = 'L';
			field[1] = 'S';
			field[2] = 'L'; //change WAN to LSL
			field[8] += 1;		//LSL port number of WAN starts at 1 :  29-12-95
		   strcat (field," Speed") ;
			// Modified by cfp on 25-3-96
			WritePrivateProfileString(LSLSectionHeader, (LPCSTR) field,
				  (LPCSTR) m_pdlgWAN[i]->m_cboxAsyncBaud, (LPCSTR) IniInWinForm) ;
   	}
		else
		{
			_itoa(i, TempPortNumber, 10);
			TempPortNumber[0]++ ;
			strcpy (TempBuff, TempLSL) ;
			strcat (TempBuff, TempPort) ;
			strcat (TempBuff, TempPortNumber) ;
			strcat (TempBuff, TempSpeed) ;

			// Modified by cfp on 26-3-96
			if (m_pdlgWAN[i]->m_RBtnIntClk.GetCheck())
				lstrcpy((LPSTR) sztemp, m_pdlgWAN[i]->m_cboxSyncIntClk) ;
			else   // Instead of 0 get some valid value
		   	m_pdlgWAN[i]->m_cboxSyncIntClkWnd.GetLBText(0, (LPSTR) sztemp) ;
			WritePrivateProfileString(LSLSectionHeader,
				(LPCSTR) TempBuff, (LPCSTR) sztemp, (LPCSTR) IniInWinForm);

		}
//^^^^Sudha 9 Dec 1997
		
		sprintf ( TempBuff,"%s%d",TempPort,i);
		sprintf ( strLHS,"ISDN WAN %s",TempBuff);
		
		if ( m_pdlgWAN[i]->m_RBtnIsdn.GetCheck())
		{
			WritePrivateProfileString ( WANSectionHeader,strLHS,StrEnabled,IniInWinForm );
			sprintf ( strRHS,"%s",m_pdlgWAN[i]->m_szSectionName );
			WriteInfoInIni ( TempBuff,strRHS );
		}
		else
		{
			WritePrivateProfileString ( WANSectionHeader,strLHS,StrDisabled,IniInWinForm );
			WritePrivateProfileString ( MapHeader,TempBuff,StrNull,ini_INIFilename );

		}
//^^^^Sudha 9 Dec 1997
   }

	return TRUE ;
}					

//Sudha 9 Dec 1997

void  CWANTab::WriteToRouconIni(LPCSTR Section,LPCSTR strLHS,LPCSTR Default,ini_tpValuePair Table,char* command)
{
   char strRHS[40],tempstr[40];
	CString String;
	int value,len = 0;

	GetPrivateProfileString(Section,strLHS,Default,
		strRHS,sizeof(strRHS),ini_INIFilename);
	if (Table != cfg_null)
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			for(int i=0; Table[i].StringID;i++)
			{
				String.LoadString(Table[i].StringID );
				if (!strcmpi(String,strRHS))
				{	
					value = Table[i].nNum;
					break;
				}
			}
			sprintf(strRHS,"%s%d",command,value);
		}
	}
	else
	{
		if (!strcmp(strRHS,StrNull))
			sprintf(strRHS,"%s",command);
		else
		{
			sprintf(tempstr,"%s%s",command,strRHS);
			strcpy(strRHS,tempstr);
		}
	}

	len = strlen ( strRHS ) + strlen ( InitstrRHS ) ;
	if ( len <= ( MAX_INIT_STRING_LENGTH - 2 ))
		strcat ( InitstrRHS , strRHS );
	
	if ( len >= ( MAX_INIT_STRING_LENGTH - 2 ))
	{
		WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
		strcpy ( InitstrRHS ,"AT");
		InitstrLHS[32]++;
		if ( len > ( MAX_INIT_STRING_LENGTH - 2 ) )
			strcat ( InitstrRHS , strRHS );
	}
	return ;
}

//Sudha 9 Dec 1997

void CWANTab::WriteInfoInIni(char Buff[40],char RHS[40] )
{
	char strLHS[40],strRHS[40] ;
	CIsdnTa Isdn;
	BOOL US = FALSE;
	
	//Configuration Name
	sprintf ( strLHS,"ISDN WAN %s ConfigName",Buff );
	WritePrivateProfileString(WANSectionHeader,strLHS,RHS,IniInWinForm);
	
	strcpy ( InitstrRHS,"AT");
	sprintf(InitstrLHS,"ISDN %s Initialization String1",Buff);

	//IDD_NETWORK_SWITCH_TYPE member
	WriteToRouconIni(RHS,"NetworkSwitchType","NI - 1",cfg_NetworkSwitchTypes,"!C0=");

	GetPrivateProfileString ( RHS,"NetworkSwitchType","NET3",strRHS,
		sizeof ( strRHS ),ini_INIFilename );
	US = Isdn.SwitchType ( strRHS );

	//IDD_NETWORK_CFG_I member
	WriteToRouconIni(RHS,"DataTEI","Auto TEI",cfg_TEI,"!D3=");
	WriteToRouconIni(RHS,"VoiceTEI","Auto TEI",cfg_TEI,"*!D3=");

	//IDD_NETWORK_CFG_II_US member
	WriteToRouconIni(RHS,"DataSPID","",cfg_null,"!C6=");
	WriteToRouconIni(RHS,"VoiceSPID","",cfg_null,"*!C6=");

	if ( US == TRUE )
	{
		WriteToRouconIni(RHS,"DataDirectoryNumber","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceDirectoryNumber","",cfg_null,"*!N1=");

	}
	
	//IDD_NETWORK_CFG_II_EUROPE
	else
	{	
		WriteToRouconIni(RHS,"DataMSN","",cfg_null,"!N1=");
		WriteToRouconIni(RHS,"VoiceMSN","",cfg_null,"*!N1=");

	}
	//IDD_CALL_CTRL_CFG
	
	WriteToRouconIni(RHS,"AutoAnswer","Yes",cfg_NoYes,"S0=");
	WriteToRouconIni(RHS,"PersistentDTRDialing","No",cfg_NoYes,"$D");
	WriteToRouconIni(RHS,"DialingMethod","Enbloc",cfg_DialingMethods,"%A97=");
	WriteToRouconIni(RHS,"RingsToAnswer","1",cfg_null,"S0=");
	WriteToRouconIni(RHS,"CallLineId","No",cfg_NoYes,"S50=");

	//IDD_DATA_PROTOCOL
	WriteToRouconIni(RHS,"DataProtocol","V.120",cfg_DataProtocols,"!Z=");
	WriteToRouconIni(RHS,"DataCompression","None",cfg_DataCompression,"&K");
	WriteToRouconIni(RHS,"AutoDetection","No",cfg_NoYes,"S52=");

	if ( strlen ( InitstrRHS ) > 2 )
	{
		WritePrivateProfileString ( WANSectionHeader,InitstrLHS,InitstrRHS,IniInWinForm );
		InitstrLHS[32]++;
	}

	if ( IsISDNProxy )
	{	
		WritePrivateProfileString ( WANSectionHeader,InitstrLHS,"AT&W",IniInWinForm );
		InitstrLHS[32]++;
 		WritePrivateProfileString ( WANSectionHeader,(LPCSTR)"WAN Port0 Dial Prefix",(LPCSTR)"ATDT",
			IniInWinForm);
	}

	char max[2];
	int maxnum;

	sprintf ( max,"%c",InitstrLHS[32]);
	sscanf ( max,"%d",&maxnum);
 
	for ( int i = maxnum; i < 20;i++)
	{
		sprintf ( strLHS,"ISDN %s Initialization String%d",Buff,i);
		WritePrivateProfileString ( WANSectionHeader,strLHS,NULL,IniInWinForm );
	}
	
	return;
}

void CWANTab::OnOK()
{
//	char ErMsg[100] ;

//	UpdateData (TRUE) ;

	CIsdnTa Isdn;
	char strLHS[40];

   for (int i = 0 ; i < tabcount ; i ++)
   {
		if (!m_pdlgWAN[i]->ValidEditFields())
		{
	   	switchTab(i);
   	   enableView(i,TRUE);
         return;
      }

		if (m_pdlgWAN[i]->m_RBtnIsdn.GetCheck())
		{
			if (m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() == CB_ERR )
				m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel(0);
			/* m_pdlgWAN[i]->m_ComBoxModemTypes.GetWindowText(
					m_pdlgWAN[i]->m_szPPINISection );*/
                        m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText(
                           m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel(),
			   m_pdlgWAN[i]->m_szSectionName);
                                        
			if ( Isdn.IsThisADefaultCfg(m_pdlgWAN[i]->m_szSectionName ) )
			{
				UpdateData ( TRUE );
				::MessageBox ( GetSafeHwnd(),"Make sure to enter SPID/ISDN & Dir numbers\
				\nfor WAN port by clicking edit control in advanced control",
				IsdnMsgHeader,MB_OK );
			}
			
			sprintf ( strLHS,"Port%d",i );
			WritePrivateProfileString ( MapHeader,strLHS,m_pdlgWAN[i]->m_szSectionName,
				ini_INIFilename );
		}
   }
	if (!AcceptConfig()) 
		return ;
	CTabDialog::OnOK() ;
	return ;
}

void CWANTab::OnCancel()
{
	CTabDialog::OnCancel();
}

/*----------------------------------------------------------------------------
	Module 	: WriteModemInfoToIni
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Writes the Modems Info into the Roucon.Ini
				  file for each of the WAN Links under the WAN Section
	Globals
	Affected : None
----------------------------------------------------------------------------*/

void CWANTab::WriteModemInfoToIni()
{
	char szFilePath[200] ;
	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;
	fModemsPtr = fopen (szFilePath, "rb") ;

	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(),
			"Could not locate MODEMS.CNF file",
					"File Open Error", MB_OK | MB_ICONSTOP) ;
		return ;
	}

	WORD nModems ;
	MODEMS_HDR ModemsHdr ;
	fread (&ModemsHdr, sizeof (ModemsHdr), 1, fModemsPtr) ;
	nModems = ModemsHdr.NumEntries ;

	// To prevent user from Modifying the Modems.Cnf File
	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Invalid MODEMS.CNF file",
																"Warning", MB_OK) ;
		return ;
	}

	char szModemNameInCombo[80] ;
	MODEM_SETUP ModemSetup ;
	WORD j = 0 ;

	for (int i = 0 ; i < tabcount ; i ++)
	{
		// Get the Select Index of the Modem from the Combo Box
		int nCurSel = m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
		
		// If none selected write nulls to Ini file
		if (nCurSel == CB_ERR)
		{
			memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;
		}
		else
		{
			m_pdlgWAN[i]->m_ComBoxModemTypes.GetLBText (nCurSel, 
													(LPSTR) szModemNameInCombo) ;
			
			// Offset from the Modems Header to First Modem Info
			fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

			for (j = 0 ; j < nModems ; j ++)
			{
				fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) ;
				if (!strcmpi (szModemNameInCombo, ModemSetup.ModemType))
					break ;
			}
		}

		if (j == nModems)
			memset ((MODEM_SETUP *) &ModemSetup, 0x00, sizeof (ModemSetup)) ;

		WriteModemStringsToIni (i, &ModemSetup) ;
	}

	fclose (fModemsPtr) ;
	return ;
}


void CWANPortDlg::OnControl()
{
	UpdateData (TRUE) ;

	// Added by cfp on 25-3-96
	BOOL fAsync = m_RBtnAsync.GetCheck() ;	
	BOOL fIntClk = m_RBtnIntClk.GetCheck() ;
	
	//Sudha 9 Dec 1997
	BOOL fIsdn = m_RBtnIsdn.GetCheck();
	BOOL fModem = m_RBtnModem.GetCheck();

	if ( !IsISDNProxy )
	{
		if ( !fIsdn && !fModem )
			OnModem () ;
	}
	
	// Added by cfp on 27-3-96
	BOOL fAnswering = m_RBtnAnswering.GetCheck() ;

	m_StatModemTypes.EnableWindow (fAsync && !m_bDirConnect ) ;
	m_ComBoxModemTypes.EnableWindow (fAsync && !m_bDirConnect) ;

	m_StatDialNumber.EnableWindow (fAsync && !m_bDirConnect && !fAnswering) ;

// Chida - 21 Apr 1997	
	m_EditDialNumberWnd.EnableWindow (fAsync && !m_bDirConnect) ;

	m_cboxAsyncBaudWnd.EnableWindow (fAsync) ;
	m_RBtnIntClk.EnableWindow (!fAsync) ;
	m_cboxSyncIntClkWnd.EnableWindow (!fAsync && fIntClk) ;
	m_RBtnExtClk.EnableWindow (!fAsync) ;
	m_BaudHeader.EnableWindow (fAsync) ;
	m_ClkSpeedHdr.EnableWindow (!fAsync && fIntClk) ;
	m_chkboxIdleFlags.EnableWindow (!fAsync) ;
	
	m_RBtnModem.EnableWindow ( fAsync && !m_bDirConnect && !IsISDNProxy);
	m_RBtnIsdn.EnableWindow ( fAsync && !m_bDirConnect );

	/* 9/7/97 chetan */
	m_BtnScript.EnableWindow (fAsync && RouterStatus && !m_bDirConnect) ;
	m_RestartScriptWnd.EnableWindow (fAsync && !m_bDirConnect);
	m_ScriptEnableWnd.EnableWindow (fAsync && !m_bDirConnect);
	/* 9/7/97 chetan */
	
}


BOOL CWANPortDlg::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	// TODO: Add extra initialization here
	
	if ( IsISDNProxy )
	{
		m_RBtnModem.ShowWindow(SW_HIDE);
		m_RBtnIsdn.ShowWindow(SW_HIDE);
		m_chkBtnDirConnect.ShowWindow ( SW_HIDE );
		m_RBtnAnswering.ShowWindow ( SW_HIDE );
		m_RBtnSync.ShowWindow ( SW_HIDE );
		m_RBtnExtClk.ShowWindow ( SW_HIDE );
		m_RBtnIntClk.ShowWindow ( SW_HIDE );
		m_chkboxIdleFlags.ShowWindow ( SW_HIDE );
		m_ClkSpeedHdr.ShowWindow ( SW_HIDE );
		m_cboxSyncIntClkWnd.ShowWindow ( SW_HIDE );

		m_RBtnModem.EnableWindow ( FALSE );
		m_RBtnIsdn.EnableWindow ( FALSE );
		m_chkBtnDirConnect.EnableWindow ( FALSE );
		m_RBtnAnswering.EnableWindow ( FALSE );
		m_RBtnDialling.EnableWindow ( FALSE );
		m_RBtnSync.EnableWindow ( FALSE );
		m_RBtnAsync.EnableWindow ( FALSE );
		m_RBtnExtClk.EnableWindow ( FALSE );
		m_RBtnIntClk.EnableWindow ( FALSE );
		m_chkboxIdleFlags.EnableWindow ( FALSE );
		m_ClkSpeedHdr.EnableWindow ( FALSE );
		m_cboxSyncIntClkWnd.EnableWindow ( FALSE );
	}
	return TRUE;  // return TRUE  unless you set the focus to a control
}

int	CWANPortDlg::RouMsgBox(int StrId, LPCSTR Header, int Opts)
{
	CString	Message;
	int	Ret_val;
	char NewHeader[50] ;

	Message.LoadString(StrId);
	ModifyHeader (Header, (LPCSTR)&NewHeader[0]) ;
	Ret_val = MessageBox(Message, (LPCSTR)&NewHeader[0], Opts);
	return Ret_val;
}

// Added by cfp
void CWANPortDlg::OnRadioAsync()
{
	// TODO: Add your control notification handler code here
	m_RBtnAsync.SetCheck (1) ;
	m_RBtnSync.SetCheck (0) ;		
	OnControl() ;

	BOOL fAnswering = m_RBtnAnswering.GetCheck() ;
}

// Added by cfp
void CWANPortDlg::OnRadioSync()
{
	// TODO: Add your control notification handler code here
	m_RBtnAsync.SetCheck (0) ;
	m_RBtnSync.SetCheck (1) ;		
	OnControl() ;
}

// Added by cfp
void CWANPortDlg::OnIntClock()
{
	// TODO: Add your control notification handler code here
	if (m_RBtnSync.GetCheck())
	{
		m_RBtnAsync.SetCheck (0) ;
	   m_RBtnIntClk.SetCheck (1) ;      
		m_RBtnExtClk.SetCheck (0) ;		
		OnControl() ;
	   return ;
	}
	m_RBtnIntClk.SetCheck (0) ;      
	OnControl() ;
	return ;
}

// Added by cfp
void CWANPortDlg::OnExtClock()
{
	// TODO: Add your control notification handler code here
	if (m_RBtnSync.GetCheck())
	{
		m_RBtnAsync.SetCheck (0) ;
	   m_RBtnIntClk.SetCheck (0) ;      
		m_RBtnExtClk.SetCheck (1) ;		
		OnControl() ;
		return ;
	}
	m_RBtnExtClk.SetCheck (0) ;		
	OnControl() ;
	return ;
}



// Added by cfp
void CWANPortDlg::OnAnswering()
{
	// TODO: Add your control notification handler code here
	m_RBtnAnswering.SetCheck (1) ;
	m_RBtnDialling.SetCheck (0) ;
	OnControl() ;
}

// Added by cfp
void CWANPortDlg::OnDialling()
{
	// TODO: Add your control notification handler code here
	m_RBtnAnswering.SetCheck (0) ;
	m_RBtnDialling.SetCheck (1) ;
	OnControl() ; 

	// If both PPP and SLIP are enabled, disable SLIP
	CMainDlg *maindlg = ((CMainDlg *)(GetParent()->GetParent()));
	int PortNo = GetMyID();
	if (PortNo == -1) return;
	if (maindlg->IsPPPEnabled(PortNo) && maindlg->IsSLIPEnabled(PortNo))
		maindlg->EnableSLIP (PortNo, FALSE);
	return ;
}

// Added by cfp
void CWANPortDlg::OnAdvanced()
{
	// TODO: Add your control notification handler code here
	CWANDlg cWANDlg ;

	CWANTab *pParent = (CWANTab *) GetParent() ;
	for (UINT i = 0 ; i < pParent->m_nPort ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
		{
		 	sprintf ( WanPortNum,"Port%d",i );
			break ;
		}
	}

	cWANDlg.m_nSelectedModem =
		pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() ;
	
	cWANDlg.IsdnEnabled = 
		pParent->m_pdlgWAN[i]->m_RBtnIsdn.GetCheck() ;

	if ( pParent->m_pdlgWAN[i]->m_RBtnIsdn.GetCheck() )
		cWANDlg.m_nSelectedIsdn =
			pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel();
	else
		cWANDlg.m_nSelectedIsdn = CB_ERR;
		

	cWANDlg.DoModal() ;
	return ;
}


/*----------------------------------------------------------------------------
	Module 	: OnBtnAddModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: On Clicking Add Modems Button processing takes place here
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnAddModem()
{
	// TODO: Add your control notification handler code here

	CModemTypes cModem (this) ;
	cModem.m_bActionAdd = TRUE ;

	int nRetVal = cModem.DoModal() ;
	if (nRetVal == IDOK)
		m_bMdmConfigChanged = TRUE ;
	EnableButtons() ;
}

/*----------------------------------------------------------------------------
	Module 	: OnBtnDelModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Confirm and Delete selected Modem Info 
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnDeleteModem()
{
	// TODO: Add your control notification handler code here

	int nSelected  = m_combBoxModemTypes.GetCurSel() ;

	// If none selected return
	if (nSelected == CB_ERR)
		return ;

	int nRetVal = ::MessageBox (GetSafeHwnd(),
			"Do you want to delete this modem ?",
				"Modem Information", MB_YESNO | MB_ICONQUESTION) ;
	if (nRetVal == IDNO)
		return ;

	MODEM_SETUP *pModemSetup = (MODEM_SETUP *) 
							m_combBoxModemTypes.GetItemDataPtr (nSelected) ;
	delete pModemSetup ;

	m_combBoxModemTypes.DeleteString (nSelected) ;

	m_bMdmConfigChanged = TRUE ;
	EnableButtons() ;
	UpdateData (FALSE) ;

	return ;
}

/*----------------------------------------------------------------------------
	Module 	: OnBtnEditModem
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: Let user Edit Modem Info 
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::OnBtnEditModem()
{
	// TODO: Add your control notification handler code here
	int nSelected  = m_combBoxModemTypes.GetCurSel() ;

	// If none selected return
	if (nSelected == CB_ERR)
		return ;

	CModemTypes cModem (this) ;
	cModem.m_bActionAdd = FALSE ;
	int nRetVal = cModem.DoModal() ;
	if (nRetVal == IDOK)
		m_bMdmConfigChanged = TRUE ;
		
	EnableButtons() ;

	return ;
}

/*----------------------------------------------------------------------------
	Module 	: EnableButtons
	Author 	: CFP
	Input  	: None
	Output 	: None
	Synopsis	: If No modems in List disable Edit and Delete Buttons
	Globals
	Affected : None
----------------------------------------------------------------------------*/
void CWANDlg::EnableButtons() 
{
	BOOL fEnable = FALSE ;

	int nCount = m_combBoxModemTypes.GetCount() ;
	if (nCount)
		fEnable = TRUE ;

	m_BtnEdit.EnableWindow (fEnable) ;
	m_BtnDelete.EnableWindow (fEnable) ;
	
	return ;
}

/*----------------------------------------------------------------------------
	Module 	: GetModemTypes
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any read error
	Synopsis	: List all Modems from the Cnf file
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWANDlg::GetModemTypes()
{
	char szFilePath[200] ; // For MODEMS.CNF File

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;

	// Refresh the Combo Box
	m_combBoxModemTypes.ResetContent() ;

	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
					"File Open Error", MB_OK) ;
		EnableButtons() ;
		return TRUE ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetSafeHwnd(), "Invalid MODEMS.CNF file",
																"Warning", MB_OK) ;
		EnableButtons() ;
		return TRUE ;
	} 

	// Jump directly to Modems Info bypassing the header
	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;

	int nIndex ;

	while (TRUE)
	{
		MODEM_SETUP *MdmSetupPtr = (MODEM_SETUP *) new (MODEM_SETUP) ;
		if (MdmSetupPtr == NULL)
		{
			::MessageBox (GetSafeHwnd(), "Insufficient Memory",
				"Modem Setup", MB_OK | MB_ICONSTOP) ;
			return FALSE ;
		}
		if (fread (MdmSetupPtr, sizeof (MODEM_SETUP), 1, fModemsPtr) < 1)
		{
			delete MdmSetupPtr ;
			break ;
		}
		if (strcmp (MdmSetupPtr->ModemType, "Direct Connection") != 0)
		{
			nIndex = m_combBoxModemTypes.AddString (MdmSetupPtr->ModemType) ;
			m_combBoxModemTypes.SetItemDataPtr (nIndex, 
										(MODEM_SETUP *) MdmSetupPtr) ;  
		}
	}
	EnableButtons() ;

	fclose (fModemsPtr) ;
	return TRUE ;
}

void CWANDlg::GetIsdnTypes ()
{
	char strLHS[40],strRHS[40],buffer[512];
	char *token;
	char *seps = "\0";
	int length = 0;
	int total;
	CString szDefaultConfig;
	
	m_INISectionControl.ResetContent();
	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
		if ( m_INISectionControl.FindStringExact ( -1, strRHS ) == CB_ERR )
		{
			// Insert the string in the list box
			m_INISectionControl.AddString( strRHS );
		}
		strLHS[6]++;
   } 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	if ( total != 0 )
	{
		token = strtok ( buffer, seps );
		while ( token != NULL)
		{
			if ( m_INISectionControl.FindStringExact ( -1, token ) == CB_ERR )
			{
				// Insert the string in the list box
				m_INISectionControl.AddString( token );
			}	
			length = length + strlen ( token ) + 1;	// +1 for the NULL character
	      token = strtok( &buffer[length], seps );
		}
	}
	
	if ( m_nSelectedIsdn != CB_ERR )
		m_INISectionControl.SetCurSel ( m_nSelectedIsdn );

	//m_INISectionControl.GetWindowText ( m_szPPINISection );
        m_INISectionControl.GetLBText ( m_INISectionControl.GetCurSel(),m_szPPINISection );
}

void CWANPortDlg::GetIsdnTypes (int j)
{
	char strLHS[40],strRHS[40],buffer[512];
	char token[40];
	// char *seps = "\0";
	char seps = '\0';
	int length = 0;
	int total;
	CString szDefaultConfig;
	int k;
	
	CWANTab *parent = (CWANTab *)GetParent();

	for (k = 0; k < parent->tabcount; k++ )
	{
		if ( j == k )
			break;
	}
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.ResetContent();

	strcpy(strLHS,DefaultIniString);
	while(GetPrivateProfileString(DefaultConfigHeader,(LPCSTR)strLHS,
		 StrNull, (LPSTR) strRHS,sizeof (strRHS),
			(LPCSTR) ini_INIFilename))
  	{
	 	if ( parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, strRHS ) == CB_ERR )
	 	{
	 		// Insert the string in the list box
	 		parent->m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( strRHS );
	 	}
	 	strLHS[6]++;
   }
 
	total = GetPrivateProfileString ( (LPCSTR) "User Config", NULL, NULL,
		buffer, sizeof(buffer), ini_INIFilename );

	//if ( total != 0 )
	while ( total > 0 )
	{
		// token = strtok ( buffer, seps );
		//token = strchr ( buffer, seps );
		strcpy ( token,&buffer[length]);
		//while ( token != NULL)
		//{
	        if ( parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact ( -1, token ) == CB_ERR )
	        {
	       	   // Insert the string in the list box
		   parent->m_pdlgWAN[k]->m_ComBoxModemTypes.AddString( token );
		}	

 	        length = length + strlen ( token ) + 1;	// +1 for the NULL character
		total = total - ( strlen ( token ) + 1 ) ;
	      //token = strtok( &buffer[length], seps );
	      //token = strchr( &buffer[length], seps );
	      //strcpy(token,&buffer[length]);
		//}
	}
	
	sprintf ( strLHS,"ISDN WAN Port%d ConfigName",j);
	GetPrivateProfileString ( WANSectionHeader, strLHS,
		StrNull,strRHS,sizeof(strRHS),IniInWinForm );
	if ( strcmp ( strRHS,StrNull ) == 0 )
		strcpy ( strRHS,"EuroIsdn");
	int nsel;
	nsel = parent->m_pdlgWAN[k]->m_ComBoxModemTypes	.FindStringExact(-1,strRHS );
	/*	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.SetCurSel (
                parent->m_pdlgWAN[k]->m_ComBoxModemTypes.FindStringExact(
                -1,strRHS)); */
	if (nsel == CB_ERR )
	   nsel = 0;
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.SetCurSel ( nsel );
	parent->m_pdlgWAN[k]->m_ComBoxModemTypes.GetLBText (nsel,parent->m_pdlgWAN[k]->m_szSectionName );
	//parent->m_pdlgWAN[k]->m_ComBoxModemTypes.GetWindowText (parent->m_pdlgWAN[k]->m_szPPINISection );

}

/*----------------------------------------------------------------------------
	Module 	: GetModemTypes
	Author 	: CFP
	Input  	: None
	Output 	: Boolean indicating any read error
	Synopsis	: List all Modems from the Cnf file
	Globals
	Affected : None
----------------------------------------------------------------------------*/
BOOL CWANTab::GetModemTypes()
{
	char szFilePath[200] ; // For MODEMS.CNF File

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;
	
	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetParent()->GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
				"Warning - File not found", MB_OK) ;
		return FALSE ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetParent()->GetSafeHwnd(),
			"Invalid MODEMS.CNF file", "Warning", MB_OK) ;
		return FALSE ;
	} 

	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;
	MODEM_SETUP ModemSetup ;
	int i ;

	for ( i = 0 ; i < tabcount ; i++)
		m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent();

	while (TRUE)
	{
		if (fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) < 1)
			break ;
		if (strcmp (ModemSetup.ModemType, "Direct Connection") == 0)
			continue ;
		for (i = 0 ; i < tabcount ; i ++)
			m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (ModemSetup.ModemType) ;
	}

	fclose (fModemsPtr) ;
	return TRUE ;
}

void CWANPortDlg::GetModemTypes(int k)
{
	char szFilePath[200] ; // For MODEMS.CNF File
	char strLHS[40],strRHS[40];
	char szBlankBackSlash[100] ;

	CWANTab *parent = (CWANTab *) GetParent();

	strcpy (szFilePath, LoadPath) ;
	strcat (szFilePath, MODEMS_FILE) ;

	FILE *fModemsPtr ;
	
	fModemsPtr = fopen (szFilePath, "rb") ;
	if (fModemsPtr == NULL)
	{
		::MessageBox (GetParent()->GetSafeHwnd(), 
			"Could not locate MODEMS.CNF file",
				"Warning - File not found", MB_OK) ;
		return ;
	}

	if (!VerifyCheckSum (fModemsPtr))
	{
		::MessageBox (GetParent()->GetSafeHwnd(),
			"Invalid MODEMS.CNF file", "Warning", MB_OK) ;
		return ;
	} 

	fseek (fModemsPtr, sizeof (MODEMS_HDR), SEEK_SET) ;
	MODEM_SETUP ModemSetup ;
	int i ;

	for ( i = 0 ; i < parent->tabcount ; i++)
	{
		if ( i == k )
			break;
	}
	
	parent->m_pdlgWAN[i]->m_ComBoxModemTypes.ResetContent();

	while (TRUE)
	{
		if (fread (&ModemSetup, sizeof (ModemSetup), 1, fModemsPtr) < 1)
			break ;
		if (strcmp (ModemSetup.ModemType, "Direct Connection") == 0)
			continue ;
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.AddString (ModemSetup.ModemType) ;
	}

	fclose (fModemsPtr) ;
	sprintf(strLHS, "WAN Port%d Modem Type",i) ;
   GetPrivateProfileString (WANSectionHeader,  
	   strLHS,StrNull,strRHS, sizeof (strRHS),  
  	     (LPCSTR) IniInWinForm) ;  
   int nToSel ;
	if (strRHS[0])
  	{
		ConvertBackSlashesToBlanks (szBlankBackSlash, strRHS) ;
		nToSel = 
			parent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1,
			szBlankBackSlash) ;
		if (nToSel == CB_ERR)
			nToSel = 0 ;
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel (nToSel) ;
	}
	else
		parent->m_pdlgWAN[i]->m_ComBoxModemTypes.SetCurSel(
			parent->m_pdlgWAN[i]->m_ComBoxModemTypes.FindStringExact (-1,
 			"Multi-Tech 56K Socket Modem"));
	return ;
}


void CWANDlg::OnSelchangeComboModemTypes()
{
	// TODO: Add your control notification handler code here
	int nIndex = m_combBoxModemTypes.GetCurSel() ;

	CString DirectConnectStr ;
	m_combBoxModemTypes.GetLBText (nIndex, DirectConnectStr) ;
	if (DirectConnectStr == MODEM_TYPE_DIRECT_CONNECT)
	{
		m_BtnEdit.EnableWindow (FALSE) ;
		return ;
	}
	m_BtnEdit.EnableWindow (TRUE) ;
	return ;
}


void CWANDlg::OnCancel()
{
	// TODO: Add extra cleanup here

	char strLHS[40],strRHS[40];

	if (!IsRF200 && !IsLanTalker && !IsISDNProxy)
	{
		if (m_bMdmConfigChanged)
		{
			int nRetVal = MessageBox ("Do you want to save changes?",
						"Modems - Information", MB_YESNO | MB_ICONQUESTION) ;
			if (nRetVal == IDNO)
			{
				CDialog::OnCancel();
				return ;
			}
			WriteToCnfFile() ;

			CWANTab *pParent = (CWANTab *) GetParent() ;
			pParent->WriteModemInfoToIni() ;
		}
		PutModemsInParentsList();
	}
	
	if ( IsISDNProxy )
		PutIsdnConfigInParentsList(0);

	CDialog::OnCancel();
	return ;

}


BOOL CWANPortDlg::ValidEditFields()
{
	CWANTab *pParent = (CWANTab *) GetParent() ;
	for (int i = 0 ; i < pParent->tabcount ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}

	char szLHSPPP[80] ;
	char szRHSPPP[80] ;
	BOOL bAsync ;
	BOOL bAnswering ;
	char strLHS[40];

	bAsync = m_RBtnAsync.GetCheck() ? TRUE : FALSE ;
	bAnswering = m_RBtnAnswering.GetCheck() ? TRUE : FALSE ;

	if (i < pParent->tabcount)
	{
		sprintf (szLHSPPP, "%s%d%s", "PPP Port", i, 
												" Remote Port Client Only") ;
		GetPrivateProfileString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) szLHSPPP, (LPCSTR) StrNull, (LPSTR) szRHSPPP,
					sizeof (szRHSPPP), 	(LPCSTR) IniInWinForm) ;
		if (szRHSPPP[0])
		{
			if (!strcmpi (szRHSPPP, StrEnabled))
			{
				if (!bAsync)
				{
					::MessageBox (pParent->GetSafeHwnd(),
						"If remote end is 'Client only type'\n \
port should be Asynchronous", "WAN - Info", MB_OK | MB_ICONINFORMATION) ;
					pParent->m_pdlgWAN[i]->m_RBtnAsync.SetFocus() ;
					return FALSE ;
				}
				if (!bAnswering)
				{
					::MessageBox (pParent->GetSafeHwnd(),
						"If remote end is 'Client only type'\n \
port should be Answering", "WAN - Info", MB_OK | MB_ICONINFORMATION) ;
					pParent->m_pdlgWAN[i]->m_RBtnAnswering.SetFocus() ;
					return FALSE ;
				}
			}
		}
		if ( pParent->m_pdlgWAN[i]->m_RBtnIsdn.GetCheck() )
		{
			if ( pParent->m_pdlgWAN[i]->m_ComBoxModemTypes.GetCurSel() == CB_ERR )
			{
				sprintf(strLHS,"Select a configuration file for Wan Port %d",i);
				::MessageBox ( GetSafeHwnd(), (LPCSTR) strLHS,IsdnMsgHeader,MB_OK );
				return FALSE;
			}
		}
	}
	return TRUE ;
}

void CWANPortDlg::OnCheckDirConnect()
{
	// TODO: Add your control notification handler code here

	OnControl() ;
}


void CWANPortDlg::OnBtnScript()
{
	// TODO: Add your control notification handler code here

	CWANTab *pParent = (CWANTab *) GetParent() ;

	for (UINT i = 0 ; i < pParent->m_nPort ; i ++)
	{
		if (pParent->m_pdlgWAN[i] == this)
			break ;
	}
	CScriptDlg CScript ;
	CScript.m_nPortNum = (int)i ;
	CScript.DoModal() ;
}


LRESULT CWANPortDlg::OnSwitchToIden (WPARAM wParam, LPARAM lParam)
{
	UpdateData (TRUE) ;
	return 0L ;
}

int CWANPortDlg::GetMyID (void)
{
	CWANTab *parent = (CWANTab *)GetParent();
	int tabcount = parent->tabcount;
	
	for (int index = 0 ; index < tabcount ; index ++)
	{
			if (parent->m_pdlgWAN[index] == this)
			{
				return (index);
			}
	}
	return -1;
}


//Sudha 9 Dec 1997
void CWANPortDlg::OnIsdn()
{
	// TODO: Add your control notification handler code here
	int Id;

	Id = GetMyID();
	m_RBtnModem.SetCheck(0);
	m_RBtnIsdn.SetCheck(1);
	OnControl();
	
	GetIsdnTypes(Id);	
}

//Sudha 9 Dec 1997
void CWANPortDlg::OnModem()
{
	// TODO: Add your control notification handler code here
	int Id;

	Id = GetMyID();
	m_RBtnIsdn.SetCheck (0) ;
	m_RBtnModem.SetCheck (1) ;
	OnControl();
	
	GetModemTypes(Id);
		
}

void CWANDlg::OnIsdnEdit()
{
	// TODO: Add your control notification handler code here
	
	m_cfgtype = kEdit;
	CIsdnTa Isdn (this);
	Isdn.DoModal();

}

void CWANDlg::OnIsdnDelete()
{
	// TODO: Add your control notification handler code here

	int			nCurSel, nMBResponse;
	CString		szConfig, szMsg, config ;
	char strRHS[40] ,strLHS[40];
	
	CIsdnTa Isdn;

	m_cfgtype = kDelete;

	if ( m_INISectionControl.GetCurSel() == CB_ERR)
	{
		::MessageBox(GetSafeHwnd(),"Select a Configuration file to delete",IsdnMsgHeader,MB_OK);
		m_INISectionControl.SetFocus();
		return;
	}
	else
	{
		nCurSel = m_INISectionControl.GetCurSel ();
   	m_INISectionControl.GetLBText ( nCurSel, m_szPPINISection );

	   if ( nCurSel != CB_ERR )
	   { 
			m_INISectionControl.GetLBText ( nCurSel, szConfig );
			if ( Isdn.IsThisADefaultCfg ( szConfig ) )
			{	
				szMsg.LoadString(IDS_DELETE_DEFAULT_CONFIG);
				nMBResponse = AfxMessageBox ( szMsg );
				return;
			}
			sprintf(strLHS,"Port0");
			while ( GetPrivateProfileString ( MapHeader,strLHS,
				StrNull,strRHS,sizeof(strRHS),ini_INIFilename ))
		  	{
				if ( szConfig.CompareNoCase ( strRHS ) == 0 )
				{
 					::MessageBox ( GetSafeHwnd(),"This is the existing configuration.\
Before deleting this make sure to change the configuration.",IsdnMsgHeader,MB_OK);
					return;
				}
			 	strLHS[4]++;
			}
		   szMsg.LoadString(IDS_DELETE_CONFIG);
		   nMBResponse = AfxMessageBox ( szMsg, MB_YESNO, 0 );
			if ( nMBResponse == IDYES )
			{
				::WritePrivateProfileString ( szConfig, NULL, NULL, ini_INIFilename );
				::WritePrivateProfileString  (	"User Config", szConfig, NULL, ini_INIFilename );
				m_INISectionControl.DeleteString ( nCurSel );
			
				if ( nCurSel != m_INISectionControl.GetCount () )
					m_INISectionControl.SetCurSel ( (nCurSel) );
				else
					m_INISectionControl.SetCurSel ( nCurSel-1 );
			}
		}
	}		
}

void CWANDlg::OnIsdnAdd()
{
	// TODO: Add your control notification handler code here

	m_cfgtype = kAdd;
	
	CIsdnTa Isdn (this);
	Isdn.DoModal();

}

void CWANDlg::OnCfgs()
{
	// TODO: Add your control notification handler code here
	
	if ( m_INISectionControl.GetCurSel() != CB_ERR )
	{
 		//m_INISectionControl.GetWindowText ( m_szPPINISection );
                m_INISectionControl.GetLBText ( 
                        m_INISectionControl.GetCurSel(),m_szPPINISection );

		sprintf ( TempSection,"%s",m_szPPINISection );
	}
	
}

void CWANPortDlg::OnSelchangeComboModemTypes()
{
	// TODO: Add your control notification handler code here
}

