// wanrf200.cpp : implementation file
//

#include "stdafx.h"
#include "procon.h"
#include "maindlg.h"
#include "wanrf200.h"
#include "wandlg.h"
#include "script.h"

#define LEN_DIAL_NUMBER 40

/* chetan 8/7/97 */
extern LPCSTR TNETSectionHeader ;
extern LPCSTR PPPSectionHeader ;
/* chetan 8/7/97 */

#ifdef _DEBUG
#undef THIS_FILE
static char BASED_CODE THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CWANRF200 dialog


CWANRF200::CWANRF200(CWnd* pParent /*=NULL*/)
	: CDialog(CWANRF200::IDD, pParent)
{
	//{{AFX_DATA_INIT(CWANRF200)
	m_szDialNumber = "";
	m_bPortEnable = FALSE;
	m_szBaud = "";
	m_nTimeOut = 0;
	m_bScript = FALSE;
	m_bRestartScript = FALSE;
	//}}AFX_DATA_INIT
}

void CWANRF200::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CWANRF200)
	DDX_Control(pDX, IDC_STATIC_DEF_TEL_SRV_IP_ADDR, m_StatDefTelSrvIPAddrTxt);
	DDX_Control(pDX, IDC_CHECK_TERM_SERVER, m_ChkBoxTrmServer);
	DDX_Control(pDX, IDC_STATIC_TERM_SERV_GRP, m_StatTermSrvGrp);
	DDX_Control(pDX, IDC_EDIT_DEF_TEL_SRV_IP_ADDR, m_EditDefTelSrvIPAddrWnd);
	DDX_Control(pDX, IDC_BUTTON_SCRIPT, m_BtnScript);
	DDX_Control(pDX, IDC_STATIC_MINS, m_StatMinutesWnd);
	DDX_Control(pDX, IDC_STATIC_PORT_INACTIVE_TIMEOUT, m_StatPortInactiveWnd);
	DDX_Control(pDX, IDC_STATIC_SPEC_NAME, m_StatSpecificNameWnd);
	DDX_Control(pDX, IDC_STATIC_GEN_NAME, m_StatGeneralNameWnd);
	DDX_Control(pDX, IDC_EDIT_TIMEOUT, m_EditTimeOutWnd);
	DDX_Control(pDX, IDC_EDIT_SPECIFIC_NAME, m_EditSpecificNameWnd);
	DDX_Control(pDX, IDC_EDIT_GEN_NAME, m_EditGeneralNameWnd);
	DDX_Control(pDX, IDC_COMBO_BAUD, m_combBoxBaud);
	DDX_Control(pDX, IDC_RADIO_ANSWERING, m_RBtnAnswering);
	DDX_Control(pDX, IDC_RADIO_DIALLING, m_RBtnDialling);
	DDX_Control(pDX, IDC_STATIC_AG_GRP, m_AGGroupWnd);
	DDX_Control(pDX, IDC_STAT_DIAL_NUM, m_StatDialNumWnd);
	DDX_Control(pDX, IDC_EDIT_DIAL_NUM, m_EditDialNumWnd);
	DDX_Text(pDX, IDC_EDIT_DIAL_NUM, m_szDialNumber);
	DDX_Check(pDX, IDC_CHECK_PORT_ENABLE, m_bPortEnable);
	DDX_CBString(pDX, IDC_COMBO_BAUD, m_szBaud);
	DDX_Text(pDX, IDC_EDIT_GEN_NAME, m_szGeneralName);
	DDX_Text(pDX, IDC_EDIT_SPECIFIC_NAME, m_szSpecificName);
	DDX_Text(pDX, IDC_EDIT_TIMEOUT, m_nTimeOut);
	DDX_Check(pDX, IDC_CHECK_SCRIPT_ENABLE, m_bScript);
	DDX_Check(pDX, IDC_CHECK_RESTART_SCRIPT_ON_COMM_FAILURE, m_bRestartScript);
	DDX_Check(pDX, IDC_CHECK_TERM_SERVER, m_bTermServer);
	DDX_Text(pDX, IDC_EDIT_DEF_TEL_SRV_IP_ADDR, m_szDefTelSrvIPAddr);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CWANRF200, CDialog)
	//{{AFX_MSG_MAP(CWANRF200)
	ON_BN_CLICKED(IDC_BTN_ADVANCED, OnAdvanced)
	ON_BN_CLICKED(IDC_BTN_HELP, OnHelp)
	ON_BN_CLICKED(IDC_RADIO_ANSWERING, OnAnswering)
	ON_BN_CLICKED(IDC_RADIO_DIALLING, OnDialling)
	ON_BN_CLICKED(IDC_BUTTON_SCRIPT, OnButtonScript)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()


/////////////////////////////////////////////////////////////////////////////
// CWANRF200 message handlers

BOOL CWANRF200::OnInitDialog()
{
	CDialog::OnInitDialog();
	
	char WindowHeader[80], CurrentHeading[80], *SubHeadingPointer ;

	GetWindowText (CurrentHeading, 80) ;
	SubHeadingPointer = strchr (CurrentHeading, '-') ;
	if (SubHeadingPointer == NULL)
		SubHeadingPointer = CurrentHeading ;
	else
		SubHeadingPointer += 2 ;

	strcpy (WindowHeader, WindowText.GetBuffer(0)) ;
	strcat (WindowHeader, " - ") ;
	strcat (WindowHeader, SubHeadingPointer) ;
	SetWindowText (WindowHeader) ;

	GetConfig() ;
	CenterWindow() ;
	UpdateData (FALSE) ;
	// TODO: Add extra initialization here
	
	return TRUE;  // return TRUE  unless you set the focus to a control
}

void CWANRF200::OnCancel()
{
	// TODO: Add extra cleanup here
	
	CDialog::OnCancel();
}

void CWANRF200::OnOK()
{
	// TODO: Add extra validation here
	char szLHS[100] ;
	char szTemp[50] ;
	LPCSTR temp ;

	if (!UpdateData (TRUE))
		return ;

	/* chetan 8/7/97 */
	if (!ValidEditFields())
		return ;
	/* chetan 8/7/97 */

	strcpy (szTemp, "WAN Port0") ;
	if (m_bPortEnable)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szTemp, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	strcpy (szLHS, szTemp) ;
	strcat (szLHS, " Auto Answer") ;
	if (m_RBtnAnswering.GetCheck())
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	/* chetan 8/7/97 */
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
		(LPCSTR) "PPP Port0 Link Auto Answer",
			(LPCSTR) temp, (LPCSTR) IniInWinForm) ;
	// Backup Port will also be same type : dialing/answering
	//Vidy 05/08/97 added - problem reported from field
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
		(LPCSTR) "PPP Port1 Link Auto Answer",
			(LPCSTR) temp, (LPCSTR) IniInWinForm) ;
	/* chetan 8/7/97 */

	strcpy (szLHS, szTemp) ;
   strcat (szLHS, " Dial Number") ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) m_szDialNumber, (LPCSTR) IniInWinForm) ;
	// Write strings of type : PPP Port00 Link Phone Number=xxx
	WritePrivateProfileString ((LPCSTR) PPPSectionHeader,
				(LPCSTR) "PPP Port0 Link Phone Number",
				m_szDialNumber, (LPCSTR) IniInWinForm) ;

	int index ;
	strcpy (szLHS, szTemp) ;
	strcat (szLHS, " Speed") ;
	index = m_combBoxBaud.GetCurSel() ;
	if (index == CB_ERR)
		m_combBoxBaud.GetLBText (0, m_szBaud) ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) m_szBaud, (LPCSTR) IniInWinForm) ;
	WritePrivateProfileString ((LPCSTR) LSLSectionHeader, 
		(LPCSTR) "LSL Port1 Speed", (LPCSTR) m_szBaud, (LPCSTR) IniInWinForm) ;

	strcpy (szLHS, szTemp) ;
	strcat (szLHS, " Script") ;
	if (m_bScript)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	strcpy (szLHS, szTemp) ;
	strcat (szLHS, " Restart Script On Comm Failure") ;
	if (m_bRestartScript)
		temp = StrEnabled ;
	else
		temp = StrDisabled ;
	WritePrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) temp, (LPCSTR) IniInWinForm) ;

	CDialog::OnOK();
}

void CWANRF200::OnAdvanced()
{
	// TODO: Add your control notification handler code here
	CWANDlg cWANDlg ;
	cWANDlg.DoModal() ;
}

void CWANRF200::OnHelp()
{
	// TODO: Add your control notification handler code here
	AfxGetApp()->WinHelp (0x20000 + IDD_WAN_PORT_CONFIG, HELP_CONTEXT) ;
}

void CWANRF200::OnAnswering()
{
	// TODO: Add your control notification handler code here
	m_EditDialNumWnd.EnableWindow (FALSE) ;
	m_StatDialNumWnd.EnableWindow (FALSE) ;

}

void CWANRF200::OnDialling()
{
	// TODO: Add your control notification handler code here
	m_EditDialNumWnd.EnableWindow (TRUE) ;
	m_StatDialNumWnd.EnableWindow (TRUE) ;

}

void CWANRF200::GetConfig()
{
	char szLHS[100] ;
	char szRHS[100] ;
	char szTemp[50] ;

	CMainDlg *pMainDialog = (CMainDlg *) GetParent() ;
	m_BtnScript.EnableWindow (pMainDialog->RouterUp && pMainDialog->TargetFound) ;

	strcpy (szTemp, "WAN Port0") ;
	strcpy (szLHS, szTemp) ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, StrDisabled, (LPSTR) szRHS,
					sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szRHS, StrEnabled))
		m_bPortEnable = TRUE ;
	else
		m_bPortEnable = FALSE ;

	strcpy (szLHS, szTemp) ;
	strcat (szLHS, " Auto Answer") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, StrDisabled, (LPSTR) szRHS,
					sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	if (!strcmp (szRHS, StrEnabled))
	{
		m_RBtnAnswering.SetCheck (1) ;
		OnAnswering() ;
	}
	else
	{
		m_RBtnDialling.SetCheck (1) ;
		OnDialling() ;
	}
	/* chetan 8/7/97 */

	strcpy (szLHS, szTemp) ;
   strcat (szLHS, " Dial Number") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) StrNull, (LPSTR) szRHS,
					sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	m_szDialNumber = szRHS ;
	m_EditDialNumWnd.LimitText (LEN_DIAL_NUMBER - 1) ;

	strcpy (szLHS, szTemp) ;
	strcat (szLHS, " Speed") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
			(LPCSTR) szLHS, (LPCSTR) StrNull, (LPSTR) szRHS,
							sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	int index = 0 ;
	if (!szRHS[0])
	{
		m_combBoxBaud.GetLBText (index, &szRHS[0]) ;
	}
	m_szBaud = szRHS ;

	strcpy (szLHS, szTemp) ;
	strcat (szLHS, " Script") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) StrDisabled, (LPSTR) szRHS,
				sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	if (strcmp (szRHS, StrEnabled) == 0)
		m_bScript = TRUE ;
	else
		m_bScript = FALSE ;
	
	strcpy (szLHS, szTemp) ;
	strcat (szLHS, " Restart Script On Comm Failure") ;
	GetPrivateProfileString ((LPCSTR) WANSectionHeader,
		(LPCSTR) szLHS, (LPCSTR) StrDisabled, (LPSTR) szRHS,
				sizeof (szRHS), (LPCSTR) IniInWinForm) ;
	if (strcmp (szRHS, StrEnabled) == 0)
		m_bRestartScript = TRUE ;
	else
		m_bRestartScript = FALSE ;

}

/* 8/7/97  Chetan */
BOOL CWANRF200::ValidEditFields()
{
	return TRUE ;
}

/* 8/7/97  Chetan */
void CWANRF200::OnButtonScript()
{
	// TODO: Add your control notification handler code here
	CScriptDlg CScript ;
	CScript.m_nPortNum = 0 ;
	CScript.DoModal() ;
}


