/*****************************************************************************
	function	:	motorola S-record relocator
	Author	:	Vidy, MTSS India.
	Date		:	26-09-96
*****************************************************************************/
#include	<stdio.h>

#define	RECORD_SIZE		200

char inline[RECORD_SIZE];
char outline[RECORD_SIZE];

long atoul(char *aptr, int count)
{
	long result = 0;
	int digit;

	while (*aptr && count--) {
		digit = *aptr++;
		if (digit >= '0' && digit <= '9')
			digit -= '0';
		else if (digit >= 'a' && digit <= 'f' )
			digit -= 'a' - 10;
		else if (digit >= 'A' && digit <= 'F')
			digit -= 'A' - 10;
		result = digit + (result * 16);
	}
	return result;
}

void	capitalize(char *outline)
{
	while(*outline) {
		if (*outline >= 'a' && *outline <= 'z')
			*outline = *outline - 'a' + 'A';
		outline++;
	}
}

void add_check_sum(char *srecord)
{
	unsigned char chk_sum = 0;
	int	rec_size;

	srecord += 2;			//skip recrd type from check_sum
	rec_size = atoul(srecord, 2);		// get size of s-record

	while (rec_size--) {
		chk_sum += atoul(srecord, 2);
		srecord += 2;
	}
	chk_sum = 0xff - chk_sum;
	sprintf(srecord,"%02x",chk_sum);
}

main(int argc, char *argv[])
{
	int	ifd, ofd;
	unsigned long	base_address = 0;
	unsigned long	new_base_address = 0x0L;
	unsigned long	rec_address = 0;

	if (argc < 2) {
		printf("Motorola S-Record converter utility. Ver. 1.00");
		printf("\nUsage: srx2hex <destination address>\n");
		printf("Input taken from stdin and output written to stdout\n");
		exit (1);
	}
	new_base_address = atoul(argv[1], 8);

	while (gets(inline) != NULL) {
		if (inline[0] != 'S') {
			continue;
		}
		strcpy(outline,inline);

		if (inline[1] == '3') {
			if (!base_address) {	// the first S3 record gives the base address
				base_address = atoul(&inline[4], 8);
			}
			rec_address = atoul(&inline[4], 8);	// get address
			rec_address -= base_address;
			rec_address += new_base_address;
			sprintf(&outline[4], "%08lx", rec_address);
			strcat(outline, &inline[12]);
			add_check_sum(outline);
			capitalize(outline);
			puts(outline);
										  
		} else if (inline[1] == '0') {
			//eatup these records
		} else if (inline[1] == '9') {
			//eatup these records
		} else {
			printf("!!!!! Unknown record type !!!!\n");
			exit(1);
		}
	}
}
