#include <defs.h>
/* AGIP.C -- Code related to the IP interface 
** Sudha  07/07/98  &  Brindha M.P  continued  on  10/09/98 
** Modifications : sudha 15-Oct-1999. In ag_tcp_send_serial_rx_packet_on_
**						 network() function, as well as in function
**						 ag_tcp_send_retained_serial_rx_packet_on_network().
*/

#define 	MAX_TCP_PACKET 1024
/* these .h files are from the include directory */

#include "rtrstd.h"
#include <socklib.h>

#include "..\..\stacks\ip\kip.h"
#include "..\..\stacks\ip\kipuser.h" 
#include "..\..\stacks\ip\vipusstr.h"  
#include "..\..\stacks\ip\vipktstr.h"  

#include "..\..\stacks\tcp\ktcp.h"
#include "..\..\stacks\tcp\tcphdr.h"
#include "..\..\stacks\tcp\tcpsock.h"

#include "kag.h"

#include "vagstr.h"
#include "vag.h"

#include "agpkttyp.h"
#include "agutil.h"
#include "agdebug.h"

#include "agip.h"
#include "agsess.h"
#include "agresp.h"
#include "agintern.h"
#include "agtx.h"

extern ULONG get_ip_address(USHORT);
extern void server_discovery_timer(void);

WORD ReqPktSize[] =
{
	sizeof(NAME_VALIDATE_REQ_TYPE),
	sizeof(PASSWORD_VALIDATE_REQ_TYPE),
	sizeof(CONNECT_REQ_TYPE),
   sizeof(STATUS_REQ_TYPE),
	sizeof(DISCONNECT_REQ_TYPE),	
   sizeof(CHANGE_PARAMS_REQ_TYPE),
   MAX_TCP_PACKET,			/* Remote Console Packets */
	sizeof(INBOUND_CONNECT_REQ_TYPE),
	0,				/* Transfer data to line 	*/
	sizeof(CONTROL_TYPE),
};

WORD RespPktSize[] =
{
	sizeof(NAME_VALIDATE_RESP_TYPE),
	sizeof(PASSWORD_VALIDATE_RESP_TYPE),
	sizeof(CONNECT_RESP_TYPE),
   ((sizeof(STATUS_RESP_TYPE) - sizeof(LINE_STAT_INFO_TYPE)) + (MAX_LINES_PER_STATUS_PACKET * sizeof(LINE_STAT_INFO_TYPE))),
	0,	
   0,
   0,			/* Remote Console Packets */
	sizeof(CONNECT_RESP_TYPE),
	0,				/* Transfer data to line 	*/
	0,
};

/*  Local  Prototypes   */
enum TEST initialize_server_discovery_socket_interface(void);
enum TEST register_server_discovery(void);
enum TEST server_discovery_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1);
WORD get_packet_size(BYTE PktClass);
WORD get_size_to_allocate(BYTE PktClass);
enum BOOLEAN ag_tcp_issue_receives_for_session(SESSION_TABLE_ENTRY *sptr_session_entry);

SERVER_DISCOVERY_CLASS server_discovery;

enum TEST initialize_ag_server_discovery ()
{
   server_discovery.enabled = TRUE;
	server_discovery.socket_interface_enabled = TRUE;
   
	if (register_server_discovery() == FAIL)
   {
      ag_printf(AG_INIT_PRINTF, "AG: Server failed to register properly \n\r");
		return (FAIL);
   }

	if (initialize_server_discovery_socket_interface() == FAIL)
		return (PASS);

	server_discovery.timer_class.timer_enabled = TRUE;
	return (PASS);
}
enum TEST initialize_server_discovery_socket_interface(void)
{
	SOCKADDR_IN local_read_sockaddr_in;

	if (server_discovery.socket_interface_enabled  == FALSE)
		return (FAIL);
		
	server_discovery.local_internet_address = get_ip_address(0);

	server_discovery.socket = socket(AF_INET, SOCK_DGRAM ,0L);
	if (server_discovery.socket == FAILED) 
	{
		return (FAIL);
	}

	associate_application_with_socket(server_discovery.socket, server_discovery.application_id);

	/* initialize local sockaddr_in structure */
	local_read_sockaddr_in.sin_family      = AF_INET;    /* "Internet" Address Family */
	local_read_sockaddr_in.sin_addr.s_addr = server_discovery.local_internet_address;    /* Local IP address */
	local_read_sockaddr_in.sin_port = IPPORT_DISCOVER_SERVER;

	/* bind local ip address & port number to the socket */
	if (bind(server_discovery.socket, (SOCKADDR *)&local_read_sockaddr_in, sizeof(SOCKADDR_IN)) == FAILED) {
		closesocket(server_discovery.socket);
		return (FAIL);
	}
		
	server_discovery.socket_interface_initialized = TRUE;
	return (PASS);
}

enum TEST register_server_discovery(void)
{
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "IP Server Discovery", 
		SERVER_DISCOVERY_APPLICATION, server_discovery_timer, server_discovery_control, &server_discovery.application_id) == FAIL)
	{
		return (FAIL);
	}
	return (PASS);
}

enum TEST server_discovery_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, ULONG parameter_1)
{

	switch (command)
	{
		case START_APPLICATION:
			break;
		case TERMINATE_APPLICATION:
         break;
		case READ_DATA_FROM_SOCKET:
			break;
		case IS_APPLICATION_ENABLED:
			*((enum BOOLEAN *) parameter_1) = (enum BOOLEAN ) server_discovery.enabled;
			break;
	}
	return (PASS);
}
   
enum TEST initialize_ag_socket_interface()
{
	SOCKADDR_IN local_read_sockaddr_in;

	ag.ip_interface.ip_specific_info.local_internet_address = get_ip_address(0);

	ag.ip_interface.ip_specific_info.socket_descriptor = socket (AF_INET, SOCK_STREAM, 0x00000000L);
	if (ag.ip_interface.ip_specific_info.socket_descriptor == FAILED) 
	{
		ag_printf(AG_INIT_PRINTF,"AG: failed to create socket\n\r");
		return (FAIL);
	}
	associate_application_with_socket(ag.ip_interface.ip_specific_info.socket_descriptor, 
							ag.application_id);

	/* initialize local sockaddr_in structure */
	local_read_sockaddr_in.sin_family      = AF_INET;    /* "Internet" Address Family */
	local_read_sockaddr_in.sin_addr.s_addr = ag.ip_interface.ip_specific_info.local_internet_address;    /* Local IP address */
	local_read_sockaddr_in.sin_port = IPPORT_ASYNC_GATEWAY;    /* Set to ASYNC Gateway Port */ 

	/* bind local ip address & port number to the socket */
	if (bind(ag.ip_interface.ip_specific_info.socket_descriptor, (SOCKADDR *)&local_read_sockaddr_in, sizeof(SOCKADDR_IN)) == FAILED) {
		ag_printf(AG_INIT_PRINTF,"AG: failed to bind\n\r");
		closesocket(ag.ip_interface.ip_specific_info.socket_descriptor);
		return (FAIL);
	}
		
	if (listen(ag.ip_interface.ip_specific_info.socket_descriptor, 1) == FAILED) {
		ag_printf(AG_INIT_PRINTF,"AG: failed to listen\n\r");
		closesocket(ag.ip_interface.ip_specific_info.socket_descriptor);
		return (FAIL);
	} 
	ag_printf(AG_INIT_PRINTF,"AG: bound and socket opened\n\r");
	return (PASS);

}

enum TEST ag_tcp_allocate_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry)
{
   IP_SPECIFIC_INFO *sptr_ip_specific_info;

   sptr_ip_specific_info = (IP_SPECIFIC_INFO *)malloc(sizeof(IP_SPECIFIC_INFO));

   if (sptr_ip_specific_info == NULL)
   {
      printf ("\n\n ag_tcp_allocate : sptr_ip_specific_info is NULL");  
      return FAIL;
   }

   memset(sptr_ip_specific_info, 0, sizeof(IP_SPECIFIC_INFO));
   sptr_session_entry->protocol_specific_info = sptr_ip_specific_info;

   return PASS;
}

void ag_tcp_free_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry) 
{
   IP_SPECIFIC_INFO *sptr_ip_specific_info;

	sptr_ip_specific_info = sptr_session_entry->protocol_specific_info;

   if (sptr_ip_specific_info != NULL )
   {
   	free(sptr_ip_specific_info);
   	sptr_session_entry->protocol_specific_info = NULL;
  	}
}

void ag_tcp_listen()
{
    SESSION_TABLE_ENTRY *sptr_session_entry;
    IP_SPECIFIC_INFO *sptr_ip_specific_info;
    int tcp_con_socket; /* TCP (Connected) Socket */
    SOCKADDR_IN stClientAddr; /* Sockets Remote Address Structure */
    USHORT AddrLen = sizeof(SOCKADDR_IN);
    ULONG		socket_error;

	 if ((tcp_con_socket = accept (ag.ip_interface.ip_specific_info.socket_descriptor, (SOCKADDR *)&stClientAddr, (int *) &AddrLen)) == FAILED) 
    {
      /* get the error number */
		lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
					(ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
		if	(socket_error != WOULD_BLOCK_ERROR)
	      ag_printf(AG_INIT_PRINTF,"AG: failed to accept\n\r");

	 }
    else
    {
      /*  Corresponding to ESR conn_listen_post_routine in agspx.c   */
      ag.sptr_listen_issued_session_entry = sptr_session_entry = get_free_session_entry();
      if (sptr_session_entry == NULL)
		   return;
	   add_entry_to_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);

	   sptr_session_entry->session_status = AG_SESS_ACTIVE;
	   ag.stats.number_of_sessions++;

	   sptr_session_entry->line_in_use = UNKNOWN_LINE;
      sptr_ip_specific_info = sptr_session_entry->protocol_specific_info;
      sptr_ip_specific_info->socket_descriptor = tcp_con_socket;      

    } /* ELSE */

    return;
    
}

void ag_tcp_issue_receives ()
{
   SESSION_TABLE_ENTRY *sptr_session_entry, *sptr_next_session_entry;
   enum BOOLEAN result ;

   sptr_session_entry = (SESSION_TABLE_ENTRY *)get_pointer_to_first_entry_in_list((LINK *)&ag.session_entries_list);

   while (sptr_session_entry != NULL)
   {
	   sptr_next_session_entry = (SESSION_TABLE_ENTRY *)get_pointer_to_next_entry_in_list((LINK *)&sptr_session_entry->links);
      if (sptr_session_entry->session_status != AG_SESS_ABORTED)
         result = ag_tcp_issue_receives_for_session(sptr_session_entry);
      if (result == TRUE || sptr_session_entry->session_status == AG_SESS_ABORTED)
         sptr_session_entry = sptr_next_session_entry;
      else
         break;
   }
}

enum BOOLEAN ag_tcp_issue_receives_for_session(SESSION_TABLE_ENTRY *sptr_session_entry)
{
   USER_SOCKET	*sptr_user_socket;
   IP_SPECIFIC_INFO *sptr_ip_specific_info;
   int session_socket_descriptor;
	int Inlen;
	USHORT data_size = MAX_TCP_PACKET;
	ULONG	socket_error;
   BYTE packet_class;
   enum TEST err_val;

   UNION_AG_PACKET *sptr_ag_packet;
	WORD packet_size;
	
   sptr_ip_specific_info = sptr_session_entry->protocol_specific_info;
   session_socket_descriptor = sptr_ip_specific_info->socket_descriptor;
   sptr_user_socket = (USER_SOCKET *)sptr_ip_specific_info->socket_descriptor;
   if ((Inlen = socket_tcp_peek(sptr_user_socket, ag.ip_interface.ip_specific_info.recv_buffer,4, &err_val )) <= 0) 
   {
		/* get the error number */
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
				(ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
			
		if (socket_error != WOULD_BLOCK_ERROR) 
		{
			closesocket(session_socket_descriptor);
			delete_entry_from_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);
         cleanup_session(sptr_session_entry);
		}
		return TRUE; 
	} 

	packet_class = ag.ip_interface.ip_specific_info.recv_buffer[0];

	if (packet_class != AG_DATA_PACKET) 
   {
		data_size = get_packet_size(packet_class) + sizeof(BYTE);
      /* if (packet_class == AG_CONNECT_REQ || packet_class == AG_IN_CONNECT_REQ)
		   if (ag.ip_interface.ip_specific_info.recv_buffer[1] != 0x80)		 First char of user name is 0x80	
			   data_size -= PASSWORD_LENGTH;			 means new MCSI client		*/
   }
	else
	{
		data_size = ((DATA_TYPE *)&ag.ip_interface.ip_specific_info.recv_buffer[1])->packet_size; 
		data_size = little_to_big_endian_ushort(&data_size) + sizeof(DATA_TYPE); 
	}
	
	if (!data_size)
   {
		ag_printf(AG_INIT_PRINTF,"AG: Invalid packet received\n\r");
		ag_printf(AG_LINE_PRINTF,"AG: TCP connection dropped abnormally\n\r");
		closesocket(session_socket_descriptor);
		delete_entry_from_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);
		cleanup_session(sptr_session_entry);
      return TRUE; 
	}	

	if (socket_tcp_buffer_length(sptr_user_socket, &err_val) >= data_size)
	{
		if (packet_class != AG_DATA_PACKET) 
			packet_size = get_size_to_allocate(packet_class) + sizeof(BYTE);
		else
		{
			packet_size = data_size;
/* we are not going to read from the socket unless all the retained data has
been buffered into the serial tx buffer descriptor which are scheduled for
transmit on the serial side. 26 Feb 1999 */
			if (are_there_retained_packets(sptr_session_entry) == TRUE)
			{
				/* Take a shot at sending the retained entries here and now. */
				send_delayed_serial_packets(sptr_session_entry);
		
				if (are_there_retained_packets(sptr_session_entry) == TRUE)
					return TRUE;
			}
		}	

	   if (!(sptr_ag_packet = (UNION_AG_PACKET *)allocate_ag_packet(packet_size)))
		{	
		   ag_printf(AG_INIT_PRINTF,"AG: run out of memory for packet\n\r");
			return FALSE;
		}
		memset(sptr_ag_packet, 0, packet_size);
		if ((Inlen = recv(session_socket_descriptor, (char *)sptr_ag_packet, data_size, 0)) <= 0) 
		{
			/* get the error number */
			free_ag_packet((BYTE *)sptr_ag_packet);
         sptr_ag_packet = NULL;
			lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
					(ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
					
			if (socket_error != WOULD_BLOCK_ERROR) 
			{
				closesocket(session_socket_descriptor);
				delete_entry_from_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);
				cleanup_session(sptr_session_entry);
            return TRUE;
			}
		} 	
      else
      {
         /* Call appropriate function via function handler array */
         packet_class = sptr_ag_packet->packet_class;

         if (packet_class > AG_CONTROL_PACKET)
	      {
            ag_printf(AG_INIT_PRINTF,"AG: Bad packet received\n\r");
	         free_ag_packet((BYTE *)sptr_ag_packet);
            sptr_ag_packet = NULL;
            return TRUE; /* continue */
         }

         if ((*packet_function_table[packet_class])(sptr_session_entry, sptr_ag_packet, data_size, NULL) == FALSE) 
	      {
	         /* Free the original receive buffer if the called function 
	         ** tells FALSE (meaning it didn't request a network send)
		      */
		      free_ag_packet((BYTE *)sptr_ag_packet);
            sptr_ag_packet = NULL;
            return TRUE;
	      }

         update_line_lan_rx_statistics(sptr_session_entry->line_in_use, data_size);
   
      }
   }
}

void ag_tcp_send_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size)
{
   int sent_buffer;
	ULONG socket_error;
   int session_socket_descriptor;
   IP_SPECIFIC_INFO *sptr_ip_specific_info;

   sptr_ip_specific_info = sptr_session_entry->protocol_specific_info;
   session_socket_descriptor = sptr_ip_specific_info->socket_descriptor;
	if ((sent_buffer = send (session_socket_descriptor,
						          (char *)sptr_ag_packet, data_size, 0)) == FAILED)
	{
		/* get the error number */
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
		if(socket_error != WOULD_BLOCK_ERROR) 
		{
			ag_printf(AG_INIT_PRINTF,"AG: failed to send\n\r");
         closesocket(session_socket_descriptor);
			delete_entry_from_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);
         cleanup_session(sptr_session_entry);
		} 
	}
   else
   {
      /* Below line of code is doubtful : Its not in agspx.c, but in RAS code it is present. 

      update_line_lan_tx_statistics(sptr_session_entry->line_in_use, sent_buffer); */

      return;
   }
}

enum TEST ag_tcp_send_internal_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size)
{
   int sent_buffer;
	USHORT socket_error;
   int session_socket_descriptor;
   IP_SPECIFIC_INFO *sptr_ip_specific_info;

   sptr_ip_specific_info = sptr_session_entry->protocol_specific_info;
   session_socket_descriptor = sptr_ip_specific_info->socket_descriptor;
	if ((sent_buffer = send (session_socket_descriptor,
						          (char *)sptr_ag_packet, data_size, 0)) == FAILED)
	{
			/* get the error number */
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
		if(socket_error != WOULD_BLOCK_ERROR) 
		{
			ag_printf(AG_INIT_PRINTF,"AG: failed to send\n\r");
         closesocket(session_socket_descriptor);
			delete_entry_from_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);
         cleanup_session(sptr_session_entry);
         return FAIL;
		} 
	}
   else
   {   
      internal_sends_callback(sptr_session_entry, sptr_ag_packet);
      return PASS;
   }
	return FAIL;
}

BYTE *allocate_ag_packet(USHORT buf_size)
{
	BYTE *buf_ptr;
	buf_ptr = (BYTE *)malloc(buf_size);

	return (buf_ptr);
}

void free_ag_packet(BYTE *bptr)
{
	if (bptr == NULL)
	{
		ag_printf(AG_ALARM_PRINTF, "AG: NULL pointer request to free\n\r");
		return;
	}
	free(bptr);
   bptr = NULL;
}

void ag_tcp_free_network_stuff(UNION_AG_PACKET *sptr_ag_packet)
{
	free_ag_packet((BYTE *)sptr_ag_packet);
}

/* Below function to be called only when a serially received packet has
** to be sent onto the network.
*/

enum TEST ag_tcp_send_serial_rx_packet_on_network (SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size)
{
   int sent_buffer;
	USHORT  unsent_data_size, send_status = 1;

   ULONG socket_error = WOULD_BLOCK_ERROR;
   int session_socket_descriptor;
   IP_SPECIFIC_INFO *sptr_ip_specific_info;
   BYTE *sptr_rx_buffer, *sptr_ag_packet_data;

	sptr_ip_specific_info = sptr_session_entry->protocol_specific_info;
   session_socket_descriptor = sptr_ip_specific_info->socket_descriptor;

   if ((sent_buffer = send (session_socket_descriptor,
						          (char *)sptr_ag_packet, data_size, 0)) == FAILED)
	{
#ifdef DEBUG_INFO
printf("\n\rAGIP: Send failed.Sent buffer is %d, data_size is %d, sptr_ag_packet %x",
sent_buffer, data_size, sptr_ag_packet);
#endif
			/* get the error number */
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
		if(socket_error != WOULD_BLOCK_ERROR) 
		{
			ag_printf(AG_INIT_PRINTF,"AG: failed to send\n\r");
         closesocket(session_socket_descriptor);
			delete_entry_from_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);
         cleanup_session(sptr_session_entry);
         return FAIL;
		} 
	}
/* 6 March 1999.... */

	if ( sent_buffer != data_size )
	{
		unsent_data_size = data_size - sent_buffer;
		sptr_ag_packet_data = (BYTE *)sptr_ag_packet + sent_buffer;
/* printf("\n\rAGIP3: sent is %d, data size is %d",sent_buffer,data_size); */
#ifdef DEBUG_INFO
printf("\n\rAGIP3: sptr_ag_packet is %x",sptr_ag_packet);
printf("\n\rAGIP3: sptr_ag_packet_data is %x",sptr_ag_packet_data); 
#endif

/* sudha 15-Oct-1999. Removed passing "is_called_from_retained" parameter */
		retain_unsent_packet(sptr_session_entry,sptr_ag_packet_data,unsent_data_size);
		send_status = 0;
	}

	/* Return the buffer back to the serial driver */

   sptr_rx_buffer = (BYTE *)(sptr_ag_packet) + sizeof(DATA_TYPE) - sizeof(BYTE) + sizeof(BYTE);
  	ag.fptr_rx_complete((USHORT)sptr_session_entry->line_in_use, sptr_rx_buffer, send_status);

   update_line_lan_tx_statistics(sptr_session_entry->line_in_use, data_size);

	return PASS;
}

/* 6 March 1999.... */

/* Below function to be called only when a serially received retained packet 
** has to be sent onto the network.
*/

/* sudha 15-Oct-1999. Added one more new parameter "unsent_size" **/
enum TEST ag_tcp_send_retained_serial_rx_packet_on_network (SESSION_TABLE_ENTRY *sptr_session_entry, 
	BYTE *sptr_ag_packet_data, USHORT data_size, USHORT *unsent_size)
{
   int sent_buffer;
	USHORT unsent_data_size, partial_data_size;
   ULONG socket_error;
   int session_socket_descriptor;
   IP_SPECIFIC_INFO *sptr_ip_specific_info;
   BYTE *sptr_retained_ag_packet_data;	
   
	sptr_ip_specific_info = sptr_session_entry->protocol_specific_info;
   session_socket_descriptor = sptr_ip_specific_info->socket_descriptor;

   if ((sent_buffer = send (session_socket_descriptor,
						          (char *)sptr_ag_packet_data, data_size, 0)) == FAILED)
	{
#ifdef DEBUG_INFO
printf("\n\rAGIP: retained send failed.Sent buffer is %d, data_size is %d, sptr_ag_packet %x",
sent_buffer, data_size, sptr_ag_packet_data);
#endif
			/* get the error number */
		lsl_control (RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE,
			(ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
		if(socket_error != WOULD_BLOCK_ERROR) 
		{
			ag_printf(AG_INIT_PRINTF,"AG: failed to send\n\r");
         closesocket(session_socket_descriptor);
			delete_entry_from_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);
         cleanup_session(sptr_session_entry);
         return FAIL;
		} 
	}
/* 6 March 1999.... */

	if ( sent_buffer == 0 )
	{
/* sudha 15-Oct-1999. To find out, exactly the unsent data size. If the entire
packet has been unsent, unsent_size will be zero, in the sense, no re-adjust
of data pointer is needed. The entire packet, without any change, will be
added to the front of the retained packets links */
		*unsent_size = 0;
		return FAIL;
	}
					
	if ( sent_buffer < data_size )
	{
#ifdef DEBUG_INFO
		printf("\n\rAGIP5: sent buffer is %d,data size is %d",sent_buffer,data_size); 
#endif
		unsent_data_size = data_size - sent_buffer;
		sptr_retained_ag_packet_data = (BYTE *)sptr_ag_packet_data + sent_buffer;
/* sudha 15-Oct-1999. This unsent_data_size is used for re_adjusting data
pointers of retained packets. Also here, no need to again call retain_unsent_
packet() function, to malloc newly again, for this already retained packet...*/
		*unsent_size = unsent_data_size;
/*		retain_unsent_packet(sptr_session_entry,sptr_retained_ag_packet_data,unsent_data_size,1); */
		return FAIL;

/* ...sudha 15-Oct-1999 */
	}

	return PASS;
}

/* ....6 March 1999 */

void ag_tcp_terminate_connection(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	IP_SPECIFIC_INFO *sptr_ip_specific_info;
	int session_socket_descriptor;

	sptr_ip_specific_info = sptr_session_entry->protocol_specific_info;
   session_socket_descriptor = sptr_ip_specific_info->socket_descriptor;
   closesocket(session_socket_descriptor);
	sptr_session_entry->session_status = AG_SESS_ABORTED;
}

enum BOOLEAN ag_tcp_says_ok_to_cleanup(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	/* if (((IP_SPECIFIC_INFO *)(sptr_session_entry->protocol_specific_info))->pending_calls == 0)
		return TRUE;
	return FALSE; */

   return TRUE;
}

enum BOOLEAN ag_tcp_says_cancels_done(SESSION_TABLE_ENTRY *sptr_session_entry)
{
   return TRUE;
}

void ag_tcp_cancel_pending_calls(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	/* ?? For now say done as usually when this is called, no call will
	** ?? be pending. 
	*/

	return;
}

WORD get_packet_size(BYTE PktClass)
{
   if (PktClass > AG_CONTROL_PACKET)
		return (0);
	return (ReqPktSize[PktClass]);
}

WORD get_size_to_allocate(BYTE PktClass)
{
	if (PktClass > AG_CONTROL_PACKET)
		return (0);
	if (RespPktSize[PktClass] < ReqPktSize[PktClass])
		return (ReqPktSize[PktClass]);
	else
		return (RespPktSize[PktClass]);	
}

