/* AGIP.H -- Header to AGIP.C
** Modifications : sudha 15-Oct-1999. Added one more parameter "unsent_data_
**						 size" in ag_tcp_send_retained_serial_rx_packet_on_network()
**						 function prototype.	
*/

#ifndef _AGIP_H_
#define _AGIP_H_

#define	IPPORT_ASYNC_GATEWAY	599
#define IPPORT_DISCOVER_SERVER	526
#define MAX_REMOTE_CONSOLE_PACKET	1024

/* Included by  Brindha  for  Server  Discovery  on  2/11/98  */ 

typedef struct SERVER_DISCOVERY_TIMER_CLASS
{
   BYTE_ENUM(BOOLEAN)	timer_enabled;
	ULONG                tick_counter;
	ULONG             	clock_ticks_per_second;
} SERVER_DISCOVERY_TIMER_CLASS;

typedef struct SERVER_DISCOVERY_CLASS {
	BYTE_ENUM(BOOLEAN)               enabled;
	BYTE_ENUM(BOOLEAN)	            socket_interface_enabled;
	BYTE_ENUM(BOOLEAN)	            socket_interface_initialized;
	BYTE_ENUM(BOOLEAN)	            client_up;
	ULONG						            local_internet_address;
	int						            socket;
	ULONG						            remote_internet_address;
	int						            remote_socket_number;
	SERVER_DISCOVERY_TIMER_CLASS  	timer_class;
	ULONG						            application_id;
} SERVER_DISCOVERY_CLASS;

typedef struct SERVER_DISCOVERY_RESPONSE_PACKET
{
	BYTE server_name[SERVER_NAME_LENGTH];

}	SERVER_DISCOVERY_RESPONSE_PACKET;

extern enum TEST initialize_ag_server_discovery(void);
extern enum TEST initialize_ag_socket_interface(void);
extern enum TEST ag_tcp_allocate_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_tcp_free_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_tcp_listen(void);
extern void ag_tcp_issue_receives(void);
extern void ag_tcp_send_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size);
extern enum TEST ag_tcp_send_internal_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size);
extern BYTE *allocate_ag_packet(USHORT data_size);
extern void free_ag_packet(BYTE *bptr);
extern void ag_tcp_free_network_stuff(UNION_AG_PACKET *sptr_ag_packet);
extern enum TEST ag_tcp_send_serial_rx_packet_on_network (SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size);
extern void ag_tcp_terminate_connection(SESSION_TABLE_ENTRY *sptr_session_entry);
extern enum BOOLEAN ag_tcp_says_ok_to_cleanup(SESSION_TABLE_ENTRY *sptr_session_entry);
extern enum BOOLEAN ag_tcp_says_cancels_done(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_tcp_cancel_pending_calls(SESSION_TABLE_ENTRY *sptr_session_entry);

/* sudha 15-Oct-1999. Added one extra parameter "unsent_size" */
extern enum TEST ag_tcp_send_retained_serial_rx_packet_on_network (SESSION_TABLE_ENTRY *sptr_session_entry, BYTE *sptr_ag_packet_data, USHORT data_size, USHORT *unsent_size);


#endif /* _AGIP_H_ */

