/* AGNETIF.C -- Generic network interface functions
** By: Sanjay
** Start: 23, July, 1996
** Done: 30, August, 1996
** Modified For NET_INTERFACE_IP : Brindha M.P
** Modifications : sudha 15-Oct-1999. Added one more parameter "unsent_data_size"
**						 in function send_retained_serial_rx_packet_on_network() as
**						 well as in function call ag_tcp_send_retained_serial_rx_packet
**						 _on_network().						
*/

#include "rtrstd.h"

#include "kag.h"

#include "vagstr.h"
#include "vag.h"

#include "agpkttyp.h"
#include "agutil.h"

#include "agip.h"
#include "agnetif.h"
#ifdef __AG_IPX__
#include "agipx.h"
#include "agspx.h"
#endif

/* Local Prototypes */

/* -- CODE ------------------------------------------------------------- */

enum BOOLEAN is_ag_net_interface_up(void)
{
	BYTE_ENUM(BOOLEAN) ip_protocol_enabled;
	enum BOOLEAN tcp_protocol_enabled;

#ifdef DEBUG_INFO
printf("\n\rAGNETIF : network interface is %d",ag.network_interface_to_use);
#endif

	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__   
		if (lsl_control(PROTOCOL_STACK_CONTROL, "IPX Routing", IS_PROTOCOL_STACK_ENABLED, 0, (ULONG)&ip_protocol_enabled) == FAIL)
			return FALSE;
		if (ip_protocol_enabled == FALSE)
			return FALSE;

		if (lsl_control(RESOLVE_SOCKET_API, TRANSPORT_LAYER_TYPE, IS_TRANSPORT_ENABLED, SPX_TRANSPORT, (ULONG)&tcp_protocol_enabled) == FAIL)
			return FALSE;
		return tcp_protocol_enabled;

#endif
		break;
	case NET_INTERFACE_IP:
      /* Brindha on 10/9/98 */
		if (lsl_control(PROTOCOL_STACK_CONTROL, "IP Routing", IS_PROTOCOL_STACK_ENABLED, 0, (ULONG)&ip_protocol_enabled) == FAIL)
			return FALSE;
		if (ip_protocol_enabled == FALSE)
			return FALSE;
		if (lsl_control(RESOLVE_SOCKET_API, TRANSPORT_LAYER_TYPE, IS_TRANSPORT_ENABLED, TCP_TRANSPORT, (ULONG)&tcp_protocol_enabled) == FAIL)
			return FALSE;
		return tcp_protocol_enabled;
		break;

	case NET_INTERFACE_NETBIOS:
		/* Currently IP and NETBIOS are not supported */
	default:
		return FALSE;
	}

	return TRUE;
}

/*  Included  by  Brindha  for  initialization  of  Server Discovery  */
enum BOOLEAN initialize_server_discovery(void)
{
   switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:            
		return FALSE;

	case NET_INTERFACE_IP:
		if (initialize_ag_server_discovery() == FAIL)
		{
			ag_printf(AG_INIT_PRINTF, "AG: Server initialization failed\n\r");
			return (FALSE);
		}
		break;

	case NET_INTERFACE_NETBIOS:
		/* Currently IP and NETBIOS are not supported */
	default:
		return FALSE;
	}

	return TRUE;
}
      

enum TEST initialize_network_interface()
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:            
#ifdef __AG_IPX__
		if (initialize_for_ipx_spx() == FAIL)
		{
			ag_printf(AG_INIT_PRINTF, "AG: IPX/SPX interface initialization failed\n\r");
			return FAIL;
		}
#endif
		break;

	case NET_INTERFACE_IP:
      /* Brindha on 10/9/98 */
		if (initialize_ag_socket_interface() == FAIL)
		{
			ag_printf(AG_INIT_PRINTF, "AG: IP interface initialization failed\n\r");
			return (FAIL);
		}
		break;

	case NET_INTERFACE_NETBIOS:
		/* Currently IP and NETBIOS are not supported */
	default:
		return FAIL;
	}

	return PASS;
}

enum TEST allocate_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag_spx_allocate_protocol_structure(sptr_session_entry);
		break;
#endif
	case NET_INTERFACE_IP:
		return ag_tcp_allocate_protocol_structure(sptr_session_entry);
      break;
	case NET_INTERFACE_NETBIOS:
		/* Currently not supported */
	default:
		break;
	}
	return FAIL;
}

void free_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__ 
		ag_spx_free_protocol_structure(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
		ag_tcp_free_protocol_structure(sptr_session_entry);
      break;
	case NET_INTERFACE_NETBIOS:
		/* Currently not supported */
	default:
		break;
	}
}

void listen_for_connection()
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
		break;
	case NET_INTERFACE_IP:
   /* Brindha on 3/12/98 */
      ag_tcp_listen();
      break;
	case NET_INTERFACE_NETBIOS:
		/* Currently not supported */
	default:
		break;
	}
}

void issue_receives_for_connection()
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		do_ipx_interface_periodic_actions();
#endif
		break;
	case NET_INTERFACE_IP:
      /* Brindha on 10/9/98 */
      ag_tcp_issue_receives();
      break;
	case NET_INTERFACE_NETBIOS:
	default:
		/* Currently not supported */
		break;
	}
}

void send_network_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		ag_spx_send_packet(sptr_session_entry, sptr_ag_packet, data_size, cb_ptr);
#endif
		break;
	case NET_INTERFACE_IP:
      /* Brindha on 11/09/98 */
      ag_tcp_send_packet(sptr_session_entry, sptr_ag_packet, data_size);
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemeted */
	default:
		break;
	}
}

enum TEST send_network_internal_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag_spx_send_internal_packet(sptr_session_entry, sptr_ag_packet, data_size);
#endif
		break;
	case NET_INTERFACE_IP:
      return ag_tcp_send_internal_packet(sptr_session_entry, sptr_ag_packet, data_size);
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemeted */
	default:
		break;
	}

	return FAIL;
}

enum TEST send_serial_rx_packet_on_network(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag_spx_send_serial_rx_packet_on_network(sptr_session_entry, sptr_ag_packet, data_size);
#endif
		break;
	case NET_INTERFACE_IP:
      return ag_tcp_send_serial_rx_packet_on_network(sptr_session_entry, sptr_ag_packet, data_size);
		break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemeted */
	default:
		break;
	}
	return PASS;
}

/* 6 March 1999.... */
/* sudha 15-Oct-1999.Added one extra parameter "unsent_size" */
enum TEST send_retained_serial_rx_packet_on_network(SESSION_TABLE_ENTRY *sptr_session_entry, BYTE *sptr_ag_packet_data, USHORT data_size, USHORT *unsent_size)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
		break;

	case NET_INTERFACE_IP:
/* sudha 15-Oct-1999.Added one extra parameter "unsent_size" */
      return ag_tcp_send_retained_serial_rx_packet_on_network(sptr_session_entry, sptr_ag_packet_data, data_size, unsent_size);
		break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemeted */
	default:
		break;
	}
	return PASS;
}

/* ....6 March 1999 */

/* This function  is  not  called  anywhere  in  the  RTRWARE code.
   I  dont  understand  the  purpose  of  this !!  */ 

USHORT get_max_network_rx_buffer_size()
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag.ipx_interface.max_net_rx_buffer_size;
#endif
		break;
	case NET_INTERFACE_IP:
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}

	return 0;
}

BYTE *get_a_network_send_packet(USHORT data_size)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return get_a_spx_send_buffer(data_size);
#endif
		break;
	case NET_INTERFACE_IP:
      return allocate_ag_packet(data_size);
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}

	return NULL;
}

void free_a_network_send_packet(BYTE *bptr)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		free_a_spx_send_buffer(bptr);
#endif
		break;
	case NET_INTERFACE_IP:
      free_ag_packet(bptr);
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

void reduce_network_receives(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		ag_spx_reduce_network_receives(sptr_session_entry);
#endif                         
		break;
	case NET_INTERFACE_IP:
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

void increase_network_receives(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		ag_spx_increase_network_receives(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

void free_network_stuff(UNION_AG_PACKET *sptr_ag_packet)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		ag_spx_free_network_stuff(sptr_ag_packet);
#endif
		break;
	case NET_INTERFACE_IP:
      ag_tcp_free_network_stuff(sptr_ag_packet);
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

enum BOOLEAN wait_for_network_packets(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		if (((IPX_SPECIFIC_INFO *)sptr_session_entry->protocol_specific_info)->receives_issued == 0)
		{
			ag_spx_issue_receives_for_session(sptr_session_entry);
			return TRUE;
		}
		return FALSE;
#endif
		break;

	case NET_INTERFACE_IP:
      return TRUE;
		break;

	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

void reduce_receives_and_wait_for_network_packets(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		((IPX_SPECIFIC_INFO *)sptr_session_entry->protocol_specific_info)->receives_issued--;
		ag_spx_issue_max_receives_for_session(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
		break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

void terminate_network_connection(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		if (sptr_session_entry->session_status != AG_SESS_ABORTED)
			ag_spx_terminate_connection(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
      if (sptr_session_entry->session_status != AG_SESS_ABORTED)
			ag_tcp_terminate_connection(sptr_session_entry);
		break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */

	default:
		break;
	}
}

enum BOOLEAN network_says_ok_to_cleanup(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag_spx_says_ok_to_cleanup(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
      return ag_tcp_says_ok_to_cleanup(sptr_session_entry);
		break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

enum BOOLEAN network_says_cancels_done(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag_spx_says_cancels_done(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
      return ag_tcp_says_cancels_done(sptr_session_entry);
		break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

void cancel_pending_network_calls(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		ag_spx_cancel_pending_calls(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
      /* At  present this  does  nothing  */
      ag_tcp_cancel_pending_calls(sptr_session_entry);
		break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

ULONG get_client_network_number(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag_spx_get_client_network_number(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
	return 0L;
}

ULONG get_client_node_number_ulong(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag_spx_get_client_node_number_ulong(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
	return 0L;
}

USHORT get_client_node_number_ushort(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		return ag_spx_get_client_node_number_ushort(sptr_session_entry);
#endif
		break;
	case NET_INTERFACE_IP:
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
	return 0;
}

void fill_user_address(SESSION_TABLE_ENTRY *sptr_session_entry, BYTE *sptr_address)
{
	switch (ag.network_interface_to_use)
	{
	case NET_INTERFACE_IPXSPX:
#ifdef __AG_IPX__
		ag_spx_fill_user_address(sptr_session_entry, sptr_address);
#endif
		break;
	case NET_INTERFACE_IP:
      break;
	case NET_INTERFACE_NETBIOS:
		/* Not implemented */
	default:
		break;
	}
}

/* -- END CODE -------------------------------------------------------- */

