/* DEVELOPMENT STOPPED FOR NOW (22, August, 1996). TO BE CONTINUED BY
** SOMEONE ELSE. THIS FILE NOT INCLUDED IN THE AG MAKEFILE.
** GUIDELINES:
**	1. Statistics should include both RAS and AG statistics.
**	2. Should work with RN's console program.
**	3. Should support supervisor password.
**	4. Ignore calls that do not make sense (like reset SBC processor,...)
*/

/* AGRCON.C -- Handling of remote console requests
** By: Sanjay S
** Start: 21, August, 1996
** Done:
*/

#include "rtrstd.h"
#include <serial.h>
#include <msm.h>

#include "kag.h"

#include "vagstr.h"
#include "vag.h"

#include "agpkttyp.h"
#include "agutil.h"
#include "agline.h"
#include "agnetif.h"
#include "agsess.h"
#include "agtx.h"
#include "aginbsup.h"

#include "agrcon.h"
#include "rcon.h"

#include <udb.h>  /* Added by Naveen.P.N. on 15-10-1996 */
#include <wanmgr.h>

#define MIN(x, y) ((x) > (y) ? (y) : (x))

/*#define HARDWARE_68K 0x80*/
extern enum BOOLEAN display_host_list(LINE_INFO_ENTRY *sptr_line_info);
extern SESSION_TABLE_ENTRY *get_ith_element_from_inbound_list(LINE_INFO_ENTRY *sptr_line_info, BYTE inbound_entry_index);
extern enum BOOLEAN  delete_inbound_session_from_line(LINE_INFO_ENTRY *sptr_line_info, SESSION_TABLE_ENTRY *sptr_session_entry_to_delete);


/* Local Prototypes */
STATIC ULONG sum_total_tx_data_packets(void);
STATIC ULONG sum_total_rx_data_packets(void);
STATIC ULONG sum_total_lan_tx_bytes(void);
STATIC ULONG sum_total_lan_rx_bytes(void);
STATIC ULONG sum_total_line_tx_bytes(void);
STATIC ULONG sum_total_line_rx_bytes(void);

STATIC void calculate_throughputs(LINE_INFO_ENTRY *sptr_line_info) ;


STATIC enum BOOLEAN rc_get_server_information(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_down_server(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_get_log_status(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_open_log(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_close_log(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_disconnect_line(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_change_parameters(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_get_statistics_summary(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_get_current_statistics(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_reset_line(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_validate_password(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_return_status(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_get_inbound_list(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_delete_inbound(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_get_server_configuration(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_change_server_configuration(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_return_configuration_file(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_change_configuration_file(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_reset_sbc_processor(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_validate_user(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_unlock_user(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);
STATIC enum BOOLEAN rc_save_changes_to_disk(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr);

/* Statics */

STATIC enum BOOLEAN (*remote_console_function_table[])(SESSION_TABLE_ENTRY *, UNION_AG_PACKET *, USHORT, void *) =
{
	rc_get_server_information,
	rc_down_server,
	rc_get_log_status,
	rc_open_log,
	rc_close_log,
	rc_disconnect_line,
	rc_change_parameters,
	rc_get_statistics_summary,
	rc_get_current_statistics,
	rc_reset_line,
	rc_validate_password,
	rc_return_status,
	rc_get_inbound_list,
	rc_delete_inbound,
	rc_get_server_configuration,
	rc_change_server_configuration,
	rc_return_configuration_file,
	rc_change_configuration_file,
	rc_reset_sbc_processor,
	rc_validate_user,
	rc_unlock_user,
	rc_save_changes_to_disk
};

/* -- CODE ------------------------------------------------------------- */

enum BOOLEAN process_remote_console_request(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	BYTE sub_function;

	/* ?? Remove similar function in AGRESP.C ?? Done(By Naveen).*/

	change_endian(sptr_ag_packet);

	sub_function = sptr_ag_packet->packet_type.remote_console_packet.sub_function;
	if (sub_function > REQ_RC_REQUEST_LAST_TYPE)
		return FALSE;
	return remote_console_function_table[sub_function](sptr_session_entry, sptr_ag_packet, data_size, cb_ptr);
}

STATIC enum BOOLEAN rc_get_server_information(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	RC_SERVER_INFORMATION *sptr_server_information;

	/* Incoming packet will be used for outgoing purposes from now on */
	sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET;
	sptr_server_information = (RC_SERVER_INFORMATION *)&sptr_ag_packet->packet_type;

	sptr_server_information->response_type = RESP_RC_SERVER_INFORMATION;
	strcpy (&sptr_server_information->server_name[0], &ag.server_name[0]) ;
/*	strcpy (&sptr_server_information->version_string[0], &ag.version_string[0]) ;*/
   strcpy (&sptr_server_information->version_string[0],"2.00");
	sptr_server_information->number_of_ports = ag.number_of_lines;
	sptr_server_information->server_type = COM_VERSION | HARDWARE_68K;
	if (ag.network_interface_to_use == NET_INTERFACE_IPXSPX)
		sptr_server_information->server_type += IPX_VERSION;

/* ExpressNaveen 16/10/1996 */

	sptr_server_information->server_type |= AG_SERVER ;

/* ExpressNaveen 16/10/1996 */

	sptr_server_information->number_of_cards = 0;
	sptr_server_information->password_present = FALSE;

	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(RC_SERVER_INFORMATION) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_down_server(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	/* We don't support this as bringing the server down will bring the 
	** router down!! We certainly don't want that to happen.
	** ?? Or should we disable the AG server alone ??
	** ?? Or should we do a warm-boot ??
	** ?? Or go into a tight-loop ??
	*/

	/* For now, we do not permit downing the AG server.
	   For sure, it is not possible to down the router.
	   We can think of bringing down only the AG server
	*/
	return FALSE;
}

STATIC enum BOOLEAN rc_get_log_status(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	RC_LOG_STATUS_INFORMATION *sptr_log_information;

	/* ?? Currently we do not support log ?? */

	/* In packet is used for out purposes */
	sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET;
	sptr_log_information = (RC_LOG_STATUS_INFORMATION *)&sptr_ag_packet->packet_type.remote_console_packet;
	memset(sptr_log_information, 0, sizeof(RC_LOG_STATUS_INFORMATION));

	sptr_log_information->response_type = RESP_RC_LOG_STATUS;
	sptr_log_information->log_status = 0;		/* Closed */

	big_to_little_endian_ushort(&sptr_log_information->log_start_time.year);
	big_to_little_endian_ushort(&sptr_log_information->current_time.year);
	big_to_little_endian_ulong(&sptr_log_information->log_period);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(RC_LOG_STATUS_INFORMATION) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_open_log(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	/* Currently we don't support logging */
	return FALSE;
}

STATIC enum BOOLEAN rc_close_log(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	/* Currently we don't support logging */
	return FALSE;
}

STATIC enum BOOLEAN rc_disconnect_line(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	BYTE line_id;
	RC_DISCONNECT_REQUEST *sptr_disconnect_request;
	LINE_INFO_ENTRY *sptr_line_info ;
	sptr_disconnect_request = (RC_DISCONNECT_REQUEST *)&sptr_ag_packet->packet_type;
	line_id = sptr_disconnect_request->channel_number;
  	if (line_id >= ag.number_of_lines /*|| ag.owned_by_module[line_id] == UNKNOWN_MODULE*/)
		return FALSE;
	sptr_line_info = &ag.line_info_array[line_id];

	/* ?? Is the following check sufficient or do other states come in ?? */
	if (sptr_line_info->line_status == AGLS_LINE_BUSY)
		freeup_line(sptr_line_info, AGFL_SUPERVISOR_DISCONNECT);
	return FALSE;
}

STATIC enum BOOLEAN rc_change_parameters(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	BYTE line_id;
	RC_CHANGE_PARAMETERS_REQUEST *sptr_new_parameters;


	sptr_new_parameters = (RC_CHANGE_PARAMETERS_REQUEST *)&sptr_ag_packet->packet_type;
	line_id = sptr_new_parameters->channel_number;
	if (line_id >= ag.number_of_lines /*|| ag.owned_by_module[line_id] == UNKNOWN_MODULE*/)
		return FALSE;
	/* Convert endian of incoming packet */
	little_to_big_endian_ushort(&sptr_new_parameters->connect_vars_info.line_parameters.baud_divisor);
	little_to_big_endian_ushort(&sptr_new_parameters->connect_vars_info.max_packet_size);
	little_to_big_endian_ushort(&sptr_new_parameters->connect_vars_info.max_inter_packet_delay);
	little_to_big_endian_ushort(&sptr_new_parameters->connect_vars_info.idle_time);

	/* ?? In reality Remote Console changes should have permanent effect.
	** ?? That is the way it is in the original AG.
	*/
	change_line_parameters(line_id, &sptr_new_parameters->connect_vars_info);

	return FALSE;
}

STATIC enum BOOLEAN rc_get_statistics_summary(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	RC_STATISTICS_SUMMARY *sptr_statistics_summary;

	/* From now in packet is out packet */
	sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET;
	sptr_statistics_summary = (RC_STATISTICS_SUMMARY *)&sptr_ag_packet->packet_type;
	memset(sptr_statistics_summary, 0, sizeof(RC_STATISTICS_SUMMARY));

	/* ?? The statistics also includes the RAS statistics in the RNAG.
	*/
	sptr_statistics_summary->response_type = RESP_RC_STATISTICS_SUMMARY;

   sptr_statistics_summary->current_time.year = 6;
   sptr_statistics_summary->current_time.month = 0;
   sptr_statistics_summary->current_time.day = 6;
   sptr_statistics_summary->current_time.week_day = 6;
   sptr_statistics_summary->current_time.hour = 6;
   sptr_statistics_summary->current_time.minute = 6;
   sptr_statistics_summary->current_time.second = 6;
   sptr_statistics_summary->current_time.hundredth_of_second = 6;

   sptr_statistics_summary->boot_time.year = 6;
   sptr_statistics_summary->boot_time.month = 0;
   sptr_statistics_summary->boot_time.day = 6;
   sptr_statistics_summary->boot_time.week_day = 6;
   sptr_statistics_summary->boot_time.hour = 6;
   sptr_statistics_summary->boot_time.minute = 6;
   sptr_statistics_summary->boot_time.second = 6;
   sptr_statistics_summary->boot_time.hundredth_of_second = 6;


	sptr_statistics_summary->utilization = 0;	/* Not computed */
	sptr_statistics_summary->free_memory = 0;	/* ?? For now ?? */
	sptr_statistics_summary->dialin_users = ag.stats.total_dialin_users - ag.stats.inbound_connections;

#if 0
   /* Code removed by Naveen just to avoid displaying boot time
       and current time on 29-10-1996 */
	sptr_statistics_summary->boot_time = ag.boot_time;
	get_current_date_time(&sptr_statistics_summary->current_time);
#endif

	sptr_statistics_summary->busy_lines = ag.stats.number_of_connections;
	sptr_statistics_summary->dialin_calls = ag.stats.total_dialin_calls;
	sptr_statistics_summary->dialout_calls = ag.stats.total_dialout_calls;
	sptr_statistics_summary->tx_data_packets = sum_total_tx_data_packets();
	sptr_statistics_summary->rx_data_packets = sum_total_rx_data_packets();
	sptr_statistics_summary->lan_tx_data_bytes = sum_total_lan_tx_bytes();
	sptr_statistics_summary->lan_rx_data_bytes = sum_total_lan_rx_bytes();
	sptr_statistics_summary->line_tx_data_bytes = sum_total_line_tx_bytes();
	sptr_statistics_summary->line_rx_data_bytes = sum_total_line_rx_bytes();

	/* Convert endian */
	big_to_little_endian_ushort(&sptr_statistics_summary->utilization);
	big_to_little_endian_ulong(&sptr_statistics_summary->free_memory);
	big_to_little_endian_ushort(&sptr_statistics_summary->dialin_users);
	big_to_little_endian_ushort(&sptr_statistics_summary->boot_time.year);
	big_to_little_endian_ushort(&sptr_statistics_summary->current_time.year);
	big_to_little_endian_ulong(&sptr_statistics_summary->dialin_calls);
	big_to_little_endian_ulong(&sptr_statistics_summary->dialout_calls);
	big_to_little_endian_ulong(&sptr_statistics_summary->tx_data_packets);
	big_to_little_endian_ulong(&sptr_statistics_summary->rx_data_packets);
	big_to_little_endian_ulong(&sptr_statistics_summary->lan_tx_data_bytes);
	big_to_little_endian_ulong(&sptr_statistics_summary->lan_rx_data_bytes);
	big_to_little_endian_ulong(&sptr_statistics_summary->line_tx_data_bytes);
	big_to_little_endian_ulong(&sptr_statistics_summary->line_rx_data_bytes);

	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(RC_STATISTICS_SUMMARY) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_get_current_statistics(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	BYTE line_id;
	char user_name[USER_NAME_LENGTH];
	LINE_INFO_ENTRY *sptr_line_info;
	RC_CURRENT_STATISTICS *sptr_current_statistics;
	RC_GET_STATISTICS_REQUEST *sptr_statistics_request;
   enum AG_PORT_AVAILABILITY port_status;

	sptr_statistics_request = (RC_GET_STATISTICS_REQUEST *)&sptr_ag_packet->packet_type;
	line_id = sptr_statistics_request->channel_number;

/*	if (line_id >= ag.number_of_lines || ag.owned_by_module[line_id] == UNKNOWN_MODULE)
   {
		return FALSE;
   } Commented by Naveen on 1-11-1996 because second condition is not meaningful*/

   if (line_id >= ag.number_of_lines)
      return FALSE;

	/* From now in packet is out packet */
	sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET;
	sptr_current_statistics = (RC_CURRENT_STATISTICS *)&sptr_ag_packet->packet_type;
	memset(sptr_current_statistics, 0, sizeof(RC_CURRENT_STATISTICS));
	sptr_current_statistics->response_type = RESP_RC_CURRENT_STATISTICS;
	sptr_line_info = &ag.line_info_array[line_id];

	port_status = ag_get_port_availability(line_id);
	if (port_status == AG_PORT_DISABLED || port_status == AG_PORT_NOT_ASYNC)
	{
		sptr_current_statistics->line_status = WAN_PORT_DISABLED;
      sptr_current_statistics->user_address[0] = 0;
		sptr_current_statistics->user_name[0] = 0;
	}
	else
	if (sptr_line_info->line_status == AGLS_LINE_BUSY || 
			sptr_line_info->line_status == AGLS_CLEANING_UP ||
			sptr_line_info->line_status == AGLS_CONNECTING)
	{
		sptr_current_statistics->line_status = sptr_line_info->line_status; /*connect_mode + 2;*/ /* ?? What is this ?? */
		strncpy(sptr_current_statistics->user_name, get_ras_user_name(sptr_line_info->sptr_session_entry->user_entry, user_name),USER_NAME_LENGTH-1);
      sptr_current_statistics->user_name[USER_NAME_LENGTH] = 0;
		if (sptr_line_info->sptr_session_entry != NULL)
			fill_user_address(sptr_line_info->sptr_session_entry, sptr_current_statistics->user_address);

/*		sptr_current_statistics->connect_time = sptr_line_info->stats.connect_time; 
                  Commented by Naveen to avoid junk display on Remote Console
*/

      sptr_current_statistics->connect_time.year = 6;
      sptr_current_statistics->connect_time.month = 0;
      sptr_current_statistics->connect_time.day = 6;
      sptr_current_statistics->connect_time.week_day = 6;
      sptr_current_statistics->connect_time.hour = 6;
      sptr_current_statistics->connect_time.minute = 6;
      sptr_current_statistics->connect_time.second = 6;
      sptr_current_statistics->connect_time.hundredth_of_second = 6;
   
      calculate_throughputs(sptr_line_info);
		sptr_current_statistics->lan_tx_throughput = sptr_line_info->stats.last_lan_tx_bytes;
		sptr_current_statistics->lan_rx_throughput = sptr_line_info->stats.last_lan_rx_bytes;
		sptr_current_statistics->line_tx_throughput = sptr_line_info->stats.last_line_tx_bytes;
		sptr_current_statistics->line_rx_throughput = sptr_line_info->stats.last_line_rx_bytes;

		sptr_current_statistics->pending_tx_bytes = sptr_line_info->stats.pending_tx_bytes;
		sptr_current_statistics->pending_rx_bytes = sptr_line_info->stats.pending_rx_bytes;

		sptr_current_statistics->current_rx_data_packets = sptr_line_info->stats.current_rx_data_packets;
		sptr_current_statistics->current_tx_data_packets = sptr_line_info->stats.current_tx_data_packets;

		sptr_current_statistics->current_line_tx_bytes = sptr_line_info->stats.current_line_tx_bytes;
		sptr_current_statistics->current_line_rx_bytes = sptr_line_info->stats.current_line_rx_bytes;
		sptr_current_statistics->current_lan_tx_bytes = sptr_line_info->stats.current_lan_tx_bytes;
		sptr_current_statistics->current_lan_rx_bytes = sptr_line_info->stats.current_lan_rx_bytes;
	}

	if(port_status != OWNED_BY_AG && port_status == AG_PORT_IN_USE)
	{
		sptr_current_statistics->line_status = AGLS_LINE_BUSY;
      sptr_current_statistics->user_name[0] = 0;
      sptr_current_statistics->user_address[0] = 0;
		
      sptr_current_statistics->connect_time.year = 6;
      sptr_current_statistics->connect_time.month = 0;
      sptr_current_statistics->connect_time.day = 6;
      sptr_current_statistics->connect_time.week_day = 6;
      sptr_current_statistics->connect_time.hour = 6;
      sptr_current_statistics->connect_time.minute = 6;
      sptr_current_statistics->connect_time.second = 6;
      sptr_current_statistics->connect_time.hundredth_of_second = 6;
   
	}
/*	get_current_date_time(&sptr_current_statistics->current_time);
      Commented By Naveen to avoid junk display on Remote Console
*/
   sptr_current_statistics->current_time.year = 6;
   sptr_current_statistics->current_time.month = 0;
   sptr_current_statistics->current_time.day = 6;
   sptr_current_statistics->current_time.week_day = 6;
   sptr_current_statistics->current_time.hour = 6;
   sptr_current_statistics->current_time.minute = 6;
   sptr_current_statistics->current_time.second = 6;
   sptr_current_statistics->current_time.hundredth_of_second = 6;

/*	sptr_current_statistics->line_parameters = sptr_line_info->line_vars.line_parameters; 
      Commented by Naveen and next line was added*/

	fill_client_style_line_parameters_info(&sptr_current_statistics->line_parameters, &sptr_line_info->line_vars);

	sptr_current_statistics->idle_time = sptr_line_info->line_vars.idle_time / (ag.clock_ticks_per_second * 60);

	sptr_current_statistics->dialout_calls = sptr_line_info->stats.total_dialout_calls;
	sptr_current_statistics->dialin_calls = sptr_line_info->stats.total_dialin_calls;

	sptr_current_statistics->total_rx_data_packets = sptr_line_info->stats.total_rx_data_packets;
	sptr_current_statistics->total_tx_data_packets = sptr_line_info->stats.total_tx_data_packets;

	sptr_current_statistics->total_line_tx_bytes = sptr_line_info->stats.total_line_tx_bytes;
	sptr_current_statistics->total_line_rx_bytes = sptr_line_info->stats.total_line_rx_bytes;
	sptr_current_statistics->total_lan_tx_bytes = sptr_line_info->stats.total_lan_tx_bytes;
	sptr_current_statistics->total_lan_rx_bytes = sptr_line_info->stats.total_lan_rx_bytes;

	/* Change endian */
	big_to_little_endian_ushort(&sptr_current_statistics->connect_time.year);
	big_to_little_endian_ushort(&sptr_current_statistics->current_time.year);
	big_to_little_endian_ushort(&sptr_current_statistics->line_parameters.baud_divisor);

	big_to_little_endian_ulong(&sptr_current_statistics->idle_time);
	big_to_little_endian_ulong(&sptr_current_statistics->dialout_calls);
	big_to_little_endian_ulong(&sptr_current_statistics->dialin_calls);
	big_to_little_endian_ulong(&sptr_current_statistics->lan_tx_throughput);
	big_to_little_endian_ulong(&sptr_current_statistics->lan_rx_throughput);
	big_to_little_endian_ulong(&sptr_current_statistics->line_tx_throughput);
	big_to_little_endian_ulong(&sptr_current_statistics->line_rx_throughput);
	big_to_little_endian_ulong(&sptr_current_statistics->pending_tx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->pending_rx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->current_rx_data_packets);
	big_to_little_endian_ulong(&sptr_current_statistics->current_tx_data_packets);
	big_to_little_endian_ulong(&sptr_current_statistics->current_line_tx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->current_line_rx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->current_lan_tx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->current_lan_rx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->total_tx_data_packets);
	big_to_little_endian_ulong(&sptr_current_statistics->total_rx_data_packets);
	big_to_little_endian_ulong(&sptr_current_statistics->total_lan_tx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->total_lan_rx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->total_line_tx_bytes);
	big_to_little_endian_ulong(&sptr_current_statistics->total_line_rx_bytes);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(RC_CURRENT_STATISTICS) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_reset_line(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	/* ?? We are supposed to re-init the port -- ignoring for now */
	return FALSE;
}

STATIC enum BOOLEAN rc_validate_password(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	/* ?? We currently do not accept or support a password */

	return FALSE;
}

STATIC enum BOOLEAN rc_return_status(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	BYTE *user_entry;
	char user_name[USER_NAME_LENGTH];
	BYTE next_line_id;
	USHORT lines_considered;
	LINE_INFO_ENTRY *sptr_line_info;/* Change by Naveen from LINE_INFO_ARRAY to LINE_INFO_ENTRY*/
	RC_STATUS_REQUEST status_request;
	LINE_STAT_INFO_TYPE *sptr_line_status;
	RC_STATUS_RESPONSE *sptr_status_response;
	enum AG_PORT_AVAILABILITY port_status;

	/* ?? Stuff may've to be different as the requestor is now the
	** ?? supervisor. See the RNAG code.
	*/
	status_request = *(RC_STATUS_REQUEST *)&sptr_ag_packet->packet_type;
	status_request.user_name[USER_NAME_LENGTH - 1] = '\0';

	/* From now in packet will be used for out purposes */
	sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET;
	sptr_status_response = (RC_STATUS_RESPONSE *)&sptr_ag_packet->packet_type;
	memset(sptr_status_response, 0, ((sizeof(RC_STATUS_RESPONSE) - sizeof(LINE_STAT_INFO_TYPE)) + (MAX_LINES_PER_STATUS_PACKET * sizeof(LINE_STAT_INFO_TYPE))));
	sptr_status_response->response_type = RESP_RC_STATUS; /* This line added by Naveen on 17-10-1996 */
	lines_considered = 0;
	next_line_id = status_request.last_line_id;
	if (next_line_id < ag.number_of_lines)
		sptr_line_info = &ag.line_info_array[next_line_id];
/*	sptr_line_status = ((BYTE *)sptr_ag_packet) + sizeof(BYTE) + sizeof(RC_STATUS_RESPONSE) - sizeof(LINE_STAT_INFO_TYPE); */
	sptr_line_status = &sptr_status_response->line_status_array[0];
	while ((next_line_id < ag.number_of_lines) && (lines_considered < MAX_LINES_PER_STATUS_PACKET))
	{
		port_status = ag_get_port_availability(next_line_id);
		memcpy(sptr_line_status->general_name, sptr_line_info->line_vars.general_name, GENERAL_NAME_LENGTH);
		memcpy(sptr_line_status->specific_name, sptr_line_info->line_vars.specific_name, SPECIFIC_NAME_LENGTH);

		if (port_status == AG_PORT_DISABLED || port_status == AG_PORT_NOT_ASYNC)
		{
			sptr_line_status->line_status = WAN_PORT_DISABLED;
			sptr_line_status->line_owner[0] = 0;
		}
		else
		if (sptr_line_info->line_status == AGLS_LINE_BUSY)
		{
			sptr_line_status->line_status = AGLS_LINE_BUSY;
			sptr_line_status->line_class = sptr_line_info->connect_mode;
			if (sptr_line_info->sptr_session_entry->user_entry != NULL)
         {
				strncpy (sptr_line_status->line_owner, get_ras_user_name(sptr_line_info->sptr_session_entry->user_entry, user_name), USER_NAME_LENGTH-1);
            sptr_line_status->line_owner[USER_NAME_LENGTH-1] = 0 ;
         }
		}
		else
		{
			sptr_line_status->line_status = AGLS_LINE_FREE;
			sptr_line_status->line_class = sptr_line_info->line_vars.line_type;
		}
		user_entry = is_valid_ras_user(status_request.user_name);
		if (user_entry == NULL)
			sptr_line_status->access = FALSE;
		else
			sptr_line_status->access = has_dialout_access(user_entry, next_line_id);
		if (!(get_ras_number_of_users()) && port_status == AG_PORT_AVAILABLE)
		{
			sptr_line_status->access = TRUE;
		}
		fill_client_style_line_parameters_info(&sptr_line_status->line_parameters, &sptr_line_info->line_vars);
		big_to_little_endian_ushort(&sptr_line_status->line_parameters.baud_divisor);

		lines_considered++;
		next_line_id++;
		sptr_line_status++;
		sptr_line_info++;
	}

	sptr_status_response->number_of_lines = ag.number_of_lines;
	sptr_status_response->last_line_id = next_line_id;
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)((sizeof(RC_STATUS_RESPONSE) - sizeof(LINE_STAT_INFO_TYPE)) + (lines_considered * sizeof(LINE_STAT_INFO_TYPE)) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_get_inbound_list(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
   int i = 0;
	RC_INBOUND_LIST_RESPONSE* sptr_inbound_response;
   LINE_INFO_ENTRY* sptr_line_info;
	SESSION_TABLE_ENTRY *sptr_inbound_session_entry;
	char user_name_buf[41];			/* Why 41, huh? */

   sptr_line_info = &ag.line_info_array[0];
	sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET;

	sptr_inbound_response= (RC_INBOUND_LIST_RESPONSE*)&sptr_ag_packet->packet_type;
	memset(sptr_inbound_response, 0, sizeof(RC_INBOUND_LIST_RESPONSE) - sizeof(RC_INBOUND_LIST_DIR_TYPE) + (8)*sizeof(RC_INBOUND_LIST_DIR_TYPE));

	sptr_inbound_response->response_type = RESP_RC_INBOUND_LIST;
   sptr_inbound_response->last_packet = 1;

	for (i = sptr_line_info->next_host_index; i < sptr_line_info->top_host_index + INBOUND_HOSTS_LIST_SIZE; i++)
   {
   	sptr_inbound_session_entry = get_ith_element_from_inbound_list(sptr_line_info, i);
   	if (sptr_inbound_session_entry == NULL)
         break;
     	get_ras_user_name(sptr_inbound_session_entry->user_entry, user_name_buf);
   	user_name_buf[USER_NAME_LENGTH - 1] = '\0';		/* We support 16 char name only */
      strcpy(sptr_inbound_response->inbound_list_array[i].host_name, user_name_buf);
      sprintf(sptr_inbound_response->inbound_list_array[i].network_number, "%08X",get_client_network_number(sptr_inbound_session_entry));
      sprintf(sptr_inbound_response->inbound_list_array[i].node_number, "%08X%04X",
		      	get_client_node_number_ulong(sptr_inbound_session_entry),
			      get_client_node_number_ushort(sptr_inbound_session_entry)
             );
      sprintf(sptr_inbound_response->inbound_list_array[i].host_status,"%s",(sptr_inbound_session_entry->session_status == AG_SESS_ACTIVE) ? "FREE" : "BUSY");
      sptr_inbound_response->inbound_list_array[i].network_number[NETWORK_NUMBER_LENGTH - 1] = '\0';
      sptr_inbound_response->inbound_list_array[i].node_number[NODE_NUMBER_LENGTH - 1] = '\0';
      sptr_inbound_response->inbound_list_array[i].host_status[HOST_STATUS_LENGTH] = '\0';
   }
   sptr_inbound_response->number_of_entries = i;
	change_endian(sptr_ag_packet);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(RC_INBOUND_LIST_RESPONSE) - sizeof(RC_INBOUND_LIST_DIR_TYPE) + (8)*sizeof(RC_INBOUND_LIST_DIR_TYPE) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_delete_inbound(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
/*   delete_inbound_session_from_line(LINE_INFO_ENTRY *sptr_line_info, SESSION_TABLE_ENTRY *sptr_session_entry_to_delete)*/
/*   delete_inbound_session_from_line(,sessions_awaiting_inbound);*/

   RC_DELETE_INBOUND_REQUEST* sptr_delete_inbound_request;
   BYTE user_name[USER_NAME_LENGTH];
   BYTE network_number[NETWORK_NUMBER_LENGTH];
   BYTE node_number[NODE_NUMBER_LENGTH];
   LINE_INFO_ENTRY* sptr_line_info;
	SESSION_TABLE_ENTRY *sptr_inbound_session_entry;
   int i;
	char user_name_buf[41];			/* Why 41, huh? */

   sptr_delete_inbound_request = (RC_DELETE_INBOUND_REQUEST*)&sptr_ag_packet->packet_type;
   sptr_line_info = &ag.line_info_array[0];

	for (i = sptr_line_info->next_host_index; i < sptr_line_info->top_host_index + INBOUND_HOSTS_LIST_SIZE; i++)
   {
   	sptr_inbound_session_entry = get_ith_element_from_inbound_list(sptr_line_info, i);
   	if (sptr_inbound_session_entry == NULL)
         break;
     	get_ras_user_name(sptr_inbound_session_entry->user_entry, user_name_buf);
   	user_name_buf[USER_NAME_LENGTH - 1] = '\0';		/* We support 16 char name only */
      strcpy(user_name, user_name_buf);
      sprintf(network_number, "%08X",get_client_network_number(sptr_inbound_session_entry));
      sprintf(node_number, "%08X%04X",
		      	get_client_node_number_ulong(sptr_inbound_session_entry),
			      get_client_node_number_ushort(sptr_inbound_session_entry)
             );
      network_number[NETWORK_NUMBER_LENGTH - 1] = '\0';
      node_number[NODE_NUMBER_LENGTH - 1] = '\0';
      if ((strcmp(user_name,sptr_delete_inbound_request->user_name) == 0)
           &&
         (strcmp(network_number,sptr_delete_inbound_request->network_number) == 0)
           &&
         (strcmp(node_number,sptr_delete_inbound_request->node_number) == 0))
         break;
   }
   if (sptr_inbound_session_entry)
      delete_inbound_session_from_line(sptr_line_info, sptr_inbound_session_entry);
      
	return FALSE;
}

STATIC enum BOOLEAN rc_get_server_configuration(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	RC_SERVER_CONFIG *sptr_server_configuration;

	sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET;
	sptr_server_configuration = (RC_SERVER_CONFIG *)&sptr_ag_packet->packet_type;
	memset(sptr_server_configuration, 0, sizeof(RC_SERVER_CONFIG));
	sptr_server_configuration->response_type = RESP_RC_SERVER_CONFIGURATION;
	change_endian(sptr_ag_packet);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(RC_SERVER_CONFIG) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_change_server_configuration(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
/*	change_endian(sptr_ag_packet);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(NAME_VALIDATE_RESP_TYPE) + sizeof(BYTE)), cb_ptr);*/
	return FALSE;
}

STATIC enum BOOLEAN rc_return_configuration_file(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
   RC_FILE_REQUEST *sptr_file_request ;
   int number_of_cards = 0 ;
   static int rem_bytes, number_of_packets,total_file_size,number_of_users;
   USER_INFO_TYPE user_info ;
   RC_FILE_RESPONSE *sptr_file_response ;
   FIXED_CONFIG_FILE_HEADER *sptr_file_header ;
   ULONG comm_offset, gen_offset, user_info_offset ;
   USHORT current_packet_number, temp_ushort ;
   int number_of_bytes_filled, user_to_start_with, offset_to_start_with ;
   RAS_USER_DATABASE_RECORD *user_record;
   int number_of_bytes_to_be_filled;

   sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET ;
   sptr_file_request = (RC_FILE_REQUEST *)&sptr_ag_packet->packet_type ;
   sptr_file_response = (RC_FILE_RESPONSE *)&sptr_ag_packet->packet_type;
   current_packet_number = little_to_big_endian_ushort(&sptr_file_request->packet_number) ;

   if (current_packet_number == 0)
   {
      /* First request from remote console */
      number_of_users = get_ras_number_of_users () ;
      total_file_size = (3 * 4) /* offsets */
                        + sizeof (GENERAL_INFO) /* General info */
                        + (1 + 1) /* Port type, number of cards */
                        + (5 * number_of_cards)
                        + (0) /* Line info for each port in each card */
                        + 2 /* number of users */
                        + (number_of_users * sizeof (USER_INFO_TYPE)) ;
      number_of_packets = total_file_size / MAX_FILE_PKT ;
      rem_bytes = total_file_size % MAX_FILE_PKT ;
   }

   sptr_file_response->response_type = RESP_RC_FILE_RETURN ;
   temp_ushort = current_packet_number + 1 ;
   sptr_file_response->packet_number = little_to_big_endian_ushort (&temp_ushort);
   temp_ushort = rem_bytes ;
   sptr_file_response->remaining_bytes =  little_to_big_endian_ushort (&temp_ushort);
   sptr_file_response->error_in_read = 0 ;
   if (current_packet_number == number_of_packets)
   {
      sptr_file_response->packet_number = 0 ;
   }

   if (current_packet_number == 0)
   {
      /*
            Fill up offsets
            general information
            communication information
      */
      sptr_file_header = (FIXED_CONFIG_FILE_HEADER *)&sptr_file_response->buffer[0] ;

      gen_offset = 12 ;
      comm_offset = 12 + sizeof(GENERAL_INFO) ;
      user_info_offset = 12 + sizeof(GENERAL_INFO) + 2 ;

      sptr_file_header->general_info_offset = gen_offset ;
      little_to_big_endian_ulong (&sptr_file_header->general_info_offset) ;
      /* sptr_file_header->general_info_offset = little_to_big_endian_ulong (&gen_offset) ; */
      sptr_file_header->communication_info_offset = little_to_big_endian_ulong (&comm_offset) ;
      sptr_file_header->user_info_offset = little_to_big_endian_ulong (&user_info_offset) ;

      temp_ushort = number_of_users ;
      sptr_file_header->number_of_users = little_to_big_endian_ushort (&temp_ushort) ;

      sptr_file_header->port_type =
      sptr_file_header->number_of_cards = 0 ;
   
      memset(&sptr_file_header->general_info, 0,sizeof(sptr_file_header->general_info));
    }
   if (current_packet_number == 0)
   {
      user_to_start_with = 0 ;
      offset_to_start_with = 0 ;
      number_of_bytes_filled = 214 ;
      number_of_bytes_to_be_filled = sizeof(USER_INFO_TYPE);
   }
   else
   {
      number_of_bytes_filled = 0 ;
      user_to_start_with = ((current_packet_number-1)*400 + 186)/102;
      offset_to_start_with = ((current_packet_number-1)*400 + 186)%102;
      number_of_bytes_to_be_filled = sizeof(USER_INFO_TYPE) - offset_to_start_with;
   }
    while (1)
   {
      if (number_of_bytes_filled >= MAX_FILE_PKT || !(number_of_users)
             || user_to_start_with >= number_of_users)
            break;
      user_record = get_ras_user_entry_from_index (user_to_start_with) ;
      if (! user_record) 
         break;
      memset (&user_info, 0, sizeof (USER_INFO_TYPE)) ;
      memcpy(&user_info.user_name[0], &user_record->user_name[0], USER_NAME_LENGTH-1);
      memcpy(&user_info.password[0], &user_record->password[0], PASSWORD_LENGTH-1);
      memcpy(&user_info.callback_number[0], &user_record->call_back_number[0], CALLBACK_NUMBER_LENGTH-1);
      user_info.callback_delay = user_record->call_back_delay;
      user_info.enter_number = !(user_record->call_back_security);
      user_info.line_permissions = user_record->dial_in_port_mask & user_record->dial_out_port_mask;
      user_info.mode_permissions = 0xff;

      little_to_big_endian_ushort (&user_info.callback_delay) ;
      little_to_big_endian_ulong (&user_info.line_permissions) ;
      memcpy (&sptr_file_response->buffer[0] + number_of_bytes_filled,
              ((BYTE *)&user_info) + offset_to_start_with,
                number_of_bytes_to_be_filled);
      offset_to_start_with = 0;
      user_to_start_with++;
      number_of_bytes_filled += number_of_bytes_to_be_filled;
      number_of_bytes_to_be_filled = MIN (sizeof(USER_INFO_TYPE), (MAX_FILE_PKT - number_of_bytes_filled)); 
   }

	change_endian(sptr_ag_packet);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(RC_FILE_RESPONSE) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_change_configuration_file(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	change_endian(sptr_ag_packet);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(NAME_VALIDATE_RESP_TYPE) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_reset_sbc_processor(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
/*  	change_endian(sptr_ag_packet);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(NAME_VALIDATE_RESP_TYPE) + sizeof(BYTE)), cb_ptr);*/
	return FALSE;
}

STATIC enum BOOLEAN rc_validate_user(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
   RC_USER_REQ_TYPE  *sptr_req_type;
   RC_USER_RESP_TYPE *sptr_resp_type;

   sptr_ag_packet->packet_class = AG_RC_RESPONSE_PACKET;
   sptr_req_type = (RC_USER_REQ_TYPE*)&sptr_ag_packet->packet_type;
   sptr_resp_type = (RC_USER_RESP_TYPE*)&sptr_ag_packet->packet_type;

   sptr_resp_type->response_type = 19;
   sptr_resp_type->ok_or_not = 1;
   change_endian(sptr_ag_packet);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(RC_USER_RESP_TYPE) + sizeof(BYTE)), cb_ptr);
	return TRUE;
}

STATIC enum BOOLEAN rc_unlock_user(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
	return FALSE;
}

STATIC enum BOOLEAN rc_save_changes_to_disk(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *cb_ptr)
{
/*	change_endian(sptr_ag_packet);
	send_network_packet(sptr_session_entry, sptr_ag_packet, (USHORT)(sizeof(NAME_VALIDATE_RESP_TYPE) + sizeof(BYTE)), cb_ptr);
	return TRUE;*/
   return FALSE;
}

/* ----------- Support routines ----------------- */

ULONG sum_total_tx_data_packets()
{
	BYTE i;
	ULONG total_packets = 0;

	for (i = 0; i < ag.number_of_lines; i++)
		total_packets += ag.line_info_array[i].stats.total_tx_data_packets;

	return total_packets;
}

ULONG sum_total_rx_data_packets()
{
	BYTE i;
	ULONG total_packets = 0;

	for (i = 0; i < ag.number_of_lines; i++)
		total_packets += ag.line_info_array[i].stats.total_rx_data_packets;

	return total_packets;
}

ULONG sum_total_lan_tx_bytes()
{
	BYTE i;
	ULONG total_bytes = 0;

	for (i = 0; i < ag.number_of_lines; i++)
		total_bytes += ag.line_info_array[i].stats.total_lan_tx_bytes;

	return total_bytes;
}

ULONG sum_total_lan_rx_bytes()
{
	BYTE i;
	ULONG total_bytes = 0;

	for (i = 0; i < ag.number_of_lines; i++)
		total_bytes += ag.line_info_array[i].stats.total_lan_rx_bytes;

	return total_bytes;
}

ULONG sum_total_line_tx_bytes()
{
	BYTE i;
	ULONG total_bytes = 0;

	for (i = 0; i < ag.number_of_lines; i++)
		total_bytes += ag.line_info_array[i].stats.total_line_tx_bytes;

	return total_bytes;
}

ULONG sum_total_line_rx_bytes()
{
	BYTE i;
	ULONG total_bytes = 0;

	for (i = 0; i < ag.number_of_lines; i++)
		total_bytes += ag.line_info_array[i].stats.total_line_rx_bytes;

	return total_bytes;
}

STATIC void calculate_throughputs(LINE_INFO_ENTRY *sptr_line_info)
{
	sptr_line_info->stats.last_lan_tx_bytes = sptr_line_info->stats.lan_tx_bytes;
	sptr_line_info->stats.lan_tx_bytes = 0;
	sptr_line_info->stats.last_lan_rx_bytes = sptr_line_info->stats.lan_rx_bytes;
	sptr_line_info->stats.lan_rx_bytes = 0;
	sptr_line_info->stats.last_line_tx_bytes = sptr_line_info->stats.line_tx_bytes;
	sptr_line_info->stats.line_tx_bytes = 0;
	sptr_line_info->stats.last_line_rx_bytes = sptr_line_info->stats.line_rx_bytes;
	sptr_line_info->stats.line_rx_bytes = 0;

	ag.start_statistics_timer = TRUE;
}

/* -- END CODE -------------------------------------------------------- */


