/* AGRX.C -- Code handling receives from the serial side
** By: Sanjay
** Start: 23, July, 1996
** Done: 30, August, 1996
** Modifications : sudha 15-Oct-1999. Changes in functions serial_rx_callback(),
**						 send_delayed_serial_rx_packets() for AG bug. ( AG used to
**						 give frequent errors & less throughput at higher bauds ).
*/

#include "rtrstd.h"

#include "kag.h"

#include "vagstr.h"
#include "vag.h"

#include "agpkttyp.h"
#include "agutil.h"
#include "agnetif.h"
#include "agrx.h"
#include "aginbsup.h"
#include "agsess.h"
void send_delayed_serial_rx_packets(SESSION_TABLE_ENTRY *sptr_session_entry);

/* -- CODE ------------------------------------------------------------- */

void serial_rx_callback(USHORT line_id, SESSION_TABLE_ENTRY *sptr_session_entry, BYTE *sptr_rx_data, USHORT rx_data_size)
{
	USHORT data_size, send_status = 1;
	LINE_INFO_ENTRY *sptr_line_info;
	UNION_AG_PACKET *sptr_ag_packet;

#ifdef DEBUG
/*	printf("AG: Received a serial packet, port %u, size %u\n\r", line_id, rx_data_size); */
#endif /* DEBUG */
	
	sptr_line_info = &ag.line_info_array[line_id];

	if (ag.owned_by_module[line_id] == INBOUND_MODULE && sptr_line_info->inbound_init_on == TRUE)
	{
		/* Some special handling during the init phase of inbound alone */

		serial_input_during_inbound_init(sptr_line_info, sptr_rx_data, rx_data_size);

		ag.fptr_rx_complete(line_id, sptr_rx_data, send_status);
		return;
	}

/* Naveen 01/01/1997 */

	if (sptr_line_info->line_status != AGLS_LINE_BUSY)
	{
		ag.fptr_rx_complete(line_id, sptr_rx_data, send_status);
		return;
	}

/* Naveen 01/01/1997 */

	if (sptr_session_entry == NULL)
	{
		ag.fptr_rx_complete((USHORT)line_id, sptr_rx_data, send_status);
		return;
	}

	if (sptr_session_entry->session_status == AG_SESS_ABORTED)
	{
		ag.fptr_rx_complete((USHORT)line_id, sptr_rx_data, send_status);
		return;
	}

	if (ag.fptr_msm_init_phase_callback[line_id] != NULL)
	{
		/* Modem init is going on. During this time, data is to go only to
		** the modem state machine module.
		*/
		ag.fptr_msm_init_phase_callback[line_id](line_id, sptr_rx_data, rx_data_size);
		ag.fptr_rx_complete(line_id, sptr_rx_data, send_status);

		return;
	}

/* 6 March 1999.... */

	/* Explanation. We need to send the packet to the client tcp socket now. 
	** But if during previous calls, we had queued up some packets here 
	** (since the client could not receive it at that time), and those
	** packets have not yet been sent out , we need to continue queueing so 
	** that packets are not transmitted out of sequence.
	** End of explanation. 
	*/

	if (are_there_retained_serial_rx_packets(sptr_session_entry) == TRUE)
	{
		/* Take a shot at sending the retained entries here and now. */

		send_delayed_serial_rx_packets(sptr_session_entry);
		
		if (are_there_retained_serial_rx_packets(sptr_session_entry) == TRUE)
		{
			/* Too bad -- serial rx is still stuck. So queue up. */
			send_status = 0;
#ifdef DEBUG_INFO
         printf("\n\r AGRX0: send_status is %d", send_status); 
#endif
		}
		else
		{
			/* Good, we managed to flush the retained list, so try to send.
			** If send fails, then again retain.
			*/
			send_status = 1;
#ifdef DEBUG_INFO
printf("\n\r AGRX: send_status is %d", send_status);
#endif
		}

/* sudha 15-Oct-1999. 
Due to this logical error only, we were getting crc error in AG at higher
bauds & also when congestion is there at all levels, starting from winmcsi
client sending a window size of zero, which first affects tcp buffer from
becoming full, which then affects & prevents the application in pumping data 
into tcp buffer. So, we need to queue this data at the application level
in order to maintain the sequential order. Even before, we notify the serial
side, not to send, any more data packet to application, as the application is 
unable to send it to tcp buffer, the serial side will eventually get few more 
data packets & those will be given to the application. This scenario, we were 
not taking into account previously & we simply assumed that, by the time, we 
send & notify, the serial side, not to send any data packet, we won't get any 
data packet. This assumption was totally wrong, due to which we were losing 
more than a couple of packets. So now, changed the code to retain those pkts 
in order. 
*/
		if ( sptr_rx_data != NULL )
		{
			sptr_ag_packet = (UNION_AG_PACKET *)(((BYTE *)sptr_rx_data) - (sizeof(DATA_TYPE) - sizeof(BYTE) + sizeof(BYTE)));
			sptr_ag_packet->packet_class = AG_DATA_PACKET;
			sptr_ag_packet->packet_type.data_packet.channel_number = line_id;
			sptr_ag_packet->packet_type.data_packet.packet_size = rx_data_size;

			/* Statistics update */
			update_line_line_rx_statistics(line_id, rx_data_size);

			/* Reset the inactivity timer */
			sptr_line_info->inactivity_timer = sptr_line_info->line_vars.idle_time;

			data_size = rx_data_size + sizeof(DATA_TYPE) - sizeof(BYTE) + sizeof(BYTE);
			change_endian(sptr_ag_packet);
			retain_unsent_packet(sptr_session_entry,sptr_ag_packet,data_size);
		}

/* ...sudha 15-Oct-1999. */

		ag.fptr_rx_complete(line_id, sptr_rx_data, send_status);
		return;
	}

/* ....6 March 1999 */

	/* Create space for the MCSI header by moving pointer back. The serial
	** driver has reserved space for this.
	*/

	if ( sptr_rx_data != NULL )
	{
		sptr_ag_packet = (UNION_AG_PACKET *)(((BYTE *)sptr_rx_data) - (sizeof(DATA_TYPE) - sizeof(BYTE) + sizeof(BYTE)));
		sptr_ag_packet->packet_class = AG_DATA_PACKET;
		sptr_ag_packet->packet_type.data_packet.channel_number = line_id;
		sptr_ag_packet->packet_type.data_packet.packet_size = rx_data_size;

		/* Statistics update */
		update_line_line_rx_statistics(line_id, rx_data_size);

		/* Reset the inactivity timer */
		sptr_line_info->inactivity_timer = sptr_line_info->line_vars.idle_time;

		data_size = rx_data_size + sizeof(DATA_TYPE) - sizeof(BYTE) + sizeof(BYTE);
		change_endian(sptr_ag_packet);
		if (send_serial_rx_packet_on_network(sptr_session_entry, sptr_ag_packet, data_size) == FAIL)
		{
/* printf("\n\rAGRX: Send packet failed."); */
			send_status = 0;
			ag.fptr_rx_complete(line_id, sptr_rx_data, send_status);
		}
	}
}

/* 6 March 1999.... */

void send_delayed_serial_rx_packets(SESSION_TABLE_ENTRY *sptr_session_entry)
{
/* sudha 15-Oct-1999. Added vars unsent_size, ptr_unsent_packet_data, to keep
track of the amount of data sent & the data pointer of retained packets */

	USHORT data_size, unsent_size = 0;
	RETAINED_TX_PACKET *sptr_retained_entry;
	BYTE *ptr_unsent_packet_data; 

	sptr_retained_entry = (RETAINED_TX_PACKET *)get_entry_from_list((LINK *)&sptr_session_entry->retained_tx_packet_links);

	while (sptr_retained_entry != NULL)
	{
		data_size = sptr_retained_entry->data_size;

/* sudha 15-Oct-1999. Passing one more var "unsent_size" to get the unsent
data size correctly */
		if (send_retained_serial_rx_packet_on_network(sptr_session_entry, sptr_retained_entry->sptr_ag_packet_data, data_size, &unsent_size) == FAIL)
		{
			/* Delay some more */
#ifdef DEBUG_INFO
         printf("\n\r AGRX1: failed in send_delayed_serial_rx... ");   
#endif
/* sudha 15-Oct-1999...
The scheme of retaining retained packets, is slightly changed now. Instead of 
mallocing each & every time, for a single retain packet, since its data size 
& data pointer keeps changing, whenever we try to send them to tcp buffer, we 
can just re-adjust the data pointer to point to each & every time, exactly from 
where it needs to be sent.
*/
			if (( unsent_size != 0 ) && ( unsent_size != data_size))
			{
				sptr_retained_entry->data_size = unsent_size;
				ptr_unsent_packet_data = sptr_retained_entry->sptr_ag_packet_data + data_size - unsent_size;
				memcpy(sptr_retained_entry->sptr_ag_packet_data, ptr_unsent_packet_data, unsent_size);
			}
/* ...sudha 15-Oct-1999. */

			add_entry_to_front_of_list((LINK *)&sptr_session_entry->retained_tx_packet_links, (LINK *)&sptr_retained_entry->links);

   		return;
		}

		else
		{
#ifdef DEBUG_INFO
printf ("\n\n send_delayed_serial_rx_packets : sptr_retained_entry address to be freed is %x",sptr_retained_entry); 
#endif
			free(sptr_retained_entry->sptr_ag_packet_data);
			sptr_retained_entry->sptr_ag_packet_data = NULL;
			sptr_retained_entry->data_size = 0;
			free(sptr_retained_entry);
		}
		sptr_retained_entry = (RETAINED_TX_PACKET *)get_entry_from_list((LINK *)&sptr_session_entry->retained_tx_packet_links);

	}
}

/* .... 6 March 1999 */
/* -- END CODE -------------------------------------------------------- */
