/* AGSESS.C -- Session management code 
** By: Sanjay
** Start: 11, July, 1996
** Done: 30, August, 1996
** Modifications : sudha 15-Oct-1999. Removed one unwanted parameter "is_called
**						 from_retained" as well as its reference in retain_unsent_packet() 
**						 function as we have changed the scheme of retaining unsent 
**						 packets slightly. 	
*/

#include "rtrstd.h"
#include <serial.h>
#include <msm.h>
#include <wanmgr.h>

#include "kag.h"

#include "vagstr.h"
#include "vag.h"

#include "agpkttyp.h"
#include "agutil.h"
#include "agnetif.h"
#include "agline.h"
#include "agtx.h"
#include "agsess.h"
#include "agdebug.h"
#include "aginbsup.h"

/* Local Prototypes */
USHORT display_retained_unsent_packets(SESSION_TABLE_ENTRY *sptr_session_entry);

/* sudha 15-Oct-1999. Removed the parameter "is_called_from_retained" as it is
no longer needed, due to change in scheme. */
enum TEST retain_unsent_packet(SESSION_TABLE_ENTRY *sptr_session_entry,BYTE *sptr_ag_packet_data,USHORT unsent_data_size);

/* -- CODE ------------------------------------------------------------- */

SESSION_TABLE_ENTRY *get_free_session_entry()
{
	SESSION_TABLE_ENTRY *sptr_session_entry;

	if (ag.stats.number_of_sessions >= ag.max_sessions)
		return NULL; 

	sptr_session_entry = (SESSION_TABLE_ENTRY *)malloc(sizeof(SESSION_TABLE_ENTRY));

	if (sptr_session_entry == NULL)
	{
		ag_printf(AG_SESS_PRINTF, "AG: No memory for session entry\n\r");
      printf ("\n\n get_free_session_entry 1 : No memory for session entry\n");
		return NULL;
	}

	memset(sptr_session_entry, 0, sizeof(SESSION_TABLE_ENTRY));

	if (allocate_protocol_structure(sptr_session_entry) == FAIL)
	{
		ag_printf(AG_SESS_PRINTF, "AG: No memory for session entry\n\r");
		free(sptr_session_entry);
      sptr_session_entry = NULL;
		return NULL;
	}
	sptr_session_entry->session_status = AG_SESS_CLOSED;

										/* A unique session identifier */
	sptr_session_entry->session_ID = ag.next_session_id_to_use;	
	ag.next_session_id_to_use++;		/* Keep incrementing and wrap */

	return sptr_session_entry;
}

SESSION_TABLE_ENTRY *find_session_using_connection_ID(ULONG connection_ID)
{
	SESSION_TABLE_ENTRY *sptr_session_entry;


	sptr_session_entry = (SESSION_TABLE_ENTRY *)get_pointer_to_first_entry_in_list((LINK *)&ag.session_entries_list);
	while (sptr_session_entry != NULL)
	{
		if (sptr_session_entry->connection_ID == connection_ID)
			break;
		sptr_session_entry = (SESSION_TABLE_ENTRY *) get_pointer_to_next_entry_in_list ((LINK *)&sptr_session_entry->links);
 	}
	return sptr_session_entry;
}

void free_session_entry(SESSION_TABLE_ENTRY *sptr_session_entry)
{
#ifdef DEBUG
/*	if (sptr_session_entry == NULL || ag.stats.number_of_sessions == 0)
	{
		printf("AG: Bad request to free_session_entry()\n\r");
	} */
#endif /* DEBUG */

   if (sptr_session_entry == NULL)
	{
		printf("AG: Bad request to free_session_entry()\n\r");
      return;
	}

   if (ag.stats.number_of_sessions != 0)
	   ag.stats.number_of_sessions--;

	free_protocol_structure(sptr_session_entry);
   sptr_session_entry->protocol_specific_info = NULL;

   free(sptr_session_entry);
   sptr_session_entry = NULL;
}

enum BOOLEAN are_there_retained_packets(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	RETAINED_RX_PACKET *sptr_retained_entry;

	sptr_retained_entry = (RETAINED_RX_PACKET *)get_pointer_to_first_entry_in_list((LINK *)&sptr_session_entry->retained_packet_links);
	if (sptr_retained_entry != NULL)
		return TRUE;

   return FALSE;
}


/* 6 March 1999.... */
/* sudha 15-Oct-1999. removed one parameter "is_called_from_retained" */
enum TEST retain_unsent_packet(SESSION_TABLE_ENTRY *sptr_session_entry,BYTE *sptr_ag_packet_data,USHORT unsent_data_size)
{
	RETAINED_TX_PACKET *sptr_retained_entry;
	
	sptr_retained_entry = (RETAINED_TX_PACKET *)malloc(sizeof(RETAINED_TX_PACKET));
	if (sptr_retained_entry == NULL)
	{
		/* We can't really do anything in this case */
		ag_printf(AG_ALARM_PRINTF, "AG: Insufficient memory to buffer packets!\n\r");

		return FAIL;
	}

/* sudha 15-Oct-1999. Moved this memset() after checking for malloc NULL. */
	memset(sptr_retained_entry, 0, sizeof(RETAINED_TX_PACKET));

#ifdef DEBUG_INFO
   printf("\n\rAGSESS : retain_txed_packet : sptr_retained_entry malloced address is %x",sptr_retained_entry); 
#endif

	sptr_retained_entry->sptr_ag_packet_data = (BYTE *)malloc(unsent_data_size);
	if (sptr_retained_entry->sptr_ag_packet_data == NULL)
	{
		/* We can't really do anything in this case */
		ag_printf(AG_ALARM_PRINTF, "AG: Insufficient memory to buffer retained packets!\n\r");
		return FAIL;
	}
	memcpy(sptr_retained_entry->sptr_ag_packet_data, sptr_ag_packet_data, unsent_data_size);

	sptr_retained_entry->data_size = unsent_data_size;

#ifdef DEBUG_INFO
printf("\n\rAGSESS : sptr_ag_packet_data is %x", sptr_retained_entry->sptr_ag_packet_data);
printf("\n\rAGSESS : data1 %c, data2 %c, datl1 %c, datal %c", sptr_retained_entry->sptr_ag_packet_data[0],
sptr_retained_entry->sptr_ag_packet_data[1], sptr_retained_entry->sptr_ag_packet_data[unsent_data_size-2],
sptr_retained_entry->sptr_ag_packet_data[unsent_data_size-1]);
#endif

/* sudha 15-Oct-1999. Removed the if else condition part, in case, we are 
retaining an already retained packet. B'cos we have changed the scheme now.
Instead of mallocing again to retain an already retained packet, we can just
re-adjust the data pointer to point to exactly, where we want to retain 
again. */
	add_entry_to_list((LINK *)&sptr_session_entry->retained_tx_packet_links, (LINK *)&sptr_retained_entry->links);
	
	return PASS;

}

/* ....6 March 1999 */

enum TEST retain_rxed_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size)
{
	LINE_INFO_ENTRY *sptr_line_info;
	RETAINED_RX_PACKET *sptr_retained_entry;


	sptr_retained_entry = (RETAINED_RX_PACKET *)malloc(sizeof(RETAINED_RX_PACKET));

#ifdef DEBUG_INFO
printf("\n\rAGSESS : retain_rxed_packet : sptr_retained_entry malloced address is %x",sptr_retained_entry);
#endif

	if (sptr_retained_entry == NULL)
	{
		/* We can't really do anything in this case */
		ag_printf(AG_ALARM_PRINTF, "AG: Insufficient memory to buffer packets!\n\r");

		return FAIL;
	}
	
	sptr_retained_entry->sptr_ag_packet = sptr_ag_packet;
	sptr_retained_entry->data_size = data_size;

	add_entry_to_list((LINK *)&sptr_session_entry->retained_packet_links, (LINK *)&sptr_retained_entry->links);
	
	reduce_network_receives(sptr_session_entry); /* Sort of flow control */

	sptr_line_info = &ag.line_info_array[sptr_session_entry->line_in_use];
	sptr_line_info->stats.pending_tx_bytes += data_size;

	return PASS;
}

/* 6 March 1999.... */

enum BOOLEAN are_there_retained_serial_rx_packets(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	RETAINED_TX_PACKET *sptr_retained_entry;

	sptr_retained_entry = (RETAINED_TX_PACKET *)get_pointer_to_first_entry_in_list((LINK *)&sptr_session_entry->retained_tx_packet_links);
	if (sptr_retained_entry != NULL)
		return TRUE;

   return FALSE;
}

/* ....6 March 1999 */

void set_session_to_active(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	BYTE line_id;
	RETAINED_RX_PACKET *sptr_retained_entry, *sptr_next_retained_entry;


	ag_printf(AG_SESS_PRINTF, "AG: Moving session back to active\n\r");

	line_id = sptr_session_entry->line_in_use;

	/* Free all retained packets */

	sptr_retained_entry = (RETAINED_RX_PACKET *)get_pointer_to_first_entry_in_list((LINK *)&sptr_session_entry->retained_packet_links);
	while (sptr_retained_entry != NULL)
	{
		sptr_next_retained_entry = get_pointer_to_next_entry_in_list((LINK *)&sptr_retained_entry->links);

		free_network_stuff(sptr_retained_entry->sptr_ag_packet);

/* Included On March 1st 1999 */
		delete_entry_from_list((LINK *)&sptr_session_entry->retained_packet_links, (LINK *)&sptr_retained_entry->links);
		free(sptr_retained_entry);

		sptr_retained_entry = sptr_next_retained_entry;
	}

	flush_serial_tx_buffers((USHORT) line_id);/* To get back all send buffers;
											** they will be got in the 
											** callback routine
											*/

	/* Delink any relation with any line */
	sptr_session_entry->line_in_use = UNKNOWN_LINE;

	sptr_session_entry->session_status = AG_SESS_ACTIVE;

	set_line_status(&ag.line_info_array[line_id], AGLS_CLEANING_UP);
	modem_hangup_complete((USHORT) line_id);
}

void cleanup_session(SESSION_TABLE_ENTRY *sptr_session_entry)
{
	BYTE line_id;
	char *modem_hangup_string;
	LINE_INFO_ENTRY *sptr_line_info;
	RETAINED_RX_PACKET *sptr_retained_entry, *sptr_next_retained_entry;
	RETAINED_TX_PACKET *sptr_tx_retained_entry, *sptr_next_tx_retained_entry;


	ag_printf(AG_SESS_PRINTF, "AG: Cleaning up session\n\r");

	line_id = sptr_session_entry->line_in_use;

	if (line_id != UNKNOWN_LINE)
	{
		/* Free all retained packets */

/* Naveen  01/02/1997 */

		sptr_line_info = &ag.line_info_array[line_id] ;

/* Naveen  01/02/1997 */

		sptr_retained_entry = (RETAINED_RX_PACKET *)get_pointer_to_first_entry_in_list((LINK *)&sptr_session_entry->retained_packet_links);
		while (sptr_retained_entry != NULL)
		{
			sptr_next_retained_entry = get_pointer_to_next_entry_in_list((LINK *)&sptr_retained_entry->links);

			free_network_stuff(sptr_retained_entry->sptr_ag_packet);

/* Included On March 1st 1999 */
			delete_entry_from_list((LINK *)&sptr_session_entry->retained_packet_links, (LINK *)&sptr_retained_entry->links);
			free(sptr_retained_entry);

			sptr_retained_entry = sptr_next_retained_entry;
		}
      
		sptr_tx_retained_entry = (RETAINED_TX_PACKET *)get_pointer_to_first_entry_in_list((LINK *)&sptr_session_entry->retained_tx_packet_links);
		while (sptr_tx_retained_entry != NULL)
		{
			sptr_next_tx_retained_entry = get_pointer_to_next_entry_in_list((LINK *)&sptr_tx_retained_entry->links);

			free(sptr_tx_retained_entry->sptr_ag_packet_data);

/* Included On March 1st 1999 */
			delete_entry_from_list((LINK *)&sptr_session_entry->retained_tx_packet_links, (LINK *)&sptr_tx_retained_entry->links);
			free(sptr_tx_retained_entry);

			sptr_tx_retained_entry = sptr_next_tx_retained_entry;
		}

		flush_serial_tx_buffers((USHORT) line_id);/* To get back all send buffers;
												** they will be got in the 
												** callback routine
												*/
	}

	/* If this session was in the inbound list of any line, remove it */
	remove_session_from_all_inbound_lists(sptr_session_entry);

	free_session_entry(sptr_session_entry);	/* We no longer need this */

	/* Make the line available for use */

	if (line_id == UNKNOWN_LINE)				
		return;									/* Not yet in use */

	sptr_line_info->sptr_session_entry = NULL;	/* Don't try to access session
												** info from now on
												*/

	set_line_status(sptr_line_info, AGLS_CLEANING_UP);

	if (is_wan_direct_connect((USHORT)line_id) == FALSE && is_dcd_present((USHORT)line_id))
	{
		modem_hangup_string = get_wan_modem_hangup_string((USHORT) line_id);
		start_modem_hangup_state_machine((USHORT) line_id, modem_hangup_string, (void (*)(USHORT, BYTE *, USHORT))write_serial_port, modem_hangup_complete);
	}
	else
	{
		modem_hangup_complete((USHORT)line_id);
	}
}

/* -- END CODE -------------------------------------------------------- */
