/* AGSESS.H -- Header to AGSESS.C
** Modifications : sudha 15-Oct-1999. Removed one unwanted parameter "is_called
**						 from_retained" in retain_unsent_packet() function prototype
**						 as we have changed the scheme of retaining unsent packets 
**						 slightly. 	
*/

#ifndef _AGSESS_H_
#define _AGSESS_H_


extern SESSION_TABLE_ENTRY *get_free_session_entry(void);
extern void free_session_entry(SESSION_TABLE_ENTRY *sptr_session_entry);
extern SESSION_TABLE_ENTRY *find_session_using_connection_ID(ULONG connection_ID);
extern enum BOOLEAN are_there_retained_packets(SESSION_TABLE_ENTRY *sptr_session_entry);
extern enum TEST retain_rxed_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size);
extern void set_session_to_active(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void cleanup_session(SESSION_TABLE_ENTRY *sptr_session_entry);

/* sudha 15-Oct-1999. Removed the parameter "is_called_from_retained" */
extern enum TEST retain_unsent_packet(SESSION_TABLE_ENTRY *sptr_session_entry,BYTE *sptr_ag_packet_data,USHORT unsent_data_size);

extern enum BOOLEAN are_there_retained_serial_rx_packets(SESSION_TABLE_ENTRY *sptr_session_entry);
extern USHORT display_retained_unsent_packets(SESSION_TABLE_ENTRY *sptr_session_entry);

#endif /* _AGSESS_H_ */
