/* AGSPX.H -- Header to AGSPX.C
*/

#ifndef _AGSPX_H_
#define _AGSPX_H_

extern void do_ipx_interface_periodic_actions(void);
extern void wait_for_connection(void);
extern void ag_spx_issue_receives_for_session(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_spx_issue_max_receives_for_session(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_spx_send_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size, void *passed_parameter);
extern enum TEST ag_spx_send_internal_packet(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size);
extern BYTE *get_a_spx_send_buffer(USHORT data_size);
extern void free_a_spx_send_buffer(BYTE *bptr);
extern void ag_spx_reduce_network_receives(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_spx_increase_network_receives(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_spx_free_network_stuff(UNION_AG_PACKET *sptr_ag_packet);
extern enum TEST ag_spx_send_serial_rx_packet_on_network(SESSION_TABLE_ENTRY *sptr_session_entry, UNION_AG_PACKET *sptr_ag_packet, USHORT data_size);
extern void ag_spx_terminate_connection(SESSION_TABLE_ENTRY *sptr_session_entry);
extern enum BOOLEAN ag_spx_says_ok_to_cleanup(SESSION_TABLE_ENTRY *sptr_session_entry);
extern enum BOOLEAN ag_spx_says_cancels_done(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_spx_cancel_pending_calls(SESSION_TABLE_ENTRY *sptr_session_entry);
extern enum TEST ag_spx_allocate_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_spx_free_protocol_structure(SESSION_TABLE_ENTRY *sptr_session_entry);
extern ULONG ag_spx_get_client_network_number(SESSION_TABLE_ENTRY *sptr_session_entry);
extern ULONG ag_spx_get_client_node_number_ulong(SESSION_TABLE_ENTRY *sptr_session_entry);
extern USHORT ag_spx_get_client_node_number_ushort(SESSION_TABLE_ENTRY *sptr_session_entry);
extern void ag_spx_fill_user_address(SESSION_TABLE_ENTRY *sptr_session_entry, BYTE *sptr_address);

#endif /* _AGSPX_H_ */
