/* AGTIMER.C -- Periodically executed code.
** By: Sanjay
** Start: 10, July, 1996
** Done: 30, August, 1996
*/

#include "rtrstd.h"

#include "kag.h"

#include "vagstr.h"
#include "vag.h"

#include "agpkttyp.h"
#include "agip.h"
#include "agutil.h"

#include "agnetif.h"
#include "agtx.h"
#include "agsess.h"
#include "agline.h"
#include "agtimer.h"
#include "aginboun.h"
#include "aginbsup.h"

#include <serial.h>
#include <wanmgr.h>

#define RECEIVE_FAILED 14

/* Included by Brindha */
extern SERVER_DISCOVERY_CLASS server_discovery;
SERVER_DISCOVERY_RESPONSE_PACKET server_discovery_response_packet;

/* Externals */
extern ULONG router_timer;
extern void send_changed_signals(void);

/* These functions are in TFTP directory */
extern int send_data_packet (ULONG destination_ip_address, int destination_port,
                   int socket, BYTE *info, ULONG length);
extern int receive_data(ULONG *source_ip_address, int *source_port, int socket,
                BYTE *packet, int *packet_length);

/* Local Prototypes */
void send_response_for_ip_server_discovery(void);

/* -- CODE ------------------------------------------------------------- */
#define STATUS_UPDATION_PERIOD 20
/*
The frequency at which to update the client with the status of
the CD, RTS, CTS and DTR pins
*/
ULONG line_status_updation_counter = 0 ;
extern void update_mcsi_clients_with_line_status () ;

void ag_timer(void)
{
	enum BOOLEAN result;
	USHORT i, port_number;
	LINE_INFO_ENTRY *sptr_line_info;
	SESSION_TABLE_ENTRY *sptr_session_entry, *sptr_next_session_entry;
	
	
	if (ag.timer_enabled == FALSE)
		return;
/* Added by Naveen and Sachin to inform the client about the current
   state of CTS,DSR & CD ...*/
	if (line_status_updation_counter >= STATUS_UPDATION_PERIOD)
	{
		line_status_updation_counter = 0 ;
		update_mcsi_clients_with_line_status () ;
	}
	else
		line_status_updation_counter++ ;
/* ... Naveen and Sachin 20/1/1997 */

	sptr_session_entry = (SESSION_TABLE_ENTRY *)get_pointer_to_first_entry_in_list((LINK *)&ag.session_entries_list);
	while (sptr_session_entry != NULL)
	{
		sptr_next_session_entry = (SESSION_TABLE_ENTRY *)get_pointer_to_next_entry_in_list((LINK *)&sptr_session_entry->links);

		switch (sptr_session_entry->session_status)
		{
		case AG_SESS_ABORTED:
#ifdef DEBUG
			printf("AG: Noticed session in AG_SESS_ABORTED state...will cleanup\n\r");
#endif /* DEBUG */
			if (network_says_ok_to_cleanup(sptr_session_entry) == TRUE &&
				inbound_says_ok_to_cleanup(sptr_session_entry) == TRUE)
			{
				delete_entry_from_list((LINK *)&ag.session_entries_list, (LINK *)&sptr_session_entry->links);
				cleanup_session(sptr_session_entry);
			}
			break;

		case AG_SESS_CONNECTED:
			send_delayed_serial_packets(sptr_session_entry);
			result = wait_for_network_packets(sptr_session_entry);
#if DEBUG
			if (result == TRUE)
				printf("AG: Finally restarted receive in timer \n\r");
#endif /* DEBUG */
			break;

		case AG_SESS_ACTIVE:
			result = wait_for_network_packets(sptr_session_entry);
#if DEBUG
			if (result == TRUE)
				printf("AG: Finally restarted receive in timer \n\r");
#endif /* DEBUG */
			break;

		case AG_SESS_CANCELLING:
			if (network_says_cancels_done(sptr_session_entry) == TRUE)
			{
				set_session_to_active(sptr_session_entry);
			}
			break;

		default:
			break;
		}

		sptr_session_entry = sptr_next_session_entry;
	}

	sptr_line_info = &ag.line_info_array[0];
	for (i = 0; i < ag.number_of_lines; i++, sptr_line_info++)
	{
		port_number = (USHORT)sptr_line_info->line_id;

		switch (sptr_line_info->line_status)
		{
		case AGLS_LINE_BUSY:
			if (sptr_line_info->line_vars.idle_time != 0)
			{
				if (sptr_line_info->inactivity_timer)
					sptr_line_info->inactivity_timer--;
				else
				{
					ag_printf(AG_LINE_PRINTF, "AG: WAN %u: Terminating connection due to inactivity\n\r", (USHORT) sptr_line_info->line_id);

					/* Set timer to a very large value so that this is not
					** triggered again.
					*/
					sptr_line_info->inactivity_timer = 0xFFFFFFFF;
					freeup_line(sptr_line_info, AGFL_IDLE_TIMEOUT);
				}
			}

			/* On inbound connections, check that CD is still up */
			if (is_wan_direct_connect(port_number) == FALSE &&
					sptr_line_info->connect_mode == INBOUND_MODEM && 
					is_dcd_present(port_number) == FALSE)
			{
				ag_printf(AG_LINE_PRINTF, "AG: WAN %u: CD lost on inbound connection...terminating connection\n\r", port_number);

				freeup_line(sptr_line_info, AGFL_CD_DROPPED);
			}
			break;
		case AGLS_CALL_COMING_IN:
			/* When the inbound state machine is progressing, CD should not
			** drop.
			*/
			if (is_wan_direct_connect(port_number) == FALSE &&
					sptr_line_info->connect_mode == INBOUND_MODEM &&
					is_dcd_present(port_number) == FALSE)
			{
				ag_printf(AG_LINE_PRINTF, "AG: WAN %u: CD lost on inbound connection init...terminating connection\n\r", port_number);

				abort_inbound_call(sptr_line_info);
			}
			break;

      default:
         break;
		}
	}

	move_inbound_state_machine();

   listen_for_connection();

	issue_receives_for_connection();

	if (ag.statistics_timer != 0)
		ag.statistics_timer--;

   else if (ag.statistics_timer == 0)
      ag.start_statistics_timer = TRUE ;

	if (ag.start_statistics_timer == TRUE)
	{
		ag.statistics_timer = ag.clock_ticks_per_second;
		ag.start_statistics_timer = FALSE;
	}
}

/* Included by Brindha */
void server_discovery_timer(void)
{
	if (server_discovery.client_up == TRUE)
		return;
	if ((server_discovery.enabled == FALSE) || (server_discovery.socket_interface_enabled == FALSE) 
			|| (server_discovery.socket_interface_initialized == FALSE))
	{
		return ;
	}
	
	if (server_discovery.timer_class.timer_enabled == FALSE)
	{
		return ;
	}

	server_discovery.timer_class.tick_counter++ ;
	
	send_response_for_ip_server_discovery ();
}

/* Included by Brindha */
void send_response_for_ip_server_discovery(void)
{
	BYTE *packet;
	int packet_length;

	packet = (BYTE *)malloc(MAX_REMOTE_CONSOLE_PACKET);
   if (packet == NULL)
   {
      printf("\n\rAGTIMER : packet malloc failed.");
      return;
   }

	if ((receive_data(&server_discovery.remote_internet_address, 
			&server_discovery.remote_socket_number, server_discovery.socket,
			packet, &packet_length) != RECEIVE_FAILED))
	{
		memset(&server_discovery_response_packet, 0, sizeof(SERVER_DISCOVERY_RESPONSE_PACKET));
		strcpy(server_discovery_response_packet.server_name,ag.server_name);

		send_data_packet(server_discovery.remote_internet_address, 
							server_discovery.remote_socket_number, server_discovery.socket,
							(BYTE *)&server_discovery_response_packet, sizeof(SERVER_DISCOVERY_RESPONSE_PACKET));	
	}
   if (packet != NULL)
   {
   	free(packet) ;
      packet = NULL ;
   }
}

/* -- END CODE -------------------------------------------------------- */

