/* VNVAG.H -- NVRAM settings related info.
*/

#include <vnvrmstr.h>

CONFIGURATION_TABLE ag_configuration_table = 
{
	{TRUE},
	{
	/*--------------------------------------------------------------------- */
	/* AG configuration parameters */
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG =",
		(ULONG) offsetof(AG_CLASS, enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
   {
      (void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_variable_string,
		NULL,
		"AG Server Name =",
		(ULONG) offsetof(AG_CLASS, server_name),
		(ULONG) &ag,
		(ULONG) NULL
   },

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"AG Maximum Number Of Sessions =",
		(ULONG) offsetof(AG_CLASS, max_sessions),
		(ULONG) &ag,
		(ULONG) NULL
	},

	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ushort_decimal_value,
		NULL,
		"AG Network Interface To Use =",
		(ULONG) offsetof(AG_CLASS, network_interface_to_use),
		(ULONG) &ag,
		(ULONG) NULL
	},
/*
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_ulong_decimal_value,
		NULL,
		"AG IPX Periodic Broadcast Interval =",
		(ULONG) offsetof(AG_CLASS, ipx_interface.broadcast_interval),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		set_byte_decimal_value,
		NULL,
		"AG IPX Receives Per Session =",
		(ULONG) offsetof(AG_CLASS, ipx_interface.receives_per_session),
		(ULONG) &ag,
		(ULONG) NULL
	},
*/
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Display Connection Manager Menu =",
		(ULONG) offsetof(AG_CLASS, show_connection_manager_menu),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		set_variable_port_and_string,
		NULL,
		"AG Port General Name =",
		(ULONG) offsetof(AG_CLASS, line_info_array[0].line_vars.general_name),
		(ULONG) &ag,
		sizeof(LINE_INFO_ENTRY)
	},
	{
		set_variable_port_and_string,
		NULL,
		"AG Port Specific Name =",
		(ULONG) offsetof(AG_CLASS, line_info_array[0].line_vars.specific_name),
		(ULONG) &ag,
		sizeof(LINE_INFO_ENTRY)
	},
	{
		set_variable_port_and_ushort_decimal_value,
		NULL,
		"AG Port Maximum Packet Size =",
		(ULONG) offsetof(AG_CLASS, line_info_array[0].line_vars.default_max_packet_size),
		(ULONG) &ag,
		sizeof(LINE_INFO_ENTRY)
	},
	{
		set_variable_port_and_ulong_decimal_value,
		NULL,
		"AG Port Idle Time =",
		(ULONG) offsetof(AG_CLASS, line_info_array[0].line_vars.idle_time),
		(ULONG) &ag,
		sizeof(LINE_INFO_ENTRY)
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.ag_print_switch_on),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Initialization Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.init_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Alarm Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.alarm_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Session Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.session_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG MCSI Incoming Calls Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.mcsi_in_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG MCSI Outgoing Calls Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.mcsi_out_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Connection Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.connect_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Diagnostic Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.diagnostic_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Line Information Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.line_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	},
	{
		NULL,
		(enum BOOLEAN *) TRUE,
		"AG Inbound Printf =",
		(ULONG) offsetof(AG_CLASS, print_class.inbound_printing_enabled),
		(ULONG) &ag,
		(ULONG) NULL
	}

	}
};


