#define GLOBAL_FILE

#include <stdio.h>
#include "dhcps.h"

#if STATUS_DEBUG
enum BOOLEAN register_debugger (void (*fptr_debug_function)(), char *signature) ;
extern void dhcp_server_configuration (void) ;
extern void print_dhcp_database () ;
#endif
extern void dhcp_server_timer () ;


void initialize_dhcp_server (ULONG clock_ticks_per_second)
{
   if (dhcp_server.enabled == FALSE)
      return ;

#if STATUS_DEBUG
	register_debugger (dhcp_server_configuration, "dhcpcon") ;
	register_debugger (print_dhcp_database, "dhcpdb") ;
#endif
   if (initialize_dhcp_server_socket_interface())
   {
      add_server_id_option_to_default_option_list () ;
      initialize_dhcp_server_database () ;

      if (dhcp_server.db_update_period == 0)
         dhcp_server.db_update_period = DHCP_DATABASE_UPDATE_PERIOD ;
      dhcp_server.db_update_period *= clock_ticks_per_second ;

      dhcp_server.db_counter = dhcp_server.db_update_period ;
      dhcp_server.db_changed = FALSE ;
      dhcp_server.clock_ticks_per_second = clock_ticks_per_second ;
   }
}

void dhcp_server_foreground ()
{
   ULONG source_ip_address ;
   int packet_length, source_port ;
   char source_ip_address_string[40] ;
   int dhcp_receive_return_value ;

   if (dhcp_server.enabled == FALSE)
      return ;

   dhcp_receive_return_value = dhcp_server_receive_data (&source_ip_address, &source_port, &dhcp_server.dhcp_receive_packet[0], &packet_length) ;
   if ((dhcp_receive_return_value != -1) && (packet_length))
   {
      ulong_to_dot_format (&source_ip_address_string[0], net_to_host_long (source_ip_address)) ;
      printf ("\nDHCP : Packet of size %d received from %s\n", packet_length, source_ip_address_string) ;
      process_dhcp_packet (&dhcp_server.dhcp_receive_packet[0], packet_length, source_ip_address, source_port) ;
   }
   dhcp_server_timer () ;

   return ;
}
