/* -----------------------------------------------------------------------
Module: DHCP
Author: Kamalnath
Duration: July 1996 - October 1996
 ----------------------------------------------------------------------- */
#include "dhcp.h"
#include "dhcpstat.h"

/* -----------------------------------------------------------------------
Function: Initialize_dhcp_socket_interface
Input   : Nothing
Synopsis: Opens and bind the socket to DHCP RELAY AGENT (SERVER) port.
 ----------------------------------------------------------------------- */
enum TEST initialize_dhcp_socket_interface (void)
{
	SOCKADDR_IN relay_agent_addr;
	int bind_return_value;

	if (dhcp.socket_interface_initialized == TRUE) 
		return(FAIL);
		
	/* Create and bind the relay_agent port for relaying DHCP packets only */
		
	relay_agent_addr.sin_family = AF_INET;
/* Changed by Naveen 25/6/1998. No confusion please relay agent socket is
   getting binded to Client port. I have done this to avoid replacement
	of the "dhcp.relay_agent_socket_descriptor". Actually this is Client Socket
*/
/*	relay_agent_addr.sin_port = DHCP_SERVER_PORT;*/
	relay_agent_addr.sin_port = DHCP_CLIENT_PORT;
	relay_agent_addr.sin_addr.s_addr = INTERNET_ADDRESS_ANY;
		
	dhcp.relay_agent_socket_descriptor = socket (AF_INET, SOCK_DGRAM, 0x00000000L);

	if (dhcp.relay_agent_socket_descriptor == FAILED)
		return (FAIL);

	associate_application_with_socket (dhcp.relay_agent_socket_descriptor, dhcp.application_id);

	bind_return_value = bind (dhcp.relay_agent_socket_descriptor, (SOCKADDR *) &relay_agent_addr, sizeof (SOCKADDR_IN));

	if (bind_return_value == FAILED)
		return (FAIL);
	
	dhcp.socket_interface_initialized = TRUE;
	
	return (PASS);
}

/* -----------------------------------------------------------------------
Function: dhcp_read_data_from_socket
Input   : Buffer Pointer and Size of the buffer	for receiving dhcp packet.
Synopsis: Reads DHCP data from binded socket
 ----------------------------------------------------------------------- */
int dhcp_read_data_from_socket (char *vptr_buffer, int max_size)
{
	int number_of_bytes_received;
	SOCKADDR_IN client_or_server_addr;
	ULONG sockaddr_length;

	if ((dhcp.enabled != TRUE) || (dhcp.socket_interface_initialized != TRUE))
		return (0) ;
	
	if (vptr_buffer == NULL)
		return (0) ;
	
	sockaddr_length = sizeof (SOCKADDR_IN);

	number_of_bytes_received = recvfrom (dhcp.relay_agent_socket_descriptor, vptr_buffer, max_size,
		(int) NULL, (SOCKADDR *) &client_or_server_addr, (int *) &sockaddr_length);
	
	return (number_of_bytes_received) ;
}

/* -----------------------------------------------------------------------
Function	:	Send_dhcp_packet
Input   	:	Port number on which the client is up, packet_type indicates
           	a DHCP DISCOVER or DHCPREQUEST broadcast
Synopsis	: 	Broadcasts a DHCPDISCOVER, DHCPREQUEST, DHCPDECLINE or 
           	DHCPRELEASE packet based on packet_type
 ----------------------------------------------------------------------- */
void send_dhcp_packet(BYTE port_num, BYTE packet_type)
{
	DHCP_DATA *vptr_dhcp_packet;
  	ULONG ip_address;
	SOCKADDR_IN server_addr;
	
	if ((dhcp.enabled != TRUE) || (dhcp.socket_interface_initialized != TRUE))
		return ;

	/* Build the DHCP Packet */
   vptr_dhcp_packet = (DHCP_DATA *) malloc (1 * sizeof(DHCP_DATA));
	
	if (vptr_dhcp_packet == NULL)
		return;
   
	memset(vptr_dhcp_packet,0,sizeof(DHCP_DATA));

	/* Only for LEASE_RENEWal Request packet is transmitted unicast to the 
		current IP address offered server and all other packets are broadcasted */
   
	server_addr.sin_family = AF_INET;
	server_addr.sin_port = DHCP_SERVER_PORT;
	
#if 0 /* Changed by Naveen 25/6/1998 */
	if ( dhcp.config.relay_agent_enabled )
	{
		server_addr.sin_addr.s_addr = dhcp.config.server_ip_address;
	}
	else
	{
#endif
		if (packet_type == DHCPREQUEST_LEASE_RENEW)
   		server_addr.sin_addr.s_addr = swap_long(dhcp_client_addr_info[port_num].dhcp_server_ip_address);
   	else 
			server_addr.sin_addr.s_addr = INTERNET_ADDRESS_BROADCAST;
#if 0
	}
#endif
   
	vptr_dhcp_packet->op_code = DHCP_REQUEST;
	vptr_dhcp_packet->hardware_type = ETHERNET_TYPE;
	vptr_dhcp_packet->hardware_addr_len = ETHERNET_ADDRESS_LENGTH;
   vptr_dhcp_packet->number_of_hops = HOP_COUNT;
	dhcp_client_addr_info[port_num].client_transaction_id = GET_RANDOM(1, MAX_RND_VALUE);
   vptr_dhcp_packet->transaction_id = dhcp_client_addr_info[port_num].client_transaction_id;
   vptr_dhcp_packet->flags_field = BROADCAST_FLAG;
#if 0 /* Code Changed by Naveen on 25/6/1998 */
	vptr_dhcp_packet->gateway_ip_address =	swap_long(dhcp.relay_agent_address);
#endif	
	vptr_dhcp_packet->gateway_ip_address =	0;
	memcpy(vptr_dhcp_packet->client_hardware_address,dhcp_client_addr_info[port_num].dummy_mac_address,MAC_ADDR_LEN);

	/* Fill in the DHCP Options List appropriately */
   
	switch ( packet_type )
   {
   	case DHCPDISCOVER:
      {
			/* Remote access client moves to init state */
        	dhcp_client_addr_info[port_num].lease_status = INIT_STATE;
	     	dhcp_client_addr_info[port_num].requested_message_type = DHCPDISCOVER;
        	memcpy(vptr_dhcp_packet->options_list,&discover_option_list,sizeof(DHCP_DISCOVER_OPTION));
        	dhcp_client_addr_info[port_num].request_and_wait_time_in_ticks = WAIT_FOR_RESPONSE_TIME;
		  	dhcp_client_addr_info[port_num].request_second_time_indicator++ ;
			printf("DHCP: Discover sent for port %d\n", port_num);
			break;
	  	}
     	
	  	case DHCPREQUEST:
     	case DHCPREQUEST_LEASE_RENEW:
     	case DHCPREQUEST_LEASE_REBIND:
		{
			ip_address = swap_long(dhcp_client_addr_info[port_num].dhcp_assigned_ip_address);
		  	memcpy(&request_option_list.ipaddress_message_type[2],&ip_address,sizeof(ULONG)); 

        	if ( packet_type == DHCPREQUEST )
         {
         	dhcp_client_addr_info[port_num].requested_message_type = DHCPREQUEST;
           	memcpy(&request_option_list.server_id_message_type[2],&dhcp_client_addr_info[port_num].dhcp_server_ip_address,sizeof(ULONG));
           	memcpy(&request_option_list.ipaddress_message_type[2],&dhcp_client_addr_info[port_num].dhcp_assigned_ip_address,sizeof(ULONG));
         }
        	else if (( packet_type == DHCPREQUEST_LEASE_RENEW ) || ( packet_type == DHCPREQUEST_LEASE_REBIND ))
         {
         	dhcp_client_addr_info[port_num].requested_message_type = DHCPREQUEST_LEASE_RENEW;
				memset(&request_option_list.server_id_message_type,0,IPADDRESS_MESSAGE_TYPE_LEN);
         }
        	
			memcpy(vptr_dhcp_packet->options_list,&request_option_list,sizeof(DHCP_REQUEST_OPTION));
			printf("DHCP: Request sent for port %d\n", port_num);
        	break;
	  	}

		case DHCPDECLINE:
     	{
        	dhcp_client_addr_info[port_num].requested_message_type = DHCPDECLINE;
        	memcpy(&decline_option_list.server_id_message_type[2],&dhcp_client_addr_info[port_num].dhcp_server_ip_address,sizeof(ULONG));
         memcpy(&request_option_list.ipaddress_message_type[2],&dhcp_client_addr_info[port_num].dhcp_assigned_ip_address,sizeof(ULONG));
        	memcpy(&decline_option_list.decline_option_array[2],"IP Address appears in use",DECLINE_MESSAGE_LENGTH-2);
        	memcpy(vptr_dhcp_packet->options_list,&decline_option_list,sizeof(DHCP_DECLINE_OPTION));
			printf("DHCP: Decline sent for port %d\n", port_num);
        	break;
      }
 
      case DHCPRELEASE:
      {
        	dhcp_client_addr_info[port_num].requested_message_type = DHCPRELEASE;
			dhcp_client_addr_info[port_num].port_status = IDLE;
        	dhcp_client_addr_info[port_num].lease_duration_in_ticks = 0 ;
			dhcp_client_addr_info[port_num].lease_renew_time_in_ticks = 0 ;
			dhcp_client_addr_info[port_num].lease_rebind_time_in_ticks = 0 ;
			vptr_dhcp_packet->flags_field = 0;
        	ip_address = swap_long(dhcp_client_addr_info[port_num].dhcp_server_ip_address);
        	memcpy(&release_option_list.server_id_message_type[2],&ip_address,sizeof(ULONG));
        	memcpy(vptr_dhcp_packet->options_list,&release_option_list,sizeof(DHCP_RELEASE_OPTION));
			printf("DHCP: Release sent for port %d\n", port_num);
			break;
      }
 
      default:
			break;
	}
	
   if (sendto(dhcp.relay_agent_socket_descriptor, (char *)vptr_dhcp_packet, (int)sizeof(DHCP_DATA),(int) NULL,
     		  (SOCKADDR *) &server_addr, sizeof(SOCKADDR_IN)) == FAILED)
	{
		/* printf("SendTo call failed\n"); */
   }
	free (vptr_dhcp_packet);    
	return; 
}

#if 0 /* Changed by Naveen 25/6/1998 
         No relay Agent functionality for Proxy Server */
void regenarate_and_relay_dhcp_packet (char *dhcp_request_packet)
{
	DHCP_DATA *relay_dhcp_packet;
	SOCKADDR_IN server_addr;
	
	if (dhcp.config.relay_agent_enabled == FALSE )
		return;
	
	if ((dhcp.enabled != TRUE) || (dhcp.socket_interface_initialized != TRUE))
		return ;

	relay_dhcp_packet = (DHCP_DATA *) dhcp_request_packet;
	
	/* Relaying to server using broadcast is the simplest procedure.
	It can be unicast to the server, but it needs server iddress
	through configuration */
 
	server_addr.sin_family = AF_INET;
	server_addr.sin_port = DHCP_SERVER_PORT;
	server_addr.sin_addr.s_addr = dhcp.config.server_ip_address;
	
	if	( (ULONG) dhcp.config.server_ip_address == 0x00000000L )
		return;

	if ( relay_dhcp_packet->number_of_hops >	MAX_HOP_COUNT )
		return;
	else
		relay_dhcp_packet->number_of_hops++;
	
	if ( relay_dhcp_packet->gateway_ip_address == (ULONG) NULL )
		relay_dhcp_packet->gateway_ip_address = swap_long ( dhcp.relay_agent_address );
   
	if ( sendto(dhcp.relay_agent_socket_descriptor, (char *)relay_dhcp_packet, (int)sizeof(DHCP_DATA),(int) NULL,
   	  (SOCKADDR *) &server_addr, sizeof(SOCKADDR_IN)) == FAILED )
	{
		/* printf("SendTo call failed\n"); */
		return;
   }
	/* printf("DHCP packet is relayed\r\n"); */
}					

void forward_reply_packets_to_dhcp_clients(char *dhcp_reply_packet)
{
	SOCKADDR_IN client_addr;
	DHCP_DATA *reply_packet;

	if ((dhcp.enabled != TRUE) || (dhcp.socket_interface_initialized != TRUE))
		return ;

	reply_packet = (DHCP_DATA *) dhcp_reply_packet;
	
	client_addr.sin_family = AF_INET;
	client_addr.sin_port = DHCP_CLIENT_PORT;
	
	if ( dhcp.config.relay_agent_enabled == FALSE )
		return;
	
	if ( dhcp.socket_interface_initialized == FALSE )
   	return;
   
	if ( reply_packet->gateway_ip_address != swap_long ( dhcp.relay_agent_address ) )
		return; 

/* Naidu to work with win 95 client 09/04/1997 */
#if 0
  	if ( reply_packet->flags_field == BROADCAST_FLAG )
		client_addr.sin_addr.s_addr = INTERNET_ADDRESS_BROADCAST;
	else
		client_addr.sin_addr.s_addr = swap_long ( reply_packet->your_ip_address );
#endif
   client_addr.sin_addr.s_addr = INTERNET_ADDRESS_BROADCAST;
		
	if ( sendto(dhcp.relay_agent_socket_descriptor, (char *)reply_packet, (int)sizeof(DHCP_DATA),(int) NULL,
   		  (SOCKADDR *) &client_addr, sizeof(SOCKADDR_IN)) == FAILED )
	{
		return;
   }
	return;
}
#endif 
