#include <stdio.h>
#include <stdlib.h>

#include "dhcps.h"


int initialize_dhcp_server_socket_interface (void)
{
	int bind_return_value ;
	SOCKADDR_IN local_dhcp_socket ;

	dhcp_server.dhcp_my_node_ip_address = gethostid() ;
	
	dhcp_server.dhcp_socket = socket (AF_INET, SOCK_DGRAM, IPPROTO_UDP) ;
		
   if (dhcp_server.dhcp_socket < 0)
   {
      printf ("DHCP: Socket open failed\n") ;
      return (0) ;
   }
   printf ("DHCP : Socket opened successfully\n") ;
	local_dhcp_socket.sin_family = AF_INET ;
	local_dhcp_socket.sin_port = DHCP_SERVER_PORT ;
	local_dhcp_socket.sin_addr.s_addr = INTERNET_ADDRESS_ANY ;

	bind_return_value = bind (dhcp_server.dhcp_socket,
		                          (SOCKADDR *)&local_dhcp_socket,
										  sizeof(SOCKADDR_IN)) ;

	if (bind_return_value < 0)
	{
		printf ("DHCP Error : Bind failed\n") ;
		return (0) ;
	}

	printf ("DHCP : Socket bound successfully to server port\n") ;
	return (1) ;
}



int dhcp_server_receive_data(ULONG *source_ip_address, int *source_port, BYTE *packet, int *packet_length)
{
	int add_len = sizeof(SOCKADDR_IN), return_code ;
	SOCKADDR_IN client_address ;
   int socket = dhcp_server.dhcp_socket ;

	return_code = recvfrom (socket, packet, DHCP_MAXIMUM_PACKET_LENGTH, 0,
	                      (struct sockaddr *)&client_address, &add_len) ;
	if (return_code != -1)
	{
		*packet_length = return_code ;
		if (return_code == 0)
			return 0 ;
		/* RouterWare's recvfrom() returns 0 if no data is available */
		*source_ip_address = client_address.sin_addr.s_addr ;
		*source_port = client_address.sin_port ;
		return 0 ;
	}
	*packet_length = 0 ;
	return -1 ;
}




int dhcp_server_send_data (ULONG destination_ip_address, int destination_port,
                   BYTE *info, ULONG length)
{
	SOCKADDR_IN destination ;
	int return_value ;
	BYTE *dhcp_send_packet ;
   int socket = dhcp_server.dhcp_socket ;

	dhcp_send_packet = (BYTE *) malloc (DHCP_MAXIMUM_PACKET_LENGTH) ;
	if (dhcp_send_packet == NULL)
	{
		return -1 ;
	}

	memcpy (dhcp_send_packet, info, (int)length) ;

	memset(&destination, 0, sizeof(SOCKADDR_IN)) ;
	destination.sin_family = AF_INET ;
	destination.sin_port = destination_port ;
	destination.sin_addr.s_addr = destination_ip_address ;

	return_value = sendto(socket, dhcp_send_packet, (int)length, 0,
	       (struct sockaddr *)&destination, sizeof (SOCKADDR_IN)) ;

	if (return_value != -1)
	{
		free (dhcp_send_packet) ;
		return 0 ;
	}
	/* If there is a send error the buffer is freed by socket_send_data()
	   or socket_udp_send(). So DO NOT free the buffer */
	return (-1);
}
