#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <memory.h>
#include "dhcps.h"



char *ulong_to_dot_format (char *cptr_array, ULONG ip_address)
{
   ULONG ip_address_host_order = net_to_host_long (ip_address) ;

	sprintf ((char *) cptr_array, "%03lu.%03lu.%03lu.%03lu",
		high_byte_of_dword (ip_address),
		high_low_byte_of_dword (ip_address),
		low_high_of_dword (ip_address),
		low_byte_of_dword (ip_address));

	return (cptr_array);
}



void dhcp_server_printf (const char *bptr_format, ...)
{
	va_list argptr ;

	va_start (argptr, bptr_format) ;

	if (dhcp_server.dhcp_server_printing == TRUE)
	{
		vprintf (bptr_format, argptr);
	}
	va_end (argptr);
}


void dhcp_display_exclusion_list (DHCP_EXCLUSION_ENTRY *sptr_exclusion_entry)
{
   char ip_address[20] ;
   int number_of_exclusions = 0 ;

   buffer_to_print[0] = 0 ;
   strcat (&buffer_to_print[0], "DHCP Exclusions : ............") ;

   while (sptr_exclusion_entry)
   {
      number_of_exclusions++ ;
      strcat (&buffer_to_print[0], "\n\t") ;
      strcat (&buffer_to_print[0], ulong_to_dot_format (&ip_address[0], sptr_exclusion_entry->lower_ip_address)) ;
      strcat (&buffer_to_print[0], " to ") ;
      strcat (&buffer_to_print[0], ulong_to_dot_format (&ip_address[0], sptr_exclusion_entry->higher_ip_address)) ;

      if (strlen (&buffer_to_print[0]) >= MAX_PRINT_BUFFER_SIZE)
         printf ("%s", &buffer_to_print[0]) ;

      sptr_exclusion_entry = sptr_exclusion_entry->sptr_next_entry ;
   }
   if (strlen (&buffer_to_print[0]) && number_of_exclusions)
      printf ("%s\n", &buffer_to_print[0]) ;
}


void dhcp_display_binding_list (DHCP_STATIC_BINDING_ENTRY *sptr_binding_entry)
{
   char ip_address[20] ;
   char mac_address[50] ;
   int next_byte, i, number_of_bindings = 0 ;
   char *cptr_temp = &mac_address[0] ;

   buffer_to_print[0] = 0 ;
   strcat (&buffer_to_print[0], "DHCP Bindings   : ............") ;

   while (sptr_binding_entry)
   {
      number_of_bindings++ ;
      strcat (&buffer_to_print[0], "\n\t") ;
      strcat (&buffer_to_print[0], "IP Address  : ") ;
      strcat (&buffer_to_print[0], ulong_to_dot_format (&ip_address[0], sptr_binding_entry->ip_address)) ;
      strcat (&buffer_to_print[0], ", MAC Address : ") ;
      for (i = 0 ; i < sptr_binding_entry->mac_address_length ; i++)
      {
         next_byte = sptr_binding_entry->mac_address[i] ;
         sprintf (cptr_temp, "%02X", next_byte) ;
         cptr_temp += 2 ;
      }
      strcat (&buffer_to_print[0], &mac_address[0]) ;

      if (strlen (&buffer_to_print[0]) >= MAX_PRINT_BUFFER_SIZE)
         printf ("%s", &buffer_to_print[0]) ;

      sptr_binding_entry = sptr_binding_entry->sptr_next_entry ;
   }
   if (strlen (&buffer_to_print[0]) && number_of_bindings)
      printf ("%s\n", &buffer_to_print[0]) ;
}


#if STATUS_DEBUG
void dhcp_server_configuration (void)
{
   int tag_index ;
   char lower_ip_address[20], higher_ip_address[20], subnet_mask[20] ;

   printf ("\nDHCP SERVER CONFIGURATION.............................") ;
   for (tag_index = 0 ; tag_index < dhcp_server.number_of_tags ; tag_index++)
   {
      printf ("\n\nRange : %s to %s, Mask : %s\n", 
         ulong_to_dot_format (&lower_ip_address[0], dhcp_server.sptr_tag_list[tag_index].lower_ip_address),
         ulong_to_dot_format (&higher_ip_address[0], dhcp_server.sptr_tag_list[tag_index].higher_ip_address),
         ulong_to_dot_format (&subnet_mask[0], dhcp_server.sptr_tag_list[tag_index].subnet_mask)) ;
      display_dhcp_options (dhcp_server.sptr_tag_list[tag_index].sptr_option_list) ;
      dhcp_display_exclusion_list (dhcp_server.sptr_tag_list[tag_index].sptr_exclusion_list) ;
      dhcp_display_binding_list (dhcp_server.sptr_tag_list[tag_index].sptr_binding_list) ;
   }
}
#endif



/* sudhir  13/2/97 */

void update_dns_server_address_in_dhcp_address_list (ULONG server_address)
{
   int tag_index ;
   DHCP_OPTION_ENTRY *sptr_dhcp_offer_options_list = (DHCP_OPTION_ENTRY *)NULL ;
	
   for (tag_index = 0 ; tag_index < dhcp_server.number_of_tags ; tag_index++)
	{
   	add_dhcp_option_to_list (&dhcp_server.sptr_tag_list[tag_index].sptr_option_list, 
				DNS, sizeof (ULONG), &server_address) ;
	}
	return;
}

/* sudhir  13/2/97 */
