/*-----------------------------------------------------------------------
Module: DHCP
Author: Kamalnath
Duration: July 1996 - October 1996
-----------------------------------------------------------------------*/
#include "dhcp.h"

#if DHCP_SERVER
void dhcp_server_foreground () ;
#endif


/*---------------------------------------------------------------------
Function: process_dhcp_packets
Input   : None
Synopsis: Processes the dhcp packets
---------------------------------------------------------------------*/
void process_dhcp_packets (char *vptr_dhcp_recvd_buffer)
{
   DHCP_DATA *sptr_dhcp_buffer;
   BYTE port_number;
   BYTE string[20]; /* Temp string used to print IP Address */ 

	/* Prepare a receive buffer to hold the DHCP data received */
	sptr_dhcp_buffer = (DHCP_DATA *)vptr_dhcp_recvd_buffer ;
	
	/* Process the received packet */
	
	if( sptr_dhcp_buffer->op_code == DHCP_REPLY )
	{
		for( port_number=1; port_number < TOTAL_NUMBER_OF_PORTS; port_number++)  
		{
			if( my_bytcmp(&dhcp_client_addr_info[port_number].dummy_mac_address,sptr_dhcp_buffer->client_hardware_address,port_number) == 0)
				break;
		}
		
		/* These are the reply packets which are to be forwarded to the dhcp clients */
		if ( port_number >= TOTAL_NUMBER_OF_PORTS ) 
		{
#if 0 /* Code removed By Naveen 25/06/1998 - No Relay Agent */
			forward_reply_packets_to_dhcp_clients(vptr_dhcp_recvd_buffer);
#endif
			return;
		}
		
		/* If transaction id not matches, discard it */
		if( sptr_dhcp_buffer->transaction_id != dhcp_client_addr_info[port_number].client_transaction_id )
			return;

		/* Switch on the message type to process packets appropriately */
		switch( sptr_dhcp_buffer->options_list[6] )
   	{
   		case DHCPOFFER: 					  
      	{
				printf ("DHCP:Offer received for port %d\n", port_number) ;
				
				if(dhcp_client_addr_info[port_number].port_status == OFFER_ACCEPTED)
					break;
			
				/* Set the flags appropriately for this port */
         	dhcp_client_addr_info[port_number].request_and_wait_time_in_ticks = 0;
         	dhcp_client_addr_info[port_number].request_second_time_indicator = NUMBER_OF_REQUESTS;
         	dhcp_client_addr_info[port_number].dhcp_assigned_ip_address = swap_long(sptr_dhcp_buffer->your_ip_address);
				dhcp_client_addr_info[port_number].port_status = OFFER_ACCEPTED;
				
				/* This function scans the list and fills the values 	*/
				scan_option_list_and_fill_values(sptr_dhcp_buffer->options_list, DHCPOFFER, port_number);
				
				/* NOTE:CLIENT can make ARP cross check here for address verification  
           	If address appears to be in use he can directly send a DHCPDECLINE 
				message broadcast and restart the DHCPDISCOVER process */

         	send_dhcp_packet( port_number, DHCPREQUEST);
         	break;
			}

      	case DHCPACK: 
      	{
         
				printf ("DHCP:Ack received for port %d\n", port_number) ;
         	
				if(dhcp_client_addr_info[port_number].requested_message_type == DHCPREQUEST)
				{
					if(dhcp_client_addr_info[port_number].port_status == ACK_ACCEPTED)
						break;
				}
			
				/* Set the flags appropriately for this port */
				dhcp_client_addr_info[port_number].port_status = ACK_ACCEPTED;
         	dhcp_client_addr_info[port_number].lease_status = BOUND_STATE;
				/* printf("Lease status set to BOUND_STATE \n"); */
         	
				scan_option_list_and_fill_values(sptr_dhcp_buffer->options_list, DHCPACK, port_number); 

         	/* If DHCP server does not return the renewal time and rebind time  
				calculate Renewal time and Rebind time are 50 % and 80% of lease 
				duration respectively */
         	if (dhcp_client_addr_info[port_number].lease_renew_time_in_ticks == 0)
				{
					dhcp_client_addr_info[port_number].lease_renew_time_in_ticks = 
            		dhcp_client_addr_info[port_number].lease_duration_in_ticks / RENEWAL_TIME_FACTOR ;
								
					dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks = dhcp_client_addr_info[port_number].lease_duration_in_ticks 
						- (dhcp_client_addr_info[port_number].lease_duration_in_ticks / REBIND_TIME_FACTOR) ;
				}
            
            ulong_to_dot_format(string, dhcp_client_addr_info[port_number].dhcp_assigned_ip_address);
            printf("IP Address obtained is   : %s\n", string);
            ulong_to_dot_format(string, dhcp_client_addr_info[port_number].dhcp_server_ip_address);
            printf("IP Address obtained from : %s\n", string);
#if 0
				printf("LEASE_DURATION = %ld seconds\n", dhcp_client_addr_info[port_number].lease_duration_in_ticks);
				printf("LEASE_RENEW_TIME = %ld seconds\n", dhcp_client_addr_info[port_number].lease_renew_time_in_ticks);
				printf("LEASE_REBIND_TIME = %ld seconds\n", dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks);
#endif

				/* convert all the times in seconds in to ticks */
		   	dhcp_client_addr_info[port_number].lease_duration_in_ticks = 
						dhcp_client_addr_info[port_number].lease_duration_in_ticks * TICKS_FACTOR;
		   	dhcp_client_addr_info[port_number].lease_renew_time_in_ticks = 
         	  	  	dhcp_client_addr_info[port_number].lease_renew_time_in_ticks * TICKS_FACTOR;
		   	dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks = 
               	dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks * TICKS_FACTOR;
				        
         	/* NOTE: Here the client can issue an ARP with its assigned IP
           	address to indicate others about its new address. */
																				
         	/* Call ppp to indicate that IP address is received */
				if(dhcp_client_addr_info[port_number].requested_message_type == DHCPREQUEST)         
				{
					ppp_dhcp_control_function ( port_number, DHCP_IP_ADDRESS_OBTAINED, 
						dhcp_client_addr_info[port_number].dhcp_assigned_ip_address);
				}
				break;
			}

      	case DHCPNAK: 
      	{
				printf ("DHCP:Received Nak for port %d\n", port_number) ;
         	
				dhcp_client_addr_info[port_number].lease_status = INIT_STATE;
			
				/* Set the flags appropriately for this port */
				dhcp_client_addr_info[port_number].requested_message_type = FALSE;

				/* Restart the configuraton process for this client    */
				memset(&dhcp_client_addr_info[port_number].dhcp_assigned_ip_address,0,sizeof(ULONG));
				
				/* If the requested_message_type is DHCPREQUEST_LEASE_RENEW then 
				we retransmit a DHCPREQUEST or else issue a DHCPDISCOVER afresh */
         	if ( dhcp_client_addr_info[port_number].requested_message_type == DHCPREQUEST_LEASE_RENEW )
         	{
         		send_dhcp_packet( port_number, DHCPREQUEST);
         	}
         	else
         	{
          		send_dhcp_packet( port_number, DHCPDISCOVER);
         	}
         	break;
			}
			
			default:   break;
		}
	}
   else if ( sptr_dhcp_buffer->op_code == DHCP_REQUEST )
	{
		/* Modify required parameters and forward this to the DHCP server */
#if 0
		printf("Received DHCP REQUEST from the client\n");
#endif

#if 0 /* Code Commented by Naveen 25/6/1998 - No Relay agent functionality */
		regenarate_and_relay_dhcp_packet (vptr_dhcp_recvd_buffer);
#endif
		return;
	}
	else /* Invalid DHCP packet */
	{
#if 0
		printf("Invalid DHCP packet received\n");
#endif
		return;
	}
}
/***********************************************************************
Function: dhcp_timer
Input   : None
Synopsis: Timer function controlling the Socket Read and Packet processing
***********************************************************************/
void dhcp_timer(void)
{
   BYTE i;
	char *vptr_dhcp_buffer;
	int number_of_bytes_read = 0;

#if DHCP_SERVER
   dhcp_server_foreground () ;
#endif

	if (dhcp.enabled != TRUE)
		return ;

	if (dhcp.timer_class.timer_enabled != TRUE)
		return;
	
	if (dhcp.remote_access_enabled == TRUE)
	{
		/*  LEASE management is done here */
		for ( i = 1; i < TOTAL_NUMBER_OF_PORTS; i++)
  		{
		
			/* Wait for 2 seconds after making the DHCP DISCOVER request, if no reply 
			make one more final request. If no response even this time, 
			then inform ppp about absence of dhcp server */
			
			if ( dhcp_client_addr_info[i].request_and_wait_time_in_ticks != 0 )
      	{
      		--dhcp_client_addr_info[i].request_and_wait_time_in_ticks;  
        		if (dhcp_client_addr_info[i].request_and_wait_time_in_ticks == 0 )
        		{
        			if (  dhcp_client_addr_info[i].request_second_time_indicator < NUMBER_OF_REQUESTS )
           		{
           			send_dhcp_packet( i, DHCPDISCOVER );
					}
           		else 
           		{									
						dhcp_client_addr_info[i].requested_message_type = FALSE;
						dhcp_client_addr_info[i].request_second_time_indicator = 0;
						ppp_dhcp_control_function ( i, DHCP_SERVER_NOT_FOUND, 0 );
           		}
        		}
 	  		}
															
			/* Handle Lease renewals carefully */
      	if ( dhcp_client_addr_info[i].lease_renew_time_in_ticks != 0 ) 
      	{
      		--dhcp_client_addr_info[i].lease_renew_time_in_ticks;
        		if (dhcp_client_addr_info[i].lease_renew_time_in_ticks == 0)
        		{
					dhcp_client_addr_info[i].lease_status = LEASE_RENEW_STATE;
					/* printf(" lease status set to LEASE_RENEW_STATE \n"); */
      			send_dhcp_packet( i, DHCPREQUEST_LEASE_RENEW);
				}
      	}

			if ( dhcp_client_addr_info[i].lease_rebind_time_in_ticks != 0 )
      	{
      		--dhcp_client_addr_info[i].lease_rebind_time_in_ticks;
        		if (dhcp_client_addr_info[i].lease_rebind_time_in_ticks == 0)
        		{
					dhcp_client_addr_info[i].lease_status = LEASE_REBIND_STATE;
					/* printf(" lease status set to LEASE_REBIND_STATE \n"); */
      			send_dhcp_packet( i, DHCPREQUEST_LEASE_REBIND);
				}	
      	} 
			
			if (dhcp_client_addr_info[i].lease_duration_in_ticks != 0 )
      	{
	   		--dhcp_client_addr_info[i].lease_duration_in_ticks;
        		if (dhcp_client_addr_info[i].lease_duration_in_ticks == 0)
         	{
			   	dhcp_client_addr_info[i].lease_status = LEASE_EXPIRED_STATE;
					/* printf(" lease status set to LEASE_EXPIRED_STATE \n"); */
					ppp_dhcp_control_function ( i, DHCP_LEASE_TIME_EXPIRED, 0 );
				}	
			}
		} 
	}
	++dhcp.timer_class.tick_counter;
	if (dhcp.timer_class.tick_counter >= dhcp.timer_class.clock_ticks_per_second)
	{
		dhcp.timer_class.tick_counter = 0x00000000L;

		vptr_dhcp_buffer = (char *) malloc (dhcp.maximum_transmission_unit) ;
		
		if (vptr_dhcp_buffer == (char *) NULL)
			return ;

      number_of_bytes_read =
		dhcp_read_data_from_socket(vptr_dhcp_buffer, dhcp.maximum_transmission_unit);

		if (number_of_bytes_read <= 0) 
		{
			free (vptr_dhcp_buffer) ;
			return ;
		}
		process_dhcp_packets(vptr_dhcp_buffer);
		free (vptr_dhcp_buffer) ;
		return ;
	}
}
