/* -----------------------------------------------------------------------
Module: DHCP
Author: Kamalnath
Duration: July - October (1996)
 ----------------------------------------------------------------------- */
#include "dhcp.h"

/* -----------------------------------------------------------------------
	ROUTINE  : my_bytcmp(ptr_1, ptr_2)
	INPUT    : Pointers to strings to be compared
	SYNOPSIS : Compares 16 octet HArdware address
 -----------------------------------------------------------------------*/

BYTE my_bytcmp(char *ptr_1, char *ptr_2, BYTE port_num)
{
	BYTE count;

   count = 1;
   if ( port_num > (TOTAL_NUMBER_OF_PORTS - 1) ) return(0);
   while ( count < MAC_ADDR_LEN)
   {
   	if ( *ptr_1 != *ptr_2 )
      {
      	return(1);
      }
      else 
      {
      	ptr_1++; 
         ptr_2++;
         count++;
      }
	}
   return(0) ;
}

/* -----------------------------------------------------------------------
	ROUTINE  : scan_option_list_and_fill_values(ptr_1, resp_packet_type, port_number )
	INPUT    : ptr_1 points to the option_list in received packet,
              packet_type indicates the values to be filled
              if DHCPOFFER , fill just server_ip_address
              if DHCPACK   , fill server and client ip_address, subnetmask,
                        renewal_time and rebind_time values
	SYNOPSIS : Searches for the option_code in the given buffer and returns
              a pointer to the option_value
 ----------------------------------------------------------------------- */

void scan_option_list_and_fill_values(char *ptr_1, BYTE resp_packet_type, BYTE port_number)
{

	/* Skip four bytes for Magic Cookie   */
	ptr_1 = ptr_1 + 4;

	/* switch on the Packet_type reseived */
   switch ( resp_packet_type ) 
   {
   	case	DHCPOFFER:
      {
      	while (  *ptr_1 != 0xFF )	/* Scan until END opcode (0xFF) */
 			{
				if ( *ptr_1 == SERVER_IDENTIFIER_OPTION )
            {
            	ptr_1 = ptr_1 + 2;
               memcpy(&dhcp_client_addr_info[port_number].dhcp_server_ip_address,ptr_1,sizeof(ULONG));
               return ;
            } 
            else 
            {
            	if ( *(ptr_1 + 1) == 0 ) 
               	ptr_1 = ptr_1 + 2;
               else
                  ptr_1 = ptr_1 + *(ptr_1 + 1 ) + 2;     

            }
         }
        	break;
		}

		case DHCPACK:
      {
      	while (  *ptr_1 != 0xFF )	    /* Scan through the list until we */
         {				   					/* get an opcode of END (0xFF)    */
         	switch ( *ptr_1 )
            {
					case SUBNET_MASK_OPTION:
               {
               	ptr_1 = ptr_1 + 2;
                	memcpy(&dhcp_client_addr_info[port_number].subnet_mask,ptr_1,sizeof(ULONG));
                	ptr_1 = ptr_1 + sizeof(ULONG);
                	break;
               }

				  	case RENEWAL_TIME_OPTION:
               {
               	ptr_1 = ptr_1 + 2;
                	memcpy(&dhcp_client_addr_info[port_number].lease_renew_time_in_ticks,ptr_1,sizeof(ULONG));
      			 	dhcp_client_addr_info[port_number].lease_renew_time_in_ticks = 
                          swap_long(dhcp_client_addr_info[port_number].lease_renew_time_in_ticks);
                	ptr_1 = ptr_1 + sizeof(ULONG);
					 	break;
               }

				  	case REBIND_TIME_OPTION:
               {
               	ptr_1 = ptr_1 + 2;
                	memcpy(&dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks,ptr_1,sizeof(ULONG));
        			 	dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks = 
                        swap_long(dhcp_client_addr_info[port_number].lease_rebind_time_in_ticks);
                	ptr_1 = ptr_1 + sizeof(ULONG);
					 	break;
					}

				   case IP_ADDRESS_LEASE_TIME_OPTION:
               {
               	ptr_1 = ptr_1 + 2;
                	memcpy(&dhcp_client_addr_info[port_number].lease_duration_in_ticks,ptr_1,sizeof(ULONG));
      			 	dhcp_client_addr_info[port_number].lease_duration_in_ticks = 
                          swap_long(dhcp_client_addr_info[port_number].lease_duration_in_ticks);
                	ptr_1 = ptr_1 + sizeof(ULONG);
					 	break;
					}

				  	case SERVER_IDENTIFIER_OPTION:
               {
               	ptr_1 = ptr_1 + 2;
                	memcpy(&dhcp_client_addr_info[port_number].dhcp_server_ip_address,ptr_1,sizeof(ULONG));
                	ptr_1 = ptr_1 + sizeof(ULONG);
                	break;
               }

              	default:
               {
               	if ( *(ptr_1 + 1) == 0 ) 
                  	ptr_1 = ptr_1 + 2;
                	else
                  	ptr_1 = ptr_1 + *(ptr_1 + 1 ) + 2;     
               	break;
               }

				}
         }
        	break;
      }

		default: break;
     
   }
}

enum BOOLEAN is_dhcp_client_enabled_in_the_configuration()
{	
	return(dhcp.config.client_enabled);
}


