#ifndef DHCP_SERVER_PORT
#define DHCP_SERVER_PORT				  67
#endif

#define DHCP_MAXIMUM_PACKET_LENGTH    1518

#ifndef BROADCAST_FLAG
#define BROADCAST_FLAG                0x80	 /* Check it out!!! */
#endif


#ifndef MAC_ADDR_LEN

#define MAC_ADDR_LEN	   				  16
#define SERVER_HOST_NAME_LENGTH       64
#define BOOT_FILE_NAME_LENGTH         128
#define MINIMUM_OPTIONS_LIST_LENGTH   312     /* RFC1542--> 64  */
#define MAGIC_COOKIE                  0x63825363L

enum DHCP_OPCODE_TYPE
{
	DHCP_REQUEST = 0x01,
   DHCP_REPLY = 0x02
};

#endif

/* DHCP Packet types are listed below  */

enum DHCP_MESSAGE_TYPE
{
	DHCPDISCOVER           	 =  0x01,
	DHCPOFFER              	 =  0x02,
	DHCPREQUEST            	 =  0x03,
	DHCPDECLINE            	 =  0x04,
	DHCPACK                	 =  0x05,
	DHCPNAK                	 =  0x06,
	DHCPRELEASE            	 =  0x07,
	DHCPREQUEST_LEASE_RENEW	 =  0x08,
	DHCPREQUEST_LEASE_REBIND =  0x09
};


enum DHCP_OPTION_TYPE
{
   DHCP_PAD_OPTION = 0,
   SUBNET_MASK = 1,
   TIME_OFFSET = 2,
   ROUTER = 3,
   TIME_SERVER = 4,
   NAME_SERVER = 5,
   DNS = 6,
   LOG_SERVER = 7,
   COOKIE_SERVER = 8,
   LPR_SERVER = 9,
   IMPRESS_SERVER = 10,
   RESOURCE_LOCATION_SERVER = 11,
   HOST_NAME = 12,
   BOOT_FILE_SIZE = 13,
   MERIT_DUMP_FILE = 14,
   DOMAIN_NAME = 15,
   SWAP_SERVER = 16,
   ROOT_PATH = 17,
   EXTENSIONS_PATH = 18,
   IP_FORWARDING_ENABLE = 19,
   NON_LOCAL_SOURCE_ROUTING = 20,
   POLICY_FILTER = 21,
   MAXIMUM_REASSEMBLY_SIZE = 22,
   TTL = 23,
   PATH_MTU_AGING_TIMEOUT = 24,
   PATH_MTU_PLATEAU_TABLE = 25,
   MTU = 26,
   ALL_SUBNETS_ARE_LOCAL = 27,
   BROADCAST_ADDRESS = 28,
   PERFORM_MASK_RECOVERY = 29,
   MASK_SUPPLIER = 30,
   PERFORM_ROUTER_DISCOVERY = 31,
   ROUTER_SOLICITATION = 32,
   STATIC_ROUTE = 33,
   TRAILER_ENCAPSULATION = 34,
   ARP_CACHE_TIMEOUT = 35,
   ETHERNET_ENCAPSULATION = 36,
   TCP_TTL = 37,
   TCP_KEEP_ALIVE_INTERVAL = 38,
   TCP_KEEP_ALIVE_GARBAGE = 39,
   NETWORK_INFORMATION_SERVICE = 40,
   NETWORK_INFORMATION_SERVERS = 41,
   NETWORK_TIME_PROTOCOL_SERVERS = 42,
   X_WHAT_IS_THIS = 43,
   NB_OVER_TCPIP_NAME_SERVER = 44,
   NB_OVER_TCPIP_DRAM_DIST_SERVER = 45,
   NB_OVER_TCPIP_NODE_TYPE = 46,
   NB_OVER_TCPIP_SCOPE = 47,
   X_W_SYSTEM_FONT_SERVER = 48,
   X_W_SYSTEM_DISPLAY_MANAGER = 49,
   REQUESTED_IP_ADDRESS = 50,
   IP_ADDRESS_LEASE_TIME = 51,
   OPTION_OVERLOAD = 52,
   DHCP_MESSAGE_TYPE = 53,
   SERVER_ID = 54,
   PARAMETER_REQUEST_LIST = 55,
   MESSAGE = 56,
   MAXIMUM_DHCP_MESSAGE_TYPE = 57,
   RENEWAL_T1_TIME_VALUE = 58,
   REBINDING_T2_TIME_VALUE = 59,
   CLASS_ID = 60,
   CLIENT_ID = 61,

   FIRST_UNKNOWN_DHCP_OPTION_TYPE,

   DHCP_END_OPTION = 255
} ;


enum DHCP_DATABASE_ENTRY_STATE
{
   OFFERED = 0,
   LEASED = 1,
   DIRTY = 2,
   DELETE = 3
} ;

#define IPPROTO_UDP 0

#define OFFER_TIMEOUT (5 * 60) /* 5 Minutes */
#define DHCP_DATABASE_UPDATE_PERIOD 60 /* 1 minute */
