/* ----------------------------------------------------------------------
Module: DHCP
Author: Kamalnath
Duration: July 1996 - October 1996
 ---------------------------------------------------------------------- */


extern void dhcp_set_tag_count (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3) ;
extern void dhcp_setup_tag_definition (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3) ;
extern void dhcp_setup_tag_exclusions (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3) ;
extern void dhcp_read_tag_options (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3) ;
extern void dhcp_setup_tag_bindings (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3) ;
extern enum TEST just_read_out (char *cptr_proxy_server_app_string);

CONFIGURATION_TABLE dhcp_configuration_table =
{
	{TRUE},
	{

		/*---------------------- Enable/Disable DHCP Relaying----------------*/
		{
			NULL,
			(enum BOOLEAN *) TRUE,
			"DHCP Relay Agent =",
			(ULONG) offsetof (DHCP_CLASS, config.relay_agent_enabled),
			(ULONG) &dhcp,
			(ULONG) NULL
		},

		/*---------------------- DHCP Server IP Address --------------------*/
		{
			(void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2, ULONG parameter_3))
			set_dhcp_server_ip_address,
			NULL,
			"DHCP Server IP Address =",
			(ULONG) offsetof (DHCP_CLASS, config.server_ip_address),
			(ULONG) &dhcp,
			(ULONG) NULL
		},
/*----------------------------------------------------------------------------*/
		{
			NULL,
			(enum BOOLEAN *) TRUE,
		   "DHCP Client =",
			(ULONG) offsetof (DHCP_CLASS, config.client_enabled),
			(ULONG) &dhcp,
			(ULONG) NULL
		},
		
#if DHCP_SERVER

      /*---------------------- Enable/Disable DHCP Server ----------------*/
		{
			NULL,
			(enum BOOLEAN *) TRUE,
			"DHCP Server =",
			(ULONG) offsetof (DHCP_SERVER_CLASS, enabled),
			(ULONG) &dhcp_server,
			(ULONG) NULL
		},

      {
         (void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		   dhcp_set_tag_count,
		   NULL,
	      "DHCP Number of Tags =",
		   (ULONG)NULL,
	 	   (ULONG)NULL
      },

      {
         (void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		   dhcp_setup_tag_definition,
		   NULL,
	      "DHCP Tag Address Range =",
		   (ULONG)NULL,
	 	   (ULONG)NULL
      },

      {
         (void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		   dhcp_setup_tag_exclusions,
		   NULL,
	      "DHCP Tag Exclusions =",
		   (ULONG)NULL,
	 	   (ULONG)NULL
      },

      {
         (void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		   dhcp_read_tag_options,
		   NULL,
	      "DHCP Tag Properties =",
		   (ULONG)NULL,
	 	   (ULONG)NULL
      },

      {
         (void (*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
		   dhcp_setup_tag_bindings,
		   NULL,
	      "DHCP Tag Bindings =",
		   (ULONG)NULL,
	 	   (ULONG)NULL
      },

      {
			(void 	(*) (char *cptr_start_of_configuration_string,ULONG parameter_1,ULONG ulptr_parameter_2,ULONG parameter_3))
			set_ulong_decimal_value,
		   NULL,
	      "DHCP Server Database Update Period =",
         (ULONG) offsetof (DHCP_SERVER_CLASS, db_update_period),
         (ULONG) &dhcp_server,
	 	   (ULONG) NULL
      },

      {
			NULL,
			(enum BOOLEAN *) TRUE,
			"DHCP Server Printf =",
			(ULONG) offsetof (DHCP_SERVER_CLASS, dhcp_server_printing),
			(ULONG) &dhcp_server,
			(ULONG) NULL
		},

#endif


		/*------------------------------------------------------------------*/
		{
			NULL,
			NULL,
			"",
			(ULONG) NULL,
			(ULONG) NULL,
			(ULONG) NULL
		}
	}

} ;
