/* Imran,Sudha for auto detection of proxy in the same lan thru 
UDP broadcast & to change its ip address to the required one thru UDP 
broadcast again. */

#include "detip.h"
#include "kdetip.h"
#include "detipstr.h"

#include "..\..\store\boot.h"

extern ULONG get_ip_address(USHORT port_number);
/*  Local  Prototypes   */
enum TEST initialize_proxy_server_discovery ();
enum TEST initialize_proxy_server_discovery_socket_interface(void);
void get_mac_address_of_proxy_server (void);

BYTE mac_address[MAX_MAC_ADDRESS_LENGTH+1];
extern char ethernet_address[8];

PROXY_SERVER_DISCOVERY_CLASS proxy_server_discovery;

enum TEST initialize_proxy_server_discovery ()
{
   proxy_server_discovery.enabled = TRUE;
	proxy_server_discovery.socket_interface_enabled = TRUE;
   
	if (initialize_proxy_server_discovery_socket_interface() == FAIL)
		return (FAIL);
	
	get_mac_address_of_proxy_server();
	return (PASS);
}

enum TEST initialize_proxy_server_discovery_socket_interface (void)
{
	SOCKADDR_IN local_read_sockaddr_in;

	if ( proxy_server_discovery.socket_interface_enabled  == FALSE )
		return (FAIL);
		
	proxy_server_discovery.local_internet_address = get_ip_address(0);

	proxy_server_discovery.socket = socket (AF_INET, SOCK_DGRAM ,0L);
	if (proxy_server_discovery.socket == FAILED) 
		return (FAIL);

	/* initialize local sockaddr_in structure */
	local_read_sockaddr_in.sin_family      = AF_INET;    /* "Internet" Address Family */
/*   local_read_sockaddr_in.sin_addr.s_addr = 0;  * since this is a broadcast */
   local_read_sockaddr_in.sin_addr.s_addr = proxy_server_discovery.local_internet_address;   
	local_read_sockaddr_in.sin_port = IPPORT_DISCOVER_PROXY_SERVER;

	/* bind local ip address & port number to the socket */
	if (bind (proxy_server_discovery.socket, (SOCKADDR *)&local_read_sockaddr_in, sizeof(SOCKADDR_IN)) == FAILED) 
	{
		closesocket(proxy_server_discovery.socket);
		return (FAIL);
	}
		
	proxy_server_discovery.socket_interface_initialized = TRUE;
	return (PASS);
}

void get_mac_address_of_proxy_server()
{
 	int index ;
	BYTE temp_string[4];

	mac_address[0] = 0;

	for (index = 0; index < 6; index++)
	{
		sprintf(temp_string,"%02X",ethernet_address[index]);
		strcat(mac_address,temp_string);		
	}
}

