#include "defs.h"
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <memory.h>

#include <kstart.h>

#include <redblack.h>
#include "pptprb.h"
#include "vpptpstr.h"



/* Define this and do operations like copying and comparisons more optimally */


PPTP_PAC_DESCRIPTOR_NODE *sptr_pptp_pac_descriptor_tree ;

static PPTP_PAC_DESCRIPTOR_NODE *get_new_proxy_rb_node ()
{
	return ((PPTP_PAC_DESCRIPTOR_NODE *) malloc(sizeof (PPTP_PAC_DESCRIPTOR_NODE))) ;
}

static void free_proxy_rb_node (PPTP_PAC_DESCRIPTOR_NODE *sptr_node)
{
	free (sptr_node) ;
}


static int proxy_RB_demo_insert_node(PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key, PPTP_RB_INFO_TYPE info, PPTP_PAC_DESCRIPTOR_NODE **ptr_sptr_new_node)
{
	PPTP_PAC_DESCRIPTOR_NODE *nptr ;

	int retVal ;

	retVal = _fmemcmp((unsigned char *)&Tree->key, (unsigned char *)&key, sizeof (PPTP_RB_KEY_TYPE)) ;
	if (retVal < 0)
	{
		if (Tree->rb_header.RChild != sptr_RB_sentinal_node)
			return (proxy_RB_demo_insert_node ((PPTP_PAC_DESCRIPTOR_NODE *)Tree->rb_header.RChild, key, info, ptr_sptr_new_node)) ;
		else
		{
			*ptr_sptr_new_node = nptr = get_new_proxy_rb_node() ;
			if (nptr == NULL)
			{
#if PROXY_RB_STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return PPTP_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
			nptr->key = key ;
			nptr->info = info ;

			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *)Tree ;
			Tree->rb_header.RChild = (RED_BLACK_NODE_HEADER *)nptr ;
#if 0
/* #if PROXY_RB_STATISTICS */
			statistics.number_of_nodes++ ;
/* #endif */
#endif
			return PPTP_RB_NEW_ENTRY ;
		}
	}
	else if (retVal > 0)
	{
		if (Tree->rb_header.LChild != sptr_RB_sentinal_node)
		{
			return (proxy_RB_demo_insert_node ((PPTP_PAC_DESCRIPTOR_NODE *)Tree->rb_header.LChild, key, info, ptr_sptr_new_node)) ;
		}
		else
		{
			*ptr_sptr_new_node = nptr = get_new_proxy_rb_node() ;
			if (nptr == NULL)
			{
#if PROXY_RB_STATISTICS
				statistics.number_of_insert_overflows++ ;
#endif
				return PPTP_RB_INSERT_OVERFLOW ;
			}
			nptr->rb_header.LChild = nptr->rb_header.RChild = sptr_RB_sentinal_node ;
			nptr->key = key ;
			nptr->info = info ;
			nptr->rb_header.Color = COLOR_RED ;
			nptr->rb_header.Parent = (RED_BLACK_NODE_HEADER *) Tree ;
			Tree->rb_header.LChild = (RED_BLACK_NODE_HEADER *) nptr ;
#if 0
/* #if PROXY_RB_STATISTICS */
			statistics.number_of_nodes++ ;
/* #endif */
#endif
			return PPTP_RB_NEW_ENTRY ;
		}
	}
#if PROXY_CUSTOM_OPERATIONS
	/* Here is where you should be putting in things like updating
	the information fields and things like that. For example you
	may want to reset an age field or update some field like
	information_source_port .... */
#endif
#if PROXY_RB_STATISTICS
	statistics.number_of_insert_hits++ ;
#endif
	return PPTP_RB_UPDATED ;
}


static int proxy_RB_demo_insert(PPTP_RB_KEY_TYPE key, PPTP_RB_INFO_TYPE info)
{
	PPTP_PAC_DESCRIPTOR_NODE *nptr, *sptr_new_node ;
	int retVal ;

	if (sptr_pptp_pac_descriptor_tree == (PPTP_PAC_DESCRIPTOR_NODE *)sptr_RB_sentinal_node)
	{
		nptr = get_new_proxy_rb_node() ;
		if (nptr == NULL)
		{
			return PPTP_RB_INSERT_OVERFLOW ;
		}
		nptr->key = key ;
		nptr->info = info ;
		nptr->rb_header.Color = COLOR_BLACK ;
		nptr->rb_header.Parent = nptr->rb_header.RChild = nptr->rb_header.LChild = sptr_RB_sentinal_node ;
		sptr_pptp_pac_descriptor_tree = nptr ;

		return PPTP_RB_NEW_ENTRY ;
	}

	retVal = proxy_RB_demo_insert_node (sptr_pptp_pac_descriptor_tree, key, info, &sptr_new_node) ;

	if (retVal == PPTP_RB_NEW_ENTRY)
	{
		sptr_pptp_pac_descriptor_tree = (PPTP_PAC_DESCRIPTOR_NODE *) RB_red_balance ((RED_BLACK_NODE_HEADER *)sptr_new_node, (RED_BLACK_NODE_HEADER *)sptr_pptp_pac_descriptor_tree) ;
	}
	return retVal ;
}
PPTP_PAC_DESCRIPTOR_NODE *pptp_pac_descriptor_search_with_client_call_id
	(PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key)
{
	PPTP_PAC_DESCRIPTOR_NODE *ptr_ret;

	if (Tree == NULL)
		return NULL;

	if (Tree == (PPTP_PAC_DESCRIPTOR_NODE *)sptr_RB_sentinal_node)
		return NULL ;

	if ((Tree->key.destination_ip_address == key.destination_ip_address) &&
		(((PPTP_INFO_DESCRIPTOR *)(Tree->info.ptr_to_pptp_descriptor))
								->client_call_id == key.call_id))
	{
		return Tree;
	}
	ptr_ret = pptp_pac_descriptor_search_with_client_call_id
					((PPTP_PAC_DESCRIPTOR_NODE *)Tree->rb_header.RChild, key);
	if (ptr_ret == NULL)
		ptr_ret = pptp_pac_descriptor_search_with_client_call_id
					((PPTP_PAC_DESCRIPTOR_NODE *)Tree->rb_header.LChild, key);
	return ptr_ret;
}

PPTP_PAC_DESCRIPTOR_NODE *pptp_pac_descriptor_search(PPTP_PAC_DESCRIPTOR_NODE *Tree, PPTP_RB_KEY_TYPE key)
{
	int ret_val ;
	
	if (Tree == NULL)
		return NULL;

	if (Tree == (PPTP_PAC_DESCRIPTOR_NODE *)sptr_RB_sentinal_node)
		return NULL ;

	ret_val = _fmemcmp((unsigned char *)&Tree->key, (unsigned char *)&key, sizeof (PPTP_RB_KEY_TYPE)) ;

	if (ret_val < 0)
	{
		return pptp_pac_descriptor_search ((PPTP_PAC_DESCRIPTOR_NODE *)Tree->rb_header.RChild, key) ;
	}
	else if (ret_val > 0)
	{	
	 	return pptp_pac_descriptor_search((PPTP_PAC_DESCRIPTOR_NODE *)Tree->rb_header.LChild, key) ;
	}
		else
		{
#if PROXY_RB_STATISTICS
			statistics.number_of_search_hits++ ;
#endif	

			return Tree ;
		}
} 

#if 0
extern unsigned long scc1_collision_errors ;
extern unsigned long scc1_overflow_errors ;
extern unsigned long scc1_CRC_errors ;
extern unsigned long scc1_short_frame_errors ;
extern unsigned long scc1_non_octet_aligned_frame_errors ;
extern unsigned long scc1_frame_length_violation_errors ;
#define PRINT_BUFFER_SIZE 1000
char print_buffer[PRINT_BUFFER_SIZE] ;

void display_proxy_tree ()
{
#if 0
	int index=0 ;
	PPTP_PAC_DESCRIPTOR_NODE *sptr_root = sptr_pptp_pac_descriptor_tree;
	PPTP_PAC_DESCRIPTOR_NODE *sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;
	
	printf ("\n\nDisplaying Redblack Tree.....\n") ;
	while (sptr_next_node)
	{
		printf ("[%d]. %d      %d\n", ++index, sptr_next_node->key.protocol_type,
						sptr_next_node->key.application_port);
					
		sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

#endif

#if 1
	BYTE application_buffer[200], temp_buffer[100];
	USHORT index = 0 ;
   PPTP_PAC_DESCRIPTOR_NODE *sptr_root = sptr_pptp_pac_descriptor_tree ;
	PPTP_PAC_DESCRIPTOR_NODE *sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;
		
	application_buffer[0] = 0 ;
	printf ("\nPROXY: Proxy Server Configuration...............\n") ;
	printf ("Number of Applications %d\n",statistics.number_of_nodes);
	while (sptr_next_node)
	{
		if (index && ((index % 3) == 0))
		{
			printf ("%s", &application_buffer[0]) ;
			application_buffer[0] = 0 ;
		}
		sprintf (&temp_buffer[0], "\tProtocol : %04d Application : %04d\n",
					sptr_next_node->key.protocol_type,
					sptr_next_node->key.application_port);
		strcat (&application_buffer[0], &temp_buffer[0]) ;
		index++;
		sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}
#endif
	return ;
}

#endif

void add_entry_to_pptp_pac_descriptor_tree (BYTE *pptp_pac_descriptor, unsigned char *vptr_buffer)
{
   PPTP_RB_INFO_TYPE info ;
	
	if (sptr_pptp_pac_descriptor_tree == NULL)
		sptr_pptp_pac_descriptor_tree = (PPTP_PAC_DESCRIPTOR_NODE *) sptr_RB_sentinal_node;


   info.ptr_to_pptp_descriptor = pptp_pac_descriptor ;

   proxy_RB_demo_insert (*((PPTP_RB_KEY_TYPE *)(vptr_buffer)), info) ;
	/* this 8 is sizeof(ULONG) and USHORT */
}

#define TEMP 0
#if 0
void initialize_proxy_rb_tree ()
{
   PPTP_RB_KEY_TYPE proxy_descriptor_key ;
   int i ;
   PPTP_RB_INFO_TYPE info ;

   info.age = proxy_descriptor_rb_node_age ;

   sptr_pptp_pac_descriptor_tree = (PPTP_PAC_DESCRIPTOR_NODE *) sptr_RB_sentinal_node ;

   ethernet_address.ethernet_address_ulong = 0x00FFFFFF ;
   ethernet_address.ethernet_address_ushort = 0xFFFF ;

   for (i = 0 ; i < 300 ; i++)
   {
      proxy_RB_demo_insert (ethernet_address, info) ;
      ethernet_address.ethernet_address_ulong-- ;
   }
}
#endif


int delete_entry_from_pptp_pac_tree (PPTP_RB_KEY_TYPE key)
{
   PPTP_PAC_DESCRIPTOR_NODE *sptr_node_to_delete ;

   sptr_node_to_delete = pptp_pac_descriptor_search (sptr_pptp_pac_descriptor_tree, key) ;
   if (sptr_node_to_delete)
   {
     	sptr_pptp_pac_descriptor_tree = (PPTP_PAC_DESCRIPTOR_NODE *) RB_delete ((RED_BLACK_NODE_HEADER *)sptr_pptp_pac_descriptor_tree, (RED_BLACK_NODE_HEADER *)sptr_node_to_delete, (unsigned long) sizeof (PPTP_PAC_DESCRIPTOR_NODE), (RED_BLACK_NODE_HEADER **)&sptr_node_to_delete) ;
		free (sptr_node_to_delete);
      return (1) ;
   }
   return (0) ;
}



void age_pac_descriptor_tree ()
{
#if 0
	PPTP_PAC_DESCRIPTOR_NODE *sptr_temp, *sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_pptp_pac_descriptor_tree) ;

   while (sptr_next_node)
   {
      sptr_temp = sptr_next_node ;
      sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
      if (sptr_temp->info.age)
      {
         sptr_temp->info.age-- ;
      }
      else
      {
#if 0
         sptr_pptp_pac_descriptor_tree = (PPTP_PAC_DESCRIPTOR_NODE *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_temp,
                      (RED_BLACK_NODE_HEADER *)sptr_pptp_pac_descriptor_tree,
                      (unsigned long) sizeof (PPTP_PAC_DESCRIPTOR_NODE),
                      (RED_BLACK_NODE_HEADER **)&sptr_temp) ;
#endif
      }
   }
#endif
}

void delete_aged_out_entries_in_pac_descriptor (void)
{
#if 0
	PPTP_PAC_DESCRIPTOR_NODE *x, *sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_pptp_pac_descriptor_tree) ;
   
   while (sptr_next_node)
   {
      if (sptr_next_node->info.age)
      {
      }
      else
      {
         sptr_pptp_pac_descriptor_tree = (PPTP_PAC_DESCRIPTOR_NODE *)
            RB_delete((RED_BLACK_NODE_HEADER *)sptr_next_node,
                      (RED_BLACK_NODE_HEADER *)sptr_pptp_pac_descriptor_tree,
                      (unsigned long) sizeof (PPTP_PAC_DESCRIPTOR_NODE),
                      (RED_BLACK_NODE_HEADER **)&x) ;
#if PROXY_RB_STATISTICS
         statistics.number_of_deletions++ ;
#endif
         free_proxy_rb_node (x) ;
         /* In one pass, delete just one. In fact as an optimization,
         we can keep track of the existence of aged out entries in
         a class variable so that we dont even need to call this function
         in case there are no aged entries */
         return ;
      }
      sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
   }
#endif
}



#define PRINT_BUFFER_SIZE 1000
static char pr_print_buffer[PRINT_BUFFER_SIZE] ;
void display_pac_descriptors ()
{

#if 0
	int i = 1, j ;
	unsigned char ch ;
	unsigned char *x ;
	char *print_buffer_ptr = &pr_print_buffer[0] ;
	int print_buffer_length = 0 ;
   PPTP_PAC_DESCRIPTOR_NODE *sptr_root = sptr_pptp_pac_descriptor_tree ;
	PPTP_PAC_DESCRIPTOR_NODE *sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_first_node ((RED_BLACK_NODE_HEADER *)sptr_root) ;

	printf ("\n\nDisplaying Redblack Tree.....\n") ;
	while (sptr_next_node)
	{
		sprintf (print_buffer_ptr, "\n\tNode %04d : ", i++) ;
		print_buffer_ptr += 14 ;
		print_buffer_length += 14 ;
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}
		x = (unsigned char *) &sptr_next_node->key ;
		for (j = 0 ; j < sizeof (PPTP_RB_KEY_TYPE) ; j++)
		{
			ch =  *x++ ;
			sprintf (print_buffer_ptr, "%02X", ch) ;
			print_buffer_ptr += 2 ;
			print_buffer_length += 2 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &pr_print_buffer[0]) ;
				print_buffer_ptr = &pr_print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
#if 0
      sprintf (print_buffer_ptr, ", Age : %04d seconds", sptr_next_node->info.age/20) ;
		print_buffer_ptr += 20 ;
		print_buffer_length += 20 ;
#endif
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}
#if 0
      sprintf (print_buffer_ptr, ", Port : %04d", sptr_next_node->info.port_number) ;
		print_buffer_ptr += 13 ;
		print_buffer_length += 13 ;
#endif
		if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
		{
			*print_buffer_ptr = 0 ;
			printf ("%s", &pr_print_buffer[0]) ;
			print_buffer_ptr = &pr_print_buffer[0] ;
			print_buffer_length = 0 ;
		}


		if (sptr_next_node == sptr_root)
		{
			sprintf (print_buffer_ptr, " (ROOT)") ;
			print_buffer_ptr += 7 ;
			print_buffer_length += 7 ;
			if (print_buffer_length >= PRINT_BUFFER_SIZE - 50)
			{
				*print_buffer_ptr = 0 ;
				printf ("%s", &pr_print_buffer[0]) ;
				print_buffer_ptr = &pr_print_buffer[0] ;
				print_buffer_length = 0 ;
			}
		}
		sptr_next_node = (PPTP_PAC_DESCRIPTOR_NODE *) RB_get_next_node ((RED_BLACK_NODE_HEADER *)sptr_next_node) ;
	}

	if (print_buffer_length)
		printf ("%s\n\n", &pr_print_buffer[0]) ;
	
	return ;
#endif
}
