
#include <defs.h>

#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <stdlib.h>
#include <kstart.h>

#include <string.h>
#include <memory.h>
#include <wanmgr.h>
#include "proxy.h"
#include "proip.h"

#include <redblack.h>
#include "proxyrb.h"

#include "vpptpstr.h"
#include "\rtrware\store\boot.h"		/* for model numbers */

#define PROXY_DEBUG 1

/* sudha 08 June 1999 */
#define MAX_TCP_APPLICATIONS     43
#define MAX_UDP_APPLICATIONS     42

/* sudha 20 Aug 1999 */
#define TOTAL_TCP_APPLICATIONS     48 
/* MAX_TCP_APPLICATIONS + number of entries with double port numbers */
#define TOTAL_UDP_APPLICATIONS     47
/* MAX_UDP_APPLICATIONS + number of entries with double port numbers */

/* sudha 19 Jan 1999 */
BOOL is_user_defined_port_not_in_reserved_port_list(USHORT lower_port, USHORT higher_port);
BOOL is_user_defined_port_desc_not_in_reserved_port_desc(BYTE user_desc[16]);

ULONG get_static_or_dynamic_mapped_local_address_from_interface_address (ULONG destination_address, USHORT destination_port, USHORT protocol);

/* sudha 19 Aug 1999 */
USHORT get_port_index (USHORT protocol_type, USHORT protocol_port_number);
void set_protocol_port_number (USHORT protocol_type, USHORT port_number, USHORT application_index);
USHORT get_port_numbers_from_application (USHORT protocol_type, char *application, 
	USHORT *ctrl_port, USHORT *data_port, USHORT *ctrl_index, USHORT *data_index);

extern PROXY_SERVER_CLASS proxy_server;
extern enum BOOLEAN is_close_connection_initiated (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);

/* sudha 24 May 1999 */
extern enum BOOLEAN is_physical_port_available_for_proxying (USHORT port_number);

extern USHORT get_icmp_echo_request_id (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern BYTE *get_ptr_to_icmp_header (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern enum BOOLEAN is_icmp_echo_request_message (UNION_IP_PACKET *ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern void set_icmp_checksum (BYTE *ptr_to_icmp_header, USHORT new_csum);
extern USHORT get_tcp_src_port_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern USHORT get_tcp_dst_port_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);


extern BYTE *get_ptr_to_tcp_header (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern USHORT get_matched_port_from_existing_descriptor (USHORT reserved_port, IP_PARAMETERS *sptr_ip_parameters);

extern void get_dns_response_packet(UNION_IP_PACKET *sptr_ip_packet, IP_PARAMETERS *sptr_ip_parameters, BYTE *dns_resp_pkt, 
	USHORT length, void (*fptr_tx_completion) (USHORT port_number, void *vptr_tx_packet));
extern BYTE *get_domain_name_from_dns_query_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern BYTE *get_dns_response_from_local_cache_if_any ( BYTE *domain_name, USHORT *data_len, USHORT dns_id);
extern USHORT get_quest_count_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
extern USHORT get_send_id_from_dns_query_pkt(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern enum BOOLEAN is_dns_query_pkt_destined_to_lan_of_proxy_as_dns_server(UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters) ;
extern USHORT get_udp_port_number_from_ip_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, USHORT *destination_port);
extern enum BOOLEAN is_proxy_lan_addr ( ULONG lan_addr ) ;
extern ULONG get_dns_server_address (USHORT port_number);


extern PROXY_APPLICATION_LIST_NODE far *proxy_rb_demo_search(PROXY_APPLICATION_LIST_NODE far *Tree, PROXY_RB_KEY_TYPE key);
extern PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_rb_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_RB_CLIENT_KEY_TYPE key);
extern PROXY_SERVER_DESCRIPTOR_NODE far *proxy_rb_server_descriptor_search(PROXY_SERVER_DESCRIPTOR_NODE far *Tree, PROXY_RB_SERVER_KEY_TYPE key);


extern void check_for_pptp_client_packet_and_process (BYTE *uptr_ip_rx_packet , IP_PARAMETERS *sptr_ip_parameters,
		USHORT tx_port_number);
extern void process_client_gre_packet_if_required (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
		PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info);
extern void check_for_pptp_server_packet_and_process (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);
extern void process_server_gre_packet_if_required (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
			PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info);
extern void send_completion_udp_packet (USHORT port_number, UNION_IP_PACKET *sptr_udp_tx_packet);


extern void add_entry_to_proxy_client_descriptor_tree (BYTE *proxy_client_descriptor, unsigned char *vptr_buffer);
extern void add_entry_to_proxy_server_descriptor_tree (BYTE *proxy_server_descriptor, unsigned char *vptr_buffer);
/* sudha 31 March 1999 */
extern void proxy_rb_pasv_ftp_ctrl_client_descriptor_search(PROXY_CLIENT_DESCRIPTOR_NODE far *Tree, PROXY_SERVER_INFO *ptr_proxy_info);


extern PROXY_APPLICATION_LIST_NODE far *sptr_proxy_address_tree ;
extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_proxy_client_descriptor_tree ;
extern PROXY_SERVER_DESCRIPTOR_NODE far *sptr_proxy_server_descriptor_tree ;
extern PROXY_LINKCTRL_DESCRIPTOR_NODE far *sptr_proxy_linkctrl_descriptor_tree;

extern BYTE *check_for_ftp_port_command_and_process (BYTE *uptr_ip_rx_packet, enum BOOLEAN *return_value, IP_PARAMETERS *sptr_ip_parameters, PROXY_SERVER_INFO *sptr_control_connection);

extern PPTP_INFO_DESCRIPTOR *get_ptr_to_pptp_info_from_gre_packet (BYTE *, IP_PARAMETERS *);
extern PPTP_INFO_DESCRIPTOR *get_ptr_to_pptp_info_from_gre_response_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters);

extern enum BOOLEAN is_port_is_remote_access (USHORT port_number);
extern USHORT is_the_link_member_of_some_bundle(USHORT link);
extern BYTE is_mlppp_enabled();
extern enum BOOLEAN if_mlppp();

extern enum BOOLEAN is_triggering_is_needed(USHORT port_number) ; /* sudha 30 Nov 1998 */

BYTE use_dial_triggered_port = FALSE  ;

/* Jo 30/07/99 Added for Static routes */
extern enum BOOLEAN static_port_list[NUMBER_OF_IP_PORTS] ;
extern enum BOOLEAN get_port_number_if_statically_configured (ULONG destination_address, USHORT *port_number) ;

extern BYTE *sptr_proxy_mapped_port_status;


typedef struct
{
	USHORT protocol_port_number ;
	char *application ;
} PORT_TO_APPLICATION_MAP ;

PORT_TO_APPLICATION_MAP tcp_applications[] =
{
	{531, "CHAT", },
	{53, "DNS"},
	{7, "ECHO"},
	{79, "FINGER"},
	{21, "FTP"},
	{70, "GOPHER"},
	{144, "NEWS"},
	{110, "POP-3"},
	{532, "READNEWS"},
	{513, "RLOGIN"},
	{25,  "SMTP"},
	{23, "TELNET"},
	{69, "TFTP"},
	{80, "WEB"},
	{42, "HOST NAME SERVER"},
	{443, "HTTPS"},
	{194, "IRC"},
	{119, "NNTP"},
	{563, "SSL-NNTP"},
	{465, "SSL-SMTP"},
	{143, "IMAP"},
	{161, "SNMP"},
	{162, "SNMP-TRAP"},
	{220, "IMAP3"},
	{990, "SSL-FTP"},
	{992, "SSL-Telnet"},
	{993, "SSL-IMAP4"},
	{994, "SSL-IRC"},
	{995, "SSL-POP3"},
	{1090, "Real audio/video"},
	{1723, "PPTP"},
	{6667, "MIRC"},
	{1755, "MS-Streaming"},
	{8000, "Vxtreme"},
	{7070, "Real audio/video"},
	{5190, "AOL"},
	{902, "Q931"},
	{5006, "RTP"},
	{5007, "RTCP"},
	{5000, "VOIP - Statistics"},
	{6284, "Road Runner1"},
	{6285, "Road Runner2"},
	{7283, "Road Runner3"},
	{20, "FTP"},
	{989, "SSL-FTP"},
	{900, "Q931"},
	{5004, "RTP"},
	{5005, "RTCP"},
	{0, ""}
} ;


PORT_TO_APPLICATION_MAP udp_applications[] =
{
	{531, "CHAT"},
	{53, "DNS"},
	{7, "ECHO"},
	{79, "FINGER"},
	{21, "FTP"},
	{70, "GOPHER"},
	{144, "NEWS"},
	{110, "POP-3"},
	{532, "READNEWS"},
	{25,  "SMTP"},
	{23, "TELNET"},
	{69, "TFTP"},
	{80, "WEB"},
	{42, "HOST NAME SERVER"},
	{443, "HTTPS"},
	{194, "IRC"},
	{119, "NNTP"},
	{563, "SSL-NNTP"},
	{465, "SSL-SMTP"},
	{143, "IMAP"},
	{161, "SNMP"},
	{162, "SNMP_TRAP"},
	{220, "IMAP3"},
	{990, "SSL-FTP"},
	{992, "SSL-Telnet"},
	{993, "SSL-IMAP4"},
	{994, "SSL-IRC"},
	{995, "SSL-POP3"},
	{1090, "Real audio/video"},
	{1723, "PPTP"},
	{6667, "MIRC"},
	{1755, "MS-Streaming"},
	{8000, "Vxtreme"},
	{7070, "Real audio/video"},
	{5190, "AOL"},
	{902, "Q931"},
	{5006, "RTP"},
	{5007, "RTCP"},
	{5000, "VOIP - Statistics"},
	{6284, "Road Runner1"},
	{6285, "Road Runner2"},
	{7283, "Road Runner3"},
	{20, "FTP"},
	{989, "SSL-FTP"},
	{900, "Q931"},
	{5004, "RTP"},
	{5005, "RTCP"},
	{0, ""}
};



char *get_protocol_type (char *protocol_type_string, enum IP_PROTOCOL_VALUE protocol_type)
{
	switch (protocol_type)
	{
		case (ICMP_PROTOCOL) :
			strcpy (protocol_type_string, "ICMP") ;
			break ;

		case (TCP_PROTOCOL) :
			strcpy (protocol_type_string, "TCP") ;
			break ;

		case (IGP_PROTOCOL) :
			strcpy (protocol_type_string, "IGP") ;
			break ;

		case (UDP_PROTOCOL) :
			strcpy (protocol_type_string, "UDP") ;
			break ;

/* sudha taken from Ravi on 16 Nov 1998 */
		case (TCP_UDP_PROTOCOL) :
			strcpy (protocol_type_string, "TCP & UDP") ;
			break ;

		default :
			strcpy (protocol_type_string, "Unknown") ;
			break ;
	}
	return (protocol_type_string) ;
}




USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index)
{

	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
/* sudha 27 Nov 1998 */
		case (TCP_UDP_PROTOCOL) : 
			if (application_index < (MAX_TCP_APPLICATIONS + 1))
				return tcp_applications[application_index-1].protocol_port_number	;
			
		case (UDP_PROTOCOL) :
			if (application_index < (MAX_UDP_APPLICATIONS + 1))
				return udp_applications[application_index-1].protocol_port_number	;

		default:
			return application_index;
	}
	return 0;
}


char *get_port_type (char *port_type_string, enum IP_PROTOCOL_VALUE protocol_type, USHORT protocol_port_number)
{
	int index ;

	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
/* sudha taken from Ravi On 17 Nov 1998 ... */
		case (TCP_UDP_PROTOCOL) :

			for (index = 0 ;
			     tcp_applications[index].protocol_port_number && tcp_applications[index].protocol_port_number != protocol_port_number ;
			     index++) ;
				if (tcp_applications[index].protocol_port_number == 0)
				{
					return ("user defined");
/*					sprintf (port_type_string, "%04X", protocol_port_number) ; */
				}
				else
					strcpy (port_type_string, tcp_applications[index].application) ;
				break ;

		case (UDP_PROTOCOL) :
			for (index = 0 ;
			     udp_applications[index].protocol_port_number && udp_applications[index].protocol_port_number != protocol_port_number ;
			     index++) ;
				if (udp_applications[index].protocol_port_number == 0)
				{
					return ("user defined");
/*					sprintf (port_type_string, "%04X", protocol_port_number) ; */
				}
				else
					strcpy (port_type_string, udp_applications[index].application) ;
				break ;

		default :
			
			sprintf (port_type_string, "%04X", protocol_port_number) ;
	}
	return (port_type_string) ; 
}

/* sudha 19 Aug 1999. For FTP configurable ctrl & data ports */
USHORT get_port_index (USHORT protocol_type, USHORT protocol_port_number)
{
	int index ;

	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
			for (index = 0 ;
			     tcp_applications[index].protocol_port_number && tcp_applications[index].protocol_port_number != protocol_port_number ;
			     index++) ;
				if (strcmp(tcp_applications[index].application,"") == 0)
					return 0xFF; /* user defined entry */
				else
					break ;

		case (UDP_PROTOCOL) :
			for (index = 0 ;
			     udp_applications[index].protocol_port_number && udp_applications[index].protocol_port_number != protocol_port_number ;
			     index++) ;
				if (strcmp(udp_applications[index].application,"") == 0)
				{
					printf("\n\rUDP Fail1 %d", index);
					return 0xFF; /* user defined entry */
				}
				else
					break ;

		default :
			printf("\n\rUDP Fail2. %d", UDP_PROTOCOL);
			return 0xFF;
	}
/* printf("\n\rPROXY: Index is %d",index); */
	return (index) ; 
}

void set_protocol_port_number (USHORT protocol_type, USHORT port_number, USHORT application_index)
{
	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
			if (application_index < TOTAL_TCP_APPLICATIONS)
			{
				tcp_applications[application_index].protocol_port_number	= port_number;
				return;
			}
			break;

		case (UDP_PROTOCOL) :
			if (application_index < TOTAL_UDP_APPLICATIONS)
			{
				udp_applications[application_index].protocol_port_number = port_number;
				return;
			}
			break;

		default:
			printf("\n\rUDPset is %d", UDP_PROTOCOL);
			return ;
	}
	return ;
}


USHORT get_port_numbers_from_application (USHORT protocol_type, char *application, 
	USHORT *ctrl_port, USHORT *data_port, USHORT *ctrl_index, USHORT *data_index)
{
	int index1 = 0, index2 = 0;
	switch (protocol_type)
	{
		case (TCP_PROTOCOL) :
			for (index1 = 0 ;
			     tcp_applications[index1].protocol_port_number && 
				  (strcmp(tcp_applications[index1].application,application) != 0);
			     index1++) ;
				if (strcmp(tcp_applications[index1].application,"") == 0)
					return 0; /* user defined entry */
				else
				{
					*ctrl_port = tcp_applications[index1].protocol_port_number;
					*ctrl_index = index1;
				}

			for (index2 = index1 + 1;
			     tcp_applications[index2].protocol_port_number && 
				  (strcmp(tcp_applications[index2].application,application) != 0);
			     index2++) ;
				if (strcmp(tcp_applications[index2].application,"") == 0)
					return 0; /* user defined entry */
				else
				{
					*data_port = tcp_applications[index2].protocol_port_number;
					*data_index = index2;
				}
			break;

		case (UDP_PROTOCOL) :

			for (index1 = 0 ;
			     udp_applications[index1].protocol_port_number && 
				  (strcmp(udp_applications[index1].application,application) != 0);
			     index1++) ;
				if (strcmp(udp_applications[index1].application,"") == 0)
				{
					printf("\n\rUDP Fail3.%d", index1);
					return 0; /* user defined entry */
				}
				else
				{
					*ctrl_port = udp_applications[index1].protocol_port_number;
					*ctrl_index = index1;
				}

			for (index2 = index1 + 1;
			     udp_applications[index2].protocol_port_number && 
				  (strcmp(udp_applications[index2].application,application) != 0);
			     index2++) ;
				if (strcmp(udp_applications[index2].application,"") == 0)
				{
					printf("\n\rUDP Fail4 %d", index2);
					return 0; /* user defined entry */
				}
				else
				{
					*data_port = udp_applications[index2].protocol_port_number;
					*data_index = index2;
				}
			break;

		default:
			printf("\n\rUDPget is %d", UDP_PROTOCOL);
			break;
	}
/* printf("\n\rPROXY : port is %d, index  is %d, data is %d, index is %d", 
*ctrl_port, *ctrl_index, *data_port, *data_index); */
	return 1;
}

int readjust_checksum (BYTE *old_ptr, BYTE *new_ptr, BYTE *csum_ptr)
{
	USHORT modified_length, variable_length=0;
	int int_csum=0, old_csum=0, new_csum=0;
	
	int_csum = csum_ptr[0]*256 + csum_ptr[1];
	int_csum = ~int_csum;

	modified_length = sizeof (TCP_CHANGED_VARIABLES);
	
	variable_length = modified_length;
	
   while (variable_length) 
	{
      if (variable_length==1) 
		{
         old_csum = old_ptr[0]*256+ old_ptr[1];
         int_csum-=old_csum & 0xff00;
         if (int_csum<=0) 
			{ 
				int_csum--; 
				int_csum &=0xffff; 
			}
         break;
       }
       else 
		 {
         old_csum = old_ptr[0]*256+old_ptr[1]; 
			old_ptr+=2;
         int_csum -= old_csum & 0xffff;
         if (int_csum <=0) 
			{ 
				int_csum--; 
				int_csum &=0xffff; 
			}
         variable_length -=2;
       }
   }
			
	variable_length = modified_length;

   while (variable_length) 
	{
   	if (variable_length ==1) 
		{
      	new_csum = new_ptr[0]*256+new_ptr[1];
         int_csum +=new_csum & 0xff00;
         if (int_csum & 0x10000) 
			{ 
				int_csum++; 
				int_csum &=0xffff; 
			}
         break;
      }
      else 
		{
      	new_csum = new_ptr[0]*256+new_ptr[1]; 
			new_ptr+=2;
         int_csum += new_csum & 0xffff;
         if (int_csum  & 0x10000) 
			{ 
				int_csum++; 
				int_csum &=0xffff; 
			}
         variable_length -=2;
      }
   }

	int_csum = ~int_csum;
	return int_csum;					
}



#if 0
BYTE *checksumadjust(BYTE *chksum, BYTE *optr, int olen, BYTE *nptr, int nlen) 
/* assuming: unsigned char is 8 bits, long is 32 bits.
- chksum points to the chksum in the packet
- optr points to the old data in the packet
- nptr points to the new data in the packet
   */
{
	int x, old, new;
   x=chksum[0]*256+chksum[1];
   x=~x;

   while (olen) 
	{
      if (olen==1) 
		{
         old=optr[0]*256+optr[1];
         x-=old & 0xff00;
         if (x<=0) 
			{ 
				x--; 
				x&=0xffff; 
			}
         break;
       }
       else 
		 {
         old=optr[0]*256+optr[1]; 
			optr+=2;
         x-=old & 0xffff;
         if (x<=0) 
			{ 
				x--; 
				x&=0xffff; 
			}
         olen-=2;
       }
   }

   while (nlen) 
	{
   	if (nlen==1) 
		{
      	new=nptr[0]*256+nptr[1];
         x+=new & 0xff00;
         if (x & 0x10000) 
			{ 
				x++; 
				x&=0xffff; 
			}
         break;
      }
      else 
		{
      	new=nptr[0]*256+nptr[1]; nptr+=2;
         x+=new & 0xffff;
         if (x & 0x10000) 
			{ 
				x++; 
				x&=0xffff; 
			}
         nlen-=2;
      }
   }
	x++;
   x=~x;
   chksum[0]=x/256; chksum[1]=x & 0xff;
	return chksum;
#if 0
	memcpy (tcpchksum, &chksum[0], 2);
	printf ("Checksum is %04x\n",chksum);
#endif
}
#endif


UNION_IP_PACKET *update_tcp_checksum_in_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	BYTE *ptr_to_tcp_packet;
	USHORT tcp_packet_size=0;


	tcp_packet_size = uptr_ip_rx_packet->ip.header.total_length - (USHORT) (uptr_ip_rx_packet->ip.header.version_header_length.header_length << 2);
	
	ptr_to_tcp_packet = (BYTE *) ((ULONG) uptr_ip_rx_packet + sizeof(UNION_MAC_HEADER) + (ULONG) (uptr_ip_rx_packet->ip.header.version_header_length.header_length << 2)); 

	tcp_checksum (uptr_ip_rx_packet->ip.header.source_ip_address,uptr_ip_rx_packet->ip.header.destination_ip_address,
				ptr_to_tcp_packet,tcp_packet_size);
	
	return (uptr_ip_rx_packet);
}



UNION_IP_PACKET *update_udp_checksum_in_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	PSEUDO_IP_PARAMETERS pseudo_header;
	UDP_HEADER *ptr_to_udp_hdr;
	BYTE *ptr_to_udp_packet;

	ptr_to_udp_packet = (BYTE *) ((ULONG) uptr_ip_rx_packet + sizeof(UNION_MAC_HEADER) + sptr_ip_parameters->header_length);
	ptr_to_udp_hdr = (UDP_HEADER *)ptr_to_udp_packet;
		
	pseudo_header.length = ptr_to_udp_hdr->length;
	pseudo_header.source_address = sptr_ip_parameters->source_address;
	pseudo_header.destination_address = sptr_ip_parameters->destination_address;
	pseudo_header.zero_field = 0x00;
	pseudo_header.protocol = UDP_PROTOCOL;
	
	ptr_to_udp_hdr->checksum = 0x0000;	

	compute_checksum_for_packet (&pseudo_header,(UDP_PACKET *)uptr_ip_rx_packet, ptr_to_udp_hdr->length);

	return (uptr_ip_rx_packet);
}

enum BOOLEAN is_new_port_already_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status, port_status;
	BYTE exp_bit_mask[] = {1,2,4,8,16,32,64,128};
	
	offset = application_port / 8;
	bit_position = application_port % 8;
	
	if (sptr_proxy_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_proxy_mapped_port_status +  (ULONG) offset);
		port_status = 	*ptr_to_bit_status & exp_bit_mask[bit_position];
		if (port_status)
			return TRUE;
	}
	return FALSE;
}				

void set_port_status_to_not_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status;
	BYTE exp_bit_mask[] = {254, 253, 251, 247, 239, 223, 191, 127};
	

	offset = application_port / 8;
	bit_position = application_port % 8;
			
	if (sptr_proxy_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_proxy_mapped_port_status +  (ULONG) offset);
		*ptr_to_bit_status &= exp_bit_mask[bit_position];  /* Imran, 10/2/99 */
	}
	
	return;
}

void set_port_status_to_in_use (USHORT application_port)
{
	USHORT offset=0 , bit_position=0;
	BYTE *ptr_to_bit_status;
	BYTE exp_bit_mask[] = {1,2,4,8,16,32,64,128};


	offset = application_port / 8;
	bit_position = application_port % 8;

	if (sptr_proxy_mapped_port_status != NULL)
   {
		ptr_to_bit_status = (BYTE *) ((ULONG )sptr_proxy_mapped_port_status +  (ULONG) offset);
		*ptr_to_bit_status |= exp_bit_mask[bit_position];   /* Imran, 10/2/99 */
	}
	return;		
}




USHORT get_application_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT *destination_port)
{
	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_ICMP:
			return INVALID_DESTINATION_PORT;

		case IP_DATA_TCP:
			return (get_tcp_port_number_from_ip_packet (uptr_ip_rx_packet, sptr_ip_parameters, destination_port));

		case IP_DATA_UDP:
			return (get_udp_port_number_from_ip_packet(uptr_ip_rx_packet, sptr_ip_parameters, destination_port));
	}
}

#if 0
USHORT get_a_free_port (USHORT application_port)
{

/* Modified for rlogin */

	switch (application_port)
	{
		case RLOGIN_PORT:
			while (1)
			{
				proxy_server.reserved_port_number_value++;
				if (proxy_server.reserved_port_number_value == 1023)
					proxy_server.reserved_port_number_value = STARTING_RESERVED_PORT;
				if (is_new_port_already_in_use (proxy_server.reserved_port_number_value) == FALSE)
				{
					set_port_status_to_in_use (proxy_server.reserved_port_number_value);
					break;
				}
			}
			return (proxy_server.reserved_port_number_value);					
							
		default:
			while (1)
			{
				proxy_server.dynamic_port_number++;
				if (proxy_server.dynamic_port_number == 0)
					proxy_server.dynamic_port_number = DYNAMIC_PORT_NUMBER;
				if (is_new_port_already_in_use (proxy_server.dynamic_port_number) == FALSE)
				{
					set_port_status_to_in_use (proxy_server.dynamic_port_number);
					break;
				}
			}	
			return (proxy_server.dynamic_port_number);
	}
}
#endif


/* Imran on 10/2/99,ported changes from firewall code for best effort
allocation of port */
USHORT get_a_free_port (USHORT application_port, USHORT source_port)
{

/* Modified for rlogin */

	switch (application_port)
	{
		case RLOGIN_PORT:
			while (1)
			{
				proxy_server.reserved_port_number_value++;
				if (proxy_server.reserved_port_number_value == 1023)
					proxy_server.reserved_port_number_value = STARTING_RESERVED_PORT;
				if (is_new_port_already_in_use (proxy_server.reserved_port_number_value) == FALSE)
				{
					set_port_status_to_in_use (proxy_server.reserved_port_number_value);
					break;
				}
			}
			return (proxy_server.reserved_port_number_value);					
							
		default:
/* Vidy 28/08/98, to take care of best effort allocation of the same port.
Some applications try to look at the incoming source port to
decide somethings (which is non-IP?) like VOIP, cable modem login etc */

			if (source_port)
			{
				if (is_new_port_already_in_use (source_port) == FALSE)
				{
					set_port_status_to_in_use (source_port);
					return source_port;
				}
			}
			while (1)
			{
				proxy_server.dynamic_port_number++;
				if (proxy_server.dynamic_port_number == 0)
					proxy_server.dynamic_port_number = DYNAMIC_PORT_NUMBER;
				if (is_new_port_already_in_use (proxy_server.dynamic_port_number) == FALSE)
				{
					set_port_status_to_in_use (proxy_server.dynamic_port_number);
					break;
				}
			}	
			return (proxy_server.dynamic_port_number);
	}
}



USHORT get_proper_port_to_send_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT reserved_port=0, port_number=0, dummy_port=0, application_index=0,application_port=0;
	PROXY_APPLICATION_TABLE *proxy_application_list = proxy_server.sptr_application_list;
	enum BOOLEAN is_port_triggered=FALSE;
	BYTE log_buffer[100];
	PROXY_RB_KEY_TYPE proxy_rb_key;
	PROXY_APPLICATION_LIST_NODE *proxy_temp_application_node;
			
	
	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_TCP:
			reserved_port = get_tcp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
						sptr_ip_parameters, &dummy_port);
			break;

		case IP_DATA_UDP:
			reserved_port = get_udp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
						sptr_ip_parameters, &dummy_port);
			break;

		default:
			break;
	}
		
	proxy_rb_key.protocol_type = sptr_ip_parameters->protocol;
	proxy_rb_key.application_port = reserved_port;

	proxy_temp_application_node = proxy_rb_demo_search (sptr_proxy_address_tree, proxy_rb_key);

	if (proxy_temp_application_node  && proxy_temp_application_node->info.same_port_required)
		port_number = get_matched_port_from_existing_descriptor (reserved_port, sptr_ip_parameters);							

	if (port_number)
	{
      proxy_server.port[port_number].number_of_connections++ ;
/*		printf ("PROXY: Allocating Same Port %04x as configured\n",port_number);*/
		return port_number;
	}
			

	port_number = get_outgoing_port_number(&is_port_triggered, sptr_ip_parameters->source_address, sptr_ip_parameters->destination_address);
	if (is_port_triggered == TRUE)
	{
		application_port = get_tcp_dst_port_from_ip_packet (uptr_ip_rx_packet, sptr_ip_parameters);
		sprintf (&log_buffer[0], "PROXY: Dialing port %d to Proxy application %d  %d",
				port_number, sptr_ip_parameters->protocol, application_port);
		write_log (log_buffer);
	}

	if (port_number == INVALID_PHYSICAL_PORT)
	{
		port_number = proxy_server.last_allocated_port;
		if ((port_number >= 1) && (port_number <= NUMBER_OF_PROXY_PORTS))
		{
/* sudha 03 dec 1998 */
			if (is_physical_port_available_for_proxying(port_number) == TRUE)
			{
			   if ((proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
					(is_triggering_is_needed(port_number-1) == TRUE) ||
					((is_wan_port_proxy_enabled(port_number - 1) == TRUE) && 
					(is_ipport_up(port_number) == FALSE)))
				{
			      printf ("PROXY1 : Triggering down-by-demand port %04X\n", port_number-1) ;
			      ppp_proxy_link_active (port_number-1) ;
				}
	      	proxy_server.port[port_number].number_of_connections++ ;
				printf ("PROXY: Port Allocation Failed, allocate %04x\n",port_number);
				return port_number;
			}
		}
		else
			return 0;
	}

/*
	if (is_port_is_remote_access (port_number) == TRUE && (port_number != 0) 
		&& is_the_link_member_of_some_bundle (port_number) == INVALID_PHYSICAL_PORT)
	{
		while (1)
			printf ("PROXY: Trying to Proxy on remote access port\n");
	} */

	return port_number;
}



PROXY_SERVER_INFO *get_free_proxy_server_info_ptr (USHORT application_port, BYTE *uptr_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, enum BOOLEAN *eptr_ftp_port_command)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	ULONG client_ip_address;
	enum BOOLEAN return_value= FALSE;
	PROXY_SERVER_INFO *new_descriptor;
	USHORT reserved_port=0, dummy_port=0;
	UNION_IP_PACKET *uptr_ip_rx_packet;
#if PROXY_DEBUG
	char mapped_ip_address[20], src_ip_address[20], dest_application[10], protocol_type_string[10] ;
	USHORT protocol_port ;
	enum IP_PROTOCOL_VALUE ip_protocol_type ;
#endif

	PROXY_RB_CLIENT_KEY_TYPE client_descriptor_key;
	PROXY_CLIENT_DESCRIPTOR_NODE far *proxy_temp_client_descriptor_list;

	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	PROXY_LINKCTRL_RB_KEY_TYPE link_control_key;



	*eptr_ftp_port_command = FALSE ;

	uptr_ip_rx_packet = (UNION_IP_PACKET *) uptr_rx_packet;
	client_ip_address = uptr_ip_rx_packet->ip.header.source_ip_address;


	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_TCP:
		case IP_DATA_UDP:
			client_descriptor_key.client_ip_address = client_ip_address;
			client_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
			client_descriptor_key.application_port = application_port;
			proxy_temp_client_descriptor_list = proxy_rb_client_descriptor_search (
							sptr_proxy_client_descriptor_tree, client_descriptor_key);

			if (proxy_temp_client_descriptor_list)
				ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) proxy_temp_client_descriptor_list->info.client_descriptor;

			reserved_port = get_tcp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
					sptr_ip_parameters, &dummy_port);

/* sudha 21 May 1999 */
#if 0
			if (proxy_temp_client_descriptor_list != NULL)	
				printf ("Application ports are %d : %d \n", dummy_port, ptr_to_proxy_server_info->source_port);
#endif
			if ( proxy_temp_client_descriptor_list != NULL &&
				  proxy_temp_client_descriptor_list->key.application_port == application_port && 
				  proxy_temp_client_descriptor_list->key.client_ip_address == client_ip_address &&
				  proxy_temp_client_descriptor_list->key.protocol_type == sptr_ip_parameters->protocol &&
				  ptr_to_proxy_server_info->source_port == dummy_port)
			{

/* This is to support FTP */
				if (reserved_port == proxy_server.ftp_ctrl_conn_port)													
				{
					new_descriptor = (PROXY_SERVER_INFO *) check_for_ftp_port_command_and_process (uptr_rx_packet, &return_value, sptr_ip_parameters, ptr_to_proxy_server_info);
				}		

				if (return_value == TRUE)
				{
					new_descriptor->ptr_to_ftp_command_descriptor = ptr_to_proxy_server_info;
					ptr_to_proxy_server_info->ptr_to_ftp_data_descriptor = new_descriptor;

#ifdef CTRL_DEBUG
printf("\n\rPROXY: data descriptor is : %x, ptr_server is %x",new_descriptor,
ptr_to_proxy_server_info);
printf("\n\rPROXY: app_port is %x,client_ip_addr is %x",application_port, client_ip_address);
#endif

/* This is to support TFTP */
					ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
/* This is to support TFTP */

					new_descriptor->incoming_physical_port = sptr_ip_parameters->rx_port_number;
		
					*eptr_ftp_port_command = TRUE ;
				}
				return (ptr_to_proxy_server_info);
			}

#if 0
				return ((PROXY_SERVER_INFO *)proxy_temp_client_descriptor_list->info.client_descriptor);
#endif

				
			
#if 0
			ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_first_entry_in_list ((LINK *)&proxy_server.proxy_server_info_list);

			while (ptr_to_proxy_server_info != NULL)
			{
				if (ptr_to_proxy_server_info->source_port == application_port && 
					ptr_to_proxy_server_info->client_ip_address == client_ip_address &&
						ptr_to_proxy_server_info->protocol_type == sptr_ip_parameters->protocol)
				{
					reserved_port = get_tcp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
								sptr_ip_parameters, &dummy_port);

/* This is to support FTP */
					if (reserved_port == proxy_server.ftp_ctrl_conn_port)													
					{
						new_descriptor = (PROXY_SERVER_INFO *) check_for_ftp_port_command_and_process (uptr_rx_packet, &return_value, sptr_ip_parameters, ptr_to_proxy_server_info);
					}		

					if (return_value == TRUE)
					{
						new_descriptor->ptr_to_ftp_command_descriptor = ptr_to_proxy_server_info;
						ptr_to_proxy_server_info->ptr_to_ftp_data_descriptor = new_descriptor;

/* This is to support TFTP */
						ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
/* This is to support TFTP */

						new_descriptor->incoming_physical_port = sptr_ip_parameters->rx_port_number;
		
						*eptr_ftp_port_command = TRUE ;
					}
					return (ptr_to_proxy_server_info);
				}
				ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_next_entry_in_list ((LINK *)ptr_to_proxy_server_info);
			}
#endif
		default:
			break;
	}
			
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) calloc (sizeof (PROXY_SERVER_INFO), 1);
	if (ptr_to_proxy_server_info == NULL)
	{
		proxy_printf ("PROXY_SERVER: Not Enough memory to proxy, Dropping packet\n");	
		return NULL;
	}

	ptr_to_proxy_server_info->ftp_port_command_on = FALSE;
	ptr_to_proxy_server_info->seq_offset = 0;
	
	ptr_to_proxy_server_info->in_use = TRUE;
	ptr_to_proxy_server_info->protocol_type = sptr_ip_parameters->protocol;
	ptr_to_proxy_server_info->destination_address = sptr_ip_parameters->destination_address;
		
	ptr_to_proxy_server_info->ptr_to_ftp_data_descriptor = NULL;
	ptr_to_proxy_server_info->source_port = application_port; 
	ptr_to_proxy_server_info->client_ip_address = uptr_ip_rx_packet->ip.header.source_ip_address ;				
	
	ptr_to_proxy_server_info->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;

	ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;

	ptr_to_proxy_server_info->connection_closing = FALSE;
	ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
	
	reserved_port = get_tcp_port_number_from_ip_packet ((BYTE *)uptr_ip_rx_packet,
							sptr_ip_parameters, &dummy_port);

	ptr_to_proxy_server_info->destination_port = reserved_port; /* sudha 30 March 1999. */

/*	printf ("Reserved port %d: Application port %d\n", reserved_port, application_port);	 */
	ptr_to_proxy_server_info->mapped_port = get_a_free_port(reserved_port, application_port);  /* Imran, 10/2/99 */

/* sudha 31 March 1999 */
	proxy_rb_pasv_ftp_ctrl_client_descriptor_search(sptr_proxy_client_descriptor_tree, ptr_to_proxy_server_info);	
	
#ifdef CTRL_DEBUG
	if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
		printf("\n\rPROXY: ftp command desc is %x",ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor);
#endif

/* Sachin, 23/12/1997 */
   if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
	{
		printf ("Setting idle timer for ftp\n");
	   ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
		ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;
	}
/* Sachin, 23/12/1997 */

/* Jo 09/08/99 Added for Static routes */
/* sudha 24 May 1999.Moved this block here from above... */
	if (sptr_ip_parameters->protocol == IP_DATA_ICMP)
		ptr_to_proxy_server_info->outgoing_physical_port = get_first_active_port(sptr_ip_parameters->destination_address);
	else 
	{
		if ((ptr_to_proxy_server_info->physical_port_for_pasv_ftp_data_connection != 0)
			&& (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor))
		{
			ptr_to_proxy_server_info->outgoing_physical_port = 
				ptr_to_proxy_server_info->physical_port_for_pasv_ftp_data_connection;
			proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_connections++;
#ifdef CTRL_DEBUG
printf("\n\rPROXY: pasv ftp data conn physical port is %d",ptr_to_proxy_server_info->outgoing_physical_port);
#endif
		}		
		else
			ptr_to_proxy_server_info->outgoing_physical_port = 
				get_proper_port_to_send_packet (uptr_rx_packet, sptr_ip_parameters);
	}

	if (ptr_to_proxy_server_info->outgoing_physical_port == 0)
	{
		proxy_printf ("PROXY: No Internet ports to proxy on\n") ;
		free (ptr_to_proxy_server_info);
		return NULL;
	}

	ptr_to_proxy_server_info->outgoing_port_address = get_ip_address (ptr_to_proxy_server_info->outgoing_physical_port);

/* sudha 27 Aug 1999.Last allocated port has to be assigned only for internet ports
& not for intranet ports.That is ports without any static route entries. */

	if (static_port_list[ptr_to_proxy_server_info->outgoing_physical_port] == FALSE)
		proxy_server.last_allocated_port = ptr_to_proxy_server_info->outgoing_physical_port;

	printf ("PROXY: Outgoing Internet Port is %d\n",ptr_to_proxy_server_info->outgoing_physical_port);

/* sudha 15 Dec 1998. Introduced this checking condition... */
	if(sptr_ip_parameters->protocol != IP_DATA_ICMP)
	{
		proxy_server.number_of_proxied_clients++;
		proxy_server.total_number_of_pseudo_connections++;
	}
/* ...sudha 15 Dec 1998. Introduced this checking condition */

	if (proxy_server.number_of_proxied_clients > proxy_server.peak_concurrent_descriptor_count)
		proxy_server.peak_concurrent_descriptor_count = proxy_server.number_of_proxied_clients ;

/* ...sudha 24 May 1999.Moved this block here from above */

	if(sptr_ip_parameters->protocol == IP_DATA_ICMP)
		return ptr_to_proxy_server_info;

	client_descriptor_key.client_ip_address = ptr_to_proxy_server_info->client_ip_address;
	client_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	client_descriptor_key.application_port = ptr_to_proxy_server_info->source_port;
	add_entry_to_proxy_client_descriptor_tree (ptr_to_proxy_server_info, (BYTE *) &client_descriptor_key);

	proxy_printf("\n\r------------------------------");
	proxy_printf("\n\rProxy : Client Descriptor Info");
	proxy_printf("\n\r------------------------------");
	proxy_printf("\n\rip addr is %x",client_descriptor_key.client_ip_address);
	proxy_printf("\n\rsrc port is %04x, %d",client_descriptor_key.application_port,ptr_to_proxy_server_info->source_port);
	proxy_printf("\n\rdest port is %04x, %d",ptr_to_proxy_server_info->destination_port,ptr_to_proxy_server_info->destination_port);
	proxy_printf("\n\rmapped port is %04x, %d",ptr_to_proxy_server_info->mapped_port,ptr_to_proxy_server_info->mapped_port);
	proxy_printf("\n\rport for pasv ftp data connection is %d",ptr_to_proxy_server_info->physical_port_for_pasv_ftp_data_connection);
	proxy_printf("\n\r------------------------------");

	server_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	server_descriptor_key.application_port = ptr_to_proxy_server_info->mapped_port;
	
	add_entry_to_proxy_server_descriptor_tree (ptr_to_proxy_server_info, (BYTE *) &server_descriptor_key);

	link_control_key.source_ip_address = ptr_to_proxy_server_info->client_ip_address;
	add_entry_to_link_control_descriptor_tree (NULL, (BYTE *) &link_control_key);
/* sudha 17 Dec 1998 */
	reset_link_control_tree_timer (link_control_key);

#if PROXY_DEBUG
	protocol_port = get_application_port_number (uptr_rx_packet, sptr_ip_parameters, &protocol_port) ;	
	proxy_printf ("PROXY: Mapping <%s,%04X> to <%s,%04X> to proxy %s port %s on WAN %04X\n",
		convert_ip_address_to_dot_format (&src_ip_address[0], ptr_to_proxy_server_info->client_ip_address),
		ptr_to_proxy_server_info->source_port,
		convert_ip_address_to_dot_format (&mapped_ip_address[0], ptr_to_proxy_server_info->outgoing_port_address),
		ptr_to_proxy_server_info->mapped_port,
		get_protocol_type (&protocol_type_string[0], ip_protocol_type),
		get_port_type (&dest_application[0], sptr_ip_parameters->protocol, protocol_port), 
		ptr_to_proxy_server_info->outgoing_physical_port-1) ;
#endif
	
	return ptr_to_proxy_server_info;
}



/* Sachin, 3rd Oct. 1997 */
/* sudha 15 Dec 1998. Changed this function for link control */
void ppp_port_down_by_no_demand (USHORT real_port_number)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	USHORT count=0, icmp_count = 0, client_count = 0, client_connections = 0;
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node;

   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_server_root = sptr_proxy_server_descriptor_tree ;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_next_server_node;

   PROXY_LINKCTRL_DESCRIPTOR_NODE far *sptr_linkctrl_root = sptr_proxy_linkctrl_descriptor_tree ;
	PROXY_LINKCTRL_DESCRIPTOR_NODE far *sptr_next_linkctrl_node;
	
   proxy_server.port[real_port_number].port_down_by_no_demand = TRUE ;
	printf ("PROXY:Port %04x down for no demand\n",real_port_number);

	if (sptr_root == NULL && sptr_server_root == NULL && sptr_linkctrl_root == NULL)
		return;

	if ( sptr_root != NULL )
	{
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

		while (sptr_next_node)
		{ 	
			if (sptr_next_node == NULL)
				return;
		
			ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.client_descriptor;
			if (ptr_to_proxy_server_info->outgoing_physical_port == real_port_number)
			{
				count++;
				ptr_to_proxy_server_info->proxy_idle_timer = 0 ;
				ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = 0;
			}
			sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
		}
		printf ("PROXY : Deleted %d Descriptors for port %04x\n", count, real_port_number);
	}

	if ( sptr_server_root != NULL )
	{
		sptr_next_server_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_server_root) ;

		while (sptr_next_server_node)
		{
			if (sptr_next_server_node == NULL)
				return;
		
			ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_server_node->info.server_descriptor;
			if (ptr_to_proxy_server_info->outgoing_physical_port == real_port_number &&
				ptr_to_proxy_server_info->protocol_type == IP_DATA_ICMP)
			{
				icmp_count++;
				ptr_to_proxy_server_info->proxy_idle_timer = 0 ;
				ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = 0;
			}
			sptr_next_server_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_server_node) ;
		}
/*		printf ("PROXY : Deleted %d icmp Descriptors for port %04x\n", icmp_count, real_port_number);*/
	}

	if ( sptr_linkctrl_root != NULL )
	{
		sptr_next_linkctrl_node = (PROXY_LINKCTRL_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_linkctrl_root) ;

		while (sptr_next_linkctrl_node != NULL)
		{
			client_connections = 0;			
			if ( sptr_root != NULL )
			{
				sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;
				while (sptr_next_node != NULL)
				{
					ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.client_descriptor;
					if (ptr_to_proxy_server_info->client_ip_address == sptr_next_linkctrl_node->key.source_ip_address)
						client_connections++;
					sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
				}
/* printf("\n\rPROXY : No. of connections for client %lX is %d",sptr_next_linkctrl_node->key.source_ip_address,
client_connections);*/
				if ( client_connections == 0 )
				{
					client_count++;
/* printf("\n\rPROXY : client %lX to be deleted.",sptr_next_linkctrl_node->key.source_ip_address);*/
				   sptr_next_linkctrl_node->info.aging_timeout = 0;
				}
			}
			else
			{
				client_count++;
/* printf("\n\rPROXY : client %lX to be deleted.",sptr_next_linkctrl_node->key.source_ip_address);*/
				sptr_next_linkctrl_node->info.aging_timeout = 0;
			}
			sptr_next_linkctrl_node = (PROXY_LINKCTRL_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_linkctrl_node) ;
		}
/* printf("\n\rPROXY : %d no. of clients are deleted.",client_count); */
	}			
	process_nat_descriptor_table ();
	return;
}
/* Sachin, 3rd Oct. 1997 */




/* sudhir added dynamic app ptr for passive ftp command */

enum BOOLEAN check_if_application_port_is_to_be_proxied (USHORT application_port, 
		 IP_PARAMETERS *sptr_ip_parameters, BYTE **dynamic_app_ptr)
{
	USHORT protocol_type=0, rx_port_number=0, application_index=0;
	PROXY_DYNAMIC_APP_LIST *temp_app_list_ptr;

	PROXY_APPLICATION_LIST_NODE *proxy_temp_application_node;
	PROXY_RB_KEY_TYPE proxy_rb_key;
	
/* sudha taken from Ravi on 01 Feb 1999 ... */
	PROXY_APP_PORT_RANGE_LIST *ptr_to_port_range = proxy_server.proxy_server_application_port_range_list;
/* ... sudha taken from Ravi on 01 Feb 1999 */

	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_TCP:
		case IP_DATA_UDP:
			protocol_type = sptr_ip_parameters->protocol;
			rx_port_number = sptr_ip_parameters->rx_port_number;

			proxy_rb_key.protocol_type = protocol_type;
			proxy_rb_key.application_port = application_port;

			proxy_temp_application_node = proxy_rb_demo_search (sptr_proxy_address_tree, proxy_rb_key);
			if (proxy_temp_application_node != NULL)
			{
				if (proxy_temp_application_node->key.protocol_type == protocol_type &&
					proxy_temp_application_node->key.application_port == application_port)
				{
/*					printf ("%d Application %d is to be proxied\n", application_port, proxy_temp_application_node->key.application_port); */
					return TRUE;
				}
				else
					return FALSE;
			}

/* Sudha taken from Ravi for User defined Ranges on 01 Feb 1999 ... */
			for (application_index = 0; application_index < proxy_server.number_of_user_defined_applications; 
				  application_index++, ptr_to_port_range++)
			{
				if (ptr_to_port_range->protocol == protocol_type &&
					 ((application_port == ptr_to_port_range->lower_port_number && ptr_to_port_range->higher_port_number == 0) ||
					  (application_port >= ptr_to_port_range->lower_port_number && application_port <= ptr_to_port_range->higher_port_number &&
				     ptr_to_port_range->higher_port_number != 0)))
				{
/*			printf("\n User defined Port.  Protocol : %04x, Port Number : %04x", protocol_type, application_port); */
					return TRUE;
				}
			}
/* ... Sudha taken from Ravi for User defined Ranges on 01 Feb 1999 */

			temp_app_list_ptr = proxy_server.proxy_server_dynamic_application_list;
			while (temp_app_list_ptr)
			{
/*				printf ("Dynamic Application is %d\n",temp_app_list_ptr->application_port); */
				if (temp_app_list_ptr->application_port == application_port)
				{
					proxy_printf ("Dynamic Application is %x, app_port is %x\n",temp_app_list_ptr->application_port, application_port); 
					*dynamic_app_ptr = temp_app_list_ptr;
					return TRUE;
				}
				temp_app_list_ptr = temp_app_list_ptr->sptr_forward_link;
			}	 
/* sudha 02 April 1999.commented this default stmt. */
#if 0
			return FALSE;

		default:
			return FALSE;
#endif
	}

/* sudha taken from Ravi on 16 Nov 1998 ... */
	if(proxy_server.proxy_any_application_enabled)
	{
		proxy_printf ("PROXY_SERVER: Proxy any Application %d\n", proxy_server.proxy_any_application_enabled);
		return TRUE;
	}
/* sudha taken from Ravi on 16 Nov 1998 ... */
	
	return FALSE;
}

#if PROXY_DEBUG
extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
extern char *get_protocol_type (char *protocol_type_string, enum IP_PROTOCOL_VALUE protocol_type) ;
extern char *get_port_type (char *port_type_string, enum IP_PROTOCOL_VALUE protocol_type, USHORT protocol_port_number) ;
#endif



enum BOOLEAN check_in_forbidden_list_for_destination_address (ULONG destination_address)
{
	PROXY_FORBIDDEN_SITE_LIST *sptr_next_forbidden_site = proxy_server.ptr_to_forbidden_list;
/* Sudha 6 June 1998 .sptr_next_restricted_domain_address is initialized */
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *sptr_next_restricted_domain_address = proxy_server.ptr_to_restricted_domain_address;
	ULONG *temp_ptr;
	USHORT forbidden_addr_index,count=0;

	for (forbidden_addr_index = 0; forbidden_addr_index < proxy_server.number_of_forbidden_sites;
		forbidden_addr_index++, sptr_next_forbidden_site++)
  	{
		if (sptr_next_forbidden_site->destination_ip_address == destination_address)
			return TRUE;
	}

	for (forbidden_addr_index = 0; forbidden_addr_index < proxy_server.max_number_of_restricted_domain_address;
		forbidden_addr_index++, sptr_next_restricted_domain_address++)
	{
/* Sudha 23 June 1998 */
		temp_ptr = sptr_next_restricted_domain_address->destination_ip_address;
		for ( count = 0;count < sptr_next_restricted_domain_address->count;count++)
		{
			if (*(temp_ptr) == destination_address)
				return TRUE;
			temp_ptr++;
		}
	}
	return FALSE;
}	

enum BOOLEAN check_in_restricted_list_for_source_address (ULONG source_address)
{
	PROXY_RESTRICTED_CLIENT_LIST *sptr_next_restricted_client = proxy_server.ptr_to_restricted_client_list;
	USHORT restricted_addr_index;

	for (restricted_addr_index = 0; restricted_addr_index < proxy_server.number_of_restricted_clients;
		restricted_addr_index++, sptr_next_restricted_client++)
  	{
		if (sptr_next_restricted_client->source_ip_address == source_address)
			return TRUE;
	}
	return FALSE;
}	


enum BOOLEAN check_if_application_is_to_be_restricted (USHORT protocol , USHORT application_port)
{
	USHORT application_index=0;
	PROXY_APPLICATION_TABLE *proxy_application_list = proxy_server.sptr_restricted_application_list;

	for (application_index = 0; application_index <= proxy_server.number_of_restricted_applications; 
				application_index++, proxy_application_list++)
	{

		if (proxy_application_list->protocol_type == protocol &&
			 proxy_application_list->protocol_port == application_port)
		{
			return TRUE;
		}
	}
	return FALSE;
}

enum BOOLEAN check_if_MAC_address_is_to_be_filtered (BYTE *uptr_ip_rx_packet)
{
	PROXY_RESTRICTED_MAC_ADDRESS_LIST *sptr_next_restricted_MAC_address_list;
	BYTE mac_address[6];
	USHORT mac_address_index;

	memcpy (&mac_address[0], (uptr_ip_rx_packet+6), 6);
	sptr_next_restricted_MAC_address_list = proxy_server.ptr_to_restricted_MAC_address_list;
	
	for (mac_address_index = 0; mac_address_index < proxy_server.max_number_of_restricted_MAC_address;
			mac_address_index++, sptr_next_restricted_MAC_address_list++)
	{
		if (!memcmp (&mac_address[0], &sptr_next_restricted_MAC_address_list->mac_address[0], 6))
			return TRUE;
	}
	return FALSE;

}

enum BOOLEAN check_if_packet_is_to_be_proxied (UNION_IP_PACKET *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, enum BOOLEAN *abort_forwarding, USHORT *outgoing_port, 
		void **proxy_info, enum BOOLEAN *eptr_size_modified)
{
	USHORT application_port=0, destination_port=0, tapp_port = 0, tdest_port = 0;
	enum IP_PROTOCOL_VALUE protocol_type;
	PROXY_SERVER_INFO *ptr_to_proxy_info;
	BYTE *ptr_to_dynamic_app_list = NULL;

#if PROXY_DEBUG
	char src_ip_address[20], dest_ip_address[20], dest_application[10], protocol_type_string[10] ;
#endif

	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	PROXY_LINKCTRL_RB_KEY_TYPE link_control_key;
	PPTP_INFO_DESCRIPTOR *pptp_info_ptr;

/* sudha 16 sep 1998 */	
	USHORT dest_port, source_port, data_len, qdcnt, dns_id ;
	BYTE *domain_name, *name ;
	BYTE *dns_response_ptr ;

/* This is to be included after initing from nvram */
	if (!proxy_server.proxy_server_enabled)
	{
		proxy_printf ("PROXY_SERVER: proxy server disabled for port %d\n",sptr_ip_parameters->rx_port_number);
		return FALSE;
	}
	
	protocol_type = sptr_ip_parameters->protocol;

	
	if (check_if_MAC_address_is_to_be_filtered ((BYTE *)uptr_ip_rx_packet) == TRUE)
	{
		*abort_forwarding = TRUE;			
		return FALSE;
	}

	
	if (check_in_restricted_list_for_source_address (sptr_ip_parameters->source_address) == TRUE)
	{
		*abort_forwarding = TRUE;			
		return FALSE;
	}

	if (check_in_forbidden_list_for_destination_address (sptr_ip_parameters->destination_address) == TRUE)
	{
		*abort_forwarding = TRUE;			
		return FALSE;
	}

	switch (protocol_type)
	{
		case IP_DATA_ICMP:
			if (is_icmp_echo_request_message (uptr_ip_rx_packet, sptr_ip_parameters))
			{
				ptr_to_proxy_info = get_free_proxy_server_info_ptr(destination_port, uptr_ip_rx_packet, sptr_ip_parameters, eptr_size_modified);
				if (ptr_to_proxy_info == NULL)
				{
					*abort_forwarding = TRUE;			
					return FALSE;
				}					


				proxy_server.port[ptr_to_proxy_info->outgoing_physical_port].number_of_packets_txed++;
				*outgoing_port = ptr_to_proxy_info->outgoing_physical_port;
				ptr_to_proxy_info->incoming_physical_port = sptr_ip_parameters->rx_port_number;
				printf ("Setting idle timer for icmp\n");
				ptr_to_proxy_info->proxy_idle_timer = proxy_server.proxy_server_idle_timeout ;
				ptr_to_proxy_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;

				ptr_to_proxy_info->icmp_packet_id = get_icmp_echo_request_id (uptr_ip_rx_packet, sptr_ip_parameters);
	

				if (proxy_server.new_icmp_packet_id == 0)
					proxy_server.new_icmp_packet_id = 5;
			
				ptr_to_proxy_info->mapped_icmp_packet_id = proxy_server.new_icmp_packet_id++;

				server_descriptor_key.protocol_type = protocol_type;
				server_descriptor_key.application_port = ptr_to_proxy_info->mapped_icmp_packet_id;
				add_entry_to_proxy_server_descriptor_tree (ptr_to_proxy_info, (BYTE *) &server_descriptor_key);
				
				link_control_key.source_ip_address = ptr_to_proxy_info->client_ip_address;
				reset_link_control_tree_timer (link_control_key);


		  
				*proxy_info = (void *) ptr_to_proxy_info;
				return TRUE;
			}	
			break;
#ifdef _VPN_PPTP_
		case IP_GRE_PROTOCOL:
tapp_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, 
	sptr_ip_parameters, &tdest_port);

printf("\n\r\proto %d, src %lX, dest %lX, src %d, dest %d", sptr_ip_parameters->protocol,
sptr_ip_parameters->source_address, sptr_ip_parameters->destination_address,
tapp_port, tdest_port);
	
			pptp_info_ptr = get_ptr_to_pptp_info_from_gre_packet (uptr_ip_rx_packet, sptr_ip_parameters);
			if (pptp_info_ptr == NULL)
			{
				*abort_forwarding = TRUE;			
				return FALSE;
			}
			
			pptp_info_ptr->idle_timer = proxy_server.proxy_server_idle_timeout;
			pptp_info_ptr->rx_port_number = sptr_ip_parameters->rx_port_number;

			proxy_server.port[pptp_info_ptr->tx_port_number].number_of_packets_txed++;
					
			*outgoing_port = pptp_info_ptr->tx_port_number;

			*proxy_info = (void *) pptp_info_ptr;
			return TRUE;
#endif


		case IP_DATA_TCP:
		case IP_DATA_UDP:
			application_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, 
									sptr_ip_parameters, &destination_port);
	
			if (check_if_application_is_to_be_restricted (sptr_ip_parameters->protocol, 
					application_port) == TRUE)
			{
				*abort_forwarding = TRUE;			
				return FALSE;
			}

			if (application_port == INVALID_DESTINATION_PORT)
			{
				proxy_printf ("PROXY :Destination Port is Invalid\n");
				return FALSE;
			}

			if (check_if_application_port_is_to_be_proxied (application_port, sptr_ip_parameters, 
				&ptr_to_dynamic_app_list))
			{

#if 0
/* sudha 15 sep 1998 
If DNS caching has to be done at this level,i.e., even before opening a port
for DNS request, call get_dns_response_from_local_cache_if_any here 
				
sudha 10 Sep 1998 
For DNS Caching.Checking whether destination port to be proxied is DNS (53)
If so check in local dns cache .If match found send a dns response from 
cache.If not found forward the packet.*/

				if (protocol_type == IP_DATA_UDP)
				{
					dest_port = get_udp_port_number_from_ip_packet (uptr_ip_rx_packet, sptr_ip_parameters, source_port ); 
					if (dest_port == IPPORT_DOMAIN) 
					{
						name = get_domain_name_from_dns_query_packet (uptr_ip_rx_packet,sptr_ip_parameters);
						qdcnt = get_quest_count_from_dns_query_pkt(uptr_ip_rx_packet, sptr_ip_parameters);
						dns_id = get_send_id_from_dns_query_pkt(uptr_ip_rx_packet, sptr_ip_parameters);

						if ( qdcnt == 1 )
 						{
							dns_response_ptr = get_dns_response_from_local_cache_if_any(name, &data_len, dns_id);

							if ( dns_response_ptr != NULL ) 
							{
								get_dns_response_packet(uptr_ip_rx_packet, sptr_ip_parameters, dns_response_ptr, 
									data_len,(void (*) (USHORT port_number, void *vptr_tx_packet)) send_completion_udp_packet );
printf("n\rPROXY : after get dns response");

								free ( dns_response_ptr );
								*abort_forwarding = TRUE;			
								return FALSE;
							}
	  	 				}
					}
				}
#endif /* Sudha 07 Nov 1998 */
			
				ptr_to_proxy_info = get_free_proxy_server_info_ptr(destination_port, uptr_ip_rx_packet, sptr_ip_parameters, eptr_size_modified);
				if (ptr_to_proxy_info == NULL)
				{
/*					proxy_printf ("PROXY : Not Enough memory to Allocate Descriptor\n"); */
					*abort_forwarding = TRUE;			
					return FALSE;
				}
		
				if (application_port == TFTP_RESERVED_PORT)
					ptr_to_proxy_info->tftp_packet_detected = TRUE;


				proxy_server.port[ptr_to_proxy_info->outgoing_physical_port].number_of_packets_txed++;
				*outgoing_port = ptr_to_proxy_info->outgoing_physical_port;
				ptr_to_proxy_info->incoming_physical_port = sptr_ip_parameters->rx_port_number;

/* sudhir for ftp passive comm */
				ptr_to_proxy_info->destination_port = application_port;
				ptr_to_proxy_info->ptr_to_dynamic_application_list = *ptr_to_dynamic_app_list;		 

				if ((is_close_connection_initiated ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters) == TRUE) 
					&&	(protocol_type == TCP_PROTOCOL)) 
				{
					proxy_printf ("PROXY : TCP Connection is closed by %08x\n",
								uptr_ip_rx_packet->ip.header.source_ip_address); 
					
					ptr_to_proxy_info->connection_closing = TRUE;
					ptr_to_proxy_info->proxy_idle_timer = (proxy_server.proxy_server_idle_timeout) / 125;
					ptr_to_proxy_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 5;
/* sudha 17 Dec 1998 */
					link_control_key.source_ip_address = ptr_to_proxy_info->client_ip_address;
					reset_link_control_tree_timer (link_control_key);
				}
				else if (ptr_to_proxy_info->connection_closing == FALSE)
/* Sachin, 23/12/1997 */
		      {
      		   if (ptr_to_proxy_info->ptr_to_ftp_command_descriptor)
					{
#ifdef CTRL_DEBUG
printf("\n\rPROXY: src_port is %x, dest_port is %x, src_ip is %x, ftp_command_desc is %x",
ptr_to_proxy_info->source_port, ptr_to_proxy_info->destination_port, 
ptr_to_proxy_info->client_ip_address, ptr_to_proxy_info->ptr_to_ftp_command_descriptor);
#endif
	         		ptr_to_proxy_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
						ptr_to_proxy_info->ptr_to_ftp_command_descriptor->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;
					}
/* Sachin, 23/12/1997 */
			   	ptr_to_proxy_info->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
					ptr_to_proxy_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;
/* sudha 17 Dec 1998 */
					link_control_key.source_ip_address = ptr_to_proxy_info->client_ip_address;
					reset_link_control_tree_timer (link_control_key);
      		}
  		
				*proxy_info = (void *) ptr_to_proxy_info;
#if 0
			proxy_printf ("PR: <%s,%d>--><%s,%s,%s> proxied on port %04X\n",
				convert_ip_address_to_dot_format (&src_ip_address[0], ptr_to_proxy_info->client_ip_address),
				ptr_to_proxy_info->source_port,
				convert_ip_address_to_dot_format (&dest_ip_address[0], uptr_ip_rx_packet->ip.header.destination_ip_address),
				get_protocol_type (&protocol_type_string[0], protocol_type),
				get_port_type (&dest_application[0], protocol_type, application_port),
				*outgoing_port) ;
#endif

				return TRUE;
			}		  
			break;

		default:
			break;
	}
	return FALSE;
}


USHORT get_least_loaded_port (USHORT port_number, BYTE get_any_available_port) 
{
   USHORT i, least_loaded_port = NUMBER_OF_PROXY_PORTS ;
   USHORT least_load = 0x7FFF ;
	enum BOOLEAN mlppp_enabled;

   for (port_number = 1 ; port_number <= NUMBER_OF_PROXY_PORTS ; port_number++)
   {
		if (is_physical_port_available_for_proxying(port_number) == FALSE)
 			continue;
		
		if (get_any_available_port == 0)
		{
			if (proxy_server.port[port_number].do_not_allocate_this_port == TRUE)
				continue;
		}

		if (!proxy_server.port[port_number].proxy_server_enabled)
			continue;

/* Jo 30/07/99 Added for Static routes */
		
		if (static_port_list[port_number] == TRUE)		
			continue ;
	
/* Jo 30/07/99 Added for Static routes */

/* __Sudha__ 22 Aug 1998 */
		mlppp_enabled = if_mlppp();		
		if (if_mlppp() == TRUE)
		{
			if ((is_ipport_up ( port_number ) == TRUE) && 
				(is_wan_port_proxy_enabled(port_number - 1) == TRUE))
			{
	  			return (port_number);
			}
		}
	}

   for (port_number = 1 ; port_number <= NUMBER_OF_PROXY_PORTS ; port_number++)
   {
		if (is_physical_port_available_for_proxying (port_number) == FALSE)
			continue;

		if (get_any_available_port == 0)
		{
			if (proxy_server.port[port_number].do_not_allocate_this_port == TRUE)
				continue;
		}

		if (!proxy_server.port[port_number].proxy_server_enabled)
			continue;

/* Jo 30/07/99 Added for Static routes */
		
		if (static_port_list[port_number] == TRUE)		
			continue ;
	
/* Jo 30/07/99 Added for Static routes */

/* __Sudha__ 22 Aug 1998 */
	   if ((is_ipport_up (port_number) == TRUE) ||
			(proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
			(proxy_server.port[port_number].client_disconnected == TRUE) ||
			(is_triggering_is_needed(port_number - 1) == TRUE ) ||
			((is_wan_port_proxy_enabled(port_number - 1) == TRUE) &&
			  (is_ipport_up(port_number) == FALSE))) /* sudha 18 Dec 1998 */
		{

   	  	if (proxy_server.port[port_number].number_of_connections < least_load)
         {
        	   least_load = proxy_server.port[port_number].number_of_connections ;
           	least_loaded_port = port_number ;
	      }
		}
	}

   if (least_load == 0x7FFF)
      return (INVALID_PHYSICAL_PORT) ;
   else
	{
/*		printf ("PROXY: Least loaded port is %04x\n",least_loaded_port); */
      return (least_loaded_port) ;
	}
}


USHORT  search_in_privilege_list_and_get_port (ULONG source_ip_address)
{
	PROXY_PRIVILEGED_USER_LIST *ptr_to_next_user_list;
	USHORT user_index=0;
	
	ptr_to_next_user_list = proxy_server.ptr_to_privileged_user_list;
	
	for (user_index = 0; user_index < proxy_server.number_of_privileged_users;
		user_index++, ptr_to_next_user_list++)
	{
		if (ptr_to_next_user_list->host_ip_address == source_ip_address)
			return (ptr_to_next_user_list->reserved_port);
	}

	return INVALID_PHYSICAL_PORT;
}


USHORT get_outgoing_port_number (enum BOOLEAN *port_triggered, ULONG source_ip_address, ULONG destination_ip_address)
{
   USHORT port_number, i , reserved_port=0;
   BYTE dialing_triggered_for_a_port = 0 ;
	BYTE get_any_available_port = 0; /* sudha 27 Aug 1999 */

/* Jo 09/08/99 Added for Static routes */

	if (get_port_number_if_statically_configured (destination_ip_address, &port_number) == TRUE)	
	{
		if ((port_number != INVALID_PHYSICAL_PORT) && (port_number != 0))
		{
			if ((proxy_server.port[port_number].proxy_server_enabled == TRUE) && 
			 (is_physical_port_available_for_proxying(port_number) == TRUE))
			{
				if ((proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
					(is_triggering_is_needed(port_number - 1) == TRUE) ||
					((is_wan_port_proxy_enabled(port_number - 1) == TRUE) 
					&& (is_ipport_up (port_number) == FALSE)))
				{
					 *port_triggered = TRUE ;
	         	 ppp_proxy_link_active (port_number - 1) ;
				}
   		   proxy_server.port[port_number].number_of_connections++ ;
				printf ("PROXY: Selecting Statically configured port %d\n", port_number) ;  
				return port_number ;
			}
		}
	}
			
/* Jo 09/08/99 Added for Static routes */

	reserved_port = search_in_privilege_list_and_get_port (source_ip_address);
	
	if (reserved_port != INVALID_PHYSICAL_PORT)
	{

/* To check whether the reserved port is being used by AG client right now... */

/* sudha 21 May 1999 */		
		if (is_wan_enabled(reserved_port - 1) == FALSE)
		{
			printf("PROXY: Wan port %04x is disabled\n",reserved_port);
		}

		if (is_port_is_in_use_by_ag (reserved_port - 1) == TRUE)
		{
			printf ("PROXY: AG client is using the port %04x\n",reserved_port);
			/* get the next available free port for proxying this host. */
		}

		if (is_port_is_in_use_by_telnet (reserved_port - 1) == TRUE)
		{
			printf ("PROXY: Telnet client is using the port %04x\n",reserved_port);
			/* get the next available free port for proxying this host. */
		}

/* To check whether the reserved port is being used by RAS client right now... */

		if (is_port_is_remote_access (reserved_port) == TRUE)
		{
			printf ("PROXY: Remote Access enabled for port %04x\n",reserved_port);
			/* get the next available free port for proxying this host. */
		}

/* sudha 03 dec 1998 */	
		if ((proxy_server.port[reserved_port].proxy_server_enabled == TRUE) && 
			 (is_physical_port_available_for_proxying(reserved_port) == TRUE))
		{
			if ((proxy_server.port[reserved_port].port_down_by_no_demand == TRUE) ||
				(is_triggering_is_needed(reserved_port - 1) == TRUE) ||
				((is_wan_port_proxy_enabled(reserved_port - 1) == TRUE) 
					&& (is_ipport_up (reserved_port) == FALSE)))
			{
				 *port_triggered = TRUE;
/* printf("\n\rProxy2: Reserved Port is %d",reserved_port);*/
	          ppp_proxy_link_active (reserved_port - 1) ;
			}
      	proxy_server.port[reserved_port].number_of_connections++ ;
			printf ("PROXY: Selecting Reserved Port %d\n",reserved_port);  
			return reserved_port;
		}
	}
	
   port_number = get_least_loaded_port (port_number, get_any_available_port) ;
/* printf("\n\rPROXY2: Get least loaded port number is : %d",port_number);*/
   if (port_number == INVALID_PHYSICAL_PORT)
	{
		if ((proxy_server.last_allocated_port < 1) || 
			(proxy_server.last_allocated_port > NUMBER_OF_PROXY_PORTS))  
		{
/* sudha 27 Aug 1999.This is needed because, if "bring up port" only,
after 'x' number of connections or host machines have been configured
for wan2 & wan3, & at that time, if any proxy request comes & wan1 is say
ras or ag port, then, though the other 2 ports are available for proxying,
it used to say, no internet ports to proxy, as the number of connections
configured in them will never reach */

			get_any_available_port = 1;
			port_number = get_least_loaded_port(port_number, get_any_available_port);
		}
		else
			port_number = proxy_server.last_allocated_port;

		if ((port_number >= 1) && (port_number <= NUMBER_OF_PROXY_PORTS))
		{
			if ((is_physical_port_available_for_proxying(port_number) == TRUE) &&
				(proxy_server.port[port_number].proxy_server_enabled == TRUE))
			{
/* sudha 03 dec 1998 */
				if ((proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
					(is_triggering_is_needed(port_number - 1) == TRUE ) ||
					((is_ipport_up(port_number) == FALSE) &&
					(is_wan_port_proxy_enabled(port_number - 1) == TRUE)))
				{
			      printf ("PROXY3 : Triggering down-by-demand WAN port %04X\n", port_number-1) ;
      			ppp_proxy_link_active (port_number-1) ;
				}
				else
				if (proxy_server.port[port_number].client_disconnected == TRUE)
				{
					set_modem_state_to_dial (port_number-1);												
				}

/*				printf ("PROXY: Port index is Above range %d\n",port_number); */
      		proxy_server.port[port_number].number_of_connections++ ;
      		return (port_number) ;
			}
		}
/*		printf ("PROXY: Remote Access enabled for port %04x\n",port_number);*/
		return (INVALID_PHYSICAL_PORT) ;
	}

/* sudha 03 dec 1998 */
   if ((proxy_server.port[port_number].port_down_by_no_demand == FALSE) &&
		(is_triggering_is_needed(port_number - 1) == FALSE) &&
		(is_wan_port_proxy_enabled(port_number - 1) == TRUE) &&
		(is_ipport_up (port_number) == TRUE))
	{
      proxy_server.port[port_number].number_of_connections++ ;
/*		printf ("PROXY: Selected Port is %d\n",port_number);  */
		if (is_port_is_remote_access (port_number) == TRUE)
		{
/*			printf ("PROXY: Remote Access enabled for port %04x\n",port_number);*/
			return INVALID_PHYSICAL_PORT;
		}

		if (is_port_is_in_use_by_ag(port_number - 1) == TRUE)
		{
			printf ("PROXY: AG client is using the port %04x\n",port_number);
			return INVALID_PHYSICAL_PORT;
		}

		if (is_port_is_in_use_by_telnet(port_number - 1) == TRUE)
		{
			printf ("PROXY: Telnet client is using the port %04x\n",port_number);
			return INVALID_PHYSICAL_PORT;
		}

		if (is_wan_enabled(port_number - 1) == FALSE)
		{
			printf ("PROXY: Wan port %04x is disabled\n",port_number);
			return INVALID_PHYSICAL_PORT;
		}

      return (port_number) ;
   }

   else if ((proxy_server.port[port_number].port_down_by_no_demand == TRUE) ||
				(is_triggering_is_needed(port_number - 1) == TRUE) ||
				((is_wan_port_proxy_enabled(port_number - 1) == TRUE) 
					&& (is_ipport_up (port_number) == FALSE)))

   {
		if (is_physical_port_available_for_proxying(port_number) == TRUE)
		{
	    	dialing_triggered_for_a_port = 1 ;
			*port_triggered = TRUE;
      	printf ("PROXY4 : Triggering down-by-demand WAN port %04X\n", port_number-1) ;
	      ppp_proxy_link_active (port_number-1) ;

/* sudha 27-Sep-1999. There is a chance that last_allocated_port can be zero 
also (LAN Port).It will be zero, during first time, i.e., after initialization 
or if last_allocated_port value has been not updated at all.So is_ipport_up (0)
will always return true as LAN Port is always up.Due to this, proxy may 
say, "no internet ports to proxy on" as port 0 ( LAN Port ) is not a proxy 
port */

   	   if ((proxy_server.last_allocated_port >= 1) && 
				(proxy_server.last_allocated_port <= NUMBER_OF_PROXY_PORTS) &&
				(is_ipport_up(proxy_server.last_allocated_port) == TRUE))
			{
				proxy_server.port[proxy_server.last_allocated_port].number_of_connections++ ;
				return proxy_server.last_allocated_port;
			}
			else
				return port_number;
		}
	}
	printf ("PROXY: Returning Wrong Port number %04x\n");
   return (INVALID_PHYSICAL_PORT) ;
}

void set_source_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT mapped_port)
{
	switch (sptr_ip_parameters->protocol)
	{
		case TCP_PROTOCOL:
		set_tcp_src_port_number (uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);
		return;

		case UDP_PROTOCOL:
			set_udp_src_port_number (uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);
			return;
	}
}

enum BOOLEAN is_proxy_response_packet (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		ULONG *client_ip_address, USHORT *destination_port, USHORT *outgoing_physical_port, void **proxy_info)
{
	USHORT application_port=0, dummy_port=0;
	USHORT icmp_packet_id =0;
	enum IP_PROTOCOL_VALUE protocol_type;
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
#if PROXY_DEBUG
	char src_ip_address[20], dest_ip_address[20], src_application[10], protocol_type_string[10] ;
#endif

	PROXY_RB_SERVER_KEY_TYPE server_descriptor_key;
	PROXY_SERVER_DESCRIPTOR_NODE far *proxy_temp_server_descriptor_list;
	PPTP_INFO_DESCRIPTOR *pptp_info_ptr;
/* sudha 17 Dec 1998 */	
	PROXY_LINKCTRL_RB_KEY_TYPE link_control_key;
		


#ifdef _VPN_PPTP_
	if (sptr_ip_parameters->protocol == IP_GRE_PROTOCOL)
	{
		pptp_info_ptr = get_ptr_to_pptp_info_from_gre_response_packet (uptr_ip_rx_packet, sptr_ip_parameters);
		if (pptp_info_ptr == NULL)
		{
			printf ("PPTP: No Descriptor for GRE Response Packet\n");
			return FALSE;
		}
		
		pptp_info_ptr->idle_timer = proxy_server.proxy_server_idle_timeout;

		*outgoing_physical_port = pptp_info_ptr->rx_port_number;
		*client_ip_address = pptp_info_ptr->source_ip_address;

		*proxy_info = (void *) pptp_info_ptr;
		return TRUE;
	}
#endif

	application_port = get_application_port_number (uptr_ip_rx_packet, sptr_ip_parameters, &dummy_port);

	protocol_type = sptr_ip_parameters->protocol;
	if (protocol_type != TCP_PROTOCOL  && protocol_type != UDP_PROTOCOL && 
				protocol_type != ICMP_PROTOCOL)
	{
		return FALSE; 
	}

#if 0
	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_first_entry_in_list ((LINK *)&proxy_server.proxy_server_info_list);
	
	while (ptr_to_proxy_server_info != NULL)
	{

		if (protocol_type == ICMP_PROTOCOL)
		{
			icmp_packet_id = get_icmp_echo_request_id (uptr_ip_rx_packet, sptr_ip_parameters);

			if (ptr_to_proxy_server_info->mapped_icmp_packet_id == icmp_packet_id)
			{	
				*outgoing_physical_port = ptr_to_proxy_server_info->incoming_physical_port;
				*client_ip_address = ptr_to_proxy_server_info->client_ip_address;			
				*proxy_info = ptr_to_proxy_server_info;
				return TRUE;
			}		
		}

#if 0
		if (application_port == ptr_to_proxy_server_info->mapped_port)
		{
			*outgoing_physical_port = ptr_to_proxy_server_info->incoming_physical_port;
			*destination_port = ptr_to_proxy_server_info->source_port;			
			*client_ip_address = ptr_to_proxy_server_info->client_ip_address;			
			if ((is_close_connection_initiated (uptr_ip_rx_packet, sptr_ip_parameters) == TRUE) &&
					(protocol_type == TCP_PROTOCOL))
			{
/*				proxy_printf ("PROXY_SERVER : TCP Connection is closed\n"); */
				ptr_to_proxy_server_info->connection_closing = TRUE;
				ptr_to_proxy_server_info->proxy_idle_timer = (proxy_server.proxy_server_idle_timeout) / 125 ;
				ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 8;

			}
			else if (ptr_to_proxy_server_info->connection_closing == FALSE)
/* Sachin, 23/12/1997 */
         {
            if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
				{
	            ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
					ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;
				}

/* Sachin, 23/12/1997 */
			   ptr_to_proxy_server_info->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
				ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;
         }

/* This is to support TFTP */
			if (ptr_to_proxy_server_info->tftp_packet_detected == TRUE)
			{
				proxy_printf ("PROXY : Adding TFTP dynamic port %d\n",dummy_port);
				add_port_to_application_list (dummy_port);	
				ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
			}		
/* This is to support TFTP */

			proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_packets_rxed++;
			*proxy_info = ptr_to_proxy_server_info;

#if 0
			proxy_printf ("PR: <%s,%s,%s>--><%s,%d> relayed on port %04X\n",
				convert_ip_address_to_dot_format (&src_ip_address[0], ((UNION_IP_PACKET *)uptr_ip_rx_packet)->ip.header.source_ip_address),
				get_protocol_type (&protocol_type_string[0], protocol_type),
				get_port_type (&src_application[0], protocol_type, dummy_port),
				convert_ip_address_to_dot_format (&dest_ip_address[0], *client_ip_address),
				*destination_port,
				*outgoing_physical_port) ;
#endif
			return TRUE;
		}
#endif
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) get_pointer_to_next_entry_in_list ((LINK *)ptr_to_proxy_server_info);

	}

#endif

	if (sptr_ip_parameters->protocol == ICMP_PROTOCOL)
	{
		icmp_packet_id = get_icmp_echo_request_id (uptr_ip_rx_packet, sptr_ip_parameters);
		
		server_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
		server_descriptor_key.application_port = icmp_packet_id;
		proxy_temp_server_descriptor_list = proxy_rb_server_descriptor_search (
					sptr_proxy_server_descriptor_tree, server_descriptor_key);
	
		if (proxy_temp_server_descriptor_list == NULL)
		{
#if 0
			printf ("PROXY: No Match for the packet id in Descriptors\n");
#endif
			return FALSE;
		}
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) (proxy_temp_server_descriptor_list->info.server_descriptor);
		
		if (ptr_to_proxy_server_info->mapped_icmp_packet_id == icmp_packet_id)
		{	
			
			*outgoing_physical_port = ptr_to_proxy_server_info->incoming_physical_port;
			*client_ip_address = ptr_to_proxy_server_info->client_ip_address;			
			*proxy_info = ptr_to_proxy_server_info;
			return TRUE;
		}		
  	}



	server_descriptor_key.protocol_type = sptr_ip_parameters->protocol;
	server_descriptor_key.application_port = application_port;

	proxy_temp_server_descriptor_list = proxy_rb_server_descriptor_search (
					sptr_proxy_server_descriptor_tree, server_descriptor_key);

	if (proxy_temp_server_descriptor_list->key.application_port == application_port &&
			proxy_temp_server_descriptor_list->key.protocol_type == sptr_ip_parameters->protocol)
	{
		ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) (proxy_temp_server_descriptor_list->info.server_descriptor);

		*outgoing_physical_port = ptr_to_proxy_server_info->incoming_physical_port;
		*destination_port = ptr_to_proxy_server_info->source_port;			
		*client_ip_address = ptr_to_proxy_server_info->client_ip_address;			
		if ((is_close_connection_initiated (uptr_ip_rx_packet, sptr_ip_parameters) == TRUE) 
			&&	(protocol_type == TCP_PROTOCOL)) 
		{
/*			proxy_printf ("PROXY_SERVER : TCP Connection is closed\n"); */
  			ptr_to_proxy_server_info->connection_closing = TRUE;
  			ptr_to_proxy_server_info->proxy_idle_timer = (proxy_server.proxy_server_idle_timeout) / 125 ;
			ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 5;
/* sudha 17 Dec 1998 */
			link_control_key.source_ip_address = ptr_to_proxy_server_info->client_ip_address;
			reset_link_control_tree_timer (link_control_key);
  		}
  		else if (ptr_to_proxy_server_info->connection_closing == FALSE)
/* Sachin, 23/12/1997 */
      {
      	if (ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor)
			{
	         ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
				ptr_to_proxy_server_info->ptr_to_ftp_command_descriptor->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;
			}
/* Sachin, 23/12/1997 */
			ptr_to_proxy_server_info->proxy_idle_timer = proxy_server.proxy_server_idle_timeout;
			ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = proxy_server.proxy_server_idle_timeout / 3;
/* sudha 17 Dec 1998 */
			link_control_key.source_ip_address = ptr_to_proxy_server_info->client_ip_address;
			reset_link_control_tree_timer (link_control_key);

      }

/* This is to support TFTP */
		if (ptr_to_proxy_server_info->tftp_packet_detected == TRUE)
		{
			proxy_printf ("PROXY : Adding TFTP dynamic port %d\n",dummy_port);
			add_port_to_application_list (dummy_port);	
			ptr_to_proxy_server_info->tftp_packet_detected = FALSE;
		}		
/* This is to support TFTP */

		proxy_server.port[ptr_to_proxy_server_info->outgoing_physical_port].number_of_packets_rxed++;
		*proxy_info = ptr_to_proxy_server_info;
		return TRUE;
	}
	return FALSE;
}

void set_destination_port_number (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
		USHORT mapped_port )
{
	switch (sptr_ip_parameters->protocol)
	{
		case TCP_PROTOCOL:
			set_tcp_dest_port_number (uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);
			return;
		case UDP_PROTOCOL:
			set_udp_dest_port_number (uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);
			return;
	}
}

/* Port command format :
	PORT i1,i2,i3,i4,p1,p2,13,10
*/
BYTE *form_new_port_command (BYTE *tcp_data, PROXY_SERVER_INFO *proxy_server_info)
{
	USHORT buffer_index=0, port_higher_byte, port_lower_byte ;
	ULONG tx_port_address;
	BYTE ip_address[20] ;

	tx_port_address = proxy_server_info->outgoing_port_address;
	convert_ip_address_to_dot_format (&ip_address[0], tx_port_address);
	for (buffer_index = 0 ; ip_address[buffer_index] ; buffer_index++)
		if (ip_address[buffer_index] == '.')
			ip_address[buffer_index] = ',' ;

	port_higher_byte = (proxy_server_info->mapped_port & 0xff00);
	port_higher_byte >>= 8;
	port_lower_byte = (proxy_server_info->mapped_port  & 0x00ff);


	sprintf (&tcp_data[0], "PORT %s,%d,%d\x0D\x0A", &ip_address[0],
		port_higher_byte, port_lower_byte) ;

	return tcp_data ;
}

USHORT get_port_command_length (BYTE *ptr_to_start_of_port_command)
{
	BYTE *x = ptr_to_start_of_port_command ;

	while (*x++ != 0x0A)
	{
		/* It can never cross 35 if "PORT" command or 55 if "227 Entering PASV mode
		   command.So 35 has been changed to 55. sudha 07 April 1999 */
		if (((BYTE *)x - (BYTE *)ptr_to_start_of_port_command) > 55)
			return (100) ;
	}

	return ((BYTE *)x - (BYTE *)ptr_to_start_of_port_command) ;
}		

#define _SUDHIR__ 0

void process_proxy_ip_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
	   BYTE *proxy_server_info, enum BOOLEAN ftp_port_command)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	BYTE *ptr_to_tcp_packet;
	int old_length, new_length ;
	BYTE *sptr_icmp_header;
	USHORT new_checksum=0, mapped_port=0, tx_port=0;
	ULONG dns_server_addr ;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	
#if _SUDHIR__
	TCP_CHANGED_VARIABLES *old_variables_ptr, *new_variables_ptr;
	int adjusted_csum=0;
		
	old_variables_ptr = (TCP_CHANGED_VARIABLES *) malloc (sizeof (TCP_CHANGED_VARIABLES));
	if (old_variables_ptr == NULL)
	{
		printf ("PROXY: Memory Allocation Error\n");
		return;
	}
	new_variables_ptr = (TCP_CHANGED_VARIABLES *) malloc (sizeof (TCP_CHANGED_VARIABLES));
	if (new_variables_ptr == NULL)
	{
		free (old_variables_ptr);
		printf ("PROXY: Memory Allocation Error\n");
		return;
	}

	old_variables_ptr->source_ip_address = sptr_ip_parameters->source_address;
	old_variables_ptr->destination_ip_address = sptr_ip_parameters->destination_address;
	old_variables_ptr->source_port_number = get_tcp_src_port_from_ip_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters);
	old_variables_ptr->destination_port_number = get_tcp_dst_port_from_ip_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters);

	old_variables_ptr->tcp_seq_number = get_tcp_seq_number_from_ip_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
	old_variables_ptr->tcp_ack_number = get_tcp_ack_number_from_ip_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters); 
#endif 
	

	ptr_to_proxy_server_info = (PROXY_SERVER_INFO *)proxy_server_info;

#ifdef _VPN_PPTP_
	if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
		check_for_pptp_client_packet_and_process (uptr_ip_rx_packet, sptr_ip_parameters,ptr_to_proxy_server_info->outgoing_physical_port);

#endif

#ifdef _VPN_PPTP_

	if (sptr_ip_parameters->protocol == IP_GRE_PROTOCOL)
	{
		ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *)proxy_server_info; 
		if (ptr_to_pptp_info == NULL)
		{
			printf ("PPTP: Invalid GRE Packet\n");
			return;
		}

		process_client_gre_packet_if_required (uptr_ip_rx_packet, sptr_ip_parameters, ptr_to_pptp_info);

		sptr_ip_parameters->source_address = ptr_to_pptp_info->outgoing_port_address;
		uptr_ip_rx_packet->ip.header.source_ip_address = ptr_to_pptp_info->outgoing_port_address;
		return;
	}


#endif

	mapped_port = ptr_to_proxy_server_info->mapped_port;			
	tx_port = ptr_to_proxy_server_info->outgoing_physical_port;

	sptr_ip_parameters->source_address = ptr_to_proxy_server_info->outgoing_port_address;

/* Sudha 07 Nov 1998 */	
	if ( is_dns_query_pkt_destined_to_lan_of_proxy_as_dns_server ( uptr_ip_rx_packet,
 		sptr_ip_parameters ) == TRUE )
	{
#if __Sudha__
printf("\n\rPROXY: is dns query pkt destined to proxy lan true.");
#endif
		dns_server_addr = get_dns_server_address(tx_port) ;		
/*		printf("\n\rPROXY: dns server addr of port %d is : %lx",tx_port, dns_server_addr);*/
		if ( dns_server_addr )
			sptr_ip_parameters->destination_address = dns_server_addr ;
#if __Sudha__
printf("\n\rPROXY : DNS server addr is %lu",dns_server_addr );
#endif
	 }	

/* Sudha 07 Nov 1998 */

	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_ICMP:
			uptr_ip_rx_packet->icmp.ip_header.source_ip_address = sptr_ip_parameters->source_address;
			uptr_ip_rx_packet->icmp.header.option.echo_message.identifier = 
						ptr_to_proxy_server_info->mapped_icmp_packet_id;					
			sptr_icmp_header = get_ptr_to_icmp_header (uptr_ip_rx_packet, sptr_ip_parameters);		 
			set_icmp_checksum (sptr_icmp_header, 0);
			new_checksum =	calculate_ip_checksum (NULL, 
					(BYTE *)sptr_icmp_header, (USHORT) (sptr_ip_parameters->total_length- sptr_ip_parameters->header_length));
			set_icmp_checksum (sptr_icmp_header, new_checksum);
			return;				

		case IP_DATA_TCP:
			set_source_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);			
	
			uptr_ip_rx_packet->ip.header.source_ip_address = sptr_ip_parameters->source_address;

			if (ptr_to_proxy_server_info->ftp_port_command_on)
				modify_tcp_seq_number_field ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, ptr_to_proxy_server_info->seq_offset);

			if (ftp_port_command)
			{
				ptr_to_proxy_server_info->ftp_port_command_on = TRUE;
				ptr_to_tcp_packet = get_ptr_to_tcp_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters) ;
				old_length = get_port_command_length (ptr_to_tcp_packet) ;
				form_new_port_command (ptr_to_tcp_packet, ptr_to_proxy_server_info->ptr_to_ftp_data_descriptor);
				new_length = get_port_command_length (ptr_to_tcp_packet) ;

#if 0
				printf ("Old Length : %d, New length : %d\n", old_length, new_length) ;
#endif
				uptr_ip_rx_packet->ip.header.total_length += (new_length - old_length) ;
				sptr_ip_parameters->total_length += (new_length - old_length) ;

				ptr_to_proxy_server_info->seq_offset += new_length - old_length;
			}

			update_tcp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters);       

#if  _SUDHIR__ 
			new_checksum = get_tcp_checksum ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
			new_variables_ptr->source_ip_address = sptr_ip_parameters->source_address;
			new_variables_ptr->destination_ip_address = sptr_ip_parameters->destination_address;
			new_variables_ptr->source_port_number = get_tcp_src_port_from_ip_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters);
			new_variables_ptr->destination_port_number = get_tcp_dst_port_from_ip_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters);

			new_variables_ptr->tcp_seq_number = get_tcp_seq_number_from_ip_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
			new_variables_ptr->tcp_ack_number = get_tcp_ack_number_from_ip_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);


				
			adjusted_csum = readjust_checksum ((BYTE *)old_variables_ptr, (BYTE *)new_variables_ptr, (BYTE *) &new_checksum);
			set_tcp_checksum (uptr_ip_rx_packet, sptr_ip_parameters, adjusted_csum);			
			free (old_variables_ptr);
			free (new_variables_ptr);
#endif 
					
			return;		  
							
		case IP_DATA_UDP:
			set_source_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, mapped_port);			
			uptr_ip_rx_packet->ip.header.source_ip_address = sptr_ip_parameters->source_address;
			uptr_ip_rx_packet->ip.header.destination_ip_address = sptr_ip_parameters->destination_address; /* sudha 07 Nov 1998 */

			update_udp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			return;
	}
}


void process_proxy_response_packet (UNION_IP_PACKET *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters,
	  USHORT destination_port, ULONG client_ip_address, BYTE *proxy_server_info)
{
	PROXY_SERVER_INFO *ptr_to_proxy_info;	
	BYTE *sptr_icmp_header, *ptr_to_tcp_packet;
	USHORT new_checksum=0, dest_port, src_port, pasv_port = 0;
	PPTP_INFO_DESCRIPTOR *ptr_to_pptp_info;
	

#ifdef _VPN_PPTP_
	if (sptr_ip_parameters->protocol == TCP_PROTOCOL)
		check_for_pptp_server_packet_and_process (uptr_ip_rx_packet, sptr_ip_parameters);

#endif


#ifdef _VPN_PPTP_
	if (sptr_ip_parameters->protocol == IP_GRE_PROTOCOL)
	{
/*		printf ("PPTP: GRE packet detected while processing response\n"); */
		
		ptr_to_pptp_info = (PPTP_INFO_DESCRIPTOR *)proxy_server_info; 
		if (ptr_to_pptp_info == NULL)
		{
	   	printf ("PPTP: No Descriptor match exists\n");
		}
		process_server_gre_packet_if_required (uptr_ip_rx_packet, sptr_ip_parameters, ptr_to_pptp_info);
				
		sptr_ip_parameters->destination_address = client_ip_address;
		uptr_ip_rx_packet->ip.header.destination_ip_address = client_ip_address;
		return;
	}

#endif

#if 0
	TCP_CHANGED_VARIABLES *old_variables_ptr, *new_variables_ptr;
	int adjusted_csum=0;
	
	old_variables_ptr = (TCP_CHANGED_VARIABLES *) malloc (sizeof (TCP_CHANGED_VARIABLES));
	if (old_variables_ptr == NULL)
	{
		printf ("PROXY: Memory Allocation Error\n");
		return;
	}
	new_variables_ptr = (TCP_CHANGED_VARIABLES *) malloc (sizeof (TCP_CHANGED_VARIABLES));
	if (new_variables_ptr == NULL)
	{
		free (old_variables_ptr);
		printf ("PROXY: Memory Allocation Error\n");
		return;
	}

	old_variables_ptr->source_ip_address = sptr_ip_parameters->source_address;
	old_variables_ptr->destination_ip_address = sptr_ip_parameters->destination_address;
	old_variables_ptr->source_port_number = get_tcp_src_port_from_ip_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters);
	old_variables_ptr->destination_port_number = get_tcp_dst_port_from_ip_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters);

	old_variables_ptr->tcp_seq_number = get_tcp_seq_number_from_ip_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
	old_variables_ptr->tcp_ack_number = get_tcp_ack_number_from_ip_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters); 
#endif

	ptr_to_proxy_info = (PROXY_SERVER_INFO *) proxy_server_info;

	sptr_ip_parameters->destination_address = client_ip_address;		

	uptr_ip_rx_packet->ip.header.destination_ip_address = client_ip_address;

/* Sudha 07 Nov 1998 */	
	if ( sptr_ip_parameters->protocol == IP_DATA_UDP )
	{
		dest_port = get_udp_port_number_from_ip_packet(uptr_ip_rx_packet, sptr_ip_parameters, &src_port); 
		if (( src_port == DNS_RESERVED_PORT ) && 
			(sptr_ip_parameters->source_address != ptr_to_proxy_info->destination_address) &&
			(is_proxy_lan_addr(ptr_to_proxy_info->destination_address)))
		{
/* printf("\n\rPROXY : is proxy lan addr true."); */
			sptr_ip_parameters->source_address = ptr_to_proxy_info->destination_address ;
			uptr_ip_rx_packet->ip.header.source_ip_address = ptr_to_proxy_info->destination_address;
		}
	}

	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_ICMP:
			uptr_ip_rx_packet->icmp.header.option.echo_message.identifier = 
						ptr_to_proxy_info->icmp_packet_id;			
			sptr_icmp_header = get_ptr_to_icmp_header (uptr_ip_rx_packet, sptr_ip_parameters);		
			set_icmp_checksum (sptr_icmp_header, 0);
			new_checksum = calculate_ip_checksum (NULL, sptr_icmp_header, (USHORT) (sptr_ip_parameters->total_length- sptr_ip_parameters->header_length));
			set_icmp_checksum (sptr_icmp_header, new_checksum);
			ptr_to_proxy_info->proxy_idle_timer = 1 ;
			ptr_to_proxy_info->proxy_descriptor_link_idle_timeout = 1;
			return;				

		case IP_DATA_TCP :
/* sudhir for ftp passive command handling */
			ptr_to_tcp_packet = get_ptr_to_tcp_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
			if (strstr (ptr_to_tcp_packet, "227 Entering Passive Mode") != NULL)
			{
				proxy_printf ("PROXY : Passive port command received\n");
				pasv_port = add_passive_port_to_application_list ((BYTE *) ptr_to_tcp_packet);
				ptr_to_proxy_info->pasv_port = pasv_port; /* sudha 31 March 1999 */

			}
			set_destination_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, destination_port);			
			if (ptr_to_proxy_info->ftp_port_command_on)
				modify_tcp_acknowledge_field ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, ptr_to_proxy_info->seq_offset);

/* sudhir for ftp passive command handling */
			update_tcp_checksum_in_packet (uptr_ip_rx_packet,sptr_ip_parameters);   

#if 0
			new_checksum = get_tcp_checksum ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
			new_variables_ptr->source_ip_address = sptr_ip_parameters->source_address;
			new_variables_ptr->destination_ip_address = sptr_ip_parameters->destination_address;
			new_variables_ptr->source_port_number = get_tcp_src_port_from_ip_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters);
			new_variables_ptr->destination_port_number = get_tcp_dst_port_from_ip_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters);
			new_variables_ptr->tcp_seq_number = get_tcp_seq_number_from_ip_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
			new_variables_ptr->tcp_ack_number = get_tcp_ack_number_from_ip_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);

			adjusted_csum = readjust_checksum ((BYTE *)old_variables_ptr, (BYTE *)new_variables_ptr, (BYTE *) &new_checksum);
			set_tcp_checksum (uptr_ip_rx_packet, sptr_ip_parameters, adjusted_csum);			
			free (old_variables_ptr);
			free (new_variables_ptr);
#endif
			return;

		case IP_DATA_UDP :
			set_destination_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, destination_port);			
			update_udp_checksum_in_packet (uptr_ip_rx_packet,sptr_ip_parameters); 
			return;
	}
}





/* sudhir new addition for NAT */



void add_ftp_data_port_descriptor_if_required (BYTE *uptr_ip_rx_packet, 
	IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_control_connection)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_internet_server_descriptor;
	BYTE temp_buff[6];
	BYTE *ptr_to_tcp_pkt;

	USHORT ip_total_length = sptr_ip_parameters->total_length ;
	USHORT port_command_length, ip_header_length = sptr_ip_parameters->header_length ;
	USHORT source_port=0;
	ULONG source_ip_address;

	
	ptr_to_tcp_pkt = get_ptr_to_tcp_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
	memcpy (temp_buff,ptr_to_tcp_pkt,4);
	temp_buff[4] = 0;
	if (strcmpi (temp_buff, "Port"))
	{
		return ;
	}

	printf ("PROXY: FTP port command detected\n");

	ptr_to_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) calloc (sizeof (PROXY_INTERNET_SERVER_DESCRIPTOR), 1);
	if (ptr_to_internet_server_descriptor == NULL)
	{
		printf ("PROXY_SERVER: Not Enough memory to proxy, Dropping packet\n");	
		return ;
	}

	get_ftp_src_port_and_address (ptr_to_tcp_pkt, &source_port, &source_ip_address);
	ptr_to_internet_server_descriptor->destination_address = sptr_ip_parameters->destination_address;
/*	ptr_to_internet_server_descriptor->source_address = source_ip_address; */
	ptr_to_internet_server_descriptor->source_address = sptr_ip_parameters->source_address;
	ptr_to_internet_server_descriptor->destination_port = proxy_server.ftp_data_conn_port;
	ptr_to_internet_server_descriptor->source_port = source_port;
/*	printf ("PROXY : Added %08x %d\n", source_ip_address, source_port);*/
	ptr_to_internet_server_descriptor->protocol = sptr_ip_parameters->protocol;
	ptr_to_internet_server_descriptor->local_mapped_address = sptr_control_connection->local_mapped_address;
	ptr_to_internet_server_descriptor->seq_offset = 0;
	ptr_to_internet_server_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;
	ptr_to_internet_server_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;

/* sudha 06 April 1999 for nat ftp ctrl connection & data connection association
as well as for nat pasv ftp. */

	ptr_to_internet_server_descriptor->ftp_pasv_mode_on = 0;
	ptr_to_internet_server_descriptor->pasv_port = 0;
	ptr_to_internet_server_descriptor->ptr_to_ftp_data_descriptor = NULL;

	ptr_to_internet_server_descriptor->ptr_to_ftp_command_descriptor = sptr_control_connection;
	sptr_control_connection->ptr_to_ftp_data_descriptor = ptr_to_internet_server_descriptor;

	ptr_to_internet_server_descriptor->connection_closing = FALSE;
#ifdef CTRL_DEBUG
printf("\n\rPROXY : nat ftp command desc is %x, nat ftp corresponding data conn is %x",
sptr_control_connection, sptr_control_connection->ptr_to_ftp_data_descriptor);
#endif

	if(ptr_to_internet_server_descriptor->ptr_to_ftp_command_descriptor)
	{
		printf ("Setting idle timer for ftp\n");
#ifdef CTRL_DEBUG
		printf("\n\r1.ftp command desc is %x, data desc is %x",ptr_to_internet_server_descriptor->ptr_to_ftp_command_descriptor,
ptr_to_internet_server_descriptor);
#endif
	   ptr_to_internet_server_descriptor->ptr_to_ftp_command_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;
	}

	add_entry_to_list ((LINK *)&proxy_server.proxy_internet_server_list, (LINK *)ptr_to_internet_server_descriptor);
	return;
}

/* sudha 07 April 1999 for nat pasv ftp */

void update_ftp_command_descriptor_info_if_pasv_ftp(BYTE *uptr_ip_rx_packet, 
 	IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_descriptor)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor;
	USHORT destination_port=0, source_port=0;

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);

	destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &source_port);

	while (sptr_internet_server_descriptor != NULL)
	{
		if (sptr_ip_parameters->source_address == sptr_internet_server_descriptor->source_address
			&& sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->destination_address
			&& sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol
			&& sptr_internet_server_descriptor->pasv_port != 0 
			&& destination_port == sptr_internet_server_descriptor->pasv_port)
		{
			
			ptr_to_descriptor->ptr_to_ftp_command_descriptor = sptr_internet_server_descriptor;
			sptr_internet_server_descriptor->ptr_to_ftp_data_descriptor = ptr_to_descriptor;

#ifdef CTRL_DEBUG
printf("\n\rPROXY: ftp command desc is %x, data desc is %x, pasv_port is %d",
ptr_to_descriptor->ptr_to_ftp_command_descriptor, ptr_to_descriptor, destination_port); 	
#endif
/* sudha 06 April 1999. */
			if (sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor)
			{
#ifdef CTRL_DEBUG
		printf("\n\r2.ftp command desc is %x, data desc is %x",sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor,
sptr_internet_server_descriptor);
#endif
				sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;
			}
			return;
		}

		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}
	return ;
}


enum BOOLEAN check_for_the_descriptor_in_the_current_list(BYTE *uptr_ip_rx_packet, 
 	IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR **matched_descriptor)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor;
	USHORT destination_port=0, source_port=0;

	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);

	destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &source_port);

	while (sptr_internet_server_descriptor != NULL)
	{
		if (sptr_ip_parameters->source_address == sptr_internet_server_descriptor->source_address
			&& sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->destination_address
			&& sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol
			&& destination_port == sptr_internet_server_descriptor->destination_port
			&& source_port == sptr_internet_server_descriptor->source_port)
		{

			if (destination_port == proxy_server.ftp_ctrl_conn_port)
			{
				add_ftp_data_port_descriptor_if_required (uptr_ip_rx_packet,
					sptr_ip_parameters, sptr_internet_server_descriptor);
			}

/* sudha 06 April 1999 */
			if (sptr_ip_parameters->protocol == IP_DATA_TCP)
			{
				if ( is_close_connection_initiated((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters) == TRUE )
				{
					proxy_printf ("PROXY : NAT TCP Connection is closed by %08x\n",
					uptr_ip_rx_packet->ip.header.source_ip_address); 

					sptr_internet_server_descriptor->connection_closing = TRUE;
					sptr_internet_server_descriptor->idle_timer = (proxy_server.proxy_server_idle_timeout) / 125;
				}
			}
			else if ( sptr_internet_server_descriptor->connection_closing == FALSE )
			{
				if (sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor)
				{
#ifdef CTRL_DEBUG
		printf("\n\r3.ftp command desc is %x, data desc is %x",sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor,
sptr_internet_server_descriptor);
#endif
					sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;
				 }
				sptr_internet_server_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;
			}
			sptr_internet_server_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;

/* sudha 06 April 1999. */

			*matched_descriptor = sptr_internet_server_descriptor;
			return TRUE;
		}

		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}
	return FALSE;
}


PROXY_INTERNET_SERVER_DESCRIPTOR *update_descriptor_list_for_local_servers (BYTE *uptr_ip_rx_packet, IP_PARAMETERS *sptr_ip_parameters, 
			ULONG local_destination_address)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_internet_server_descriptor, *temp_ptr;
	USHORT source_port=0, destination_port=0;
	UNION_IP_PACKET *uptr_rx_packet;


	uptr_rx_packet = (UNION_IP_PACKET *) uptr_ip_rx_packet;

	if (check_for_the_descriptor_in_the_current_list (uptr_ip_rx_packet, 
			sptr_ip_parameters, &temp_ptr) == TRUE)
	{
		return temp_ptr;
	}
	
	destination_port =  get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &source_port);
		
	ptr_to_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *)
							calloc (sizeof (PROXY_INTERNET_SERVER_DESCRIPTOR), 1);
	if (ptr_to_internet_server_descriptor == NULL)
	{
		printf ("PROXY :Error Allocating Memory\n");
		return NULL;
	}
	
	ptr_to_internet_server_descriptor->destination_address = sptr_ip_parameters->destination_address; 


	ptr_to_internet_server_descriptor->source_address = sptr_ip_parameters->source_address; 
	ptr_to_internet_server_descriptor->local_mapped_address = local_destination_address;
	ptr_to_internet_server_descriptor->protocol = sptr_ip_parameters->protocol;
	ptr_to_internet_server_descriptor->destination_port = destination_port;
	ptr_to_internet_server_descriptor->source_port = source_port;
	ptr_to_internet_server_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;
	ptr_to_internet_server_descriptor->seq_offset = 0;

/* sudha 06 April 1999 */
	ptr_to_internet_server_descriptor->ftp_pasv_mode_on = 0; 
	ptr_to_internet_server_descriptor->pasv_port = 0;
	ptr_to_internet_server_descriptor->ptr_to_ftp_command_descriptor = NULL;
	ptr_to_internet_server_descriptor->ptr_to_ftp_data_descriptor = NULL;
	ptr_to_internet_server_descriptor->connection_closing = FALSE;
/* sudha 06 April 1999 */

	ptr_to_internet_server_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;

/* sudha 06 April 1999. */
	update_ftp_command_descriptor_info_if_pasv_ftp(uptr_ip_rx_packet, 
			sptr_ip_parameters, ptr_to_internet_server_descriptor);

#if 0
	printf ("Destination address %04x\n",ptr_to_internet_server_descriptor->destination_address);
	printf ("Source addres %04x\n",ptr_to_internet_server_descriptor->source_address);
	printf ("Local mapped address %04x\n",ptr_to_internet_server_descriptor->local_mapped_address);
	printf ("Adding new entries with ports %d %d\n",destination_port ,source_port);
	printf ("Received port number is %d\n", ptr_to_internet_server_descriptor->rx_port_number);
#endif
	add_entry_to_list ((LINK *)&proxy_server.proxy_internet_server_list, (LINK *)ptr_to_internet_server_descriptor);
	return ptr_to_internet_server_descriptor;
}

enum BOOLEAN check_if_the_packet_is_from_a_local_server (BYTE *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR **server_descriptor)
{
	PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_internet_server_descriptor;
	USHORT destination_port=0, source_port=0;


	sptr_internet_server_descriptor = get_pointer_to_first_entry_in_list
						((LINK *)&proxy_server.proxy_internet_server_list);
	
	destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, &source_port);
	
#if 0
	if (source_port == proxy_server.ftp_data_conn_port)
		printf ("Destination Port is %d\n",destination_port);
#endif
	
	while (sptr_internet_server_descriptor != NULL)
	{
		switch (sptr_ip_parameters->protocol)
		{
			case IP_DATA_TCP:
			case IP_DATA_UDP:
				if (sptr_ip_parameters->source_address == sptr_internet_server_descriptor->local_mapped_address
					&& sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->source_address
					&& sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol
					&& destination_port == sptr_internet_server_descriptor->source_port)
				{
/*					*global_source_address = sptr_internet_server_descriptor->destination_address;  */
					*server_descriptor = sptr_internet_server_descriptor;

/* sudha 06 April 1999 */
					if(is_close_connection_initiated((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters) == TRUE)
					{
						proxy_printf ("PROXY : NAT TCP Connection is closed by %08x\n",
								uptr_ip_rx_packet->ip.header.source_ip_address); 

						sptr_internet_server_descriptor->connection_closing = TRUE;
						sptr_internet_server_descriptor->idle_timer = (proxy_server.proxy_server_idle_timeout) /125;
					}

					else if (sptr_internet_server_descriptor->connection_closing == FALSE)
					{
						if (sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor)
						{
#ifdef CTRL_DEBUG
		printf("\n\r4.ftp command desc is %x, data desc is %x",sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor,
sptr_internet_server_descriptor);
#endif
							sptr_internet_server_descriptor->ptr_to_ftp_command_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;
						}
						sptr_internet_server_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;
					}
/* sudha 06 April 1999 */

/*					printf ("PROXY: Received packets from a local server\n"); */
					return TRUE;
				}
				break;

			case IP_DATA_ICMP:
				if (sptr_ip_parameters->source_address == sptr_internet_server_descriptor->local_mapped_address
					&& sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->source_address
					&& sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol)

				{
					*server_descriptor = sptr_internet_server_descriptor;
					sptr_internet_server_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;
					return TRUE;
				}
				break;

			default:
				break;
		}
#if 0
		printf ("Source address comp %04x %04x\n",
			sptr_ip_parameters->destination_address,
			sptr_internet_server_descriptor->source_address);
		if (source_port == proxy_server.ftp_data_conn_port)
		{
			printf ("PROXY SRC: %08x  %08x\n",sptr_ip_parameters->source_address, sptr_internet_server_descriptor->local_mapped_address);
			printf ("PROXY DST: %08x  %08x\n",sptr_ip_parameters->destination_address, sptr_internet_server_descriptor->source_address);
			printf ("PROXY PROT: %d  %d\n",sptr_ip_parameters->protocol, sptr_internet_server_descriptor->protocol);
			printf ("PROXY PORT: %d  %d\n",destination_port, sptr_internet_server_descriptor->source_port);
		}
						

		if (sptr_ip_parameters->source_address == sptr_internet_server_descriptor->local_mapped_address
			&& sptr_ip_parameters->destination_address == sptr_internet_server_descriptor->source_address
			&& sptr_ip_parameters->protocol == sptr_internet_server_descriptor->protocol
			&& destination_port == sptr_internet_server_descriptor->source_port)
		{
/*			*global_source_address = sptr_internet_server_descriptor->destination_address;  */
			*server_descriptor = sptr_internet_server_descriptor;
			sptr_internet_server_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;
			return TRUE;
		}
#endif

		sptr_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *) get_pointer_to_next_entry_in_list ((LINK *)sptr_internet_server_descriptor);
	}
	return FALSE;
}


ULONG get_dynamic_server_address_from_port_number (USHORT application_port, USHORT protocol)
{
	USHORT server_index;
	PROXY_DYNAMIC_SERVER_LIST *sptr_dynamic_internet_server_list;

	PROXY_DYNAMIC_NAT_APP_LIST *temp_dynamic_internet_app_list; /* sudha 06 April 1999 */

	sptr_dynamic_internet_server_list = proxy_server.dynamic_internet_server_list;
	switch (protocol)
	{
		case IP_DATA_TCP:
		case IP_DATA_UDP:
			for (server_index=0; server_index < proxy_server.total_number_of_dynamic_servers;
					server_index++, sptr_dynamic_internet_server_list++)
			{	
				if (application_port == sptr_dynamic_internet_server_list->application_port &&
						protocol == sptr_dynamic_internet_server_list->ip_protocol_type)			

				return (sptr_dynamic_internet_server_list->dynamic_server_ip_address);
			}

/* sudha 05 April 1999... */
						
			temp_dynamic_internet_app_list = proxy_server.dynamic_nat_application_list;
			while(temp_dynamic_internet_app_list != NULL)
			{
				if (application_port == temp_dynamic_internet_app_list->application_port &&
						protocol == temp_dynamic_internet_app_list->ip_protocol_type)			
					return (temp_dynamic_internet_app_list->dynamic_server_ip_address);
				else
					temp_dynamic_internet_app_list = temp_dynamic_internet_app_list->sptr_forward_link;
			}
/* ...sudha 05 April 1999. */
		break;

		case IP_DATA_ICMP:
			return (sptr_dynamic_internet_server_list->dynamic_server_ip_address);
	}
	return 0;
}


enum BOOLEAN check_if_the_destination_is_our_interface_address (ULONG destination_address)
{
	USHORT lan_ports=0, wan_ports, port_index;

	lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);
	wan_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS);

	for (port_index=0; port_index < lan_ports+wan_ports; port_index++)
	{
	 	if (destination_address == get_ip_address (port_index+lan_ports))
		{
			return TRUE;
		}
	}
	return FALSE;
}


enum BOOLEAN check_if_the_packet_is_for_our_NAT_address (BYTE *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters,ULONG *local_destination_ip_address, 
		enum BOOLEAN *is_my_packet)
{
	USHORT global_addr_index, source_port, destination_port;
	ULONG static_or_dynamic_mapped_local_address;
	PROXY_NAT_ADDRESS_LIST *sptr_global_address_list;
	

	destination_port = get_application_port_number (uptr_ip_rx_packet, sptr_ip_parameters,
			&source_port);

	if ((sptr_ip_parameters->destination_address == proxy_server.proxy_local_internet_server_address)
		&& (sptr_ip_parameters->destination_address != 0x00000000L))
	{
/* This packet is meant for dynamically configured servers 
	we need to get the local server address from dynamic server list */
		*local_destination_ip_address = get_dynamic_server_address_from_port_number (destination_port, sptr_ip_parameters->protocol);
/*		printf ("Packet is for our dynamic address%04x\n", *local_destination_ip_address);  */
		*is_my_packet = FALSE;
		return TRUE;
	}

	sptr_global_address_list = proxy_server.global_address_list;

	for (global_addr_index = 0; global_addr_index <= proxy_server.total_number_of_global_address;
			global_addr_index++, sptr_global_address_list++)				
	{

/* sudha 05 July 1999.To prevent NAT with 0.0.0.0 or 0.0.0.1 or 0.0.0.2
or 0.0.0.3 as destination addr as these addresses are for our internal
use to replace with wan interface addr dynamically & not for the usage
of internet clients */

		if ((sptr_ip_parameters->destination_address == sptr_global_address_list->global_address)
			&& (sptr_ip_parameters->destination_address != 0x00000000L)
			&& (sptr_ip_parameters->destination_address != 0x00000001L)
			&& (sptr_ip_parameters->destination_address != 0x00000002L)
			&& (sptr_ip_parameters->destination_address != 0x00000003L))
		{
			*local_destination_ip_address = sptr_global_address_list->local_address;
			*is_my_packet = FALSE;
			return TRUE;						
		}				
	}

	if (check_if_the_destination_is_our_interface_address (sptr_ip_parameters->destination_address) == TRUE)
	{
		static_or_dynamic_mapped_local_address = get_static_or_dynamic_mapped_local_address_from_interface_address(sptr_ip_parameters->destination_address,destination_port, sptr_ip_parameters->protocol);
		if (static_or_dynamic_mapped_local_address != 0)
		{
/* printf("\n\rPROXY : static_dynamic server address is %lX",static_or_dynamic_mapped_local_address);*/
		 	*local_destination_ip_address = static_or_dynamic_mapped_local_address;
		 	*is_my_packet = FALSE;
		 	return TRUE;						
		}

/* sudha 20 July 1999. */
#if 0
/* Imran 24 Feb '99.
	We need to get the local server address from dynamic server list if
		* dynamic mapping exists for global address 0.0.0.0 
		* destination ip address is one of our WAN ports 
*/

		if ((proxy_server.number_of_dynamic_servers != 0) &&
				((proxy_server.proxy_local_internet_server_address == 0x00000000L) ||
				(proxy_server.proxy_local_internet_server_address == 0x00000001L) ||
				(proxy_server.proxy_local_internet_server_address == 0x00000002L) ||
				(proxy_server.proxy_local_internet_server_address == 0x00000003L)))
		{
			*local_destination_ip_address = get_dynamic_server_address_from_port_number (destination_port, sptr_ip_parameters->protocol);
/* printf ("Packet is for our dynamic address%04x\n", *local_destination_ip_address);  */
			*is_my_packet = FALSE;
			return TRUE;
		}
#endif

/*		printf ("PROXY: Packet is meant for our LAN addres\n");  */
		
/* sudha 21 May 1999 */
		if ((destination_port == TELNET_RESERVED_PORT) || 
			(destination_port == WEB_RESERVED_PORT))
		{
			*local_destination_ip_address = 	get_ip_address (0);
			*is_my_packet = TRUE;
			return TRUE;
		}
	}

	return FALSE;	
}	

void process_ftp_port_command_and_update_descriptor_list (BYTE *uptr_ip_rx_packet,
		IP_PARAMETERS *sptr_ip_parameters)
{
	USHORT source_port=0;
	ULONG source_ip_address;
	BYTE *ptr_to_tcp_pkt;
	PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_internet_server_descriptor;
	BYTE temp_buff[6];

	ptr_to_tcp_pkt = get_ptr_to_tcp_packet ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters);
	memcpy (temp_buff,ptr_to_tcp_pkt,4);
	temp_buff[4] = 0;
	if (strcmpi (temp_buff, "Port"))
	{
		return;
	}

	printf ("PROXY: FTP port command detected\n");
	ptr_to_internet_server_descriptor = (PROXY_INTERNET_SERVER_DESCRIPTOR *)
							malloc (sizeof (PROXY_INTERNET_SERVER_DESCRIPTOR));

	if (ptr_to_internet_server_descriptor == NULL)
	{
		printf ("PROXY :Error Allocating Memory\n");
		return ;
	}

	get_ftp_src_port_and_address (ptr_to_tcp_pkt, &source_port, &source_ip_address);

	ptr_to_internet_server_descriptor->destination_address = sptr_ip_parameters->destination_address; 
	ptr_to_internet_server_descriptor->source_address = sptr_ip_parameters->source_address; 
	ptr_to_internet_server_descriptor->protocol = sptr_ip_parameters->protocol;
	ptr_to_internet_server_descriptor->destination_port = proxy_server.ftp_data_conn_port;
	ptr_to_internet_server_descriptor->source_port = source_port;
	ptr_to_internet_server_descriptor->rx_port_number = sptr_ip_parameters->rx_port_number;
	ptr_to_internet_server_descriptor->seq_offset = 0;
	ptr_to_internet_server_descriptor->idle_timer = proxy_server.proxy_server_idle_timeout;

#if 0
	printf ("Destination address %04x\n",ptr_to_internet_server_descriptor->destination_address);
	printf ("Source addres %04x\n",ptr_to_internet_server_descriptor->source_address);
	printf ("Local mapped address %04x\n",ptr_to_internet_server_descriptor->local_mapped_address);
	printf ("Adding new entries with ports %d\n",source_port);
	printf ("Received port number is %d\n", ptr_to_internet_server_descriptor->rx_port_number);
#endif

	add_entry_to_list ((LINK *)&proxy_server.proxy_internet_server_list, (LINK *)ptr_to_internet_server_descriptor);
	return;		 	
}



void process_packets_meant_for_local_servers (UNION_IP_PACKET *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, ULONG local_destination_address,
		PROXY_INTERNET_SERVER_DESCRIPTOR *server_descriptor_info)
{
	USHORT destination_port=0, source_port=0;
	
	sptr_ip_parameters->destination_address = local_destination_address;
	uptr_ip_rx_packet->ip.header.destination_ip_address = local_destination_address;
	  
	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_TCP:
			destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet,
											sptr_ip_parameters, &source_port);
			if (destination_port == proxy_server.ftp_ctrl_conn_port)
			{
/*			 	process_ftp_port_command_and_update_descriptor_list ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters ); */
/*				modify_tcp_acknowledge_field ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info->seq_offset);  */
			}

/* sudha 03 April 1999. */			
			if(server_descriptor_info->ftp_pasv_mode_on)
				modify_tcp_acknowledge_field ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info->seq_offset);

			update_tcp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			break;

		case IP_DATA_UDP:
			update_udp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			break;

		case IP_DATA_ICMP:
			break;
	}
}


void process_the_ftp_packet_after_pasv_commd (UNION_IP_PACKET *uptr_ip_rx_packet, 
		IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR *server_descriptor_info, enum BOOLEAN *ftp_pasv_mode)
{
	BYTE *ptr_to_tcp_packet;
	int old_length, new_length ;
	BYTE ip_address[20], port_buff[10];
	USHORT number_of_commas=0, buffer_index=0, port_index=0;

/* sudha 06 April 1999 */	
	USHORT port1, port2, new_port_number;
	PROXY_DYNAMIC_NAT_APP_LIST *ptr_to_nat_app_list;	



	ptr_to_tcp_packet = get_ptr_to_tcp_packet ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters) ;
	old_length = get_port_command_length (ptr_to_tcp_packet) ;

	if (strstr (ptr_to_tcp_packet, "227 Entering Passive Mode") == NULL)
	{
		*ftp_pasv_mode = FALSE;
		return;
	}

	ptr_to_nat_app_list = (PROXY_DYNAMIC_NAT_APP_LIST *) calloc (sizeof (PROXY_DYNAMIC_NAT_APP_LIST), 1);
	if (ptr_to_nat_app_list == NULL)
	{
		printf ("PROXY : Not Enough memory add application\n");
		return;
	} 

	ptr_to_nat_app_list->dynamic_server_ip_address = server_descriptor_info->local_mapped_address;
	ptr_to_nat_app_list->ip_protocol_type = server_descriptor_info->protocol;

	convert_ip_address_to_dot_format (&ip_address[0], server_descriptor_info->destination_address);
	for (buffer_index = 0 ; ip_address[buffer_index] ; buffer_index++)
		if (ip_address[buffer_index] == '.')
			ip_address[buffer_index] = ',' ;
			
	for (buffer_index =0; ptr_to_tcp_packet[buffer_index] != 0x0A; buffer_index++)
	{
		if (number_of_commas == 4) /* sudha 03 April 1999. */
		{
			if((ptr_to_tcp_packet[buffer_index] == 0x0D) || 
				(ptr_to_tcp_packet[buffer_index] == ')'))
				break;

			port_buff[port_index] = ptr_to_tcp_packet[buffer_index];
			port_index++;
			continue;
		}
		if (ptr_to_tcp_packet[buffer_index] == ',')
			number_of_commas++;
	}
	port_buff[port_index] = 0;

	sprintf (&ptr_to_tcp_packet[0], "227 Entering Passive Mode (%s,%s)\x0D\x0A",
			&ip_address[0], &port_buff[0]);

	sscanf (port_buff ,"%hu,%hu",&port1, &port2);		
	
	port1 = port1 & 0x00ff;
	port1 = port1 << 8;
	port2 = port2 &0x00ff;
	new_port_number = (port1 | port2);
	ptr_to_nat_app_list->application_port = new_port_number;

	server_descriptor_info->pasv_port = new_port_number;

#ifdef CTRL_DEBUG
	printf("\n\rPROXY: added port number %d, server ip addr %lu to dynamic nat app list",
new_port_number, ptr_to_nat_app_list->dynamic_server_ip_address);
#endif	

	ptr_to_nat_app_list->sptr_forward_link = proxy_server.dynamic_nat_application_list;
	proxy_server.dynamic_nat_application_list = ptr_to_nat_app_list;
	
#ifdef CTRL_DEBUG
	printf("\n\rPROXY: New pasv command is %s",&ptr_to_tcp_packet[0]);
#endif

	new_length = get_port_command_length (ptr_to_tcp_packet) ;

#ifdef CTRL_DEBUG
	printf ("Old Length : %d, New length : %d\n", old_length, new_length) ;
#endif

	uptr_ip_rx_packet->ip.header.total_length += (new_length - old_length) ;
	sptr_ip_parameters->total_length += (new_length - old_length) ;

	server_descriptor_info->seq_offset += new_length - old_length;

#ifdef CTRL_DEBUG
	printf("\n\rPROXY: seq_offset is %d",server_descriptor_info->seq_offset);
#endif

/* sudha 03 April 1999... */
	*ftp_pasv_mode = TRUE;
	server_descriptor_info->ftp_pasv_mode_on = TRUE;
/* ...sudha 03 April 1999. */

	return;
}


void process_packets_from_local_servers (UNION_IP_PACKET *uptr_ip_rx_packet,
		IP_PARAMETERS *sptr_ip_parameters, PROXY_INTERNET_SERVER_DESCRIPTOR *server_descriptor_info, enum BOOLEAN *ftp_pasv_mode)
{
	USHORT source_port=0, destination_port=0;
	BYTE *sptr_icmp_header;
	USHORT new_checksum=0;

	sptr_ip_parameters->source_address = server_descriptor_info->destination_address;
	uptr_ip_rx_packet->ip.header.source_ip_address = server_descriptor_info->destination_address;

	switch (sptr_ip_parameters->protocol)
	{
		case IP_DATA_TCP:
			destination_port = get_application_port_number ((BYTE *) uptr_ip_rx_packet, 
					sptr_ip_parameters, &source_port);				

#if 0
			if (source_port == proxy_server.ftp_ctrl_conn_port)
			{
				process_the_ftp_packet_after_pasv_commd (uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info);
				modify_tcp_seq_number_field ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info->seq_offset);
			}
#endif

/* sudha 03 April 1999... */
			if (server_descriptor_info->ftp_pasv_mode_on)	
				modify_tcp_seq_number_field ((BYTE *) uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info->seq_offset);

			if (source_port == proxy_server.ftp_ctrl_conn_port)
				process_the_ftp_packet_after_pasv_commd (uptr_ip_rx_packet, sptr_ip_parameters, server_descriptor_info, ftp_pasv_mode);

/* ...sudha 03 April 1999 */

			update_tcp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			break;
		 	
		case IP_DATA_UDP:
			update_udp_checksum_in_packet (uptr_ip_rx_packet, sptr_ip_parameters); 
			break;

		case IP_DATA_ICMP:
#if 0
			sptr_icmp_header = get_ptr_to_icmp_header (uptr_ip_rx_packet, sptr_ip_parameters);		 
			set_icmp_checksum (sptr_icmp_header, 0);
			new_checksum =	calculate_ip_checksum (NULL, 
					(BYTE *)sptr_icmp_header, (USHORT) (sptr_ip_parameters->total_length- sptr_ip_parameters->header_length));
			set_icmp_checksum (sptr_icmp_header, new_checksum);
#endif
			break;
	}
}



enum BOOLEAN check_and_process_the_packets_to_or_from_internet_servers (UNION_IP_PACKET *uptr_ip_rx_packet,
		IP_PARAMETERS *sptr_ip_parameters, USHORT *outgoing_port_number, enum BOOLEAN *is_my_packet, enum BOOLEAN *ftp_pasv_mode)
{
	ULONG local_destination_address;
	PROXY_INTERNET_SERVER_DESCRIPTOR *server_descriptor_info;

	if (check_if_the_packet_is_for_our_NAT_address ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, &local_destination_address, is_my_packet) == TRUE)
	{
		server_descriptor_info = update_descriptor_list_for_local_servers ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters,
				local_destination_address);

		if (server_descriptor_info == NULL)
			return FALSE;

 		process_packets_meant_for_local_servers (uptr_ip_rx_packet, sptr_ip_parameters,
			local_destination_address, server_descriptor_info);

		*outgoing_port_number = 0;
		return TRUE;
	}

	if (check_if_the_packet_is_from_a_local_server ((BYTE *)uptr_ip_rx_packet, sptr_ip_parameters, 
		&server_descriptor_info) == TRUE)
	{
		process_packets_from_local_servers (uptr_ip_rx_packet, sptr_ip_parameters,
			server_descriptor_info, ftp_pasv_mode);
		*outgoing_port_number = server_descriptor_info->rx_port_number;
		return TRUE;
	}
	return FALSE;
}	


void ppp_port_client_disconnected (USHORT real_port_number)
{
	proxy_server.port[real_port_number].client_disconnected = TRUE;
	return;
}

BOOL is_user_defined_port_not_in_reserved_port_list(USHORT lower_port, USHORT higher_port)
{
	int index1, index2;
	if ( higher_port == 0 )
	{
		index1 = lower_port;
		for(index2 = 0; index2 < MAX_TCP_APPLICATIONS; index2++)
		{
			if ( index1 == tcp_applications[index2].protocol_port_number )
				return FALSE;
		}

		for(index2 = 0; index2 < MAX_UDP_APPLICATIONS; index2++)
		{
			if ( index1 == udp_applications[index2].protocol_port_number )
				return FALSE;
		}
	}
	else
	{
		for (index1 = lower_port; index1 <= higher_port; index1++)
		{
			for(index2 = 0; index2 < MAX_TCP_APPLICATIONS; index2++)
			{
				if ( index1 == tcp_applications[index2].protocol_port_number )
					return FALSE;
			}
		
			for(index2 = 0; index2 < MAX_UDP_APPLICATIONS; index2++)
			{
				if ( index1 == udp_applications[index2].protocol_port_number )
					return FALSE;
			}
		}
	}
	return TRUE;
}

BOOL is_user_defined_port_desc_not_in_reserved_port_desc(BYTE user_desc[16])
{
	int index1;

	for(index1 = 0; index1 < MAX_TCP_APPLICATIONS; index1++)
	{
		if ( strcmpi((char *)user_desc,tcp_applications[index1].application ) == 0)
			return FALSE;
	}

	for(index1 = 0; index1 < MAX_UDP_APPLICATIONS; index1++)
	{
		if ( strcmpi((char *)user_desc,udp_applications[index1].application ) == 0)
			return FALSE;
	}
	return TRUE;
}

ULONG get_static_or_dynamic_mapped_local_address_from_interface_address (ULONG destination_address,USHORT destination_port, USHORT protocol)
{
	USHORT global_addr_index;
	USHORT lan_ports=0, wan_ports, port_index;
	int	hardware_model;
	ULONG local_destination_ip_address;

	PROXY_NAT_ADDRESS_LIST *sptr_global_address_list;

	sptr_global_address_list = proxy_server.global_address_list;

	lan_ports = lsl_control(GET_NUMBER_OF_LAN_PORTS);
	wan_ports = lsl_control(GET_NUMBER_OF_WAN_PORTS);

	hardware_model = lsl_control(GET_HARDWARE_MODEL);

	for (port_index=0; port_index < wan_ports; port_index++)
	{
		if (destination_address == get_ip_address (port_index+lan_ports))
			break;
	}

	for (global_addr_index = 0; global_addr_index <= proxy_server.total_number_of_global_address;
			global_addr_index++, sptr_global_address_list++)				
	{

/* If static mapping exists for 0.0.0.1 global addr, & if destination addr
is our wan port 1 interface addr, get the mapped local address for that 
0.0.0.1 entry */

		if (port_index == 0x00)
 		{
		  	if (sptr_global_address_list->global_address == 0x00000001L)
				return (sptr_global_address_list->local_address);
			else
				continue;
		}

		else if (((hardware_model == MODEL_MTSR3_200) ||
			(hardware_model == MODEL_MTSR2_201)) && (port_index == 0x01)) 
		{
/* If static mapping exists for 0.0.0.2 global addr, & if destination addr
is our wan port 2 interface addr, get the mapped local address for that 
0.0.0.2 entry */

			if (sptr_global_address_list->global_address == 0x00000002L)
				return (sptr_global_address_list->local_address);
			else
				continue;
		}
/* If static mapping exists for 0.0.0.3 global addr, & if destination addr
is our wan port 3 interface addr, get the mapped local address for that 
0.0.0.3 entry */

		 else	if ((port_index == 0x02) && (hardware_model == MODEL_MTSR3_200))
 		 {
				if (sptr_global_address_list->global_address == 0x00000003L)
					return (sptr_global_address_list->local_address);
				else
					continue;
		}
	}

	if (proxy_server.number_of_dynamic_servers != 0)
	{
		if ((port_index == 0x00) &&
			(proxy_server.proxy_local_internet_server_address == 0x00000001L))
		{
			local_destination_ip_address = get_dynamic_server_address_from_port_number (destination_port, protocol);
			if (local_destination_ip_address != 0)
				return (local_destination_ip_address);
		}
		else if ((port_index == 0x01) &&
			(proxy_server.proxy_local_internet_server_address == 0x00000002L))
		{
			local_destination_ip_address = get_dynamic_server_address_from_port_number (destination_port, protocol);
			if (local_destination_ip_address != 0)
				return (local_destination_ip_address);
		}
		else if ((port_index == 0x02) &&
			(proxy_server.proxy_local_internet_server_address == 0x00000003L))
		{
			local_destination_ip_address = get_dynamic_server_address_from_port_number (destination_port, protocol);
			if (local_destination_ip_address != 0)
				return (local_destination_ip_address);
		}

		if	(proxy_server.proxy_local_internet_server_address == 0x00000000L)
		{
			local_destination_ip_address = get_dynamic_server_address_from_port_number (destination_port, protocol);
			if (local_destination_ip_address != 0)
				return (local_destination_ip_address);
		}
	}

	sptr_global_address_list = proxy_server.global_address_list;

	for (global_addr_index = 0; global_addr_index <= proxy_server.total_number_of_global_address;
			global_addr_index++, sptr_global_address_list++)				
	{

/* If static mapping exists for 0.0.0.0 global addr, & if destination addr
is one of our wan interface addr, get the mapped local address for that 
0.0.0.0 entry */

		if (sptr_global_address_list->global_address == 0x00000000L)
			return (sptr_global_address_list->local_address);
		
	}

	return 0;
}

