/* sudhir */

/************************************************************************/
/*
Changes History : 
	{ sudha 12-Nov-1999. Changes in initialize_proxy_server() function }
*/
/************************************************************************/


#include <defs.h>


#include	<stdio.h>
#include	<stdarg.h>
#include <stddef.h>
#include	<stdlib.h>

#include "proxy.h"

#include <redblack.h>
#include "proxyrb.h"


#if STATUS_DEBUG
enum BOOLEAN register_debugger (void (*fptr_debug_function)(), char *signature) ;
void proxy_configuration (void) ;
void proxy_status (void) ;
void proxy_internet_port_status ();
#endif


extern PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_proxy_client_descriptor_tree ;
extern PROXY_SERVER_DESCRIPTOR_NODE far *sptr_proxy_server_descriptor_tree ;
extern PROXY_LINKCTRL_DESCRIPTOR_NODE far *sptr_proxy_linkctrl_descriptor_tree;

extern void display_proxy_client_descriptors ();

extern void proxy_server_timer ();
extern enum TEST proxy_server_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, 
		ULONG parameter_1);
extern void debug_proxy_dns_filter_info ();
extern void display_proxy_dns_cache_info ();
extern void proxy_user_defined_application ();
extern void set_ftp_port_numbers_during_init(); /* sudha 19 Aug 1999 */

extern PROXY_SERVER_CLASS proxy_server;

BYTE *sptr_proxy_mapped_port_status= NULL;

/* Imran 19.02.99 */
extern enum TEST initialize_proxy_server_discovery ();

extern void display_proxy_tree ();

enum TEST initialize_proxy_server (ULONG clock_ticks_per_second)
{
	USHORT port_index=0;

	if (proxy_server.proxy_server_enabled == FALSE)
		return PASS;

	proxy_server.number_of_proxied_clients = 0;
	proxy_server.total_number_of_pseudo_connections = 0;
	
	proxy_server.dynamic_port_number = DYNAMIC_PORT_NUMBER;
	proxy_server.reserved_port_number_value = STARTING_RESERVED_PORT;
	proxy_server.new_icmp_packet_id = 5;

/* sudha 12-Nov-1999... */
	proxy_server.number_of_address_resolved = 0;
	proxy_server.actual_number_of_address_resolved = 0;
/* ...sudha 12-Nov-1999 */

	proxy_server.dns_resolver_state = PROXY_START_DNS_CLIENT;

	if (proxy_server.maximum_number_of_descriptors == 0)
		proxy_server.maximum_number_of_descriptors = MAXIMUM_ACTIVE_DESCRIPTORS;

	sptr_proxy_mapped_port_status = calloc (8195,1);  /* Imran, 10/2/99 */
	if (sptr_proxy_mapped_port_status == NULL)
	{
		printf ("PROXY : Not Enough memory to store port status\n");
		return;
	}

	proxy_server.start_resolving_dns_filters = FALSE;
		
	for (port_index = 1; port_index < NUMBER_OF_IP_PORTS ; port_index++)
	{
		proxy_server.port[port_index].throughput_index = 1;
		proxy_server.port[port_index].number_of_connections = 0;
		proxy_server.port[port_index].start_monitoring_port_traffic = FALSE;
		proxy_server.port[port_index].port_monitoring_timer=0;

		proxy_server.port[port_index].host_threshold_level_reached = FALSE;
		proxy_server.port[port_index].host_threshold_monitoring_timer = 0;

		proxy_server.port[port_index].do_not_allocate_this_port = FALSE;


		proxy_server.port[port_index].client_disconnected = FALSE;

/* sudha 15 Dec 1998.Initialized these variables....*/
		  if (port_index == 2)
		  {
			  proxy_server.number_of_descriptors_to_trigger_port2 = proxy_server.port[port_index].maximum_number_of_connections_to_dial;
			  proxy_server.number_of_active_hosts_to_trigger_port2 = proxy_server.port[port_index].maximum_number_of_hosts_to_dial ;
		  }

		  if (port_index == 3)
		  {
			  proxy_server.number_of_descriptors_to_trigger_port3 = proxy_server.port[port_index].maximum_number_of_connections_to_dial;
			  proxy_server.number_of_active_hosts_to_trigger_port3 = proxy_server.port[port_index].maximum_number_of_hosts_to_dial ;
		  }
/* ...sudha 15 Dec 1998.Initialized these variables.*/

	}		

	proxy_server.minimum_connections_required_for_port2 = proxy_server.number_of_descriptors_to_trigger_port2 / 5;
	proxy_server.minimum_hosts_required_for_port2 = proxy_server.number_of_active_hosts_to_trigger_port2 / 5;

	proxy_server.minimum_connections_required_for_port3 = proxy_server.number_of_descriptors_to_trigger_port3 / 5;
	proxy_server.minimum_hosts_required_for_port3 = proxy_server.number_of_active_hosts_to_trigger_port3 / 5;

/* sudha 19 Aug 1999 */
	set_ftp_port_numbers_during_init(); 

/* Imran 19.02.99 , added for auto-detection */
   if (initialize_proxy_server_discovery() == FAIL)
      return FAIL;

#ifdef __LSL__
	if ((enum TEST) lsl_control (REGISTER_APPLICATION, "PROXY Server", PROXY_SERVER_APPLICATION, proxy_server_timer, 
			proxy_server_control, &proxy_server.application_id) == FAIL)	
	{
		proxy_printf ("PROXY_SERVER: register_application () failed to register Proxy Server with lsl\n");
		return (FAIL);
	}
	proxy_printf ("PROXY_SERVER : Intialized proxy server\n");
#if 1
	register_debugger (proxy_configuration, "PROCON") ;
	register_debugger (proxy_status, "PROSTAT") ;
	register_debugger (proxy_internet_port_status, "PORTSTAT");
	register_debugger (proxy_user_defined_application, "PUSER");
	register_debugger (display_proxy_tree, "PROXYTREE");
	register_debugger (display_proxy_client_descriptors, "PRCLIENTDE");
	register_debugger (debug_proxy_dns_filter_info, "PRDNSFILT");
	register_debugger (display_proxy_dns_cache_info, "PRDNSCACHE");
#endif
	return (PASS);
#else
	return (FAIL);
#endif
	
	return PASS;
}

enum TEST
proxy_server_control(enum APPLICATION_CONTROL_OPERATION command, ULONG parameter_0, 
		ULONG parameter_1)
{
	return PASS;
}


extern char *convert_ip_address_to_dot_format (char *, ULONG) ;
extern char *get_protocol_type (char *protocol_type_string, enum IP_PROTOCOL_VALUE protocol_type) ;
extern char *get_port_type (char *port_type_string, enum IP_PROTOCOL_VALUE protocol_type, USHORT protocol_port_number) ;

void ip_port_down (USHORT port_number); /* sudha 20 Nov 1998 */
void ip_port_up (USHORT port_number) ;

void ip_port_up (USHORT port_number)
{
/* Sachin, 3rd Oct. 1997 */
   proxy_server.port[port_number].port_down_by_no_demand = FALSE ;
/* Sachin, 3rd Oct. 1997 */
	proxy_server.port[port_number].client_disconnected = FALSE;
/*    proxy_configuration () ; */
}

void ip_port_down (USHORT port_number)
{
	PROXY_SERVER_INFO *ptr_to_proxy_server_info;
	USHORT count=0, icmp_count = 0, client_count = 0, client_connections = 0;
   PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_root = sptr_proxy_client_descriptor_tree ;
	PROXY_CLIENT_DESCRIPTOR_NODE far *sptr_next_node;

   PROXY_SERVER_DESCRIPTOR_NODE far *sptr_server_root = sptr_proxy_server_descriptor_tree ;
	PROXY_SERVER_DESCRIPTOR_NODE far *sptr_next_server_node;
	
   PROXY_LINKCTRL_DESCRIPTOR_NODE far *sptr_linkctrl_root = sptr_proxy_linkctrl_descriptor_tree ;
	PROXY_LINKCTRL_DESCRIPTOR_NODE far *sptr_next_linkctrl_node;

   proxy_server.port[port_number].port_down_by_no_demand = TRUE ;
	
	if (sptr_root == NULL && sptr_server_root == NULL && sptr_linkctrl_root == NULL)
		return;

	if ( sptr_root != NULL )
	{
		sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;

		while (sptr_next_node)
		{
			if (sptr_next_node == NULL)
				return;
		
			ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.client_descriptor;
			if (ptr_to_proxy_server_info->outgoing_physical_port == port_number)
			{
				count++;
				ptr_to_proxy_server_info->proxy_idle_timer = 0 ;
				ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = 0;
			}
			sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
		}
/*		printf ("\n\rPROXY : Deleted %d Descriptors for port %04x\n", count, port_number);*/
	}

	if ( sptr_server_root != NULL )
	{
		sptr_next_server_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_server_root) ;

		while (sptr_next_server_node)
		{
			if (sptr_next_server_node == NULL)
				return;
		
			ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_server_node->info.server_descriptor;
			if (ptr_to_proxy_server_info->outgoing_physical_port == port_number &&
				ptr_to_proxy_server_info->protocol_type == IP_DATA_ICMP)
			{
				icmp_count++;
				ptr_to_proxy_server_info->proxy_idle_timer = 0 ;
				ptr_to_proxy_server_info->proxy_descriptor_link_idle_timeout = 0;
			}
			sptr_next_server_node = (PROXY_SERVER_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_server_node) ;
		}
/*		printf ("PR_INIT : Deleted %d icmp Descriptors for port %04x\n", icmp_count, port_number);*/
	}

	if ( sptr_linkctrl_root != NULL )
	{
		sptr_next_linkctrl_node = (PROXY_LINKCTRL_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_linkctrl_root) ;

		while (sptr_next_linkctrl_node != NULL)
		{
			client_connections = 0;
			if ( sptr_root != NULL )
			{
				sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_first_node ((RED_BLACK_NODE_HEADER far *)sptr_root) ;
				while (sptr_next_node != NULL)
				{
					ptr_to_proxy_server_info = (PROXY_SERVER_INFO *) sptr_next_node->info.client_descriptor;
					if (ptr_to_proxy_server_info->client_ip_address == sptr_next_linkctrl_node->key.source_ip_address)
						client_connections++;
					sptr_next_node = (PROXY_CLIENT_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_node) ;
				}
/* printf("\n\rPROXY : No. of connections for client %lX is %d",sptr_next_linkctrl_node->key.source_ip_address,
client_connections); */
				if ( client_connections == 0 )
				{
					client_count++;
/* printf("\n\rPR_INIT : client %lX to be deleted.",sptr_next_linkctrl_node->key.source_ip_address);*/
				   sptr_next_linkctrl_node->info.aging_timeout = 0; 
				}
			}
			else
			{
				client_count++;
/* printf("\n\rPR_INIT : client %lX to be deleted.",sptr_next_linkctrl_node->key.source_ip_address);*/
				sptr_next_linkctrl_node->info.aging_timeout = 0;
			}
			sptr_next_linkctrl_node = (PROXY_LINKCTRL_DESCRIPTOR_NODE far *) RB_get_next_node ((RED_BLACK_NODE_HEADER far *)sptr_next_linkctrl_node) ;
		}
/* printf("\n\rPR_INIT : %d no. of clients are deleted.",client_count);*/
	}			

	process_nat_descriptor_table ();
}


