/************************************************************************/
/*
Changes History : 
	{ sudha 12-Nov-1999. Added 2 new USHORT vars in PROXY_FORBIDDEN_DOMAIN_ADDRESS
		struct & 1 new USHORT var in PROXY_SERVER_CLASS struct }
*/
/************************************************************************/

#ifndef __VPROXY_
#define __VPROXY_


typedef struct PROXY_DYNAMIC_APP_LIST
{
	struct PROXY_DYNAMIC_APP_LIST *sptr_forward_link;
	USHORT application_port;
} PROXY_DYNAMIC_APP_LIST;

/* Sudha taken from Ravi 01 Feb 1999 ... */
/* Imran, for port range addition */
typedef struct PROXY_APP_PORT_RANGE_LIST
{
	USHORT protocol;
	USHORT lower_port_number;
	USHORT higher_port_number;
} PROXY_APP_PORT_RANGE_LIST;
/* Imran, for port range addition */
/* ... Sudha taken from Ravi 01 Feb 1999 */

typedef struct PROXY_SERVER_INFO
{
#if 0
	struct PROXY_SERVER_INFO  *sptr_forward_link;
	struct PROXY_SERVER_INFO  *sptr_backward_link;
#endif

	struct PROXY_SERVER_INFO  *ptr_to_ftp_data_descriptor;
	struct PROXY_SERVER_INFO  *ptr_to_ftp_command_descriptor;

/* sudhir for passive ftp comm */
	PROXY_DYNAMIC_APP_LIST *ptr_to_dynamic_application_list;  

	USHORT hit_count;          /* thiis is for future use */
	USHORT outgoing_physical_port;
	USHORT incoming_physical_port;

/* sudhir for strict port allocation */
	ULONG destination_address;
/* sudhir for strict port allocation */

	ULONG client_ip_address;
	ULONG outgoing_port_address;
	USHORT source_port;
	USHORT destination_port;
	USHORT mapped_port;
	USHORT pasv_port; /* sudha 30 March 1999 */
	USHORT physical_port_for_pasv_ftp_data_connection; /* sudha 24 May 1999 */
	USHORT proxy_idle_timer;
	USHORT protocol_type;
	
	int seq_offset;
	USHORT icmp_packet_id;
	USHORT mapped_icmp_packet_id;
	BYTE ftp_port_command_on;

	BYTE tftp_packet_detected;

	BYTE in_use;
	BYTE connection_closing;

	USHORT proxy_descriptor_link_idle_timeout;

} PROXY_SERVER_INFO;

typedef struct PROXY_SERVER_PORT_CLASS
{
	BYTE_ENUM (BOOLEAN)       proxy_server_enabled;
	USHORT                    recorded_tx_buffer_size;
	USHORT                    throughput_index;
	USHORT                    number_of_connections;
	USHORT                    number_of_bytes_txed;
	USHORT                    number_of_bytes_rxed;
	USHORT                    number_of_packets_txed;
	USHORT                    number_of_packets_rxed;
	enum WAN_THROUGHPUT_STATS tp_status;
/* Sachin, 3rd Oct. 1997 */
   BYTE_ENUM (BOOLEAN) port_down_by_no_demand ;
   BYTE_ENUM (BOOLEAN) port_opened ;
/* Sachin, 3rd Oct. 1997 */

	BYTE start_monitoring_port_traffic;
	USHORT port_monitoring_timer;
	
	BYTE  host_threshold_level_reached;
	USHORT  host_threshold_monitoring_timer;

	USHORT maximum_number_of_hosts_to_dial;
	USHORT maximum_number_of_connections_to_dial;

	BYTE  do_not_allocate_this_port;
	BYTE  client_disconnected;
}PROXY_SERVER_PORT_CLASS;

typedef struct PROXY_APPLICATION_TABLE
{	
	USHORT protocol_type;
	USHORT protocol_port;
	BYTE same_port_required;

}PROXY_APPLICATION_TABLE;


typedef struct PROXY_NAT_ADDRESS_LIST {
	ULONG local_address;
	ULONG global_address;
} PROXY_NAT_ADDRESS_LIST;

/* sudha 07 April 1999 for nat pasv ftp applications */

typedef struct PROXY_DYNAMIC_NAT_APP_LIST {
	struct PROXY_DYNAMIC_NAT_APP_LIST *sptr_forward_link;
	ULONG dynamic_server_ip_address;          /* dynamic in the sense of ip address sharing */
	USHORT ip_protocol_type;
	USHORT application_port;
} PROXY_DYNAMIC_NAT_APP_LIST;

typedef struct PROXY_DYNAMIC_SERVER_LIST {
	ULONG dynamic_server_ip_address;          /* dynamic in the sense of ip address sharing */
	USHORT ip_protocol_type;
	USHORT application_port;
} PROXY_DYNAMIC_SERVER_LIST;



typedef struct PROXY_INTERNET_SERVER_DESCRIPTOR
{
	struct PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_forward_link;
	struct PROXY_INTERNET_SERVER_DESCRIPTOR *sptr_backward_link;

	USHORT destination_port;
	USHORT source_port;
	USHORT rx_port_number;
	USHORT protocol;
	ULONG destination_address;
	ULONG source_address;
	ULONG local_mapped_address;

	BYTE ftp_pasv_mode_on; /* sudha 03 April 1999... */
	BYTE connection_closing;
	
	struct PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_ftp_data_descriptor;
	struct PROXY_INTERNET_SERVER_DESCRIPTOR *ptr_to_ftp_command_descriptor;

	USHORT pasv_port; /* ...sudha 06 April 1999. */

	int seq_offset;
	USHORT idle_timer;
}PROXY_INTERNET_SERVER_DESCRIPTOR;


typedef struct PROXY_FORBIDDEN_SITE_LIST 
{
	ULONG  destination_ip_address;
}PROXY_FORBIDDEN_SITE_LIST;

typedef struct PROXY_FORBIDDEN_DOMAIN_ADDRESS
{
	ULONG *destination_ip_address;
	BYTE domain_name[255];
	USHORT count;
/* sudha 12-Nov-1999... */
	USHORT dns_query_response_status;
	USHORT dns_retry_count;
/* ...sudha 12-Nov-1999 */
}PROXY_FORBIDDEN_DOMAIN_ADDRESS;

typedef struct PROXY_RESTRICTED_CLIENT_LIST 
{
	ULONG  source_ip_address;
}PROXY_RESTRICTED_CLIENT_LIST;

typedef struct PROXY_RESTRICTED_MAC_ADDRESS_LIST 
{
	BYTE mac_address[6];
}PROXY_RESTRICTED_MAC_ADDRESS_LIST ;


typedef struct PROXY_PRIVILEGED_USER_LIST
{
	ULONG host_ip_address;
	USHORT reserved_port;
}PROXY_PRIVILEGED_USER_LIST;

typedef struct PROXY_SERVER_CLASS
{
	BYTE_ENUM (BOOLEAN)      proxy_server_enabled;
	BYTE_ENUM (BOOLEAN)      proxy_any_application_enabled;

	USHORT dynamic_port_number;
	USHORT reserved_port_number_value;
	USHORT new_icmp_packet_id;
#if 0
	USHORT                   number_of_tcp_proxy_applications;
	USHORT                   number_of_udp_proxy_applications;
#endif
	USHORT 						 number_of_proxied_clients;
	USHORT 						 peak_concurrent_descriptor_count ;
	PROXY_SERVER_PORT_CLASS  port[NUMBER_OF_IP_PORTS];
	USHORT 						 proxy_server_idle_timeout;
	USHORT 						 proxy_server_table_size;
	USHORT 						 proxy_server_idle_entry_cache_size;
	ULONG 						 application_id;
	USHORT 						 max_number_of_applications;
	USHORT 						 max_number_of_user_defined_applications; /* Sudha from Ravi */
	USHORT 						 number_of_applications;
	USHORT 						 number_of_user_defined_applications; /* Sudha from Ravi */
	USHORT 						 maximum_number_of_descriptors;
	BYTE_ENUM (BOOLEAN)      proxy_server_printf_enabled;
	PROXY_SERVER_INFO 		 proxy_server_info_list;
	PROXY_APPLICATION_TABLE *sptr_application_list ;
	PROXY_DYNAMIC_APP_LIST  *proxy_server_dynamic_application_list;

/* sudha for nat pasv ftp thru dynamic mapping.05 April 1999 */	
	PROXY_DYNAMIC_NAT_APP_LIST *dynamic_nat_application_list;

/* Sudha taken from Ravi on 01 Feb 1999 ... */
/* Imran,for port range addition */
	PROXY_APP_PORT_RANGE_LIST *proxy_server_application_port_range_list;
/* ... Sudha taken from Ravi on 01 Feb 1999 */

/* sudha 12 Aug 1999.For configurable FTP ctrl & data ports */
	USHORT ftp_ctrl_conn_port;
	USHORT ftp_data_conn_port;

	USHORT number_of_global_address;
	USHORT total_number_of_global_address;
	PROXY_NAT_ADDRESS_LIST *global_address_list;
	
	ULONG proxy_local_internet_server_address;	
	USHORT number_of_dynamic_servers;  /* dynamic in the sense of using single ip address */
	USHORT total_number_of_dynamic_servers;   /* this is count of local servers
															which uses single ip address */
	PROXY_DYNAMIC_SERVER_LIST *dynamic_internet_server_list;

	PROXY_INTERNET_SERVER_DESCRIPTOR proxy_internet_server_list;

	USHORT number_of_forbidden_sites;
	USHORT max_number_of_forbidden_sites;
	PROXY_FORBIDDEN_SITE_LIST *ptr_to_forbidden_list;

	USHORT number_of_restricted_clients;
	USHORT max_number_of_restricted_clients;
	PROXY_RESTRICTED_CLIENT_LIST *ptr_to_restricted_client_list;
	
	USHORT number_of_restricted_applications;
	USHORT max_number_of_restricted_applications;
	PROXY_APPLICATION_TABLE *sptr_restricted_application_list;
	
	USHORT number_of_restricted_MAC_address;
	USHORT max_number_of_restricted_MAC_address;
 	PROXY_RESTRICTED_MAC_ADDRESS_LIST *ptr_to_restricted_MAC_address_list;

	USHORT number_of_restricted_domain_address;
	USHORT max_number_of_restricted_domain_address;
	USHORT number_of_address_resolved;
	PROXY_FORBIDDEN_DOMAIN_ADDRESS *ptr_to_restricted_domain_address;

/* for link control */
	USHORT number_of_active_hosts_to_trigger_port2;
	USHORT number_of_active_hosts_to_trigger_port3;
	
	USHORT number_of_descriptors_to_trigger_port2;
	USHORT number_of_descriptors_to_trigger_port3;

	USHORT total_number_of_pseudo_connections;

	USHORT proxy_number_of_active_hosts;

	USHORT max_number_of_privileged_users;
	USHORT number_of_privileged_users;
	PROXY_PRIVILEGED_USER_LIST *ptr_to_privileged_user_list;

	USHORT minimum_hosts_required_for_port2;
	USHORT minimum_connections_required_for_port2;

	USHORT minimum_hosts_required_for_port3;
	USHORT minimum_connections_required_for_port3;

	BYTE	start_resolving_dns_filters;

	USHORT  dns_resolver_state;
	USHORT last_allocated_port;
/* sudha 12-Nov-1999... */
	USHORT actual_number_of_address_resolved;
/* ...sudha 12-Nov-1999 */
	
	
}PROXY_SERVER_CLASS;

/* sudhir for ftp passive command handling */


typedef struct TCP_CHANGED_VARIABLES
{
	ULONG source_ip_address;
	ULONG destination_ip_address;
	USHORT source_port_number;
	USHORT destination_port_number;
	int tcp_seq_number;
	int tcp_ack_number; 
}TCP_CHANGED_VARIABLES;


#endif



