/*	$Modname: ksnmp.h$  $version: 1.13$		$date: 06/27/95$	 */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 04/28/94 keyur
1.3 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.4 05/18/94 keyur Removed a bug for memcpy overrun in snmputil.c
1.5 05/26/94 keyur
1.6 05/28/94 keyur adding enumerations
1.7 06/01/94 ross
1.8 06/02/94 ross more general clean-up.
1.9 06/03/94 ross adding protocol and driver traps.
1.10 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.11 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.12 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
1.13 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#define MAXIMUM_NUMBER_OF_SNMP_PORTS		16
#define SNMP_PORT									161
#define SNMP_TRAP_PORT							162
#define SNMP_MAX_LEN								484
#define SNMP_VERSION_1							0
/* Srikar, Mar 18, 1997. number of communities to 6. */
#define NUMBER_OF_SNMP_COMMUNITIES 			6
#define NO_PORT_NEEDED							0xffff
#define MIB_TABLE_ENTRY 0xff
#define MAXIMUM_LENGTH_OF_MIB_NAME 50

#define MIB 1, 3, 6, 1, 2, 1
#define PPPMIB 1, 3, 6, 1, 2
#define PRIVATE_MIB 1, 3, 6, 1, 4, 1

#define SESSION_ID_MAXIMUM_LENGTH		64

#ifdef __MSDOS__
	#define MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID		20	/* number of subid's in a object_id */
#else
	#define MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID		84	/* number of subid's in a object_id */
#endif

#define MAXIMUM_NUMBER_OF_BYTES_FOR_TABLE_INDICES		84

#define VARIABLE_NUMBER_OF_BYTES 1
#define MAXIMUM_SIZE_OF_MIB_VARIABLE 256
/* Srikar, Apr 11, 1997. Changed the MAX_SUBID from 0xff to 0xffffffff */
#define MAX_SUBID	 0xffffffff

enum VARIABLE_ACCESS_RIGHTS
{
	WRITE,
	READ
};

#define INTERNET_ADDRESS_ANY				(ULONG)0x00000000L

#define READ_ONLY			BIG_ENDIAN_CONSTANT (0xAAAA)

#ifdef BIG_ENDIAN
/* Srikar, Mar 18, 1997. changed read-write constant from 0xaaba to 0xaeba. */
	#define READ_WRITE 0xAEBA
#else
	#define READ_WRITE 0xAAAB
#endif

#define ASN_LONG_LEN			0x80
#define ASN_EXTENSION_ID	0x1F
#define ASN_BIT8				0x80

#define INTEGER			ASN_INTEGER
#define STRING				ASN_OCTET_STRING

enum ASN_TYPES
{
	ASN_BOOLEAN = 0x01,
	ASN_INTEGER	= 0x02,
	ASN_BIT_STRING	= 0x03,
	ASN_OCTET_STRING = 0x04,
	ASN_NULL = 0x05,
	ASN_OBJECT_ID = 0x06,
	ASN_SEQUENCE = 0x10,
	ASN_SET = 0x11,

	ASN_UNIVERSAL = 0x00,

	ASN_APPLICATION = 0x40,

	IP_ADDRESS = (ASN_APPLICATION | 0),
	COUNTER = (ASN_APPLICATION | 1),
	GAUGE = (ASN_APPLICATION | 2),
	TIMETICKS =	(ASN_APPLICATION | 3),
	OPAQUE =	(ASN_APPLICATION | 4),
	PHYSICAL_ADDRESS = (ASN_APPLICATION | 5),

	ASN_CONTEXT = 0x80,
	ASN_PRIVATE = 0xC0,

	ASN_PRIMITIVE = 0x00,
	ASN_CONSTRUCTOR = 0x20
};

enum SNMP_PDU_TYPE
{
	GET_REQUEST_MESSAGE = 0xa0,										/* (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x0), */
	GET_NEXT_REQUEST_MESSAGE =	0xa1, 								/* (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x1), */
	GET_RESPONSE_MESSAGE = 0xa2, 										/* (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x2), */
	SET_REQUEST_MESSAGE = 0xa3, 										/* (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x3), */
	TRAP_REQUEST_MESSAGE = 0xa4 										/* (ASN_CONTEXT | ASN_CONSTRUCTOR | 0x4)	*/
};


enum SNMP_STATE
{
	SNMP_OK = 0x00,
	SNMP_ERROR_TOO_BIG = 0x01,
	SNMP_ERROR_NO_SUCH_NAME = 0x02,
	SNMP_ERROR_BAD_VALUE = 0x03,
	SNMP_ERROR_READ_ONLY = 0x04,
	SNMP_ERROR_GENERAL_ERROR = 0x05,
 	SNMP_PARSE_ERROR = 0x0b,
	SNMP_BUILD_ERROR = 0x0c
};

enum SNMP_TRAP_TYPES
{
	SNMP_TRAP_COLD_START					= 0x00,
	SNMP_TRAP_WARM_START					= 0x01,
	SNMP_TRAP_LINK_DOWN		  			= 0x02,
	SNMP_TRAP_LINK_UP						= 0x03,
	SNMP_TRAP_AUTHENTICATION_FAILURE	= 0x04,
	SNMP_TRAP_EGP_NEIGHBOR_LOSS		= 0x05,
	SNMP_TRAP_ENTERPRISE_SPECIFIC		= 0x06
};

enum SNMP_PRINTF_GROUPS
{
	SNMP_INIT_PRINTF,
	SNMP_SOCKET_PRINTF,
	SNMP_PARSE_PRINTF,
	SNMP_TX_PRINTF,
	SNMP_RX_PRINTF,
	SNMP_MIB_PRINTF,
	SNMP_MEMORY_PRINTF,
	SNMP_ALARM_PRINTF,
	SNMP_DATA_PRINTF
};

enum SNMP_ALARM_TYPE
{
	SNMP_RX_PACKET_TOO_SHORT, 
	SNMP_RX_PACKET_TOO_LONG 
};

