#include	"defs.h"
/*	$Modname: snmpasnb.c$  $version: 1.7$		$date: 01/26/95$	 */
/*
* 	$lgb$
1.0 05/28/94 ross new file.
1.1 05/28/94 ross
1.2 06/01/94 ross
1.3 06/02/94 ross more general clean-up.
1.4 06/03/94 ross adding protocol and driver traps.
1.5 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.6 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.7 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "snmp.h"
/**********************************************************************************/
/*
 * asn_build_integer - builds an ASN object containing an integer.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 following the end of this object.
 *
 *	Returns a pointer to the first byte past the end
 *	 of this object (i.e. the start of the next object).
 *	Returns NULL on any error.
 */
BYTE *asn_build_integer (BYTE *bptr_response_packet, USHORT *usptr_length_of_data,
	enum ASN_TYPES asn_type, ULONG *ulptr_integer, USHORT size_of_integer, BYTE flag)
{
	/*
	 * ASN.1 integer ::= 0x02 asnlength byte {byte}*
 	 */

	ULONG integer;
	ULONG mask;

	if (size_of_integer != sizeof (ULONG))
		{
		return (NULL);
		}

	integer = *ulptr_integer;

	/*
	 * Truncate "unnecessary" bytes off of the most significant end of this 2's complement integer.
	 * There should be no sequence of 9 consecutive 1's or 0's at the most significant end of the
	 * integer.
	 */

	mask = 0x1ff << ((8 * (sizeof (ULONG) - 1)) - 1);

	if (flag == 0x00)
		{
		/* mask is 0xff800000 on a big-endian machine */

		while ((((integer & mask) == 0) || ((integer & mask) == mask)) && (size_of_integer > 1))
			{
			--size_of_integer;

			integer <<= 8;
			}
		}

	bptr_response_packet = asn_build_header (bptr_response_packet, usptr_length_of_data, asn_type, size_of_integer);

	if (bptr_response_packet == NULL)
		{
		return (NULL);
		}

	if (*usptr_length_of_data < size_of_integer)
		{
		return (NULL);
		}

	*usptr_length_of_data -= size_of_integer;

	if (flag == 0x00)
		{
		mask = 0xff << (8 * (sizeof (ULONG) - 1));

		/* mask is 0xff000000 on a big-endian machine */

		while (size_of_integer--)
			{
			*bptr_response_packet = (BYTE) ((integer & mask) >> (8 * (sizeof (ULONG) - 1)));

			++bptr_response_packet;

			integer <<= 8;
			}
		}
	else
		{
		memcpy (bptr_response_packet, ulptr_integer, sizeof (ULONG));

		bptr_response_packet = (BYTE *) ((ULONG) bptr_response_packet + sizeof (ULONG));
		}

	return (bptr_response_packet);
}
/**********************************************************************************/
/*
 * asn_build_string - Builds an ASN octet string object containing the input string.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 following the beginning of the next object.
 *
 *	Returns a pointer to the first byte past the end
 *	 of this object (i.e. the start of the next object).
 *	Returns NULL on any error.
 */
BYTE *asn_build_string (BYTE *bptr_response_packet, USHORT *usptr_length_of_data,
	enum ASN_TYPES asn_type, char *cptr_string_to_be_built, USHORT length_of_string)
{
	/*
 	 * ASN.1 octet string ::= primstring | cmpdstring
 	 * primstring ::= 0x04 asnlength byte {byte}*
 	 * cmpdstring ::= 0x24 asnlength string {string}*
 	 * This code will never send a compound string.
 	 */

	BYTE	*bptr_next_data_in_response_packet;

	bptr_response_packet = asn_build_header (bptr_response_packet, usptr_length_of_data, asn_type, length_of_string);

	if (bptr_response_packet == NULL)
		{
		return (NULL);
		}

	if (*usptr_length_of_data < length_of_string)
		{
		return (NULL);
		}

	memcpy ((BYTE *) bptr_response_packet, (BYTE *) cptr_string_to_be_built, length_of_string);

	*usptr_length_of_data -= length_of_string;

	bptr_next_data_in_response_packet = (BYTE *) ((ULONG) bptr_response_packet + length_of_string);

	return (bptr_next_data_in_response_packet);
}
/**********************************************************************************/
/*
 * asn_build_header - builds an ASN header for an object with the ID and
 * length specified.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 in this object following the id and length.
 *
 *	This only works on data types < 30, i.e. no extension octets.
 *	The maximum length is 0xffff;
 *
 *	Returns a pointer to the first byte of the contents of this object.
 *	Returns NULL on any error.
 */
BYTE *asn_build_header (BYTE *bptr_response_packet, USHORT *usptr_length_of_data, enum ASN_TYPES asn_type, USHORT length)
{
	BYTE	*bptr_next_data_in_response_packet;

	if (*usptr_length_of_data < 0x0001)
		{
		return (NULL);
		}

	*bptr_response_packet = asn_type;

	++bptr_response_packet;

	--(*usptr_length_of_data);

	bptr_next_data_in_response_packet = asn_build_length (bptr_response_packet, usptr_length_of_data, length);

	return (bptr_next_data_in_response_packet);
}
/**********************************************************************************/
BYTE *asn_build_length (BYTE *bptr_response_packet, USHORT *usptr_length_of_data, USHORT length)
{
	BYTE *bptr_start_data;

	bptr_start_data = bptr_response_packet;

	/* no indefinite lengths sent */

	if (length < 0x80)
		{
		*bptr_response_packet = (BYTE) length;

		++bptr_response_packet;
		} 
	else if (length <= 0xff)
		{
		*bptr_response_packet = (BYTE) (0x01 | ASN_LONG_LEN);

		++bptr_response_packet;

		*bptr_response_packet = (BYTE) length;

		++bptr_response_packet;
		} 
	else 
		{
		/* 0xff < length <= 0xffff */

		*bptr_response_packet = (BYTE) (0x02 | ASN_LONG_LEN);

		++bptr_response_packet;

		*bptr_response_packet = (BYTE) ((length >> 8) & 0xff);

		++bptr_response_packet;

		*bptr_response_packet = (BYTE) (length & 0xff);

		++bptr_response_packet;
		}

	if (*usptr_length_of_data < (USHORT) ((ULONG) bptr_response_packet - (ULONG) bptr_start_data))
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: build_length error occured\n");

		return (NULL);
		}

	*usptr_length_of_data = (USHORT) (*usptr_length_of_data - ((ULONG) bptr_response_packet - (ULONG) bptr_start_data));

	return (bptr_response_packet);
}
/**********************************************************************************/
/*
 * asn_build_object_id - Builds an ASN object identifier object containing the input string.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 following the beginning of the next object.
 *
 *	Returns a pointer to the first byte past the end
 *	 of this object (i.e. the start of the next object).
 *	Returns NULL on any error.
 */
BYTE *asn_build_object_id (BYTE *bptr_tx_packet, USHORT *usptr_length_of_data, enum ASN_TYPES asn_type,
	OBJECT_ID *sptr_object_id, USHORT length_of_object_id)
{
	/*
 	 * ASN.1 object_id ::= 0x06 asnlength subidentifier {subidentifier}*
 	 * subidentifier ::= {leadingbyte}* lastbyte
 	 * leadingbyte ::= 1 7bitvalue
  	 * lastbyte ::= 0 7bitvalue
 	 */

	USHORT asn_length;
	USHORT bits;
	USHORT testbits;
	/* Srikar, Mar 29, 1997. Changed the type of 'subidentifier' from ULONG to OBJECT_ID. */
	OBJECT_ID subidentifier;
	ULONG	mask;
	ULONG	test_mask;
	/* Srikar, Mar 29, 1997. Changed the size of the buffer required to store the encoded object ids */
	BYTE buffer[MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID * 5];
	BYTE *bptr_buffer;
	BYTE	*bptr_next_data_in_response_packet;
	OBJECT_ID object_buffer[MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID];
	OBJECT_ID *sptr_object;

	bptr_buffer = buffer;

 	sptr_object = object_buffer;

	/* Srikar, Mar 09, 1997. Added check for the condition where length_of_object_id is 0 */
	if (length_of_object_id > 0)
		{
		memcpy (object_buffer, sptr_object_id, (length_of_object_id * sizeof (OBJECT_ID)));

		/* transform size in bytes to size in subid's */
		/* encode the first two components into the first subidentifier */

		/* Srikar, Mar 29, 1997. Changed the type casting in the the following line */
		sptr_object[1] = (OBJECT_ID) (sptr_object[1] + (sptr_object[0] * 40));

		++sptr_object;

		--length_of_object_id;
		}

	while (length_of_object_id-- > 0x0000)
		{
		subidentifier = *sptr_object;

		++sptr_object;

		mask = 0x7F; /* handle subidentifier == 0 case */

		bits = 0x0000;

		/* test_mask *MUST* !!!! be of an unsigned type */

		test_mask = 0x0000007FL;

		testbits = 0x0000;

		while (test_mask != 0x00000000L)
			{
			if (subidentifier & test_mask)
				{
				/* if any bits set */

				mask = test_mask;

				bits = testbits;
				}

			test_mask <<= 7;

			testbits += (USHORT) 7;
			}

		/* mask can't be zero here */

		while (mask != 0x7F)
			{
			if (mask == 0x1E00000L)	/* fix a mask that got truncated above */
				{
				mask = 0xFE00000L;
				}

			*bptr_buffer = (BYTE) (((subidentifier & mask) >> bits) | ASN_BIT8);

			++bptr_buffer;

			mask >>= 7;

			bits -= (USHORT) 7;
			}

		*bptr_buffer = (BYTE) (subidentifier & mask);

		++bptr_buffer;
		}

	asn_length = (USHORT) (bptr_buffer - buffer);

	bptr_tx_packet = asn_build_header (bptr_tx_packet, usptr_length_of_data, asn_type, asn_length);

	if (bptr_tx_packet == NULL)
		{
		return (NULL);
		}

	if (*usptr_length_of_data < (USHORT) asn_length)
		{
		return (NULL);
		}

	memcpy (bptr_tx_packet, buffer, (USHORT) asn_length);

	*usptr_length_of_data -= (USHORT) asn_length;

 	bptr_next_data_in_response_packet = (BYTE *) ((ULONG) bptr_tx_packet + asn_length);

	return (bptr_next_data_in_response_packet);
}
/**********************************************************************************/
/*
 * asn_build_null - Builds an ASN null object.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 following the beginning of the next object.
 *
 *	Returns a pointer to the first byte past the end
 *	 of this object (i.e. the start of the next object).
 *	Returns NULL on any error.
 */
BYTE *asn_build_null (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES asn_type)
{
	/*
 	 * ASN.1 null ::= 0x05 0x00
 	 */

	BYTE *bptr_next_data_in_response_packet;

	bptr_next_data_in_response_packet =
		asn_build_header (bptr_rxed_packet, usptr_length_of_data, asn_type, 0x0000);

	return (bptr_next_data_in_response_packet);
}
/**********************************************************************************/
BYTE *build_a_variable_binding (BYTE *bptr_response_packet, USHORT *usptr_length_of_packet, OBJECT_ID *sptr_object_id,
	USHORT length_of_object_id, enum ASN_TYPES type, USHORT length_of_variable_value, BYTE *bptr_variable_value)
{
	USHORT dummy_length;
	USHORT header_length;
	USHORT header_shift;
	BYTE *bptr_data;
	enum ASN_TYPES asn_type;

	dummy_length = *usptr_length_of_packet;

	bptr_data = bptr_response_packet;

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR);

	bptr_response_packet = asn_build_header (bptr_response_packet, &dummy_length, asn_type, 0x0000);

	if (bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: NULL error in building header\n");

		return (NULL);
		}

	header_length = (USHORT) (bptr_response_packet - bptr_data);

	*usptr_length_of_packet -= header_length;

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_OBJECT_ID);

	bptr_response_packet = asn_build_object_id (bptr_response_packet, usptr_length_of_packet, asn_type, sptr_object_id,
		length_of_object_id);

	if (bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: NULL error in building object id\n");

		return (NULL);
		}

	switch (type)
		{
		case ASN_INTEGER:
		case GAUGE:
		case COUNTER:
		case TIMETICKS:

			bptr_response_packet = asn_build_integer (bptr_response_packet, usptr_length_of_packet, type,
				(ULONG *) bptr_variable_value, length_of_variable_value, 0x01);

			break;

		case ASN_OCTET_STRING:
		case IP_ADDRESS:
		case OPAQUE:

			bptr_response_packet = asn_build_string (bptr_response_packet, usptr_length_of_packet,
				type, (char *) bptr_variable_value, length_of_variable_value);

			break;

		case ASN_OBJECT_ID:

			bptr_response_packet = asn_build_object_id (bptr_response_packet, usptr_length_of_packet, type,
				(OBJECT_ID *) bptr_variable_value, (USHORT) (length_of_variable_value/sizeof (OBJECT_ID)));

			break;

		case ASN_NULL:

			bptr_response_packet = asn_build_null (bptr_response_packet, usptr_length_of_packet, type);

			break;

		default:

			snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Wrong type \r\n");

			return (NULL);
		}

  	if (bptr_response_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: NULL error in building \r\n");

		return (NULL);
		}

	dummy_length = (USHORT) ((ULONG) (bptr_response_packet - bptr_data) - header_length);

	header_shift = 0x0000;

	if (dummy_length >= 0x80)
		{
		++header_shift;

		if (dummy_length > 0xff)
			{
			++header_shift;
			}
		}

	if (header_shift != 0x0000)
		{
		/* should check next length here */

		shift_array (bptr_data + header_length, dummy_length, (short) header_shift);

		bptr_response_packet = (BYTE *) ((ULONG) bptr_response_packet + header_shift);
		}

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR);

	if (asn_build_header (bptr_data, &dummy_length, asn_type, dummy_length) == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: NULL error in building header\n");

		return (NULL);
		}

	return (bptr_response_packet);
}

