#include	"defs.h"
/*	$Modname: snmpasnp.c$  $version: 1.12$		$date: 06/27/95$	 */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 04/28/94 keyur
1.3 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.4 05/18/94 keyur Removed a bug for memcpy overrun in snmputil.c
1.5 05/26/94 keyur
1.6 05/28/94 keyur adding enumerations.
1.7 06/01/94 ross
1.8 06/02/94 ross more general clean-up.
1.9 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.10 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.11 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
1.12 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
/*
 * Abstract Syntax Notation One, ASN.1
 * As defined in ISO/IS 8824 and ISO/IS 8825
 * This implements a subset of the above International Standards that
 * is sufficient to implement SNMP.
 *
 * Encodes abstract data types into a machine independent stream of bytes.
 *
 */
#include <string.h>
#include "snmp.h"
/**********************************************************************************/
/*
 * asn_parse_integer - pulls a long out of an ASN int type.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 following the end of this object.
 *
 *	Returns a pointer to the first byte past the end
 *	 of this object (i.e. the start of the next object).
 *	Returns NULL on any error.
 */
BYTE *asn_parse_integer (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES *eptr_asn_type,
	ULONG *ulptr_integer, USHORT size_of_integer, BYTE flag)
{
/*	ASN.1 integer ::= 0x02 asnlength byte {byte} */

	ULONG	asn_length;
	int value;
	BYTE *bptr_buffer;

	bptr_buffer = bptr_rxed_packet;

	value = 0x00000000L;

	if (size_of_integer != sizeof (ULONG))
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: not long variable\r\n");

		return (NULL);
		}

	*eptr_asn_type = (enum ASN_TYPES) *bptr_buffer;

	++bptr_buffer;

	bptr_buffer = asn_parse_length (bptr_buffer, &asn_length);

	if (bptr_buffer == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Bad length field found\r\n");

		return (NULL);
		}

	if ((USHORT) (asn_length + (ULONG) (bptr_buffer - bptr_rxed_packet)) > *usptr_length_of_data)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Overflow of message\r\n");

		return (NULL);
		}

	if ((USHORT) asn_length > size_of_integer)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Such large integers are not supported\r\n");

		return (NULL);
		}

	/*
	*usptr_length_of_data = (USHORT) (*usptr_length_of_data - asn_length + (ULONG) (bptr_buffer - bptr_rxed_packet));
	*/

		*usptr_length_of_data = (USHORT) (*usptr_length_of_data - asn_length - (ULONG) (bptr_buffer - bptr_rxed_packet));

	if (*bptr_buffer & 0x80)
		{
		value = -1; /* integer is negative */
		}

	if (flag == 0x00)
		{
		while (asn_length--)
			{
			value = (int) (((ULONG) value << 8) | *bptr_buffer);

			++bptr_buffer;
			}

		*ulptr_integer = (ULONG) value;
		}
	else
		{
		memcpy (ulptr_integer, bptr_buffer, sizeof (ULONG));

		bptr_buffer = (BYTE *) ((ULONG) bptr_buffer + sizeof (ULONG));
		}

	return (bptr_buffer);
}
/**********************************************************************************/
/*
 * asn_parse_string - pulls an octet string out of an ASN octet string type.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 following the beginning of the next object.
 *
 *	"string" is filled with the octet string.
 *
 *	Returns a pointer to the first byte past the end
 *	 of this object (i.e. the start of the next object).
 *	Returns NULL on any error.
 */
BYTE *asn_parse_string (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES *eptr_asn_type,
	char *cptr_string_to_be_parsed, USHORT *usptr_length_of_string)
{
/*
 * ASN.1 octet string ::= primstring | cmpdstring
 * primstring ::= 0x04 asnlength byte {byte}*
 * cmpdstring ::= 0x24 asnlength string {string}*
 * This doesn't yet support the compound string.
 */
	BYTE *bptr_buffer;
	ULONG	asn_length;
	BYTE	*bptr_next_data_in_rx_packet;

	bptr_buffer = bptr_rxed_packet;

	*eptr_asn_type = (enum ASN_TYPES) *bptr_buffer;

	++bptr_buffer;

	bptr_buffer = asn_parse_length (bptr_buffer, &asn_length);

	if (bptr_buffer == NULL)
		{
		return (NULL);
		}

	if ((USHORT) (asn_length + (ULONG) (bptr_buffer - bptr_rxed_packet)) > *usptr_length_of_data)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Overflow of message \r\n");

		return (NULL);
		}

	if ((USHORT) asn_length > *usptr_length_of_string)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Such long strings are not supported\n");

		return (NULL);
		}

	memcpy ((BYTE *) cptr_string_to_be_parsed, (BYTE *) bptr_buffer, (USHORT) asn_length);
	cptr_string_to_be_parsed[asn_length] = '\0';
	*usptr_length_of_string = (USHORT) asn_length;
	*usptr_length_of_data -= (USHORT) (asn_length + (ULONG) (bptr_buffer - bptr_rxed_packet));

	bptr_next_data_in_rx_packet = (BYTE *) ((ULONG) bptr_buffer + asn_length);

	return (bptr_next_data_in_rx_packet);
}
/**********************************************************************************/
/*
 * asn_parse_header - interprets the ID and length of the current object.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 in this object following the id and length.
 *
 *	Returns a pointer to the first byte of the contents of this object.
 *	Returns NULL on any error.
 */
BYTE *asn_parse_header (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, UNION_SNMP_TYPES *eptr_type)
{
	ULONG	header_length;
	ULONG	asn_length;
	BYTE *bptr_buffer;

 	bptr_buffer = bptr_rxed_packet;

	/* this only works on data types < 30, i.e. no extension octets */

	if (((*bptr_buffer) & ASN_EXTENSION_ID) == ASN_EXTENSION_ID)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Can't process ID \r\n");

		return (NULL);
		}

/*	eptr_type->data = (enum ASN_TYPES) *bptr_buffer;*/
	*((enum ASN_TYPES *)eptr_type) = (enum ASN_TYPES) 0;
	*((enum ASN_TYPES *)eptr_type) = (enum ASN_TYPES) *bptr_buffer;

	bptr_buffer = asn_parse_length (bptr_buffer + 1, &asn_length);

	if (bptr_buffer == NULL)
		{
		return (NULL);
		}

	header_length = (ULONG) (bptr_buffer - bptr_rxed_packet);

	if ((USHORT) (header_length + asn_length) > *usptr_length_of_data)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: asn length too long \r\n");

		return (NULL);
		}

	*usptr_length_of_data = (USHORT) asn_length;

	return (bptr_buffer);
}
/**********************************************************************************/
/*
 * asn_parse_length - interprets the length of the current object.
 *	On exit, length contains the value of this length field.
 *
 *	Returns a pointer to the first byte after this length
 *	field (aka: the start of the data field).
 *	Returns NULL on any error.
 */
BYTE *asn_parse_length (BYTE *bptr_rxed_packet, ULONG *ulptr_length)
{
	BYTE length_byte;
	BYTE *bptr_return_value;

  	length_byte = *bptr_rxed_packet;

	if (length_byte & ASN_LONG_LEN)
		{
		length_byte = length_byte & (BYTE) ~ASN_LONG_LEN;	/* turn MSb off */

		if (length_byte == 0x00)
			{
			snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Indefinite lengths are not supported\n");

			return (NULL);
			}

		if (length_byte > sizeof (ULONG))
			{
			snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Data length that is too long is not supported\n");

			return (NULL);
			}

		memcpy ((BYTE *) ulptr_length, (BYTE *) bptr_rxed_packet + 1, (USHORT) length_byte);

		*ulptr_length = net_to_host_long (*ulptr_length);

		*ulptr_length >>= (8 * ((sizeof (*ulptr_length)) - length_byte));

		bptr_return_value = (BYTE *) ((ULONG) bptr_rxed_packet + length_byte + 1);

		return (bptr_return_value);
		} 
	else 
		{
		/* short asnlength */

		*ulptr_length = (ULONG) length_byte;

		bptr_return_value = (BYTE *) ((ULONG) bptr_rxed_packet + 1);

		return (bptr_return_value);
		}
}
/**********************************************************************************/
/*
 * asn_parse_object_id - pulls an object indentifier out of an ASN object identifier type.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 following the beginning of the next object.
 *
 *	"object_id" is filled with the object identifier.
 *
 *	Returns a pointer to the first byte past the end
 *	 of this object (i.e. the start of the next object).
 *	Returns NULL on any error.
 */
/* Srikar, Mar 19, 1997. Changed the function 'asn_parse_object_id', to reflect the change of OBJECT_ID from */
/* BYTE to ULONG */
BYTE *asn_parse_object_id (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES *eptr_asn_type,
	OBJECT_ID *sptr_variable_object_id, USHORT *usptr_length_of_object_id)
{
	/*
 	 * ASN.1 object_id ::= 0x06 asnlength subidentifier {subidentifier}*
 	 * subidentifier ::= {leadingbyte}* lastbyte
 	 * leadingbyte ::= 1 7bitvalue
 	 * lastbyte ::= 0 7bitvalue
 	 */

	OBJECT_ID subidentifier;
	ULONG	asn_length;
	long length;
	BYTE *bptr_buffer;
	OBJECT_ID *sptr_object;

 	bptr_buffer = bptr_rxed_packet;

	sptr_object = sptr_variable_object_id + 1;

	*eptr_asn_type = (enum ASN_TYPES) *bptr_buffer;

	++bptr_buffer;

	/* this parses the length of the variable name */

	bptr_buffer = asn_parse_length (bptr_buffer, &asn_length);

	if (bptr_buffer == NULL)
		{
		return (NULL);
		}

	if ((USHORT) (asn_length + (ULONG) (bptr_buffer - bptr_rxed_packet)) > *usptr_length_of_data)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Overflow of message \r\n");

		return (NULL);
		}

	/*
	*usptr_length_of_data = (USHORT) (*usptr_length_of_data - asn_length + (ULONG) (bptr_buffer - bptr_rxed_packet));
	*/

	*usptr_length_of_data = (USHORT) (*usptr_length_of_data - asn_length - (ULONG) (bptr_buffer - bptr_rxed_packet));

	length = (long) asn_length;

	--(*usptr_length_of_object_id);		/* account for expansion of first byte */

	/* the first two subidentifiers i.e iso and org are encoded into one byte */

	while ((length > 0x00000000L) && ((*usptr_length_of_object_id)-- > 0x0000))
		{
		subidentifier = 0x00000000L;

		do 
			{
			/* shift and add in low order 7 bits */

			subidentifier = (subidentifier << 7) + (*bptr_buffer & ~ASN_BIT8);

			--length;
			}
		while (* bptr_buffer++ & ASN_BIT8);				/* last byte has high bit clear */

		if (subidentifier >  MAX_SUBID)
			{
			snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: subidentifier too long \r\n");

			return (NULL);
			}

		*sptr_object = subidentifier;

		++sptr_object;
		}

	/*
	 * The first two subidentifiers are encoded into the first component
	 * with the value (X * 40) + Y, where:
	 *	X is the value of the first subidentifier.
	 *	Y is the value of the second subidentifier.
	 */

	subidentifier = sptr_variable_object_id[1];

	sptr_variable_object_id[1] = subidentifier % 40;

	sptr_variable_object_id[0] = (subidentifier - sptr_variable_object_id[1]) / 40;

	*usptr_length_of_object_id = (USHORT) (sptr_object - sptr_variable_object_id);

	return (bptr_buffer);
}
/**********************************************************************************/
/*
 * asn_parse_null - Interprets an ASN null type.
 *	On entry, datalength is input as the number of valid bytes following
 *	 "data".  On exit, it is returned as the number of valid bytes
 *	 following the beginning of the next object.
 *
 *	Returns a pointer to the first byte past the end
 *	 of this object (i.e. the start of the next object).
 *	Returns NULL on any error.
 */
BYTE *asn_parse_null (BYTE *bptr_rxed_packet, USHORT *usptr_length_of_data, enum ASN_TYPES *eptr_asn_type)
{
	/*
 	* ASN.1 null ::= 0x05 0x00
 	*/

	BYTE *bptr_buffer;
	BYTE	*bptr_next_data_in_rx_packet;
	ULONG	asn_length;

  	bptr_buffer = bptr_rxed_packet;

	*eptr_asn_type = (enum ASN_TYPES) *bptr_buffer;

	++bptr_buffer;

	bptr_buffer = asn_parse_length (bptr_buffer, &asn_length);

	if (bptr_buffer == NULL)
		{
		return (NULL);
		}

	if (asn_length != 0x00000000L)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: malformed NULL\n");

		return (NULL);
		}

	*usptr_length_of_data = (USHORT) (*usptr_length_of_data - (USHORT) (bptr_buffer - bptr_rxed_packet));

	bptr_next_data_in_rx_packet =	(BYTE *) ((ULONG) bptr_buffer + asn_length);

	return (bptr_next_data_in_rx_packet);
}
