#include	"defs.h"
/*	$Modname: snmpmgr.c$  $version: 1.6$		 $date: 06/27/95$	  */
/*
* 	$lgb$
1.0 05/28/94 keyur adding enumerations.
1.1 06/03/94 ross adding protocol and driver traps.
1.2 06/20/94 ross
1.3 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.4 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.5 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
1.6 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include	<stddef.h>
#include	<stdlib.h>
#include	<string.h>
#include "snmp.h"
#include	<visnpstr.h>
#include "visnmp.h"
/**********************************************************************************/
MANAGER_CLASS *find_snmp_manager (ULONG internet_address)
{
	MANAGER_CLASS *sptr_manager;

	sptr_manager = (MANAGER_CLASS *) get_pointer_to_first_entry_in_list ((LINK *) &snmp.manager_list);

	while (sptr_manager != NULL)
		{
		if (internet_address == sptr_manager->internet_address)
			{
			return (sptr_manager);
			}

		sptr_manager = (MANAGER_CLASS *) get_pointer_to_next_entry_in_list ((LINK *) sptr_manager);
		}

	return (NULL);
}
/**********************************************************************************/
MANAGER_CLASS *add_snmp_manager (ULONG internet_address)
{
	MANAGER_CLASS *sptr_manager;

	sptr_manager = table_malloc (1, sizeof (MANAGER_CLASS));

	if (sptr_manager != NULL)
		{
		sptr_manager->internet_address = internet_address;

		add_entry_to_list ((LINK *) &snmp.manager_list, (LINK *) sptr_manager);
		}
	else
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP: add_snmp_manager (): table_malloc failed\n");
		}

	return (sptr_manager);
}
/**********************************************************************************/
enum TEST delete_snmp_manager (ULONG internet_address)
{
	MANAGER_CLASS *sptr_manager;

	sptr_manager = (MANAGER_CLASS *) get_pointer_to_first_entry_in_list ((LINK *) &snmp.manager_list);

	while (sptr_manager != NULL)
		{
		if (internet_address == sptr_manager->internet_address)
			{
			delete_entry_from_list ((LINK *) &snmp.manager_list, (LINK *) sptr_manager);

			snmp_free_receive_queue (sptr_manager);

			table_free ((void *) sptr_manager);

			return (PASS);
			}

		sptr_manager = (MANAGER_CLASS *) get_pointer_to_next_entry_in_list ((LINK *) sptr_manager);
		}

	return (FAIL);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
enum TEST get_snmp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_size_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	enum TEST return_code;

	return_code = process_mib_variable (mib_operation, cptr_mib_string, bptr_variable_value,
		usptr_size_of_variable_value, usptr_size_of_table_indices, sptr_table_indices, eptr_end_of_table,
		ptr_to_cptr_next_variable_name, &snmp_table[0x00]);

	return (return_code);
}

