#include	"defs.h"
/*	$Modname: snmpmib.c$	$version: 1.11$		$date: 01/26/95$	*/
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.3 05/18/94 keyur Removed a bug for memcpy overrun in snmputil.c
1.4 05/26/94 keyur
1.5 05/28/94 keyur adding enumerations.
1.6 06/01/94 ross
1.7 06/02/94 ross more general clean-up.
1.8 06/03/94 ross adding protocol and driver traps.
1.9 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.10 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.11 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <string.h>
#include "snmp.h"
#include "vsnmpmib.h"
/**********************************************************************************/
/*
 * get_mib_variable - return a pointer to the named variable, as well as it's
 * type, length, and access control list.
 *
 * If an exact match for the variable name exists, it is returned.  If not,
 * and exact is false, the next variable lexicographically after the
 * requested one is returned.
 *
 * If no appropriate variable can be found, NULL is returned.
 */
/* Srikar, Mar 19, 1997. Changed the type and name of the following parameters */
/* bptr_table_indices - sptr_table_indices(BYTE * - OBJECT_ID *) */
/* bptr_to_table_indices_in_variable_binding_name - sptr_to_table_indices_in_variable_binding_name */
/* (BYTE **  - OBJECT_ID **) */
/* Changed the parameter name from usptr_number_of_bytes_in_table_indices to usptr_number_of_table_indices */
VARIABLE	*get_mib_variable_and_table_indices (OBJECT_ID *sptr_object_id, USHORT *usptr_object_id_length,
	enum ASN_TYPES *eptr_type, USHORT *access_control_list, enum BOOLEAN exact, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, OBJECT_ID **sptr_to_table_indices_in_variable_binding_name)
{
	USHORT variable_count;
	USHORT minimum_length;
	int result;
	OBJECT_ID *sptr_object_id_1;
	OBJECT_ID *sptr_object_id_2;
	VARIABLE	*sptr_variable;

	sptr_variable = &variables[0];

	sptr_object_id_1 = sptr_object_id;

	result = 0x0000;

	minimum_length = 0x0000;

	for (variable_count = 0x0000; variable_count < snmp.number_of_variables; ++variable_count)
		{
		if (*usptr_object_id_length < (USHORT) sptr_variable->object_id_length)
			{
			minimum_length = *usptr_object_id_length;
			}
		else
			{
			minimum_length = (USHORT) sptr_variable->object_id_length;
			}

		sptr_object_id_1 = sptr_object_id;

		sptr_object_id_2 = sptr_variable->object_id;

		result = 0x0000;

		while (minimum_length > 0x0000)
			{
			if (*sptr_object_id_1 < *sptr_object_id_2)
				{
				result = -1;
				break;
				}

			if (*sptr_object_id_2 < *sptr_object_id_1)
				{
				result = 0x0001;
				break;
				}

			++sptr_object_id_2;

			++sptr_object_id_1;

			--minimum_length;
			}

		if (result == 0x0000)
			{
			if (*usptr_object_id_length < (USHORT) sptr_variable->object_id_length)
				{
				result = -2;						/* sptr_object_id_1 shorter so it is "less" */
				}
			else if ((USHORT) sptr_variable->object_id_length < *usptr_object_id_length)
				{
				result = 0x0001;
				}
			else
				{
				result = 0x0000;
				}
			}

/*		 	result = compare (sptr_object_id, *usptr_object_id_length, sptr_variable->mib_name, (int) sptr_variable->object_id_length);  */

		if ((result < 0x0000) || ((exact == TRUE) && (result == 0x0000)))
			{
			break;
			}

		++sptr_variable;
		}

	if (variable_count == snmp.number_of_variables)
		{
		return (NULL);
		}

	/* sptr_variable now points to the appropriate struct */

	*usptr_number_of_table_indices = 0x0000;

	/* save the pointer to table indices of variable binding name */

	/* Srikar, Mar 19, 1997. Removed the type casting of the variable sptr_object_id_1 to BYTE pointer */
	*sptr_to_table_indices_in_variable_binding_name = sptr_object_id_1;

	if ((sptr_variable->is_table_entry == TRUE) && (result == -1))
		{
		/* fetch the indices from the object id */

		while (minimum_length > 0x0000)
			{
			/* Srikar, Mar 19, 1997. Removed the type casting of the variable sptr_object_id_1 to BYTE pointer */
			*sptr_table_indices = *sptr_object_id_1;

			++sptr_table_indices;

			++sptr_object_id_1;

			++(*usptr_number_of_table_indices);

			--minimum_length;
			}
		}

	*eptr_type = sptr_variable->type;

	*access_control_list = sptr_variable->access_control_list;
	return (sptr_variable);
}
/**********************************************************************************/
VARIABLE	*get_mib_variable_using_name (char *cptr_mib_name)
{
	VARIABLE	*sptr_mib_variable;
	USHORT variable_count;

	sptr_mib_variable = variables;

	for (variable_count = 0x0000; variable_count < snmp.number_of_variables; ++variable_count)
			{
			if (strcmp (sptr_mib_variable->mib_name, cptr_mib_name) == STRINGS_MATCH)
				{
				return (sptr_mib_variable);
				}

			++sptr_mib_variable;
			}

		return (NULL);
}
/**********************************************************************************/
enum TEST is_it_a_good_value (BYTE in_type, USHORT in_length, BYTE actual_type, USHORT actual_length)
{
	/* Check type and value length are OK or not.  Then Call appropriate stack for validation of the value
	 * this step is extra and is implemented here for added security from setting absolutely garbage value
	 * for some parameter.
	 */

	PARAMETER_NOT_USED (in_type);
	PARAMETER_NOT_USED (in_length);
	PARAMETER_NOT_USED (actual_type);
	PARAMETER_NOT_USED (actual_length);

/*	PARAMETER_NOT_USED (actual_length);*/
/*printf("\r\n  in_type  %d \t in_length %d \r\n actual type %d \t actual_len %d",in_type,in_length,actual_type,actual_length);*/

	return (PASS);
}
/**********************************************************************************/
enum TEST set_the_variable_value (BYTE *bptr_new_variable_value, enum ASN_TYPES variable_value_type,
	BYTE *bptr_actual_variable_value, USHORT status_length)
{
	USHORT dummy_buffer_size;

	dummy_buffer_size = 1000; 							/* some arbitrarily large number */

	switch (variable_value_type)
		{
		case ASN_INTEGER:
		case COUNTER:
		case GAUGE:
		case TIMETICKS:

			asn_parse_integer (bptr_new_variable_value, &dummy_buffer_size, &variable_value_type,
				(ULONG *) bptr_actual_variable_value, status_length, 0x00);

			break;

		case ASN_OCTET_STRING:
		case IP_ADDRESS:
		case OPAQUE:

			asn_parse_string (bptr_new_variable_value, &dummy_buffer_size, &variable_value_type,
				(char *) bptr_actual_variable_value, &status_length);

			break;

		case ASN_OBJECT_ID:

			asn_parse_object_id (bptr_new_variable_value, &dummy_buffer_size, &variable_value_type,
				(OBJECT_ID *) bptr_actual_variable_value, &status_length);

			break;
		}

	/*	Call appropriate stack for actually setting the mib variable. */

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
enum TEST get_rfc1213_system_mibs (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_subids_in_table_indices);
	PARAMETER_NOT_USED (sptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (ptr_to_cptr_next_variable_name);

	return (PASS);
}
#ifdef __SNMP_STANDALONE__
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
enum TEST get_tcp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_table_indices);
	PARAMETER_NOT_USED (sptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (ptr_to_cptr_next_variable_name);

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
enum TEST get_source_routing_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char *cptr_next_variable_name);
{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_table_indices);
	PARAMETER_NOT_USED (sptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (cptr_next_variable_name);

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
enum TEST get_spanning_tree_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_table_indices,
	BYTE *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char *cptr_next_variable_name);
{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_bytes_in_table_indices);
	PARAMETER_NOT_USED (bptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (cptr_next_variable_name);

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
enum TEST get_ppp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char *cptr_next_variable_name);
{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_table_indices);
	PARAMETER_NOT_USED (sptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (cptr_next_variable_name);

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
extern enum TEST get_frame_relay_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char *cptr_next_variable_name);
{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_table_indices);
	PARAMETER_NOT_USED (sptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (cptr_next_variable_name);

	return (PASS);
}
/**********************************************************************************/
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
extern enum TEST get_ipx_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char *cptr_next_variable_name);
{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_table_indices);
	PARAMETER_NOT_USED (sptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (cptr_next_variable_name);

	return (PASS);
}
#endif /* __SNMP_STANDALONE__ */

#ifdef BYME
/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
enum TEST get_lsl_system_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
	{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_bytes_in_table_indices);
	PARAMETER_NOT_USED (bptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (ptr_to_cptr_next_variable_name);
		return(PASS);
	}

/* Srikar, Mar 19, 1997. Changed the variable bptr_table_indices to sptr_table_indices and its type */
/* from BYTE * to OBJECT_ID * */
/* Changed the variable usptr_number_of_bytes_in_table_indices to usptr_number_of_subids_in_table_indices */
extern enum TEST get_lsl_interfaces_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name)
	{
	PARAMETER_NOT_USED (mib_operation);
	PARAMETER_NOT_USED (cptr_mib_string);
	PARAMETER_NOT_USED (bptr_variable_value);
	PARAMETER_NOT_USED (usptr_size_of_variable_value);
	PARAMETER_NOT_USED (usptr_number_of_bytes_in_table_indices);
	PARAMETER_NOT_USED (bptr_table_indices);
	PARAMETER_NOT_USED (eptr_end_of_table);
	PARAMETER_NOT_USED (ptr_to_cptr_next_variable_name);
		return(PASS);
	}
#endif
