#include	"defs.h"
/*	$Modname: snmptrap.c$  $version: 1.10$		$date: 01/26/95$	 */
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version
1.1 04/28/94 keyur Added support for version control
1.2 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.3 05/26/94 keyur
1.4 05/28/94 keyur adding enumerations.
1.5 06/01/94 ross
1.6 06/01/94 ross general clean-up.
1.7 06/03/94 ross adding protocol and driver traps.
1.8 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.9 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.10 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
* 	$lge$
*/
/***********************************************************
	Portions Copyright 1988, 1989 by Carnegie Mellon University

                      All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted,
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the name of CMU not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

CMU DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
CMU BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.
******************************************************************/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
#include <stdlib.h>
#include <string.h>
#include "snmp.h"
/**********************************************************************************/
static void send_trap (enum SNMP_TRAP_TYPES trap_type, char *cptr_mib_variable_name);
/**********************************************************************************/
void snmp_trap_function (void *vptr_packet, USHORT length)
{
	/* for ipx */

	PARAMETER_NOT_USED (vptr_packet);
	PARAMETER_NOT_USED (length);
}
/**********************************************************************************/
void lsl_trap_function (enum DEVICE_CONTROL_OPERATION control_command)
{
	switch (control_command)
		{
		case OPEN_DEVICE_DRIVER_PORT:

			break;

		case STACK_HAS_REGISTERED:

			break;

		case CLOSE_DEVICE_DRIVER_PORT:

			break;

		case OPEN_DEVICE_DRIVER:

			break;

		case CLOSE_DEVICE_DRIVER:

			send_trap (SNMP_TRAP_LINK_DOWN, "ifIndex");

			break;

		case DEVICE_QUERY:

			break;

		case GET_DEVICE_MAC_ADDRESS:

			break;
		}
}
/**********************************************************************************/
static void send_trap (enum SNMP_TRAP_TYPES trap_type, char *cptr_mib_variable_name)
{
	MANAGER_CLASS *sptr_manager;
	void *vptr_buffer;
	USHORT actual_number_of_bytes_to_send;
	ULONG my_ip_address;
	ULONG	specific_trap;
	extern ULONG timer_ulong;
	ULONG timer_ticks;

	specific_trap = 0x00000000L;

	sptr_manager = (MANAGER_CLASS *) get_pointer_to_first_entry_in_list ((LINK *) &snmp.manager_list);

	while (sptr_manager != NULL)
		{
		vptr_buffer = table_malloc (1, (ULONG) snmp.maximum_transmission_unit);

		if (vptr_buffer != NULL)
			{
			my_ip_address = snmp.local_internet_address;

			timer_ticks = timer_ulong;

			actual_number_of_bytes_to_send = snmp_build_trap ((BYTE *) vptr_buffer, &actual_number_of_bytes_to_send, my_ip_address,
				(ULONG) trap_type, (USHORT) specific_trap, timer_ticks, cptr_mib_variable_name);

			if (actual_number_of_bytes_to_send != 0x0000)
				{
				send_snmp_packet (&sptr_manager->remote_sockaddr_in, vptr_buffer, actual_number_of_bytes_to_send);
				}
			else
				{
				snmp_free_a_send_packet (vptr_buffer);
				}
			}
		else
			{
			snmp_printf (SNMP_ALARM_PRINTF, "SNMP: send_trap (): table_malloc failed\n");
			}

		sptr_manager = (MANAGER_CLASS *) get_pointer_to_next_entry_in_list ((LINK *) sptr_manager);
		}
}
/**********************************************************************************/
USHORT snmp_build_trap (BYTE *bptr_tx_packet, USHORT *usptr_length, ULONG tx_address, ULONG trap_type, USHORT specific_type,
	ULONG time, char *cptr_mib_variable_name)
{
	VARIABLE	*sptr_mib_variable;
	USHORT length_of_system_id;
	USHORT dummy_length;
	USHORT authentication_shift;
	USHORT pdu_shift;
	USHORT list_shift;
	ULONG version;
	BYTE *bptr_tx_authentication;
	BYTE *bptr_out_header;
	BYTE *bptr_tx_pdu;
	BYTE *bptr_tx_variable_header;
	BYTE *bptr_tx_variable_list;
	BYTE *bptr_tx_end;
	OBJECT_ID enterprise_id[MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID];
	USHORT length_of_enterprise_object_id;
	USHORT length_of_variable;
	BYTE *bptr_variable_value;
	enum ASN_TYPES asn_type;
	USHORT return_value;

	length_of_variable = sizeof (ULONG);

	bptr_variable_value = (BYTE *) &length_of_variable;

	sptr_mib_variable = get_mib_variable_using_name (cptr_mib_variable_name);

  	length_of_system_id = (USHORT) strlen ("public");

	version = SNMP_VERSION_1;

	bptr_tx_authentication = bptr_tx_packet;

	bptr_out_header = snmp_authentication_build ((BYTE *) bptr_tx_packet, usptr_length, "public", &length_of_system_id, &version,
		(USHORT) 90);

	if (bptr_out_header == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Authentication Build Failed\n");

		return (0x0000);
		}

	bptr_tx_pdu = asn_build_header (bptr_out_header, usptr_length, (enum ASN_TYPES) TRAP_REQUEST_MESSAGE, 90);

	if (bptr_tx_pdu == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Header Build Failed \r\n");

		return (0x0000);
		}

	length_of_enterprise_object_id = MAXIMUM_NUMBER_OF_SUB_IDS_IN_OBJECT_ID;

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_OBJECT_ID);

	bptr_tx_packet = asn_build_object_id (bptr_tx_pdu, usptr_length, asn_type, &enterprise_id[0], length_of_enterprise_object_id);

	if (bptr_tx_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Enterprise Build Failed\n");

		return (0x0000);
		}

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_OCTET_STRING);

	bptr_tx_packet = asn_build_string (bptr_tx_packet, usptr_length, asn_type, (char *) &tx_address, sizeof (tx_address));

	if (bptr_tx_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Agent address Build Failed\n");

		return (0x0000);
		}

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_INTEGER);

	bptr_tx_packet = asn_build_integer (bptr_tx_packet, usptr_length, asn_type, &trap_type, sizeof (trap_type), TRUE);

	if (bptr_tx_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: trap_type Build Failed \r\n");

		return (0x0000);
		}

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_UNIVERSAL | (ULONG) ASN_PRIMITIVE | (ULONG) ASN_INTEGER);

	bptr_tx_packet = asn_build_integer (bptr_tx_packet, usptr_length, asn_type, (ULONG *) &specific_type, sizeof (specific_type),
		TRUE);

	if (bptr_tx_packet == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: specific_type Build Failed\n");

		return (0x0000);
		}

	bptr_tx_variable_header = asn_build_integer (bptr_tx_packet, usptr_length, (enum ASN_TYPES) TIMETICKS, (ULONG *) &time,
		sizeof (time), TRUE);

	if (bptr_tx_variable_header == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: timestamp Build Failed \r\n");

		return (0x0000);
		}

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR);

	bptr_tx_variable_list = asn_build_header (bptr_tx_variable_header, usptr_length, asn_type, 90);

	bptr_tx_end = build_a_variable_binding (bptr_tx_variable_list, usptr_length, &sptr_mib_variable->object_id[0],
		sptr_mib_variable->object_id_length, sptr_mib_variable->type, length_of_variable, bptr_variable_value);

	if (bptr_tx_end == NULL)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Variable option Build Failed\n");

		return (0x0000);
		}

	/*
	 * Because of the assumption above that header lengths would be encoded
	 * in one byte, things need to be fixed, now that the actual lengths are known.
	 */

	list_shift = 0x0000;

	*usptr_length = (USHORT) (bptr_tx_end - bptr_tx_variable_list);

	if (*usptr_length >= 0x80)
		{
		++list_shift;

		if (*usptr_length > 0xff)
			{
			++list_shift;
			}
		}

	pdu_shift = 0x0000;

	*usptr_length = (USHORT) ((bptr_tx_end - bptr_tx_pdu) + list_shift);

	if (*usptr_length >= 0x80)
		{
		++pdu_shift;

		if (*usptr_length > 0xff)
			{
			++pdu_shift;
			}
		}

	authentication_shift = 0x0000;

	/*	2 below is the size of the assumed asn header in the auth header */

	*usptr_length = (USHORT) ((bptr_tx_end - bptr_tx_authentication) - 2 + pdu_shift + list_shift);

	if (*usptr_length >= 0x80)
		{
		++authentication_shift;

		if (*usptr_length > 0xff)
			{
			++authentication_shift;
			}
		}

	if ((authentication_shift + pdu_shift + list_shift) > 0x0000)
		{
		/* Shift packet (from start of varlist to end of packet) by the sum of the necessary shift counts. */

		shift_array (bptr_tx_variable_list, (USHORT) (bptr_tx_end - bptr_tx_variable_list), (short) (authentication_shift + pdu_shift + list_shift));

		/* Now adjust pointers into the packet */

		bptr_tx_end += authentication_shift + pdu_shift + list_shift;

		bptr_tx_variable_list += authentication_shift + pdu_shift + list_shift;

		bptr_tx_variable_header += authentication_shift + pdu_shift;
		}

	/* Now rebuild header with the actual lengths */

	dummy_length = (USHORT) (bptr_tx_end - bptr_tx_variable_list);

	asn_type = (enum ASN_TYPES) ((ULONG) ASN_SEQUENCE | (ULONG) ASN_CONSTRUCTOR);

	if (asn_build_header (bptr_tx_variable_header, &dummy_length, asn_type, dummy_length) != bptr_tx_variable_list)
		{
		return (0x0000);
		}

	if ((authentication_shift + pdu_shift) > 0x0000)
		{
		/* Shift packet (from start of varlist to end of packet) by the sum of the necessary shift counts. */

		shift_array (bptr_tx_pdu, (USHORT) (bptr_tx_variable_header - bptr_tx_pdu), (short) (authentication_shift + pdu_shift));

		/* Now adjust pointers into the packet */

		bptr_tx_pdu += authentication_shift + pdu_shift;

		bptr_out_header += authentication_shift;
		}

	/* Now rebuild header with the actual lengths */

	dummy_length = (USHORT) (bptr_tx_end - bptr_tx_pdu);

	if (asn_build_header (bptr_out_header, &dummy_length, (enum ASN_TYPES) TRAP_REQUEST_MESSAGE, dummy_length) != bptr_tx_pdu)
		{
		return (0x0000);
		}

	bptr_tx_packet = bptr_tx_authentication;

	*usptr_length = (USHORT) (bptr_tx_end - bptr_tx_authentication);

	bptr_tx_packet = snmp_authentication_build (bptr_tx_packet, usptr_length, "public", &length_of_system_id, &version,
		(USHORT) (bptr_tx_end - bptr_out_header));

	if (bptr_tx_packet != bptr_out_header)
		{
		snmp_printf (SNMP_ALARM_PRINTF, "SNMP Error: Internal Error Occured \r\n");

		return (0x0000);
		}

	*usptr_length = (USHORT) (bptr_tx_end - bptr_tx_authentication);

	return_value = *usptr_length;

	return (return_value);
}
