/*	$Modname: vsnmpmib.h$  $version: 1.13$		$date: 06/27/95$	*/
/*
* 	$lgb$
1.0 04/28/94 keyur Initial version.
1.1 04/28/94 keyur Added support for version control
1.2 04/28/94 keyur
1.3 05/17/94 keyur Added support for Big Endian - Little Endian consideration.
1.4 05/26/94 keyur
1.5 05/28/94 keyur adding enumerations
1.6 06/01/94 ross
1.7 06/02/94 ross more general clean-up.
1.8 06/03/94 ross adding protocol and driver traps.
1.9 06/20/94 ross fixed copyright notice.  Removed some unnecessary port number parameters from fu
1.10 12/27/94 ross fix table access functions.  Added sort instrumentation.
1.11 01/26/95 ross fixes to work with new generic snmp in rwutils, fixed mib table
1.12 03/08/95 ross mib table change for source routing.  lsl_control added.
1.13 06/27/95 ross added ip address function to reduce redundancy in ip family protocols
* 	$lge$
*/
/************************************************************************/
/*	Copyright (C) 1994 RouterWare, Inc.												*/
/*	Unpublished - rights reserved under the Copyright Laws of the			*/
/*	United States.  Use, duplication, or disclosure by the 					*/
/*	Government is subject to restrictions as set forth in 					*/
/*	subparagraph (c)(1)(ii) of the Rights in Technical Data and 			*/
/*	Computer Software clause at 252.227-7013.										*/
/*	RouterWare, Inc., 3961 MacArthur Blvd. Suite 212, Newport Beach Ca   */
/************************************************************************/
/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
enum TEST get_rfc1213_system_mibs (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
enum TEST get_tcp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_lsl_interfaces_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_lsl_system_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_source_routing_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_spanning_tree_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
enum TEST get_snmp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_rfc1213_arp_table_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_rfc1213_ip_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_rfc1213_icmp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_rfc1213_udp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_ppp_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_frame_relay_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

/* Srikar, Mar 20, 1997. Changed the function prototype due to change in object id type */
extern enum TEST get_ipx_mib_variable (enum MIB_OPERATION mib_operation, char *cptr_mib_string,
	BYTE *bptr_variable_value, USHORT *usptr_size_of_variable_value, USHORT *usptr_number_of_subids_in_table_indices,
	OBJECT_ID *sptr_table_indices, enum BOOLEAN *eptr_end_of_table, char **ptr_to_cptr_next_variable_name);

#ifdef GLOBAL_FILE

	#ifdef __MSDOS__
		VARIABLE	far	variables[] =
	#else
		VARIABLE	variables[] =
	#endif
	{
		/* these must be lexicographly ordered by the name field */

		/* Srikar, Mar 20, 1997. Replaced all initializations of table indices part of object ids from 0xff to 0xffffffff */
		/* Initialized the table indices such that there is one for each subidentifier instead of one for each byte */

		/* system MIBs */

		/* Srikar, Mar 18, 1997. sysDescr and sysServices made read-only. */
		{{MIB,1,1,0},9,STRING,"sysDescr",READ_ONLY,FALSE,get_lsl_system_mib_variable},
		{{MIB,1,2,0},9,ASN_OBJECT_ID,"sysObjectID",READ_ONLY,FALSE,get_lsl_system_mib_variable},
		{{MIB,1,3,0},9,TIMETICKS,"sysUpTime",READ_ONLY,FALSE,get_lsl_system_mib_variable},
		{{MIB,1,4,0},9,STRING,"sysContact",READ_WRITE,FALSE,get_lsl_system_mib_variable},
		{{MIB,1,5,0},9,STRING,"sysName",READ_WRITE,FALSE,get_lsl_system_mib_variable},
		{{MIB,1,6,0},9,STRING,"sysLocation",READ_WRITE,FALSE,get_lsl_system_mib_variable},
		{{MIB,1,7,0},9,INTEGER,"sysServices",READ_ONLY,FALSE,get_lsl_system_mib_variable},

		/* interface (LSL) MIBs */

		{{MIB,2,1,0},9,INTEGER,"ifNumber",READ_ONLY,FALSE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,1,0xffffffff},11,INTEGER,"ifIndex",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,2,0xffffffff},11,STRING,"ifDescr",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,3,0xffffffff},11,INTEGER,"ifType",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,4,0xffffffff},11,INTEGER,"ifMtu",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,5,0xffffffff},11,GAUGE,"ifSpeed",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,6,0xffffffff},11,STRING,"ifPhysAddress",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,7,0xffffffff},11,INTEGER,"ifAdminStatus",READ_WRITE,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,8,0xffffffff},11,INTEGER,"ifOperStatus",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,9,0xffffffff},11,TIMETICKS,"ifLastChange",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,10,0xffffffff},11,COUNTER,"ifInOctets",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,11,0xffffffff},11,COUNTER,"ifInUcastPkts",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,12,0xffffffff},11,COUNTER,"ifInNUcastPkts",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,13,0xffffffff},11,COUNTER,"ifInDiscards",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,14,0xffffffff},11,COUNTER,"ifInErrors",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,15,0xffffffff},11,COUNTER,"ifInUnknownProtos",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,16,0xffffffff},11,COUNTER,"ifOutOctets",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,17,0xffffffff},11,COUNTER,"ifOutUcastPkts",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,18,0xffffffff},11,COUNTER,"ifOutNUcastPkts",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,19,0xffffffff},11,COUNTER,"ifOutDiscards",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,20,0xffffffff},11,COUNTER,"ifOutErrors",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,21,0xffffffff},11,GAUGE,"ifOutQLen",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},
		{{MIB,2,2,1,22,0xffffffff},11,ASN_OBJECT_ID,"ifSpecific",READ_ONLY,TRUE,get_lsl_interfaces_mib_variable},

		/* ARP Table MIBs */

		{{MIB,3,1,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},16,INTEGER,"atIfIndex",READ_ONLY,TRUE,
			get_rfc1213_arp_table_mib_variable},
		{{MIB,3,1,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},16,STRING,"atPhysAddress",READ_ONLY,TRUE,
			get_rfc1213_arp_table_mib_variable},
		{{MIB,3,1,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},16,IP_ADDRESS,"atNetAddress",READ_ONLY,TRUE,
			get_rfc1213_arp_table_mib_variable},

		/* IP MIBs */

		{{MIB,4,1,0},9,INTEGER,"ipForwarding",READ_WRITE,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,2,0},9,INTEGER,"ipDefaultTTL",READ_WRITE,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,3,0},9,COUNTER,"ipInReceives",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,4,0},9,COUNTER,"ipInHdrErrors",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,5,0},9,COUNTER,"ipInAddrErrors",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,6,0},9,COUNTER,"ipForwDatagrams",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,7,0},9,COUNTER,"ipInUnknownProtos",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,8,0},9,COUNTER,"ipInDiscards",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,9,0},9,COUNTER,"ipInDelivers",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,10,0},9,COUNTER,"ipOutRequests",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,11,0},9,COUNTER,"ipOutDiscards",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,12,0},9,COUNTER,"ipOutNoRoutes",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,13,0},9,INTEGER,"ipReasmTimeout",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,14,0},9,COUNTER,"ipReasmReqds",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,15,0},9,COUNTER,"ipReasmOKs",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,16,0},9,COUNTER,"ipReasmFails",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,17,0},9,COUNTER,"ipFragOKs",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,18,0},9,COUNTER,"ipFragFails",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,19,0},9,COUNTER,"ipFragCreates",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},
		{{MIB,4,20,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,IP_ADDRESS,"ipAdEntAddr",READ_ONLY,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,20,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipAdEntIfIndex",READ_ONLY,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,20,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,IP_ADDRESS,"ipAdEntNetMask",READ_ONLY,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,20,1,4,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,IP_ADDRESS,"ipAdEntBcastAddr",READ_ONLY,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,20,1,5,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipAdEntReasmMaxSize",READ_ONLY,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,IP_ADDRESS,"ipRouteDest",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteIfIndex",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteMetric1",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,4,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteMetric2",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,5,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteMetric3",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,6,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteMetric4",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,7,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,IP_ADDRESS,"ipRouteNextHop",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,8,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteType",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,9,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteProto",READ_ONLY,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,10,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteAge",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,11,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,IP_ADDRESS,"ipRouteMask",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,12,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,INTEGER,"ipRouteMetric5",READ_WRITE,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,21,1,13,0xffffffff,0xffffffff,0xffffffff,0xffffffff},14,ASN_OBJECT_ID,"ipRouteInfo",READ_ONLY,TRUE,get_rfc1213_ip_mib_variable},
		{{MIB,4,22,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},15,INTEGER,"ipNetToMediaIfIndex",READ_WRITE,TRUE,
			get_rfc1213_ip_mib_variable},
		{{MIB,4,22,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},15,STRING,"ipNetToMediaPhysAddress",READ_WRITE,TRUE,
			get_rfc1213_ip_mib_variable},
		{{MIB,4,22,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},15,IP_ADDRESS,"ipNetToMediaNetAddress",READ_WRITE,TRUE,
			get_rfc1213_ip_mib_variable},
		{{MIB,4,22,1,4,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},15,INTEGER,"ipNetToMediaType",READ_WRITE,TRUE,
			get_rfc1213_ip_mib_variable},
		{{MIB,4,23,0},9,COUNTER,"ipRoutingDiscards",READ_ONLY,FALSE,get_rfc1213_ip_mib_variable},

		/* ICMP MIBs */

		{{MIB,5,1,0},9,COUNTER,"icmpInMsgs",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,2,0},9,COUNTER,"icmpInErrors",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,3,0},9,COUNTER,"icmpInDestUnreachs",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,4,0},9,COUNTER,"icmpInTimeExcds",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,5,0},9,COUNTER,"icmpInParmProbs",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,6,0},9,COUNTER,"icmpInSrcQuenchs",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,7,0},9,COUNTER,"icmpInRedirects",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,8,0},9,COUNTER,"icmpInEchos",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,9,0},9,COUNTER,"icmpInEchoReps",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,10,0},9,COUNTER,"icmpInTimestamps",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,11,0},9,COUNTER,"icmpInTimestampReps",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,12,0},9,COUNTER,"icmpInAddrMasks",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,13,0},9,COUNTER,"icmpInAddrMaskReps",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,14,0},9,COUNTER,"icmpOutMsgs",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,15,0},9,COUNTER,"icmpOutErrors",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,16,0},9,COUNTER,"icmpOutDestUnreachs",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,17,0},9,COUNTER,"icmpOutTimeExcds",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,18,0},9,COUNTER,"icmpOutParmProbs",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,19,0},9,COUNTER,"icmpOutSrcQuenchs",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,20,0},9,COUNTER,"icmpOutRedirects",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,21,0},9,COUNTER,"icmpOutEchos",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,22,0},9,COUNTER,"icmpOutEchoReps",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,23,0},9,COUNTER,"icmpOutTimestamps",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,24,0},9,COUNTER,"icmpOutTimestampReps",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,25,0},9,COUNTER,"icmpOutAddrMasks",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},
		{{MIB,5,26,0},9,COUNTER,"icmpOutAddrMaskReps",READ_ONLY,FALSE,get_rfc1213_icmp_mib_variable},

		/* TCP MIBs */
#define TCP_MIB	6

		{{MIB, TCP_MIB,  1, 0}, 9, INTEGER, "tcpRtoAlgorithm", READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB,  2, 0}, 9, INTEGER, "tcpRtoMin",       READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB,  3, 0}, 9, INTEGER, "tcpRtoMax",       READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB,  4, 0}, 9, INTEGER, "tcpMaxConn",      READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB,  5, 0}, 9, COUNTER, "tcpActiveOpens",  READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB,  6, 0}, 9, COUNTER, "tcpPassiveOpens", READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB,  7, 0}, 9, COUNTER, "tcpAttemptFails", READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB,  8, 0}, 9, COUNTER, "tcpEstabResets",  READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB,  9, 0}, 9, GAUGE,   "tcpCurrEstab",    READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB, 10, 0}, 9, COUNTER, "tcpInSegs",       READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB, 11, 0}, 9, COUNTER, "tcpOutSegs",      READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB, 12, 0}, 9, COUNTER, "tcpRetransSegs",  READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB,TCP_MIB,13,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			20, INTEGER, "tcpConnState",  READ_WRITE, TRUE, get_tcp_mib_variable},
		{{MIB,TCP_MIB,13,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			20, IP_ADDRESS, "tcpConnLocalAddress", READ_ONLY, TRUE, get_tcp_mib_variable},
		{{MIB,TCP_MIB,13,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			20, INTEGER, "tcpConnLocalPort", READ_ONLY, TRUE, get_tcp_mib_variable},
		{{MIB,TCP_MIB,13,1,4,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			20, IP_ADDRESS, "tcpConnRemAddress", READ_ONLY, TRUE,  get_tcp_mib_variable},
		{{MIB,TCP_MIB,13,1,5,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			20, INTEGER, "tcpConnRemPort", READ_ONLY, TRUE,  get_tcp_mib_variable},
		{{MIB, TCP_MIB, 14, 0}, 9, COUNTER, "tcpInErrs",       READ_ONLY, FALSE, get_tcp_mib_variable},
		{{MIB, TCP_MIB, 15, 0}, 9, COUNTER, "tcpOutRsts",      READ_ONLY, FALSE, get_tcp_mib_variable},

		/* UDP MIBs */

		{{MIB,7,1,0},9,COUNTER,"udpInDatagrams",READ_ONLY,FALSE,get_rfc1213_udp_mib_variable},
		{{MIB,7,2,0},9,COUNTER,"udpNoPorts",READ_ONLY,FALSE,get_rfc1213_udp_mib_variable},
		{{MIB,7,3,0},9,COUNTER,"udpInErrors",READ_ONLY,FALSE,get_rfc1213_udp_mib_variable},
		{{MIB,7,4,0},9,COUNTER,"udpOutDatagrams",READ_ONLY,FALSE,get_rfc1213_udp_mib_variable},
		{{MIB,7,5,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},15,IP_ADDRESS,"udpLocalAddress",READ_ONLY,TRUE,
			get_rfc1213_udp_mib_variable},
		{{MIB,7,5,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},15,INTEGER,"udpLocalPort",READ_ONLY,TRUE,
			get_rfc1213_udp_mib_variable},

/* PPP CHANGED PLACES BY ME */

		/* PPP MIBs */

		/* Srikar, Mar 18, 1997. Changed "pppLinkStatusLocalToPeerACCMap" and "pppLinkStatusPeerToLocalACCMap" */
		/* from IP_ADDRESS to STRING type. */
		{{MIB,10,23,1,1,1,1,1,0xffffffff},14,INTEGER,"pppLinkStatusPhysicalIndex",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,2,0xffffffff},14,COUNTER,"pppLinkStatusBadAddresses",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,3,0xffffffff},14,COUNTER,"pppLinkStatusBadControls",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,4,0xffffffff},14,COUNTER,"pppLinkStatusPacketTooLongs",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,5,0xffffffff},14,COUNTER,"pppLinkStatusBadFCSs",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,6,0xffffffff},14,INTEGER,"pppLinkStatusLocalMRU",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,7,0xffffffff},14,INTEGER,"pppLinkStatusRemoteMRU",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,8,0xffffffff},14,STRING,"pppLinkStatusLocalToPeerACCMap",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,9,0xffffffff},14,STRING,"pppLinkStatusPeerToLocalACCMap",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,10,0xffffffff},14,INTEGER,"pppLinkStatusLocalToRemoteProtocolCompression",READ_ONLY,TRUE,
			get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,11,0xffffffff},14,INTEGER,"pppLinkStatusRemoteToLocalProtocolCompression",READ_ONLY,TRUE,
			get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,12,0xffffffff},14,INTEGER,"pppLinkStatusLocalToRemoteACCompression",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,13,0xffffffff},14,INTEGER,"pppLinkStatusRemoteToLocalACCompression",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,14,0xffffffff},14,INTEGER,"pppLinkStatusTransmitFcsSize",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,1,1,15,0xffffffff},14,INTEGER,"pppLinkStatusReceiveFcsSize",READ_ONLY,TRUE,get_ppp_mib_variable},

			/* ppp link group configuration */

		/* Srikar, Mar 18, 1997. Changed "pppLinkConfigReceiveACCMap" and "pppLinkConfigTransmitACCMap" */
		/* from IP_ADDRESS to STRING type. Changed the access permission for the following from read-only to */
		/* read-write : "pppLinkConfigInitialMRU", "pppLinkConfigReceiveACCMap", "pppLinkConfigTransmitACCMap", */
		/* "pppLinkConfigMagicNumber", "pppLinkConfigFcsSize". */

		{{MIB,10,23,1,1,2,1,1,0xffffffff},14,INTEGER,"pppLinkConfigInitialMRU",READ_WRITE,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,2,1,2,0xffffffff},14,STRING,"pppLinkConfigReceiveACCMap",READ_WRITE,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,2,1,3,0xffffffff},14,STRING,"pppLinkConfigTransmitACCMap",READ_WRITE,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,2,1,4,0xffffffff},14,INTEGER,"pppLinkConfigMagicNumber",READ_WRITE,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,1,2,1,5,0xffffffff},14,INTEGER,"pppLinkConfigFcsSize",READ_WRITE,TRUE,get_ppp_mib_variable},

/* Srikar, Mar 18, 1997. Commented the following line to include LQR variables. */
/*#ifdef PPP_LQR_MODULE */

			/* ppp link quality group */

		{{MIB,10,23,1,2,1,1,1,0xffffffff},14,INTEGER,"pppLqrQuality",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,2,1,1,2,0xffffffff},14,COUNTER,"pppLqrInGoodOctets",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,2,1,1,3,0xffffffff},14,INTEGER,"pppLqrLocalPeriod",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,2,1,1,4,0xffffffff},14,INTEGER,"pppLqrRemotePeriod",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,2,1,1,5,0xffffffff},14,COUNTER,"pppLqrOutLQRs",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,2,1,1,6,0xffffffff},14,COUNTER,"pppLqrInLQRs",READ_ONLY,TRUE,get_ppp_mib_variable},

			/* ppp link quality configuration */

		{{MIB,10,23,1,2,2,1,1,0xffffffff},14,INTEGER,"pppLqrConfigPeriod",READ_WRITE,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,1,2,2,1,2,0xffffffff},14,INTEGER,"pppLqrConfigStatus",READ_WRITE,TRUE,get_ppp_mib_variable},

		/* Srikar, Mar 18, 1997. Added the LQR extensions table variable. */

		{{MIB,10,23,1,2,3,1,1,0xffffffff},14,STRING,"pppLqrExtnsLastReceivedLqrPacket",READ_ONLY,TRUE,get_ppp_mib_variable},

/* Srikar, Mar 18, 1997. Commented the following line to include LQR variables. */
/* #endif PPP_LQR_MODULE */

		/* Srikar, Mar 18, 1997. Added the PPP IP Table and PPP IP Configuration table. */

		/* PPP IP table. */
		{{MIB,10,23,3,1,1,1,0xffffffff},13,INTEGER,"pppIpOperStatus",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,3,1,1,2,0xffffffff},13,INTEGER,"pppIpLocalToRemoteCompressionProtocol",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,3,1,1,3,0xffffffff},13,INTEGER,"pppIpRemoteToLocalCompressionProtocol",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,3,1,1,4,0xffffffff},13,INTEGER,"pppIpRemoteMaxSlotId",READ_ONLY,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,3,1,1,5,0xffffffff},13,INTEGER,"pppIpLocalMaxSlotId",READ_ONLY,TRUE,get_ppp_mib_variable},

		/* PPP IP configuration table. */
		{{MIB,10,23,3,2,1,1,0xffffffff},13,INTEGER,"pppIpConfigAdminStatus",READ_WRITE,TRUE,get_ppp_mib_variable},
		{{MIB,10,23,3,2,1,2,0xffffffff},13,INTEGER,"pppIpConfigCompression",READ_WRITE,TRUE,get_ppp_mib_variable},
#if PROXY_SERVER
#else
		/* Srikar, Apr 11, 1997. Added Frame Relay mib variables */
		/* Frame Relay MIBs */

		/* Data Link Connection Managemnt Interface */
		{{MIB,10,32,1,1,1,0xffffffff},12,INTEGER,"frDlcmiIfIndex",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,2,0xffffffff},12,INTEGER,"frDlcmiState",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,3,0xffffffff},12,INTEGER,"frDlcmiAddress",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,4,0xffffffff},12,INTEGER,"frDlcmiAddressLen",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,5,0xffffffff},12,INTEGER,"frDlcmiPollingInterval",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,6,0xffffffff},12,INTEGER,"frDlcmiFullEnquiryInterval",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,7,0xffffffff},12,INTEGER,"frDlcmiErrorThreshold",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,8,0xffffffff},12,INTEGER,"frDlcmiMonitoredEvents",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,9,0xffffffff},12,INTEGER,"frDlcmiMaxSupportedVCs",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,1,1,10,0xffffffff},12,INTEGER,"frDlcmiMulticast",READ_WRITE,TRUE,get_frame_relay_mib_variable},

		/* Frame Relay Circuit Table */
		{{MIB,10,32,2,1,1,0xffffffff,0xffffffff},13,INTEGER,"frCircuitIndex",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,2,0xffffffff,0xffffffff},13,INTEGER,"frCircuitDlci",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,3,0xffffffff,0xffffffff},13,INTEGER,"frCircuitState",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,4,0xffffffff,0xffffffff},13,INTEGER,"frCircuitReceivedFECNs",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,5,0xffffffff,0xffffffff},13,INTEGER,"frCircuitReceivedBECNs",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,6,0xffffffff,0xffffffff},13,INTEGER,"frCircuitSentFrames",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,7,0xffffffff,0xffffffff},13,INTEGER,"frCircuitSentOctets",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,8,0xffffffff,0xffffffff},13,INTEGER,"frCircuitReceivedFrames",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,9,0xffffffff,0xffffffff},13,INTEGER,"frCircuitReceivedOctets",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,10,0xffffffff,0xffffffff},13,INTEGER,"frCircuitCreationTime",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,11,0xffffffff,0xffffffff},13,INTEGER,"frCircuitLastTimeChange",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,12,0xffffffff,0xffffffff},13,INTEGER,"frCircuitCommittedBurst",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,13,0xffffffff,0xffffffff},13,INTEGER,"frCircuitExcessBurst",READ_WRITE,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,2,1,14,0xffffffff,0xffffffff},13,INTEGER,"frCircuitThroughput",READ_WRITE,TRUE,get_frame_relay_mib_variable},

		/* Frame Relay Error Table */
		{{MIB,10,32,3,1,1,0xffffffff},12,INTEGER,"frErrIfIndex",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,3,1,2,0xffffffff},12,INTEGER,"frErrType",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,3,1,3,0xffffffff},12,STRING,"frErrData",READ_ONLY,TRUE,get_frame_relay_mib_variable},
		{{MIB,10,32,3,1,4,0xffffffff},12,INTEGER,"frErrTime",READ_ONLY,TRUE,get_frame_relay_mib_variable},

#endif

/* SNMP CHANGED PLACES BY ME */

		/* SNMP MIBs */
		{{MIB,11,1,0},9,COUNTER,"snmpInPkts",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,2,0},9,COUNTER,"snmpOutPkts",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,3,0},9,COUNTER,"snmpInBadVersions",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,4,0},9,COUNTER,"snmpInBadCommunityNames",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,5,0},9,COUNTER,"snmpInBadCommunityUses",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,6,0},9,COUNTER,"snmpInASNParseErrs",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,8,0},9,COUNTER,"snmpInTooBigs",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,9,0},9,COUNTER,"snmpInNoSuchNames",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,10,0},9,COUNTER,"snmpInBadValues",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,11,0},9,COUNTER,"snmpInReadOnlys",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,12,0},9,COUNTER,"snmpInGenErrs",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,13,0},9,COUNTER,"snmpInTotalReqVars",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,14,0},9,COUNTER,"snmpInTotalSetVars",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,15,0},9,COUNTER,"snmpInGetRequests",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,16,0},9,COUNTER,"snmpInGetNexts",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,17,0},9,COUNTER,"snmpInSetRequests",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,18,0},9,COUNTER,"snmpInGetResponses",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,19,0},9,COUNTER,"snmpInTraps",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,20,0},9,COUNTER,"snmpOutTooBigs",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,21,0},9,COUNTER,"snmpOutNoSuchNames",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,22,0},9,COUNTER,"snmpOutBadValues",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,24,0},9,COUNTER,"snmpOutGenErrs",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,25,0},9,COUNTER,"snmpOutGetRequests",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,26,0},9,COUNTER,"snmpOutGetNexts",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,27,0},9,COUNTER,"snmpOutSetRequests",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,28,0},9,COUNTER,"snmpOutGetResponses",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,29,0},9,COUNTER,"snmpOutTraps",READ_ONLY,FALSE,get_snmp_mib_variable},
		{{MIB,11,30,0},9,INTEGER,"snmpEnableAuthenTraps",READ_WRITE,FALSE,get_snmp_mib_variable},

#if PROXY_SERVER
#else
		/* Spanning Tree MIBs */

		/* dot1dBase */

		{{MIB,17,1,1,0},10,STRING,"dot1dBaseBridgeAddress",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,1,2,0},10,INTEGER,"dot1dBaseNumPorts",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,1,3,0},10,INTEGER,"dot1dBaseType",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,1,4,1,1,0xffffffff},12,INTEGER,"dot1dBasePort",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,1,4,1,2,0xffffffff},12,INTEGER,"dot1dBasePortIfIndex",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,1,4,1,3,0xffffffff},12,ASN_OBJECT_ID,"dot1dBasePortCircuit",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,1,4,1,4,0xffffffff},12,COUNTER,"dot1dBasePortDelayExceededDiscards",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,1,4,1,5,0xffffffff},12,COUNTER,"dot1dBasePortMtuExceededDiscards",READ_ONLY,TRUE,get_spanning_tree_mib_variable},

		/* dot1dStp */

		{{MIB,17,2,1,0},10,INTEGER,"dot1dStpProtocolSpecification",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,2,0},10,INTEGER,"dot1dStpPriority",READ_WRITE,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,3,0},10,INTEGER,"dot1dStpTimeSinceTopologyChange",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,4,0},10,INTEGER,"dot1dStpTopChanges",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		/* Srikar, Mar 20, 1997. Changed the type of dot1dStpDesignatedRoot from object_id to string. */
		{{MIB,17,2,5,0},10,STRING,"dot1dStpDesignatedRoot",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,6,0},10,INTEGER,"dot1dStpRootCost",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,7,0},10,INTEGER,"dot1dStpRootPort",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,8,0},10,INTEGER,"dot1dStpMaxAge",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,9,0},10,INTEGER,"dot1dStpHelloTime",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,10,0},10,INTEGER,"dot1dStpHoldTime",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,11,0},10,INTEGER,"dot1dStpForwardDelay",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,12,0},10,INTEGER,"dot1dStpBridgeMaxAge",READ_WRITE,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,13,0},10,INTEGER,"dot1dStpBridgeHelloTime",READ_WRITE,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,14,0},10,INTEGER,"dot1dStpBridgeForwardDelay",READ_WRITE,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,2,15,1,1,0xffffffff},12,INTEGER,"dot1dStpPort",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,2,15,1,2,0xffffffff},12,INTEGER,"dot1dStpPortPriority",READ_WRITE,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,2,15,1,3,0xffffffff},12,INTEGER,"dot1dStpPortState",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,2,15,1,4,0xffffffff},12,INTEGER,"dot1dStpPortEnable",READ_WRITE,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,2,15,1,5,0xffffffff},12,INTEGER,"dot1dStpPortPathCost",READ_WRITE,TRUE,get_spanning_tree_mib_variable},
		/* Srikar, Mar 20, 1997. Changed the type of dot1dStpPortDesignatedRoot from object_id to string. */
		{{MIB,17,2,15,1,6,0xffffffff},12,STRING,"dot1dStpPortDesignatedRoot",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,2,15,1,7,0xffffffff},12,INTEGER,"dot1dStpPortDesignatedCost",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		/* Srikar, Mar 20, 1997. Changed the type of dot1dStpPortDesignatedBridge from object_id to string. */
		{{MIB,17,2,15,1,8,0xffffffff},12,STRING,"dot1dStpPortDesignatedBridge",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,2,15,1,9,0xffffffff},12,ASN_OBJECT_ID,"dot1dStpPortDesignatedPort",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,2,15,1,10,0xffffffff},12,COUNTER,"dot1dStpPortForwardTransitions",READ_ONLY,TRUE,get_spanning_tree_mib_variable},

		/* dot1dSr */

#ifdef RTRERROR
		{{MIB,17,3,1,1,1,0xff,0xff,0xff,0xff},15,INTEGER,"dot1dSrPort",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,2,0xff,0xff,0xff,0xff},15,INTEGER,"dot1dSrPortHopCount",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,3,0xff,0xff,0xff,0xff},15,INTEGER,"dot1dSrPortLocalSegment",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,4,0xff,0xff,0xff,0xff},15,INTEGER,"dot1dSrPortBridgeNum",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,5,0xff,0xff,0xff,0xff},15,INTEGER,"dot1dSrPortTargetSegment",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,6,0xff,0xff,0xff,0xff},15,INTEGER,"dot1dSrPortLargestFrame",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,7,0xff,0xff,0xff,0xff},15,INTEGER,"dot1dSrPortSTESpanMode",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,8,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortSpecInFrames",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,9,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortSpecOutFrames",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,10,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortApeInFrames",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,11,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortApeOutFrames",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,12,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortSteInFrames",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,13,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortSteOutFrames",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,14,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortSegmentMismatchDiscards",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,15,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortDuplicateSegmentDiscards",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,16,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortHopCountExceededDiscards",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,17,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortDupLanIdOrTreeErrors",READ_ONLY,TRUE,get_source_routing_mib_variable},
		{{MIB,17,3,1,1,18,0xff,0xff,0xff,0xff},15,COUNTER,"dot1dSrPortLanIdMismatches",READ_ONLY,TRUE,get_source_routing_mib_variable},
#endif

		/* dot1dTp */

		{{MIB,17,4,1,0},10,COUNTER,"dot1dTpLearnedEntryDiscards",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,4,2,0},10,COUNTER,"dot1dTpAgingTime",READ_WRITE,FALSE,get_spanning_tree_mib_variable},
		/* Srikar, Mar 18, 1997. Changed the type of dot1dTpFdbAddress from object_id to string. Also added a */
		/* table index subid to accommodate the string length byte in dot1dTpFdbAddress, dot1dTpFdbPort, and dot1dTpFdpStatus. */
		{{MIB,17,4,3,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},18,STRING,"dot1dTpFdbAddress",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,4,3,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},18,INTEGER,"dot1dTpFdbPort",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,4,3,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},18,INTEGER,"dot1dTpFdbStatus",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,4,4,1,1,0xffffffff},12,INTEGER,"dot1dTpPort",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,4,4,1,2,0xffffffff},12,INTEGER,"dot1dTpPortMaxInfo",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,4,4,1,3,0xffffffff},12,INTEGER,"dot1dTpPortInFrames",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,4,4,1,4,0xffffffff},12,INTEGER,"dot1dTpPortOutFrames",READ_ONLY,TRUE,get_spanning_tree_mib_variable},
		{{MIB,17,4,4,1,5,0xffffffff},12,INTEGER,"dot1dTpPortInDiscards",READ_ONLY,TRUE,get_spanning_tree_mib_variable},

		/* dot1dStatic */

		{{MIB,17,5,1,1},10,COUNTER,"dot1dStaticAddress",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,5,1,2},10,COUNTER,"dot1dStaticReceivePort",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,5,1,3},10,COUNTER,"dot1dStaticAllowedToGoTo",READ_ONLY,FALSE,get_spanning_tree_mib_variable},
		{{MIB,17,5,1,4},10,COUNTER,"dot1dStaticStatus",READ_ONLY,FALSE,get_spanning_tree_mib_variable},

#endif

#if PROXY_SERVER
#else
		/* ipx */

			/* basic */

		{{PRIVATE_MIB,23,2,5,1,1,1,1,0xffffffff},14,INTEGER,"ipxBasicSysInstance",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,2,0xffffffff},14,INTEGER,"ipxBasicSysExistState",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the type of ipxBasicSysNetNumber from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,1,1,1,3,0xffffffff},14,STRING,"ipxBasicSysNetNumber",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,4,0xffffffff},14,STRING,"ipxBasicSysNode",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,5,0xffffffff},14,STRING,"ipxBasicSysName",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,6,0xffffffff},14,COUNTER,"ipxBasicSysInReceives",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,7,0xffffffff},14,COUNTER,"ipxBasicSysInHdrErrors",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,8,0xffffffff},14,COUNTER,"ipxBasicSysInUnknownSockets",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,9,0xffffffff},14,COUNTER,"ipxBasicSysInDiscards",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,10,0xffffffff},14,COUNTER,"ipxBasicSysInBadChecksums",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,11,0xffffffff},14,COUNTER,"ipxBasicSysInDelivers",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,12,0xffffffff},14,COUNTER,"ipxBasicSysNoRoutes",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,13,0xffffffff},14,COUNTER,"ipxBasicSysOutRequests",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,14,0xffffffff},14,COUNTER,"ipxBasicSysOutMalformedRequests",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,15,0xffffffff},14,COUNTER,"ipxBasicSysOutDiscards",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,16,0xffffffff},14,COUNTER,"ipxBasicSysOutPackets",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,17,0xffffffff},14,INTEGER,"ipxBasicSysConfigSockets",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,1,1,18,0xffffffff},14,COUNTER,"ipxBasicSysOpenSocketFails",READ_ONLY,TRUE,
			get_ipx_mib_variable},

			/* advanced */

		{{PRIVATE_MIB,23,2,5,1,2,1,1,0xffffffff},14,INTEGER,"ipxAdvSysInstance",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,2,0xffffffff},14,INTEGER,"ipxAdvSysMaxPathSplits",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,3,0xffffffff},14,INTEGER,"ipxAdvSysMaxHops",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,4,0xffffffff},14,COUNTER,"ipxAdvSysInTooManyHops",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,5,0xffffffff},14,COUNTER,"ipxAdvSysInFiltered",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,6,0xffffffff},14,COUNTER,"ipxAdvSysInCompressDiscards",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,7,0xffffffff},14,COUNTER,"ipxAdvSysNETBIOSPackets",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,8,0xffffffff},14,COUNTER,"ipxAdvSysForwPackets",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,9,0xffffffff},14,COUNTER,"ipxAdvSysOutFiltered",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,10,0xffffffff},14,COUNTER,"ipxAdvSysOutCompressDiscards",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,11,0xffffffff},14,COUNTER,"ipxAdvSysCircCount",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,12,0xffffffff},14,COUNTER,"ipxAdvSysDestCount",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,1,2,1,13,0xffffffff},14,COUNTER,"ipxAdvSysServCount",READ_ONLY,TRUE,get_ipx_mib_variable},

			/* circuit */

		{{PRIVATE_MIB,23,2,5,2,1,1,1,0xffffffff,0xffffffff},15,INTEGER,"ipxCircSysInstance",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,2,0xffffffff,0xffffffff},15,INTEGER,"ipxCircIndex",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,3,0xffffffff,0xffffffff},15,INTEGER,"ipxCircExistState",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		/* Srikar, Mar 17, 1997. Changed the access level from READ_ONLY to READ_WRITE for ipxCircOperState. */
		{{PRIVATE_MIB,23,2,5,2,1,1,4,0xffffffff,0xffffffff},15,INTEGER,"ipxCircOperState",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,5,0xffffffff,0xffffffff},15,INTEGER,"ipxCircIfIndex",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,6,0xffffffff,0xffffffff},15,STRING,"ipxCircName",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,7,0xffffffff,0xffffffff},15,INTEGER,"ipxCircType",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		/* Srikar, Mar 19, 1997. Changed the access level from READ_ONLY to READ_WRITE for ipxCircDialName. */
		{{PRIVATE_MIB,23,2,5,2,1,1,8,0xffffffff,0xffffffff},15,STRING,"ipxCircDialName",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,9,0xffffffff,0xffffffff},15,INTEGER,"ipxCircLocalMaxPacketSize",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,10,0xffffffff,0xffffffff},15,INTEGER,"ipxCircCompressState",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,11,0xffffffff,0xffffffff},15,INTEGER,"ipxCircCompressSlots",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,12,0xffffffff,0xffffffff},15,INTEGER,"ipxCircStaticStatus",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,13,0xffffffff,0xffffffff},15,COUNTER,"ipxCircCompressedSent",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,14,0xffffffff,0xffffffff},15,COUNTER,"ipxCircCompressedInitSent",READ_ONLY,
			TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,15,0xffffffff,0xffffffff},15,COUNTER,"ipxCircCompressedRejectsSent",READ_ONLY,
			TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,16,0xffffffff,0xffffffff},15,COUNTER,"ipxCircUncompressedSent",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,17,0xffffffff,0xffffffff},15,COUNTER,"ipxCircCompressedReceived",READ_ONLY,
			TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,18,0xffffffff,0xffffffff},15,COUNTER,"ipxCircCompressedInitReceived",READ_ONLY,
			TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,19,0xffffffff,0xffffffff},15,COUNTER,"ipxCircCompressedRejectsReceived",
			READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,20,0xffffffff,0xffffffff},15,COUNTER,"ipxCircUncompressedReceived",READ_ONLY,
			TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,21,0xffffffff,0xffffffff},15,INTEGER,"ipxCircMediaType",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the type of ipxCircNetNumber from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,2,1,1,22,0xffffffff,0xffffffff},15,STRING,"ipxCircNetNumber",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,23,0xffffffff,0xffffffff},15,COUNTER,"ipxCircStateChanges",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,24,0xffffffff,0xffffffff},15,COUNTER,"ipxCircInitFails",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,25,0xffffffff,0xffffffff},15,COUNTER,"ipxCircDelay",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,26,0xffffffff,0xffffffff},15,COUNTER,"ipxCircThroughput",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,2,1,1,27,0xffffffff,0xffffffff},15,STRING,"ipxCircNeighRouterName",READ_ONLY,
			TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the type of ipxCircNeighInternalNetNum from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,2,1,1,28,0xffffffff,0xffffffff},15,STRING,"ipxCircNeighInternalNetNum",READ_ONLY,
			TRUE,get_ipx_mib_variable},

		{{PRIVATE_MIB,23,2,5,3,1,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},19,INTEGER,"ipxDestSysInstance",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the of ipxDestNetNum type from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,3,1,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},19,STRING,"ipxDestNetNum",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,3,1,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},19,INTEGER,"ipxDestProtocol",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,3,1,1,4,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},19,INTEGER,"ipxDestTicks",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,3,1,1,5,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},19,INTEGER,"ipxDestHopCount",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,3,1,1,6,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},19,INTEGER,"ipxDestNextHopCircIndex",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,3,1,1,7,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},19,STRING,"ipxDestNextHopNICAddress",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the type of ipxDestNextHopNetNum from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,3,1,1,8,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},19,STRING,"ipxDestNextHopNetNum",READ_ONLY,TRUE,
			get_ipx_mib_variable},

/*	We do not support inclusion of STATIC ROUTES in our Routing Table for IPX */
/* So we comment out this portion */
#ifdef IPX_STATIC_ROUTING

		{{PRIVATE_MIB,23,2,5,3,2,1,1,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},25,INTEGER,
			"ipxStaticRouteSysInstance",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,3,2,1,2,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},25,INTEGER,
			"ipxStaticRouteCircIndex",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the type of ipxStaticRouteNetNum from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,3,2,1,3,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},25,STRING,
			"ipxStaticRouteNetNum",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,3,2,1,4,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},25,INTEGER,
			"ipxStaticRouteExistState",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 19, 1997. Commented the following ipxDestHopCount since it is repeated and not correct here. */
		/* Also modified the object-id's of ipxStaticRouteTicks and ipxStaticRouteHopCount since the id's were not correct. */
	/*	{{PRIVATE_MIB,23,2,5,3,2,1,5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},25,INTEGER,
			"ipxDestHopCount",READ_ONLY,TRUE,get_ipx_mib_variable},*/
		{{PRIVATE_MIB,23,2,5,3,2,1,5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},25,INTEGER,
			"ipxStaticRouteTicks",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,3,2,1,6,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},25,INTEGER,
			"ipxStaticRouteHopCount",READ_ONLY,TRUE,get_ipx_mib_variable},
#endif /* IPX_STATIC_ROUTING */

		{{PRIVATE_MIB,23,2,5,4,1,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff},25,INTEGER,"ipxServSysInstance",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		/* Srikar, Mar 17, 1997. Changed the type of ipxServType from INTEGER to STRING. */
		{{PRIVATE_MIB,23,2,5,4,1,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff},25,STRING,"ipxServType",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,1,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff},25,STRING,"ipxServName",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,1,1,4,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff},25,INTEGER,"ipxServProtocol",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the type of ipxServNetNum from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,4,1,1,5,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff},25,STRING,"ipxServNetNum",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,1,1,6,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff},25,STRING,"ipxServNode",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		/* Srikar, Mar 17, 1997. Changed the type of ipxServSocket from INTEGER to STRING. */
		{{PRIVATE_MIB,23,2,5,4,1,1,7,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff},25,STRING,"ipxServSocket",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,1,1,8,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff},25,INTEGER,"ipxServHopCount",READ_ONLY,TRUE,
			get_ipx_mib_variable},

		{{PRIVATE_MIB,23,2,5,4,2,1,1,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			38,INTEGER,"ipxDestServSysInstance",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the type of ipxDestServNetNum from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,4,2,1,2,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			38,STRING,"ipxDestServNetNum",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,2,1,3,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			38,STRING,"ipxDestServNode",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 17, 1997. Changed the type of ipxDestServSocket from INTEGER to STRING. */
		{{PRIVATE_MIB,23,2,5,4,2,1,4,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			38,STRING,"ipxDestServSocket",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,2,1,5,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			38,STRING,"ipxDestServName",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 17, 1997. Changed the type of ipxDestServType from INTEGER to STRING. */
		{{PRIVATE_MIB,23,2,5,4,2,1,6,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			38,STRING,"ipxDestServType",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,2,1,7,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			38,INTEGER,"ipxDestServProtocol",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,2,1,8,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,
			0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff,0xffffffff},
			38,INTEGER,"ipxDestServHopCount",READ_ONLY,TRUE,get_ipx_mib_variable},

		/* This section is not supported by us (we do not allow static inclusion
		** of server names in our SAP table).
		*/
#ifdef IPX_STATIC_SERVERS
		{{PRIVATE_MIB,23,2,5,4,3,1,1,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,INTEGER,"ipxStaticServSysInstance",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,3,1,2,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,INTEGER,"ipxStaticServCircIndex",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,3,1,3,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,STRING,"ipxStaticServName",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 17, 1997. Changed the type of ipxStaticServType from INTEGER to STRING. */
		{{PRIVATE_MIB,23,2,5,4,3,1,4,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,STRING,"ipxStaticServType",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,3,1,5,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,INTEGER,"ipxStaticServExistState",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 15, 1997. Changed the type of ipxStaticServNetNum from IP_ADDRESS to STRING. */
		{{PRIVATE_MIB,23,2,5,4,3,1,6,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,STRING,"ipxStaticServNetNum",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,3,1,7,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,STRING,"ipxStaticServNode",READ_ONLY,TRUE,get_ipx_mib_variable},
		/* Srikar, Mar 17, 1997. Changed the type of ipxStaticServSocket from INTEGER to STRING. */
		{{PRIVATE_MIB,23,2,5,4,3,1,8,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,STRING,"ipxStaticServSocket",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,5,4,3,1,9,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,
			0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff,0xff},
			79,INTEGER,"ipxStaticServHopCount",READ_ONLY,TRUE,get_ipx_mib_variable},
#endif /* IPX_STATIC_SERVERS */
			/* rip sap mib */

		{{PRIVATE_MIB,23,2,20,1,1,1,1,0xffffffff},14,INTEGER,"ripSysInstance",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,1,1,1,2,0xffffffff},14,INTEGER,"ripSysState",READ_WRITE,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,1,1,1,3,0xffffffff},14,COUNTER,"ripSysIncorrectPackets",READ_ONLY,TRUE,get_ipx_mib_variable},

		{{PRIVATE_MIB,23,2,20,1,2,1,1,0xffffffff},14,INTEGER,"sapSysInstance",READ_ONLY,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,1,2,1,2,0xffffffff},14,INTEGER,"sapSysState",READ_WRITE,TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,1,2,1,3,0xffffffff},14,COUNTER,"sapSysIncorrectPackets",READ_ONLY,TRUE,get_ipx_mib_variable},

		{{PRIVATE_MIB,23,2,20,2,1,1,1,0xffffffff,0xffffffff},15,INTEGER,"ripCircSysInstance",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,1,1,2,0xffffffff,0xffffffff},15,INTEGER,"ripCircIndex",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,1,1,3,0xffffffff,0xffffffff},15,INTEGER,"ripCircState",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,1,1,4,0xffffffff,0xffffffff},15,INTEGER,"ripCircPace",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,1,1,5,0xffffffff,0xffffffff},15,INTEGER,"ripCircUpdate",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,1,1,6,0xffffffff,0xffffffff},15,INTEGER,"ripCircAgeMultiplier",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,1,1,7,0xffffffff,0xffffffff},15,INTEGER,"ripCircPacketSize",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,1,1,8,0xffffffff,0xffffffff},15,INTEGER,"ripCircOutPackets",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,1,1,9,0xffffffff,0xffffffff},15,INTEGER,"ripCircInPackets",READ_ONLY,TRUE,
			get_ipx_mib_variable},

		{{PRIVATE_MIB,23,2,20,2,2,1,1,0xffffffff,0xffffffff},15,INTEGER,"sapCircSysInstance",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,2,0xffffffff,0xffffffff},15,INTEGER,"sapCircIndex",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,3,0xffffffff,0xffffffff},15,INTEGER,"sapCircState",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,4,0xffffffff,0xffffffff},15,INTEGER,"sapCircPace",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,5,0xffffffff,0xffffffff},15,INTEGER,"sapCircUpdate",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,6,0xffffffff,0xffffffff},15,INTEGER,"sapCircAgeMultiplier",READ_WRITE,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,7,0xffffffff,0xffffffff},15,INTEGER,"sapCircPacketSize",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,8,0xffffffff,0xffffffff},15,INTEGER,"sapCircGetNearestServerReply",READ_WRITE,
			TRUE,get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,9,0xffffffff,0xffffffff},15,INTEGER,"sapCircOutPackets",READ_ONLY,TRUE,
			get_ipx_mib_variable},
		{{PRIVATE_MIB,23,2,20,2,2,1,10,0xffffffff,0xffffffff},15,INTEGER,"sapCircInPackets",READ_ONLY,TRUE,
			get_ipx_mib_variable}
#endif
	};

#else

	#ifdef __MSDOS__
		GLOBAL VARIABLE	far	variables[];
	#else
		GLOBAL VARIABLE	variables[];
	#endif

#endif /* GLOBAL_FILE */

