#include	<defs.h>

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include	<stdarg.h>
#include <udb.h>

#include	"telnet.h"
#include	"ksocket.h"
#include	"menu.h"
#include	"dialout.h"
#include	<vnvrmstr.h>


#include <serial.h>
#include <uartmode.h>
#include <wanmgr.h>
#include "..\..\stacks\ip\kdns.h" 

/*sudhir new change */
extern ULONG get_ip_address(USHORT);

extern ULONG str_to_net (BYTE *);
extern void *malloc (ULONG) ;
extern int get_index_to_udb_record (char *user_name);
/* Sudha 23 June 1998 */
#if 0
extern enum TEST get_ip_address_from_name (BYTE *domain_name, USHORT port_number, void (*fptr_complete_routine)(ULONG *, USHORT,USHORT, enum DNS_STATE));
#endif

extern ULONG check_if_ip_addr (BYTE *ip_str);

/* sudhir new change */
extern void	WriteToPort(USHORT port_number, char *String, USHORT count);


void change_state_to_ipaddr_obtained (ULONG IPAddr, USHORT port_number, enum DNS_STATE status);
BYTE *net_to_str (BYTE *Addr, ULONG Address);

#define CRETN '\r'
#define BSPACE '\b'


const char tc_invalid_server_address[] = 
"\n\r\n\rInvalid Server Address!!!\n\r\
\n\rEnter Server Address : ";    

char tc_resolving_domain_name[] =
"\n\r\n\rResolving domain name   %s ......";

/* sudhir 26/6/97 */
const char tc_dns_failed[] = "\n\r\n\rHost Name Unknown!!!";

const char tc_disconnect_message[] = "\n\n\n\rDisconnected from server\n\r" ;
/* sudhir 16/6/97 */
const char tc_connect_message[] = "\n\n\n\rConnecting to server  %s ....." ;
const char tc_connect_message_name[] = "\n\n\n\rConnecting to server %s (%s) .....";

const char tc_ip_address_prompt[] = "\n\n\rEnter Server Address: ";
const char tc_connect_failed[]="\n\r\n\rConnect Failed ";

BYTE term_serv_info_buffer[NUMBER_OF_WAN_PORTS][50];
BYTE dup_term_serv_info_buffer[NUMBER_OF_WAN_PORTS][50];

/* sudhir 16/6/97 */
USHORT domain_name_received[NUMBER_OF_WAN_PORTS];

USHORT recv_buffer_index[NUMBER_OF_WAN_PORTS];



void terminate_telnet_client (TELNET_CLIENT_CLASS *client_info_ptr) ;
void (*rx_complete)(USHORT, BYTE *, USHORT) ;
void tx_complete (USHORT port_number, BYTE *handle, BYTE *tx_buffer)
{
   TELNET_CLIENT_CLASS *client_info_ptr = (TELNET_CLIENT_CLASS *)handle ;

   if ((strncmp (tx_buffer, tc_disconnect_message, strlen (tc_disconnect_message)) == 0) || (strncmp (tx_buffer, tc_connect_failed, strlen (tc_connect_failed)) == 0) || 
		(strncmp (tx_buffer, tc_dns_failed, strlen (tc_dns_failed)) == 0) || (strncmp (tx_buffer, CloseCnx, strlen (CloseCnx)) == 0))
   {
      printf ("Terminal Server : Freeing port %d from use\n", client_info_ptr->port_used_by_client) ;
      free_serial_port_from_use (client_info_ptr->port_used_by_client) ;
      set_wan_port_owner (client_info_ptr->port_used_by_client, OWNED_BY_NONE) ;
		if (client_info_ptr->connect_to_ourself != TRUE)
	      close_connection (client_info_ptr);
		else
		{
			closesocket(client_info_ptr->socket_num);
/* printf("\n\rCLIENT1: in_use is false."); */

			client_info_ptr->in_use = 0;
			telnet.num_of_connected_clients--;
		}	
   }
   free (tx_buffer) ;
   return ;
}



enum BOOLEAN is_valid_name_or_ip_address (BYTE *rcvd_name_buffer)
{
   
   while (*rcvd_name_buffer)
   {
      if (*rcvd_name_buffer != ' ' && *rcvd_name_buffer != '\t')
         return TRUE;
      rcvd_name_buffer++;
   }         
   return FALSE;
}


void process_recv_buffer (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *sptr_buffer, int length)
{					 
	BYTE *ptr_to_rcvd_ip, *temp_ptr;
   USHORT port_number = client_info_ptr->port_used_by_client ;

      	
	ptr_to_rcvd_ip = (BYTE *) malloc (length);
	if (ptr_to_rcvd_ip == NULL)
		return;

   /* echo */
   if (client_info_ptr->client_state == WAITING_FOR_PASSWORD)
      memset (ptr_to_rcvd_ip, '*', length) ;
   else
	   memcpy (ptr_to_rcvd_ip, sptr_buffer, length);

   serial_tx_packet (port_number, ptr_to_rcvd_ip, length, APPLICATION) ;

	while ((length > 0) && (length < 50))
	{
		switch (*sptr_buffer)
		{
		 	case CRETN:
            switch (client_info_ptr->client_state)
            {
               case (WAITING_FOR_USER_NAME) :
                  term_serv_info_buffer[port_number][recv_buffer_index[port_number]] = 0;
                  validate_username_and_process (client_info_ptr);
                  recv_buffer_index[port_number] = 0 ;
                  break ;

               case (WAITING_FOR_PASSWORD) :
                  term_serv_info_buffer[port_number][recv_buffer_index[port_number]] = 0;                  
/*                  valid_user_password_and_process (client_info_ptr); */
                  recv_buffer_index[port_number] = 0 ;
                  break ;

               case (WAITING_FOR_IP_ADDRESS) :
                  client_info_ptr->client_state = TS_IDLE ;
                  term_serv_info_buffer[port_number][recv_buffer_index[port_number]] = 0 ;
                  recv_buffer_index[port_number] = 0 ;

/*                  printf ("%15s\n", term_serv_info_buffer[port_number]) ; */
/* sudhir 16/6/97 */

                  if (is_valid_name_or_ip_address (term_serv_info_buffer[port_number]) == FALSE)
                  {
                     temp_ptr = (BYTE *) malloc (strlen (tc_invalid_server_address)) ;
                     if (temp_ptr != NULL)
                     {
                        memcpy (temp_ptr, tc_invalid_server_address, strlen (tc_invalid_server_address)) ;
                        serial_tx_packet (client_info_ptr->port_used_by_client, temp_ptr, strlen (tc_invalid_server_address), APPLICATION) ;
                     }
                     client_info_ptr->client_state = WAITING_FOR_IP_ADDRESS;
                     return;

                  }

                  if (check_if_ip_addr (term_serv_info_buffer[port_number]) == 0)
                  {
                     domain_name_received[port_number] = 1;
                     strcpy (dup_term_serv_info_buffer[port_number],term_serv_info_buffer[port_number]);
                     temp_ptr = (BYTE *) malloc (strlen (tc_resolving_domain_name)+ strlen (term_serv_info_buffer[port_number]) + 5 ) ;
                     if (temp_ptr != NULL)
                     {
                        sprintf (temp_ptr, tc_resolving_domain_name, term_serv_info_buffer[port_number]) ;
                        serial_tx_packet (client_info_ptr->port_used_by_client, temp_ptr, strlen (temp_ptr), APPLICATION) ;
                     }
                  }

/* Sudha 23 June 1998 */
/* Commenting this temporarily since this is not used anywhere now.Later if we
are using this, be careful to pass correct parameters in fptr_complete_routine
(i.e.,)change_state_to_ipaddr_obtained function in get_ip_address_from_name
function as I have changed the parameter types in that function */
#if 0                                          
/* sudhir 19/3/97 */
                  if (get_ip_address_from_name (term_serv_info_buffer[port_number], port_number, change_state_to_ipaddr_obtained ) == FAIL)
                  {
                     printf ("resolving failed\n");
                     client_info_ptr->client_state = TS_IDLE;
                  } 
#endif
                  break ;
            }
				break;

			case BSPACE:
				recv_buffer_index[port_number]--;
				break;

			default:
            term_serv_info_buffer[port_number][recv_buffer_index[port_number]] = *sptr_buffer;
            recv_buffer_index[port_number]++;
				break;
		}
		if (*sptr_buffer == '\r')
		{
/*			printf ("%15s\n", term_serv_info_buffer[port_number]) ; */
		}
		*sptr_buffer++;
		length--;
	}
}

BYTE *net_to_str (BYTE *Addr, ULONG Address)
{
   sprintf(Addr,"%03u.%03u.%03u.%03u",(((int)(Address >> 24)) & 0xff),
		(((int)(Address >> 16)) & 0xff), (((int)(Address >> 8)) & 0xff),
		(((int)(Address)) & 0xff));

   return Addr;
}

void change_state_to_ipaddr_obtained (ULONG IPAddr, USHORT port_number, enum DNS_STATE status)
{
   BYTE temp_buff[25];
   USHORT i=0;
   TELNET_CLIENT_CLASS *connection_ptr;
	BYTE *temp_ptr;

   connection_ptr = telnet.clients_info;

   for (i = 0 ; i < telnet.max_telnet_connections ; i++,connection_ptr++)
   {
      if (connection_ptr->port_used_by_client == port_number)
         break;
   }
   
   if (status == RESOLVED)
   {
      net_to_str (temp_buff, IPAddr);
      strcpy (term_serv_info_buffer[port_number], temp_buff);
      printf ("IP Addr is %s\n",term_serv_info_buffer[port_number]); 
      connection_ptr->client_state = IP_ADDRESS_OBTAINED;
   }
   else
   {
      connection_ptr->client_state = TS_IDLE;
      free_serial_port_from_use (connection_ptr->port_used_by_client) ;
      set_wan_port_owner (connection_ptr->port_used_by_client, OWNED_BY_NONE) ;
/* printf("\n\rCLIENT2: in_use is false."); */

		connection_ptr->in_use = 0;
   }
}

enum BOOLEAN send_packet_to_specific_telnet_server (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer, USHORT buffer_size)
{
   BYTE *quote_buf_ptr, *src_ptr, *dst_ptr;
   int i, new_length = 0 ;

/* 9 March 1999.This var is introduced newly in serial_rx_complete for 
getting the status of tcp send call, used mainly for ag application & nothing 
to do with this application.So simply pass 1 in place of this var in 
rx_complete call. */

	USHORT send_status = 1;
	
   quote_buf_ptr = malloc (buffer_size * 2);
   if (quote_buf_ptr == NULL)
   {
      printf ("Not enough memory to quote the packet received on WAN\n");
      return FALSE ;
   }
   src_ptr = buffer;
   dst_ptr = quote_buf_ptr;
   new_length = buffer_size;
   
   for (i = 0 ; i < buffer_size ; i++, src_ptr++, dst_ptr++)
   {
      *dst_ptr = *src_ptr;
      if (*src_ptr == TCIAC)
      {
         dst_ptr++;
         *dst_ptr = TCIAC;
         new_length++;
      }
   }

/*   printf ("Packet of size %d quoted to %d and sent on Telnet port\n",
            buffer_size, new_length, client_info_ptr->port_used_by_client); */

   send_telnet_packet (client_info_ptr, quote_buf_ptr, new_length, 0) ;

   free (quote_buf_ptr); 

   (*rx_complete) (client_info_ptr->port_used_by_client, buffer, send_status) ;

   return (TRUE) ;
}

/* sudhir new change */

void start_our_telnet_server (TELNET_CLIENT_CLASS *client_info_ptr)
{
/*	options_negotiate (client_info_ptr); */
	client_info_ptr->start_our_server = TRUE;
	welcome_to_telnet(client_info_ptr);
}

void open_and_init_socket (TELNET_CLIENT_CLASS *client_info_ptr)
{
   ULONG IPAddress;
   int socket_no;
	USHORT port_number = client_info_ptr->port_used_by_client ;
   BYTE *temp_ptr ;
   BYTE temp_buff[25];

   if (client_info_ptr->client_state != IP_ADDRESS_OBTAINED)
      return ;


    
   if (telnet.term_server_port[client_info_ptr->port_used_by_client].telnet_server_address != 0x00000000L 
        && telnet.term_server_port[client_info_ptr->port_used_by_client].telnet_server_address != 0xffffffff)
   {
      IPAddress = telnet.term_server_port[client_info_ptr->port_used_by_client].telnet_server_address;
/*      printf ("WRONG is %lu\n",IPAddress); 
      net_to_str (temp_buff, IPAddress);
      printf ("Rcvd IpAddr is %s\n",temp_buff);  */
   }
   else
   if (telnet.telnet_server_ip_address != 0x00000000L && telnet.telnet_server_ip_address != 0xffffffff)
   {
/*		printf ("Main server addres\n");*/
      IPAddress = telnet.telnet_server_ip_address;
/*		net_to_str (temp_buff, IPAddress);
      printf ("Rcvd IpAddr is %s\n",temp_buff);  */
   }
   else
	{
/*		printf ("Resolved IP Address is %s\n",term_serv_info_buffer[port_number]); */
      IPAddress = str_to_net (term_serv_info_buffer[port_number]);
	}


   socket_no = socket (AF_INET, SOCK_STREAM, 0x00000000L);
   if (socket_no == FAILED)
   {
      printf ("Socket Call Failed\n");   
      return;
   }

	if (initialize_client (client_info_ptr, socket_no))
	{  
		telnet.num_of_connected_clients++;

		client_info_ptr->stClientAddr.sin_family = AF_INET;
		client_info_ptr->stClientAddr.sin_addr.s_addr = IPAddress;
		client_info_ptr->stClientAddr.sin_port = IPPORT_TELNET ;
		client_info_ptr->port_used_by_client = port_number ;
		client_info_ptr->socket_num = socket_no;

      client_info_ptr->client_state = CONNECT_TO_SERVER;
      client_info_ptr->in_use_by_terminal_server = TRUE ;

		
/* sudhir 16/6/97 */

		/* sudhir new change */

		if (IPAddress == get_ip_address (0))
		{
			tel_printf (TELNET_ALARM,"TELNET: Connecting to Router Telnet server\n");
			client_info_ptr->connect_to_ourself = TRUE;
			client_info_ptr->echoing = TRUE;
			start_our_telnet_server (client_info_ptr);
			return;
		}				

      net_to_str (temp_buff, IPAddress);

      if (domain_name_received[client_info_ptr->port_used_by_client])
      {
         domain_name_received[client_info_ptr->port_used_by_client] = 0;         
         temp_ptr = (BYTE *) malloc (strlen (tc_connect_message_name) + strlen (dup_term_serv_info_buffer[client_info_ptr->port_used_by_client]) + strlen (temp_buff) + 5) ;
         if (temp_ptr != NULL)
         {
            sprintf (temp_ptr, tc_connect_message_name, dup_term_serv_info_buffer[client_info_ptr->port_used_by_client],temp_buff) ;
            serial_tx_packet (client_info_ptr->port_used_by_client, temp_ptr, strlen (temp_ptr), APPLICATION) ;
         }
      }
      else
      {
         temp_ptr = (BYTE *) malloc (strlen (tc_connect_message) + strlen (temp_buff) + 5) ;

         if (temp_ptr != NULL)
         {
            sprintf (temp_ptr, tc_connect_message, temp_buff) ;
            serial_tx_packet (client_info_ptr->port_used_by_client, temp_ptr, strlen (temp_ptr), APPLICATION) ;
         }
      }
	}
	else
   {
		close_connection (client_info_ptr); 
   }
}

extern int initialize_port_for_terminal_server (TELNET_CLIENT_CLASS *) ;

int init_terminal_server (USHORT port_number)
{
	TELNET_CLIENT_CLASS *client_info_ptr ;
	BYTE *temp_ptr ;

   if (!telnet.term_server_port[port_number].termser_enabled)
      return -1;
      
/*	printf ("Init terminal server is called\n"); */
   recv_buffer_index[port_number] = 0 ;
   term_serv_info_buffer[port_number][0] = 0;

	client_info_ptr = get_free_client_entry () ;
	if (client_info_ptr == NULL)
	{
		return (-1) ;
	}
	client_info_ptr->in_use_by_terminal_server = TRUE ;
	client_info_ptr->force_close = FALSE ;
	client_info_ptr->in_use = TRUE ;
	client_info_ptr->port_used_by_client = port_number ;

	set_wan_port_owner (client_info_ptr->port_used_by_client, OWNED_BY_TERMINAL_SERVER) ;


	initialize_port_for_terminal_server (client_info_ptr) ;

   
   if (telnet.term_server_port[client_info_ptr->port_used_by_client].telnet_server_address != 0x00000000L 
        && telnet.term_server_port[client_info_ptr->port_used_by_client].telnet_server_address != 0xffffffff)
   {
      client_info_ptr->client_state = IP_ADDRESS_OBTAINED;
   }
   else
   if (telnet.telnet_server_ip_address != 0x00000000L && telnet.telnet_server_ip_address != 0xffffffff)
   {
      client_info_ptr->client_state = IP_ADDRESS_OBTAINED;
   }
   else
   {
      temp_ptr = (BYTE *) malloc (strlen (tc_ip_address_prompt)) ;
      if (temp_ptr != NULL)
      {
         memcpy (temp_ptr, tc_ip_address_prompt, strlen (tc_ip_address_prompt));
         serial_tx_packet (client_info_ptr->port_used_by_client, temp_ptr, strlen (tc_ip_address_prompt), APPLICATION) ;
         client_info_ptr->client_state = WAITING_FOR_IP_ADDRESS;
      }
   }
}

void negotiate_options_with_server (TELNET_CLIENT_CLASS *client_info_ptr)
{
/* for no go aheads */
   client_info_ptr->option_cmd = TCWILL;
   do_noga (client_info_ptr, TONOGA);

/* for echoing */
   client_info_ptr->option_cmd = TCWONT;
   do_echo (client_info_ptr, TOECHO);

}

void connect_to_server (TELNET_CLIENT_CLASS *client_info_ptr)
{
	ULONG socket_error;
   BYTE *temp_ptr;
   USHORT port_number = client_info_ptr->port_used_by_client;
	
/*	printf ("Calling connect\n"); */

	if (connect (client_info_ptr->socket_num, &client_info_ptr->stClientAddr, sizeof (SOCKADDR_IN)) == FAILED)
	{
		lsl_control(RESOLVE_SOCKET_API, APPLICATION_LAYER_TYPE, (ULONG)GET_SOCKET_ERROR_VALUE, (ULONG) SOCKETS_INTERFACE, (ULONG) &socket_error);
		if (socket_error != WOULD_BLOCK_ERROR)
		{
			temp_ptr = malloc (strlen (tc_connect_failed)) ;
      	if (temp_ptr == NULL)
	      {
/* printf("\n\rCLIENT3: in_use is false."); */

	      	client_info_ptr->in_use = FALSE ;
	      	return  ;
      	}
         memcpy (temp_ptr, tc_connect_failed, strlen (tc_connect_failed)) ;
   	   serial_tx_packet (client_info_ptr->port_used_by_client, temp_ptr, strlen (tc_connect_failed), APPLICATION) ; 
			client_info_ptr->client_state = TS_IDLE ;
		}
      else
      {
         tel_printf (TELNET_ALARM,"TELNET:Connect failed\n");
		}
	}
	else
	{
 		client_info_ptr->client_state = CONNECTED_TO_SERVER;
      negotiate_options_with_server (client_info_ptr);
	}
}

void packet_received (USHORT port_number, BYTE *handle, BYTE *buffer, USHORT buffer_size)
{
   TELNET_CLIENT_CLASS *client_info_ptr = (TELNET_CLIENT_CLASS *)handle ;

/* 9 March 1999.This var is introduced newly in serial_rx_complete for 
getting the status of tcp send call, used mainly for ag application & nothing 
to do with this application.So simply pass 1 in place of this var in 
rx_complete call. */

	USHORT send_status = 1;

   telnet.term_server_port[client_info_ptr->port_used_by_client].number_of_wan_pkts_rcvd++;
	switch (client_info_ptr->client_state)
	{
		case (CONNECTED_TO_SERVER) :
         telnet.term_server_port[client_info_ptr->port_used_by_client].number_of_lan_pkts_forwarded++;
			send_packet_to_specific_telnet_server (client_info_ptr, buffer, buffer_size);
			break ;

/* sudhir new change */
		
		case (CONNECT_TO_SERVER):
			if (client_info_ptr->connect_to_ourself == TRUE && client_info_ptr->in_use == TRUE)
			{
 				socket_in (client_info_ptr, buffer,	buffer_size);
				break;
			}

		case (WAITING_FOR_IP_ADDRESS) :
			process_recv_buffer (client_info_ptr, buffer, buffer_size);
			(*rx_complete) (port_number, buffer, send_status) ;
			break ;

      case (WAITING_FOR_USER_NAME) :
			process_recv_buffer (client_info_ptr, buffer, buffer_size);
			(*rx_complete) (port_number, buffer, send_status) ;
			break ;

      case (WAITING_FOR_PASSWORD) :
			process_recv_buffer (client_info_ptr, buffer, buffer_size);
			(*rx_complete) (port_number, buffer, send_status) ;
			break ;

		default :
			(*rx_complete) (port_number, buffer, send_status) ;
			break ;
	}
}


int initialize_port_for_terminal_server (TELNET_CLIENT_CLASS *client_info_ptr)
{

/* sudhir 16/6/97 */

   domain_name_received[client_info_ptr->port_used_by_client] = 0;   

   if (setup_serial_port_for_use (client_info_ptr->port_used_by_client,
      (BYTE *)client_info_ptr,
      tx_complete,
      packet_received,
      &rx_complete,
      get_wan_configured_baud_rate (client_info_ptr->port_used_by_client), EIGHT_DATA, NONE, ONE_STOP) == FAIL)
      return (0) ;

   return (1) ;
}


void terminal_server_timer ()
{
   int i ;
   TELNET_CLIENT_CLASS *client_info_ptr ;
   
   for (i = 0 ; i < telnet.max_telnet_connections ; i++)
   {
      client_info_ptr = &telnet.clients_info[i] ;

      if ((client_info_ptr->in_use == FALSE) ||
          (client_info_ptr->force_close == TRUE))
         continue ;

      if (!client_info_ptr->in_use_by_terminal_server)
         continue ;

		if (client_info_ptr->client_state == TS_IDLE)
			continue;

		if (client_info_ptr->client_state == IP_ADDRESS_OBTAINED)
      {
/*         printf ("open and init socket\n"); */
			open_and_init_socket (client_info_ptr) ;
      }
		else
		{
			if (client_info_ptr->client_state == CONNECT_TO_SERVER && client_info_ptr->connect_to_ourself != TRUE)
			{
		   	connect_to_server (client_info_ptr);
		   	continue ;
			}
			else
			{
      		if (is_dcd_present (client_info_ptr->port_used_by_client))
         		continue ;

      		printf ("Terminal Server : Freeing port %d from use\n", client_info_ptr->port_used_by_client) ;
      		free_serial_port_from_use (client_info_ptr->port_used_by_client) ;
      		set_wan_port_owner (client_info_ptr->port_used_by_client, OWNED_BY_NONE) ;
            client_info_ptr->in_use_by_terminal_server == FALSE;
/*            number_of_name_retries[client_info_ptr->port_used_by_client] = 0;
            number_of_password_retries[client_info_ptr->port_used_by_client] = 0; */
            if (client_info_ptr->client_state == CONNECTED_TO_SERVER)
      		   close_connection (client_info_ptr) ;
            else
				{
/* printf("\n\rCLIENT4: in_use is false."); */

               client_info_ptr->in_use = FALSE;
				}
   		}
		}
	}
}


void terminate_telnet_client (TELNET_CLIENT_CLASS *client_info_ptr)
{
   char *temp_buff ;

/*   printf ("TS : Closing Telnet connection on port %d\n",
            client_info_ptr->port_used_by_client) ; */

   temp_buff = (char *) malloc (strlen (tc_disconnect_message)) ;
   if (temp_buff != NULL)
   {
      memcpy (temp_buff, tc_disconnect_message, strlen (tc_disconnect_message)) ;
      serial_tx_packet (client_info_ptr->port_used_by_client, temp_buff, strlen (tc_disconnect_message), APPLICATION) ;
   }
   else
      printf ("Not enough memmory to send disconnect message\n");
}





