/*
** Modifications : sudha 15-Oct-1999. Added 2 new parameters in the function
**						 urg_callback() & slight change in that function.
**						 Taken from ras tcp bug fixes.	
*/

#include	<defs.h>
#include	"telnet.h"

/****************************************************************************
	Routine		: tcdm
	Input			: Index to TELNET structure corresponding to this connection.
					  	Character - not used.
	Synopsis		: Decrements the counting flag when a DM is received. DM is
						an indication of end of URGent data.
****************************************************************************/

/* received DATA MARK */
USHORT	tcdm(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	if (client_info_ptr->synching)
		client_info_ptr->synching--;
	return 1;
}

/****************************************************************************
	Routine		: urg_callback
	Input			: skt : Socket number on which URGent data has been received.
	Synopsis		: Called by TCP to indicate that a TELNET 'Synch' has been 
						received on 'skt'. Increments a counting flag .
	Changes		: sudha 15-Oct-1999.Taken from ras tcp code. 
	Comments		: Added two more parameters urgent_offset and urgent_length.
						As far as telnet goes this should not make any diff.
						11th March 1997.

****************************************************************************/

/* sudha 15-Oct-1999. Added 2 more parameters */
void	urg_callback(int skt, ULONG urgent_offset,USHORT urgent_length)
{
	USHORT	index;
	TELNET_CLIENT_CLASS	*connection_ptr = telnet.clients_info;

/* sudha 15-Oct-1999.Taken from ras tcp code... */

	PARAMETER_NOT_USED(urgent_offset);
	PARAMETER_NOT_USED(urgent_length);

/* ...sudha 15-Oct-1999.Taken from ras tcp code */
	
	for( index = 0; index < telnet.max_telnet_connections; index++,connection_ptr++) {
		if ((connection_ptr->in_use) && (connection_ptr->socket_num == skt)) { 
			connection_ptr->synching++;
			break;
		}
	}
}		

