#include	<defs.h>
#include	"telnet.h"

/****************************************************************************
	Routine		: do_termtype
	Input			: Index to TELNET structure corresponding to this connection.
						Character received.
	Synopsis		: Response/Request for TERM-TYPE option considering the 
						conditions in RFC854. 
****************************************************************************/

USHORT	do_termtype(TELNET_CLIENT_CLASS *client_info_ptr, BYTE character)
{
	USHORT			i=0;

	if (client_info_ptr->termtype) {
		if (client_info_ptr->option_cmd == TCWILL)
			return 1;
	} else if (client_info_ptr->option_cmd == TCWONT)
			return 1;

	client_info_ptr->termtype = !client_info_ptr->termtype;

	telnet.tx_buffer[i++] = TCIAC;
	if (client_info_ptr->termtype)
		telnet.tx_buffer[i++] = TCDO;
	else
		telnet.tx_buffer[i++] = TCDONT;

	telnet.tx_buffer[i++] = character;
	return (send_telnet_packet(client_info_ptr, telnet.tx_buffer, i, 0));
}


