#ifndef _TEL_KTEL_
#define _TEL_KTEL_
/* sudhir 28/2/97 */
#define CONNECT_TO_SERVER 1
#define CONNECTED_TO_SERVER 2
#define WAITING_FOR_IP_ADDRESS 3
#define IP_ADDRESS_OBTAINED 4
#define WAITING_FOR_USER_NAME 5
#define WAITING_FOR_PASSWORD 6
#define TS_IDLE  7
/* sudhir 28/2/97 */


#define	TERMINAL_NAME	41
#define	MAX_PASSWORD_TRIES	3
#define	TELNET_NAME_SIZE		48

#define	MAX_BYTES_PER_SCREEN	2048

/* Increase this below value only if you increase in (CHAT code KCHAT.H). */
#define MAX_CHAR_BUFFER_SIZE	1024 * 2

/* Below constant should be <= above constant (MAX_CHAR_BUFFER_SIZE). It does
** not make sense to have this larger than the TCP receive window size.
*/
#define	MAX_TCP_PKT				1024


/* TELNET Command Codes */

#define	TCSB				(BYTE)250		/* Start Subnegotiation */
#define	TCSE				(BYTE)240		/* End Subnegotiation */
#define	TCNOP				(BYTE)241		/* No Operation */
#define	TCDM				(BYTE)242		/* Data Mark for Synch */
#define	TCBRK				(BYTE)243		/*	NVT Character Break */
#define	TCIP				(BYTE)244		/*	Interrupt Process */
#define	TCAO				(BYTE)245		/* Abort Output */
#define	TCAYT				(BYTE)246		/* Are You There */
#define	TCEC				(BYTE)247		/*	Erase Character */
#define	TCEL				(BYTE)248		/*	Erase Line */
#define	TCGA				(BYTE)249		/*	Go-Ahead */
#define	TCWILL			(BYTE)251		/*	Desire/Confirm Will Do Option */
#define	TCWONT			(BYTE)252		/*	Refusal To Do Option */
#define	TCDO				(BYTE)253		/*	Request To Do Option */
#define	TCDONT			(BYTE)254		/*	Request Not To Do Option */
#define	TCIAC				(BYTE)255		/*	Interpret As Command Escape */

/* TELNET Option Codes */

#define	TOTXBINARY		(BYTE)0		/* TRANSMIT-BINARY option */
#define	TOECHO			(BYTE)1		/* ECHO option */
#define	TONOGA			(BYTE)3		/* Suppress Go-Ahead option */
#define	TOTIMINGMARK	(BYTE)6		/* Timing Mark option for synch */
#define	TOTERMTYPE		(BYTE)24		/* Terminal-Type option */


/* NVT Special Characters */
#define	VPLF				'\n'				/* Line Feed */
#define	VPCR				'\r'				/* Carriage Return */
#define	VPBS				'\b'				/* Back Space */

/* Option Subnegotiation Constants */
#define	TT_IS				0					/* TERMINAL_TYPE option IS command */
#define	TT_SEND			1					/* TERMINAL_TYPE option SEND command */


#define	TESCAPE			27


/* Telnet Socket-Input FSM States */

#define	TSDATA				0		/* normal data processing */
#define	TSIAC					1		/* seen IAC */
#define	TSWOPT				2		/* seen IAC-(WILL/WONT) */
#define	TSDOPT				3		/* seen IAC-(DO/DONT) */
#define	TSSUBNEG				4		/* seen IAC-SB */
#define	TSSUBIAC				5		/* seen IAC-SB-...-IAC */

#define	NSTATES				6

/* Telnet Option Subnegotiation FSM States */
#define	SS_START				0		/* initial state */
#define	SS_TERMTYPE			1		/* TERMINAL-TYPE option subnegotiation */
#define	SS_TERMNAME			2		/* receiving terminal name */
#define	SS_END				3		/* state after all legal input */

#define	NSSTATES				4

#define	FSINVALID			0xff	
#define	NCHRS					256
#define	TCANY					(NCHRS+1)



/* TCP message type */
#define	MSG_OOB				0x01		/* out-of-band data */


/* printf groups */
enum TELNET_PRINTF_GROUPS
{
	TELNET_RXTX,
	TELNET_ALARM
};

#endif


