#ifndef _TEL_MENU_
#define _TEL_MENU_
#define TELNET_CLIENT_MENU 255

#define NOT_PORT_PARAMETER     100

#define MAX_NUM_OF_PORTS 16

#define MAX_ENTRIES_PER_PAGE            10
#define PUNCT_NUM_LEN                   25 /* mod by oss on 21-3-97 */


/* sudha 08 June 1999 */
#define MAX_TCP_APPLICATIONS     43
#define MAX_UDP_APPLICATIONS     42

#define IP_ID			0
#define IPX_ID			1
#define STP_ID			2
#define PPP_ID			3
#define WAN_ID			4
#define TELNET_ID		5
#define FRAME_ID		6
#define MUX_ID			7
#define DHCP_ID		8
#define AG_ID			9
#define CCP_ID			10
#define CIPX_ID		11
#define VJC_ID			12
#define TFTP_ID		13
#define CHAT_ID      14
#define SLIP_ID      15

#define DIAL_OUT_TYPE 0
#define DIAL_IN_TYPE 1
#define DIAL_OUT_IN_TYPE 2

/* Menu Level -1 (super menu) */
#define DIALOUT_MODE       1  /* Sudha 11 Feb 1998 */
#define PROXY_MANAGEMENT   2  
#define MODIFY_CONFIG      3
#define WAN_CONFIG         4
#define REMOTE_UDB         5

#define PROXY_STATISTICS   1
#define PROXY_SYSTEM_INFO  2
#define RESET_PROXY_OPTION 3

#define PRX_PROXY_SERVER_STATISTICS  1
#define PRX_TCP_IP_STATISTICS        2
#define PRX_MAC_STATISTICS           3
#define PRX_WAN_STATISTICS           4
#define PRX_PPP_STATISTICS           5

#define PROXY_IP_STATISTICS          1
#define PROXY_TCP_STATISTICS         2
#define PROXY_ARP_STATISTICS         3
#define PROXY_RARP_STATISTICS        4
#define PROXY_ICMP_STATISTICS        5
#define PROXY_UDP_STATISTICS         6

 
#define MOD_WAN_PORT_ENABLE             1
#define MOD_WAN_PORT_MODE    	        2
#define MOD_WAN_PORT_CONNECTION_METHOD  3
#define MOD_WAN_PORT_CONNECTION_MODE    4
#define MOD_WAN_PORT_FUNCTION_TYPE      5
#define SCRIPT_EN                       6
#define SCRIPT_RESTART                  7
#define MOD_WAN_PORT_OTHERS    	        8
#define MOD_WAN_PORT_LINK_USAGE_CONTROL 9



#define MOD_WAN_BAUD_RATE  1
/* Menu Level 0 */

/* sudhir 23-11-96 */

#define MOD_PROTO_STK   		1
#define MOD_HLDD        		2
#define MOD_LLDD        		3
#define MOD_APPLICATION 		4
#define MOD_PROXY_SERVER      5
#define MOD_DHCP_SERVER_INFO  6
#define MOD_NAT_MAPPING_INFO  7


#define TFTP_STATUS    1
#define TELNET_STATUS  2

#define DTTY_STATUS    1

#define AG_STATUS      1
#define AG_SERVER_NAME 2
#define AG_PORTINFO    3 

#define MOD_AG_GENNAME  1
#define MOD_AG_SPECNAME 2
#define MOD_AG_IDLETIME 3

/* Sudha 17 Feb 1998 */
#define NAT_GLOBAL             1
#define NAT_MAPPING            2

#define NAT_STATIC_GLOBAL      1
#define NAT_STATIC_LOCAL       2  

#define NAT_GLOBAL_START_ADDR  1
#define NAT_GLOBAL_END_ADDR    2
#define NAT_GLOBAL_SUBNET_MASK 3

#define NAT_STATIC_MAPPING       1
#define NAT_DYNAMIC_MAPPING      2

#define NAT_DYNAMIC_GLOBAL       1
#define NAT_DYNAMIC_LOCAL        2
#define NAT_DYNAMIC_PROTOCOL     3
#define NAT_DYNAMIC_PORT         4

#define PROXY_ANY_APP            1 /* sudha 18 Nov 1998 */
/* sudha 18 Aug 1999 */
#define PROXY_FTP_CTRL_PORT      2
#define PROXY_FTP_DATA_PORT      3
#define PROXY_APP_INFO           4
#define PROXY_FILTER_INFO        5

#define PROXY_SOURCE_ADDR_FILTER 3
#define PROXY_DEST_ADDR_FILTER   1
#define PROXY_APP_FILTER         5
#define PROXY_MAC_ADDR_FILTER    4
#define PROXY_DNS_ADDR_FILTER    2
 
/* Sudha 17 Feb 1998 */

#define PROXY_PROTOCOL_PORT    1
#define PROXY_APPLICATION_PORT 2

/* sudha 19 Jan 1999 */
#define PROXY_USER_LOWER_PORT    2
#define PROXY_USER_HIGHER_PORT   3
#define PROXY_USER_DESCRPTN      4


#define TERMS_STATUS     1
#define TERMS_SERV_ADDR  2


/* Menu Level 1 - PROTOCOL STACKS */
#define MODIFY_IP    1
#define MOD_SNMP     2

#define MODIFY_PPP    1
/* #define MODIFY_FRM_RELAY 2       KVSP */
#define MODIFY_SLIP    2
#define MOD_HLDDEXIT  4


#define TEL_SLIP    1
#define TEL_CSLIP   2
#define SLIP_MTU    3


#define  MODIFY_WAN  	1

/* Menu Level 1 - CHAT MODE ON WAN PORT */
#define CHAT_PORT_1     1
#define CHAT_PORT_2     2
#define CHAT_PORT_3     3
#define CHATEXIT        4

#define  IPX_ENABLE    	1
#define  IPX_AUTOLEARN  2
#define  IPX_RTR_NAME   3
#define  IPX_NW_NUMBER  4
#define  IPX_DEF_FILT_ACTION 5
#define  IPX_PORT_INFO   6


#define	IP_GEN_INFO	1
#define	IP_PORT	 	2 /* Sudha 11 June 1998 */
#define  IP_STATIC_ROUTES 3

#if 0
#define IP_DEFAULT_TTL    1
#define IP_DEFAULT_GWAY   2
#define IP_REAS_TIMOUT    3
#endif

#define IP_DHCP_INFO      1
#define IP_DNS_INFO       2

#define  MOD_DNS_ROOT_ADDR 1
#define  MOD_DNS_LOCAL_ADDR 2
 

/* Menu Level 2 - SNMP */
#define SNMP_AGT                1
#define SNMP_STAT               2
#define SNMP_EXIT               3

#define STP_BRIDGING_ENABLE   1
#define STP_ALGORITHM_ENABLE  2
#define STP_DEFAULT_ACTION    3
#define STP_PORT_INFO         4
#define STP_FILTERS           5

#define STP_PORT_SETUP        1
#define STP_PORT_STATS        2

#define  IPX_PORT_SETUP    1
#define  IPX_PORT_STATS   2

#define MOD_STP_PORT_STATE      1
#define MOD_STP_ROOT_PATHCOST   2

/* Menu Level 2 - PPP */
#define  PPP_MAX_CONF_REQ       1
#define  PPP_MAX_TERM_REQ       2
#define  PPP_MAX_UNACKECH_REQ   3
#define  PPP_MAX_CONF_REQ_SENDI 4
#define  PPP_MAX_TERM_REQ_SENDI 5
#define  PPP_MAX_ECHO_REQ_SENDI 6
#define  PPP_MAX_CONF_REQ_BACKO 7
#define  MULTI_PPP              8
#define  PPP_NEED_TO_DIAL_OUT   9 /* sudha 18 Nov 1998 */
#define  PPP_PORT_INFO          10


#define  MOD_IPX_PORT_STATE          1
#define  MOD_IPX_FRAME_TYPE          2
#define  MOD_NETBIOS                 3
#define  MOD_IPX_MAX_NUM_HOPS        4
#define  MOD_IPX_RIP_TX_TIME         5
#define  MOD_IPX_RIP_AGE_TIMER       6
#define  MOD_IPX_RIP_TRANSPORT_TIME  7
#define  MOD_IPX_SAP_TX_TIME         8 
#define  MOD_IPX_SAP_AGE_TIMER       9
#define  MOD_IPX_PERIODIC_RIP       10
#define  MOD_IPX_PERIODIC_SAP       11
#define  MOD_IPX_DISCARD_PACKETS    12
#define  MOD_IPX_WATCHDOG_SPOOFING  13
#define  MOD_SPX_WATCHDOG_SPOOFING  14
#define  MOD_IPX_PORT_NWNUMBER      15
#define  IPX_FILTERS                16


#define IPX_FILT_NET                1
#define IPX_FILT_NODE               2
#define IPX_FILT_SOCK               3
#define IPX_FILT_PORT               4
#define IPX_FILT_TYPE               5

#define IPX_LAN     1
#define IPX_WAN1    2
#define IPX_WAN2    3
#define IPX_WAN3    4

#define MOD_WAN_PORT_CLOCKING  				1
#define MOD_WAN_PORT_CLOCK_SPEED				2
#define MOD_WAN_PORT_SEND_IDLE_FLAGS		3

#define MOD_WAN_PORT_BAUDRATE					1
#define MOD_WAN_PORT_MODEM_TYPE				2

/* Sudha 13 Feb 1998 */
#define MOD_WAN_PORT_DOD_ENABLE           1
#define MOD_WAN_PORT_DOD_HANG             2
#define MOD_WAN_PORT_LINK_NUM_CONNECTIONS 3   
#define MOD_WAN_PORT_LINK_NUM_HOSTS       4
#define MOD_WAN_PORT_LINK_HOST_ENTRY      5


#define MOD_WAN_PORT_ISDN_CONFIG_NAME          2
#define MOD_WAN_PORT_ISDN_SWITCH_TYPE          3
#define MOD_WAN_PORT_ISDN_DATA_SPID_ISDN_NUM   4
#define MOD_WAN_PORT_ISDN_VOICE_SPID_ISDN_NUM  5
#define MOD_WAN_PORT_ISDN_DATA_DIR_SUB_NUM     6
#define MOD_WAN_PORT_ISDN_VOICE_DIR_SUB_NUM    7

#define BK_BAUD      1
#define BK_MODEM     2
#define BK_DIAL_NO   3
#define BK_PRIORITY  4

#define  MOD_IP_SUBNETMASK   1
#define  MOD_IP_NODE_ADDRESS 2
#define  MOD_IP_RAS_ADDR     3


#define  MOD_DHCP    			1
#define  MOD_DHCP_SER_IP_ADD 	2

#define  MOD_PPP_PORT_ENABLE  			1
#define  MOD_PPP_PORT_DATACOMP  			2
#define  MOD_PPP_PORT_VJC_HC     		3
#define  MOD_PPP_PORT_DIAL_NO          4
#define  MOD_PPP_PORT_AUTH_TYPE        5
#define  MOD_PPP_PORT_USER_NAME   		6
#define  MOD_PPP_PORT_USER_PWD    		7
#define  MOD_PPP_PORT_TIMER	    		8
#define  MOD_PPP_PORT_RETRIES    		9


#define MODIFY_TFTP_SERVER   1
#define MODIFY_TELNET_SERVER 2
#define MODIFY_WEB_SERVER    3 
#define MODIFY_AG_SERVER	  4
#define MODIFY_DTTY          5
#define MODIFY_PASSWORD      6


#define EDIT_USR_NAME  1
#define EDIT_USR_PWD   2
#define EDIT_USR_CB    3
#define EDIT_USR_CBS   4
#define EDIT_CBN       5
#define EDIT_CBD       6
#define EDIT_USR_IP    7

#define MUX_PORT_ENABLE                 1
#define MUX_PORT_PROTOCOL               2
#define MUX_PORT_MODE                   3
#define MUX_PORT_OTHERS                 4

#define MUX_PORT_1              	1
#define MUX_PORT_2              	2
#define MUX_LINK_STATS  			3
#define MUX_PORT_NONE   			4

#define FR_ENABLE                1
#define MGMT_TYPE                2
#define DLCI_CONF                3
#define MGMT_PARAMETERS         	4

#define DLCI_Number              1
#define DLCI_IP_Address         	2
#define DLCI_IPX_Network         3
#define DLCI_STP_Port            4
#define DLCI_CIR                 5
#define DLCI_Be                  6
#define DLCI_Mode                7

/* oss on 4-3-97 */

#define         MUX_CLOCKING            1
#define         MUX_SPEED               2
#define         MUX_BETWEEN_FRAMES      3
#define         MUX_ENCODING_SCHEME     4
#define         MUX_INTERFRAME_TIMER    5

#define         MUX_BAUDRATE            1
#define         MUX_WORDLENGTH          2
#define         MUX_PARITY              3
#define         MUX_STOPBITS            4
#define         MUX_FLOWCONTROL         5
#define         MUX_PACING              6
#define         MUX_XOFF_1stCHAR        7
#define         MUX_PASSXON             8
#define         MUX_ECHO                9
#define         MUX_EIAPASSTHROUGH      10
#define         MUX_ENQACK              11
#define         MUX_COMPRESSION         12

#define  MGMT_N391                      1
#define  MGMT_N392                      2
#define  MGMT_N393                      3
#define  MGMT_T391                      4
#define  MGMT_T392                      5

#define STATIC_ROUTE_PORT               1
#define STATIC_ROUTE_ADDRESS            2
#define STATIC_ROUTE_GWAY               4
#define STATIC_ROUTE_SMASK              3
#define STATIC_ROUTE_METRIC             5

#define  STP_ETHER_ADDR         1
#define  STP_PORT_NUMBER        2
#define  STP_FILTER_TYPE        3

#define  DHCP_SER_ENABLED       1
#define  DHCP_ADDR_LIST         2

#define  DHCP_ADDR_LOWER_BOUND  1
#define  DHCP_ADDR_UPPER_BOUND  2
#define  DHCP_SERV_SNET_MASK    3
#define  DHCP_EXCLUDE_LOWER_BOUND 4
#define  DHCP_EXCLUDE_UPPER_BOUND 5

#define  IP_ADDRESS_TO_BIND      1
#define  MAC_ADDR_LENGTH         2
#define  MAPPED_MAC_ADDRESS      3

#define DHCP_ROUTER_ADDRESS 1
#define DHCP_DNS_SERVER   2
#define DHCP_DOMAIN_NAME  3
#define DHCP_REASSEMBLY_SIZE 4
#define DHCP_IP_TTL 5
#define DHCP_MTU 6
#define DHCP_TCP_TTL 7
#define DHCP_LEASE_TIME 8

#define TELNET_DHCP_OPTION_VALUE       1
#define TELNET_DHCP_OPTION_POSITION    2



/*************************** Menu State Machine *****************************/

#define TMS_SUPERMENU                   1                       /* Menu before main menu */

#define TMS_DIALOUT_USERNAME            2                       /* Prompt, validate user name */
#define TMS_DIALOUT_PASSWORD            3                       /* Validate password */
#define TMS_DIALOUT_ENTER               4                       /* Wait for <Enter> key */
#define TMS_DIALOUT_PORTCHOICE          5               /* Choice of WAN ports menu */
#define TMS_DIALOUT_DEFAULTS            6                       /* Defaults menu */

#define TMS_DIALOUT_MODEM_INIT          7                       /* Modem init in progress */
#define TMS_DIALOUT_CHAT                8                       /* Dialout in progress */
#define TMS_DIALOUT_BAUD                9                       /* Baud rate */
#define TMS_DIALOUT_DATABITS            10                      /* Data bits */
#define TMS_DIALOUT_PARITY              11                      /* Parity */
#define TMS_DIALOUT_STOPBITS            12                      /* Stop bits */
#define TMS_DIALOUT_MODEM_HUP   			 13                      /* Modem hangup in progress */
#define TMS_DIALOUT_ENTER2              14                      /* Wait for <Enter> key (2nd type) */
#define TMS_CHATPORT                    15
#define TMS_CHATMODE                    16

#define TMS_MODIFY_CONFIG       			 17
#define TMS_MODI_PROTOSTKS      			 18
#define TMS_MODI_HLDD           			 19
#define TMS_MODI_LLDD           			 20
#define TMS_MODI_APP                    21      
#define TMS_SYSINFO                     22

#define TMS_MODI_ETHER                  23

#define TMS_MODI_IPXMAIN        			 24
#define TMS_MODI_IPMAIN	                25
#define TMS_MODI_STPMAIN        			 26
#define TMS_SNMP_MAIN                   27

#define TMS_MODI_PPPMAIN        			 28
#define TMS_MODI_WAN            			 29
#define TMS_MOD_FRPARAMETERS            30

#define TMS_MODI_IP                     31
#define TMS_IP_MODIFY_MENU              32
#define TMS_MODI_IPPORT                 33
#define TMS_MODI_IPPORTINFO     			 34
#define TMS_MODI_UPD_IPPORTINFO         35

#define TMS_IPXPORTINFO                 37
#define TMS_IPX_DEL_FILT                38
#define TMS_IPX_STAT                    39
#define TMS_IPX_MODIFY_MENU     			 40
#define TMS_MODI_IPXPORT                41
#define TMS_MODI_IPXPORTINFO    			 42
#define TMS_MODI_UPD_IPXPORTINFO 		 43
#define TMS_IPX_FILT                    44
#define TMS_IPX_FILT_CHOICE             45
#define TMS_IPX_ADD_FILTERS             46
#define TMS_IPX_PORT_CHOICE             47

#define TMS_STP_MODIFY_MENU     			 48
#define TMS_MODI_STPPORT                49
#define TMS_MODI_STPPORTINFO    			 50
#define TMS_MODI_UPD_STPPORTINFO 		 51
#define TMS_STP_FILTERS                 52
#define TMS_STPPORT_INFO					 53
#define TMS_STPPORTSTAT                 54


#define TMS_PPP_MODIFY_MENU     			 56
#define TMS_MODI_PPPPORT        			 57
#define TMS_MODI_PPPPORTINFO    			 58
#define TMS_MODI_UPD_PPPPORTINFO 		 59
#define TMS_PPP_PORTINFO                60
#define TMS_PPPPORTSTAT                 61

#define TMS_MOD_FRMAIN                  62
#define TMS_MOD_DLCI                    63
#define TMS_ADD_DLCI                    64
#define TMS_DELETE_DLCI                 65

#define TMS_MAIN_NAT                    66
#define TMS_NAT_GLOBAL                  67
#define TMS_NAT_MAPPING                 68

#define TMS_MOD_FR_MGMT_PARA            69
#define TMS_MOD_DLCI_CONF               70
#define TMS_MOD_DLCI_OPTIONS            71
#define TMS_DLCI_SAVE_CHANGES   			 72

#define  TMS_MODI_WANPORTINFO   			 74
#define  TMS_MODI_UPD_WANPORTINFO 		 75
#define  TMS_WAN_PORTINFO               76
#define  TMS_WANPORTSTAT                77
#define  TMS_MODI_WAN_OTHER_OPTIONS 	 78
#define  TMS_MODI_SYNC_WANPORTINFO 		 79
#define  TMS_MODI_ASYNC_WANPORTINFO 	 80
#define  TMS_BACKUP_INFO                81
#define  TMS_UPD_BKUPPORT               82
#define  TMS_MODI_WAN_LINK_USAGE_CONTROL 83

#define  TMS_MODI_TFTPINFO              85
#define  TMS_MODI_TELNETINFO            86
#define  TMS_MODI_WEBINFO               87
#define  TMS_MODI_AGINFO                88
#define  TMS_TFTP_MODIFY_MENU   			 89
#define  TMS_TELNET_MODIFY_MENU         90
#define  TMS_AG_MODIFY_MENU     			 91
#define  TMS_AG_MODIFY_PORT     			 92
#define  TMS_MODI_AGPORTINFO    			 93
#define  TMS_MODI_UPD_AGPORTINFO 		 94
#define  TMS_WEB_MODIFY_MENU            95

#define  TMS_SAVE_CHANGES               97
#define  TMS_REBOOTROUTER               98
#define  TMS_RETRY_PASSWORD             99

#define  TMS_REMOTE_UDB                 101
#define  TMS_ADD_USERS                  102
#define  TMS_DELETE_USERS               103
#define  TMS_EDIT_USERS                 104

#define  TMS_NEXT_PAGE                  106
#define  TMS_SEND_EDIT_MENU             107
#define  TMS_USER_MODI_PARA             108
#define  TMS_SAVE_REMOTE_UDB            109
#define  TMS_REMOTE_RETRY               110
#define  TMS_WRITE_FLASH                111
#define  TMS_CONFIRM_DEL_MENU           112

#define  TMS_DHCP_MODI_PARA             115
#define  TMS_DHCP_UPD_PARA              116
#define  TMS_DNS_MODI_PARA              117
#define  TMS_DNS_UPD_PARA               118

#define TMS_MOD_DATAPORTS               120
#define TMS_MOD_PORT                    121
#define TMS_MOD_PORT_INFO               122
#define TMS_MOD_ASYNC_PORT              123
#define TMS_MOD_SYNC_PORT               124  
#define TMS_MOD_PORT_OTHER_OPTIONS      125

#define TMS_IP_DELETE_PORT              128
#define TMS_IPX_DELETE_PORT             129
#define TMS_STP_DELETE_PORT             130

#define TMS_IPSTAT                      131
#define TMS_IPTCP                       132
#define TMS_IPRIP                       133
#define TMS_IPARP                       134
#define TMS_IPRARP                      135
#define TMS_IPICMP                      136
#define TMS_IPUDP                       137

#define TMS_IPNW                        139
#define TMS_IPPORT                  	 140

#define TMS_IP_STATIC_RT                143
#define TMS_IP_ADD_ROUTE                144
#define TMS_IP_UPD_ROUTE                145
#define TMS_DELETE_STATIC_RT            146

#define TMS_SNMPAGT                     156
#define TMS_SNMPSTAT                    157

#define  TMS_STP_ADD_FILT               160
#define  TMS_STP_UPD_FILT               161
#define  TMS_STP_DEL_FILT               162

#define  TMS_TERMS_MENU                 163
#define  TMS_TERMS_MODIFY_MENU          164

#define  TMS_MOD_SLIP                   165
#define  TMS_SLIP_PORTINFO              166
#define  TMS_SLIP_UPD_MENU              167

#define TMS_MODI_DTTYINFO              168
#define TMS_DTTY_MODIFY_MENU           169

#define TMS_NULL_FUNC                  170
#define TMS_WRONG_VALUE                171

#define TMS_IPX_EDIT_FILTER            172
#define TMS_IP_EDIT_ROUTE              173

#define TMS_STP_EDIT_FILTER            176

#define TMS_MODIFY_RTR_PASSWORD        177
#define TMS_UPD_RTR_PASSWORD           178

#define TMS_CONFIRM_CLOSE              179
#define TMS_CONFIRM_CLIENT_ONLY        180

#define TMS_MODI_PROXY		       181
#define TMS_ADD_PROXY_APP              182
#define TMS_DELETE_PROXY_APP           183                 
#define TMS_EDIT_PROXY_APP             184
#define TMS_PROXY_UPD_APPLICATION		185
#define TMS_UPD_PROXY_PROTOCOL         186


#define TMS_MODI_DHCP_INFO 	                187
#define TMS_ADD_DHCP_ADDRESS           188
#define TMS_DHCP_UPD_ADDR_INFO         189
#define TMS_EDIT_DHCP_ADDRESS 			190
#define TMS_DELETE_DHCP_ADDRESS			191
#define TMS_BIND_DHCP_ADDRESS 			192
#define TMS_DHCP_OPTION_HDLR 				193
#define TMS_DHCP_DISPLAY_BIND_ADDRESS  194
#define TMS_ADD_DHCP_ADDRESS_BIND      195
#define TMS_REMOVE_DHCP_ADDRESS_BIND   196
#define TMS_UPD_BIND_ADDR_INFO         197
#define TMS_SELECT_OPTION_FOR_RANGE    198
#define TMS_DHCP_DISPLAY_OPTIONS       199
#define TMS_ADD_SELECTED_DHCP_OPTION   200
#define TMS_EDIT_SELECTED_DHCP_OPTION  201
#define TMS_DELETE_SELECTED_DHCP_OPTION 202
#define TMS_DHCP_OPTION_UPD_HDLR			 203
#define TMS_DISPLAY_PROXY_STATI			 204
#define TMS_DISPLAY_PORT_STATUS         205
#define TMS_PROXY_PORT_STAT_INFO        206
#define TMS_MODI_MAIN_DHCP              207
#define TMS_MODI_UPD_MAIN_DHCP          208 
#define TMS_PROXY_MANAGEMENT_MENU       210 
#define TMS_PROXY_STATISTICS_MAIN_MENU  211
#define TMS_TCP_IP_STATISTICS           212
#define TMS_MAC_STATISTICS              213
#define TMS_WAN_STATISTICS              214
#define TMS_PPP_STATISTICS              215
#define TMS_IP_SUB_STATISTICS           216

#define TMS_ADD_NAT_GLOBAL              221
#define TMS_UPD_NAT_GLOBAL              222
#define TMS_DEL_NAT_GLOBAL              223
#define TMS_DISP_STATIC_NAT             224
#define TMS_ADD_STATIC_NAT              225
#define TMS_UPD_STATIC_NAT              226
#define TMS_EDIT_STATIC_NAT             227
#define TMS_DEL_STATIC_NAT              228  

#define TMS_UPD_WAN_LINK_USAGE_CONTROL  229
#define TMS_WAN_PORT_LINK_HOST_ENTRY    230  
#define TMS_ADD_HOST_ADDR               231
#define TMS_DELETE_HOST_ADDR            232
#define TMS_UPD_HOST_ADDR               233

#define TMS_DISP_DYNAMIC_NAT            234
#define TMS_ADD_DYNAMIC_NAT             235
#define TMS_UPD_DYNAMIC_NAT             236
#define TMS_EDIT_DYNAMIC_NAT            237
#define TMS_DEL_DYNAMIC_NAT             238
#define TMS_APP_UPD_DYNAMIC             239

#define TMS_MAIN_PROXY                  240
#define TMS_PROXY_FILTERS               241   

#define TMS_PRXFILTSRC                  242
#define TMS_PRX_ADD_SRC_FILT            243
#define TMS_PRX_UPD_SRC_FILT            244
#define TMS_PRX_DEL_SRC_FILT            245
#define TMS_PRX_EDIT_SRC_FILT           246
#define TMS_MODI_UPD_PROX_APP           247

/* sudha 19 Jan 1999 for tcp/udp port range addition... */

#define TMS_UPD_PROXY_USER_PROTOCOL		248
#define TMS_UPD_PROXY_USER_PORT  		249

/* ...sudha 19 Jan 1999 for tcp/udp port range addition */

typedef struct {
	BYTE            *(*menuhdlr)(TELNET_CLIENT_CLASS *, BYTE *);            /* function handling the menu */
	BYTE            *menu;                          /* menu for current state */
	USHORT  parentstate;            /* parent state of current state */
/*      BYTE            *errormenu;     */              /* error menu for current state */
	USHORT  num_of_items;           /* number of items in the menu 
											used to display error-menu */
} menufsmtype;  


typedef struct {
	BYTE    ReplyStr[PUNCT_NUM_LEN];
} ReplyStrsType;

extern  ReplyStrsType   ReplyStrs[];
extern  menufsmtype     menufsmhdlr[];
extern  BYTE    *ChatEnd;
extern  BYTE    CloseCnx[];
extern  TELNET_CLIENT_CLASS     *ChatClientPtr;

/* All menu hdlrs modified by oss on 22-3-97 */
BYTE *super_menu_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_username_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_password_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_enter_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_port_choice(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_chat_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_baud_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_databits_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_parity_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_stopbits_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_config_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dialout_2nd_enter_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *modify_main_menu_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_protocol_stks_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_hldev_drvr_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_lldev_drvr_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *sysinfo_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *chat_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);


BYTE *modify_ipx_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ip_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_stp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *modify_ppp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_wan_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *frame_relay_conf_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *ip_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ip_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_modify_ip_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *ipx_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ipx_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ipx_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_modify_ipx_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *stp_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_stp_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_stp_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_modify_stp_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *ppp_modify_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ppp_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ppp_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_modify_ppp_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *frame_relay_conf_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *frame_relay_dlci_mod_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *frame_relay_dlci_add_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *frame_relay_dlci_delete_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *frame_relay_mgmt_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *frame_relay_dlci_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dlci_options_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dlci_save_changes_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *modify_wan_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_modify_wan_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_wan_port_other_options(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_wan_port_sync_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_wan_port_async_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *modify_wan_port_link_usage_control (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_wan_port_link_usage_control (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *display_wan_port_link_host_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_host_addr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_host_addr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *del_host_addr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);


BYTE *modify_applications_menu_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_tftp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_telnet_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_web_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ag_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *tftp_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *telnet_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *ag_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ag_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_AG_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_modify_ag_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *web_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *save_changes_to_prom (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *reboot_router_after_configuration (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *retry_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *users_menu_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *send_options_for_newuser (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
void *delete_udb_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *edit_udb_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *get_next_udb_page (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *send_edit_menu(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_user_parameters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *save_remote_udb_changes (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *retry_remote_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *save_changes_permanent (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *confirm_delete (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);


BYTE *modify_dhcp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *update_dhcp_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *mux_mod_data_ports_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *mux_mod_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *mux_mod_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *mux_mod_async_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *mux_mod_sync_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *port_other_options_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);


BYTE *ip_port_delete_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *ipx_port_delete_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *stp_port_delete_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

void back_to_normal_mode(TELNET_CLIENT_CLASS *client_info_ptr);

/* ---- added by oss on 28-3-97 General purpose functions ---- 
extern BYTE *get_lhs_str (ULONG, CONFIGURATION_TABLE);
extern void *get_profile_string ( BYTE *, ULONG, BYTE *);
extern void force_write_string (BYTE *, BYTE *, ULONG , BYTE *); */

BYTE *ipx_filt_db_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *recv_filter_choice (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_filters_to_ipx_fdb (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *ipx_port_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_ipx_port_choice_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE * delete_ipx_filter_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE	*ip_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*ip_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*ip_tcp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*ip_rip_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*ip_arp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*ip_rarp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*ip_icmp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*ip_udp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*ip_rip_table_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *ip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE  *display_static_routes (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *delete_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *display_stp_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE	*snmp_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *snmp_agt_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *snmp_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*modify_stp_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*stp_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE	*stp_port_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_stp_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_stp_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *delete_stp_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *ppp_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *ppp_port_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *lan_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *wan_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *wan_port_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *modify_dns_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *update_dns_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_terminals_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *terms_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *modify_bkup_port (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_bkup_port_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE	*modify_slip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_slip_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *slip_modify_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);


BYTE *modify_dtty_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dtty_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *null_function (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *wrong_value_function (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE	*ipx_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *display_ipx_filters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *te_edit_ipx_filter_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *te_edit_stp_filter (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *te_edit_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_router_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *update_router_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *confirm_close_connection (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *confirm_client_only (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *proxy_main_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *proxy_server_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_proxy_server_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_proxy_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *update_proxy_application_port (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *delete_proxy_server_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *te_edit_proxy_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE *proxy_filt_db_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *display_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *te_edit_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *delete_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

/* Sudha 19 March 1998 */
BYTE *dhcp_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *modify_dhcp_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr,BYTE *buffer);
/* Sudha 19 March 1998 */

BYTE *dhcp_server_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_dhcp_address_information (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_dhcp_addrress_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *delete_dhcp_server_address_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *edit_dhcp_server_address_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *get_dhcp_binding_tag_index (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *display_dhcp_address_bindings (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dhcp_addr_option_handler (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *delete_dhcp_server_address_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_dhcp_address_bind_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *update_bind_address_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *delete_dhcp_addr_bind_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dhcp_select_option_to_address(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *dhcp_display_options_for_address(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *delete_selected_dhcp_option (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *add_selected_dhcp_option_to_address (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *upd_selected_dhcp_option_to_address (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *edit_selected_dhcp_option_to_address (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *send_proxy_server_general_statistics (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *send_proxy_server_port_statstics (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *display_port_status_and_option (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

/* sudha 18 Nov 1998 */
BYTE *proxy_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
/* sudha 18 Nov 1998 */

/* Sudha 12 Feb 1998 */
BYTE *proxy_management_main_menu ( TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *proxy_statistics_main_menu ( TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *display_ip_statistics ( TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *display_ip_sub_statistics ( TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *send_the_wan_ports_for_management ( TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
/* Sudha 12 Feb 1998 */

/* Sudha 17 Feb 1998 */
BYTE    *NAT_main_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_global_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_global_addr_add(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_global_addr_upd(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer); 
BYTE    *NAT_global_addr_del(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE    *NAT_static_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_edit_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_del_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_add_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_upd_static_entry_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

BYTE    *NAT_dynamic_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr,BYTE *buffer);
BYTE    *NAT_edit_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_del_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_add_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *NAT_upd_dynamic_entry_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE    *update_nat_dynamic_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);

/* sudha 19 Jan 1999... */
BYTE *update_proxy_user_application_protocol (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
BYTE *update_proxy_user_application_port (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer);
/* ...sudha 19 Jan 1999 */

#endif


