#include <defs.h>
#include <kstart.h>
#include <v8022str.h>
#include <vethstr.h>
#include <lslproto.h>   

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
/*#include <stddef.h>	  */


#include	"telnet.h"
#include	"vmenu.h"

#include <incall.h>
#include <cfgmgr.h>



const BYTE ProperChoiceApp[]=
"\n\r\
\n\r\
Invalid Choice!\n\r\
\n\r\
Enter your choice (1, exit or ESC to Previous menu) : ";

extern BYTE ChoiceBuffer[80];

extern int modify_config_visited;

extern void	generate_no_of_ports_strings(int no_of_ports, int section_id);



BYTE *modify_applications_menu_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
		return (menufsmhdlr[client_info_ptr->menustate].menu);

	switch ( atoi(buffer))
	{
		case MODIFY_TFTP_SERVER:
			client_info_ptr->menustate = TMS_MODI_TFTPINFO;
			break;

		case MODIFY_TELNET_SERVER:
			client_info_ptr->menustate = TMS_MODI_TELNETINFO;
			break;

/* Sudha 21 Feb 1998 */      
      case MODIFY_WEB_SERVER:
         client_info_ptr->menustate = TMS_MODI_WEBINFO;
			break;

/* Sudha 31 May 1999 */      
      case MODIFY_AG_SERVER:
         client_info_ptr->menustate = TMS_MODI_AGINFO;
			break;

      case MODIFY_DTTY:
         client_info_ptr->menustate = TMS_MODI_DTTYINFO;
         break;

/* sudhir 16/6/96 */
      case MODIFY_PASSWORD:
         client_info_ptr->menustate = TMS_MODIFY_RTR_PASSWORD;
         break;
   
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



BYTE *modify_dtty_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_TELNET_SECTION, (void *) &telnet.dumb_tty_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0],
				10);				

		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0],				
			GoBack, EnterSingleChoice);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer);

	if (client_info_ptr->modify_option_rcvd == DTTY_STATUS)  
	{
		client_info_ptr->menustate = TMS_DTTY_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, ProperChoiceApp, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *dtty_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *lhs_para_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case DTTY_STATUS:
				ret_str = EnaOrDis;
				break;

			default:
				sprintf(telnet.tx_buffer, ProperChoiceApp, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case DTTY_STATUS:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ; 
			
			switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.dumb_tty_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	client_info_ptr->menustate = TMS_MODI_DTTYINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_tftp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_TFTP_SECTION, (void *) &tftp.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0],
				10);				

		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0],				
			GoBack, EnterSingleChoice);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer);

	if (client_info_ptr->modify_option_rcvd == TFTP_STATUS)  
	{
		client_info_ptr->menustate = TMS_TFTP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, ProperChoiceApp, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *tftp_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *lhs_para_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case TFTP_STATUS:
				ret_str = EnaOrDis;
				break;

			default:
				sprintf(telnet.tx_buffer, ProperChoiceApp, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case TFTP_STATUS:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ; 
			
			switch (set_parameter (CM_TFTP_SECTION, (void *) &tftp.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	client_info_ptr->menustate = TMS_MODI_TFTPINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_telnet_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		get_parameter (CM_TELNET_SECTION, (void *) &telnet.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);				

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0]);

		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if (client_info_ptr->modify_option_rcvd == 1)  
	{
		client_info_ptr->menustate = TMS_TELNET_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, ProperChoiceApp, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *telnet_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case 1:	
				ret_str = EnaOrDis;
				break;

		}
		return (ret_str);
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case 1:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ;
			switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
	}
	client_info_ptr->menustate = TMS_MODI_TELNETINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

/* Sudha 21 Feb 1998 */
BYTE *modify_web_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_WEB_SECTION, (void *) &web.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);				

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			&ReplyStrs[0].ReplyStr[0]);

		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if (client_info_ptr->modify_option_rcvd == 1)  
	{
		client_info_ptr->menustate = TMS_WEB_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, ProperChoiceApp, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *web_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case 1:	
				ret_str = EnaOrDis;
				break;

		}
		return (ret_str);
	}

	switch (client_info_ptr->modify_option_rcvd)
	{
		case 1:
			new_value = atoi (buffer);
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ;
			switch (set_parameter (CM_WEB_SECTION, (void *) &web.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
	}
	client_info_ptr->menustate = TMS_MODI_WEBINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* Sudha 21 Feb 1998 */

BYTE *modify_ag_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_AG_SECTION, (void *) &ag.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				
/* printf("\n\rAg enabled is %s",ReplyStrs[0].ReplyStr);*/

		get_parameter (CM_AG_SECTION, (void *) &ag.server_name,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 10);				
/* printf("\n\rAg Server name is %s",ReplyStrs[1].ReplyStr); */
		
		sprintf (ChoiceBuffer, EnterChoice,
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0],
				&ReplyStrs[1].ReplyStr[0],
				GoBack, ChoiceBuffer);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;

	if (client_info_ptr->modify_option_rcvd <= AG_PORTINFO &&
   	client_info_ptr->modify_option_rcvd >= 1)  
	{
		client_info_ptr->menustate = TMS_AG_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *ag_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case  AG_STATUS:	ret_str = EnaOrDis;
									break;

			case  AG_SERVER_NAME:	ret_str = NewValue;
									break;

			case  AG_PORTINFO:
				client_info_ptr->menustate = TMS_AG_MODIFY_PORT;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	new_value = atoi (buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
		case AG_STATUS:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
   				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ;
			switch (set_parameter (CM_AG_SECTION, (void *) &ag.enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			} 
			break;

		case AG_SERVER_NAME:
			new_rhs = buffer;
         if ((strlen (buffer) > 15) || 
				(validate_alpha_numeric_underscore_name_and_convert_to_upper_case(buffer) == FALSE))
         {
            client_info_ptr->menustate = TMS_WRONG_VALUE;
            menufsmhdlr[TMS_WRONG_VALUE].parentstate = TMS_AG_MODIFY_MENU;

            return ("\n\r\Enter server name of length 15 ('A'-'Z', 'a'-'z', 0-9,_) : ");
         }

			modify_config_visited = 1 ;
			switch (set_parameter (CM_AG_SECTION, (void *) &ag.server_name,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			} 
			break;

		case AG_PORTINFO:
			client_info_ptr->menustate = TMS_AG_MODIFY_PORT;
			break; 
		
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
		   return(telnet.tx_buffer);
		}
	client_info_ptr->menustate = TMS_MODI_AGINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
			
BYTE	*modify_ag_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

	if (!buffer)
	{
			generate_no_of_ports_strings(telnet.number_of_ports  - 1, AG_ID);
			return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);	  

	if (port_number > (telnet.number_of_ports - 1) ||	port_number <= 0)
	{
      sprintf(telnet.tx_buffer, EnterProperChoice, telnet.number_of_ports-1);
		return(telnet.tx_buffer);
	}
 	client_info_ptr->menustate = TMS_MODI_AGPORTINFO;
	client_info_ptr->menu_selected_port = port_number - 1; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_AG_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int ag_inactivity_time;
   ULONG idle_time;

	ag_inactivity_time = ag.line_info_array[client_info_ptr->menu_selected_port].line_vars.idle_time /(20 * 60); 

	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.general_name,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				
/* printf("\n\rGeneral name is %s",ReplyStrs[0].ReplyStr); */

		get_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.specific_name,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 10);				
/* printf("\n\rSpecific name is %s",ReplyStrs[1].ReplyStr); */

		get_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.idle_time,
				client_info_ptr->menu_selected_port, CM_ULONG_FORMAT, &idle_time, 10);				

		sprintf (ChoiceBuffer, EnterChoice,
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu, 
			client_info_ptr->menu_selected_port+1,
			&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0], 
         idle_time,
			GoBack, ChoiceBuffer);

/*
			ag.line_info_array[client_info_ptr->menu_selected_port].line_vars.general_name,
			ag.line_info_array[client_info_ptr->menu_selected_port].line_vars.specific_name,
			ag_inactivity_time); */
		return (telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= MOD_AG_GENNAME) &&
		(client_info_ptr->modify_option_rcvd <= MOD_AG_IDLETIME))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_AGPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}

BYTE *upd_modify_ag_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str;
	ULONG new_value, port_no;
   BYTE *new_rhs;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
		 	case MOD_AG_GENNAME:
			case MOD_AG_SPECNAME:
			case MOD_AG_IDLETIME:  
            ret_str = NewValue;
				break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	port_no = client_info_ptr->menu_selected_port;
	new_value = atoi(buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_AG_GENNAME:
			new_rhs = buffer;
         if ((strlen (buffer) > 9) ||
				(validate_alpha_numeric_underscore_name_and_convert_to_upper_case(buffer) == FALSE))
         {
            client_info_ptr->menustate = TMS_WRONG_VALUE;
            menufsmhdlr[TMS_WRONG_VALUE].parentstate = TMS_MODI_AGPORTINFO;

            return ("\n\r\General name should be ('A'-'Z', 'a'-'z', 0-9,_) of length 9.\n\r\
				Enter exit or ESC to PREV menu : ");
         }

			switch (set_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.general_name,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
            case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			} 
			break;
			
		case MOD_AG_SPECNAME:
			new_rhs = buffer;
         if ((strlen (buffer) > 14) ||
				(validate_alpha_numeric_underscore_name_and_convert_to_upper_case(buffer) == FALSE))
         {
            client_info_ptr->menustate = TMS_WRONG_VALUE;
            menufsmhdlr[TMS_WRONG_VALUE].parentstate = TMS_MODI_AGPORTINFO;
            return ("\n\r\Specific name should be ('A'-'Z', 'a'-'z', 0-9,_) of length 14.\n\r\
				Enter exit or ESC to PREV menu : ");

         }

			switch (set_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.specific_name,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
            case CM_ERROR_WHILE_VALIDATING:
					return InvalidChoice;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			} 
			break;
		
		case MOD_AG_IDLETIME:
			new_rhs = buffer;
			if (new_value > 60 || new_value < 0)
				return("\n\r\Enter proper port idle time (0 - 60 mins ) : ");
			switch (set_parameter (CM_AG_SECTION, (void *) &ag.line_info_array[0].line_vars.idle_time,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			} 
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}

	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_MODI_AGPORTINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_terminals_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		get_parameter (CM_TELNET_SECTION, (void *) &telnet.terminal_server_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				

      get_parameter (CM_TELNET_SECTION, (void *) &telnet.telnet_server_ip_address_string[0],
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);				
		
		sprintf (ChoiceBuffer, EnterChoice,
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0],
            &ReplyStrs[1].ReplyStr[0],
				GoBack, ChoiceBuffer);
		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;

	if (client_info_ptr->modify_option_rcvd <= 2 &&
   	client_info_ptr->modify_option_rcvd >= 1)  
	{
		client_info_ptr->menustate = TMS_TERMS_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *terms_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs;
	ULONG new_value;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case  TERMS_STATUS:	
            ret_str = EnaOrDis;
				break;

         case TERMS_SERV_ADDR:
            ret_str = NewValue;
            break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	new_value = atoi (buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
		case TERMS_STATUS:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
   				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

			modify_config_visited = 1 ;
			switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.terminal_server_enabled,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
      
      case TERMS_SERV_ADDR:
         new_rhs = buffer;
         if (validate_ip_address (buffer) == FALSE)
            return InvalidIP;

         switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.telnet_server_ip_address_string,
			   CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
         {
            case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
		   return(telnet.tx_buffer);
		}
   client_info_ptr->menustate = TMS_TERMS_MENU;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
			

BYTE *modify_router_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE router_password[50], decrypted_pass[50];
   USHORT length;
   
   ReplyStrs[0].ReplyStr[0] = 0 ;

   get_parameter (CM_TELNET_SECTION, (void *) &telnet.password,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);				

	decrypt (&ReplyStrs[0].ReplyStr[0], &decrypted_pass[0]);

   length = strlen (&decrypted_pass[0]);
	if (length)
		memset(&router_password[0], (int)'*', length);  
	router_password[length] = 0;

   if (!buffer)
   {
      sprintf (telnet.tx_buffer, RouterPassword, router_password);
      return telnet.tx_buffer;
   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);

   if (client_info_ptr->modify_option_rcvd != 1)
   {
      sprintf(telnet.tx_buffer, ProperChoiceApp,1);
      return telnet.tx_buffer;
   }       
   else
   {
      client_info_ptr->menustate = TMS_UPD_RTR_PASSWORD;
      client_info_ptr->verifying_ppp_pwd = TRUE;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }      
}

BYTE *update_router_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{

   if (!buffer)
      return ("\n\rEnter Router Password :");

   client_info_ptr->verifying_ppp_pwd = FALSE;

   if (strlen (buffer) > 40)
   {
      return (wrong_pass);
   }

   switch (set_parameter (CM_TELNET_SECTION, (void *) &telnet.password,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, buffer))
   {
      case CM_NOT_ENOUGH_MEMORY:
   		return Insufficient_memory;
   }      
   client_info_ptr->menustate = TMS_MODIFY_RTR_PASSWORD;
   modify_config_visited = 1;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
