#include	<defs.h>

#include	<stdlib.h>
#include	<stdio.h>
#include <string.h>

#include	"telnet.h"
#include	"vmenu.h"

#include "..\..\stacks\ip\karp.h"
#include "..\..\stacks\ip\kip.h"
#include "..\..\stacks\ip\kipuser.h"
#include "..\..\stacks\ip\varpuser.h"
#include "..\..\stacks\ip\varpstr.h"
#include "..\..\stacks\ip\vrarpusr.h"
#include "..\..\stacks\ip\vrarpstr.h"
#include "..\..\stacks\ip\kroute.h"	  
#include "..\..\stacks\ip\viprtstr.h"	  
#include "..\..\stacks\ip\vipusstr.h"  
#include "..\..\stacks\ip\vsktstr.h"
#include "..\..\stacks\ip\kudp.h"
#include "..\..\stacks\ip\vipktstr.h"
#include "..\..\stacks\ip\kicmp.h"
#include "..\..\stacks\ip\vudpuser.h"
#include "..\..\stacks\ip\vudpbuf.h"
#include "..\..\stacks\ip\vudpstr.h"
#include "..\..\stacks\ip\krip.h"
#include "..\..\stacks\ip\vripstr.h"
#include "..\..\stacks\ip\vicmpstr.h"
#include "..\..\stacks\ip\viprastr.h"
#include "..\..\stacks\ip\vipstr.h" 

/*	sudhir 5-10-96 */
#include "..\..\stacks\ip\vip.h"
/* sudhir 5-10-96 */


#include <incall.h>
#include <cfgmgr.h>




extern int modify_config_visited;

PARAMETER_NODE *ptr_to_current_node;

#define	ICMP_PROTOCOL	  1
#define	TCP_PROTOCOL	  6
#define	UDP_PROTOCOL	  17
#define	ARP_PROTOCOL	  34
#define	IP_PROTOCOL		  35

extern	TCP_CLASS	tcp;
extern	IP_CLASS	ip;
extern   DHCP_CLASS dhcp;
extern 	int frame_relay_enabled;  	/* oss on 3-3-97 */
extern 	int no_of_ip_ports;			/* oss on 3-3-97 */

extern enum BOOLEAN dial_bkup_enabled; /* Sudha 12 Feb 1998 */
BYTE temp_str[200];

void force_write_string (BYTE *, BYTE *, ULONG , BYTE *);

/* sudhir 5-10-96 */
extern int toupper (int);
enum BOOLEAN is_default_route_valid (ULONG);
extern BYTE is_an_ip_address(BYTE* address);
extern BYTE is_valid_string_to_read_data(BYTE* buffer);
extern BYTE local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);
extern BYTE is_a_static_ip_address_mask(BYTE* address, BYTE* mask);
extern BYTE is_a_static_ip_address(BYTE* address, BYTE* mask);

/* sudhir */
extern BYTE *net_to_str (BYTE *Addr, ULONG Address);
extern BYTE *get_port_type (USHORT port_type);

/* sudha 18 Nov 1998 */
extern BYTE get_wan_port_function_type_cfg(USHORT port_number);

BYTE *get_ip_address_str (BYTE *buf, USHORT port_number);
int get_number_of_ip_ports();

void	generate_no_of_ip_ports_strings(int value);
void	initialize_values_of_new_ip_port();

void	generate_no_of_ports_strings(int no_of_ports, int section_id);
void	add_delete_values_of_ip_port(int Flag, int PortNo);

int num_of_ip_ports = 2;
/* added by oss on 28-3-97 */
#define OFFSET_TO_RHS 3
#define OFFSET_OF_PORT_STATS 5
#define PTR_TO_PORT_NO 2

PARA_STR *test_linked_list (PARA_STR *);

BYTE *to_upper_string (BYTE *);
ULONG str_to_net(BYTE *);

BYTE ChoiceBuffer[80];

STRUCT_STATIC_ROUTE temp_static_route;

extern BYTE is_an_ip_address(BYTE* address);
BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
extern BYTE  local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);

extern void  delete_string_from_linked_list(BYTE *str_to_delete, PARA_STR *start_addr);
extern void  modify_string_in_linked_list(BYTE *str_to_modify, ULONG OldPortNo, ULONG NewPortNo, PARA_STR *start_addr);
extern BYTE  *get_rhs_from_linked_list(BYTE *lhs_para_str, ULONG PortNo, PARA_STR *starting_addr);
extern BYTE  *get_rhs_for_disp (ULONG offset, CONFIGURATION_TABLE configuration_table, ULONG PortNo, PARA_STR *starting_addr);
extern void  set_rhs_in_link_list (ULONG offset, CONFIGURATION_TABLE configuration_table,
										ULONG PortNo, PARA_STR *starting_addr,
										BYTE *new_rhs);
extern PARA_STR *search_for_string (BYTE *lhs_para_str, BYTE *rhs_string, PARA_STR *start_addr);
extern void force_write_string_with_port_num (BYTE *, ULONG , BYTE *, PARA_STR *);
extern BYTE *copy_to_temp_struct(BYTE *buffer, BYTE *char_array);
extern BYTE *get_physical_port(USHORT port_number);

/* sudhir 5-10-96 */

BYTE *get_ip_port_type (USHORT port_type)
{
   switch ( telnet.model_number)
   {
      case MODEL_UNKNOWN :
         printf ( "\n\rModel Unknown.");
         break;
      case MODEL_MTSR3_200 :
      	switch (port_type) 
         {
		      case 0:	return ("Ethernet");
      		case 1: return ("WAN1");
      		case 2: return ("WAN2");
      		case 3: return ("WAN3");
		      default: return ("Unknown");
         }
         break;
      case MODEL_MTSR1_202ST :
         switch (port_type)
         {
            case 0: return ("Ethernet");
            case 1: return ("ISDN_ST");
            default:return ("Unknown");
         }
         break;
      case MODEL_MTSR1_202NT :
         switch (port_type)
         {
            case 0: return ("Ethernet");
            case 1: return ("ISDN_NT");
            default:return ("Unknown");
         }
         break;
      case MODEL_MTSR2_201 :
         switch (port_type)
         {
            case 0: return ("Ethernet");
            case 1: return ("WAN1(DSU)");
            case 2: return ("WAN2");
            default:return ("Unknown");
         }
         break;
      default :
         return ("Unknown");
         break;
	}
}


static BYTE * ip_protocol_string (USHORT_ENUM (IP_PORT_FILTER_PROTOCOL) protocol)
{
	switch (protocol) {
      case PROTOCOL_TCP:
		   return ("TCP");
      case PROTOCOL_UDP:
		   return ("UDP");
		default: return ("Unknown");
	}
}

BYTE *modify_dns_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();
   
      get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 20);				

      get_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address2",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);				


		sprintf (ChoiceBuffer, EnterChoice, 2);

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],
			GoBack, ChoiceBuffer);
			
		return (telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if ((client_info_ptr->modify_option_rcvd <= 2) && 
		(client_info_ptr->modify_option_rcvd >= 1))
	{
		client_info_ptr->menustate = TMS_DNS_UPD_PARA;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}

BYTE *update_dns_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs ;
	ULONG new_value, port_no;
 	
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_DNS_ROOT_ADDR:				
            ret_str = NewValue;
            break;

			case MOD_DNS_LOCAL_ADDR:
            ret_str = NewValue;
            break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}
	port_no = NOT_PORT_PARAMETER;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_DNS_ROOT_ADDR:
         new_rhs = buffer;			
         if (is_an_ip_address (buffer) == FALSE)
            return InvalidIP;

         switch (set_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address1",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_DNS_LOCAL_ADDR:
         new_rhs = buffer;
         if (is_an_ip_address (buffer) == FALSE)
            return InvalidIP;
         switch (set_parameter_by_name (CM_IP_SECTION, "IP DNS Server Address2",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;  

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
   client_info_ptr->menustate =  TMS_DNS_MODI_PARA;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* sudhir 22-9-96*/

BYTE *modify_dhcp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		initialize_replystr ();
		get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.bootp_enabled,
				0, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0], 10);				
      
		get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.server_ip_address,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);				

		sprintf (ChoiceBuffer, EnterChoice, 2);

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],
			GoBack, ChoiceBuffer);
			
		return (telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;
	if ((client_info_ptr->modify_option_rcvd >= 1) && 
		(client_info_ptr->modify_option_rcvd <= 
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_DHCP_UPD_PARA;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}

BYTE *update_dhcp_info (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str, *new_rhs,dhcp_addr[16] ;
	ULONG new_value, port_no;
 	
   get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.server_ip_address,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&dhcp_addr[0], 20);				

   
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_DHCP:				  
            if ( strcmp (dhcp_addr,"0.0.0.0") == 0)
            {
               strcpy(temp_str,"\n\r\DHCP server addr should be entered before enabling this.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               ret_str = temp_str;
            }
            else
            {         
               strcpy(temp_str,"\n\r\Make sure to enter DHCP server addr if you enable this.");
               strcat(temp_str,EnaOrDis);
               ret_str = temp_str;
            }
				break;

			case MOD_DHCP_SER_IP_ADD:	ret_str = NewValue;
												break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}
	port_no = NOT_PORT_PARAMETER;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case MOD_DHCP:
         if ( strcmp (dhcp_addr,"0.0.0.0") == 0)
         {
            strcpy(temp_str,"\n\r\DHCP server addr should be entered before enabling this.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
            return(temp_str);
         }
         else
         {
			   if (new_value == 1)
				   new_rhs = &telnet_enabled_str[0];
   			else
	   			if (new_value == 2)
		   			new_rhs = &telnet_disabled_str[0];
			   	else
				   	return (InvalidChoice);
			
   			switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.bootp_enabled,
	   			0, CM_STRING_FORMAT, new_rhs))
		   	{
			   	case CM_NOT_ENOUGH_MEMORY:
				   	return Insufficient_memory;
   			}
         }
			break;
      

		case MOD_DHCP_SER_IP_ADD:
			new_rhs = buffer;
         if (!is_an_ip_address(buffer) || (strcmp ( buffer,"0.0.0.0") == 0 ))
            return (InvalidIP);
			switch (set_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.server_ip_address,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_DHCP_MODI_PARA;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*ip_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer) 
		return (menufsmhdlr[client_info_ptr->menustate].menu);

 	switch (atoi(buffer)) 
   {
 		case IP_GEN_INFO:			
			client_info_ptr->menustate = TMS_MODI_IP;
			break;

 		case IP_PORT:				
			client_info_ptr->menustate = TMS_MODI_IPPORT;
			break;

		case IP_STATIC_ROUTES:
			client_info_ptr->menustate = TMS_IP_STATIC_RT;
			break;
			
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_ip_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE IP_defrt[] = "IP Default Route";
   BYTE ip_route[18];

	if (!buffer)
	{
#if 0
		initialize_replystr ();

		get_parameter (CM_IP_SECTION, (void *) &ip.mib.ipDefaultTTL ,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,(void *)&ReplyStrs[0].ReplyStr[0], 10);				

		get_parameter_by_name (CM_IP_SECTION, IP_defrt,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ip_route,18);				

      ip_route[strlen(ip_route)-2] = 0;
      strcpy(&ReplyStrs[2].ReplyStr[0],ip_route);

		get_parameter (CM_IP_SECTION, (void *) &ip.mib.ipReasmTimeout,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ReplyStrs[3].ReplyStr[0], 10);				
#endif
			
		sprintf (ChoiceBuffer, 	EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);

		sprintf (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			GoBack, ChoiceBuffer);

		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer) ;

	if ((client_info_ptr->modify_option_rcvd >= IP_DHCP_INFO) && 
		(client_info_ptr->modify_option_rcvd <= IP_DNS_INFO))
	{
		client_info_ptr->menustate = TMS_IP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	 }
}


BYTE *ip_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE  *ret_str, *new_rhs, *ptr_to_metric;
	ULONG  new_value;
	BYTE ip_defr[] = "IP Default Route";
   BYTE lan_addr[16],lan_mask[16];

	if(!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
/*			case IP_STATE:				
            ret_str = EnaOrDis;
				break; */

#if 0
			case  IP_DEFAULT_TTL:	
            strcpy( temp_str,"\n\rEnter New Value ( 1 to 255 ) : "); 
            ret_str = temp_str;
            break;

			case  IP_REAS_TIMOUT: 
	         strcpy( temp_str,"\n\rEnter New Value ( 1 to 100 ) : "); 
            ret_str = temp_str;
				break;

			case  IP_DEFAULT_GWAY:	
            return("\n\r\Enter Gateway Address : ");
				break;
#endif

			case  IP_DHCP_INFO:
				client_info_ptr->menustate =  TMS_DHCP_MODI_PARA;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 

         case  IP_DNS_INFO:
            client_info_ptr->menustate =  TMS_DNS_MODI_PARA;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
      
            
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	new_value = atoi (buffer);
	switch (client_info_ptr->modify_option_rcvd)
	{
/*		case IP_STATE:
			if (new_value == 1)
				new_rhs = telnet_enabled_str;
			else if (new_value == 2)
				new_rhs = telnet_disabled_str;
			else
				return (InvalidChoice);
            
			switch (set_parameter_by_name (CM_IP_SECTION, "IP",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break; */

#if 0
		case IP_DEFAULT_TTL :
         new_rhs = buffer;
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.mib.ipDefaultTTL,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return (wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;


		case IP_REAS_TIMOUT :
         new_rhs = buffer;
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.mib.ipReasmTimeout,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;
			}
			break;

		case IP_DEFAULT_GWAY:
/* Sudha 1 August 1998 */
			if ( !*buffer )
				strcpy(buffer,"0.0.0.0");
         if ((strcmp(buffer,"0.0.0.0") && (!is_an_ip_address(buffer))))
  	         return (InvalidIP);
						
         strcpy(temp_str,buffer);
         strcat(temp_str,",1");
         new_rhs = temp_str;

         get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.subnetmask,
		      0, CM_STRING_FORMAT,&lan_mask[0],16);				

         get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address,
   			0, CM_STRING_FORMAT,&lan_addr[0],16);	 
         
         if ( local_ip_address_and_remote_ip_address_on_same_network(lan_addr,buffer,lan_mask) == FALSE )
               {
                  return ("\n\rInvalid Gateway address.LAN & Gateway address should belong to the same net.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }     

			switch (set_parameter_by_name (CM_IP_SECTION, ip_defr,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}

			break;
#endif
		
		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
		   return(telnet.tx_buffer);
		}
	modify_config_visited = 1 ; 

	client_info_ptr->menustate = TMS_MODI_IP;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

   frame_relay_enabled = 0;

	if (!buffer)
	{
		if (frame_relay_enabled)	/* added by oss on 3-3-97 */
		{
			generate_no_of_ports_strings(no_of_ip_ports, IP_ID);
			return (telnet.tx_buffer);
		}
		generate_no_of_ports_strings(telnet.number_of_ports, IP_ID);
		return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);

	if (frame_relay_enabled) /* added by oss on 3-3-97 */
	{
		if (port_number == no_of_ip_ports + 1)
		{
			return not_supported;

			if (no_of_ip_ports >= MAX_NUM_OF_PORTS)
				return (MAX_16_ports);
			no_of_ip_ports ++;
			add_delete_values_of_ip_port(0, no_of_ip_ports);
			client_info_ptr->menu_selected_port = port_number - 1; 
		 	client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
		if (port_number == no_of_ip_ports + 2)
		{
			return not_supported;

			client_info_ptr->menustate = TMS_IP_DELETE_PORT;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
		if ((port_number > no_of_ip_ports) || (port_number < 1)) 
		{
			sprintf(telnet.tx_buffer, EnterProperChoice, no_of_ip_ports);
			return(telnet.tx_buffer);
		}
		else
		{
			client_info_ptr->menu_selected_port = port_number - 1; 
		 	client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
		}
	}

	if (port_number > telnet.number_of_ports ||	port_number < 1)
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, telnet.number_of_ports);
		return(telnet.tx_buffer);
	}
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
   else
    	client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
	
   client_info_ptr->menu_selected_port = port_number - 1; 
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ip_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG port_no;
	BYTE ip_frame[] = "IP Port Frame Type";
	BYTE temp_buff[300],value_got;

	port_no = client_info_ptr->menu_selected_port + 1;
	if (!buffer)
	{
		initialize_replystr ();

		if (client_info_ptr->menu_selected_port)
		{
			strcpy (temp_buff, "**This should be 0.0.0.0 if the IP address is to be assigned by ISP\n\r");
			strcat (temp_buff, GoBack );
		}
		else
		{
			strcpy (temp_buff, GoBack );
		}

		get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.subnetmask,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[0].ReplyStr[0],
				20);				

		get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[1].ReplyStr[0], 20);	 

#if 0
      get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].client_only,
				client_info_ptr->menu_selected_port-1, CM_INDEX_FORMAT,(void *)&value_got,2);
      if ( value_got == 1 && (client_info_ptr->menu_selected_port > 0))         
         strcpy(&ReplyStrs[2].ReplyStr[0],telnet_enabled_str);
      else
         strcpy(&ReplyStrs[2].ReplyStr[0],telnet_disabled_str);

#endif

		get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.point_to_point_remote_ip_address,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT,&ReplyStrs[3].ReplyStr[0], 20);	 

      if ( !ReplyStrs[3].ReplyStr[0])
         strcpy ( &ReplyStrs[3].ReplyStr[0],"0.0.0.0");

		sprintf (ChoiceBuffer, 	EnterChoice,
						menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port+1,
		   &ReplyStrs[0].ReplyStr[0],	&ReplyStrs[1].ReplyStr[0],
         &ReplyStrs[3].ReplyStr[0],
			temp_buff, ChoiceBuffer); 
		return(telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= MOD_IP_SUBNETMASK) &&
			(client_info_ptr->modify_option_rcvd <=
			 menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_IPPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}

BYTE *upd_modify_ip_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE  *ret_str, *new_rhs,ras_str[10],ras_addr[16],lan_addr[16],lan_mask[16];
	ULONG  new_value, port_no,port_num;
	BYTE IP_frame[] = "IP Port Frame Type";
   BYTE set_value = 0,value_got = 0;
   
   ras_str[0] = ras_addr[0] = lan_addr[0] = lan_mask[0] = 0;
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case MOD_IP_SUBNETMASK:		ret_str = NewValue;
												break;
			case MOD_IP_NODE_ADDRESS:
					ret_str = NewValue;
					break;

/* sudha 09 June 1999.This is not needed in ip section as we are configuring
it in wan section itself.*/
#if 0  
         case MOD_IP_RAS_ENABLED:
/* sudha 18 Nov 1998 */
               if (client_info_ptr->menu_selected_port < 1)
               {
                  client_info_ptr->menustate = TMS_NULL_FUNC;
                  menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_MODI_IPPORTINFO;
                  return (not_supported);
               }

					if ( get_wan_port_function_type_cfg(client_info_ptr->menu_selected_port - 1 ) == 0 )
                  return ("\n\rRAS can't be enabled for dial out only ports.Enter exit or ESC to PREV menu : \n\r");
               else
               {
                  strcpy(temp_str,"\n\r\Make sure to enter RAS addr if you enable it.");
                  strcat(temp_str,EnaOrDis);
                  ret_str = temp_str;
               }                  
					break;                  
#endif
         case MOD_IP_RAS_ADDR:
               if (client_info_ptr->menu_selected_port < 1 )
               {
                  client_info_ptr->menustate = TMS_NULL_FUNC;
                  menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_MODI_IPPORTINFO;
                  return (not_supported);
               }
               else
               {
                  get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].client_only,
         				client_info_ptr->menu_selected_port-1, CM_INDEX_FORMAT,(void *)&value_got,2);

                  if ( value_got == 1)
                     ret_str = NewValue;
                  else
                     return ("\n\rRAS option is disabled.Enter exit or ESC to PREV menu : \n\r");
               }
					break;                  

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	port_no = client_info_ptr->menu_selected_port + 1;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{

		case MOD_IP_SUBNETMASK:
         new_rhs = buffer;
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.subnetmask,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidSubnet;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		case MOD_IP_NODE_ADDRESS: 
			new_rhs = buffer;
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

/* sudha 09 June 1999.This is not needed in ip section as we are configuring
it in wan section itself.*/
      
#if 0
      case MOD_IP_RAS_ENABLED: 
         if (new_value == 1)
   			new_rhs = telnet_enabled_str;
         else
            new_rhs = telnet_disabled_str;

         if ( strcmp(new_rhs,telnet_enabled_str) == 0 )
            set_value = 1;
         else
            set_value = 0;
         switch(set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].client_only,
				client_info_ptr->menu_selected_port-1, CM_INDEX_FORMAT,(void *)&set_value))
         {
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
#endif

      case MOD_IP_RAS_ADDR: 
			new_rhs = buffer;

         if (( strcmp(buffer,"0.0.0.0") == 0 ) || !buffer[0] )
         {
            get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.bootp_enabled,
   				0, CM_STRING_FORMAT,&ras_str[0], 10);				
            
            if ( strcmp(ras_str,telnet_enabled_str) == 0 )
            {
             	get_parameter (CM_DHCP_SECTION, (void *) &dhcp.config.server_ip_address,
		   	   	CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT,&ras_addr[0], 16);				
               
               if (( strcmp(ras_addr,"0.0.0.0") == 0) || !ras_addr[0] )
               {
                  return ("\n\rInvalid Remote Access IP Addr.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }
               else
                  new_rhs = ras_addr;
            }
            else
            {
               return ("\n\rInvalid Remote Access IP Addr.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
            }
         }
         else
         {
            if (!is_an_ip_address(buffer))
               return (InvalidIP);
            else
            {
               get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.subnetmask,
				      0, CM_STRING_FORMAT,&lan_mask[0],16);				

               get_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.ip_address,
      				0, CM_STRING_FORMAT,&lan_addr[0],16);	 
						               		
               if ( strcmp(buffer,lan_addr) == 0 )
               {
                  return ("\n\rEntered addr is same as LAN addr.So Invalid.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }

               if ( local_ip_address_and_remote_ip_address_on_same_network(lan_addr,buffer,lan_mask) == FALSE )
               {
                  return ("\n\rInvalid RAS addr.LAN & RAS addr should belong to the same net.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }

					if (check_if_ras_address_is_valid_and_unique(buffer, client_info_ptr->menu_selected_port) == FALSE)
					{
                  return ("\n\rInvalid RAS addr.It should be unique.\n\r\
Enter Your Choice ( exit or ESC to PREV menu ) : ");
               }
               else
                  new_rhs = buffer;
            }   
         }
			switch (set_parameter (CM_IP_SECTION, (void *) &ip.port[0].config.point_to_point_remote_ip_address,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return InvalidIP;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}													
	modify_config_visited = 1 ; 
	client_info_ptr->menustate =  TMS_MODI_IPPORTINFO;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


/* sudhir 3-10-96 */
PARA_STR *test_linked_list (PARA_STR *start_of_linked_list)
{	
/*
	while (start_of_linked_list)
	{
		if (!i)
		{
			printf("The first string is %s\n", &start_of_linked_list->parameter[0]);
			i = 25 ;
		}
		else
		{
			start_of_linked_list = start_of_linked_list->next ;
			i-- ;
		}
	}
*/
	return (start_of_linked_list);
}





enum BOOLEAN is_default_route_valid (ULONG default_rout)
{
	int port_no;
	ULONG default_net, port_net;

	for (port_no =0; port_no < telnet.number_of_ports ; port_no++)
	{
		 default_net = default_rout & ip.port[port_no].config.subnetmask;
		 port_net = ip.port[port_no].config.ip_address & ip.port[port_no].config.subnetmask;
		 if (default_net == port_net)
		 	return (TRUE);
	}
	return (FALSE);
}	 

BYTE *get_ip_address_str (BYTE *buf, USHORT port_number)
{
	convert_ip_address_to_dot_format (buf, ip.port[port_number].config.ip_address);
	return (buf);
}

int get_number_of_ip_ports()
{
	USHORT no_of_ports=0;
	
	return ip.number_of_ports;

	get_parameter (CM_IP_SECTION, (void *) &ip.number_of_ports,
			CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT,&no_of_ports, 10);				
	return no_of_ports;
}

void	generate_no_of_ip_ports_strings(int Flag)
{
	BYTE temp_buf[75];
	int i;

	strcpy (telnet.tx_buffer, "\n\r             << Select IP Port >> \n\r");
	for (i = 1; i <= no_of_ip_ports; i++)
	{
		if (!Flag)
			sprintf (temp_buf, "\n\r[%d] Port %2d", i, i);
		else
			sprintf (temp_buf, "\n\r[%d] Port %2d     : %s", i, i,
				enabled_or_disabled (ip.port[i-1].config.port_enabled));
		strcat (telnet.tx_buffer, temp_buf);
	}
	if (!Flag)
	{
		sprintf (temp_buf, "\n\r[%d] Add a Virtual Port", no_of_ip_ports + 1);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, "\n\r[%d] Delete a Virtual Port", no_of_ip_ports + 2);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, EnterChoice, no_of_ip_ports + 2);
	}
	else
		sprintf (temp_buf, EnterChoice, no_of_ip_ports);
	strcat (telnet.tx_buffer, temp_buf);
}

BYTE  *ip_port_delete_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	if (!buffer)
	{
		sprintf (telnet.tx_buffer, PortNoToDelete, "IP");
		return (telnet.tx_buffer);
	}

	new_value = atoi (buffer);
	if (new_value > no_of_ip_ports)
	{
		sprintf (telnet.tx_buffer, EnterProperChoice, no_of_ip_ports);
		return (telnet.tx_buffer);
	}
	else
	{
	}
	client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
 	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *ip_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.mib.ipInReceives),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.mib.ipInHdrErrors),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.mib.ipForwDatagrams),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.statistics.number_of_packets_that_couldnot_be_forwarded),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.mib.ipOutRequests),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.mib.ipOutNoRoutes));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE *ip_tcp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;
	
   switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], tcp.mib.tcpPassiveOpens),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], tcp.mib.tcpAttemptFails),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], tcp.mib.tcpInSegs),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], tcp.mib.tcpOutSegs),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], tcp.mib.tcpRetransSegs),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], tcp.mib.tcpInErrs),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], tcp.mib.tcpOutRsts));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr); 
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE *ip_rip_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0],
				ip.rip.statistics.number_of_request_packets_sent + ip.rip.statistics.number_of_response_packets_sent),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.rip.statistics.number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.rip.statistics.number_of_packets_rejected),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.rip.statistics.number_of_request_packets_received),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.rip.statistics.number_of_response_packets_received),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.rip.statistics.number_of_unrecongnized_packets_received),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.rip.statistics.number_of_bad_versions),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.rip.statistics.number_of_bad_address_families),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.rip.statistics.number_of_bad_metrics));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE *ip_arp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.arp.statistics.total_number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.arp.statistics.total_number_of_incoming_requests),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.arp.statistics.total_number_of_short_packets_received),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.arp.statistics.bad_length_field),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.arp.statistics.unsupported_hardware),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.arp.statistics.unsupported_protocol),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.arp.statistics.bad_address),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.arp.statistics.total_number_of_replies_sent),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.arp.statistics.total_number_of_pending_packets_discarded),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.arp.statistics.total_number_of_requests_sent));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}



BYTE *ip_rarp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.rarp.statistics.total_number_of_packets_received),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.rarp.statistics.total_number_of_incoming_requests),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.rarp.statistics.total_number_of_short_packets_received),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.rarp.statistics.bad_length_field),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.rarp.statistics.unsupported_hardware),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.rarp.statistics.unsupported_protocol),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.rarp.statistics.bad_address),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.rarp.statistics.total_number_of_replies_sent),
/*				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.rarp.statistics.total_number_of_pending_packets_discarded),*/
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], 0),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.rarp.statistics.total_number_of_requests_sent));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}



BYTE *ip_icmp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.icmp.mib.icmpInMsgs),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.icmp.mib.icmpInErrors),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.icmp.mib.icmpInDestUnreachs),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.icmp.mib.icmpInEchos),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], ip.icmp.mib.icmpInEchoReps),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], ip.icmp.mib.icmpOutMsgs),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], ip.icmp.mib.icmpOutErrors),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], ip.icmp.mib.icmpOutDestUnreachs),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], ip.icmp.mib.icmpOutEchos),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], ip.icmp.mib.icmpOutEchoReps));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}



BYTE *ip_udp_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_TCP_IP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], ip.udp.mib.udpInDatagrams),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], ip.udp.mib.udpNoPorts),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], ip.udp.mib.udpInErrors),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], ip.udp.mib.udpOutDatagrams));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE	*ip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

	if (!buffer) {
		if (telnet.number_of_ports == 2)
		{
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				enabled_or_disabled (ip.port[0].config.port_enabled),
				enabled_or_disabled (ip.port[1].config.port_enabled));
		}
		else
		{
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				enabled_or_disabled (ip.port[0].config.port_enabled),
				enabled_or_disabled (ip.port[1].config.port_enabled),
				enabled_or_disabled (ip.port[2].config.port_enabled),
				enabled_or_disabled (ip.port[3].config.port_enabled));
		}
		return (telnet.tx_buffer);
	}

	port_number = atoi(buffer);
	/* Sanjay */
	if (port_number > menufsmhdlr[client_info_ptr->menustate].num_of_items ||
		port_number <= 0)
	{
		/* Invalid choice */
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
	else if (port_number == menufsmhdlr[client_info_ptr->menustate].num_of_items)
	{	
		/* Move to parent menu */
		client_info_ptr->menustate = menufsmhdlr[client_info_ptr->menustate].parentstate;
	}
	else
	{
		/* One of the ports */
		client_info_ptr->menustate = TMS_MODI_IPPORTINFO;
		client_info_ptr->menu_selected_port = port_number-1;
	}
	/* Sanjay */
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *to_upper_string (BYTE *in_str)
{
	BYTE *ptr = in_str;

	while (*ptr)
	{
		*ptr = (char) toupper ((int) *ptr) ;
		ptr ++ ;
	}
	return in_str ;
}

ULONG str_to_net(BYTE *Str)
{
	int f1, f2, f3, f4;

	if (sscanf(Str,"%03u.%03u.%03u.%03u", &f1, &f2, &f3, &f4) != 4)
		return(-1l);

	if ((f1 < 0) || (f1 > 255) || (f2 < 0) || (f2 > 255) ||
			(f3 < 0) || (f3 > 255) || (f4 < 0) || (f4 > 255))
		return(-1l);

	return ((f1 << 24) | (f2 << 16) | (f3 << 8) | f4);
}

BYTE *read_till_next_comma (BYTE *start_ptr, USHORT *length)
{
   USHORT count=0;
   BYTE *buf_ptr, *temp_ptr;

   temp_ptr = malloc (10);
   if (temp_ptr == NULL)
   {
      printf ("Malloc failed\n");
      return NULL;
   }
   buf_ptr = temp_ptr;
   while (*start_ptr != ',')
   {
      *temp_ptr++ = *start_ptr++;
      count++;
   }
   *temp_ptr = 0;
   *length = count;
   return buf_ptr;
}
                  
      
void initialize_static_route ()
{
   strcpy (temp_static_route.ip_address ,"0.0.0.0");
   strcpy (temp_static_route.gateway_address, "0.0.0.0");
   strcpy (temp_static_route.address_mask, "0.0.0.0");
   strcpy (temp_static_route.metric, "1"); 
	temp_static_route.port = 0;
}

BYTE *display_static_routes (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE temp_buff[200];
   USHORT index=0;
   STRUCT_STATIC_ROUTE ptr_to_static_route;
   STRUCT_STATIC_ROUTE *ptr_to_route;
   PARAMETER_NODE *ptr_to_previous_node;
   

   if (!buffer)
   {
      if (client_info_ptr->next_screen)
      {
         ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ptr_to_static_route);
      }         
      else
      {
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Static Route Table Entries", (void *) &ptr_to_static_route);
         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->no_filters = 1;
            strcpy (telnet.tx_buffer,static_route_table);
            strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");            
            return telnet.tx_buffer;
         }            
         client_info_ptr->index = 1;
      }

         
      strcpy (telnet.tx_buffer, static_route_table);

      ptr_to_route = (STRUCT_STATIC_ROUTE *) &ptr_to_static_route;

      while (ptr_to_route != NULL)
      {
         client_info_ptr->no_filters = 0;
/*         printf ("Address %s\n",ptr_to_route->ip_address); */
         index++;
			sprintf (temp_buff, "%3d. %-15s  %-15s  %-15s  %-3s  %-6s\n\r",
            client_info_ptr->index++,
            ptr_to_route->ip_address,
            ptr_to_route->address_mask,
            ptr_to_route->gateway_address,
            ptr_to_route->metric,
				get_physical_port(ptr_to_route->port));
         strcat (telnet.tx_buffer, temp_buff);

         
         ptr_to_previous_node = ptr_to_current_node;
         ptr_to_current_node =  cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void*)&ptr_to_static_route);
      
         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_node != NULL)
         {
            ptr_to_current_node = ptr_to_previous_node;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_route = (STRUCT_STATIC_ROUTE *) &ptr_to_static_route;
      }

      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 

      return telnet.tx_buffer;
   }

   if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_static_route ();
      client_info_ptr->menustate = TMS_IP_ADD_ROUTE;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_EDIT_ROUTE;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_STATIC_RT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_IP_STATIC_RT;
   }
   else
      return InvalidChoice;

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *te_edit_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_STATIC_ROUTE static_route;
   STRUCT_STATIC_ROUTE *ptr_to_static_route;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of Route:");

   index = atoi (buffer);

   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit or ESC to previous menu):");
   }
      


   client_info_ptr->edit_index = index;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Static Route Table Entries", (void *) &static_route);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &static_route);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit or ESC to previous menu):");
      }
   }  
   ptr_to_static_route = (STRUCT_STATIC_ROUTE *) &static_route;

   strcpy (temp_static_route.ip_address, ptr_to_static_route->ip_address);
   strcpy (temp_static_route.gateway_address, ptr_to_static_route->gateway_address);
   strcpy (temp_static_route.address_mask, ptr_to_static_route->address_mask);
   strcpy (temp_static_route.metric, ptr_to_static_route->metric);
	temp_static_route.port = ptr_to_static_route->port;

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_IP_ADD_ROUTE;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}


BYTE *add_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT i=0;
	BYTE ip_address[20], ip_mask[20], metric;
   STRUCT_STATIC_ROUTE ip_route;
   STRUCT_STATIC_ROUTE *ptr_to_ip_route;

   if (!buffer)
   {
      client_info_ptr->next_screen = 0;
      sprintf (telnet.tx_buffer, static_route_menu,
			get_physical_port(temp_static_route.port),
          temp_static_route.ip_address,
          temp_static_route.address_mask,
          temp_static_route.gateway_address,
          temp_static_route.metric);
      return (telnet.tx_buffer);
    }

    client_info_ptr->modify_option_rcvd = atoi (buffer);
      
    if (client_info_ptr->modify_option_rcvd >= STATIC_ROUTE_PORT &&
      client_info_ptr->modify_option_rcvd <= STATIC_ROUTE_METRIC )
    {
      client_info_ptr->menustate = TMS_IP_UPD_ROUTE;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
    {
      modify_config_visited = 1;
      
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, temp_static_route.port, CM_STRING_FORMAT, (void*)ip_address, 20);
		get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.subnetmask, temp_static_route.port, CM_STRING_FORMAT, (void*)ip_mask, 20);

		if (!is_a_static_ip_address(temp_static_route.ip_address, temp_static_route.address_mask))
			return("\n\r\Not a Valid IP Address.Enter Your Choice ( 1 to 5, exit or ESC ) : ");

		if (!is_a_static_ip_address_mask(temp_static_route.ip_address, temp_static_route.address_mask))
			return("\n\r\Not a Valid Ip Address Mask.Enter Your Choice ( 1 to 5, exit or ESC ) : ");

		if (!is_valid_string_to_read_data(temp_static_route.metric))
			return("\n\r\Not a Valid Metric.Enter Enter Your Choice ( 1 to 5, exit or ESC ) : ");

	   metric = atoi(temp_static_route.metric);
		if (metric < 1 || metric > 16)
			return("\n\r\Metric is out of range.Enter Your Choice ( 1 to 5, exit or ESC ) : ");

		if ((temp_static_route.port == 0) && (!is_a_static_ip_address(temp_static_route.gateway_address, ip_mask)))
			return("\n\r\Gateway Address, Not a valid IP Address for LAN port.\n\r\Enter Your Choice ( 1 to 5, exit or ESC ) : ");

		if ((temp_static_route.port != 0) && (strcmp(ip_address,"0.0.0.0") == 0))
		{
			if (strcmp(temp_static_route.gateway_address, "0.0.0.0") != 0)
				strcpy(temp_static_route.gateway_address, "0.0.0.0"); 
		}

		if ((strcmp(temp_static_route.gateway_address, "0.0.0.0") != 0) 
			&&	(strcmp(temp_static_route.gateway_address, "") != 0))			
		{
			if (local_ip_address_and_remote_ip_address_on_same_network(ip_address, temp_static_route.gateway_address, ip_mask) == FALSE)
				return("\n\r\Gateway & IP Address of port selected are not of same net.\n\r\Enter Your Choice ( 1 to 5, exit or ESC ) : ");
		}

      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Static Route Table Entries",(void *) &ip_route);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ip_route);
            if (ptr_to_current_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit or ESC to previous menu):");
            }
         }  
         ptr_to_ip_route = (STRUCT_STATIC_ROUTE *) &ip_route;
         client_info_ptr->edit_filter = 0;

/* sudhir 16/6/97 */
         cm_edit_string (CM_IP_SECTION, "IP Static Route Table Entries", (void *)ptr_to_ip_route,(void *) &temp_static_route);
      }
      else
         cm_insert_string (CM_IP_SECTION, "IP Static Route Table Entries", (void *) &temp_static_route);
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_IP_STATIC_RT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    return InvalidChoice;
}

BYTE *upd_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   ULONG value=0, port_number = 0;
	BYTE ip_address[20];
   
   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
			case STATIC_ROUTE_PORT:
				generate_no_of_ports_strings(telnet.number_of_ports, IP_ID);
				return (telnet.tx_buffer);
				break;				

         case STATIC_ROUTE_ADDRESS:
            return stat_rt_target;
         
         case STATIC_ROUTE_GWAY:
				if (strcmp(temp_static_route.gateway_address, "ISP Assigned") == 0)
				{
               client_info_ptr->menustate = TMS_NULL_FUNC;
               menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_IP_ADD_ROUTE;
               return (not_supported);
				}
            return ("\n\rEnter gateway ip address : ");

         case STATIC_ROUTE_SMASK:
            return stat_rt_mask;

         case STATIC_ROUTE_METRIC:
            return ("\n\rEnter Metric ( 1 to 16) :");

      }
   }
	
	port_number = atoi(buffer);
   switch (client_info_ptr->modify_option_rcvd)
   {
		case STATIC_ROUTE_PORT:
			if((port_number < 0) || (port_number > telnet.number_of_ports))					
				return(InvalidChoice);
			temp_static_route.port = (USHORT) (port_number - 1);
			if (temp_static_route.port != 0) 
			{
				get_parameter(CM_IP_SECTION, (void*)&ip.port[0].config.ip_address, temp_static_route.port, CM_STRING_FORMAT, (void*)ip_address, 20);
				if (strcmp(ip_address, "0.0.0.0") == 0)
					strcpy(temp_static_route.gateway_address, "ISP Assigned");
			}
			else
				strcpy(temp_static_route.gateway_address, "0.0.0.0");
			break;

      case STATIC_ROUTE_ADDRESS:
         if (!is_an_ip_address(buffer))
				return (InvalidIP);
         strcpy (temp_static_route.ip_address, buffer);
         break;
         
      case STATIC_ROUTE_GWAY:
         if (!is_an_ip_address(buffer))
				return (InvalidIP);
         strcpy (temp_static_route.gateway_address, buffer);
         break;
      
      case STATIC_ROUTE_SMASK:
         if (is_an_ip_address_mask(temp_static_route.ip_address, buffer) == FALSE)
				return (InvalidSubnet);
         strcpy (temp_static_route.address_mask, buffer);
         break;

      case STATIC_ROUTE_METRIC:
         sscanf (buffer, "%lu", &value);
         if (value < 1 || value > 15 )
            return InvalidChoice;
         strcpy (temp_static_route.metric, buffer);
         break;

   }
   client_info_ptr->menustate = TMS_IP_ADD_ROUTE;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *delete_static_route (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   BYTE ptr_to_static_route[100];
   STRUCT_STATIC_ROUTE *ptr_to_route;


   if (!buffer)
   {
      return ("\n\rEnter index of Route to delete:");
   }

   index = atoi (buffer) - 1;

   ptr_to_current_node = cm_get_first_entry (CM_IP_SECTION, "IP Static Route Table Entries",(void *) &ptr_to_static_route[0]);
   for (i=0; i < index; i++)
   {
      ptr_to_current_node = cm_get_next_entry (CM_IP_SECTION, ptr_to_current_node, (void *) &ptr_to_static_route[0]);
      if (ptr_to_current_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit or ESC to previous menu):");
      }
   }  

   ptr_to_route = (STRUCT_STATIC_ROUTE *) ptr_to_static_route;
   cm_remove_string (CM_IP_SECTION, "IP Static Route Table Entries", (void *)ptr_to_route);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_IP_STATIC_RT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


static void add_IP_RIP_entry_to_buffer(IP_ROUTE_ENTRY *sptr_RIP_entry, BYTE index) 
{
	BYTE	tmp_buffer[81];

	sprintf(tmp_buffer, "%3d.   %-15s    %-15s    %-15s     %2ld      %2d\n\r", 
		index,
		convert_ip_address_to_dot_format(&ReplyStrs[0].ReplyStr[0], sptr_RIP_entry->target),
		convert_ip_address_to_dot_format(&ReplyStrs[1].ReplyStr[0], sptr_RIP_entry->gateway),
		convert_ip_address_to_dot_format(&ReplyStrs[2].ReplyStr[0], sptr_RIP_entry->mask),
		sptr_RIP_entry->metric,
		sptr_RIP_entry->port_number+1);
	strcat(telnet.tx_buffer, tmp_buffer);
}


BYTE *ip_rip_table_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	i = 0;
	IP_ROUTE_ENTRY		*sptr_RIP_entry;
	BYTE	index;

	if (client_info_ptr->more) {
		sptr_RIP_entry = (IP_ROUTE_ENTRY *)client_info_ptr->ptr_last_read_primary_table_entry;
	} else {
		/* First set of entries. Go into character-at-a-time mode */
		will_temp_echo(client_info_ptr, TOECHO);
      client_info_ptr->echoing = FALSE;

		sptr_RIP_entry = ip.route_list.sptr_forward_link;
	}

	strcpy (telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu);
	index = client_info_ptr->more * MAX_ENTRIES_PER_PAGE;

	while (i < MAX_ENTRIES_PER_PAGE && sptr_RIP_entry) {
		add_IP_RIP_entry_to_buffer (sptr_RIP_entry, ++index);
 		sptr_RIP_entry = sptr_RIP_entry->links.sptr_forward_link;
		i++;
	}

	client_info_ptr->more++;

/*	if (i == MAX_ENTRIES_PER_PAGE) 
		client_info_ptr->ptr_last_read_primary_table_entry = (BYTE *)sptr_RIP_entry;
*/

	if (i) {
		client_info_ptr->ptr_last_read_primary_table_entry = (BYTE *)sptr_RIP_entry;
		/* There are entries to be displayed. Add the continue message */
		if (i == MAX_ENTRIES_PER_PAGE && sptr_RIP_entry) 
			strcat(telnet.tx_buffer, MoreContinue);
		else
			strcat(telnet.tx_buffer, Continue);
		return (telnet.tx_buffer);
	} else {
		/* No more entries. Go back to the parent menu */
		back_to_normal_mode(client_info_ptr);
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}		

void	initialize_values_of_new_ip_port()
{
}


void	generate_no_of_ports_strings(int no_of_ports, int section_id)
{
	BYTE temp_buf[75];
	int i;
   /* Sudha 12 Feb 1998 */
   char *menu_ptr;

	strcpy (temp_buf, "\n\r\n\r\             << Select %s Port >> \n\r");
	switch (section_id)
	{
		case IP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "IP");
							break;
		case IPX_ID : 	sprintf (telnet.tx_buffer, temp_buf, "IPX");
							break;
		case STP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "STP");
							break;
		case PPP_ID : 	sprintf (telnet.tx_buffer, temp_buf, "PPP");
							break;
		case WAN_ID : 	sprintf (telnet.tx_buffer, temp_buf, "WAN");
							break;
		case MUX_ID : 	sprintf (telnet.tx_buffer, temp_buf, "MUX Data");
							break;
		case AG_ID : 	sprintf (telnet.tx_buffer, temp_buf, "AG");
							break;
      case CHAT_ID : sprintf (telnet.tx_buffer, temp_buf, "WANTalk");
                     break;
      case SLIP_ID : sprintf (telnet.tx_buffer, temp_buf, "SLIP");
                     break;
		default	:
							break;
	}


   /* Sudha 12 Feb 1998 */
   switch (telnet.model_number)
   {
      case MODEL_UNKNOWN :
         printf( "\n\rModel Unknown.");
         break;
      case MODEL_MTSR3_200 :
         switch ( section_id )
         {
            case IP_ID  :
            case STP_ID :
               menu_ptr = &Mtsr3IpPPPMenu;
               break;
            case IPX_ID :
               menu_ptr = &Mtsr3IpxPPPMenu;
               break;
            case PPP_ID :
            case AG_ID  :
            case CHAT_ID:
            case SLIP_ID:
               menu_ptr = &Mtsr3WanPPPMenu;
               break;
            case WAN_ID :
               if ( dial_bkup_enabled )
                  menu_ptr = &dlbkmenu;
               else
                  menu_ptr = &Mtsr3WanPPPMenu;
               break;

            default     :
               break;
         }
         break;
      case MODEL_MTSR1_202ST :
         switch ( section_id )
         {
            case IP_ID  :
            case STP_ID :
               menu_ptr = &Mtsr1202STIpMenu;
               break;
            case IPX_ID :
               menu_ptr = &Mtsr1202STIpxMenu;
               break;
            case PPP_ID :
            case WAN_ID :
            case AG_ID  :
            case CHAT_ID:
            case SLIP_ID:
               menu_ptr = &Mtsr1202STWanMenu;
               break;
            default     :
               break;
         }
         break;
      case MODEL_MTSR1_202NT :
         switch ( section_id )
         {
            case IP_ID  :
            case STP_ID :
               menu_ptr = &Mtsr1202NTIpMenu;
               break;
            case IPX_ID :
               menu_ptr = &Mtsr1202NTIpxMenu;
               break;
            case PPP_ID :
            case WAN_ID :
            case AG_ID  :
            case CHAT_ID:
            case SLIP_ID:
               menu_ptr = &Mtsr1202NTWanMenu;
               break;
            default     :
               break;
         }
         break;

      case MODEL_MTSR2_201 :
         switch ( section_id )
         {
            case IP_ID  :
            case STP_ID :
               menu_ptr = &Mtsr2201IpPPPMenu;
               break;
            case IPX_ID :
               menu_ptr = &Mtsr2201IpxPPPMenu;
               break;
            case PPP_ID :
            case AG_ID  :
            case CHAT_ID:
            case SLIP_ID:
               menu_ptr = &Mtsr2201WanPPPMenu;
               break;
            case WAN_ID  :
               if ( dial_bkup_enabled )
                  menu_ptr = &Mtsr2201WanBkupPPPMenu;
               else
                  menu_ptr = &Mtsr2201WanPPPMenu;
               break;
            default      :
               break;
         }
         break;
      default  :
         break ;
   }
   strcat ( telnet.tx_buffer,menu_ptr);
   if ( section_id == MUX_ID )
   {
	   for (i = 1; i <= no_of_ports; i++)
   	{
	   	sprintf (temp_buf, "\n\r[%d] Port %2d", i, i);
		   strcat (telnet.tx_buffer, temp_buf);
   	}
	   strcat (telnet.tx_buffer, "\n\r");
   }

	if ((frame_relay_enabled) && (section_id < PPP_ID))
	{
		sprintf (temp_buf, "[%d] Add a Virtual Port", no_of_ports + 1);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, "\n\r[%d] Delete a Virtual Port\n\r", no_of_ports + 2);
		strcat (telnet.tx_buffer, temp_buf);
		sprintf (temp_buf, EnterChoice, no_of_ports + 2);
	}
	else
   {
		if (no_of_ports > 1)
			sprintf (temp_buf, EnterChoice, no_of_ports);
		else
			strcpy (temp_buf, EnterSingleChoice);
   }
	strcat (telnet.tx_buffer, temp_buf);
}
      

BYTE *null_function (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   
/*         if (client_info_ptr->modify_option_rcvd == MOD_ETHER_FRAME)
              return ("\n\rFrame Type is not configurable for WAN Port\n\r\
Enter your choice (exit or ESC to previous menu):");

   else  */
      return not_supported;

}


BYTE *wrong_value_function (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   return wrong_value;
}

  
   
