/* Sudha 17 Feb 1998 */
#include <defs.h>

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include <stddef.h>


#include	"telnet.h"
#include	"vmenu.h"

#include <incall.h>

#if 0
#include "..\..\include\vnvrmstr.h"		  
#endif

#include <cfgmgr.h>


extern PROXY_SERVER_CLASS proxy_server;

BYTE dummy_nat_global_addr_ptr[25]; 
BYTE dup_nat_global_addr_ptr[16];
BYTE temp_nat_global_addr[16];

PARAMETER_NODE *ptr_to_current_nat_node;

STRUCT_NAT_STATIC_ENTRY *dummy_nat_static_entry_ptr;
STRUCT_NAT_STATIC_ENTRY dup_nat_static_entry_ptr;
STRUCT_NAT_STATIC_ENTRY temp_nat_static_entry;

typedef struct NAT_ADDR_LIST 
{
BYTE addr[16];
struct NAT_ADDR_LIST *next;
}NAT_ADDR_LIST;

NAT_ADDR_LIST *telnet_nat_global_addr_list=NULL;

USHORT list_index = 0;
STRUCT_NAT_DYNAMIC_ENTRY *dummy_nat_dynamic_entry_ptr;
STRUCT_NAT_DYNAMIC_ENTRY dup_nat_dynamic_entry_ptr;
STRUCT_NAT_DYNAMIC_ENTRY temp_nat_dynamic_entry;	

extern BYTE is_an_ip_address(BYTE* address);
extern BYTE is_an_ip_address_mask(BYTE* address, BYTE* mask);
extern BYTE local_ip_address_and_remote_ip_address_on_same_network(BYTE* local_ip_address, BYTE* remote_ip_address, BYTE* mask);

extern int modify_config_visited;

extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);
extern char *get_protocol_type (char *protocol_type_string, USHORT protocol_type);
extern char *get_port_type (char *port_type_string, USHORT, USHORT protocol_port_number);
extern void get_ftp_port_numbers(USHORT *ctrl_port, USHORT *data_port);

extern BYTE tcp_application_list[];
extern BYTE udp_application_list[];

void telnet_free_nat_global_addr_list ()
{
   NAT_ADDR_LIST *list_ptr;
   NAT_ADDR_LIST *list;

   list = telnet_nat_global_addr_list;

   if (list == NULL)
      return;
   while ( list->next != NULL )
   {
      list_ptr = list->next;
      free (list);
      list = list_ptr;
   }
   return;
}

void telnet_get_global_addr_list()
{
   BYTE nat_global_addr[16];
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   PARAMETER_NODE *ptr_to_current_global_node,*ptr_to_current_static_node;
   BYTE dynamic_addr[16],temp_str[70], num_dynamic[5];
	ULONG no_of_dynamic_entries;
   BYTE *temp_buff;
	NAT_ADDR_LIST *temp_ptr, *dup_nat_addr_list;
   USHORT index;
   
   telnet_free_nat_global_addr_list ();
   telnet_nat_global_addr_list = NULL;

   ptr_to_current_global_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *) &nat_global_addr[0]);

   get_parameter(CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,&dynamic_addr[0],16);

   get_parameter(CM_PROXY_SECTION,(void *) &proxy_server.total_number_of_dynamic_servers,
         CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,&num_dynamic[0],5);
   
	sscanf(num_dynamic,"%lu",&no_of_dynamic_entries);
   ptr_to_current_static_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &nat_static_entry);

   if ( (!dynamic_addr[0]) && (ptr_to_current_static_node == NULL))  
   {
      while ( ptr_to_current_global_node != NULL )
      {
         temp_ptr = (NAT_ADDR_LIST *)malloc(sizeof (NAT_ADDR_LIST ));
            if (temp_ptr == NULL)
	            strcpy(telnet.tx_buffer,"\n\rInsufficient Memory.Enter exit or ESC to PREV menu : ");
					
            strcpy(temp_ptr->addr,nat_global_addr );
			   temp_ptr->next = telnet_nat_global_addr_list;
				telnet_nat_global_addr_list = temp_ptr;
         
         ptr_to_current_global_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_global_node, (void *) &nat_global_addr[0]);
      }
      goto GET_GLOBADDR;
   }

   while ( ptr_to_current_global_node != NULL )
   {
/* sudha 09 April 1999 */
      if (strcmp(nat_global_addr,dynamic_addr) || ((strcmp(nat_global_addr,dynamic_addr) == 0)
			&& (no_of_dynamic_entries == 0 )))
      {
         ptr_to_current_static_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &nat_static_entry);
         while ( ptr_to_current_static_node != NULL) 
         {
            if (strcmp(nat_global_addr,nat_static_entry.global_addr) != 0)
               ptr_to_current_static_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_static_node, (void *) &nat_static_entry);
            else
               break;
         }
         if ( ptr_to_current_static_node == NULL) 
         {
            temp_ptr = (NAT_ADDR_LIST *)malloc(sizeof (NAT_ADDR_LIST ));
            if (temp_ptr == NULL)
	            strcpy(telnet.tx_buffer,"\n\rInsufficient Memory.Enter exit or ESC to PREV menu : ");
					
            strcpy(temp_ptr->addr,nat_global_addr );
			   temp_ptr->next = telnet_nat_global_addr_list;
				telnet_nat_global_addr_list = temp_ptr;
         
         }
      }
      ptr_to_current_global_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_global_node, (void *) &nat_global_addr[0]);
   }

GET_GLOBADDR:
   strcpy (telnet.tx_buffer,NATGlobalAddrDB);
   index = 0;

   temp_buff = (BYTE *) malloc (50);
   if ( temp_buff == NULL )
   {
      strcpy(telnet.tx_buffer,"\n\rInsufficient Memory.Enter exit or ESC to PREV menu : ");
      return;
   }
   dup_nat_addr_list = telnet_nat_global_addr_list;
   while ( dup_nat_addr_list != NULL )
   {
      sprintf ( temp_buff,"%3d.   %-16s\n\r",
         ++index,
         dup_nat_addr_list->addr);
      strcat ( telnet.tx_buffer,temp_buff);
      dup_nat_addr_list = dup_nat_addr_list->next;
   }
   
   list_index = index;
   free ( temp_buff );

   if ( index >= 1 )
      sprintf (temp_str,"\n\rEnter Your Choice of index ( 1 to %d ) : ",index);
   else
      strcpy(temp_str,"\n\rNo global addr entry to map.Enter exit or ESC to PREV menu : ");
   strcat (telnet.tx_buffer,temp_str);
   return;
}


BYTE is_duplicate_global_addr ( BYTE *string_ptr )
{
   BYTE nat_global_addr[16];
   PARAMETER_NODE *ptr_to_current_global_node;
   
   ptr_to_current_global_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *) &nat_global_addr[0]);
   while ( ptr_to_current_global_node != NULL )
   {
      if (strcmp (nat_global_addr,string_ptr) == 0)
      {
         strcpy(telnet.tx_buffer,"\n\rEntered addr already exists in global addr list.\n\r\
         Enter exit or ESC to PREV menu : ");
         return TRUE;
      }
      else
         ptr_to_current_global_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_global_node, (void *) &nat_global_addr[0]);
   }
   return FALSE;
}


BYTE is_duplicate_addr ( BYTE *string_ptr,ULONG dyn_flag )
{
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   PARAMETER_NODE *ptr_to_current_local_node;
   
   #if 0
   ptr_to_current_global_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *) &nat_global_addr[0]);
   while ( ptr_to_current_global_node != NULL )
   {
      if (strcmp (nat_global_addr,string_ptr) == 0)
      {
         strcpy(telnet.tx_buffer,"\n\rEntered addr already exists in global addr list.\n\r\
         Enter exit or ESC to PREV menu : ");
         return TRUE;
      }
      else
         ptr_to_current_global_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_global_node, (void *) &nat_global_addr[0]);
   }
   #endif

   ptr_to_current_local_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &nat_static_entry);
   while ( ptr_to_current_local_node != NULL )
   {
      if ( !(strcmp (nat_static_entry.local_addr,string_ptr)))
      {
         strcpy(telnet.tx_buffer,"\n\rEntered addr already exists in static local addr list.\n\r\
         Enter exit or ESC to PREV menu : ");
         return TRUE;
      }
      else
         ptr_to_current_local_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_local_node, (void *) &nat_static_entry);
   }               
   
   if ( dyn_flag == 0 )
   {
      ptr_to_current_local_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *) &nat_dynamic_entry);
      while ( ptr_to_current_local_node != NULL )
      {
         if ( !(strcmp (nat_dynamic_entry.local_addr,string_ptr)))
         {
            strcpy(telnet.tx_buffer,"\n\rEntered addr already exists in dynamic local addr list.\n\r\
            Enter exit or ESC to PREV menu : ");
            return TRUE;
         }
         else
            ptr_to_current_local_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_local_node, (void *) &nat_dynamic_entry);
      }   
   }
   return FALSE;
}

BYTE is_duplicate_dynamic_entry ( USHORT protocol,USHORT port )
{

   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   PARAMETER_NODE *ptr_to_current_dynamic_node;

   ptr_to_current_dynamic_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *) &nat_dynamic_entry);
   while ( ptr_to_current_dynamic_node != NULL )
   {
      if ( (nat_dynamic_entry.protocol == protocol) &&
         (nat_dynamic_entry.port == port))
      {
         strcpy(telnet.tx_buffer,"\n\rEntered Protocol,Port pair already exists.\n\r\
         Enter exit or ESC to PREV menu : ");
         return TRUE;
      }
      else
         ptr_to_current_dynamic_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_dynamic_node, (void *) &nat_dynamic_entry);
   }
   return FALSE;
}


void initialize_NAT_global_addr()
{
   strcpy(temp_nat_global_addr,"0.0.0.0");
}

BYTE *NAT_main_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if ( !buffer)
      return (menufsmhdlr[client_info_ptr->menustate].menu);

   switch ( atoi(buffer))
   {
      case NAT_GLOBAL :
         client_info_ptr->menustate = TMS_NAT_GLOBAL;
         break;

      case NAT_MAPPING :
         client_info_ptr->menustate = TMS_NAT_MAPPING;
         break;
   
      default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
   client_info_ptr->next_screen = 0;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
   
BYTE *NAT_global_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   BYTE *ptr_to_glob_addr;
   BYTE glob_addr[50];
   USHORT index=0;
   BYTE *temp_buff;

   if (!buffer)
   {  
      if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_nat_node != NULL)
            ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &glob_addr[0]);
		}
		else
		{
         ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *) &glob_addr[0]);

         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->no_filters = 1;       
            strcpy (telnet.tx_buffer,NATGlobalAddrDB);
            strcat (telnet.tx_buffer, "\n\r\n\rEnter Your Choice (A:Add, exit or ESC to PREV menu):");            
            return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
      }            
      strcpy (telnet.tx_buffer,NATGlobalAddrDB);

      temp_buff = (BYTE *)malloc(200);
      if ( temp_buff == NULL )
         return NULL;
      

      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf ( temp_buff,"     %3d.      %-15s\n\r",
            client_info_ptr->index++,
            &dummy_nat_global_addr_ptr[0]);
         strcat ( telnet.tx_buffer,temp_buff);
         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDNAT_GLBA;
			}
      }

      ptr_to_glob_addr = (BYTE *) &glob_addr[0];

      while (ptr_to_current_nat_node != NULL)
      {
         client_info_ptr->no_filters = 0;
         index++;
         sprintf ( temp_buff,"     %3d.      %-15s\n\r",
            client_info_ptr->index++,
            ptr_to_glob_addr);
         strcat ( telnet.tx_buffer,temp_buff);
         
         if (ptr_to_current_nat_node != NULL)
            ptr_to_current_nat_node =  cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void*)&glob_addr[0]);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_nat_node != NULL)
         {
            memcpy ((char *) &dup_nat_global_addr_ptr[0], (char *) &glob_addr[0], 16);    
            strcpy(dummy_nat_global_addr_ptr,dup_nat_global_addr_ptr);
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_glob_addr = (BYTE *) &glob_addr[0];
      }
SENDNAT_GLBA:
      free(temp_buff);
         strcat (telnet.tx_buffer, "\n\rEnter Your Choice(A:Add, D:Delete,"); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return (telnet.tx_buffer);
	}
	
	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_NAT_global_addr();
      client_info_ptr->menustate = TMS_ADD_NAT_GLOBAL;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters )
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DEL_NAT_GLOBAL;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_NAT_GLOBAL;
   }
   else
      return ((BYTE*)InvalidChoice);

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

}

BYTE *NAT_global_addr_add ( TELNET_CLIENT_CLASS *client_info_ptr,BYTE *buffer)
{
	if (!buffer)
   {
      client_info_ptr->next_screen = 0;
      sprintf ( telnet.tx_buffer,NATGlobalSingleMenu,
         temp_nat_global_addr);
      return (telnet.tx_buffer);
   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);
   if ( client_info_ptr->modify_option_rcvd == 1 ) 
   {
      client_info_ptr->menustate = TMS_UPD_NAT_GLOBAL;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }

   else if ((*buffer == 'c' || *buffer == 'C' ) && strlen ( buffer ) == 1)
   {
      if ((is_an_ip_address ( temp_nat_global_addr )== FALSE))

/* sudha 09 April 1999.commented this out to support 0.0.0.0 also as valid
global addr which will be replaced by ISP assigned dynamic addr as soon as
ppp comes up.

		|| ( strcmp(temp_nat_global_addr,"0.0.0.0") == 0 )) */

         return ((BYTE *)InvalidIP);
      else
         cm_insert_string ( CM_PROXY_SECTION, "Proxy Server Global Address List", (void *)&temp_nat_global_addr[0]);

      modify_config_visited = 1;

      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_NAT_GLOBAL;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return ((BYTE*)InvalidChoice);
}

BYTE *NAT_global_addr_upd ( TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT new_value=0;

   if (!buffer)
   {
      switch(client_info_ptr->modify_option_rcvd)
      {
         case NAT_GLOBAL_START_ADDR:
            return ((BYTE *)stat_rt_target);
      }
   }
   new_value = atoi ( buffer );
   switch (client_info_ptr->modify_option_rcvd)
   {
      case NAT_GLOBAL_START_ADDR :
         if (is_an_ip_address (buffer) == FALSE )
            return ((BYTE *)InvalidIP);
         if ( is_duplicate_global_addr (buffer) == TRUE )
            return telnet.tx_buffer;
         else
            strcpy ( temp_nat_global_addr,buffer);
         break;

   }
   client_info_ptr->menustate = TMS_ADD_NAT_GLOBAL;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_global_addr_del(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;                                                      
   BYTE dynamic_addr[16];

   BYTE nat_global_addr[16];
   BYTE *ptr_to_nat_global_addr;
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;

   if (!buffer)
      return ("\n\rEnter index of global addr to delete : ");

   index = atoi (buffer) - 1;

   ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "Proxy Server Global Address List",(void *) &nat_global_addr[0]);
   for (i=0; i < index; i++)
   {
      ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_global_addr[0]);
      if (ptr_to_current_nat_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ("\n\rInvalid index to delete.Enter exit or ESC to PREV menu : ");
      }
   }  

   ptr_to_nat_global_addr = (BYTE *) &nat_global_addr[0];

   get_parameter(CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,&dynamic_addr[0],16);

   ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *) &nat_dynamic_entry);

   if ( (strcmp(dynamic_addr,&nat_global_addr[0]) == 0) && 
      (ptr_to_current_nat_node != NULL))
   {
      client_info_ptr->next_screen = 0;
      return ("\n\rDynamic mapping exists for this addr.Can't delete.\n\r\
      Enter exit or ESC to PREV menu : ");
   }
   else
   {
      ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &nat_static_entry);
      while ( ptr_to_current_nat_node != NULL )
      {
         if ( !(strcmp (nat_static_entry.global_addr,&nat_global_addr[0])))
         {
            client_info_ptr->next_screen = 0;
            return ("\n\rStatic mapping exists for this addr.Can't delete.\n\r\
            Enter exit or ESC to PREV menu : ");
         }
         else
            ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_static_entry);
      }
   }      
   cm_remove_string (CM_PROXY_SECTION, "Proxy Server Global Address List", (void *)ptr_to_nat_global_addr);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_NAT_GLOBAL;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer)
      return ((BYTE *)NATMappingType);

   client_info_ptr->modify_option_rcvd = atoi (buffer);
   switch ( client_info_ptr->modify_option_rcvd )
   {
      case NAT_STATIC_MAPPING :
         client_info_ptr->menustate = TMS_DISP_STATIC_NAT;
         break;

      case NAT_DYNAMIC_MAPPING :
         client_info_ptr->menustate = TMS_DISP_DYNAMIC_NAT;
         break;

      default :
         sprintf(telnet.tx_buffer, EnterProperChoice,2); 
			return(telnet.tx_buffer);
   }
   client_info_ptr->next_screen = 0;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}      

void initialize_nat_static_entry()
{
	strcpy(temp_nat_static_entry.global_addr,"");
	strcpy(temp_nat_static_entry.local_addr,"0.0.0.0");
}	

BYTE	*NAT_static_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_STATIC_ENTRY *ptr_to_nat_static_entry;
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   BYTE temp_buff[200];

   USHORT index=0;

	if (!buffer)
	{
		if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_nat_node != NULL)
            ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_static_entry);
		}
		else
		{
         ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &nat_static_entry);
         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->no_filters = 1;
				strcpy (telnet.tx_buffer, NATStaticTableDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter Your Choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
		}

		strcpy (telnet.tx_buffer, NATStaticTableDB);
      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf (temp_buff, "     %3d.      %-15s    %-15s\n\r",
            client_info_ptr->index++,
            dummy_nat_static_entry_ptr->global_addr,
            dummy_nat_static_entry_ptr->local_addr);
         strcat (telnet.tx_buffer, temp_buff);
         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDSTAT_NAT;
         }
      }         

      ptr_to_nat_static_entry = (STRUCT_NAT_STATIC_ENTRY *) &nat_static_entry;

   	while (ptr_to_nat_static_entry != NULL)
   	{
         client_info_ptr->no_filters = 0;
         index++;
         sprintf (temp_buff, "     %3d.      %-15s    %-15s\n\r",
            client_info_ptr->index++,
            ptr_to_nat_static_entry->global_addr,
            ptr_to_nat_static_entry->local_addr);
         strcat (telnet.tx_buffer, temp_buff);
         
         if (ptr_to_current_nat_node != NULL)
            ptr_to_current_nat_node =  cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void*)&nat_static_entry);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_nat_node != NULL)
         {
            memcpy ((char *) &dup_nat_static_entry_ptr, (char *) &nat_static_entry,sizeof (STRUCT_NAT_STATIC_ENTRY));
            dummy_nat_static_entry_ptr = (STRUCT_NAT_STATIC_ENTRY *) &dup_nat_static_entry_ptr;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_nat_static_entry = (STRUCT_NAT_STATIC_ENTRY *) &nat_static_entry;
		}
SENDSTAT_NAT:

      strcat (telnet.tx_buffer, "\n\rEnter Your Choice(A:Add, D:Delete, E:Edit ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 

   	return telnet.tx_buffer;
	}
   	
	if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_nat_static_entry ();
      client_info_ptr->menustate = TMS_ADD_STATIC_NAT;
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_EDIT_STATIC_NAT;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DEL_STATIC_NAT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_DISP_STATIC_NAT;
   }
   else
      return ((BYTE*)InvalidChoice);

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

}

BYTE *NAT_edit_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   STRUCT_NAT_STATIC_ENTRY *ptr_to_nat_static_entry;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of static mapping : ");

   index = atoi (buffer);
   if (index >= client_info_ptr->index || index == 0)
      return ("\n\rInvalid index to edit.Enter exit or ESC to PREV menu : ");

   client_info_ptr->edit_index = index;

   ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping",(void *) &nat_static_entry);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_static_entry);
      if (ptr_to_current_nat_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ((BYTE *)InvalidChoice);
      }
   }  
   ptr_to_nat_static_entry = (STRUCT_NAT_STATIC_ENTRY *) &nat_static_entry;

   strcpy(temp_nat_static_entry.global_addr,ptr_to_nat_static_entry->global_addr);
   strcpy(temp_nat_static_entry.local_addr,ptr_to_nat_static_entry->local_addr);
   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;
   
   client_info_ptr->menustate = TMS_ADD_STATIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



BYTE *NAT_del_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   STRUCT_NAT_STATIC_ENTRY *ptr_to_nat_static_entry;


   if (!buffer)
      return ("\n\rEnter index of static mapping to delete : ");

   index = atoi (buffer) - 1;

   ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping",(void *) &nat_static_entry);
   for (i=0; i < index; i++)
   {
      ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_static_entry);
      if (ptr_to_current_nat_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ("\n\rInvalid index to delete.Enter exit or ESC to PREV menu : ");
      }
   }  

   ptr_to_nat_static_entry = (STRUCT_NAT_STATIC_ENTRY *) &nat_static_entry;
   cm_remove_string (CM_PROXY_SECTION, "NAT_Static Mapping", (void *)ptr_to_nat_static_entry);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;
   client_info_ptr->menustate = TMS_DISP_STATIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_add_static_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_STATIC_ENTRY nat_static_entry;
   STRUCT_NAT_STATIC_ENTRY *ptr_to_nat_static_entry;
   USHORT i;

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, NATStaticMappingMenu,
			temp_nat_static_entry.global_addr,
         temp_nat_static_entry.local_addr);
		return telnet.tx_buffer;
	}
	
	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= NAT_STATIC_GLOBAL &&
      client_info_ptr->modify_option_rcvd <= NAT_STATIC_LOCAL )
   {
      client_info_ptr->menustate = TMS_UPD_STATIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      if ((strcmp(temp_nat_static_entry.global_addr,"") != 0) && 
         (strcmp(temp_nat_static_entry.local_addr,"0.0.0.0") != 0))
      {
         modify_config_visited = 1;
      
         if (client_info_ptr->edit_filter)
         {
            ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Static Mapping",(void *) &nat_static_entry);
            for (i=0; i < client_info_ptr->edit_index-1; i++)
            {
               ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_static_entry);
               if (ptr_to_current_nat_node == NULL)
               {
                  client_info_ptr->next_screen = 0;
                  return ((BYTE*)InvalidChoice);                  
               }
            }  
            ptr_to_nat_static_entry = (STRUCT_NAT_STATIC_ENTRY *) &nat_static_entry;
            client_info_ptr->edit_filter = 0;

            cm_edit_string (CM_PROXY_SECTION, "NAT_Static Mapping", (void *)ptr_to_nat_static_entry,(void *) &temp_nat_static_entry);
         }
         else
            cm_insert_string (CM_PROXY_SECTION, "NAT_Static Mapping", (void *) &temp_nat_static_entry);
      }
      else
         return ("\n\rInvalid Address.\n\r");
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DISP_STATIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return ((BYTE *)InvalidChoice);
}

BYTE *NAT_upd_static_entry_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value=0,i=0;
   BYTE *addr_value;
   NAT_ADDR_LIST *dup_nat_addr_list;
   ULONG flag = 0;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case NAT_STATIC_GLOBAL:
            telnet_get_global_addr_list();
            return telnet.tx_buffer;

         case NAT_STATIC_LOCAL:
				return ("\n\rEnter Local Addr to map : ");

		}
	}
	value = atoi (buffer);
   addr_value = buffer;

	switch (client_info_ptr->modify_option_rcvd)
	{
		case NAT_STATIC_GLOBAL:
			if ((value <= 0) || (value > list_index))
            return ((BYTE*)InvalidChoice);
         else
         {
            dup_nat_addr_list = telnet_nat_global_addr_list;
            for ( i = 0;i < value-1 ;i++)
            {
               dup_nat_addr_list = dup_nat_addr_list->next;
               if ( dup_nat_addr_list == NULL )
                  return ((BYTE *)InvalidChoice);
            }
            strcpy (temp_nat_static_entry.global_addr,dup_nat_addr_list->addr);
         }
         break;

   	case NAT_STATIC_LOCAL:
         if ( is_an_ip_address ( addr_value ) == FALSE )
            return ("\n\rEntered address is invalid.Enter exit or ESC to PREV menu : ");
         if (is_duplicate_addr(addr_value,flag) == TRUE )
            return telnet.tx_buffer;
         else
            strcpy (temp_nat_static_entry.local_addr,buffer);             
			break;
				
	}
   
   client_info_ptr->menustate = TMS_ADD_STATIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

void initialize_nat_dynamic_entry()
{
	strcpy (temp_nat_dynamic_entry.local_addr, "0.0.0.0");
   temp_nat_dynamic_entry.port = 0;
   temp_nat_dynamic_entry.protocol = 0;
}

BYTE	*NAT_dynamic_mapping_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_DYNAMIC_ENTRY *ptr_to_nat_dynamic_entry;
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   BYTE temp_buff[200],dynamic_addr[16];
   BYTE port_buff[20], protocol_buff[25];

   USHORT index=0;

   dynamic_addr[0] = 0;
   
	if (!buffer)
	{
		if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_nat_node != NULL)
            ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_dynamic_entry);
		}
		else
		{
         ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *) &nat_dynamic_entry);
         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->no_filters = 1;
            set_parameter (CM_PROXY_SECTION, (void *) &proxy_server.proxy_local_internet_server_address,
                  CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,dynamic_addr);
				strcpy (telnet.tx_buffer, NATTableDB);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter Your Choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
		}

		strcpy (telnet.tx_buffer, NATTableDB);

      get_parameter(CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,&dynamic_addr[0],16);

      if (client_info_ptr->next_screen)
      {
         index++;
         sprintf (temp_buff, "     %3d.    %-15s   %-15s   %-4s   %s (%04d)\n\r",
            client_info_ptr->index++,
            dynamic_addr,
            dummy_nat_dynamic_entry_ptr->local_addr,
            get_protocol_type (protocol_buff,dummy_nat_dynamic_entry_ptr->protocol),
            get_port_type (port_buff, dummy_nat_dynamic_entry_ptr->protocol,dummy_nat_dynamic_entry_ptr->port),
            dummy_nat_dynamic_entry_ptr->port);
         strcat (telnet.tx_buffer, temp_buff);
         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDDYN_NAT;
         }
      }         

      ptr_to_nat_dynamic_entry = (STRUCT_NAT_DYNAMIC_ENTRY *) &nat_dynamic_entry;

   	while (ptr_to_nat_dynamic_entry != NULL)
   	{
         client_info_ptr->no_filters = 0;
         index++;
         sprintf (temp_buff, "     %3d.    %-15s   %-15s   %-4s   %s (%04d)\n\r",
            client_info_ptr->index++,
            dynamic_addr,
            ptr_to_nat_dynamic_entry->local_addr,
            get_protocol_type (protocol_buff,ptr_to_nat_dynamic_entry->protocol),
            get_port_type (port_buff, ptr_to_nat_dynamic_entry->protocol,ptr_to_nat_dynamic_entry->port),
            ptr_to_nat_dynamic_entry->port);
         strcat (telnet.tx_buffer, temp_buff);
         
         if (ptr_to_current_nat_node != NULL)
            ptr_to_current_nat_node =  cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void*)&nat_dynamic_entry);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_nat_node != NULL)
         {
            memcpy ((char *) &dup_nat_dynamic_entry_ptr, (char *) &nat_dynamic_entry,sizeof (STRUCT_NAT_DYNAMIC_ENTRY));
            dummy_nat_dynamic_entry_ptr = (STRUCT_NAT_DYNAMIC_ENTRY *) &dup_nat_dynamic_entry_ptr;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_nat_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_nat_dynamic_entry = (STRUCT_NAT_DYNAMIC_ENTRY *) &nat_dynamic_entry;
		}
SENDDYN_NAT:

      strcat (telnet.tx_buffer, "\n\rEnter Your Choice(A:Add, D:Delete, E:Edit ");  
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 

   	return telnet.tx_buffer;
	}
   	
	if ((*buffer == 'A' || *buffer == 'a') && strlen (buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_nat_dynamic_entry ();
      client_info_ptr->menustate = TMS_ADD_DYNAMIC_NAT;
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_EDIT_DYNAMIC_NAT;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DEL_DYNAMIC_NAT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_DISP_DYNAMIC_NAT;
   }
   else
      return ((BYTE *)InvalidChoice);

   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

}

BYTE *NAT_edit_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   STRUCT_NAT_DYNAMIC_ENTRY *ptr_to_nat_dynamic_entry;
   USHORT i;
   USHORT index;

   if (!buffer)
      return ("\n\rEnter index of dynamic mapping : ");

   index = atoi (buffer);
   if (index >= client_info_ptr->index || index == 0)
      return ("\n\rInvalid index to edit.Enter exit or ESC to PREV menu : ");

   client_info_ptr->edit_index = index;

   ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping",(void *) &nat_dynamic_entry);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_dynamic_entry);
      if (ptr_to_current_nat_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ((BYTE *)InvalidChoice);
      }
   }  
   ptr_to_nat_dynamic_entry = (STRUCT_NAT_DYNAMIC_ENTRY *) &nat_dynamic_entry;

   strcpy(temp_nat_dynamic_entry.local_addr,ptr_to_nat_dynamic_entry->local_addr);
   temp_nat_dynamic_entry.port = ptr_to_nat_dynamic_entry->port;
   temp_nat_dynamic_entry.protocol = ptr_to_nat_dynamic_entry->protocol;

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;
   
   client_info_ptr->menustate = TMS_ADD_DYNAMIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_del_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   STRUCT_NAT_DYNAMIC_ENTRY *ptr_to_nat_dynamic_entry;
   BYTE dynamic_addr[16];

   if (!buffer)
      return ("\n\rEnter index of dynamic mapping to delete : ");

   index = atoi (buffer) - 1;

   ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping",(void *) &nat_dynamic_entry);
   for (i=0; i < index; i++)
   {
      ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_dynamic_entry);
      if (ptr_to_current_nat_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return ("\n\rInvalid index to delete.Enter exit or ESC to PREV menu : ");
      }
   }  

   ptr_to_nat_dynamic_entry = (STRUCT_NAT_DYNAMIC_ENTRY *) &nat_dynamic_entry;
   
   if (ptr_to_nat_dynamic_entry->protocol == 6)
      ptr_to_nat_dynamic_entry->protocol = 0;
   else if ( ptr_to_nat_dynamic_entry->protocol == 17)
      ptr_to_nat_dynamic_entry->protocol = 1;
   
   cm_remove_string (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *)ptr_to_nat_dynamic_entry);
   
   ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping",(void *) &nat_dynamic_entry);

   if ( ptr_to_current_nat_node == NULL )
   {
      dynamic_addr[0] = 0;
      set_parameter (CM_PROXY_SECTION, (void *) &proxy_server.proxy_local_internet_server_address,
                  CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,dynamic_addr);
   }

   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_DISP_DYNAMIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *NAT_add_dynamic_entry_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_NAT_DYNAMIC_ENTRY nat_dynamic_entry;
   STRUCT_NAT_DYNAMIC_ENTRY *ptr_to_nat_dynamic_entry;
   BYTE port_buff[20], protocol_buff[20];
   BYTE dynamic_addr[16];
   USHORT i;

   dynamic_addr[0] = 0;
   
   get_parameter(CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
         CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,&dynamic_addr[0],16);

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (telnet.tx_buffer, NATDynamicMappingMenu,
         dynamic_addr,
         temp_nat_dynamic_entry.local_addr,
         get_protocol_type ( protocol_buff, temp_nat_dynamic_entry.protocol),
         get_port_type ( port_buff, temp_nat_dynamic_entry.protocol,temp_nat_dynamic_entry.port),
         temp_nat_dynamic_entry.port);
		return telnet.tx_buffer;
	}
	
	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= NAT_DYNAMIC_GLOBAL &&
      client_info_ptr->modify_option_rcvd <= NAT_DYNAMIC_PORT )
   {
      client_info_ptr->menustate = TMS_UPD_DYNAMIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {

      if ( (!dynamic_addr[0]) || 

/* sudha 09 April 1999.commented this out to support 0.0.0.0 also as valid
global addr which will be replaced by ISP assigned dynamic addr as soon as
ppp comes up.
		(strcmp(dynamic_addr,"0.0.0.0") == 0) || */

         (strcmp(temp_nat_dynamic_entry.local_addr,"0.0.0.0") == 0) ||
         (temp_nat_dynamic_entry.port == 0 ))
         return("\n\rValues for all fields needed.Enter exit or ESC to PREV menu : ");

      modify_config_visited = 1;

      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_nat_node = cm_get_first_entry (CM_PROXY_SECTION, "NAT_Dynamic Mapping",(void *) &nat_dynamic_entry);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_nat_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_nat_node, (void *) &nat_dynamic_entry);
            if (ptr_to_current_nat_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return ((BYTE *)InvalidChoice);                  
            }
         }  
         ptr_to_nat_dynamic_entry = (STRUCT_NAT_DYNAMIC_ENTRY *) &nat_dynamic_entry;
         client_info_ptr->edit_filter = 0;

         if (temp_nat_dynamic_entry.protocol == 6)
				temp_nat_dynamic_entry.protocol = 0;
			else if (temp_nat_dynamic_entry.protocol == 17)
				temp_nat_dynamic_entry.protocol = 1;

			if (ptr_to_nat_dynamic_entry->protocol == 6)
				ptr_to_nat_dynamic_entry->protocol = 0;
			else if (ptr_to_nat_dynamic_entry->protocol == 17)
				ptr_to_nat_dynamic_entry->protocol = 1;

         cm_edit_string (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *)ptr_to_nat_dynamic_entry,(void *) &temp_nat_dynamic_entry);
      }
      else
      {
      	if (is_duplicate_dynamic_entry ( temp_nat_dynamic_entry.protocol,
         	temp_nat_dynamic_entry.port) == TRUE )
	         return telnet.tx_buffer;

			if (temp_nat_dynamic_entry.protocol == 6)
				temp_nat_dynamic_entry.protocol = 0;
			else if (temp_nat_dynamic_entry.protocol == 17)
				temp_nat_dynamic_entry.protocol = 1;
			
         cm_insert_string (CM_PROXY_SECTION, "NAT_Dynamic Mapping", (void *) &temp_nat_dynamic_entry);
      }   
		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_DISP_DYNAMIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return ((BYTE *)InvalidChoice);
}

BYTE *update_nat_dynamic_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT new_value =0;

	if (!buffer)
		return ("\n\rEnter Proxy Application Port to map : ");

	new_value = atoi (buffer);

	if (new_value > 0 && new_value <= 1024)
	{
		temp_nat_dynamic_entry.port = new_value;
      client_info_ptr->menustate = TMS_ADD_DYNAMIC_NAT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return ((BYTE *)InvalidChoice);
}

BYTE *NAT_upd_dynamic_entry_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value=0,i=0, ctrl_port = 0, data_port = 0;
   BYTE dynamic_addr[16];
   BYTE port_buff[20];
   NAT_ADDR_LIST *dup_nat_addr_list;
   ULONG flag = 1;

   dynamic_addr[0] = 0;
   get_parameter(CM_PROXY_SECTION,(void *) &proxy_server.proxy_local_internet_server_address,
               CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,&dynamic_addr[0],16);
	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case NAT_DYNAMIC_GLOBAL:
            if ( !(dynamic_addr[0])) 
/*				|| (!(strcmp(dynamic_addr,"0.0.0.0")))) */
            {
               telnet_get_global_addr_list();
               return telnet.tx_buffer;
            }
            else
               return ((BYTE *)not_supported);

         case NAT_DYNAMIC_LOCAL:
   	      return("\n\rEnter Local addr to map : ");   

         case NAT_DYNAMIC_PROTOCOL:
            return ((BYTE *)Protochoice);
            
         case NAT_DYNAMIC_PORT:
            if (!strcmp (get_protocol_type (port_buff,temp_nat_dynamic_entry.protocol), "TCP"))
				{
					get_ftp_port_numbers(&ctrl_port, &data_port);
					sprintf(telnet.tx_buffer,tcp_application_list,
						ctrl_port,data_port);
					return telnet.tx_buffer;
				/*	return tcp_application_list; */
				}					
				else if (!strcmp (get_protocol_type (port_buff,temp_nat_dynamic_entry.protocol), "UDP"))
				{
					get_ftp_port_numbers(&ctrl_port, &data_port);
					sprintf(telnet.tx_buffer,udp_application_list,
						ctrl_port,data_port);
					return telnet.tx_buffer;
				/*	return udp_application_list; */
				}
				else
					return ("\n\rUnknown Protocol");		

      }
   }

	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case NAT_DYNAMIC_GLOBAL:
         if ( !(dynamic_addr[0]))
/*			|| (!(strcmp(dynamic_addr,"0.0.0.0")))) */
         {
	   		if ((value <= 0) || (value > list_index))
               return ((BYTE *)InvalidChoice);
            else
            {
               dup_nat_addr_list = telnet_nat_global_addr_list;
               for ( i = 0;i < value-1 ;i++)
               {
                  dup_nat_addr_list = dup_nat_addr_list->next;
                  if ( dup_nat_addr_list == NULL )
                     return ((BYTE *)InvalidChoice);
               }
               strcpy (dynamic_addr,dup_nat_addr_list->addr);
               set_parameter (CM_PROXY_SECTION, (void *) &proxy_server.proxy_local_internet_server_address,
                  CM_NO_PORT_PARAMETER_PRESENT,CM_STRING_FORMAT,dynamic_addr);
            }
         }
         break;
      
      case NAT_DYNAMIC_LOCAL:
         if ( is_an_ip_address ( buffer ) == FALSE )
            return ("\n\rEntered address is invalid.Enter exit or ESC to PREV menu : ");
         if (is_duplicate_addr(buffer,flag) == TRUE )
            return telnet.tx_buffer;
         else
            strcpy (temp_nat_dynamic_entry.local_addr,buffer);             
			break;

   	case NAT_DYNAMIC_PROTOCOL:
         if (value == 1)
				temp_nat_dynamic_entry.protocol = 6 ;
			else if (value == 2)
				temp_nat_dynamic_entry.protocol = 17 ;
			else
				return ((BYTE *)InvalidChoice);
			break;
	
		case NAT_DYNAMIC_PORT:
			if (temp_nat_dynamic_entry.protocol == 6)
			{
				if (value < (MAX_TCP_APPLICATIONS + 1))
				{
					temp_nat_dynamic_entry.port = get_protocol_port_number (temp_nat_dynamic_entry.protocol , value);
				}
				else if (value == (MAX_TCP_APPLICATIONS + 1))
				{
               client_info_ptr->menustate = TMS_APP_UPD_DYNAMIC;
               return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
				}
				else
					return ((BYTE *)InvalidChoice);
			}	
			else if (temp_nat_dynamic_entry.protocol == 17)
			{
				if (value < (MAX_UDP_APPLICATIONS + 1))
					temp_nat_dynamic_entry.port = get_protocol_port_number (temp_nat_dynamic_entry.protocol ,value);
				else if (value == (MAX_UDP_APPLICATIONS + 1))
				{
               client_info_ptr->menustate = TMS_APP_UPD_DYNAMIC;
               return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
				}
				else
					return ((BYTE *)InvalidChoice);
			}
			else 
				return ("\n\rUnknown Protocol");
			break;

	}

   client_info_ptr->menustate = TMS_ADD_DYNAMIC_NAT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

