#include	<defs.h>
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include <stddef.h>

#include	"telnet.h" 
#include	"vmenu.h"
#include "telip.h"

#include <incall.h>

#include <cfgmgr.h>

/* Sudha 12 Feb 1998 */
/* #include "..\..\store\hardware.h" */

/* added by oss on 4-4-97 */
ULONG PAP_enabled;
ULONG CHAP_enabled;
int PPP_Flag_enable = 0;
extern BYTE ChoiceBuffer[80];

extern	PPP_CLASS	ppp;

BYTE user_password[60], password_str[60];

extern int modify_config_visited;

BYTE temp_strn[200];

extern void *memset(void *,int ,size_t);
extern void decrypt (char *src, char *dest);

/*extern int  strlen (const char *); */
extern void	generate_no_of_ports_strings(int no_of_ports, int section_id);
/* sudhir 3-10-96 */


/* Sudha 17 March 1998 */
extern BYTE get_the_section_number(enum CM_SECTIONS section);
extern PARAMETER_NODE* get_authentication_method(PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, USHORT port_number, BYTE* port_number_matched, BYTE* authentication_type, BYTE is_local_required);
extern PARAMETER_NODE* set_authentication_method(PARAMETER_NODE* search_to_start_at, PARAMETER_NODE* start_of_next_section, USHORT port_number, BYTE* port_number_matched, BYTE authentication_type);

BYTE	*modify_slip_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

	if (!buffer) 
	{
      /* Sudha 12 Feb 1998 */
      /* if (telnet.number_of_ports == 2)
         return SelectSLIPPort_2Port;
      else if (telnet.number_of_ports == 4)
         return SelectSLIPPort_4Port; */

  		generate_no_of_ports_strings(telnet.number_of_ports - 1, SLIP_ID);
		return (telnet.tx_buffer);  
	}

	port_number = atoi (buffer);
	if (port_number > ((telnet.number_of_ports) - 1 ) || port_number < 1)
	{
		/* Bad choice */
		sprintf(telnet.tx_buffer, EnterProperChoice,((telnet.number_of_ports) - 1)); 
		return(telnet.tx_buffer);
	}
	else
	{
		/* One of the ports */
		client_info_ptr->menustate = TMS_SLIP_PORTINFO;
/*		client_info_ptr->menustate = TMS_MODI_PPPPORTINFO; */
		client_info_ptr->menu_selected_port = port_number-1;
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *modify_slip_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer)
   {
      initialize_replystr ();

		get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].slip_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);
   
      get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].cslip_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[1].ReplyStr[0], 10);
   
      #if 0
      get_parameter_by_name (CM_PPP_SECTION, "PPP Port SLIP Inbound Authentication",
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[2].ReplyStr[0], 10);
      #endif

      get_parameter_by_name (CM_PPP_SECTION, "PPP Port SLIP Maximum Transmit Unit",
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[2].ReplyStr[0], 10);

      sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
         client_info_ptr->menu_selected_port+1,
         &ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],
         &ReplyStrs[2].ReplyStr[0]);
       
      return telnet.tx_buffer;
   }

   client_info_ptr->modify_option_rcvd = atoi (buffer);

   if ((client_info_ptr->modify_option_rcvd >= 1) && 
  		(client_info_ptr->modify_option_rcvd <=
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_SLIP_UPD_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
		menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
 	}
}   

BYTE *slip_modify_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	BYTE  *ret_str;
   BYTE *new_rhs,ppp_str[10];

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
          case TEL_SLIP:
          case TEL_CSLIP:
            ret_str = (BYTE *)EnaOrDis;
            break;
            
               #if 0
          case SLIP_CALLER:
            client_info_ptr->menustate = TMS_NULL_FUNC;
            menufsmhdlr[TMS_NULL_FUNC].parentstate = TMS_SLIP_PORTINFO;

            ret_str = not_supported;
            break;
            #endif

          case SLIP_MTU:
            ret_str = (BYTE *)NewValue;
            break;
      }
      return ret_str;
   }

   new_value = atoi (buffer);

   switch (client_info_ptr->modify_option_rcvd)
	{
      case TEL_SLIP:
         if (new_value == 1)
				new_rhs = (BYTE *)&telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = (BYTE *)&telnet_disabled_str[0];
			else
				return ((BYTE *)InvalidChoice);

         get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ppp_str[0], 10);
         
         if (( strcmp(ppp_str,telnet_enabled_str) == 0 ) &&
            ( strcmp(new_rhs,telnet_enabled_str) == 0 ))
         {
            return("\n\rPPP is also enabled.Disable that first & then enable SLIP.\n\r\
Enter ( exit or ESC to PREV menu ) : ");
         }
         else
         {
            switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].slip_enabled,
	   			client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
            {
			   	case CM_NOT_ENOUGH_MEMORY:
				   	return ((BYTE *)Insufficient_memory);

   			} 
         }
         break;
  
      case TEL_CSLIP:
         if (new_value == 1)
				new_rhs = (BYTE *)&telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = (BYTE *)&telnet_disabled_str[0];
			else
				return ((BYTE *)InvalidChoice);

         switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].cslip_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
         {

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
         break;

         #if 0
      case SLIP_CALLER:
         return not_supported;
         break;
         #endif
/*         if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = &telnet_disabled_str[0];
			else
				return (InvalidChoice);

         switch (set_parameter_by_name (CM_PPP_SECTION, "PPP Port SLIP Inbound Authentication",
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
         {
				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
         break; */

      case SLIP_MTU:
         new_rhs = buffer;
         if (strlen (new_rhs) > 5)
            return ((BYTE *)wrong_value);

         switch (set_parameter_by_name (CM_PPP_SECTION, "PPP Port SLIP Maximum Transmit Unit",
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
         {
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)InvalidChoice);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
         break;
   }
   client_info_ptr->menustate = TMS_SLIP_PORTINFO;
   return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *modify_ppp_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG ppp1,ppp2,ppp3,ppp4,ppp5,ppp6,ppp7;

	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_configuration_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp1, 10);

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_termination_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp2, 10);		

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_unacknowledged_echo_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp3, 10);	

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_configuration_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp4,	10);	

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_termination_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp5,	10); 
		
		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_echo_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp6, 10);	

		get_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_configuration_request_backoff_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_ULONG_FORMAT, &ppp7, 10);	

		get_parameter_by_name (CM_PPP_SECTION, "MLPPP",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);
				
/* sudha 18 Nov 1998... */
		get_parameter (CM_PPP_SECTION, (void *) &ppp.need_to_dial_out_initially,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, &ReplyStrs[1].ReplyStr[0], 10);	
/* ...sudha 18 Nov 1998 */

		sprintf (ChoiceBuffer, EnterChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			MakePunctNumStr(&ReplyStrs[7].ReplyStr[0], ppp1),
			MakePunctNumStr(&ReplyStrs[8].ReplyStr[0], ppp2),
			MakePunctNumStr(&ReplyStrs[9].ReplyStr[0], ppp3),
			MakePunctNumStr(&ReplyStrs[10].ReplyStr[0], ppp4),
			MakePunctNumStr(&ReplyStrs[11].ReplyStr[0], ppp5),
			MakePunctNumStr(&ReplyStrs[12].ReplyStr[0], ppp6),
			MakePunctNumStr(&ReplyStrs[13].ReplyStr[0], ppp7),
   		&ReplyStrs[0].ReplyStr[0],
			&ReplyStrs[1].ReplyStr[0]);
		return(telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= 1) && 
  		(client_info_ptr->modify_option_rcvd <=
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_PPP_MODIFY_MENU;
		return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
		menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
 	}
}

BYTE *ppp_modify_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG new_value;
	BYTE  *ret_str;
   BYTE *new_rhs;

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case 	PPP_MAX_CONF_REQ:
			case  PPP_MAX_TERM_REQ:
			case  PPP_MAX_UNACKECH_REQ:
			case  PPP_MAX_CONF_REQ_SENDI: 
			case  PPP_MAX_TERM_REQ_SENDI:
			case  PPP_MAX_ECHO_REQ_SENDI:
			case  PPP_MAX_CONF_REQ_BACKO: ret_str = (BYTE *)NewValue;
				break;
/* sudha 18 Nov 1998... */
			case PPP_NEED_TO_DIAL_OUT :
				ret_str = (BYTE *)EnaOrDis;
				break;
/* ...sudha 18 Nov 1998 */
				
			case MULTI_PPP:
            strcpy(temp_strn,"\n\r\ 1. Make sure to have the same user name & password \n\r\
   in all the ports if you enable this.\n\r\
 2. If MLPPP is enabled,Remote Access will be disabled on all the ports.");
            strcat(temp_strn,EnaOrDis);
				ret_str = temp_strn;
				break;

			case PPP_PORT_INFO:
				client_info_ptr->menustate = TMS_MODI_PPPPORT;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

			
			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);

		}
		return (ret_str);

	}
	new_value = atoi (buffer);

	switch(client_info_ptr->modify_option_rcvd)
	{
		case 	PPP_MAX_CONF_REQ:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_configuration_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      case  PPP_MAX_TERM_REQ:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_termination_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      case  PPP_MAX_UNACKECH_REQ:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_number_of_unacknowledged_echo_requests,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      case  PPP_MAX_CONF_REQ_SENDI: 
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_configuration_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      case  PPP_MAX_TERM_REQ_SENDI:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_termination_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      case  PPP_MAX_ECHO_REQ_SENDI:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_echo_request_send_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      case  PPP_MAX_CONF_REQ_BACKO:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.maximum_configuration_request_backoff_interval,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

/* sudha 18 Nov 1998... */
		case PPP_NEED_TO_DIAL_OUT:
			if (new_value == 1)
				new_rhs = (BYTE *)&telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = (BYTE *)&telnet_disabled_str[0];
			else
				return ((BYTE *)InvalidChoice);

			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.need_to_dial_out_initially,
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))

			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break; 

/* ...sudha 18 Nov 1998 */

      case	PPP_PORT_INFO:      	
			client_info_ptr->menustate = TMS_MODI_PPPPORT;
			break;

		case MULTI_PPP:
			if (new_value == 1)
				new_rhs = (BYTE *)&telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = (BYTE *)&telnet_disabled_str[0];
			else
				return ((BYTE *)InvalidChoice);

			switch (set_parameter_by_name (CM_PPP_SECTION, "MLPPP",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break; 

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	} 
	modify_config_visited = 1 ; 
	client_info_ptr->menustate = TMS_MODI_PPPMAIN;	
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ppp_port_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT	port_number;

	if (!buffer) 
	{
      /* Sudha 12 Feb 1998 */
	   generate_no_of_ports_strings(telnet.number_of_ports - 1, PPP_ID);
		return (telnet.tx_buffer);
	}

	port_number = atoi (buffer);
	if (port_number > ((telnet.number_of_ports) - 1 ) || port_number < 1)
	{
		/* Bad choice */
		sprintf(telnet.tx_buffer, EnterProperChoice,((telnet.number_of_ports) - 1)); 
		return(telnet.tx_buffer);
	}
	else
	{
		/* One of the ports */
/*	 	client_info_ptr->menustate = TMS_PPP_PORTINFO;  */
		client_info_ptr->menustate = TMS_MODI_PPPPORTINFO; 
		client_info_ptr->menu_selected_port = port_number-1;
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}
/* sudhir 19-9-96 */

BYTE	*ppp_port_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer)
	{
		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				client_info_ptr->menu_selected_port+1);
		return (telnet.tx_buffer);
	}

 	switch( atoi(buffer)) {
 		case 1 :   /*PPP_PORT_SETUP: */
			client_info_ptr->menustate = TMS_MODI_PPPPORTINFO;
			break;

 		/* case 2:     
			client_info_ptr->menustate = TMS_PPPPORTSTAT;
			break; */

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE	*modify_ppp_port_setup_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE user_password[60],pap_str[10],chap_str[10],dial_no[60],user_name[60];
	BYTE decrypted_pass[60];
	ULONG port_no = client_info_ptr->menu_selected_port+1, len;

   port_no = client_info_ptr->menu_selected_port;

   ReplyStrs[11].ReplyStr[0] = 0 ;
	get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].authentication.password,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &user_password[0], 60);

	decrypt ( &user_password[0],&decrypted_pass[0]);

	len = strlen (&decrypted_pass[0]);
	if (len)
		memset(&user_password[0], (int)'*', len);  
	user_password[len] = 0;

	if (!buffer)
	{
		initialize_replystr ();

		get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].enabled,
				port_no, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10);

		get_parameter (CM_CCP_SECTION, (void*)&ccp.ports[0].enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[1].ReplyStr[0], 10); 

		get_parameter (CM_VJC_SECTION, (void*)&vjc.port[0].vjc_compression_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, &ReplyStrs[2].ReplyStr[0], 10);

      #if 0 /* Sudha 23 Feb 1998 */
		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand,
				port_no, CM_STRING_FORMAT, &ReplyStrs[3].ReplyStr[0], 10);

		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout,
				port_no, CM_STRING_FORMAT, &ReplyStrs[4].ReplyStr[0], 10);

      #endif

      #if 0
      get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].client_only,
				port_no, CM_STRING_FORMAT, &ReplyStrs[3].ReplyStr[0], 10);
      #endif
      
      get_parameter (CM_WAN_SECTION, (void *) &wan.port[0].modem_info.strings.modem_dial_number,
				port_no, CM_STRING_FORMAT, &dial_no[0], 60); 

      get_parameter_by_name(CM_PPP_SECTION,"PAP",port_no,CM_STRING_FORMAT,
         &pap_str,10);

      get_parameter_by_name(CM_PPP_SECTION,"CHAP",port_no,CM_STRING_FORMAT,
         &chap_str,10);
      
      if ( (strcmp(pap_str,telnet_enabled_str) == 0 ) &&
           (strcmp(chap_str,telnet_enabled_str) == 0 ))
         strcpy (&ReplyStrs[4].ReplyStr[0],"PAP/CHAP");
      else if ( (strcmp(pap_str,telnet_enabled_str) == 0 ) &&
           (strcmp(chap_str,telnet_enabled_str) != 0 ))
         strcpy (&ReplyStrs[4].ReplyStr[0],"PAP only");
      else if ( (strcmp(pap_str,telnet_enabled_str) != 0 ) &&
           (strcmp(chap_str,telnet_enabled_str) == 0 ))
         strcpy (&ReplyStrs[4].ReplyStr[0],"CHAP only");
              
		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.user_name,
				port_no, CM_STRING_FORMAT, &user_name[0], 60);
      
		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.timeout,
				port_no, CM_STRING_FORMAT, &ReplyStrs[6].ReplyStr[0], 10);
         
		get_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.maximum_number_of_retries,
				port_no, CM_STRING_FORMAT, &ReplyStrs[7].ReplyStr[0], 10);

		sprintf (ChoiceBuffer, EnterChoice,
				menufsmhdlr[client_info_ptr->menustate].num_of_items);

		sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
			client_info_ptr->menu_selected_port+1,
			&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0], &ReplyStrs[2].ReplyStr[0],
			&dial_no[0], &ReplyStrs[4].ReplyStr[0], 
         &user_name[0], 
         user_password,&ReplyStrs[6].ReplyStr[0], 
         &ReplyStrs[7].ReplyStr[0], 
			GoBack, ChoiceBuffer);
		return(telnet.tx_buffer);
	}
	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= 1) &&
		(client_info_ptr->modify_option_rcvd <=
			menufsmhdlr[client_info_ptr->menustate].num_of_items))
	{
		client_info_ptr->menustate = TMS_MODI_UPD_PPPPORTINFO;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	{
		sprintf(telnet.tx_buffer, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(telnet.tx_buffer);
	}
}   	 
/* sudhir 19-9-96 */

BYTE *upd_modify_ppp_port_setup_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	ULONG  new_value, port_no;
	BYTE   *ret_str, *new_rhs,dial_no[60];

	memset(dial_no,0x00,60);

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case  MOD_PPP_PORT_ENABLE: 	
			case  MOD_PPP_PORT_DATACOMP: 	
			case  MOD_PPP_PORT_VJC_HC: 	
				ret_str = (BYTE *)EnaOrDis;
				break;

         #if 0 /* Sudha 23 Feb 1998 */
			case  MOD_PPP_PORT_DODE: 		
				ret_str = EnaOrDis;
				break;

			case  MOD_PPP_PORT_DOD_HANG: 	
				ret_str = NewValue;
				break;
        #endif

         case MOD_PPP_PORT_DIAL_NO				:	
            strcpy(temp_strn,"\n\rEnter new value of length within 40 : ");
            ret_str = temp_strn;
	   		break;
 
         case  MOD_PPP_PORT_AUTH_TYPE:
            ret_str = (BYTE *)AuthenticationType;
            break;
                        
			case  MOD_PPP_PORT_USER_NAME: ret_str = (BYTE *)NewValue;
												 	break;
			case  MOD_PPP_PORT_USER_PWD:  
						client_info_ptr->verifying_ppp_pwd = TRUE;
                  strcpy(temp_strn,"\n\rEnter password of length within 60 : ");
                  ret_str = temp_strn;
					 	break;

			case  MOD_PPP_PORT_TIMER	: 	
            sprintf(temp_strn,RangeNewValue,5,65535 );
            ret_str = temp_strn;
            break;

			case  MOD_PPP_PORT_RETRIES	: 	
            sprintf(temp_strn,RangeNewValue,3,65535 );
            ret_str = temp_strn;
			 	break;

			default:
			  sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
			  return(telnet.tx_buffer);
		}
		return (ret_str);
	}

	port_no = client_info_ptr->menu_selected_port ;
	new_value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case  MOD_PPP_PORT_ENABLE:
			if (new_value == 1)
				new_rhs = (BYTE *)&telnet_enabled_str[0];
			else if (new_value == 2)
				new_rhs = (BYTE *)&telnet_disabled_str[0];
			else
				return ((BYTE *)InvalidChoice);
			
			switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].enabled,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

		case  MOD_PPP_PORT_DATACOMP:
			if (new_value == 1)
				new_rhs = (BYTE *)&telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = (BYTE *)&telnet_disabled_str[0];
			else
				return ((BYTE *)InvalidChoice);


			switch (set_parameter (CM_CCP_SECTION, (void*)&ccp.ports[0].enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);
         }
			break;

		case  MOD_PPP_PORT_VJC_HC:
			if (new_value == 1)
				new_rhs = (BYTE *)&telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = (BYTE *)&telnet_disabled_str[0];
   		else
				return ((BYTE *)InvalidChoice);

			switch (set_parameter (CM_VJC_SECTION,(void*)&vjc.port[0].vjc_compression_enabled,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      #if 0 /* Sudha 23 Feb 1998 */
		case  MOD_PPP_PORT_DODE:
			if (new_value == 1)
				new_rhs = &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = &telnet_disabled_str[0];
			else
			 	return (InvalidChoice);

			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].dial_on_demand,
				port_no, CM_STRING_FORMAT, new_rhs))
			{

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;

	   case  MOD_PPP_PORT_DOD_HANG:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].idle_timeout,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return wrong_value;

				case CM_NOT_ENOUGH_MEMORY:
					return Insufficient_memory;

			}
			break;
      #endif

      case MOD_PPP_PORT_DIAL_NO				:
   			if (strlen (buffer) > 40)
	   			return ((BYTE *)InvalidChoice);

		   	strcpy(dial_no,buffer);
			   switch (set_parameter (CM_WAN_SECTION, (void *) &wan.port[0].modem_info.strings.modem_dial_number,
   				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, dial_no))
	   		{
		   		case CM_ERROR_WHILE_VALIDATING:
			   		return ((BYTE *)InvalidChoice);
               
   				case CM_NOT_ENOUGH_MEMORY:
	   				return ((BYTE *)Insufficient_memory);

		   	}
			   break;


      case  MOD_PPP_PORT_AUTH_TYPE :
         if ( new_value == 1 )
         {
            set_parameter_by_name ( CM_PPP_SECTION,"PAP",port_no,
               CM_STRING_FORMAT,telnet_enabled_str);
/*            set_parameter_by_name ( CM_PPP_SECTION,"CHAP",port_no,
               CM_STRING_FORMAT,telnet_disabled_str);*/
         }
         else if (new_value == 2 )
         {
/*            set_parameter_by_name ( CM_PPP_SECTION,"PAP",port_no,
               CM_STRING_FORMAT,telnet_disabled_str);*/
            set_parameter_by_name ( CM_PPP_SECTION,"CHAP",port_no,
               CM_STRING_FORMAT,telnet_enabled_str);
         }
         else if (new_value == 3 )
         {
            set_parameter_by_name ( CM_PPP_SECTION,"PAP OR CHAP",port_no,
               CM_STRING_FORMAT,telnet_enabled_str);
/*            set_parameter_by_name ( CM_PPP_SECTION,"CHAP",port_no,
               CM_STRING_FORMAT,telnet_enabled_str);*/
         }
         else
            return ((BYTE *)InvalidChoice);
         break;

	   case  MOD_PPP_PORT_USER_NAME:
			if (strlen (buffer) > 60)
				return ((BYTE *)InvalidChoice);
         new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.user_name,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      case  MOD_PPP_PORT_USER_PWD:
			if (strlen (buffer) > 60)
			{
				client_info_ptr->verifying_ppp_pwd = FALSE;
				ret_str = (BYTE *)&InvalidPass[0];
				return (ret_str);	
			}
			modify_config_visited = 1 ; 
			strcpy (password_str, buffer);
			client_info_ptr->menustate = TMS_RETRY_PASSWORD ;
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

      case  MOD_PPP_PORT_TIMER:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.timeout,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

      case  MOD_PPP_PORT_RETRIES:
			new_rhs = buffer;
			switch (set_parameter (CM_PPP_SECTION, (void*)&ppp.port[0].authentication.maximum_number_of_retries,
				port_no, CM_STRING_FORMAT, new_rhs))
			{
				case CM_ERROR_WHILE_VALIDATING:
					return ((BYTE *)wrong_value);

				case CM_NOT_ENOUGH_MEMORY:
					return ((BYTE *)Insufficient_memory);

			}
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	modify_config_visited = 1 ;
	client_info_ptr->menustate = TMS_MODI_PPPPORTINFO ;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
} 


BYTE *retry_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT port_no;


	if (!buffer)
		return ((BYTE *)retry_pass);

	client_info_ptr->verifying_ppp_pwd = FALSE;

	port_no = client_info_ptr->menu_selected_port ;
	if (strcmp (buffer, password_str))
		return ((BYTE *)wrong_pass);

   switch (set_parameter (CM_PPP_SECTION, (void *)&ppp.port[0].authentication.password,
				port_no, CM_STRING_FORMAT, buffer))
   {
     	case CM_NOT_ENOUGH_MEMORY:
			return ((BYTE *)Insufficient_memory);
   }

	client_info_ptr->menustate = TMS_MODI_PPPPORTINFO;
/*	client_info_ptr->echoing = FALSE; */
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE	*ppp_port_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	PPP_LCP_STATISTICS	*sptr_lcp_stats;
	PPP_LCP_MIBS	*sptr_lcp_mibs;
	PPP_NCP_STATISTICS	*sptr_ipcp_stats;
	PPP_AUTHENTICATION_STATISTICS	*sptr_auth_stats;

   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_PPP_STATISTICS;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;

			sptr_lcp_stats = &ppp.port[client_info_ptr->menu_selected_port].lcp_statistics;
			sptr_lcp_mibs = &ppp.port[client_info_ptr->menu_selected_port].lcp_mibs;

			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				client_info_ptr->menu_selected_port+1,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], sptr_lcp_stats->number_of_tx_packets),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], sptr_lcp_stats->number_of_tx_bytes),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], sptr_lcp_stats->number_of_rx_packets),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], sptr_lcp_stats->number_of_rx_bytes),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], sptr_lcp_mibs->pppLinkStatusBadAddresses),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], sptr_lcp_mibs->pppLinkStatusBadControls),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], sptr_lcp_mibs->pppLinkStatusPacketTooLongs),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], sptr_lcp_mibs->pppLinkStatusBadFCSs),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], sptr_lcp_mibs->pppLqrOutLQRs),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], sptr_lcp_mibs->pppLqrInLQRs));
			return(telnet.tx_buffer);
		case 1:
			client_info_ptr->more++;

/*			sptr_ipxcp_stats =&ppp.port[client_info_ptr->menu_selected_port].ncp[(enum NCP_STACK_INDEX)PPP_IPX_NCP_STACK_INDEX].statistics;
			sptr_ipcp_stats =&ppp.port[client_info_ptr->menu_selected_port].ncp[(enum NCP_STACK_INDEX)PPP_IP_NCP_STACK_INDEX].statistics; */
			sprintf(telnet.tx_buffer, PPPPortStats2,
				client_info_ptr->menu_selected_port+1,
/*				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], sptr_ipxcp_stats->number_of_tx_packets),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], sptr_ipxcp_stats->number_of_tx_bytes),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], sptr_ipxcp_stats->number_of_rx_packets),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], sptr_ipxcp_stats->number_of_rx_bytes), */

				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], sptr_ipcp_stats->number_of_tx_packets),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], sptr_ipcp_stats->number_of_tx_bytes),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], sptr_ipcp_stats->number_of_rx_packets),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], sptr_ipcp_stats->number_of_rx_bytes));
			return(telnet.tx_buffer);
		case 2:
			client_info_ptr->more++;

			sptr_auth_stats =&ppp.port[client_info_ptr->menu_selected_port].authentication.statistics;
			sprintf(telnet.tx_buffer, PPPPortStats3,
				client_info_ptr->menu_selected_port+1,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], sptr_auth_stats->number_of_tx_packets),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], sptr_auth_stats->number_of_tx_bytes),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], sptr_auth_stats->number_of_rx_packets),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], sptr_auth_stats->number_of_rx_bytes));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}

BYTE * auth_protocol_string (USHORT_ENUM (PPP_PROTOCOL_TYPE) protocol)
{
	switch (protocol) {
		case IP_PROTOCOL: return ("IP");
		case IPX_PROTOCOL: return ("IPX");
		case APPLETALK_PROTOCOL: return ("APPLETALK");
		case VAN_JACOBSON_COMPRESSED_PROTOCOL: return ("VJ_COMPRESSED");
		case VAN_JACOBSON_UNCOMPRESSED_PROTOCOL: return ("VJ_UNCOMPRESSED");
		case BRIDGING_PROTOCOL: return ("BRIDGING");
		case NETBIOS_PROTOCOL : return ("NETBIOS");

		case _8021D_SPANNING_TREE_BPDU : return ("802.1D");
		case SOURCE_ROUTING_BPDU : return ("SOURCE_ROUTING");
		case DEC_LAN_BRIDGE_100 : return ("DEC_LAN_BRIDGE_100");

		case IPCP_PROTOCOL : return ("IPCP");
		case IPXCP_PROTOCOL: return ("IPXCP");
		case ATCP_PROTOCOL : return ("ATCP");
		case BCP_PROTOCOL : return ("BCP");
		case NBFCP_PROTOCOL: return ("NBFCP");
	
		case LCP_PROTOCOL : return ("LCP");
		case PAP_PROTOCOL : return ("PAP");
		case CHAP_PROTOCOL: return ("CHAP");
		case LINK_QUALITY_PROTOCOL: return ("LINK_QUALITY");
		default: return ("Unknown");
	}
}

BYTE *ipxcp_compr_protocol_string( USHORT_ENUM(IPXCP_COMPRESSION_OPTION_TYPE) protocol)
{
	switch (protocol) {
		case TELEBIT_IPX_COMPRESSION:
			return ("TELEBIT IPX");
		case SHIVA_COMPRESSED_NCP_IPX:
			return ("SHIVA	COMPRESSED NCP");
		default:
			return ("Unknown");
	}
}

BYTE *ipxcp_route_protocol_string( USHORT_ENUM (IPXCP_ROUTING_PROTOCOL_TYPE) protocol)
{
	 switch (protocol) 
    {
		case NO_IPXCP_ROUTING_PROTOCOL_REQUIRED:
			return ("Not Required");
		case NOVELL_RIP_SAP_REQUIRED:
			return ("NOVELL RIP-SAP");
		case NOVELL_NLSP_REQUIRED:
			return ("NOVELL NLSP");
		default:
			return ("Unknown");
	 }
}

int  checkif_fr_enabled()
{
		
/*	get_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].all_other_parameters,
				0, CM_STRING_FORMAT, &ReplyStrs[0].ReplyStr[0], 10); */


	if (strcmp (&ReplyStrs[0].ReplyStr[0], telnet_disabled_str))
		return 1;
	else
		return 0;

}


BYTE *confirm_client_only (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *new_rhs;

	if (!buffer)
		return ((BYTE *)ClientOnlymes);

	if (*buffer == 'Y' || *buffer == 'y')
	{
		new_rhs = (BYTE *)&telnet_enabled_str[0];
		switch (set_parameter (CM_PPP_SECTION, (void *) &ppp.port[0].client_only,
				client_info_ptr->menu_selected_port, CM_STRING_FORMAT, new_rhs))
 		{
 			case CM_NOT_ENOUGH_MEMORY:
 				return ((BYTE *)Insufficient_memory);
 		}
		modify_config_visited = 1;
		client_info_ptr->menustate = TMS_MODI_PPPPORTINFO ;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else if (*buffer == 'N' || *buffer == 'n')
	{
		client_info_ptr->menustate = TMS_MODI_PPPPORTINFO ;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return ((BYTE *)InvalidChoice);
}
