#include <defs.h>

#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

#include <kstart.h>
#include	<v8022str.h>
#include	<vethstr.h>
#include	<lslproto.h>
#include <socklib.h>
#include <stddef.h>


#include	"telnet.h"
#include	"vmenu.h"

#include <incall.h>

#if 0
#include "..\..\include\vnvrmstr.h"		  
#endif

#include <cfgmgr.h>

PARAMETER_NODE *ptr_to_current_proxy_node;
STRUCT_PROXY_ENTRY *dummy_proxy_application_ptr;
STRUCT_PROXY_ENTRY dup_proxy_application_ptr;
STRUCT_PROXY_ENTRY temp_proxy_application;	

/* sudha 18 Jan 1999 */
STRUCT_PROXY_USER_ENTRY *dummy_proxy_user_application_ptr;
STRUCT_PROXY_USER_ENTRY dup_proxy_user_application_ptr;
STRUCT_PROXY_USER_ENTRY temp_proxy_user_application;	
STRUCT_PROXY_USER_ENTRY *dummy_proxy_user_application_edit_ptr;
STRUCT_PROXY_USER_ENTRY dup_proxy_user_application_edit_ptr;

STRUCT_PROXY_FILTER *dummy_proxy_addr_filter;
STRUCT_PROXY_FILTER dup_proxy_addr_filter;
STRUCT_PROXY_FILTER temp_proxy_addr_filter;

BYTE menu_ptr[30];
BYTE lhs_string[50];
BYTE filter_string[50] = "Proxy Application Filter";

extern int modify_config_visited;
extern BYTE is_an_ip_address(BYTE* address);

extern USHORT get_protocol_port_number (USHORT protocol_type, USHORT application_index);
extern char *get_protocol_type (char *protocol_type_string, USHORT protocol_type);
extern char *get_port_type (char *port_type_string, USHORT, USHORT protocol_port_number);

extern BOOL is_user_defined_port_not_in_reserved_port_list(USHORT lower_port,USHORT higher_port);
extern BOOL is_user_defined_port_desc_not_in_reserved_port_desc(BYTE user_desc[16]);
extern BOOL IsStrNumericAndValid(char *Str);

extern enum TEST_RESULT is_user_defined_port_range_unique(USHORT lower_port, USHORT higher_port,USHORT protocol);
extern BOOL is_user_defined_port_desc_not_a_duplicate(BYTE user_desc[16], USHORT protocol);

/* sudha 19 Aug 1999 */
extern void get_ftp_port_numbers(USHORT *ctrl_port, USHORT *data_port);

BYTE tcp_application_list[] =
"\n\r\
\n\r\
[ 1] CHAT (531)          [ 2] DNS (53)            [ 3] ECHO (7)\n\r\
[ 4] FINGER (79)         [ 5] FTP (%d,%d)         [ 6] GOPHER (70)\n\r\
[ 7] NEWS (144)          [ 8] POP-3 (110)         [ 9] READNEWS (532)\n\r\
[10] RLOGIN (513)        [11] SMTP (25)           [12] TELNET (23)\n\r\
[13] TFTP (69)           [14] HTTP (80)           [15] HOST NAME SERVER(42)\n\r\
[16] HTTPS (443)         [17] IRC (194)           [18] NNTP (119)\n\r\
[19] SSL-NNTP (563)      [20] SSL-SMTP (465)      [21] IMAP (143)\n\r\
[22] SNMP (161)          [23] SNMP-TRAP (162)     [24] IMAP3 (220)\n\r\
[25] SSL-FTP (989, 990)  [26] SSL-Telnet (992)    [27] SSL-IMAP4 (993)\n\r\
[28] SSL-IRC (994)       [29] SSL-POP3 (995)      [30] Real audio/video (1090)\n\r\
[31] PPTP (1723)         [32] MIRC (6667)         [33] MS-Streaming (1755)\n\r\
[34] Vxtreme (8000)      [35] Real audio/video (7070)\n\r\
[36] AOL (5190)          [37] Q931 (900,902)      [38] RTP (5004,5006)\n\r\
[39] RTCP (5005,5007)    [40] VOIP - Statistics (5000)\n\r\
[41] Road Runner1 (6284) [42] Road Runner2 (6285) [43] Road Runner3 (7283)\n\r\
[44] Others\n\r\
\n\r\
Enter Your Choice (1 to 44) : ";

BYTE tcp_edit_application_list[] =
"\n\r\
\n\r\
[ 1] CHAT (531)          [ 2] DNS (53)            [ 3] ECHO (7)\n\r\
[ 4] FINGER (79)         [ 5] FTP (%d,%d)         [ 6] GOPHER (70)\n\r\
[ 7] NEWS (144)          [ 8] POP-3 (110)         [ 9] READNEWS (532)\n\r\
[10] RLOGIN (513)        [11] SMTP (25)           [12] TELNET (23)\n\r\
[13] TFTP (69)           [14] HTTP (80)           [15] HOST NAME SERVER(42)\n\r\
[16] HTTPS (443)         [17] IRC (194)           [18] NNTP (119)\n\r\
[19] SSL_NNTP (563)      [20] SSL_SMTP (465)      [21] IMAP (143)\n\r\
[22] SNMP (161)          [23] SNMP-TRAP (162)     [24] IMAP3 (220)\n\r\
[25] SSL-FTP (989, 990)  [26] SSL-Telnet (992)    [27] SSL-IMAP4 (993)\n\r\
[28] SSL-IRC (994)       [29] SSL-POP3 (995)      [30] Real audio/video (1090)\n\r\
[31] PPTP (1723)         [32] MIRC (6667)         [33] MS-Streaming (1755)\n\r\
[34] Vxtreme (8000)      [35] Real audio/video (7070)\n\r\
[36] AOL (5190)          [37] Q931 (900,902)      [38] RTP (5004,5006)\n\r\
[39] RTCP (5005,5007)    [40] VOIP - Statistics (5000)\n\r\
[41] Road Runner1 (6284) [42] Road Runner2 (6285) [43] Road Runner3 (7283)\n\r\
\n\r\
Enter Your Choice (1 to 43) : ";

BYTE udp_application_list[] = 
"\n\r\
[ 1] CHAT (531)          [ 2] DNS (53)            [ 3] ECHO (7)\n\r\
[ 4] FINGER (79)         [ 5] FTP (%d,%d)         [ 6] GOPHER (70)\n\r\
[ 7] NEWS (144)          [ 8] POP-3 (110)         [ 9] READNEWS (532)\n\r\
[10] SMTP (25)           [11] TELNET (23)         [12] TFTP (69)\n\r\
[13] HTTP (80)           [14] HOST NAME SERVER(42)\n\r\
[15] HTTPS (443)         [16] IRC (194)           [17] NNTP (119)\n\r\
[18] SSL_NNTP (563)      [19] SSL_SMTP (465)      [20] IMAP (143)\n\r\
[21] SNMP (161)          [22] SNMP-TRAP (162)     [23] IMAP3 (220)\n\r\
[24] SSL-FTP (989, 990)  [25] SSL-Telnet (992)    [26] SSL-IMAP4 (993)\n\r\
[27] SSL-IRC (994)       [28] SSL-POP3 (995)      [29] Real audio/video (1090)\n\r\
[30] PPTP (1723)         [31] MIRC (6667)         [32] MS-Streaming (1755)\n\r\
[33] Vxtreme (8000)      [34] Real audio/video (7070)\n\r\
[35] AOL (5190)          [36] Q931 (900,902)      [37] RTP (5004,5006)\n\r\
[38] RTCP (5005,5007)    [39] VOIP - Statistics (5000)\n\r\
[40] Road Runner1 (6284) [41] Road Runner2 (6285) [42] Road Runner3 (7283)\n\r\
[43] Others\n\r\
\n\r\
Enter Your Choice (1 to 43) : ";

BYTE udp_edit_application_list[] = 
"\n\r\
[ 1] CHAT (531)          [ 2] DNS (53)            [ 3] ECHO (7)\n\r\
[ 4] FINGER (79)         [ 5] FTP (%d,%d)         [ 6] GOPHER (70)\n\r\
[ 7] NEWS (144)          [ 8] POP-3 (110)         [ 9] READNEWS (532)\n\r\
[10] SMTP (25)           [11] TELNET (23)         [12] TFTP (69)\n\r\
[13] HTTP (80)           [14] HOST NAME SERVER(42)\n\r\
[15] HTTPS (443)         [16] IRC (194)           [17] NNTP (119)\n\r\
[18] SSL_NNTP (563)      [19] SSL_SMTP (465)      [20] IMAP (143)\n\r\
[21] SNMP (161)          [22] SNMP-TRAP (162)     [23] IMAP3 (220)\n\r\
[24] SSL-FTP (989, 990)  [25] SSL-Telnet (992)    [26] SSL-IMAP4 (993)\n\r\
[27] SSL-IRC (994)       [28] SSL-POP3 (995)      [29] Real audio/video (1090)\n\r\
[30] PPTP (1723)         [31] MIRC (6667)         [32] MS-Streaming (1755)\n\r\
[33] Vxtreme (8000)      [34] Real audio/video (7070)\n\r\
[35] AOL (5190)          [36] Q931 (900,902)      [37] RTP (5004,5006)\n\r\
[38] RTCP (5005,5007)    [39] VOIP - Statistics (5000)\n\r\
[40] Road Runner1 (6284) [41] Road Runner2 (6285) [42] Road Runner3 (7283)\n\r\
Enter Your Choice (1 to 42) : ";

/* sudha 18 Nov 1998 */

BYTE ProxyMenu[]=
"\n\r\
\n\r\
        << ProxyServer Application Configuration Menu >>\n\r\
\n\r\
[ 1] Proxy Any Application    : %s\n\r\
[ 2] FTP Control Port Number  : %s\n\r\
[ 3] FTP Data Port Number     : %s\n\r\
[ 4] ProxyServer Application\n\r\
[ 5] Filters\n\r\
\n\r\
Go Back to \"Proxy Server Management\" menu to save changes.\n\r\
\n\r\
Enter your choice ( 1 to 5,exit or ESC to PREV menu ) : ";

const BYTE ProxyFiltersMenu[]=
"\n\r\
\n\r\
                << ProxyServer Filters Menu >>\n\r\
\n\r\
[ 1] Internet Sites (IP Address)\n\r\
[ 2] Internet Sites (Domain Name)\n\r\
[ 3] Client Workstations (IP Address)\n\r\
[ 4] Client Workstations (MAC Address)\n\r\
[ 5] Applications\n\r\
\n\r\
Enter your choice ( 1 to 5,exit or ESC to PREV menu ) : ";

BYTE ProxyAddrFilter[]=
"\n\r\
\n\r\
                << ProxyServer %s Filter >>\n\r\
\n\r\
[ 1]  Enter %s Address          : %s\n\r\
\n\r\
Enter your choice ( 1, exit or ESC to PREV menu, C : Confirm changes ) : ";

BYTE ProxyAddrFilterDB[]=
"\n\r\
\n\r\
        << ProxyServer %s Filter Database >>\n\r\
\n\r\
\n\r\
     Index     Address\n\r\
     -----     -------\n\r\
\n\r\
\n\r";

BYTE ProxyAppDB[]=
"\n\r\
\n\r\
                      << Proxy Server Application %s Table>>\n\r\
\n\r\
    Index   Protocol      Port\n\r\
    -----   --------   ----------\n\r\
\n\r\
\n\r";


BYTE ProxyAppSMenu[] = 
"\n\r\
\n\r\
1. Protocol             : %s\n\r\
2. Application Port     : %s (%05d)\n\r\
\n\r\
Enter Choice (1 to 2, exit  C: confirm Changes): ";

BYTE ProxyAppSRangeMenu[] =
"\n\r\
\n\r\
1. Protocol             : %s\n\r\
2. Application Port     : %s (%05d,%05d)\n\r\
\n\r\
Enter Choice (1 to 2, exit, C: confirm Changes): ";

BYTE ProxyAppPortRangeMenu[] =
"\n\r\
\n\r\
1. Protocol                 : %s\n\r\
2. Lower Port               : %05d\n\r\
3. Higher Port              : %05d\n\r\
4. User Defined Descrption  : %s\n\r\
\n\r\
Note : Higher port number is 0 for no range.\n\r\
\n\r\
Enter Choice (2 to 4, exit, A: Add): ";

BYTE is_valid_mac_address(BYTE* string_ptr)
{
	BYTE i;

   if ( (strlen(string_ptr) < 1 ) || (strlen(string_ptr) > 12 ))
      return FALSE;
   if ( !strcmp(string_ptr,"000000000000"))
      return FALSE;
  	for(i=0;i<strlen(string_ptr);++i)
   {
	   if (string_ptr[i] < '0' || (string_ptr[i] > '9' && string_ptr[i] < 'A') || (string_ptr[i] > 'F' && string_ptr[i] < 'a') || string_ptr[i] > 'f')
  		{
   		return FALSE;
	   }
  	}
   return TRUE;
}

void format_the_mac_address(BYTE* string_ptr)
{
	int string_length, i;
	char temp_buff[200] ;
	int number_of_zeros_to_be_inserted ;
	
	string_length = strlen(string_ptr);
	if (string_length == 12)
		return;
	memset (&temp_buff[0], '0', 200) ;

	number_of_zeros_to_be_inserted = 12 - string_length;

	for (i = number_of_zeros_to_be_inserted ; i < 12 ; i++)
		temp_buff[i] = string_ptr[i-number_of_zeros_to_be_inserted] ;
	temp_buff[12] = 0 ;

	strcpy(string_ptr, temp_buff);
}

BYTE is_valid_dns_address(BYTE* string_ptr)
{
   char delim = '.';
   int length = 0,token_len = 0;
   char *token, *ptr_to_space;
   char temp_str[256];
   
   if ((strlen(string_ptr) < 1) || (strlen(string_ptr) > 255))
      return FALSE;
   
   ptr_to_space = strchr (string_ptr, ' ');
   if (ptr_to_space)
   {
      printf("\n\rInvalid DNS Name.Space found.\n");
      return FALSE;
   }

   strcpy(temp_str,string_ptr);
   token = strtok ( temp_str,delim );
   while ( token != NULL )
   {
      token_len = strlen ( token );
      if ( token_len > 64 )
         return FALSE;
      else
      {
         
         length = length + strlen ( token ) + 1;
         token = strtok(&temp_str[length],delim);
      }
   }
   return TRUE;
}

void initialize_proxy_server_applications ()
{
	temp_proxy_application.port = 0;
	temp_proxy_application.protocol = 0;
}

void initialize_proxy_server_user_applications ()
{
	temp_proxy_user_application.lower_port = 0;
	temp_proxy_user_application.higher_port = 0;
	strcpy(temp_proxy_user_application.descrptn,"");
}

BYTE *proxy_main_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   if (!buffer) 
	{
		initialize_replystr ();

      get_parameter (CM_PROXY_SECTION, &proxy_server.proxy_any_application_enabled, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&ReplyStrs[0].ReplyStr[0], 10);

      get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_ctrl_conn_port, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&ReplyStrs[1].ReplyStr[0], 10);

      get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_data_conn_port, 
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, (void*)&ReplyStrs[2].ReplyStr[0], 10);

		sprintf (telnet.tx_buffer, ProxyMenu,
			&ReplyStrs[0].ReplyStr[0], &ReplyStrs[1].ReplyStr[0],
			&ReplyStrs[2].ReplyStr[0]);

		return(telnet.tx_buffer);
	}

	client_info_ptr->modify_option_rcvd = atoi(buffer);

	if (client_info_ptr->modify_option_rcvd >= PROXY_ANY_APP && client_info_ptr->modify_option_rcvd <= PROXY_FILTER_INFO)  
	{															
		client_info_ptr->menustate = TMS_MODI_UPD_PROX_APP;
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}

BYTE *proxy_modify_info_hdlr (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE  *ret_str;
	BYTE  *new_rhs; 
	USHORT new_value = 0, higher_port = 0, protocol = 0x0006;
	USHORT ftp_prev_ctrl_port = 0, ftp_prev_data_port = 0;
	enum TEST_RESULT result;
	STRUCT_PROXY_ENTRY ptr_to_old_proxy_app, ptr_to_new_proxy_app;	

	get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_ctrl_conn_port, 
		CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, (void*)&ftp_prev_ctrl_port, sizeof(USHORT));

	get_parameter (CM_PROXY_SECTION, &proxy_server.ftp_data_conn_port, 
		CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, (void*)&ftp_prev_data_port, sizeof(USHORT));

	if (!buffer)
	{
	 	switch (client_info_ptr->modify_option_rcvd) 
   	{
	 		case PROXY_ANY_APP:			
				ret_str = (BYTE *)EnaOrDis;
				break;
	
	 		case PROXY_FTP_CTRL_PORT:			
				ret_str = (BYTE *)NewValue;
				break;

	 		case PROXY_FTP_DATA_PORT:			
				ret_str = (BYTE *)NewValue;
				break;

	 		case PROXY_APP_INFO:			
				client_info_ptr->menustate = TMS_MODI_PROXY;
   	      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_MAIN_PROXY;
        		strcpy(menu_ptr,"");
	         strcpy(lhs_string,"Proxy");
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

				break;

      	case PROXY_FILTER_INFO:				
				client_info_ptr->menustate = TMS_PROXY_FILTERS;
				return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

				break;

			default:
				sprintf(telnet.tx_buffer, EnterProperChoice, 
					menufsmhdlr[client_info_ptr->menustate].num_of_items);
				return(telnet.tx_buffer);
		}
	   return(ret_str);
	}

	new_value = atoi(buffer);
	switch (client_info_ptr->modify_option_rcvd) 
	{
		case PROXY_ANY_APP:
			if (new_value == 1)
				new_rhs = (BYTE *) &telnet_enabled_str[0];
			else
				if (new_value == 2)
					new_rhs = (BYTE *)&telnet_disabled_str[0];
			else
				return (BYTE *)(InvalidChoice);

			switch (set_parameter_by_name (CM_PROXY_SECTION, "Proxy Any Application",
				CM_NO_PORT_PARAMETER_PRESENT, CM_STRING_FORMAT, new_rhs))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return (BYTE *)Insufficient_memory;
			}
         break;
		
		case PROXY_FTP_CTRL_PORT:
			if (!*buffer)
			{
 				sprintf(buffer,"%d", FTP21);
				new_value = FTP21;
			}

			if ((IsStrNumericAndValid(buffer) == FALSE) || (new_value == 0))
				return("\n\rUnknown Port type.Re-Enter value from 1 to 65535 .\n\r\
Enter ( Esc Or exit ) : ");				

			if (new_value == ftp_prev_data_port)
				return ("\n\rEntered value conflict with ftp data port entry.\n\r\
Enter ( Esc Or exit ) : ");				

			if ((is_user_defined_port_not_in_reserved_port_list(new_value, higher_port) == FALSE)
				&& (new_value != ftp_prev_ctrl_port) && 
					(new_value != ftp_prev_data_port))
				return ("\n\rEntered value conflict with reserved port entries.\n\r\
Enter ( Esc Or exit ) : ");				

			result = is_user_defined_port_range_unique(new_value, higher_port, protocol);
			if (( result == PROXY_ENTRY )	&& 
				(new_value != ftp_prev_ctrl_port) && 
					(new_value != ftp_prev_data_port))
			{
				return ("\n\r\Entered value conflict with proxy port entries.\n\r\
Enter ( Esc Or exit ) : ");				
			}
			else if (( result == PROXY_RANGE_ENTRY ) &&
				(new_value != ftp_prev_ctrl_port) && 
					(new_value != ftp_prev_data_port))
			{
				return ("\n\r\Entered value conflict with proxy port range entries.\n\r\
Enter ( Esc Or exit ) : ");				
			}

			switch (set_parameter (CM_PROXY_SECTION,&proxy_server.ftp_ctrl_conn_port,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, (void *)&new_value))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return (BYTE *)Insufficient_memory;
			}
			
			ptr_to_old_proxy_app.protocol = 0; /* TCP_PROTOCOL */
			ptr_to_old_proxy_app.port = ftp_prev_ctrl_port;

			ptr_to_new_proxy_app.protocol = 0; /* TCP_PROTOCOL */
			ptr_to_new_proxy_app.port = new_value;

	      cm_edit_string (CM_PROXY_SECTION, "Proxy", (void *)&ptr_to_old_proxy_app,(void *) &ptr_to_new_proxy_app);

			ptr_to_old_proxy_app.protocol = 1; /* UDP_PROTOCOL */
			ptr_to_new_proxy_app.protocol = 1; /* UDP_PROTOCOL */

	      cm_edit_string (CM_PROXY_SECTION, "Proxy", (void *)&ptr_to_old_proxy_app,(void *) &ptr_to_new_proxy_app);

         break;

		case PROXY_FTP_DATA_PORT:
			if (!*buffer)
			{
 				sprintf(buffer,"%d",FTP20);
				new_value = FTP20;
			}

			if (new_value == ftp_prev_ctrl_port)
				return ("\n\rEntered value conflict with ftp control port entry.\n\r\
Enter ( Esc Or exit ) : ");				

			if ((IsStrNumericAndValid(buffer) == FALSE) || (new_value == 0))
				return("\n\rUnknown Port type.Re-Enter value from 1 to 65535.\n\r\
Enter ( Esc Or exit ) : ");				

			if ((is_user_defined_port_not_in_reserved_port_list(new_value, higher_port) == FALSE) 
				&& (new_value != ftp_prev_ctrl_port) && (new_value != ftp_prev_data_port))
				return ("\n\rEntered value conflict with reserved port entries.\n\r\
Enter ( Esc Or exit ) : ");				

			result = is_user_defined_port_range_unique(new_value, higher_port, protocol);
			if (( result == PROXY_ENTRY )	&& 
				(new_value != ftp_prev_ctrl_port) && 
					(new_value != ftp_prev_data_port))
			{
				return ("\n\r\Entered value conflict with proxy port entries.\n\r\
Enter ( Esc Or exit ) : ");				
			}
			else if (( result == PROXY_RANGE_ENTRY ) &&
				(new_value != ftp_prev_ctrl_port) && 
					(new_value != ftp_prev_data_port))
			{
				return ("\n\r\Entered value conflict with proxy port range entries.\n\r\
Enter ( Esc Or exit ) : ");				
			}

			switch (set_parameter (CM_PROXY_SECTION,&proxy_server.ftp_data_conn_port,
				CM_NO_PORT_PARAMETER_PRESENT, CM_USHORT_FORMAT, (void *)&new_value))
			{
				case CM_NOT_ENOUGH_MEMORY:
					return (BYTE *)Insufficient_memory;
			}

			ptr_to_old_proxy_app.protocol = 0; /* TCP_PROTOCOL */
			ptr_to_old_proxy_app.port = ftp_prev_data_port;

			ptr_to_new_proxy_app.protocol = 0; /* TCP_PROTOCOL */
			ptr_to_new_proxy_app.port = new_value;

	      cm_edit_string (CM_PROXY_SECTION, "Proxy", (void *)&ptr_to_old_proxy_app,(void *) &ptr_to_new_proxy_app);

			ptr_to_old_proxy_app.protocol = 1; /* UDP_PROTOCOL */
			ptr_to_new_proxy_app.protocol = 1; /* UDP_PROTOCOL */

	      cm_edit_string (CM_PROXY_SECTION, "Proxy", (void *)&ptr_to_old_proxy_app,(void *) &ptr_to_new_proxy_app);

         break;

		case PROXY_APP_INFO:
		case PROXY_FILTER_INFO:
			break;
	}
	modify_config_visited = 1 ; 
	client_info_ptr->menustate = TMS_MAIN_PROXY ;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

}

BYTE *proxy_server_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	STRUCT_PROXY_ENTRY *ptr_to_proxy_application;
	STRUCT_PROXY_ENTRY proxy_server_application;

	STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_application;
	STRUCT_PROXY_USER_ENTRY proxy_server_user_application;

	USHORT index=0;
	BOOL proxy_user_defined_entries_over = FALSE;
	BYTE temp_buff[200], protocol_buff[25], port_buff[20],temp_db[100];
   BYTE *ptr_lhs_string, *app_info_lhs;

	
	ptr_lhs_string = &lhs_string;		
	app_info_lhs = "Proxy Application Info";

	if (!buffer)
	{
/* sudha taken from Ravi On 18 Nov 1998 ... */
	   client_info_ptr->edit_filter = 0;
/* ... sudha taken from Ravi On 18 Nov 1998 */
		if (client_info_ptr->next_screen)
		{
			if ( strstr ( lhs_string,filter_string ) == NULL )
			{
				if (ptr_to_current_proxy_node != NULL)
				{
					if (( strstr ( (BYTE *)ptr_to_current_proxy_node->parameter,app_info_lhs) != NULL)  ||
						( strstr ( (BYTE *)ptr_to_current_proxy_node->next->previous->parameter,app_info_lhs) != NULL))
					{
				      ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_server_user_application);
      				sprintf(temp_db,ProxyAppDB,menu_ptr);
						strcpy (telnet.tx_buffer, temp_db);
						goto PROXY_USER;

					}
					else
		   		   ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_server_application);
				}
				else
				{
					if ( proxy_user_defined_entries_over == TRUE )
						goto PROXY_USER;
				}
			}
			else
				if (ptr_to_current_proxy_node != NULL)
		   	   ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_server_application);
		}
		else
		{
         ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string, (void *) &proxy_server_application);
         if (ptr_to_current_proxy_node == NULL)
         {
				if ( strstr ( lhs_string,filter_string ) == NULL )
				{
					ptr_lhs_string = "Proxy User App";
				   ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string, (void *) &proxy_server_user_application);
	   			if (ptr_to_current_proxy_node == NULL)
					{
         		   client_info_ptr->no_filters = 1;
            		sprintf (temp_db,ProxyAppDB,menu_ptr);
						strcpy (telnet.tx_buffer, temp_db);
						strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
						return telnet.tx_buffer;
					}
					else
					{
				      client_info_ptr->index = 1;
						goto PROXY_USER;
					}
				}
				else
				{
         	   client_info_ptr->no_filters = 1;
            	sprintf (temp_db,ProxyAppDB,menu_ptr);
					strcpy (telnet.tx_buffer, temp_db);
					strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
					return telnet.tx_buffer;
         	}
			}
         client_info_ptr->index = 1;
		}

      sprintf(temp_db,ProxyAppDB,menu_ptr);
		strcpy (telnet.tx_buffer, temp_db);

		if (client_info_ptr->next_screen)
      {
         index++;
      	sprintf (temp_buff,"     %3d.       %-4s      %s (%05d)\n\r", 
            client_info_ptr->index++,
				get_protocol_type (protocol_buff, dummy_proxy_application_ptr->protocol),
				get_port_type (port_buff, dummy_proxy_application_ptr->protocol,dummy_proxy_application_ptr->port),
				dummy_proxy_application_ptr->port);
			strcat (telnet.tx_buffer,temp_buff);
			if (ptr_to_current_proxy_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto PROXY_USER1;
			}
		}				
		ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) &proxy_server_application;
			
		while (ptr_to_proxy_application != NULL)
	   {
   	   client_info_ptr->no_filters = 0;
      	index++;
      	sprintf (temp_buff,"     %3d.       %-4s      %s (%05d)\n\r", 
           	client_info_ptr->index++,
           	get_protocol_type (protocol_buff, ptr_to_proxy_application->protocol),
           	get_port_type (port_buff, ptr_to_proxy_application->protocol, ptr_to_proxy_application->port),
				ptr_to_proxy_application->port);
      	strcat (telnet.tx_buffer,temp_buff);
			
			if (ptr_to_current_proxy_node != NULL)
	  	      ptr_to_current_proxy_node =  cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void*)&proxy_server_application);

	      if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_proxy_node != NULL)
	      {
				memcpy ((char *) &dup_proxy_application_ptr, (char *) &proxy_server_application, sizeof (STRUCT_PROXY_ENTRY));
				dummy_proxy_application_ptr = (STRUCT_PROXY_ENTRY *) &dup_proxy_application_ptr;
            client_info_ptr->next_screen++;
				goto SENDFILT_IPA;
	      }
   	   if (ptr_to_current_proxy_node == NULL)
      	{
         	client_info_ptr->next_screen = 0;
            break;
	      }
   	   ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) &proxy_server_application;
	   }

PROXY_USER1 :
		if ( strstr ( lhs_string,filter_string ) == NULL )
		{
			ptr_lhs_string = "Proxy User App";
		   ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string, (void *) &proxy_server_user_application);
	   	if (ptr_to_current_proxy_node == NULL)
			{
   	     	client_info_ptr->next_screen = 0;
	   	   goto SENDFILT_IPA;
			}
PROXY_USER :
			if (client_info_ptr->next_screen)
      	{
         	index++;
				if ( dummy_proxy_user_application_ptr->higher_port == 0 )
   	   		sprintf (temp_buff,"     %3d.        %-4s       %s (%05d)\n\r", 
			     		client_info_ptr->index++,
						get_protocol_type (protocol_buff, dummy_proxy_user_application_ptr->protocol),
        				dummy_proxy_user_application_ptr->descrptn, 
						dummy_proxy_user_application_ptr->lower_port);
				else
   	   		sprintf (temp_buff,"     %3d.        %-4s       %s (%05d,%05d)\n\r", 
			     		client_info_ptr->index++,
						get_protocol_type (protocol_buff, dummy_proxy_user_application_ptr->protocol),
        				dummy_proxy_user_application_ptr->descrptn, 
						dummy_proxy_user_application_ptr->lower_port,
						dummy_proxy_user_application_ptr->higher_port);

				strcat (telnet.tx_buffer,temp_buff);
				if (ptr_to_current_proxy_node == NULL)
      	   {
         	   client_info_ptr->next_screen = 0;
            	goto SENDFILT_IPA;
				}
			}				

			ptr_to_proxy_user_application = (STRUCT_PROXY_USER_ENTRY *) &proxy_server_user_application;
			
			while (ptr_to_proxy_user_application != NULL)
			{
  	   		client_info_ptr->no_filters = 0;
		  		index++;
				if ( ptr_to_proxy_user_application->higher_port == 0 )
   	   		sprintf (temp_buff,"     %3d.        %-4s       %s (%05d)\n\r", 
			     		client_info_ptr->index++,
						get_protocol_type (protocol_buff,ptr_to_proxy_user_application->protocol),
        				ptr_to_proxy_user_application->descrptn, 
						ptr_to_proxy_user_application->lower_port);
				else
   	   		sprintf (temp_buff,"     %3d.        %-4s       %s (%05d,%05d)\n\r", 
			     		client_info_ptr->index++,
						get_protocol_type (protocol_buff,ptr_to_proxy_user_application->protocol),
        				ptr_to_proxy_user_application->descrptn, 
						ptr_to_proxy_user_application->lower_port,
						ptr_to_proxy_user_application->higher_port);
			  	strcat (telnet.tx_buffer,temp_buff);
				if (ptr_to_current_proxy_node != NULL)
			      ptr_to_current_proxy_node =  cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void*)&proxy_server_user_application);
  				if (ptr_to_current_proxy_node == NULL)
					proxy_user_defined_entries_over = TRUE ;
		   	if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_proxy_node != NULL)
			   {
					memcpy ((char *) &dup_proxy_user_application_ptr, (char *) &proxy_server_user_application, sizeof (STRUCT_PROXY_USER_ENTRY));
						dummy_proxy_user_application_ptr = (STRUCT_PROXY_USER_ENTRY *) &dup_proxy_user_application_ptr;
	   		   client_info_ptr->next_screen++;
        			break;
			   }
  				if (ptr_to_current_proxy_node == NULL)
      		{
					proxy_user_defined_entries_over = TRUE ;
  					client_info_ptr->next_screen = 0;
            	break;
				}
			   ptr_to_proxy_user_application = (STRUCT_PROXY_USER_ENTRY *) &proxy_server_user_application;
	   	}
		}			
SENDFILT_IPA:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit "); 
	      if (client_info_ptr->next_screen)
   	     	strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return telnet.tx_buffer;
	}


	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
		initialize_proxy_server_applications (); 
		initialize_proxy_server_user_applications ();
      client_info_ptr->menustate = TMS_ADD_PROXY_APP;      
   }
	else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1))
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_EDIT_PROXY_APP;
   }
	else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters)
   {
		client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_DELETE_PROXY_APP;
   }
	else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
		client_info_ptr->menustate = TMS_MODI_PROXY;
	else
		return (BYTE *)InvalidChoice;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *te_edit_proxy_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	STRUCT_PROXY_ENTRY *ptr_to_proxy_application;
	STRUCT_PROXY_ENTRY proxy_server_application;

	STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_application;
	STRUCT_PROXY_USER_ENTRY proxy_server_user_application;

   USHORT i,j;
   USHORT index;
   BYTE *ptr_lhs_string;

   ptr_lhs_string = &lhs_string;
   if (!buffer)
      return ("\n\rEnter index of Application:");

   index = atoi (buffer);

   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return ("\n\rRoute index is wrong\n\r\
Enter your choice (exit or ESC to previous menu):");
   }
      
   client_info_ptr->edit_index = index;

   ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string, (void *) &proxy_server_application);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_server_application);
      if (ptr_to_current_proxy_node == NULL)
      {
			if ( (strstr ( lhs_string,filter_string ) == NULL)  && (i != (index - 1)))
			{
				temp_proxy_application.port = (MAX_TCP_APPLICATIONS + 1);
				ptr_lhs_string = "Proxy User App";
	   		ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string, (void *) &proxy_server_user_application);
				
			   for (j = i+1; j < index-1; j++)
	   		{
			      ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_server_user_application);
	   		   if (ptr_to_current_proxy_node == NULL)
			      {
	   		      client_info_ptr->next_screen = 0;
     					return ("\n\rEntered index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");
					}
				}

	   		ptr_to_proxy_user_application = (STRUCT_PROXY_USER_ENTRY *) &proxy_server_user_application;
				memcpy ((char *) &dup_proxy_user_application_edit_ptr, (char *) &proxy_server_user_application, sizeof (STRUCT_PROXY_USER_ENTRY));
				dummy_proxy_user_application_edit_ptr = (STRUCT_PROXY_USER_ENTRY *) &dup_proxy_user_application_edit_ptr;

				strcpy(temp_proxy_user_application.descrptn,ptr_to_proxy_user_application->descrptn);
	   		temp_proxy_user_application.lower_port = ptr_to_proxy_user_application->lower_port;
			   temp_proxy_user_application.higher_port = ptr_to_proxy_user_application->higher_port;
   			temp_proxy_user_application.protocol = ptr_to_proxy_user_application->protocol;
	
   			client_info_ptr->next_screen = 0;
			   client_info_ptr->edit_filter = 1;

			   client_info_ptr->menustate = TMS_ADD_PROXY_APP;
			   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 

			}
			else
			{
	   		client_info_ptr->next_screen = 0;
		   	return ("\n\rEntered index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");

			}
		}
   }  

   ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) &proxy_server_application;

   temp_proxy_application.port = ptr_to_proxy_application->port;
   temp_proxy_application.protocol = ptr_to_proxy_application->protocol;

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_ADD_PROXY_APP;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}


BYTE *add_proxy_server_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT i=0;
	BYTE port_buff[20], protocol_buff[20];
	STRUCT_PROXY_ENTRY proxy_server_application;
	STRUCT_PROXY_ENTRY *ptr_to_proxy_application;
	STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_application;

   BYTE *ptr_lhs_string;

   ptr_lhs_string = &lhs_string;
   if (!buffer)
   {
      client_info_ptr->next_screen = 0;
/* user defined port number index for tcp & udp protocol */

		if ((strstr ( lhs_string,filter_string ) == NULL) &&
			((temp_proxy_application.port == (MAX_TCP_APPLICATIONS + 1)) || (temp_proxy_application.port == (MAX_UDP_APPLICATIONS + 1))))
		{
			if ( temp_proxy_user_application.higher_port == 0 )
			{
				sprintf (telnet.tx_buffer, ProxyAppSMenu,
					get_protocol_type (protocol_buff,temp_proxy_user_application.protocol),
				 	temp_proxy_user_application.descrptn,
	          	temp_proxy_user_application.lower_port);
     		   return (telnet.tx_buffer);
			}
			else
			{
				sprintf (telnet.tx_buffer, ProxyAppSRangeMenu,
					 get_protocol_type (protocol_buff,temp_proxy_user_application.protocol),
					 temp_proxy_user_application.descrptn,
		          temp_proxy_user_application.lower_port,
	   	       temp_proxy_user_application.higher_port);
     			return (telnet.tx_buffer);
			}
		}
  	   else
		{
      	sprintf (telnet.tx_buffer, ProxyAppSMenu,
         	 get_protocol_type (protocol_buff, temp_proxy_application.protocol),
	          get_port_type (port_buff, temp_proxy_application.protocol, temp_proxy_application.port),
				 temp_proxy_application.port);
      	return (telnet.tx_buffer);
	    }
	 }						
    client_info_ptr->modify_option_rcvd = atoi (buffer);
      
    if (client_info_ptr->modify_option_rcvd >= PROXY_PROTOCOL_PORT &&
      client_info_ptr->modify_option_rcvd <= PROXY_APPLICATION_PORT)
    {
      client_info_ptr->menustate = TMS_PROXY_UPD_APPLICATION;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
    {
      
      if (temp_proxy_application.port == 0 )
         return("\n\rInvalid Value.Enter exit or ESC to PREV menu : ");
      
      modify_config_visited = 1;
      

      if (client_info_ptr->edit_filter)
      {
			if ((strstr ( lhs_string,filter_string ) == NULL) &&
				((temp_proxy_application.port == (MAX_TCP_APPLICATIONS + 1)) || (temp_proxy_application.port == (MAX_UDP_APPLICATIONS + 1))))
			{
				ptr_lhs_string = "Proxy User App";
				
				if ( (temp_proxy_user_application.lower_port == 0 ) || 
					(strcmp(temp_proxy_user_application.descrptn,"") == 0))
					return ("\n\r\Enter proper values for lower port, descrption.\n\r\
Enter Choice ( 2, exit ) : ");
				else
				{
		   		ptr_to_proxy_user_application = dummy_proxy_user_application_edit_ptr;
					
      		   client_info_ptr->edit_filter = 0;
					
					if (temp_proxy_user_application.protocol == 6)
						temp_proxy_user_application.protocol = 0;
					else if (temp_proxy_user_application.protocol == 17)
						temp_proxy_user_application.protocol = 1;
						
					if (ptr_to_proxy_user_application->protocol == 6)
						ptr_to_proxy_user_application->protocol = 0;
					else if (ptr_to_proxy_user_application->protocol == 17)
						ptr_to_proxy_user_application->protocol = 1;

	   	      cm_edit_string (CM_PROXY_SECTION, ptr_lhs_string, (void *)ptr_to_proxy_user_application,(void *) &temp_proxy_user_application);
				}	
			}
			else
			{
      	   ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string,(void *) &proxy_server_application);
         	for (i=0; i < client_info_ptr->edit_index-1; i++)
	         {
   	         ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_server_application);
      	      if (ptr_to_current_proxy_node == NULL)
         	   {
            	   client_info_ptr->next_screen = 0;
               	return ("\n\rApplication index is wrong\n\r\
Enter your choice (exit or ESC to previous menu):");
	            }
   	      }  
      	   ptr_to_proxy_application = (STRUCT_PROXY_ENTRY *) &proxy_server_application;
         	client_info_ptr->edit_filter = 0;

/* sudhir 16/6/97 */
				if (temp_proxy_application.protocol == 6)
					temp_proxy_application.protocol = 0;
				else if (temp_proxy_application.protocol == 17)
					temp_proxy_application.protocol = 1;

				if (ptr_to_proxy_application->protocol == 6)
					ptr_to_proxy_application->protocol = 0;
				else if (ptr_to_proxy_application->protocol == 17)
					ptr_to_proxy_application->protocol = 1;

	         cm_edit_string (CM_PROXY_SECTION, ptr_lhs_string, (void *)ptr_to_proxy_application,(void *) &temp_proxy_application);
   	   }
		}
      else
		{
			if ((strstr ( lhs_string,filter_string ) == NULL) &&
				((temp_proxy_application.port == (MAX_TCP_APPLICATIONS + 1)) || (temp_proxy_application.port == (MAX_UDP_APPLICATIONS + 1))))
			{
				if ( (temp_proxy_user_application.lower_port == 0 ) || 
					(strcmp(temp_proxy_user_application.descrptn,"") == 0))
					return ("\n\r\Enter proper values for lower port, description.\n\r\
Enter Choice ( 1 to 2, exit ) : ");
				else
				{
					ptr_lhs_string = "Proxy User App";
					if (temp_proxy_user_application.protocol == 50)
					{
						temp_proxy_user_application.protocol = 0;
	  		   	   if (cm_insert_string (CM_PROXY_SECTION, ptr_lhs_string, (void *) &temp_proxy_user_application) == NULL)
								printf ("Inserting node failed\n");

						temp_proxy_user_application.protocol = 1;
			         if (cm_insert_string (CM_PROXY_SECTION, ptr_lhs_string, (void *) &temp_proxy_user_application) == NULL)
								printf ("Inserting node failed\n");
					}
					else 
					{
						if (temp_proxy_user_application.protocol == 6)
							temp_proxy_user_application.protocol = 0;
						else if (temp_proxy_user_application.protocol == 17)
							temp_proxy_user_application.protocol = 1;
				
	        			if (cm_insert_string (CM_PROXY_SECTION, ptr_lhs_string, (void *) &temp_proxy_user_application) == NULL)
							printf ("Inserting node failed\n");
						printf ("Adding application %d\n",temp_proxy_user_application.lower_port);
					}
				}
			}			
			else
			{
/* sudha taken from Ravi on 18 Nov 1998 ... */ 
				if (temp_proxy_application.protocol == 50)
				{
					temp_proxy_application.protocol = 0;
	   	      if (cm_insert_string (CM_PROXY_SECTION, ptr_lhs_string, (void *) &temp_proxy_application) == NULL)
							printf ("Inserting node failed\n");
					printf ("Adding application %d\n",temp_proxy_application.port);
				
					temp_proxy_application.protocol = 1;
		         if (cm_insert_string (CM_PROXY_SECTION, ptr_lhs_string, (void *) &temp_proxy_application) == NULL)
							printf ("Inserting node failed\n");
					printf ("Adding application %d\n",temp_proxy_application.port);
				}
/* ... sudha taken from Ravi on 18 Nov 1998 	*/ 
				else
				{
					if (temp_proxy_application.protocol == 6)
						temp_proxy_application.protocol = 0;
					else if (temp_proxy_application.protocol == 17)
						temp_proxy_application.protocol = 1;
			
		         if (cm_insert_string (CM_PROXY_SECTION, ptr_lhs_string, (void *) &temp_proxy_application) == NULL)
						printf ("Inserting node failed\n");
					printf ("Adding application %d\n",temp_proxy_application.port);
				}
			}
		}			
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_MODI_PROXY;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
    }
    return (BYTE *)InvalidChoice;
}

BYTE *upd_proxy_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE port_buff[20];
	USHORT new_value = 0;
	USHORT ctrl_port = 0, data_port = 0;
   
   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
         case PROXY_PROTOCOL_PORT:
/* sudha taken from Ravi On 18 Nov 1998 ... */			
				if (client_info_ptr->edit_filter)
	            return (BYTE*)(Protochoice);
				else
	            return (BYTE *)(Protochoice1);
/* ... sudha taken from Ravi On 18 Nov 1998 */			

			case PROXY_APPLICATION_PORT:
/* sudha taken from Ravi On 18 Nov 1998 ... */			
				if (client_info_ptr->edit_filter)
				{
					if ( strstr ( lhs_string,filter_string ) == NULL)
					{
						if((temp_proxy_application.port == (MAX_TCP_APPLICATIONS + 1)) || (temp_proxy_application.port == (MAX_UDP_APPLICATIONS + 1)))
						{
							client_info_ptr->menustate = TMS_UPD_PROXY_USER_PROTOCOL;
							return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
						}
						else
						{					
							if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "TCP"))
							{
								get_ftp_port_numbers(&ctrl_port, &data_port);
								sprintf(telnet.tx_buffer,tcp_edit_application_list,
									ctrl_port,data_port);
								return telnet.tx_buffer;
/*								return (BYTE *)tcp_edit_application_list; */
							}								
							else if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "UDP"))
							{
								get_ftp_port_numbers(&ctrl_port, &data_port);
								sprintf(telnet.tx_buffer,udp_edit_application_list,
									ctrl_port,data_port);
								return telnet.tx_buffer;
/*								return (BYTE *)udp_edit_application_list; */
							}
							else
								return ("\n\rUnknown Protocol");		
						}
					}
				}
				if ( strstr ( lhs_string,filter_string ) == NULL)
				{
					if((temp_proxy_application.port == (MAX_TCP_APPLICATIONS + 1)) || (temp_proxy_application.port == (MAX_UDP_APPLICATIONS + 1)))
					{
						client_info_ptr->menustate = TMS_UPD_PROXY_USER_PROTOCOL;
						return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
					}
					else
					{					
						if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "TCP"))
						{
							get_ftp_port_numbers(&ctrl_port, &data_port);
							sprintf(telnet.tx_buffer,tcp_application_list,
								ctrl_port,data_port);
							return telnet.tx_buffer;
						/*	return (BYTE *)tcp_application_list; */
						}
						else if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "UDP"))
						{
							get_ftp_port_numbers(&ctrl_port, &data_port);
							sprintf(telnet.tx_buffer,udp_application_list,
								ctrl_port,data_port);
							return telnet.tx_buffer;
						/*	return (BYTE *)udp_application_list; */
						}
						else if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "TCP & UDP"))
						{
								get_ftp_port_numbers(&ctrl_port, &data_port);
								sprintf(telnet.tx_buffer,tcp_application_list,
									ctrl_port,data_port);
								return telnet.tx_buffer;

					   /* return (BYTE *)tcp_application_list; */
						}
						else
							return ("\n\rUnknown Protocol");		
				/* ... Added By Ravi On 03 Nov 1998 */			
					}
				}
				else
				{					
					if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "TCP"))
					{
							get_ftp_port_numbers(&ctrl_port, &data_port);
							sprintf(telnet.tx_buffer,tcp_application_list,
								ctrl_port,data_port);
							return telnet.tx_buffer;
					/*	return (BYTE *)tcp_application_list; */
					}
					else if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "UDP"))
					{
						get_ftp_port_numbers(&ctrl_port, &data_port);
						sprintf(telnet.tx_buffer,udp_application_list,
							ctrl_port,data_port);
						return telnet.tx_buffer;
					/*	return (BYTE *)udp_application_list; */
					}
					else if (!strcmp (get_protocol_type (port_buff,temp_proxy_application.protocol), "TCP & UDP"))
					{
						get_ftp_port_numbers(&ctrl_port, &data_port);
						sprintf(telnet.tx_buffer,tcp_application_list,
							ctrl_port,data_port);
						return telnet.tx_buffer;
					/*	return (BYTE *)tcp_application_list; */
					}
					else
						return ("\n\rUnknown Protocol");		
				}
/* ... sudha taken from Ravi On 18 Nov 1998 */			
      }
   }

	new_value = atoi (buffer);
		
   switch (client_info_ptr->modify_option_rcvd)
   {
   	case PROXY_PROTOCOL_PORT:
/* sudha taken from Ravi On 18 Nov 1998 ... */
			if(client_info_ptr->edit_filter)
			{
				if (new_value == 1)
					temp_proxy_application.protocol = 6 ;
				else if (new_value == 2)
					temp_proxy_application.protocol = 17 ;
				else
					return (BYTE *)InvalidChoice;

				if ((strstr ( lhs_string,filter_string ) == NULL) && 
					(temp_proxy_application.port == (MAX_TCP_APPLICATIONS + 1)))
					temp_proxy_user_application.protocol = temp_proxy_application.protocol;

			}
			else
			{
				if (new_value == 1)
					temp_proxy_application.protocol = 6 ;
				else if (new_value == 2)
					temp_proxy_application.protocol = 17 ;
				else if (new_value == 3)
					temp_proxy_application.protocol = 50 ;
				else
					return (BYTE *)InvalidChoice;
			}
/* sudha taken from Ravi On 18 Nov 1998 ... */

			break;
	
		case PROXY_APPLICATION_PORT:
			if(client_info_ptr->edit_filter)
			{
				if ((strstr ( lhs_string,filter_string ) == NULL) && 
					(temp_proxy_application.port == (MAX_TCP_APPLICATIONS + 1)))
				{
					client_info_ptr->menustate = TMS_UPD_PROXY_USER_PROTOCOL;
					return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
				}
				else 
				{
					if (temp_proxy_application.protocol == 6)
					{
						if (new_value < (MAX_TCP_APPLICATIONS + 1))
						{
							temp_proxy_application.port = get_protocol_port_number (temp_proxy_application.protocol , new_value);
						}
						else
							return (BYTE *)InvalidChoice;
					}
					else if (temp_proxy_application.protocol == 17)
					{
						if (new_value < (MAX_UDP_APPLICATIONS + 1))
							temp_proxy_application.port = get_protocol_port_number (temp_proxy_application.protocol , new_value);
						else
							return (BYTE *)InvalidChoice;
					}
				}
			}				
			else
			{
				if (temp_proxy_application.protocol == 6)
				{
					if (new_value < (MAX_TCP_APPLICATIONS + 1))
					{
						temp_proxy_application.port = get_protocol_port_number (temp_proxy_application.protocol , new_value);
					}
					else if (new_value == (MAX_TCP_APPLICATIONS + 1))
					{
						if ( strstr ( lhs_string,filter_string ) == NULL)
						{
							temp_proxy_application.port = (MAX_TCP_APPLICATIONS + 1);
							temp_proxy_user_application.protocol = temp_proxy_application.protocol;
							client_info_ptr->menustate = TMS_UPD_PROXY_USER_PROTOCOL;
						}
						else
							client_info_ptr->menustate = TMS_UPD_PROXY_PROTOCOL;
						return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
					}
					else
						return (BYTE *)InvalidChoice;
				}	
				else if (temp_proxy_application.protocol == 17)
				{
					if (new_value < (MAX_UDP_APPLICATIONS + 1))
						temp_proxy_application.port = get_protocol_port_number (temp_proxy_application.protocol , new_value);
					else if (new_value == (MAX_UDP_APPLICATIONS + 1))
					{
						if ( strstr ( lhs_string,filter_string ) == NULL)
						{
							temp_proxy_application.port = (MAX_UDP_APPLICATIONS + 1);
							temp_proxy_user_application.protocol = temp_proxy_application.protocol;
							client_info_ptr->menustate = TMS_UPD_PROXY_USER_PROTOCOL;
						}
						else
							client_info_ptr->menustate = TMS_UPD_PROXY_PROTOCOL;
						return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
					}
					else
						return (BYTE *)InvalidChoice;
				}
/* sudha taken from Ravi on 18 Nov 1998 ... */	
				else if (temp_proxy_application.protocol == 50)
				{
					if (new_value < (MAX_TCP_APPLICATIONS + 1))
						temp_proxy_application.port = get_protocol_port_number (temp_proxy_application.protocol , new_value);
					else if (new_value == (MAX_TCP_APPLICATIONS + 1))
					{
						if ( strstr ( lhs_string,filter_string ) == NULL)
						{
							temp_proxy_application.port = (MAX_TCP_APPLICATIONS + 1);
							temp_proxy_user_application.protocol = temp_proxy_application.protocol;
							client_info_ptr->menustate = TMS_UPD_PROXY_USER_PROTOCOL;
						}
						else
							client_info_ptr->menustate = TMS_UPD_PROXY_PROTOCOL;
						return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
					}
					else
						return (BYTE *)InvalidChoice;
				}
/* ... sudha taken from Ravi on 18 Nov 1998 */
		
				else 
					return ("\n\rUnknown Protocol");
			}
			break;
   }

   client_info_ptr->menustate = TMS_ADD_PROXY_APP;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *update_proxy_application_port (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT new_value =0;

	if (!buffer)
		return ("\n\rEnter Proxy Application Port : ");

	new_value = atoi (buffer);

	if (new_value > 0 && new_value <= 1024)
	{
		temp_proxy_application.port = new_value;
		client_info_ptr->menustate = TMS_ADD_PROXY_APP;
	   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
		return (BYTE *)InvalidChoice;
}

BYTE *update_proxy_user_application_protocol (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE protocol_buff[25];
	enum TEST_RESULT result;
		
	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
/* user defined port number index for tcp & udp protocol */

		sprintf (telnet.tx_buffer, ProxyAppPortRangeMenu,
			get_protocol_type (protocol_buff,temp_proxy_user_application.protocol),
		 	temp_proxy_user_application.lower_port,
        	temp_proxy_user_application.higher_port,
			temp_proxy_user_application.descrptn);
      return (telnet.tx_buffer);
	}

   client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd >= PROXY_USER_LOWER_PORT &&
      client_info_ptr->modify_option_rcvd <= PROXY_USER_DESCRPTN)
   {
      client_info_ptr->menustate = TMS_UPD_PROXY_USER_PORT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
	else if ((*buffer == 'A' || *buffer ==  'a') && strlen (buffer) == 1)
	{
		if ( (temp_proxy_user_application.lower_port == 0) || 
			( strcmp(temp_proxy_user_application.descrptn,"") == 0 ))
		{
			client_info_ptr->menustate = TMS_UPD_PROXY_USER_PROTOCOL ;
			menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_UPD_PROXY_USER_PROTOCOL;
			
			return ("\n\r\Enter values properly for lower port, description.\n\r\
Enter ( 2 to 4, A: Add, exit ) : ");
		}
		if ( (temp_proxy_user_application.higher_port != 0 ) &&
		 	(temp_proxy_user_application.lower_port >= temp_proxy_user_application.higher_port ))
		{														
			temp_proxy_user_application.higher_port = 0;
			return ("\n\r\Higher Port should be greater than lower port.\n\r\
Enter ( 2 to 4, A: Add, exit ) : ");
		}
		if (is_user_defined_port_not_in_reserved_port_list(temp_proxy_user_application.lower_port,temp_proxy_user_application.higher_port) == FALSE)
		{
			temp_proxy_user_application.lower_port = 0;
			temp_proxy_user_application.higher_port = 0;
			return ("\n\r\Entered values conflict with reserved port entries.\n\r\
Enter ( 2 to 4, A: Add, exit ) : ");
		}
		if (is_user_defined_port_desc_not_in_reserved_port_desc(temp_proxy_user_application.descrptn) == FALSE )
		{
			strcpy(temp_proxy_user_application.descrptn,"");
			return ("\n\r\Entered description conflict with reserved port description.\n\r\
Enter ( 2 to 4, A: Add, exit ) : ");
		}
		if ( !client_info_ptr->edit_filter && ( temp_proxy_user_application.protocol != 50 ))
		{
			result = is_user_defined_port_range_unique(temp_proxy_user_application.lower_port,temp_proxy_user_application.higher_port,temp_proxy_user_application.protocol);
			if ( result == PROXY_ENTRY )
			{
				temp_proxy_user_application.lower_port = 0;
				temp_proxy_user_application.higher_port = 0;
				return ("\n\r\Entered values conflict with proxy port entries.\n\r\
Enter ( 2 to 4, A: Add, exit ) : ");
			}
			else if ( result == PROXY_RANGE_ENTRY )
			{
				temp_proxy_user_application.lower_port = 0;
				temp_proxy_user_application.higher_port = 0;
				return ("\n\r\Entered values conflict with proxy port range entries.\n\r\
Enter ( 2 to 4, A: Add, exit ) : ");
			}
			if ( is_user_defined_port_desc_not_a_duplicate(temp_proxy_user_application.descrptn, temp_proxy_user_application.protocol) == FALSE)
			{
				strcpy(temp_proxy_user_application.descrptn,"");
				return ("\n\r\Entered description is a duplicate description.\n\r\
Enter ( 2 to 4, A: Add, exit ) : ");
			}
		}

     	client_info_ptr->menustate = TMS_ADD_PROXY_APP;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
	else
	 	return (BYTE *)InvalidChoice;
}

BYTE *update_proxy_user_application_port (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int new_value = 0;
   BYTE *desc;

   if (!buffer)
   {
      switch (client_info_ptr->modify_option_rcvd)
      {
			case PROXY_USER_LOWER_PORT:
				return ("\n\rEnter Proxy Application Lower Port ( 1 to 65535 ): ");
		
			case PROXY_USER_HIGHER_PORT:
				return ("\n\rEnter Proxy Application Higher Port ( 1 to 65535 ): ");

			case PROXY_USER_DESCRPTN:
				return ("\n\rEnter Proxy Application Descrption ( Length <= 15 ): ");
			
		}
	}
	
	new_value = atoi (buffer);

   switch (client_info_ptr->modify_option_rcvd)
   {
   	case PROXY_USER_LOWER_PORT:
			if (new_value > 0 && new_value <= 65535)
				temp_proxy_user_application.lower_port = new_value;
			else
				return ("\n\r\Invalid Port number.Enter within 1 to 65535.");
			break;
		
		case PROXY_USER_HIGHER_PORT:
			if ( new_value == 0 )
				temp_proxy_user_application.higher_port = new_value;
			else if (new_value <= temp_proxy_user_application.lower_port )
				return ("\n\rHigher port should be greater than lower port.");
			else if (new_value < 0 && new_value > 65535)
				return ("\n\r\Invalid Port number.Enter within 0 to 65535.");
 			else
				temp_proxy_user_application.higher_port = new_value;
			break;

		case PROXY_USER_DESCRPTN:
			if (strlen (buffer) > 15)
				return ("\n\rEnter Descrption of length <= 15.");
			else
			{
				desc = buffer;
				strcpy(&temp_proxy_user_application.descrptn[0], desc);
			}
			break;
	}
   client_info_ptr->menustate = TMS_UPD_PROXY_USER_PROTOCOL;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

}

BYTE *delete_proxy_server_application (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT i=0, j;
	int index=0;
   BYTE ptr_to_proxy_application[100];
	STRUCT_PROXY_ENTRY *ptr_to_application;
	STRUCT_PROXY_USER_ENTRY *ptr_to_proxy_user_application;
   BYTE *ptr_lhs_string;

   ptr_lhs_string = &lhs_string;
   if (!buffer)
   {
      return ("\n\rEnter index of Application to delete:");
   }

   index = atoi (buffer) - 1;

   if (index < 0)
   {
      client_info_ptr->next_screen = 0;
      return ("\n\rEntered index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");
   }

   ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string,(void *) &ptr_to_proxy_application[0]);
   for (i=0; i < index; i++)
   {
      ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &ptr_to_proxy_application[0]);
      if (ptr_to_current_proxy_node == NULL)
      {
			if ( (strstr ( lhs_string,filter_string ) == NULL)  && (i != index))
			{
				ptr_lhs_string = "Proxy User App";
	   		ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string, (void *) &ptr_to_proxy_application[0]);
				
			   for (j = i+1; j < index; j++)
	   		{
			      ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &ptr_to_proxy_application[0]);
	   		   if (ptr_to_current_proxy_node == NULL)
			      {
	   		      client_info_ptr->next_screen = 0;
     					return ("\n\rEntered index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");
					}
				}

	   		ptr_to_proxy_user_application = (STRUCT_PROXY_USER_ENTRY *) &ptr_to_proxy_application;

				if (ptr_to_proxy_user_application->protocol == 6)
					ptr_to_proxy_user_application->protocol = 0;
				else if (ptr_to_proxy_user_application->protocol == 17)
					ptr_to_proxy_user_application->protocol = 1;

			   switch (cm_remove_string (CM_PROXY_SECTION, ptr_lhs_string, (void *)ptr_to_proxy_user_application))
				{
					case CM_REMOVING_STRING_SUCCESSFUL:
						printf ("String is removed\n");
						break;

					case CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING:
      				printf ("String removal failed\n");
			 			break;
				}
	
			   modify_config_visited = 1;
			   client_info_ptr->next_screen = 0;

			   client_info_ptr->menustate = TMS_MODI_PROXY;
			   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));

			}
			else
			{

         	client_info_ptr->next_screen = 0;
         	return ("\n\rEntered index is wrong\n\r\
Enter your choice (exit, ESC to previous menu):");
      	}
		}
   }  

   ptr_to_application = (STRUCT_PROXY_ENTRY *) ptr_to_proxy_application;
	printf ("Deleting application %d\n",ptr_to_application->port);

	if (ptr_to_application->protocol == 6)
		ptr_to_application->protocol = 0;
	else if (ptr_to_application->protocol == 17)
		ptr_to_application->protocol = 1;

   switch (cm_remove_string (CM_PROXY_SECTION, ptr_lhs_string, (void *)ptr_to_application))
	{
		case CM_REMOVING_STRING_SUCCESSFUL:
			printf ("String is removed\n");
			break;

		case CM_RHS_STRING_NOT_FOUND_WHILE_REMOVING:
      	printf ("String removal failed\n");
 			break;
	}

   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

   client_info_ptr->menustate = TMS_MODI_PROXY;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

BYTE *proxy_filt_db_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE	filter_type;

   menu_ptr[0] = 0;
   lhs_string[0] = 0;

	if (!buffer) 
		return (BYTE *)(ProxyFiltersMenu);

	filter_type = atoi(buffer);
 	switch( filter_type) {
      case PROXY_SOURCE_ADDR_FILTER:
			client_info_ptr->menustate = TMS_PRXFILTSRC;
			client_info_ptr->ptr_to_last_read_linked_list = NULL;
			client_info_ptr->menu_selected_port = filter_type;
         strcpy(menu_ptr,"Source IP Address");
         strcpy(lhs_string,"Proxy Source Filter");
			break;

 		case PROXY_DEST_ADDR_FILTER:
			client_info_ptr->menustate = TMS_PRXFILTSRC;
			client_info_ptr->ptr_to_last_read_linked_list = NULL;
			client_info_ptr->menu_selected_port = filter_type;
         strcpy(menu_ptr,"Destination IP Address");
         strcpy(lhs_string,"Proxy Destination Filter");
			break;

      case PROXY_APP_FILTER:
         client_info_ptr->menustate = TMS_MODI_PROXY;
         menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_PROXY_FILTERS;
         strcpy(lhs_string,"Proxy Application Filter");
         strcpy(menu_ptr,"Filter");
         client_info_ptr->ptr_to_last_read_linked_list = NULL;
			client_info_ptr->menu_selected_port = filter_type;
			break;

 		case PROXY_MAC_ADDR_FILTER:
			client_info_ptr->menustate = TMS_PRXFILTSRC;
         client_info_ptr->ptr_to_last_read_linked_list = NULL;
			client_info_ptr->menu_selected_port = filter_type;
         strcpy(menu_ptr,"MAC Address");
         strcpy(lhs_string,"Proxy MAC Filter");
			break;

      case PROXY_DNS_ADDR_FILTER:
			client_info_ptr->menustate = TMS_PRXFILTSRC;
         client_info_ptr->ptr_to_last_read_linked_list = NULL;
			client_info_ptr->menu_selected_port = filter_type;
         strcpy(menu_ptr,"Domain Name");
         strcpy(lhs_string,"Proxy DNS Filter");
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
   client_info_ptr->next_screen = 0;

	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}

void initialize_proxy_addr_filter (TELNET_CLIENT_CLASS *client_info_ptr)
{
   switch ( client_info_ptr->menu_selected_port )
   {
      case PROXY_SOURCE_ADDR_FILTER:
      case PROXY_DEST_ADDR_FILTER:
      	strcpy (temp_proxy_addr_filter.addr, "0.0.0.0");
         break;
      case PROXY_MAC_ADDR_FILTER:
         strcpy (temp_proxy_addr_filter.addr, "000000000000");
         break;
      case PROXY_DNS_ADDR_FILTER:
         strcpy(temp_proxy_addr_filter.addr,"");
         break;
   }
}	

BYTE	*display_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_PROXY_FILTER *ptr_to_proxy_addr_filter;
   STRUCT_PROXY_FILTER proxy_addr_filter;
   BYTE *ptr_lhs_string;
   BYTE temp_buff[200],temp_db[100];
   USHORT index=0;

   ptr_lhs_string = &lhs_string;
	
   if (!buffer)
	{
		if (client_info_ptr->next_screen)
		{
         if (ptr_to_current_proxy_node != NULL)
            ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_addr_filter);
		}
		else
		{
         ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string, (void *) &proxy_addr_filter);
         if (ptr_to_current_proxy_node == NULL)
         {
            client_info_ptr->no_filters = 1;
            sprintf(temp_db,ProxyAddrFilterDB,menu_ptr);
				strcpy (telnet.tx_buffer, temp_db);
				strcat (telnet.tx_buffer, "\n\r\n\rEnter your choice (A:Add, exit or ESC to PREV menu):");
				return telnet.tx_buffer;
         }
         client_info_ptr->index = 1;
		}

      sprintf(temp_db,ProxyAddrFilterDB,menu_ptr);
		strcpy (telnet.tx_buffer, temp_db);
      if (client_info_ptr->next_screen)
      {
         index++;
      	sprintf (temp_buff,"     %3d.       %-15s\n\r", 
            client_info_ptr->index++,
            dummy_proxy_addr_filter->addr);
      	strcat (telnet.tx_buffer,temp_buff);
         if (ptr_to_current_proxy_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            goto SENDFILT_PRXSRC;
			}
      }

      ptr_to_proxy_addr_filter = (STRUCT_PROXY_FILTER *) &proxy_addr_filter;

   	while (ptr_to_current_proxy_node != NULL)
   	{
         client_info_ptr->no_filters = 0;
      	index++;
      	sprintf (temp_buff,"      %3d.       %-15s\n\r",
            client_info_ptr->index++,
            ptr_to_proxy_addr_filter->addr);
      	strcat (telnet.tx_buffer,temp_buff);

         if (ptr_to_current_proxy_node != NULL)
            ptr_to_current_proxy_node =  cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void*)&proxy_addr_filter);

         if (index == MAX_ENTRIES_PER_PAGE && ptr_to_current_proxy_node != NULL)
         {
            memcpy ((char *) &dup_proxy_addr_filter, (char *) &proxy_addr_filter, sizeof ( STRUCT_PROXY_FILTER));
            dummy_proxy_addr_filter = (STRUCT_PROXY_FILTER *) &dup_proxy_addr_filter;
            client_info_ptr->next_screen++;
            break;
         }

         if (ptr_to_current_proxy_node == NULL)
         {
            client_info_ptr->next_screen = 0;
            break;
         }
         ptr_to_proxy_addr_filter = (STRUCT_PROXY_FILTER *) &proxy_addr_filter;
	   }
SENDFILT_PRXSRC:
      strcat (telnet.tx_buffer, "\n\rEnter your choice(A:Add, D:Delete, E:Edit "); 
      if (client_info_ptr->next_screen)
         strcat (telnet.tx_buffer, "N:Next, ");
      strcat (telnet.tx_buffer,"exit or ESC to PREV menu):"); 
   	return telnet.tx_buffer;
	}
	
	if ((*buffer == 'A' || *buffer == 'a') && strlen(buffer) == 1)
   {
      client_info_ptr->next_screen = 0;
      initialize_proxy_addr_filter (client_info_ptr);
      client_info_ptr->edit_filter = 0;
      client_info_ptr->menustate = TMS_PRX_ADD_SRC_FILT;      
   }
   else if ((*buffer == 'E') || (*buffer == 'e') && (strlen (buffer) == 1) && !client_info_ptr->no_filters)
   {
      client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_PRX_EDIT_SRC_FILT;
   }
   else if ((*buffer == 'D' || *buffer == 'd') && strlen (buffer) == 1 && !client_info_ptr->no_filters )
   {
      client_info_ptr->next_screen = 0;
		client_info_ptr->menustate = TMS_PRX_DEL_SRC_FILT;
   }
   else if ((*buffer == 'N' || *buffer == 'n') && strlen (buffer) == 1 && client_info_ptr->next_screen)
   {
      client_info_ptr->menustate = TMS_PRXFILTSRC;
   }
   else
      return (BYTE *)InvalidChoice;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *te_edit_proxy_source_filt (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   STRUCT_PROXY_FILTER proxy_addr_filter;
   STRUCT_PROXY_FILTER *ptr_to_proxy_addr_filter;
   BYTE *ptr_lhs_string;
   USHORT i;
   USHORT index;
   
   ptr_lhs_string = &lhs_string;
   if (!buffer)
      return ("\n\rEnter index of filter:");

   index = atoi (buffer);
   if (index == 0)
   {
      client_info_ptr->next_screen = 0;
      return (BYTE *)InvalidFilter;
   }
   client_info_ptr->edit_index = index;


   ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string,(void *) &proxy_addr_filter);
   for (i=0; i < index-1; i++)
   {
      ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_addr_filter);
      if (ptr_to_current_proxy_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (BYTE *)(InvalidFilter);
      }                  
   }  
   ptr_to_proxy_addr_filter = (STRUCT_PROXY_FILTER *) &proxy_addr_filter;

   strcpy (temp_proxy_addr_filter.addr, ptr_to_proxy_addr_filter->addr);

   client_info_ptr->next_screen = 0;
   client_info_ptr->edit_filter = 1;

   client_info_ptr->menustate = TMS_PRX_ADD_SRC_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)); 
}

BYTE *add_proxy_source_filt (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT i=0;
   STRUCT_PROXY_FILTER proxy_address_filter;
   STRUCT_PROXY_FILTER *ptr_to_proxy_address_filter;
   BYTE *ptr_lhs_string,temp_db[100];

   ptr_lhs_string = &lhs_string;

	if (!buffer)
	{
      client_info_ptr->next_screen = 0;
		sprintf (temp_db, ProxyAddrFilter,
         menu_ptr,menu_ptr,
			temp_proxy_addr_filter.addr);
      strcpy(telnet.tx_buffer,temp_db);
		return telnet.tx_buffer;
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);
      
   if (client_info_ptr->modify_option_rcvd == 1)
   {
      client_info_ptr->menustate = TMS_PRX_UPD_SRC_FILT;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   else if ((*buffer == 'c' || *buffer ==  'C') && strlen (buffer) == 1)
   {
      switch ( client_info_ptr->menu_selected_port )
      {
         case PROXY_SOURCE_ADDR_FILTER :
         case PROXY_DEST_ADDR_FILTER :
    			if ((!is_an_ip_address(temp_proxy_addr_filter.addr)) ||
               (strcmp(temp_proxy_addr_filter.addr,"0.0.0.0") == 0))
   	   		return (BYTE *)(InvalidIP);
            break;
         case PROXY_MAC_ADDR_FILTER :
            if (!is_valid_mac_address(temp_proxy_addr_filter.addr))
               return ("\n\rMAC Address entered is invalid.\n\r\
Enter exit or ESC to PREV menu : ");
            else
               format_the_mac_address(temp_proxy_addr_filter.addr);
            break;
         case PROXY_DNS_ADDR_FILTER :
            if (!is_valid_dns_address(temp_proxy_addr_filter.addr))
               return ("\n\rDomain Name entered is invalid.Space is not accepted.\n\r\
Enter exit or ESC to PREV menu : ");
            break;
      }         

      modify_config_visited = 1;

      if (client_info_ptr->edit_filter)
      {
         ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string,(void *) &proxy_address_filter);
         for (i=0; i < client_info_ptr->edit_index-1; i++)
         {
            ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_address_filter);
            if (ptr_to_current_proxy_node == NULL)
            {
               client_info_ptr->next_screen = 0;
               return (BYTE *)(InvalidFilter);
            }
         }  
         ptr_to_proxy_address_filter = (STRUCT_PROXY_FILTER *) &proxy_address_filter;
         client_info_ptr->edit_filter = 0;
         cm_edit_string (CM_PROXY_SECTION, ptr_lhs_string, (void *)ptr_to_proxy_address_filter, (void *) &temp_proxy_addr_filter);
      }
      else
         cm_insert_string (CM_PROXY_SECTION, ptr_lhs_string, (void *) &temp_proxy_addr_filter);

		client_info_ptr->next_screen = 0;
      client_info_ptr->menustate = TMS_PRXFILTSRC;
      return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
   }
   return (BYTE *)InvalidChoice;
}  	

BYTE *upd_proxy_source_filt(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	USHORT value;
   BYTE temp_db[100];

	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)
		{
			case 1:
            sprintf ( temp_db,EnterString,menu_ptr);
				return ( temp_db );
		}        
	}

	value = atoi (buffer);

	switch (client_info_ptr->modify_option_rcvd)
	{
		case 1:
         switch ( client_info_ptr->menu_selected_port )
         {
            case PROXY_SOURCE_ADDR_FILTER :
            case PROXY_DEST_ADDR_FILTER :
      			if (!is_an_ip_address(buffer))
   		   		return (BYTE *)(InvalidIP);
               break;
            case PROXY_MAC_ADDR_FILTER :
               if (!is_valid_mac_address(buffer))
                  return ("\n\rMAC Address entered is invalid.\n\r\
Enter exit or ESC to PREV menu : ");
               else
                  format_the_mac_address(buffer);
               break;
            case PROXY_DNS_ADDR_FILTER :
               if (!is_valid_dns_address(buffer))
                  return ("\n\rDomain Name entered is invalid.\n\r\
Enter exit or ESC to PREV menu : ");
               break;
         }         
         strcpy (temp_proxy_addr_filter.addr, buffer);
         break;
	}
	client_info_ptr->menustate = TMS_PRX_ADD_SRC_FILT;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *delete_proxy_source_filt (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
   USHORT index=0, i=0;
   STRUCT_PROXY_FILTER *ptr_to_proxy_addr_filter;
   STRUCT_PROXY_FILTER proxy_addr_filter;
   BYTE *ptr_lhs_string;

   ptr_lhs_string = &lhs_string;

   if (!buffer)
      return (BYTE *)EnterFilter;

   index = atoi (buffer) - 1;

   ptr_to_current_proxy_node = cm_get_first_entry (CM_PROXY_SECTION, ptr_lhs_string,(void *) &proxy_addr_filter);
   for (i=0; i < index; i++)
   {
      ptr_to_current_proxy_node = cm_get_next_entry (CM_PROXY_SECTION, ptr_to_current_proxy_node, (void *) &proxy_addr_filter);
      if (ptr_to_current_proxy_node == NULL)
      {
         client_info_ptr->next_screen = 0;
         return (BYTE *)(InvalidFilter);
      }
   }  

   ptr_to_proxy_addr_filter = (STRUCT_PROXY_FILTER *) &proxy_addr_filter;
   cm_remove_string (CM_PROXY_SECTION, ptr_lhs_string, (void *)ptr_to_proxy_addr_filter);
       
   modify_config_visited = 1;
   client_info_ptr->next_screen = 0;

	client_info_ptr->menustate = TMS_PRXFILTSRC;
   return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


