#include	<defs.h>
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>

#include	"telnet.h"
#include	"vmenu.h"

#include "..\..\applicat\snmp\ksnmp.h" 
#include "..\..\applicat\snmp\vsnmpstr.h" 

#include	"..\..\lsl\klsl.h"
#include	"..\..\lsl\vbufstr.h"
#include	"..\..\lsl\vlslstr.h"
#include	"..\..\lsl\vlsl.h"

extern	SNMP_CLASS	snmp;

/*#ifdef TCON */

BYTE	*snmp_main_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	if (!buffer) {
		if (snmp.enabled == TRUE)
			return (menufsmhdlr[client_info_ptr->menustate].menu);
		else {
			/* Display error message and wait for ENTER to be pressed */
			will_temp_echo(client_info_ptr, TOECHO);
			client_info_ptr->more++;
			return (SNMPDisable);
		}
	}

	/* If we are waiting for ENTER to be pressed after error message,
	 go back to the parent menu */
	if (client_info_ptr->more) {
		back_to_normal_mode(client_info_ptr);
		return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}	
 	switch( atoi(buffer)) {
 		case SNMP_AGT:
			client_info_ptr->menustate = TMS_SNMPAGT;
			break;
 		case SNMP_STAT:
			client_info_ptr->menustate = TMS_SNMPSTAT;
			break;

		default:
			sprintf(telnet.tx_buffer, EnterProperChoice, 
				menufsmhdlr[client_info_ptr->menustate].num_of_items);
			return(telnet.tx_buffer);
	}
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}



BYTE	*snmp_agt_info_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	LSL_SYSTEM_MIB  *sptr_lsl_system_mib;
	sptr_lsl_system_mib = &lsl.system_mib;

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				lsl.system_mib.sysName, lsl.system_mib.sysDescr, lsl.system_mib.sysContact, lsl.system_mib.sysLocation);
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}


BYTE	*snmp_stats_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{

	switch(client_info_ptr->more) {
		case 0:
			will_temp_echo(client_info_ptr, TOECHO);

         client_info_ptr->echoing = FALSE;

			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, menufsmhdlr[client_info_ptr->menustate].menu,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], snmp.mib.snmpInPkts),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], snmp.mib.snmpOutPkts),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], snmp.mib.snmpInBadVersions),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], snmp.mib.snmpInBadCommunities),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], snmp.mib.snmpInBadCommunityUses),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], snmp.mib.snmpInTraps),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], snmp.mib.snmpInAsnParseErrs),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], snmp.mib.snmpInGetResponses),
				MakePunctNumStr( &ReplyStrs[8].ReplyStr[0], snmp.mib.snmpInNoSuchNames),
				MakePunctNumStr( &ReplyStrs[9].ReplyStr[0], snmp.mib.snmpInBadValues));
			return(telnet.tx_buffer);
		case 1:
			client_info_ptr->more++;
			sprintf(telnet.tx_buffer, SNMPStats2,
				MakePunctNumStr( &ReplyStrs[0].ReplyStr[0], snmp.mib.snmpInReadOnlys),
				MakePunctNumStr( &ReplyStrs[1].ReplyStr[0], snmp.mib.snmpInTotalReqVars),
				MakePunctNumStr( &ReplyStrs[2].ReplyStr[0], snmp.mib.snmpInTotalSetVars),
				MakePunctNumStr( &ReplyStrs[3].ReplyStr[0], snmp.mib.snmpInGetRequests),
				MakePunctNumStr( &ReplyStrs[4].ReplyStr[0], snmp.mib.snmpInGetNexts),
				MakePunctNumStr( &ReplyStrs[5].ReplyStr[0], snmp.mib.snmpInSetRequests),
				MakePunctNumStr( &ReplyStrs[6].ReplyStr[0], snmp.mib.snmpOutTooBigs),
				MakePunctNumStr( &ReplyStrs[7].ReplyStr[0], snmp.mib.snmpOutGetResponses));
			return(telnet.tx_buffer);
		default:
			back_to_normal_mode(client_info_ptr);
			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
	}
}
/*#endif */





