#include	<defs.h>
#include	<string.h>
#include	<stdlib.h>
#include	<stdio.h>
#include <stddef.h>

#include	"telnet.h"
#include	"vmenu.h"
#include "\rtrware\store\boot.h"

#define MAX_USERS_PER_PAGE  15

#include <udb.h>

RAS_USER_DATABASE_RECORD ptr_to_rudb;

extern RAS_USER_DATABASE_RECORD *ptr_ras_user_database;
extern int udb_deinit_flag;
extern int udb_init_flag;

extern BYTE retry_pass[];
extern BYTE Insufficient_memory[];

const BYTE SaveSetup[] = "\n\rDo you want to save changes (y/n):";
const BYTE SaveSetupperm[] =
"\n\rDo you want make changes permanent (y/n):";

const BYTE not_changable[] =
"\n\rUser name can't be modified\n\r\
ESC to PREV menu";

const BYTE Not_Inited[]=
"\n\rUser Database is not Initialized";

const BYTE AddUser[]= 
"\n\rDo you want to save user entry (y/n):";

const BYTE NotSaved[]=
"\n\rChanges are not saved\n\r\
ESC to PREV menu";

const BYTE dupuser[]=
"\n\rUser already exist";

BYTE max_user[]=
"\n\rMaximum number of users allowed is %d";

BYTE no_remote_users[] =

"\n\rThere is no valid User\n\r\
ESC to PREV menu";

const BYTE confirm_del[]=
"\n\rDo you want to delete user entry (y/n):";

const BYTE InvalidUserName[] =
"\n\r\
User name is invalid";


BYTE no_more_page[]=
"\n\r\
No more user to be displayed\n\r\
ESC to previous menu";

const BYTE rem_usr_name[]=
"\n\r\
Enter user name:";

const BYTE rem_usr_pwd[]=
"\n\r\
Enter user password:";

const BYTE user_number[] =
"\n\r\
Enter the user index :";

int user_num=0, add_usr=0,edit_usr=0, user_modified=0;
int verifying_remu_pwd=0;
int no_of_remote_users=0;


BYTE temp_buff[750], store_pwd[10],del_usr_name[40];
RAS_USER_DATABASE_RECORD *ptr_to_first_user;

extern int toupper (int);
extern BYTE *to_upper_string (BYTE *) ;
BYTE *ReadUserNames (TELNET_CLIENT_CLASS *,int);
extern void *memset(void *,int ,size_t);


BYTE *get_stats (BYTE call_state)
{
	int number;

	number = (int) call_state;
	return  ((number==1) ? "enabled" : "disabled");
}

BYTE *get_protocol_status (BYTE protocol_stat, int prot)
{
	int number;
	int bit_val;

	number = (int) protocol_stat;
	if (prot == 1)
	{
		bit_val = number & 1;		
		return  ((bit_val==1) ? "enabled" : "disabled");
	}
	else if (prot == 2)
	{
		bit_val = number & 2;
		return  ((bit_val == 2) ? "enabled" : "disabled");
	}
	else if (prot == 3)
	{
		bit_val = number & 4;
		return  ((bit_val==4) ? "enabled" : "disabled");
	}
	else 
		return ("unknown");
}

void set_default_values()
{
	ptr_to_rudb.user_name[0] = 0;
	ptr_to_rudb.password[0] = 0;
	ptr_to_rudb.call_back_enabled = (BYTE) 0;
	ptr_to_rudb.call_back_security = (BYTE) 0;
	ptr_to_rudb.call_back_number[0] = 0;
	ptr_to_rudb.call_back_delay = 10;
	ptr_to_rudb.protocol_mask = (BYTE) 7;

/* sudha 31 Aug 1999.If model is dsu, wan1 is sync port.So don't
allow that wan1 for dial-in or dial-out by any client. */
	if (telnet.model_number == MODEL_MTSR2_201)
		ptr_to_rudb.dial_in_port_mask = ptr_to_rudb.dial_out_port_mask = 0xfffffffe;
	else
		ptr_to_rudb.dial_in_port_mask = ptr_to_rudb.dial_out_port_mask = 0xffffffff;
}



BYTE *users_menu_hdlr(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int no_of_users=0, no_of_pages=0;
	BYTE *ptr_to_user_name;

   /* Sudha 12 Feb 1998 */
   if ( client_info_ptr->telnet_management_menu )
      menufsmhdlr[client_info_ptr->menustate].parentstate = TMS_PROXY_MANAGEMENT_MENU;

	no_of_users = udb_get_number_of_users();

	if (no_of_users > MAX_USERS_PER_PAGE)
		no_of_pages = (no_of_users / MAX_USERS_PER_PAGE);
	else
		no_of_pages = 0;

	if (!buffer)
	{
		ptr_to_user_name = ReadUserNames (client_info_ptr, no_of_pages);
		if (ptr_to_user_name == NULL)
			return (NULL);
		return (ptr_to_user_name);
	}

	CompressString(buffer);

	if (((*buffer == 'A') || (*buffer == 'a')) && strlen (buffer) == 1)
	{
		add_usr = 1;
		client_info_ptr->menustate = TMS_ADD_USERS;
		set_default_values ();
	}
	else if (((*buffer == 'D') || (*buffer == 'd')) && strlen (buffer) == 1)
	{
		if (udb_get_number_of_users() == 0)
		{
			client_info_ptr->menustate = TMS_DELETE_USERS;
			return (no_remote_users);
		}
		client_info_ptr->menustate = TMS_DELETE_USERS;
	}
	else if (((*buffer == 'E') || (*buffer == 'e')) && strlen(buffer) == 1)
	{

		add_usr = 0;
		if (udb_get_number_of_users() == 0)
		{
			client_info_ptr->menustate = TMS_EDIT_USERS;
			return (no_remote_users);
		}
		client_info_ptr->menustate = TMS_EDIT_USERS;

	 }
	else if (((*buffer == 'N') || (*buffer == 'n')) && strlen(buffer) == 1)
	{
		if (!no_of_pages)
			return (no_more_page);
		client_info_ptr->menustate = TMS_NEXT_PAGE;
	}
	else
		return (InvalidChoice);

	return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *ReadUserNames (TELNET_CLIENT_CLASS *client_info_ptr, int no_of_pages)
{
	int i=0, no_of_users;
	RAS_USER_DATABASE_RECORD *ptr_to_next_user;
	BYTE index[5];

	temp_buff[0] = 0;

   strcpy (temp_buff,   "\n\r\n\r                  <<Remote User Database>>\n\r");

	no_of_users = udb_get_number_of_users();
	if (no_of_users == 0)
	{
      /* Sudha 12 Feb 1998 */
      if ( client_info_ptr->telnet_management_menu == FALSE )
      {
		   /* strcat (&temp_buff[0], "\n\rA: Add User ");
         strcat (&temp_buff[0], "\n\rEnter your choice:");*/
         strcat (&temp_buff[0], "\n\rEnter your choice (A: Add User,exit or Esc to previous menu ) : ");
	   	return (&temp_buff[0]);
   	}
      else
      {
         strcat (&temp_buff[0], "\n\rNo Users in database.");
         strcat (&temp_buff[0], "\n\rEnter your choice (A: Add User,exit or Esc to previous menu ) : ");
         return (&temp_buff[0]);
      }
   }

	for (i = 0; i < no_of_users; i++)
	{
		ptr_to_next_user = udb_get_user_entry_from_index (i);
		if (ptr_to_next_user == NULL || i > MAX_USERS_PER_PAGE-1)
			break;
/*		if (strlen (&ptr_to_next_user->user_name[0]) > UDB_USER_NAME_LENGTH)
			return (InvalidUserName); */

		strcat (&temp_buff[0], "\n\r"); 
		sprintf (&index[0], "%2d. ",i+1);
		strcat (&temp_buff[0], &index[0]);
		strcat (&temp_buff[0], ptr_to_next_user->user_name);
		ptr_to_first_user =ptr_to_next_user;
	}
	no_of_remote_users = i;

   if ( client_info_ptr->telnet_management_menu == FALSE )
   {
   	strcat (&temp_buff[0],"\n\r\n\rA:Add    E:Edit    D:Delete");
	   if (no_of_pages)	
		   strcat (&temp_buff[0], "    N: Next page");
      strcat (&temp_buff[0],"    ESC to PREV menu");
   	strcat (&temp_buff[0],"\n\r\n\rGo back to \"Proxy Management\" menu to save changes");
	   strcat (&temp_buff[0],"\n\rEnter choice:");
   }
   else
   {
      strcat (&temp_buff[0],"\n\r\n\rA:Add    E:Edit    D:Delete");
      if (no_of_pages)
         strcat ( &temp_buff[0], "    N: Next Page ");
      else
      {
         strcat (&temp_buff[0], "\n\r.............Esc to previous menu\n\r");
         return (&temp_buff[0]);
      }
      strcat (&temp_buff[0],"\n\r\n\rGo back to \"Proxy Management\" menu to save changes");
      strcat (&temp_buff[0], "\n\r\Enter Choice : ");
   }
	return (&temp_buff[0]);
}


BYTE *send_options_for_newuser (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{

	if (!buffer)
	{
		sprintf (temp_buff,	edit_user_parameters,
			ptr_to_rudb.user_name,
			ptr_to_rudb.password,
			get_stats (ptr_to_rudb.call_back_enabled),
			get_stats (ptr_to_rudb.call_back_security),
			ptr_to_rudb.call_back_number,
			ptr_to_rudb.call_back_delay,
			get_protocol_status (ptr_to_rudb.protocol_mask, 1));

		  /* 	get_protocol_status (ptr_to_rudb.protocol_mask, 2),
			get_protocol_status (ptr_to_rudb.protocol_mask, 3));*/
		return (&temp_buff[0]);
	}
	
	client_info_ptr->modify_option_rcvd = atoi (buffer);


	if ((client_info_ptr->modify_option_rcvd >= EDIT_USR_NAME) &&
			(client_info_ptr->modify_option_rcvd <= EDIT_USR_IP))
	{
		client_info_ptr->menustate = TMS_USER_MODI_PARA;
		return (modify_user_parameters (client_info_ptr, NULL));  
	}
	else
	{
		sprintf(temp_buff, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(temp_buff);
	}
}


				
void *delete_udb_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int user_index;
	RAS_USER_DATABASE_RECORD *sptr_user_entry ;

	if (!buffer)
		return (user_number);

	user_index = atoi (buffer);
	user_index-- ; /* Zero base the index */

	sptr_user_entry = udb_get_user_entry_from_index (user_index) ;
   if (sptr_user_entry == NULL)
      return (no_remote_users);

	if (strlen (&sptr_user_entry->user_name[0]) < UDB_USER_NAME_LENGTH)  
		strcpy (del_usr_name, &sptr_user_entry->user_name[0]);

	client_info_ptr->menustate = TMS_CONFIRM_DEL_MENU;
	return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *edit_udb_entry (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	RAS_USER_DATABASE_RECORD *ptr_to_user_entry;
	
	if (!buffer)
		return (user_number);

	user_num = atoi (buffer) - 1;
	
	edit_usr = 1;
	if (user_num < 0 || (user_num >= udb_get_number_of_users()))
		return (InvalidChoice);

	ptr_to_user_entry = udb_get_user_entry_from_index (user_num);
	if (ptr_to_user_entry == NULL)
		return (no_remote_users);
	memcpy (&ptr_to_rudb, ptr_to_user_entry, sizeof (RAS_USER_DATABASE_RECORD));

	client_info_ptr->menustate = TMS_SEND_EDIT_MENU;
	return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *send_edit_menu(TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE user_pass[12];
	int str_len =0;

	str_len = strlen (&ptr_to_rudb.password[0]);
	if (str_len)
	{
		memset (&user_pass[0], (int)'*', str_len);
		user_pass[str_len+1] = 0;
	}
	else
		user_pass[0] = 0;  
	
 	client_info_ptr->echoing = TRUE;

	if (!buffer)
	{
		if (add_usr)
		{
			sprintf(temp_buff, menufsmhdlr[client_info_ptr->menustate].menu,
				ptr_to_rudb.user_name,
				user_pass,
				get_stats (ptr_to_rudb.call_back_enabled),
				get_stats (ptr_to_rudb.call_back_security),
				ptr_to_rudb.call_back_number,
				ptr_to_rudb.call_back_delay,
				get_protocol_status (ptr_to_rudb.protocol_mask, 1));

				/* get_protocol_status (ptr_to_rudb.protocol_mask, 2),
				get_protocol_status (ptr_to_rudb.protocol_mask, 3));*/
		}
		else
		{
			sprintf (temp_buff, menufsmhdlr[client_info_ptr->menustate].menu,
				ptr_to_rudb.user_name,
				user_pass,
				get_stats (ptr_to_rudb.call_back_enabled),
				get_stats (ptr_to_rudb.call_back_security),
				ptr_to_rudb.call_back_number,
				ptr_to_rudb.call_back_delay,
				get_protocol_status (ptr_to_rudb.protocol_mask, 1));

			  /*	get_protocol_status (ptr_to_rudb.protocol_mask, 2),
				get_protocol_status (ptr_to_rudb.protocol_mask, 3));*/
		}
		return (temp_buff);
	}

	client_info_ptr->modify_option_rcvd = atoi (buffer);

	if ((client_info_ptr->modify_option_rcvd >= EDIT_USR_NAME) &&
			(client_info_ptr->modify_option_rcvd <= EDIT_USR_IP))
	{
		client_info_ptr->menustate = TMS_USER_MODI_PARA;
		return (modify_user_parameters (client_info_ptr, NULL));
	}
	else
	{
		sprintf(temp_buff, EnterProperChoice, 
			menufsmhdlr[client_info_ptr->menustate].num_of_items);
		return(temp_buff);
	}
}


BYTE *get_next_udb_page (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int i=0, number=0, no_of_users, no_of_pages=0;
	RAS_USER_DATABASE_RECORD *ptr_to_next_user;
	BYTE index[5];

	temp_buff[0] = 0;	
	no_of_users = udb_get_number_of_users();

	if (!buffer)
	{
		for (i=no_of_remote_users; i<no_of_users; i++) 
		{
			ptr_to_next_user = udb_get_user_entry_from_index (i);
			if (ptr_to_next_user == NULL)
			{
				no_of_remote_users = 0;
				if (!number)
					return (no_more_page);
				break;
			}
			number++;
			if (number > MAX_USERS_PER_PAGE-1)
			{
				no_of_pages = 1;
				break;
			}
			if (strlen (ptr_to_next_user->user_name) >UDB_USER_NAME_LENGTH)
			{
				return (InvalidUserName);
			}

			strcat (&temp_buff[0], "\n\r"); 
			sprintf (&index[0], "%2d. ",i+1);
			strcat (&temp_buff[0], &index[0]);
			strcat (&temp_buff[0], ptr_to_next_user->user_name);

			ptr_to_first_user =ptr_to_next_user;
		}
		no_of_remote_users = i;
		strcat (&temp_buff[0],"\n\r\n\rA:Add    E:Edit    D:Delete");

		if (no_of_pages)	
			strcat (&temp_buff[0], "    N: Next page");

		strcat (&temp_buff[0],"\n\r\n\rGo back to \"Proxy Telnet Server\" menu to save changes");
		strcat (&temp_buff[0],"\n\rEnter choice:");
		return (&temp_buff[0]);
	}

	if ((*buffer == 'A') || (*buffer == 'a'))
	{
		add_usr = 1;
		client_info_ptr->menustate = TMS_SEND_EDIT_MENU;
		set_default_values ();
	}
	else if ((*buffer == 'D') || (*buffer == 'd'))
	{
		if (udb_get_number_of_users() == 0)
			return (no_remote_users);
		client_info_ptr->menustate = TMS_DELETE_USERS;
	}
	else if ((*buffer == 'E') || (*buffer == 'e'))
	{
		add_usr = 0;
		if (udb_get_number_of_users() == 0)
			return (no_remote_users);
		client_info_ptr->menustate = TMS_EDIT_USERS;

	}
	else if ((*buffer == 'N') || (*buffer == 'n'))
	{
/*		if (!no_of_pages)
		{
			no_of_remote_users = 0;
			return (no_more_page);
		}  */
		client_info_ptr->menustate = TMS_NEXT_PAGE;
	}
	else
		return (InvalidChoice);

	return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *modify_user_parameters (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	BYTE *ret_str;	
	int new_value;


	if (!buffer)
	{
		switch (client_info_ptr->modify_option_rcvd)		
		{
			case EDIT_USR_NAME:
				if (edit_usr)
					return (not_changable);
				ret_str = &rem_usr_name[0];
				break;
			
 			case EDIT_USR_PWD:
				verifying_remu_pwd = 1;
				ret_str =  &rem_usr_pwd[0];
				break;

			case EDIT_USR_CB:
				ret_str = &EnaOrDis[0];
				break;

			case EDIT_USR_CBS:
				ret_str = &EnaOrDis[0];
				break;

			case EDIT_CBN:
				ret_str = NewValue;
				break;

			case EDIT_CBD:
				ret_str = NewValue;
				break;

			case EDIT_USR_IP:
				ret_str = &EnaOrDis[0];
				break;

			/* case EDIT_USR_IPX:
				ret_str = &EnaOrDis[0];
				break;

			case EDIT_USR_STP:
				ret_str = &EnaOrDis[0];
				break; */

			default:
				ret_str = &InvalidChoice[0];
				break;
		}
		return (ret_str);
	}

	new_value = atoi (buffer);

	user_modified = 1;
	switch (client_info_ptr->modify_option_rcvd)		
	{
		case EDIT_USR_NAME:
			if (edit_usr)
				return (not_changable);

			if ( strlen (buffer) > UDB_USER_NAME_LENGTH || strlen (buffer) < 1 )
				return (InvalidUserName) ;  

			strcpy (ptr_to_rudb.user_name, buffer);
			break;
		
 		case EDIT_USR_PWD:
			if (strlen (buffer) > UDB_PASSWORD_LENGTH )
			{
				verifying_remu_pwd = 0;
				return (wrong_pass);
			}
			strcpy (store_pwd, buffer);  

			client_info_ptr->menustate = TMS_REMOTE_RETRY ;
/*			return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));  */

			return (retry_remote_password (client_info_ptr, NULL));

		case EDIT_USR_CB:
			if (new_value == 1)
				ptr_to_rudb.call_back_enabled = (BYTE) 1;
			else if (new_value == 2)
				ptr_to_rudb.call_back_enabled = (BYTE) 0;
			else 
				return (InvalidChoice);
			break;

		case EDIT_USR_CBS:
				if (new_value == 1)
					ptr_to_rudb.call_back_security = (BYTE) 1;
				else if (new_value == 2)
					ptr_to_rudb.call_back_security = (BYTE) 0;
				else 
					return (InvalidChoice);

			break;

		case EDIT_CBN:
			if (strlen (buffer) > UDB_CALLBACK_NUMBER_LENGTH)
				return (InvalidChoice);

			strcpy (ptr_to_rudb.call_back_number, buffer);
			break;

		case EDIT_CBD:
			ptr_to_rudb.call_back_delay = new_value;
			break;

		case EDIT_USR_IP:
			if (new_value == 1)
				ptr_to_rudb.protocol_mask =  ptr_to_rudb.protocol_mask | 0x01;
			else if (new_value == 2)
				ptr_to_rudb.protocol_mask =  ptr_to_rudb.protocol_mask & 0xfe;
			else 
				return (InvalidChoice);

			break;

		/* case EDIT_USR_IPX:
			if (new_value == 1)
				ptr_to_rudb.protocol_mask =  ptr_to_rudb.protocol_mask | 0x02;
			else if (new_value == 2)
				ptr_to_rudb.protocol_mask =  ptr_to_rudb.protocol_mask & 0xfd;
			else 
				return (InvalidChoice);
			break;

		case EDIT_USR_STP:
			if (new_value == 1)
				ptr_to_rudb.protocol_mask =  ptr_to_rudb.protocol_mask | 0x04;
			else if (new_value == 2)
				ptr_to_rudb.protocol_mask =  ptr_to_rudb.protocol_mask & 0xfb;
			else 
				return (InvalidChoice);
			break;*/

		default:
			ret_str = &InvalidChoice[0];
	 		break;
	}
	client_info_ptr->menustate = TMS_SEND_EDIT_MENU;
	return (menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL));
}


BYTE *save_remote_udb_changes (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int ret_val;

	if (!buffer)
	{
		if (add_usr && user_modified)
			return (AddUser) ;
		else if (edit_usr && user_modified)  
			return (SaveSetup);
		else 
			goto Error;
	}

	if ((*buffer == 'Y') || (*buffer == 'y'))
	{
		if (add_usr)
		{
			if (strlen (&ptr_to_rudb.user_name[0]) == 0)
				return (InvalidUserName);

			to_upper_string (&ptr_to_rudb.user_name[0]) ;
			ret_val = udb_insert (&ptr_to_rudb) ;
			if (ret_val == INSERT_USER_ALREADY_EXISTS)
 				return (dupuser);
			else if (ret_val == INSERT_MAX_COUNT_EXCEEDED)
			{
				sprintf (telnet.tx_buffer, max_user, UDB_MAX_USERS);
				return (telnet.tx_buffer);
			}
			else if (ret_val == INSERT_NO_MEMORY)
				return (NotSaved);
			else if (ret_val == INSERT_SUCCESSFUL)
				goto Error;
			else if (ret_val == UDB_HANDLER_NOT_INITED)
				return (Not_Inited);
		}
		else
		{
			edit_usr = 0;
			to_upper_string (&ptr_to_rudb.user_name[0]) ;
			ret_val = udb_edit (&ptr_to_rudb);
			if (ret_val == EDIT_RECORD_NOT_FOUND)
 				return (no_remote_users);
			else if (ret_val == EDIT_NO_MEMORY)
				return (Insufficient_memory);
			else if (ret_val == EDIT_SUCCESSFUL)
				goto Error;
			else if (ret_val == UDB_HANDLER_NOT_INITED)
				return (Not_Inited);
 
		}
	}
	if ( (*buffer == 'N') || (*buffer == 'n'))
	{
		edit_usr = 0;
      user_modified = 0;
		goto Error;   /* here add the add function */	
	}
	else 
	{	
		add_usr = 0;
      user_modified = 0;
		edit_usr = 0;
		return (InvalidChoice);
	}

Error:
	add_usr = 0;
	edit_usr = 0;
	client_info_ptr->menustate = TMS_REMOTE_UDB;
	return(menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)) ;
}

BYTE *save_changes_permanent (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	enum UDB_MODIFY ret_val;	

	if (!buffer)
	{
		if (user_modified)
		{
			user_modified = 0;
			return (SaveSetupperm);
		}
		else
			goto Error;
	}

	if ((*buffer == 'Y') || (*buffer == 'y'))
	{
		ret_val = udb_update_after_changes();
		if (udb_deinit_flag)
		{
			udb_deinitialize();
			udb_deinit_flag = 0;
		}
		if (ret_val != UPDATE_SUCCESSFUL)
			return (NotSaved);
	}
	else if ((*buffer == 'N') || (*buffer == 'n'))
	{
		if (udb_deinit_flag)
		{
			udb_deinitialize();
			udb_deinit_flag = 0;
		}
	}
	else
		return (InvalidChoice);

Error:
	client_info_ptr->menustate = TMS_SUPERMENU;
	return(menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)) ;
}

BYTE *retry_remote_password (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{

	if (!buffer)
		return (retry_pass);

	if (!verifying_remu_pwd)
		store_pwd[0] = 0;
	
	verifying_remu_pwd = 0;

	if (strcmp (buffer, store_pwd))
	{
		client_info_ptr->echoing = FALSE;
		return (wrong_pass);
	}
	else
		strcpy (ptr_to_rudb.password, buffer);

	client_info_ptr->menustate = TMS_SEND_EDIT_MENU;
	return(menufsmhdlr[client_info_ptr->menustate].menuhdlr (client_info_ptr, NULL)); 
}

BYTE *confirm_delete (TELNET_CLIENT_CLASS *client_info_ptr, BYTE *buffer)
{
	int ret_val;
	
	if (!buffer)
		return (confirm_del);

	
	if ((*buffer == 'Y') || (*buffer == 'y'))
	{
		user_modified = 1;
		ret_val = udb_delete (del_usr_name);
		if (ret_val == DELETE_USER_NOT_FOUND)
			return (no_remote_users);
		else if (ret_val == UDB_HANDLER_NOT_INITED)
			return (Not_Inited);

	}
	else if ((*buffer == 'N') || (*buffer == 'n'))
		goto Error;
	else
		return (InvalidChoice);

Error:
	
	 client_info_ptr->menustate = TMS_REMOTE_UDB;
    return(menufsmhdlr[client_info_ptr->menustate].menuhdlr(client_info_ptr, NULL)) ;
}

